/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.liburing.IOURingBuf$Buffer;

public class IOURingBuf
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ADDR;
    public static final int LEN;
    public static final int BID;
    public static final int RESV;

    protected IOURingBuf(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected IOURingBuf create(long l2, ByteBuffer byteBuffer) {
        return new IOURingBuf(l2, byteBuffer);
    }

    public IOURingBuf(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), IOURingBuf.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long addr() {
        return IOURingBuf.naddr(this.address());
    }

    public int len() {
        return IOURingBuf.nlen(this.address());
    }

    public short bid() {
        return IOURingBuf.nbid(this.address());
    }

    public short resv() {
        return IOURingBuf.nresv(this.address());
    }

    public IOURingBuf addr(long l2) {
        IOURingBuf.naddr(this.address(), l2);
        return this;
    }

    public IOURingBuf len(int n2) {
        IOURingBuf.nlen(this.address(), n2);
        return this;
    }

    public IOURingBuf bid(short s2) {
        IOURingBuf.nbid(this.address(), s2);
        return this;
    }

    public IOURingBuf resv(short s2) {
        IOURingBuf.nresv(this.address(), s2);
        return this;
    }

    public IOURingBuf set(long l2, int n2, short s2, short s3) {
        this.addr(l2);
        this.len(n2);
        this.bid(s2);
        this.resv(s3);
        return this;
    }

    public IOURingBuf set(IOURingBuf iOURingBuf) {
        MemoryUtil.memCopy(iOURingBuf.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOURingBuf malloc() {
        return new IOURingBuf(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static IOURingBuf calloc() {
        return new IOURingBuf(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static IOURingBuf create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new IOURingBuf(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static IOURingBuf create(long l2) {
        return new IOURingBuf(l2, null);
    }

    public static IOURingBuf createSafe(long l2) {
        return l2 == 0L ? null : new IOURingBuf(l2, null);
    }

    public static IOURingBuf$Buffer malloc(int n2) {
        return new IOURingBuf$Buffer(MemoryUtil.nmemAllocChecked(IOURingBuf.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static IOURingBuf$Buffer calloc(int n2) {
        return new IOURingBuf$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static IOURingBuf$Buffer create(int n2) {
        ByteBuffer byteBuffer = IOURingBuf.__create(n2, SIZEOF);
        return new IOURingBuf$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n2, n2);
    }

    public static IOURingBuf$Buffer create(long l2, int n2) {
        return new IOURingBuf$Buffer(l2, n2);
    }

    public static IOURingBuf$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : new IOURingBuf$Buffer(l2, n2);
    }

    public static IOURingBuf malloc(MemoryStack memoryStack) {
        return new IOURingBuf(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static IOURingBuf calloc(MemoryStack memoryStack) {
        return new IOURingBuf(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static IOURingBuf$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new IOURingBuf$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static IOURingBuf$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new IOURingBuf$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static long naddr(long l2) {
        return UNSAFE.getLong(null, l2 + (long)ADDR);
    }

    public static int nlen(long l2) {
        return UNSAFE.getInt(null, l2 + (long)LEN);
    }

    public static short nbid(long l2) {
        return UNSAFE.getShort(null, l2 + (long)BID);
    }

    public static short nresv(long l2) {
        return UNSAFE.getShort(null, l2 + (long)RESV);
    }

    public static void naddr(long l2, long l3) {
        UNSAFE.putLong(null, l2 + (long)ADDR, l3);
    }

    public static void nlen(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)LEN, n2);
    }

    public static void nbid(long l2, short s2) {
        UNSAFE.putShort(null, l2 + (long)BID, s2);
    }

    public static void nresv(long l2, short s2) {
        UNSAFE.putShort(null, l2 + (long)RESV, s2);
    }

    static {
        Struct$Layout struct$Layout = IOURingBuf.__struct(IOURingBuf.__member(8), IOURingBuf.__member(4), IOURingBuf.__member(2), IOURingBuf.__member(2));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        ADDR = struct$Layout.offsetof(0);
        LEN = struct$Layout.offsetof(1);
        BID = struct$Layout.offsetof(2);
        RESV = struct$Layout.offsetof(3);
    }
}

