/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.windows.CRYPTPROTECT_PROMPTSTRUCT;
import org.lwjgl.system.windows.Crypt32$Functions;
import org.lwjgl.system.windows.DATA_BLOB;

public class Crypt32 {
    private static final SharedLibrary CRYPT32 = Library.loadNative(Crypt32.class, "org.lwjgl", "crypt32");
    public static final int CRYPTPROTECT_UI_FORBIDDEN = 1;
    public static final int CRYPTPROTECT_LOCAL_MACHINE = 4;
    public static final int CRYPTPROTECT_AUDIT = 16;
    public static final int CRYPTPROTECT_VERIFY_PROTECTION = 64;
    public static final int CRYPTPROTECTMEMORY_SAME_PROCESS = 0;
    public static final int CRYPTPROTECTMEMORY_CROSS_PROCESS = 1;
    public static final int CRYPTPROTECTMEMORY_SAME_LOGON = 2;
    public static final int CRYPTPROTECT_PROMPT_ON_UNPROTECT = 1;
    public static final int CRYPTPROTECT_PROMPT_ON_PROTECT = 2;
    public static final int CRYPTPROTECTMEMORY_BLOCK_SIZE = 16;

    public static SharedLibrary getLibrary() {
        return CRYPT32;
    }

    protected Crypt32() {
        throw new UnsupportedOperationException();
    }

    public static native int nCryptProtectData(long var0, long var2, long var4, long var6, long var8, int var10, long var11, long var13);

    public static int nCryptProtectData(long l2, long l3, long l4, long l5, long l6, int n2, long l7) {
        long l8 = Crypt32$Functions.CryptProtectData;
        return Crypt32.nCryptProtectData(l2, l3, l4, l5, l6, n2, l7, l8);
    }

    public static boolean CryptProtectData(DATA_BLOB dATA_BLOB, ByteBuffer byteBuffer, DATA_BLOB dATA_BLOB2, long l2, CRYPTPROTECT_PROMPTSTRUCT cRYPTPROTECT_PROMPTSTRUCT, int n2, DATA_BLOB dATA_BLOB3) {
        if (Checks.CHECKS) {
            Checks.checkNT2Safe(byteBuffer);
        }
        return Crypt32.nCryptProtectData(dATA_BLOB.address(), MemoryUtil.memAddressSafe(byteBuffer), MemoryUtil.memAddressSafe(dATA_BLOB2), l2, MemoryUtil.memAddressSafe(cRYPTPROTECT_PROMPTSTRUCT), n2, dATA_BLOB3.address()) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean CryptProtectData(DATA_BLOB dATA_BLOB, CharSequence charSequence, DATA_BLOB dATA_BLOB2, long l2, CRYPTPROTECT_PROMPTSTRUCT cRYPTPROTECT_PROMPTSTRUCT, int n2, DATA_BLOB dATA_BLOB3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            memoryStack.nUTF16Safe(charSequence, true);
            long l3 = charSequence == null ? 0L : memoryStack.getPointerAddress();
            boolean bl2 = Crypt32.nCryptProtectData(dATA_BLOB.address(), l3, MemoryUtil.memAddressSafe(dATA_BLOB2), l2, MemoryUtil.memAddressSafe(cRYPTPROTECT_PROMPTSTRUCT), n2, dATA_BLOB3.address()) != 0;
            return bl2;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native int nCryptProtectMemory(long var0, int var2, int var3, long var4);

    public static int nCryptProtectMemory(long l2, int n2, int n3) {
        long l3 = Crypt32$Functions.CryptProtectMemory;
        if (Checks.CHECKS) {
            Checks.check(l3);
        }
        return Crypt32.nCryptProtectMemory(l2, n2, n3, l3);
    }

    public static boolean CryptProtectMemory(ByteBuffer byteBuffer, int n2) {
        return Crypt32.nCryptProtectMemory(MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining(), n2) != 0;
    }

    public static native int nCryptUnprotectData(long var0, long var2, long var4, long var6, long var8, int var10, long var11, long var13);

    public static int nCryptUnprotectData(long l2, long l3, long l4, long l5, long l6, int n2, long l7) {
        long l8 = Crypt32$Functions.CryptUnprotectData;
        return Crypt32.nCryptUnprotectData(l2, l3, l4, l5, l6, n2, l7, l8);
    }

    public static boolean CryptUnprotectData(DATA_BLOB dATA_BLOB, PointerBuffer pointerBuffer, DATA_BLOB dATA_BLOB2, long l2, CRYPTPROTECT_PROMPTSTRUCT cRYPTPROTECT_PROMPTSTRUCT, int n2, DATA_BLOB dATA_BLOB3) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)pointerBuffer, 1);
        }
        return Crypt32.nCryptUnprotectData(dATA_BLOB.address(), MemoryUtil.memAddressSafe(pointerBuffer), MemoryUtil.memAddressSafe(dATA_BLOB2), l2, MemoryUtil.memAddressSafe(cRYPTPROTECT_PROMPTSTRUCT), n2, dATA_BLOB3.address()) != 0;
    }

    public static native int nCryptUnprotectMemory(long var0, int var2, int var3, long var4);

    public static int nCryptUnprotectMemory(long l2, int n2, int n3) {
        long l3 = Crypt32$Functions.CryptUnprotectMemory;
        if (Checks.CHECKS) {
            Checks.check(l3);
        }
        return Crypt32.nCryptUnprotectMemory(l2, n2, n3, l3);
    }

    public static boolean CryptUnprotectMemory(ByteBuffer byteBuffer, int n2) {
        return Crypt32.nCryptUnprotectMemory(MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining(), n2) != 0;
    }

    static /* synthetic */ SharedLibrary access$000() {
        return CRYPT32;
    }
}

