/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.windows.WNDCLASSEX$Buffer;
import org.lwjgl.system.windows.WindowProc;
import org.lwjgl.system.windows.WindowProcI;

public class WNDCLASSEX
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CBSIZE;
    public static final int STYLE;
    public static final int LPFNWNDPROC;
    public static final int CBCLSEXTRA;
    public static final int CBWNDEXTRA;
    public static final int HINSTANCE;
    public static final int HICON;
    public static final int HCURSOR;
    public static final int HBRBACKGROUND;
    public static final int LPSZMENUNAME;
    public static final int LPSZCLASSNAME;
    public static final int HICONSM;

    protected WNDCLASSEX(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected WNDCLASSEX create(long l2, ByteBuffer byteBuffer) {
        return new WNDCLASSEX(l2, byteBuffer);
    }

    public WNDCLASSEX(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), WNDCLASSEX.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int cbSize() {
        return WNDCLASSEX.ncbSize(this.address());
    }

    public int style() {
        return WNDCLASSEX.nstyle(this.address());
    }

    public WindowProc lpfnWndProc() {
        return WNDCLASSEX.nlpfnWndProc(this.address());
    }

    public int cbClsExtra() {
        return WNDCLASSEX.ncbClsExtra(this.address());
    }

    public int cbWndExtra() {
        return WNDCLASSEX.ncbWndExtra(this.address());
    }

    public long hInstance() {
        return WNDCLASSEX.nhInstance(this.address());
    }

    public long hIcon() {
        return WNDCLASSEX.nhIcon(this.address());
    }

    public long hCursor() {
        return WNDCLASSEX.nhCursor(this.address());
    }

    public long hbrBackground() {
        return WNDCLASSEX.nhbrBackground(this.address());
    }

    public ByteBuffer lpszMenuName() {
        return WNDCLASSEX.nlpszMenuName(this.address());
    }

    public String lpszMenuNameString() {
        return WNDCLASSEX.nlpszMenuNameString(this.address());
    }

    public ByteBuffer lpszClassName() {
        return WNDCLASSEX.nlpszClassName(this.address());
    }

    public String lpszClassNameString() {
        return WNDCLASSEX.nlpszClassNameString(this.address());
    }

    public long hIconSm() {
        return WNDCLASSEX.nhIconSm(this.address());
    }

    public WNDCLASSEX cbSize(int n2) {
        WNDCLASSEX.ncbSize(this.address(), n2);
        return this;
    }

    public WNDCLASSEX style(int n2) {
        WNDCLASSEX.nstyle(this.address(), n2);
        return this;
    }

    public WNDCLASSEX lpfnWndProc(WindowProcI windowProcI) {
        WNDCLASSEX.nlpfnWndProc(this.address(), windowProcI);
        return this;
    }

    public WNDCLASSEX cbClsExtra(int n2) {
        WNDCLASSEX.ncbClsExtra(this.address(), n2);
        return this;
    }

    public WNDCLASSEX cbWndExtra(int n2) {
        WNDCLASSEX.ncbWndExtra(this.address(), n2);
        return this;
    }

    public WNDCLASSEX hInstance(long l2) {
        WNDCLASSEX.nhInstance(this.address(), l2);
        return this;
    }

    public WNDCLASSEX hIcon(long l2) {
        WNDCLASSEX.nhIcon(this.address(), l2);
        return this;
    }

    public WNDCLASSEX hCursor(long l2) {
        WNDCLASSEX.nhCursor(this.address(), l2);
        return this;
    }

    public WNDCLASSEX hbrBackground(long l2) {
        WNDCLASSEX.nhbrBackground(this.address(), l2);
        return this;
    }

    public WNDCLASSEX lpszMenuName(ByteBuffer byteBuffer) {
        WNDCLASSEX.nlpszMenuName(this.address(), byteBuffer);
        return this;
    }

    public WNDCLASSEX lpszClassName(ByteBuffer byteBuffer) {
        WNDCLASSEX.nlpszClassName(this.address(), byteBuffer);
        return this;
    }

    public WNDCLASSEX hIconSm(long l2) {
        WNDCLASSEX.nhIconSm(this.address(), l2);
        return this;
    }

    public WNDCLASSEX set(int n2, int n3, WindowProcI windowProcI, int n4, int n5, long l2, long l3, long l4, long l5, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, long l6) {
        this.cbSize(n2);
        this.style(n3);
        this.lpfnWndProc(windowProcI);
        this.cbClsExtra(n4);
        this.cbWndExtra(n5);
        this.hInstance(l2);
        this.hIcon(l3);
        this.hCursor(l4);
        this.hbrBackground(l5);
        this.lpszMenuName(byteBuffer);
        this.lpszClassName(byteBuffer2);
        this.hIconSm(l6);
        return this;
    }

    public WNDCLASSEX set(WNDCLASSEX wNDCLASSEX) {
        MemoryUtil.memCopy(wNDCLASSEX.address(), this.address(), SIZEOF);
        return this;
    }

    public static WNDCLASSEX malloc() {
        return new WNDCLASSEX(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static WNDCLASSEX calloc() {
        return new WNDCLASSEX(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static WNDCLASSEX create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new WNDCLASSEX(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static WNDCLASSEX create(long l2) {
        return new WNDCLASSEX(l2, null);
    }

    public static WNDCLASSEX createSafe(long l2) {
        return l2 == 0L ? null : new WNDCLASSEX(l2, null);
    }

    public static WNDCLASSEX$Buffer malloc(int n2) {
        return new WNDCLASSEX$Buffer(MemoryUtil.nmemAllocChecked(WNDCLASSEX.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static WNDCLASSEX$Buffer calloc(int n2) {
        return new WNDCLASSEX$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static WNDCLASSEX$Buffer create(int n2) {
        ByteBuffer byteBuffer = WNDCLASSEX.__create(n2, SIZEOF);
        return new WNDCLASSEX$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n2, n2);
    }

    public static WNDCLASSEX$Buffer create(long l2, int n2) {
        return new WNDCLASSEX$Buffer(l2, n2);
    }

    public static WNDCLASSEX$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : new WNDCLASSEX$Buffer(l2, n2);
    }

    public static WNDCLASSEX mallocStack() {
        return WNDCLASSEX.malloc(MemoryStack.stackGet());
    }

    public static WNDCLASSEX callocStack() {
        return WNDCLASSEX.calloc(MemoryStack.stackGet());
    }

    public static WNDCLASSEX mallocStack(MemoryStack memoryStack) {
        return WNDCLASSEX.malloc(memoryStack);
    }

    public static WNDCLASSEX callocStack(MemoryStack memoryStack) {
        return WNDCLASSEX.calloc(memoryStack);
    }

    public static WNDCLASSEX$Buffer mallocStack(int n2) {
        return WNDCLASSEX.malloc(n2, MemoryStack.stackGet());
    }

    public static WNDCLASSEX$Buffer callocStack(int n2) {
        return WNDCLASSEX.calloc(n2, MemoryStack.stackGet());
    }

    public static WNDCLASSEX$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return WNDCLASSEX.malloc(n2, memoryStack);
    }

    public static WNDCLASSEX$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return WNDCLASSEX.calloc(n2, memoryStack);
    }

    public static WNDCLASSEX malloc(MemoryStack memoryStack) {
        return new WNDCLASSEX(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static WNDCLASSEX calloc(MemoryStack memoryStack) {
        return new WNDCLASSEX(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static WNDCLASSEX$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new WNDCLASSEX$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static WNDCLASSEX$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new WNDCLASSEX$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int ncbSize(long l2) {
        return UNSAFE.getInt(null, l2 + (long)CBSIZE);
    }

    public static int nstyle(long l2) {
        return UNSAFE.getInt(null, l2 + (long)STYLE);
    }

    public static WindowProc nlpfnWndProc(long l2) {
        return WindowProc.create(MemoryUtil.memGetAddress(l2 + (long)LPFNWNDPROC));
    }

    public static int ncbClsExtra(long l2) {
        return UNSAFE.getInt(null, l2 + (long)CBCLSEXTRA);
    }

    public static int ncbWndExtra(long l2) {
        return UNSAFE.getInt(null, l2 + (long)CBWNDEXTRA);
    }

    public static long nhInstance(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)HINSTANCE);
    }

    public static long nhIcon(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)HICON);
    }

    public static long nhCursor(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)HCURSOR);
    }

    public static long nhbrBackground(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)HBRBACKGROUND);
    }

    public static ByteBuffer nlpszMenuName(long l2) {
        return MemoryUtil.memByteBufferNT2Safe(MemoryUtil.memGetAddress(l2 + (long)LPSZMENUNAME));
    }

    public static String nlpszMenuNameString(long l2) {
        return MemoryUtil.memUTF16Safe(MemoryUtil.memGetAddress(l2 + (long)LPSZMENUNAME));
    }

    public static ByteBuffer nlpszClassName(long l2) {
        return MemoryUtil.memByteBufferNT2(MemoryUtil.memGetAddress(l2 + (long)LPSZCLASSNAME));
    }

    public static String nlpszClassNameString(long l2) {
        return MemoryUtil.memUTF16(MemoryUtil.memGetAddress(l2 + (long)LPSZCLASSNAME));
    }

    public static long nhIconSm(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)HICONSM);
    }

    public static void ncbSize(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)CBSIZE, n2);
    }

    public static void nstyle(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)STYLE, n2);
    }

    public static void nlpfnWndProc(long l2, WindowProcI windowProcI) {
        MemoryUtil.memPutAddress(l2 + (long)LPFNWNDPROC, windowProcI.address());
    }

    public static void ncbClsExtra(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)CBCLSEXTRA, n2);
    }

    public static void ncbWndExtra(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)CBWNDEXTRA, n2);
    }

    public static void nhInstance(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)HINSTANCE, l3);
    }

    public static void nhIcon(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)HICON, l3);
    }

    public static void nhCursor(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)HCURSOR, l3);
    }

    public static void nhbrBackground(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)HBRBACKGROUND, l3);
    }

    public static void nlpszMenuName(long l2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT2Safe(byteBuffer);
        }
        MemoryUtil.memPutAddress(l2 + (long)LPSZMENUNAME, MemoryUtil.memAddressSafe(byteBuffer));
    }

    public static void nlpszClassName(long l2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT2(byteBuffer);
        }
        MemoryUtil.memPutAddress(l2 + (long)LPSZCLASSNAME, MemoryUtil.memAddress(byteBuffer));
    }

    public static void nhIconSm(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)HICONSM, l3);
    }

    public static void validate(long l2) {
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)LPFNWNDPROC));
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)LPSZCLASSNAME));
    }

    static {
        Struct$Layout struct$Layout = WNDCLASSEX.__struct(WNDCLASSEX.__member(4), WNDCLASSEX.__member(4), WNDCLASSEX.__member(POINTER_SIZE), WNDCLASSEX.__member(4), WNDCLASSEX.__member(4), WNDCLASSEX.__member(POINTER_SIZE), WNDCLASSEX.__member(POINTER_SIZE), WNDCLASSEX.__member(POINTER_SIZE), WNDCLASSEX.__member(POINTER_SIZE), WNDCLASSEX.__member(POINTER_SIZE), WNDCLASSEX.__member(POINTER_SIZE), WNDCLASSEX.__member(POINTER_SIZE));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        CBSIZE = struct$Layout.offsetof(0);
        STYLE = struct$Layout.offsetof(1);
        LPFNWNDPROC = struct$Layout.offsetof(2);
        CBCLSEXTRA = struct$Layout.offsetof(3);
        CBWNDEXTRA = struct$Layout.offsetof(4);
        HINSTANCE = struct$Layout.offsetof(5);
        HICON = struct$Layout.offsetof(6);
        HCURSOR = struct$Layout.offsetof(7);
        HBRBACKGROUND = struct$Layout.offsetof(8);
        LPSZMENUNAME = struct$Layout.offsetof(9);
        LPSZCLASSNAME = struct$Layout.offsetof(10);
        HICONSM = struct$Layout.offsetof(11);
    }
}

