/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.net.BasicHttpResponse;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.HttpResponse;
import com.sun.deploy.net.MessageHeader;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.URLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class HttpUtils {
    private static final String CONNECTION_HEADER = "Connection";
    public static final String LOCATION_HEADER = "Location";
    private static final String CONNECTION_KEEP_ALIVE = "Keep-Alive";
    private static final String PROTOCOL_VERSION_1_1 = "HTTP/1.1";
    private static final HashSet isNotCacheable = new HashSet();

    public static HttpURLConnection followRedirects(URLConnection uRLConnection) throws IOException {
        boolean bl;
        int n = 0;
        InputStream inputStream = null;
        do {
            HttpURLConnection httpURLConnection;
            int n2;
            if (uRLConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)uRLConnection).setInstanceFollowRedirects(false);
            }
            inputStream = uRLConnection.getInputStream();
            bl = false;
            if (!(uRLConnection instanceof HttpURLConnection) || !HttpUtils.isRedirect(n2 = (httpURLConnection = (HttpURLConnection)uRLConnection).getResponseCode())) continue;
            URL uRL = httpURLConnection.getURL();
            String string = httpURLConnection.getHeaderField(LOCATION_HEADER);
            URL uRL2 = null;
            if (string != null) {
                uRL2 = new URL(uRL, string);
            }
            if (uRL != null && !URLUtil.sameURLs(uRL, uRL2)) {
                DownloadEngine.createRedirectURLEntry(uRL.toString(), uRL2);
            }
            HttpUtils.cleanupConnection(httpURLConnection);
            if (uRL2 == null || !uRL.getProtocol().equals(uRL2.getProtocol()) || n >= 5) {
                throw new SecurityException("illegal URL redirect");
            }
            bl = true;
            uRLConnection = uRL2.openConnection();
            ++n;
        } while (bl);
        if (!(uRLConnection instanceof HttpURLConnection)) {
            throw new IOException(uRLConnection.getURL() + " redirected to non-http URL");
        }
        return (HttpURLConnection)uRLConnection;
    }

    public static URL removeQueryStringFromURL(URL uRL) {
        String string;
        int n;
        URL uRL2 = uRL;
        if (uRL2 != null && (n = (string = uRL2.toString()).lastIndexOf(63)) != -1) {
            try {
                uRL2 = new URL(string.substring(0, n));
            }
            catch (MalformedURLException malformedURLException) {
                Trace.ignoredException(malformedURLException);
            }
        }
        return uRL2;
    }

    public static URL removeVersionQueriesFromURL(URL uRL) {
        String string;
        int n;
        if (uRL != null && (n = (string = uRL.toString()).lastIndexOf(63)) > -1) {
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, n + 1));
            String[] stringArray = string.substring(n + 1).split("&");
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String[] stringArray2 = string2.split("=");
                if (stringArray2.length > 0 && ("version-id".equals(stringArray2[0]) || "current-version-id".equals(stringArray2[0]))) continue;
                if (bl) {
                    stringBuffer.append('&');
                } else {
                    bl = true;
                }
                stringBuffer.append(string2);
            }
            try {
                return new URL(stringBuffer.toString());
            }
            catch (MalformedURLException malformedURLException) {
                Trace.ignoredException(malformedURLException);
            }
        }
        return uRL;
    }

    public static boolean sameURLsIgnoreVersionQueries(URL uRL, URL uRL2) {
        uRL = HttpUtils.removeVersionQueriesFromURL(uRL);
        uRL2 = HttpUtils.removeVersionQueriesFromURL(uRL2);
        return URLUtil.sameURLs(uRL, uRL2);
    }

    public static void cleanupConnection(URLConnection uRLConnection) {
        if (uRLConnection == null || !(uRLConnection instanceof HttpURLConnection)) {
            return;
        }
        try {
            InputStream inputStream;
            int n;
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            String string = httpURLConnection.getHeaderField(null);
            String string2 = httpURLConnection.getHeaderField(CONNECTION_HEADER);
            if ((string2 != null && string2.equalsIgnoreCase(CONNECTION_KEEP_ALIVE) || string != null && string.startsWith(PROTOCOL_VERSION_1_1) && string2 == null) && (n = httpURLConnection.getResponseCode()) < 400 && (inputStream = httpURLConnection.getInputStream()) != null) {
                byte[] byArray = new byte[8192];
                while (inputStream.read(byArray) > 0) {
                }
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean isRedirect(int n) {
        return n >= 300 && n <= 305 && n != 304;
    }

    public static URL getFinalRedirectedURL(HttpResponse httpResponse) {
        if (httpResponse instanceof BasicHttpResponse) {
            return ((BasicHttpResponse)httpResponse).getFinalURL();
        }
        return null;
    }

    static boolean hasContentEncoding(Map map, String string) {
        string = string.toLowerCase(Locale.US);
        Set set = HttpUtils.getEncodingTokens(map, false);
        return set.contains(string);
    }

    public static boolean matchEncoding(String string, Map map, Map map2) {
        string = string == null ? null : string.toLowerCase(Locale.US);
        Set set = HttpUtils.getEncodingTokens(map, true);
        Set set2 = HttpUtils.getEncodingTokens(map2, false);
        if (string != null && !set.contains(string)) {
            return true;
        }
        if (string != null) {
            return set2.contains(string);
        }
        for (String string2 : set) {
            if (!"*".equals(string2) && !set2.contains(string2)) continue;
            return true;
        }
        return false;
    }

    private static Set getEncodingTokens(Map map, boolean bl) {
        List list = (List)map.get(bl ? "accept-encoding" : "content-encoding");
        HashSet<String> hashSet = new HashSet<String>();
        if (list != null) {
            for (String string : list) {
                String[] stringArray = string.split(",");
                for (int i = 0; i < stringArray.length; ++i) {
                    hashSet.add(stringArray[i].trim().toLowerCase(Locale.US));
                }
            }
        }
        return hashSet;
    }

    public static boolean hasGzipOrPack200Encoding(URLConnection uRLConnection) {
        String string = uRLConnection.getRequestProperty("accept-encoding");
        if (string != null) {
            string = string.toLowerCase(Locale.US);
        }
        return string != null && (string.indexOf("gzip") > -1 || string.indexOf("pack200-gzip") > -1);
    }

    public static boolean refusesIdentityEncodings(Map map) {
        Set set = HttpUtils.getEncodingTokens(map, true);
        return set.contains("identity;q=0") || set.contains("*;q=0") && !set.contains("identity");
    }

    public static boolean refusesIdentityEncodings(URLConnection uRLConnection) {
        String string = uRLConnection.getRequestProperty("accept-encoding");
        if (string == null) {
            return false;
        }
        return string.indexOf("identity;q=0") > -1 || string.indexOf("*;q=0") > -1 && string.indexOf("identity") == -1;
    }

    public static boolean hasGzipOrPack200Encoding(Map map) {
        return HttpUtils.hasContentEncoding(map, "gzip") || HttpUtils.hasContentEncoding(map, "pack200-gzip");
    }

    public static boolean hasGzipEncoding(String string) {
        return string != null && string.toLowerCase(Locale.US).indexOf("gzip") > -1;
    }

    static String removeGzipEncoding(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split(",");
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].trim().toLowerCase(Locale.US).equals("gzip")) continue;
            if (bl) {
                stringBuffer.append(", ");
            } else {
                bl = true;
            }
            stringBuffer.append(stringArray[i].trim());
        }
        return stringBuffer.length() > 0 ? stringBuffer.toString() : null;
    }

    public static long getEffectiveExpiration(long l, MessageHeader messageHeader) {
        Map map = messageHeader.getHeaders();
        Object v = map.get("cache-control");
        Long l2 = null;
        if (v instanceof List) {
            List list = (List)v;
            block2: for (int i = 0; i < list.size(); ++i) {
                String[] stringArray;
                if (!(list.get(i) instanceof String)) continue;
                for (String string : stringArray = ((String)list.get(i)).split(",")) {
                    String[] stringArray2 = string.split("=");
                    if (stringArray2 == null || stringArray2.length != 2) continue;
                    String string2 = stringArray2[0].trim();
                    String string3 = stringArray2[1].trim();
                    if (!"max-age".equalsIgnoreCase(string2)) continue;
                    try {
                        l2 = Long.valueOf(string3);
                        continue block2;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (l2 != null) {
            return System.currentTimeMillis() + l2 * 1000L;
        }
        return l;
    }

    public static long getEffectiveExpiration(HttpResponse httpResponse) {
        return HttpUtils.getEffectiveExpiration(httpResponse.getExpiration(), httpResponse.getHeaders());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isResourceCacheable(String string, MessageHeader messageHeader, boolean bl) {
        Collection collection;
        if (!Cache.isCacheEnabled()) {
            return false;
        }
        Map map = messageHeader.getHeaders();
        if (map.get("content-range") != null) {
            return false;
        }
        Object v = map.get("cache-control");
        if (v instanceof List) {
            collection = (List)v;
            for (int i = 0; i < collection.size(); ++i) {
                String string2;
                if (!(collection.get(i) instanceof String) || (string2 = (String)collection.get(i)).toLowerCase(Locale.US).indexOf("no-store") <= -1) continue;
                return false;
            }
        }
        if (bl && !HttpUtils.hasValueFor(map, "last-modified") && !HttpUtils.hasValueFor(map, "expires") && v == null) {
            collection = isNotCacheable;
            synchronized (collection) {
                isNotCacheable.add(string);
                Trace.println(string + " is not cacheable.", TraceLevel.CACHE);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean resourceNotCached(String string) {
        HashSet hashSet = isNotCacheable;
        synchronized (hashSet) {
            return isNotCacheable.contains(string);
        }
    }

    private static boolean hasValueFor(Map map, String string) {
        List list;
        Object v = map.get(string);
        return v instanceof List ? (list = (List)v).size() > 0 : v instanceof String;
    }

    private static boolean hasMimeType(Map map, String string) {
        Object v = map.get("content-type");
        if (!(v instanceof List)) {
            return false;
        }
        List list = (List)v;
        return list.contains(string);
    }

    private static boolean hasRequestType(Map map, String string) {
        Object v = map.get("deploy-request-content-type");
        if (!(v instanceof List)) {
            return false;
        }
        List list = (List)v;
        return list.contains(string);
    }

    public static boolean isJarFile(String string, Map map) {
        String string2 = string;
        if (HttpUtils.hasRequestType(map, "application/x-java-archive")) {
            return true;
        }
        int n = string2.indexOf(";");
        if (n != -1) {
            string2 = string2.substring(0, n);
        }
        if ((n = string2.indexOf("?")) != -1) {
            string2 = string2.substring(0, n);
        }
        return string2.toLowerCase().endsWith(".jar") || string2.toLowerCase().endsWith(".jarjar") || HttpUtils.hasMimeType(map, "application/x-java-archive") || HttpUtils.hasMimeType(map, "application/java-archive") || HttpUtils.hasMimeType(map, "application/x-java-archive-diff");
    }

    public static boolean isJNLPFile(String string, MessageHeader messageHeader) {
        Map map = messageHeader == null ? Collections.EMPTY_MAP : messageHeader.getHeaders();
        return HttpUtils.isJNLPFile(string, map);
    }

    public static boolean isJNLPFile(String string, Map map) {
        if (HttpUtils.hasRequestType(map, "application/x-java-jnlp-file") || HttpUtils.hasMimeType(map, "application/x-java-jnlp-file")) {
            return true;
        }
        String string2 = string;
        int n = string2.indexOf(";");
        if (n != -1) {
            string2 = string2.substring(0, n);
        }
        if ((n = string2.indexOf("?")) != -1) {
            string2 = string2.substring(0, n);
        }
        return string2.toLowerCase(Locale.US).endsWith(".jnlp") || string2.toLowerCase(Locale.US).endsWith(".jarjnlp");
    }
}

