/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import emulator.graphics3D.Vector4f;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Node;

public class RayIntersection {
    private float[] rayStartEnd = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    private float[] normal = new float[]{0.0f, 0.0f, 1.0f};
    private Node intersected = null;
    private int submeshIndex = 0;
    private float distance = 0.0f;
    private float[] textureS = new float[10];
    private float[] textureT = new float[10];
    private Camera camera;
    private float pickX;
    private float pickY;
    private float minDistance;

    public Node getIntersected() {
        return this.intersected;
    }

    public void getRay(float[] ray) {
        if (ray == null) {
            throw new NullPointerException();
        }
        if (ray.length < 6) {
            throw new IllegalArgumentException();
        }
        ray[0] = this.rayStartEnd[0];
        ray[1] = this.rayStartEnd[1];
        ray[2] = this.rayStartEnd[2];
        ray[3] = this.rayStartEnd[3] - this.rayStartEnd[0];
        ray[4] = this.rayStartEnd[4] - this.rayStartEnd[1];
        ray[5] = this.rayStartEnd[5] - this.rayStartEnd[2];
    }

    public float getDistance() {
        return this.distance;
    }

    public int getSubmeshIndex() {
        return this.submeshIndex;
    }

    public float getTextureS(int index) {
        if (index < 0 && index >= 10) {
            throw new IndexOutOfBoundsException();
        }
        return this.textureS[index];
    }

    public float getTextureT(int index) {
        if (index < 0 && index >= 10) {
            throw new IndexOutOfBoundsException();
        }
        return this.textureS[index];
    }

    public float getNormalX() {
        return this.normal[0];
    }

    public float getNormalY() {
        return this.normal[1];
    }

    public float getNormalZ() {
        return this.normal[2];
    }

    protected Camera getCamera() {
        return this.camera;
    }

    protected float getPickX() {
        return this.pickX;
    }

    protected float getPickY() {
        return this.pickY;
    }

    protected void startPick(float[] rayStartEnd, float pickX, float pickY, Camera camera) {
        this.rayStartEnd = rayStartEnd;
        this.pickX = pickX;
        this.pickY = pickY;
        this.camera = camera;
        this.minDistance = Float.MAX_VALUE;
    }

    protected boolean testDistance(float distance) {
        return distance > 0.0f && distance < this.minDistance;
    }

    protected boolean endPick(float dist, float[] hitTexS, float[] hitTexT, int hitSubmesh, Node hitNode, float[] hitNorm) {
        if (!this.testDistance(dist)) {
            return false;
        }
        if (hitTexS != null && hitTexT != null) {
            for (int i = 0; i < hitTexS.length; ++i) {
                this.textureS[i] = hitTexS[i];
                this.textureT[i] = hitTexT[i];
            }
        }
        this.submeshIndex = hitSubmesh;
        this.distance = dist;
        this.intersected = hitNode;
        if (hitNorm != null) {
            this.normal[0] = hitNorm[0];
            this.normal[1] = hitNorm[1];
            this.normal[2] = hitNorm[2];
            float length = Vector4f.length((float[])this.normal);
            if (length > 1.0E-5f) {
                this.normal[0] = this.normal[0] / length;
                this.normal[1] = this.normal[1] / length;
                this.normal[2] = this.normal[2] / length;
            }
        }
        this.minDistance = dist;
        return true;
    }
}

