/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import emulator.graphics3D.G3DUtils;
import javax.microedition.m3g.Object3D;

public class VertexArray
extends Object3D {
    private int componentType;
    private int vertexCount;
    private int componentCount;
    private byte[] byteValues;
    private short[] shortValues;

    public VertexArray(int numVertices, int numComponents, int componentSize) {
        if (!(numVertices < 1 || numVertices > 65535 || numComponents < 2 && numComponents > 4 || componentSize < 1 && componentSize > 2)) {
            this.vertexCount = numVertices;
            this.componentCount = numComponents;
            this.componentType = componentSize;
            if (this.componentType == 1) {
                this.byteValues = new byte[numVertices * numComponents];
            } else {
                this.shortValues = new short[numVertices * numComponents];
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    protected Object3D duplicateObject() {
        VertexArray clone = (VertexArray)super.duplicateObject();
        if (this.componentType == 1) {
            clone.byteValues = (byte[])this.byteValues.clone();
        } else {
            clone.shortValues = (short[])this.shortValues.clone();
        }
        return clone;
    }

    public void set(int firstVertex, int numVertices, short[] values) {
        if (values == null) {
            throw new NullPointerException();
        }
        if (this.componentType != 2) {
            throw new IllegalStateException();
        }
        if (numVertices < 0 || values.length < numVertices * this.componentCount) {
            throw new IllegalArgumentException();
        }
        if (firstVertex < 0 || firstVertex + numVertices > this.vertexCount) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(values, 0, this.shortValues, firstVertex * this.componentCount, numVertices * this.componentCount);
    }

    public void set(int firstVertex, int numVertices, byte[] values) {
        if (values == null) {
            throw new NullPointerException();
        }
        if (this.componentType != 1) {
            throw new IllegalStateException();
        }
        if (numVertices < 0 || values.length < numVertices * this.componentCount) {
            throw new IllegalArgumentException();
        }
        if (firstVertex < 0 || firstVertex + numVertices > this.vertexCount) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(values, 0, this.byteValues, firstVertex * this.componentCount, numVertices * this.componentCount);
    }

    public int getVertexCount() {
        return this.vertexCount;
    }

    public int getComponentCount() {
        return this.componentCount;
    }

    public int getComponentType() {
        return this.componentType;
    }

    public void get(int firstVertex, int numVertices, short[] values) {
        if (values == null) {
            throw new NullPointerException();
        }
        if (this.componentType != 2) {
            throw new IllegalStateException();
        }
        if (numVertices < 0 || values.length < numVertices * this.componentCount) {
            throw new IllegalArgumentException();
        }
        if (firstVertex < 0 || firstVertex + numVertices > this.vertexCount) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(this.shortValues, firstVertex * this.componentCount, values, 0, numVertices * this.componentCount);
    }

    public void get(int firstVertex, int numVertices, byte[] values) {
        if (values == null) {
            throw new NullPointerException();
        }
        if (this.componentType != 1) {
            throw new IllegalStateException();
        }
        if (numVertices < 0 || values.length < numVertices * this.componentCount) {
            throw new IllegalArgumentException();
        }
        if (firstVertex < 0 || firstVertex + numVertices > this.vertexCount) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(this.byteValues, firstVertex * this.componentCount, values, 0, numVertices * this.componentCount);
    }

    public byte[] getByteValues() {
        return this.byteValues;
    }

    public short[] getShortValues() {
        return this.shortValues;
    }

    private boolean equals_(VertexArray va) {
        return va != null && this.componentType == va.componentType && this.componentCount == va.componentCount && this.vertexCount == va.vertexCount;
    }

    public void morph(VertexArray[] targets, VertexArray base, float[] weights, float baseWeight) {
        int t;
        for (VertexArray target : targets) {
            if (this.equals_(target)) continue;
            throw new IllegalStateException();
        }
        if (this.componentType == 1) {
            for (int i = 0; i < this.byteValues.length; ++i) {
                float val = 0.0f;
                for (t = 0; t < targets.length; ++t) {
                    val += (float)targets[t].byteValues[i] * weights[t];
                }
                this.byteValues[i] = (byte)G3DUtils.round((float)(val += (float)base.byteValues[i] * baseWeight));
            }
        } else {
            for (int i = 0; i < this.shortValues.length; ++i) {
                float val = 0.0f;
                for (t = 0; t < targets.length; ++t) {
                    val += (float)targets[t].shortValues[i] * weights[t];
                }
                this.shortValues[i] = (short)G3DUtils.round((float)(val += (float)base.shortValues[i] * baseWeight));
            }
        }
    }

    public void morphColors(VertexArray[] targets, VertexArray base, float[] weights, float baseWeight) {
        for (VertexArray target : targets) {
            if (this.equals_(target)) continue;
            throw new IllegalStateException();
        }
        if (this.componentType == 1) {
            for (int i = 0; i < this.byteValues.length; ++i) {
                float val = 0.0f;
                for (int t = 0; t < targets.length; ++t) {
                    val += (float)(targets[t].byteValues[i] & 0xFF) * weights[t];
                }
                this.byteValues[i] = (byte)G3DUtils.limit((int)G3DUtils.round((float)(val += (float)(base.byteValues[i] & 0xFF) * baseWeight)), (int)0, (int)255);
            }
        }
    }
}

