/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import emulator.graphics3D.G3DUtils;
import emulator.graphics3D.Vector4f;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.VertexArray;

public class VertexBuffer
extends Object3D {
    private int vertexCount = 0;
    private VertexArray positions = null;
    private VertexArray normals = null;
    private VertexArray[] uvms = new VertexArray[10];
    private VertexArray colors = null;
    private int defaultColor = -1;
    private float[] posScaleBias = new float[]{1.0f, 0.0f, 0.0f, 0.0f};
    private float[][] uvScaleBias = new float[10][4];
    private int arraysCount = 0;

    @Override
    protected Object3D duplicateObject() {
        VertexBuffer clone = (VertexBuffer)super.duplicateObject();
        clone.uvms = (VertexArray[])this.uvms.clone();
        clone.posScaleBias = (float[])this.posScaleBias.clone();
        clone.uvScaleBias = new float[10][4];
        for (int i = 0; i < 10; ++i) {
            clone.uvScaleBias[i] = (float[])this.uvScaleBias[i].clone();
        }
        return clone;
    }

    public int getVertexCount() {
        return this.vertexCount;
    }

    public void setPositions(VertexArray newPoses, float scale, float[] bias) {
        if (newPoses != null && newPoses.getComponentCount() != 3) {
            throw new IllegalArgumentException();
        }
        if (newPoses != null && bias != null && bias.length < 3) {
            throw new IllegalArgumentException();
        }
        if (newPoses != null && this.vertexCount != 0 && newPoses.getVertexCount() != this.vertexCount) {
            throw new IllegalArgumentException();
        }
        this.removeReference(this.positions);
        if (newPoses != null) {
            if (this.positions == null) {
                ++this.arraysCount;
            }
            this.vertexCount = newPoses.getVertexCount();
            this.positions = newPoses;
            this.posScaleBias[0] = scale;
            if (bias != null) {
                System.arraycopy(bias, 0, this.posScaleBias, 1, 3);
            } else {
                this.posScaleBias[1] = 0.0f;
                this.posScaleBias[2] = 0.0f;
                this.posScaleBias[3] = 0.0f;
            }
        } else if (this.positions != null) {
            this.positions = null;
            --this.arraysCount;
            this.vertexCount = this.arraysCount > 0 ? this.vertexCount : 0;
        }
        this.addReference(this.positions);
    }

    public void setTexCoords(int index, VertexArray newUvm, float scale, float[] bias) {
        if (newUvm != null && newUvm.getComponentCount() != 2 && newUvm.getComponentCount() != 3) {
            throw new IllegalArgumentException();
        }
        if (newUvm != null && this.vertexCount != 0 && newUvm.getVertexCount() != this.vertexCount) {
            throw new IllegalArgumentException();
        }
        if (newUvm != null && bias != null && bias.length < newUvm.getComponentCount()) {
            throw new IllegalArgumentException();
        }
        if (index >= 0 && index < 10) {
            this.removeReference(this.uvms[index]);
            if (newUvm != null) {
                if (this.uvms[index] == null) {
                    ++this.arraysCount;
                }
                this.vertexCount = newUvm.getVertexCount();
                this.uvms[index] = newUvm;
                this.uvScaleBias[index][0] = scale;
                this.uvScaleBias[index][1] = 0.0f;
                this.uvScaleBias[index][2] = 0.0f;
                this.uvScaleBias[index][3] = 0.0f;
                if (bias != null) {
                    System.arraycopy(bias, 0, this.uvScaleBias[index], 1, newUvm.getComponentCount());
                }
            } else if (this.uvms[index] != null) {
                this.uvms[index] = null;
                --this.arraysCount;
                this.vertexCount = this.arraysCount > 0 ? this.vertexCount : 0;
            }
        } else {
            throw new IndexOutOfBoundsException();
        }
        this.addReference(this.uvms[index]);
    }

    public void setNormals(VertexArray newNorms) {
        if (newNorms != null && newNorms.getComponentCount() != 3) {
            throw new IllegalArgumentException();
        }
        if (newNorms != null && this.vertexCount != 0 && newNorms.getVertexCount() != this.vertexCount) {
            throw new IllegalArgumentException();
        }
        this.removeReference(this.normals);
        if (newNorms != null) {
            if (this.normals == null) {
                ++this.arraysCount;
            }
            this.vertexCount = newNorms.getVertexCount();
            this.normals = newNorms;
        } else if (this.normals != null) {
            this.normals = null;
            --this.arraysCount;
            this.vertexCount = this.arraysCount > 0 ? this.vertexCount : 0;
        }
        this.addReference(this.normals);
    }

    public void setColors(VertexArray newCols) {
        if (newCols != null && newCols.getComponentType() != 1) {
            throw new IllegalArgumentException();
        }
        if (newCols != null && newCols.getComponentCount() != 3 && newCols.getComponentCount() != 4) {
            throw new IllegalArgumentException();
        }
        if (newCols != null && this.vertexCount != 0 && newCols.getVertexCount() != this.vertexCount) {
            throw new IllegalArgumentException();
        }
        this.removeReference(this.colors);
        if (newCols != null) {
            if (this.colors == null) {
                ++this.arraysCount;
            }
            this.vertexCount = newCols.getVertexCount();
            this.colors = newCols;
        } else if (this.colors != null) {
            this.colors = null;
            --this.arraysCount;
            this.vertexCount = this.arraysCount > 0 ? this.vertexCount : 0;
        }
        this.addReference(this.colors);
    }

    public VertexArray getPositions(float[] scaleBias) {
        if (scaleBias != null && scaleBias.length < 4) {
            throw new IllegalArgumentException();
        }
        if (this.positions != null && scaleBias != null) {
            System.arraycopy(this.posScaleBias, 0, scaleBias, 0, 4);
        }
        return this.positions;
    }

    public VertexArray getTexCoords(int index, float[] scaleBias) {
        if (index >= 0 && index < 10) {
            if (this.uvms[index] != null && scaleBias != null) {
                if (scaleBias.length < this.uvms[index].getComponentCount() + 1) {
                    throw new IllegalArgumentException();
                }
                System.arraycopy(this.uvScaleBias[index], 0, scaleBias, 0, this.uvms[index].getComponentCount() + 1);
            }
            return this.uvms[index];
        }
        throw new IndexOutOfBoundsException();
    }

    public VertexArray getNormals() {
        return this.normals;
    }

    public VertexArray getColors() {
        return this.colors;
    }

    public void setDefaultColor(int col) {
        this.defaultColor = col;
    }

    public int getDefaultColor() {
        return this.defaultColor;
    }

    @Override
    protected void updateProperty(int property, float[] value) {
        switch (property) {
            case 256: {
                this.defaultColor &= 0xFFFFFF;
                this.defaultColor |= G3DUtils.getIntColor((float[])value) & 0xFF000000;
                return;
            }
            case 258: {
                this.defaultColor &= 0xFF000000;
                this.defaultColor |= G3DUtils.getIntColor((float[])value) & 0xFFFFFF;
                return;
            }
        }
        super.updateProperty(property, value);
    }

    protected boolean getNormalVertex(int vertexIndex, Vector4f vec) {
        float nz;
        float ny;
        float nx;
        if (this.normals == null) {
            return false;
        }
        if (this.normals.getComponentType() == 1) {
            byte[] tmpVec = new byte[3];
            this.normals.get(vertexIndex, 1, tmpVec);
            nx = tmpVec[0];
            ny = tmpVec[1];
            nz = tmpVec[2];
        } else {
            short[] tmpVec = new short[3];
            this.normals.get(vertexIndex, 1, tmpVec);
            nx = tmpVec[0];
            ny = tmpVec[1];
            nz = tmpVec[2];
        }
        vec.set(nx, ny, nz, 1.0f);
        return true;
    }

    protected void getVertex(int vertexIndex, Vector4f vec) {
        float z;
        float y;
        float x;
        if (this.positions.getComponentType() == 1) {
            byte[] tmpVec = new byte[3];
            this.positions.get(vertexIndex, 1, tmpVec);
            x = tmpVec[0];
            y = tmpVec[1];
            z = tmpVec[2];
        } else {
            short[] tmpVec = new short[3];
            this.positions.get(vertexIndex, 1, tmpVec);
            x = tmpVec[0];
            y = tmpVec[1];
            z = tmpVec[2];
        }
        x *= this.posScaleBias[0];
        y *= this.posScaleBias[0];
        z *= this.posScaleBias[0];
        vec.set(x += this.posScaleBias[1], y += this.posScaleBias[2], z += this.posScaleBias[3], 1.0f);
    }

    protected boolean getTexVertex(int vertexIndex, int texSlot, Vector4f vec) {
        float z;
        float y;
        float x;
        if (this.uvms[texSlot] == null) {
            return false;
        }
        int componentCount = this.uvms[texSlot].getComponentCount();
        if (this.uvms[texSlot].getComponentType() == 1) {
            byte[] tmpVec = new byte[componentCount];
            this.uvms[texSlot].get(vertexIndex, 1, tmpVec);
            x = tmpVec[0];
            y = tmpVec[1];
            z = componentCount == 3 ? (float)tmpVec[2] : 0.0f;
        } else {
            short[] tmpVec = new short[componentCount];
            this.uvms[texSlot].get(vertexIndex, 1, tmpVec);
            x = tmpVec[0];
            y = tmpVec[1];
            z = componentCount == 3 ? (float)tmpVec[2] : 0.0f;
        }
        x *= this.uvScaleBias[texSlot][0];
        y *= this.uvScaleBias[texSlot][0];
        z *= this.uvScaleBias[texSlot][0];
        vec.set(x += this.uvScaleBias[texSlot][1], y += this.uvScaleBias[texSlot][2], z += this.uvScaleBias[texSlot][3], 1.0f);
        return true;
    }
}

