/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.color_game;

import com.siemens.mp.color_game.Layer;
import javax.microedition.lcdui.Graphics;

public class LayerManager {
    private int nlayers;
    private Layer[] component = new Layer[4];
    private int viewX;
    private int viewY;
    private int viewWidth;
    private int viewHeight;

    public LayerManager() {
        this.setViewWindow(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void append(Layer layer) {
        this.removeImpl(layer);
        this.addImpl(layer, this.nlayers);
    }

    public void insert(Layer layer, int n2) {
        if (n2 < 0 || n2 > this.nlayers || this.exist(layer) && n2 >= this.nlayers) {
            throw new IndexOutOfBoundsException();
        }
        this.removeImpl(layer);
        this.addImpl(layer, n2);
    }

    public Layer getLayerAt(int n2) {
        if (n2 < 0 || n2 >= this.nlayers) {
            throw new IndexOutOfBoundsException();
        }
        return this.component[n2];
    }

    public int getSize() {
        return this.nlayers;
    }

    public void remove(Layer layer) {
        this.removeImpl(layer);
    }

    public void paint(Graphics graphics, int n2, int n3) {
        int n4 = graphics.getClipX();
        int n5 = graphics.getClipY();
        int n6 = graphics.getClipWidth();
        int n7 = graphics.getClipHeight();
        graphics.translate(n2 - this.viewX, n3 - this.viewY);
        graphics.clipRect(this.viewX, this.viewY, this.viewWidth, this.viewHeight);
        int n8 = this.nlayers;
        while (--n8 >= 0) {
            Layer layer = this.component[n8];
            if (!layer.visible) continue;
            layer.paint(graphics);
        }
        graphics.translate(-n2 + this.viewX, -n3 + this.viewY);
        graphics.setClip(n4, n5, n6, n7);
    }

    public void setViewWindow(int n2, int n3, int n4, int n5) {
        if (n4 < 0 || n5 < 0) {
            throw new IllegalArgumentException();
        }
        this.viewX = n2;
        this.viewY = n3;
        this.viewWidth = n4;
        this.viewHeight = n5;
    }

    private void addImpl(Layer layer, int n2) {
        if (this.nlayers == this.component.length) {
            Layer[] layerArray = new Layer[this.nlayers + 4];
            System.arraycopy(this.component, 0, layerArray, 0, this.nlayers);
            System.arraycopy(this.component, n2, layerArray, n2 + 1, this.nlayers - n2);
            this.component = layerArray;
        } else {
            System.arraycopy(this.component, n2, this.component, n2 + 1, this.nlayers - n2);
        }
        this.component[n2] = layer;
        ++this.nlayers;
    }

    private void removeImpl(Layer layer) {
        if (layer == null) {
            throw new NullPointerException();
        }
        int n2 = this.nlayers;
        while (--n2 >= 0) {
            if (this.component[n2] != layer) continue;
            this.remove(n2);
        }
    }

    private boolean exist(Layer layer) {
        if (layer == null) {
            return false;
        }
        int n2 = this.nlayers;
        while (--n2 >= 0) {
            if (this.component[n2] != layer) continue;
            return true;
        }
        return false;
    }

    private void remove(int n2) {
        System.arraycopy(this.component, n2 + 1, this.component, n2, this.nlayers - n2 - 1);
        this.component[--this.nlayers] = null;
    }
}

