/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM.util;

import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.COM.Dispatch;
import com.sun.jna.platform.win32.COM.DispatchListener;
import com.sun.jna.platform.win32.COM.IDispatchCallback;
import com.sun.jna.platform.win32.COM.Unknown;
import com.sun.jna.platform.win32.COM.util.Convert;
import com.sun.jna.platform.win32.COM.util.IComEventCallbackListener;
import com.sun.jna.platform.win32.COM.util.ObjectFactory;
import com.sun.jna.platform.win32.COM.util.annotation.ComEventCallback;
import com.sun.jna.platform.win32.COM.util.annotation.ComInterface;
import com.sun.jna.platform.win32.COM.util.annotation.ComMethod;
import com.sun.jna.platform.win32.Guid$IID;
import com.sun.jna.platform.win32.Guid$REFIID;
import com.sun.jna.platform.win32.OaIdl$DISPID;
import com.sun.jna.platform.win32.OaIdl$DISPIDByReference;
import com.sun.jna.platform.win32.OaIdl$EXCEPINFO$ByReference;
import com.sun.jna.platform.win32.OleAuto$DISPPARAMS$ByReference;
import com.sun.jna.platform.win32.Variant$VARIANT;
import com.sun.jna.platform.win32.Variant$VARIANT$ByReference;
import com.sun.jna.platform.win32.WinDef$LCID;
import com.sun.jna.platform.win32.WinDef$UINT;
import com.sun.jna.platform.win32.WinDef$UINTByReference;
import com.sun.jna.platform.win32.WinDef$WORD;
import com.sun.jna.platform.win32.WinError;
import com.sun.jna.platform.win32.WinNT$HRESULT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CallbackProxy
implements IDispatchCallback {
    private static boolean DEFAULT_BOOLEAN;
    private static byte DEFAULT_BYTE;
    private static short DEFAULT_SHORT;
    private static int DEFAULT_INT;
    private static long DEFAULT_LONG;
    private static float DEFAULT_FLOAT;
    private static double DEFAULT_DOUBLE;
    ObjectFactory factory;
    Class comEventCallbackInterface;
    IComEventCallbackListener comEventCallbackListener;
    Guid$REFIID listenedToRiid;
    public DispatchListener dispatchListener;
    Map dsipIdMap;

    public CallbackProxy(ObjectFactory objectFactory, Class clazz, IComEventCallbackListener iComEventCallbackListener) {
        this.factory = objectFactory;
        this.comEventCallbackInterface = clazz;
        this.comEventCallbackListener = iComEventCallbackListener;
        this.listenedToRiid = this.createRIID(clazz);
        this.dsipIdMap = this.createDispIdMap(clazz);
        this.dispatchListener = new DispatchListener(this);
    }

    Guid$REFIID createRIID(Class clazz) {
        ComInterface comInterface = clazz.getAnnotation(ComInterface.class);
        if (null == comInterface) {
            throw new COMException("advise: Interface must define a value for either iid via the ComInterface annotation");
        }
        String string = comInterface.iid();
        if (null == string || string.isEmpty()) {
            throw new COMException("ComInterface must define a value for iid");
        }
        return new Guid$REFIID(new Guid$IID(string).getPointer());
    }

    Map createDispIdMap(Class clazz) {
        HashMap<OaIdl$DISPID, Method> hashMap = new HashMap<OaIdl$DISPID, Method>();
        for (Method method : clazz.getMethods()) {
            int n2;
            ComEventCallback comEventCallback = method.getAnnotation(ComEventCallback.class);
            ComMethod comMethod = method.getAnnotation(ComMethod.class);
            if (comMethod != null) {
                n2 = comMethod.dispId();
                if (-1 == n2) {
                    n2 = this.fetchDispIdFromName(comEventCallback);
                }
                if (n2 == -1) {
                    this.comEventCallbackListener.errorReceivingCallbackEvent("DISPID for " + method.getName() + " not found", null);
                }
                hashMap.put(new OaIdl$DISPID(n2), method);
                continue;
            }
            if (null == comEventCallback) continue;
            n2 = comEventCallback.dispid();
            if (-1 == n2) {
                n2 = this.fetchDispIdFromName(comEventCallback);
            }
            if (n2 == -1) {
                this.comEventCallbackListener.errorReceivingCallbackEvent("DISPID for " + method.getName() + " not found", null);
            }
            hashMap.put(new OaIdl$DISPID(n2), method);
        }
        return hashMap;
    }

    int fetchDispIdFromName(ComEventCallback comEventCallback) {
        return -1;
    }

    void invokeOnThread(OaIdl$DISPID oaIdl$DISPID, Guid$REFIID guid$REFIID, WinDef$LCID winDef$LCID, WinDef$WORD winDef$WORD, OleAuto$DISPPARAMS$ByReference oleAuto$DISPPARAMS$ByReference) {
        Object[] objectArray;
        int n2;
        Variant$VARIANT[] variant$VARIANTArray = oleAuto$DISPPARAMS$ByReference.getArgs();
        Method method = (Method)this.dsipIdMap.get(oaIdl$DISPID);
        if (method == null) {
            this.comEventCallbackListener.errorReceivingCallbackEvent("No method found with dispId = " + oaIdl$DISPID, null);
            return;
        }
        OaIdl$DISPID[] oaIdl$DISPIDArray = oleAuto$DISPPARAMS$ByReference.getRgdispidNamedArgs();
        Class<?>[] classArray = method.getParameterTypes();
        Object[] objectArray2 = new Object[classArray.length];
        for (n2 = 0; n2 < objectArray2.length && variant$VARIANTArray.length - oaIdl$DISPIDArray.length - n2 > 0; ++n2) {
            Class<?> clazz = classArray[n2];
            objectArray = variant$VARIANTArray[variant$VARIANTArray.length - n2 - 1];
            objectArray2[n2] = Convert.toJavaObject((Variant$VARIANT)objectArray, clazz, this.factory, true, false);
        }
        for (n2 = 0; n2 < oaIdl$DISPIDArray.length; ++n2) {
            int n3 = oaIdl$DISPIDArray[n2].intValue();
            if (n3 >= objectArray2.length) continue;
            objectArray = classArray[n3];
            Variant$VARIANT variant$VARIANT = variant$VARIANTArray[n2];
            objectArray2[n3] = Convert.toJavaObject(variant$VARIANT, (Class)objectArray, this.factory, true, false);
        }
        for (n2 = 0; n2 < objectArray2.length; ++n2) {
            if (objectArray2[n2] != null || !classArray[n2].isPrimitive()) continue;
            if (classArray[n2].equals(Boolean.TYPE)) {
                objectArray2[n2] = DEFAULT_BOOLEAN;
                continue;
            }
            if (classArray[n2].equals(Byte.TYPE)) {
                objectArray2[n2] = DEFAULT_BYTE;
                continue;
            }
            if (classArray[n2].equals(Short.TYPE)) {
                objectArray2[n2] = DEFAULT_SHORT;
                continue;
            }
            if (classArray[n2].equals(Integer.TYPE)) {
                objectArray2[n2] = DEFAULT_INT;
                continue;
            }
            if (classArray[n2].equals(Long.TYPE)) {
                objectArray2[n2] = DEFAULT_LONG;
                continue;
            }
            if (classArray[n2].equals(Float.TYPE)) {
                objectArray2[n2] = Float.valueOf(DEFAULT_FLOAT);
                continue;
            }
            if (classArray[n2].equals(Double.TYPE)) {
                objectArray2[n2] = DEFAULT_DOUBLE;
                continue;
            }
            throw new IllegalArgumentException("Class type " + classArray[n2].getName() + " not mapped to primitive default value.");
        }
        try {
            method.invoke((Object)this.comEventCallbackListener, objectArray2);
        }
        catch (Exception exception) {
            ArrayList<String> arrayList = new ArrayList<String>(objectArray2.length);
            for (Object object : objectArray2) {
                if (object == null) {
                    arrayList.add("NULL");
                    continue;
                }
                arrayList.add(object.getClass().getName());
            }
            this.comEventCallbackListener.errorReceivingCallbackEvent("Exception invoking method " + method + " supplied: " + ((Object)arrayList).toString(), exception);
        }
    }

    @Override
    public Pointer getPointer() {
        return this.dispatchListener.getPointer();
    }

    @Override
    public WinNT$HRESULT GetTypeInfoCount(WinDef$UINTByReference winDef$UINTByReference) {
        return new WinNT$HRESULT(-2147467263);
    }

    @Override
    public WinNT$HRESULT GetTypeInfo(WinDef$UINT winDef$UINT, WinDef$LCID winDef$LCID, PointerByReference pointerByReference) {
        return new WinNT$HRESULT(-2147467263);
    }

    @Override
    public WinNT$HRESULT GetIDsOfNames(Guid$REFIID guid$REFIID, WString[] wStringArray, int n2, WinDef$LCID winDef$LCID, OaIdl$DISPIDByReference oaIdl$DISPIDByReference) {
        return new WinNT$HRESULT(-2147467263);
    }

    @Override
    public WinNT$HRESULT Invoke(OaIdl$DISPID oaIdl$DISPID, Guid$REFIID guid$REFIID, WinDef$LCID winDef$LCID, WinDef$WORD winDef$WORD, OleAuto$DISPPARAMS$ByReference oleAuto$DISPPARAMS$ByReference, Variant$VARIANT$ByReference variant$VARIANT$ByReference, OaIdl$EXCEPINFO$ByReference oaIdl$EXCEPINFO$ByReference, IntByReference intByReference) {
        assert (COMUtils.comIsInitialized()) : "Assumption about COM threading broken.";
        this.invokeOnThread(oaIdl$DISPID, guid$REFIID, winDef$LCID, winDef$WORD, oleAuto$DISPPARAMS$ByReference);
        return WinError.S_OK;
    }

    @Override
    public WinNT$HRESULT QueryInterface(Guid$REFIID guid$REFIID, PointerByReference pointerByReference) {
        if (null == pointerByReference) {
            return new WinNT$HRESULT(-2147467261);
        }
        if (guid$REFIID.equals(this.listenedToRiid)) {
            pointerByReference.setValue(this.getPointer());
            return WinError.S_OK;
        }
        if (guid$REFIID.getValue().equals(Unknown.IID_IUNKNOWN)) {
            pointerByReference.setValue(this.getPointer());
            return WinError.S_OK;
        }
        if (guid$REFIID.getValue().equals(Dispatch.IID_IDISPATCH)) {
            pointerByReference.setValue(this.getPointer());
            return WinError.S_OK;
        }
        return new WinNT$HRESULT(-2147467262);
    }

    @Override
    public int AddRef() {
        return 0;
    }

    @Override
    public int Release() {
        return 0;
    }
}

