/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.io.IOException;
import net.java.games.input.Component$Identifier;
import net.java.games.input.DIEffectInfo;
import net.java.games.input.DirectInputEnvironmentPlugin;
import net.java.games.input.Rumbler;

final class IDirectInputEffect
implements Rumbler {
    private final long address;
    private final DIEffectInfo info;
    private boolean released;

    public IDirectInputEffect(long l2, DIEffectInfo dIEffectInfo) {
        this.address = l2;
        this.info = dIEffectInfo;
    }

    @Override
    public final synchronized void rumble(float f2) {
        try {
            this.checkReleased();
            if (f2 > 0.0f) {
                int n2 = Math.round(f2 * 10000.0f);
                this.setGain(n2);
                this.start(1, 0);
            } else {
                this.stop();
            }
        }
        catch (IOException iOException) {
            DirectInputEnvironmentPlugin.logln(new StringBuffer().append("Failed to set rumbler gain: ").append(iOException.getMessage()).toString());
        }
    }

    @Override
    public final Component$Identifier getAxisIdentifier() {
        return null;
    }

    @Override
    public final String getAxisName() {
        return null;
    }

    public final synchronized void release() {
        if (!this.released) {
            this.released = true;
            IDirectInputEffect.nRelease(this.address);
        }
    }

    private static final native void nRelease(long var0);

    private final void checkReleased() {
        if (this.released) {
            throw new IOException();
        }
    }

    private final void setGain(int n2) {
        int n3 = IDirectInputEffect.nSetGain(this.address, n2);
        if (n3 != 3 && n3 != 4 && n3 != 0 && n3 != 8 && n3 != 12) {
            throw new IOException(new StringBuffer().append("Failed to set effect gain (0x").append(Integer.toHexString(n3)).append(")").toString());
        }
    }

    private static final native int nSetGain(long var0, int var2);

    private final void start(int n2, int n3) {
        int n4 = IDirectInputEffect.nStart(this.address, n2, n3);
        if (n4 != 0) {
            throw new IOException(new StringBuffer().append("Failed to start effect (0x").append(Integer.toHexString(n4)).append(")").toString());
        }
    }

    private static final native int nStart(long var0, int var2, int var3);

    private final void stop() {
        int n2 = IDirectInputEffect.nStop(this.address);
        if (n2 != 0) {
            throw new IOException(new StringBuffer().append("Failed to stop effect (0x").append(Integer.toHexString(n2)).append(")").toString());
        }
    }

    private static final native int nStop(long var0);

    protected void finalize() {
        this.release();
    }
}

