/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.Event;
import net.java.games.input.Mouse;
import net.java.games.input.RawDevice;
import net.java.games.input.RawMouseEvent;
import net.java.games.input.Rumbler;

final class RawMouse
extends Mouse {
    private static final int EVENT_DONE = 1;
    private static final int EVENT_X = 2;
    private static final int EVENT_Y = 3;
    private static final int EVENT_Z = 4;
    private static final int EVENT_BUTTON_0 = 5;
    private static final int EVENT_BUTTON_1 = 6;
    private static final int EVENT_BUTTON_2 = 7;
    private static final int EVENT_BUTTON_3 = 8;
    private static final int EVENT_BUTTON_4 = 9;
    private final RawDevice device;
    private final RawMouseEvent current_event = new RawMouseEvent();
    private int event_state = 1;

    protected RawMouse(String string, RawDevice rawDevice, Component[] componentArray, Controller[] controllerArray, Rumbler[] rumblerArray) {
        super(string, componentArray, controllerArray, rumblerArray);
        this.device = rawDevice;
    }

    @Override
    public final void pollDevice() {
        this.device.pollMouse();
    }

    private static final boolean makeButtonEvent(RawMouseEvent rawMouseEvent, Event event, Component component, int n2, int n3) {
        if ((rawMouseEvent.getButtonFlags() & n2) != 0) {
            event.set(component, 1.0f, rawMouseEvent.getNanos());
            return true;
        }
        if ((rawMouseEvent.getButtonFlags() & n3) != 0) {
            event.set(component, 0.0f, rawMouseEvent.getNanos());
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected final synchronized boolean getNextDeviceEvent(Event event) {
        block11: while (true) {
            switch (this.event_state) {
                case 1: {
                    if (!this.device.getNextMouseEvent(this.current_event)) {
                        return false;
                    }
                    this.event_state = 2;
                    continue block11;
                }
                case 2: {
                    int n2 = this.device.getEventRelativeX();
                    this.event_state = 3;
                    if (n2 == 0) continue block11;
                    event.set(this.getX(), n2, this.current_event.getNanos());
                    return true;
                }
                case 3: {
                    int n3 = this.device.getEventRelativeY();
                    this.event_state = 4;
                    if (n3 == 0) continue block11;
                    event.set(this.getY(), n3, this.current_event.getNanos());
                    return true;
                }
                case 4: {
                    int n4 = this.current_event.getWheelDelta();
                    this.event_state = 5;
                    if (n4 == 0) continue block11;
                    event.set(this.getWheel(), n4, this.current_event.getNanos());
                    return true;
                }
                case 5: {
                    this.event_state = 6;
                    if (!RawMouse.makeButtonEvent(this.current_event, event, this.getPrimaryButton(), 1, 2)) continue block11;
                    return true;
                }
                case 6: {
                    this.event_state = 7;
                    if (!RawMouse.makeButtonEvent(this.current_event, event, this.getSecondaryButton(), 4, 8)) continue block11;
                    return true;
                }
                case 7: {
                    this.event_state = 8;
                    if (!RawMouse.makeButtonEvent(this.current_event, event, this.getTertiaryButton(), 16, 32)) continue block11;
                    return true;
                }
                case 8: {
                    this.event_state = 9;
                    if (!RawMouse.makeButtonEvent(this.current_event, event, this.getButton3(), 64, 128)) continue block11;
                    return true;
                }
                case 9: {
                    this.event_state = 1;
                    if (RawMouse.makeButtonEvent(this.current_event, event, this.getButton4(), 256, 512)) return true;
                    continue block11;
                }
            }
            break;
        }
        throw new RuntimeException(new StringBuffer().append("Unknown event state: ").append(this.event_state).toString());
    }

    @Override
    protected final void setDeviceEventQueueSize(int n2) {
        this.device.setBufferSize(n2);
    }
}

