/*
 * Decompiled with CFR 0.152.
 */
package org.bridj.demangling;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.bridj.BridJ;
import org.bridj.CLong;
import org.bridj.CRuntime;
import org.bridj.FlagSet;
import org.bridj.NativeObject;
import org.bridj.Platform;
import org.bridj.Pointer;
import org.bridj.SizeT;
import org.bridj.TimeT;
import org.bridj.ann.Convention$Style;
import org.bridj.ann.Ptr;
import org.bridj.ann.Template;
import org.bridj.demangling.Demangler;
import org.bridj.demangling.Demangler$Annotations;
import org.bridj.demangling.Demangler$ClassRef;
import org.bridj.demangling.Demangler$Constant;
import org.bridj.demangling.Demangler$IdentLike;
import org.bridj.demangling.Demangler$SpecialName;
import org.bridj.demangling.Demangler$TemplateArg;
import org.bridj.demangling.Demangler$TypeRef;
import org.bridj.util.AnnotationUtils;
import org.bridj.util.Utils;

public class Demangler$MemberRef {
    private Integer argumentsStackSize;
    private Demangler$TypeRef enclosingType;
    private Demangler$TypeRef valueType;
    private Demangler$IdentLike memberName;
    Boolean isStatic;
    Boolean isProtected;
    Boolean isPrivate;
    public int modifiers;
    public Demangler$TypeRef[] paramTypes;
    public Demangler$TypeRef[] throwTypes;
    Demangler$TemplateArg[] templateArguments;
    public Convention$Style callingConvention;

    public void setTemplateArguments(Demangler$TemplateArg[] demangler$TemplateArgArray) {
        this.templateArguments = demangler$TemplateArgArray;
    }

    public Integer getArgumentsStackSize() {
        return this.argumentsStackSize;
    }

    public void setArgumentsStackSize(Integer n2) {
        this.argumentsStackSize = n2;
    }

    protected boolean matchesEnclosingType(Type type) {
        return this.getEnclosingType() != null && this.getEnclosingType().matches(type, Demangler.annotations(type));
    }

    protected boolean matchesVirtualTable(Type type) {
        return this.memberName == Demangler$SpecialName.VFTable && this.matchesEnclosingType(type);
    }

    protected boolean matchesConstructor(Type type, Constructor constructor) {
        int n2;
        if (this.memberName != Demangler$SpecialName.Constructor) {
            return false;
        }
        if (!this.matchesEnclosingType(type)) {
            return false;
        }
        Template template = Utils.getClass(type).getAnnotation(Template.class);
        Annotation[][] annotationArray = constructor.getParameterAnnotations();
        Type[] typeArray = constructor.getGenericParameterTypes();
        return this.matchesArgs(typeArray, annotationArray, (n2 = Utils.getEnclosedConstructorParametersOffset(constructor)) + (template == null ? 0 : template.value().length));
    }

    protected boolean matchesDestructor(Type type) {
        return this.memberName == Demangler$SpecialName.Destructor && this.matchesEnclosingType(type);
    }

    static boolean hasInstance(Object[] objectArray, Class ... classArray) {
        for (Object object : objectArray) {
            for (Class clazz : classArray) {
                if (!clazz.isInstance(object)) continue;
                return true;
            }
        }
        return false;
    }

    static int getArgumentsStackSize(Method method) {
        int n2 = 0;
        Type[] typeArray = method.getGenericParameterTypes();
        Annotation[][] annotationArray = method.getParameterAnnotations();
        int n3 = typeArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Class clazz = Demangler.getTypeClass(typeArray[i2]);
            if (clazz == Integer.TYPE) {
                n2 += 4;
                continue;
            }
            if (clazz == Long.TYPE) {
                Annotation[] annotationArray2 = annotationArray[i2];
                if (AnnotationUtils.isAnnotationPresent(Ptr.class, annotationArray2) || AnnotationUtils.isAnnotationPresent(org.bridj.ann.CLong.class, annotationArray2)) {
                    n2 += Pointer.SIZE;
                    continue;
                }
                n2 += 8;
                continue;
            }
            if (clazz == Float.TYPE) {
                n2 += 4;
                continue;
            }
            if (clazz == Double.TYPE) {
                n2 += 8;
                continue;
            }
            if (clazz == Byte.TYPE) {
                ++n2;
                continue;
            }
            if (clazz == Character.TYPE) {
                n2 += Platform.WCHAR_T_SIZE;
                continue;
            }
            if (clazz == CLong.class) {
                n2 += Platform.CLONG_SIZE;
                continue;
            }
            if (clazz == SizeT.class) {
                n2 += Platform.SIZE_T_SIZE;
                continue;
            }
            if (clazz == TimeT.class) {
                n2 += Platform.TIME_T_SIZE;
                continue;
            }
            if (clazz == Short.TYPE) {
                n2 += 2;
                continue;
            }
            if (clazz == Boolean.TYPE) {
                ++n2;
                continue;
            }
            if (Pointer.class.isAssignableFrom(clazz)) {
                n2 += Pointer.SIZE;
                continue;
            }
            if (NativeObject.class.isAssignableFrom(clazz)) {
                n2 = (int)((long)n2 + ((CRuntime)BridJ.getRuntime(clazz)).sizeOf(typeArray[i2], null));
                continue;
            }
            if (FlagSet.class.isAssignableFrom(clazz)) {
                n2 += 4;
                continue;
            }
            throw new RuntimeException("Type not handled : " + clazz.getName());
        }
        return n2;
    }

    protected boolean matches(Method method) {
        if (this.memberName instanceof Demangler$SpecialName) {
            return false;
        }
        if (!this.matchesEnclosingType(method)) {
            return false;
        }
        return this.matchesSignature(method);
    }

    public boolean matchesEnclosingType(Method method) {
        Demangler$TypeRef demangler$TypeRef = this.getEnclosingType();
        if (demangler$TypeRef == null) {
            return true;
        }
        Demangler$Annotations demangler$Annotations = Demangler.annotations(method);
        Class<?> clazz = method.getDeclaringClass();
        do {
            if (!demangler$TypeRef.matches(clazz, demangler$Annotations)) continue;
            return true;
        } while ((clazz = clazz.getSuperclass()) != null && clazz != Object.class);
        return false;
    }

    public boolean matchesSignature(Method method) {
        if (this.getArgumentsStackSize() != null && this.getArgumentsStackSize() != Demangler$MemberRef.getArgumentsStackSize(method)) {
            return false;
        }
        if (this.getMemberName() != null && !this.getMemberName().toString().equals(Demangler.getMethodName(method))) {
            return false;
        }
        if (this.getValueType() != null && !this.getValueType().matches(method.getReturnType(), Demangler.annotations(method))) {
            return false;
        }
        Template template = method.getAnnotation(Template.class);
        Annotation[][] annotationArray = method.getParameterAnnotations();
        Type[] typeArray = method.getGenericParameterTypes();
        return this.paramTypes == null || this.matchesArgs(typeArray, annotationArray, template == null ? 0 : template.value().length);
    }

    private boolean matchesArgs(Type[] typeArray, Annotation[][] annotationArray, int n2) {
        Object object;
        Object object2;
        int n3;
        int n4;
        int n5 = n2;
        int n6 = n4 = this.templateArguments == null ? 0 : this.templateArguments.length;
        for (n3 = 0; n3 < n4; ++n3) {
            if (n5 >= typeArray.length) {
                return false;
            }
            object2 = typeArray[n2 + n3];
            object = this.templateArguments[n3];
            if (object instanceof Demangler$TypeRef) {
                if (!object2.equals(Class.class)) {
                    return false;
                }
            } else if (object instanceof Demangler$Constant) {
                try {
                    Demangler.getTypeClass((Type)object2).cast(((Demangler$Constant)object).value);
                }
                catch (ClassCastException classCastException) {
                    return false;
                }
            }
            ++n5;
        }
        int n7 = n4 = this.paramTypes == null ? 0 : this.paramTypes.length;
        for (n3 = 0; n3 < n4; ++n3) {
            if (n5 >= typeArray.length) {
                return false;
            }
            object2 = this.paramTypes[n3];
            object = typeArray[n5];
            if (!((Demangler$TypeRef)object2).matches((Type)object, Demangler.annotations(annotationArray == null ? null : annotationArray[n3]))) {
                return false;
            }
            ++n5;
        }
        if (n5 != typeArray.length) {
            BridJ.error("Not enough args for " + this);
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.valueType).append(' ');
        boolean bl2 = false;
        if (this.enclosingType != null) {
            stringBuilder.append(this.enclosingType);
            stringBuilder.append('.');
            if (this.memberName instanceof Demangler$SpecialName) {
                switch ((Demangler$SpecialName)this.memberName) {
                    case Destructor: {
                        stringBuilder.append('~');
                    }
                    case Constructor: {
                        stringBuilder.append(((Demangler$ClassRef)this.enclosingType).ident.simpleName);
                        bl2 = true;
                    }
                }
            }
        }
        if (!bl2) {
            stringBuilder.append(this.memberName);
        }
        Demangler.appendTemplateArgs(stringBuilder, this.templateArguments);
        Demangler.appendArgs(stringBuilder, '(', ')', this.paramTypes);
        return stringBuilder.toString();
    }

    public void setMemberName(Demangler$IdentLike demangler$IdentLike) {
        this.memberName = demangler$IdentLike;
    }

    public Demangler$IdentLike getMemberName() {
        return this.memberName;
    }

    public void setValueType(Demangler$TypeRef demangler$TypeRef) {
        this.valueType = demangler$TypeRef;
    }

    public Demangler$TypeRef getValueType() {
        return this.valueType;
    }

    public void setEnclosingType(Demangler$TypeRef demangler$TypeRef) {
        this.enclosingType = demangler$TypeRef;
    }

    public Demangler$TypeRef getEnclosingType() {
        return this.enclosingType;
    }
}

