/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleAttributeAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleEditableTextListener;
import org.eclipse.swt.accessibility.AccessibleTextExtendedAdapter;
import org.eclipse.swt.custom.BidiSegmentListener;
import org.eclipse.swt.custom.Bullet;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.DefaultContent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.MovementListener;
import org.eclipse.swt.custom.PaintObjectListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText$1;
import org.eclipse.swt.custom.StyledText$10;
import org.eclipse.swt.custom.StyledText$2;
import org.eclipse.swt.custom.StyledText$3;
import org.eclipse.swt.custom.StyledText$4;
import org.eclipse.swt.custom.StyledText$5;
import org.eclipse.swt.custom.StyledText$6;
import org.eclipse.swt.custom.StyledText$7;
import org.eclipse.swt.custom.StyledText$8;
import org.eclipse.swt.custom.StyledText$9;
import org.eclipse.swt.custom.StyledText$Printing;
import org.eclipse.swt.custom.StyledText$RTFWriter;
import org.eclipse.swt.custom.StyledText$TextWriter;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.StyledTextDropTargetEffect;
import org.eclipse.swt.custom.StyledTextEvent;
import org.eclipse.swt.custom.StyledTextListener;
import org.eclipse.swt.custom.StyledTextPrintOptions;
import org.eclipse.swt.custom.StyledTextRenderer;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.IME;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TypedListener;

public class StyledText
extends Canvas {
    static final char TAB = '\t';
    static final String PlatformLineDelimiter = System.getProperty("line.separator");
    static final int BIDI_CARET_WIDTH = 3;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final int V_SCROLL_RATE = 50;
    static final int H_SCROLL_RATE = 10;
    static final int PREVIOUS_OFFSET_TRAILING = 0;
    static final int OFFSET_LEADING = 1;
    static final String STYLEDTEXT_KEY = "org.eclipse.swt.internal.cocoa.styledtext";
    Color selectionBackground;
    Color selectionForeground;
    StyledTextContent content;
    StyledTextRenderer renderer;
    Listener listener;
    TextChangeListener textChangeListener;
    int verticalScrollOffset = 0;
    int horizontalScrollOffset = 0;
    boolean alwaysShowScroll = true;
    int ignoreResize = 0;
    int topIndex = 0;
    int topIndexY;
    int clientAreaHeight = 0;
    int clientAreaWidth = 0;
    int tabLength = 4;
    int[] tabs;
    int leftMargin;
    int topMargin;
    int rightMargin;
    int bottomMargin;
    Color marginColor;
    int columnX;
    int caretOffset;
    int caretAlignment;
    Point selection = new Point(0, 0);
    Point clipboardSelection;
    int selectionAnchor;
    Point doubleClickSelection;
    boolean editable = true;
    boolean wordWrap = false;
    boolean visualWrap = false;
    boolean doubleClickEnabled = true;
    boolean overwrite = false;
    int textLimit = -1;
    Map keyActionMap = new HashMap();
    Color background = null;
    Color foreground = null;
    Clipboard clipboard;
    int clickCount;
    int autoScrollDirection = 0;
    int autoScrollDistance = 0;
    int lastTextChangeStart;
    int lastTextChangeNewLineCount;
    int lastTextChangeNewCharCount;
    int lastTextChangeReplaceLineCount;
    int lastTextChangeReplaceCharCount;
    int lastCharCount = 0;
    int lastLineBottom;
    boolean bidiColoring = false;
    Image leftCaretBitmap = null;
    Image rightCaretBitmap = null;
    int caretDirection = 0;
    int caretWidth = 0;
    Caret defaultCaret = null;
    boolean updateCaretDirection = true;
    boolean fixedLineHeight;
    boolean dragDetect = true;
    IME ime;
    Cursor cursor;
    int alignment;
    boolean justify;
    int indent;
    int wrapIndent;
    int lineSpacing;
    int alignmentMargin;
    int newOrientation = 0;
    int accCaretOffset;
    Accessible acc;
    AccessibleControlAdapter accControlAdapter;
    AccessibleAttributeAdapter accAttributeAdapter;
    AccessibleEditableTextListener accEditableTextListener;
    AccessibleTextExtendedAdapter accTextExtendedAdapter;
    AccessibleAdapter accAdapter;
    boolean blockSelection;
    int blockXAnchor = -1;
    int blockYAnchor = -1;
    int blockXLocation = -1;
    int blockYLocation = -1;
    static final boolean IS_MAC;
    static final boolean IS_GTK;

    public StyledText(Composite composite, int n2) {
        super(composite, StyledText.checkStyle(n2));
        super.setForeground(this.getForeground());
        super.setDragDetect(false);
        Display display = this.getDisplay();
        this.fixedLineHeight = true;
        if ((n2 & 8) != 0) {
            this.setEditable(false);
        }
        this.rightMargin = this.isBidiCaret() ? 2 : 0;
        this.leftMargin = this.rightMargin;
        if ((n2 & 4) != 0 && (n2 & 0x800) != 0) {
            this.bottomMargin = 2;
            this.rightMargin = 2;
            this.topMargin = 2;
            this.leftMargin = 2;
        }
        this.alignment = n2 & 0x1024000;
        if (this.alignment == 0) {
            this.alignment = 16384;
        }
        this.clipboard = new Clipboard(display);
        this.installDefaultContent();
        this.renderer = new StyledTextRenderer(this.getDisplay(), this);
        this.renderer.setContent(this.content);
        this.renderer.setFont(this.getFont(), this.tabLength);
        this.ime = new IME(this, 0);
        this.defaultCaret = new Caret(this, 0);
        if ((n2 & 0x40) != 0) {
            this.setWordWrap(true);
        }
        if (this.isBidiCaret()) {
            this.createCaretBitmaps();
            Runnable runnable = () -> {
                int n2;
                int n3 = n2 = BidiUtil.getKeyboardLanguage() == 1 ? 131072 : 16384;
                if (n2 == this.caretDirection) {
                    return;
                }
                if (this.getCaret() != this.defaultCaret) {
                    return;
                }
                Point point = this.getPointAtOffset(this.caretOffset);
                this.setCaretLocation(point, n2);
            };
            BidiUtil.addLanguageListener(this, runnable);
        }
        this.setCaret(this.defaultCaret);
        this.calculateScrollBars();
        this.createKeyBindings();
        super.setCursor(display.getSystemCursor(19));
        this.installListeners();
        this.initializeAccessible();
        this.setData("DEFAULT_DROP_TARGET_EFFECT", new StyledTextDropTargetEffect(this));
        if (IS_MAC) {
            this.setData(STYLEDTEXT_KEY);
        }
    }

    public void addExtendedModifyListener(ExtendedModifyListener extendedModifyListener) {
        this.checkWidget();
        if (extendedModifyListener == null) {
            SWT.error(4);
        }
        StyledTextListener styledTextListener = new StyledTextListener(extendedModifyListener);
        this.addListener(3000, styledTextListener);
    }

    public void addBidiSegmentListener(BidiSegmentListener bidiSegmentListener) {
        this.checkWidget();
        if (bidiSegmentListener == null) {
            SWT.error(4);
        }
        this.addListener(3007, new StyledTextListener(bidiSegmentListener));
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        super.redraw();
    }

    public void addCaretListener(CaretListener caretListener) {
        this.checkWidget();
        if (caretListener == null) {
            SWT.error(4);
        }
        this.addListener(3011, new StyledTextListener(caretListener));
    }

    public void addLineBackgroundListener(LineBackgroundListener lineBackgroundListener) {
        this.checkWidget();
        if (lineBackgroundListener == null) {
            SWT.error(4);
        }
        if (!this.isListening(3001)) {
            this.renderer.clearLineBackground(0, this.content.getLineCount());
        }
        this.addListener(3001, new StyledTextListener(lineBackgroundListener));
    }

    public void addLineStyleListener(LineStyleListener lineStyleListener) {
        this.checkWidget();
        if (lineStyleListener == null) {
            SWT.error(4);
        }
        if (!this.isListening(3002)) {
            this.setStyleRanges(0, 0, null, null, true);
            this.renderer.clearLineStyle(0, this.content.getLineCount());
        }
        this.addListener(3002, new StyledTextListener(lineStyleListener));
        this.setCaretLocation();
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            SWT.error(4);
        }
        this.addListener(24, new TypedListener(modifyListener));
    }

    public void addPaintObjectListener(PaintObjectListener paintObjectListener) {
        this.checkWidget();
        if (paintObjectListener == null) {
            SWT.error(4);
        }
        this.addListener(3008, new StyledTextListener(paintObjectListener));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        this.addListener(13, new TypedListener(selectionListener));
    }

    public void addVerifyKeyListener(VerifyKeyListener verifyKeyListener) {
        this.checkWidget();
        if (verifyKeyListener == null) {
            SWT.error(4);
        }
        this.addListener(3005, new StyledTextListener(verifyKeyListener));
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            SWT.error(4);
        }
        this.addListener(25, new TypedListener(verifyListener));
    }

    public void addWordMovementListener(MovementListener movementListener) {
        this.checkWidget();
        if (movementListener == null) {
            SWT.error(4);
        }
        this.addListener(3009, new StyledTextListener(movementListener));
        this.addListener(3010, new StyledTextListener(movementListener));
    }

    public void append(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        int n2 = Math.max(this.getCharCount(), 0);
        this.replaceTextRange(n2, 0, string);
    }

    void calculateScrollBars() {
        ScrollBar scrollBar = this.getHorizontalBar();
        ScrollBar scrollBar2 = this.getVerticalBar();
        this.setScrollBars(true);
        if (scrollBar2 != null) {
            scrollBar2.setIncrement(this.getVerticalIncrement());
        }
        if (scrollBar != null) {
            scrollBar.setIncrement(this.getHorizontalIncrement());
        }
    }

    void calculateTopIndex(int n2) {
        int n3;
        int n4 = n2;
        int n5 = this.topIndex;
        int n6 = this.topIndexY;
        if (this.isFixedLineHeight()) {
            n3 = this.getVerticalIncrement();
            if (n3 == 0) {
                return;
            }
            this.topIndex = Compatibility.ceil(this.getVerticalScrollOffset(), n3);
            if (this.topIndex > 0) {
                if (this.clientAreaHeight > 0) {
                    int n7;
                    int n8 = this.getVerticalScrollOffset() + this.clientAreaHeight;
                    int n9 = n8 - (n7 = this.topIndex * n3);
                    if (n9 < n3) {
                        this.topIndex = this.getVerticalScrollOffset() / n3;
                    }
                } else if (this.topIndex >= this.content.getLineCount()) {
                    this.topIndex = this.content.getLineCount() - 1;
                }
            }
        } else if (n2 >= 0) {
            n2 -= this.topIndexY;
            n3 = this.topIndex;
            int n10 = this.content.getLineCount();
            while (n3 < n10 && n2 > 0) {
                n2 -= this.renderer.getLineHeight(n3++);
            }
            if (n3 < n10 && -n2 + this.renderer.getLineHeight(n3) <= this.clientAreaHeight - this.topMargin - this.bottomMargin) {
                this.topIndex = n3;
                this.topIndexY = -n2;
            } else {
                this.topIndex = n3 - 1;
                this.topIndexY = -this.renderer.getLineHeight(this.topIndex) - n2;
            }
        } else {
            int n11;
            n2 -= this.topIndexY;
            for (n3 = this.topIndex; n3 > 0 && n2 + (n11 = this.renderer.getLineHeight(n3 - 1)) <= 0; --n3) {
                n2 += n11;
            }
            if (n3 == 0 || -n2 + this.renderer.getLineHeight(n3) <= this.clientAreaHeight - this.topMargin - this.bottomMargin) {
                this.topIndex = n3;
                this.topIndexY = -n2;
            } else {
                this.topIndex = n3 - 1;
                this.topIndexY = -this.renderer.getLineHeight(this.topIndex) - n2;
            }
        }
        if (this.topIndex < 0) {
            System.err.println("StyledText: topIndex was " + this.topIndex + ", isFixedLineHeight() = " + this.isFixedLineHeight() + ", delta = " + n2 + ", content.getLineCount() = " + this.content.getLineCount() + ", clientAreaHeight = " + this.clientAreaHeight + ", oldTopIndex = " + n5 + ", oldTopIndexY = " + n6 + ", getVerticalScrollOffset = " + this.getVerticalScrollOffset() + ", oldDelta = " + n4 + ", getVerticalIncrement() = " + this.getVerticalIncrement());
            this.topIndex = 0;
        }
        if (this.topIndex != n5 || n6 != this.topIndexY) {
            n3 = this.renderer.getWidth();
            this.renderer.calculateClientArea();
            if (n3 != this.renderer.getWidth()) {
                this.setScrollBars(false);
            }
        }
    }

    static int checkStyle(int n2) {
        if ((n2 & 4) != 0) {
            n2 &= 0xFFFFFCBD;
        } else if (((n2 |= 2) & 0x40) != 0) {
            n2 &= 0xFFFFFEFF;
        }
        return (n2 |= 0x20140000) & 0xFEFFFFFF;
    }

    void claimBottomFreeSpace() {
        if (this.ime.getCompositionOffset() != -1) {
            return;
        }
        if (this.isFixedLineHeight()) {
            int n2 = Math.max(0, this.renderer.getHeight() - this.clientAreaHeight);
            if (n2 < this.getVerticalScrollOffset()) {
                this.scrollVertical(n2 - this.getVerticalScrollOffset(), true);
            }
        } else {
            int n3 = this.getPartialBottomIndex();
            int n4 = this.getLinePixel(n3 + 1);
            if (this.clientAreaHeight > n4) {
                this.scrollVertical(-this.getAvailableHeightAbove(this.clientAreaHeight - n4), true);
            }
        }
    }

    void claimRightFreeSpace() {
        int n2 = Math.max(0, this.renderer.getWidth() - this.clientAreaWidth);
        if (n2 < this.horizontalScrollOffset) {
            this.scrollHorizontal(n2 - this.horizontalScrollOffset, true);
        }
    }

    void clearBlockSelection(boolean bl2, boolean bl3) {
        if (bl2) {
            this.resetSelection();
        }
        this.blockYAnchor = -1;
        this.blockXAnchor = -1;
        this.blockYLocation = -1;
        this.blockXLocation = -1;
        this.caretDirection = 0;
        this.updateCaretVisibility();
        super.redraw();
        if (bl3) {
            this.sendSelectionEvent();
        }
    }

    void clearSelection(boolean bl2) {
        int n2 = this.selection.x;
        int n3 = this.selection.y;
        this.resetSelection();
        if (n3 - n2 > 0) {
            int n4 = this.content.getCharCount();
            int n5 = Math.min(n2, n4);
            int n6 = Math.min(n3, n4);
            if (n6 - n5 > 0) {
                this.internalRedrawRange(n5, n6 - n5);
            }
            if (bl2) {
                this.sendSelectionEvent();
            }
        }
    }

    @Override
    public Point computeSize(int n2, int n3, boolean bl2) {
        int n4;
        this.checkWidget();
        int n5 = (this.getStyle() & 4) != 0 ? 1 : this.content.getLineCount();
        int n6 = 0;
        int n7 = 0;
        if (n2 == -1 || n3 == -1) {
            Display display = this.getDisplay();
            n4 = display.getClientArea().height;
            for (int i2 = 0; i2 < n5; ++i2) {
                TextLayout textLayout = this.renderer.getTextLayout(i2);
                int n8 = textLayout.getWidth();
                if (this.wordWrap) {
                    textLayout.setWidth(n2 == 0 ? 1 : (n2 == -1 ? -1 : Math.max(1, n2 - this.leftMargin - this.rightMargin)));
                }
                Rectangle rectangle = textLayout.getBounds();
                n6 = Math.max(n6, rectangle.width);
                textLayout.setWidth(n8);
                this.renderer.disposeTextLayout(textLayout);
                if (this.isFixedLineHeight() && (n7 += rectangle.height) > n4) break;
            }
            if (this.isFixedLineHeight()) {
                n7 = n5 * this.renderer.getLineHeight();
            }
        }
        if (n6 == 0) {
            n6 = 64;
        }
        if (n7 == 0) {
            n7 = 64;
        }
        if (n2 != -1) {
            n6 = n2;
        }
        if (n3 != -1) {
            n7 = n3;
        }
        int n9 = this.getLeftMargin() + this.rightMargin + this.getCaretWidth();
        n4 = this.topMargin + this.bottomMargin;
        Rectangle rectangle = this.computeTrim(0, 0, n6 + n9, n7 + n4);
        return new Point(rectangle.width, rectangle.height);
    }

    public void copy() {
        this.checkWidget();
        this.copySelection(1);
    }

    public void copy(int n2) {
        this.checkWidget();
        this.copySelection(n2);
    }

    boolean copySelection(int n2) {
        block7: {
            if (n2 != 1 && n2 != 2) {
                return false;
            }
            try {
                if (this.blockSelection && this.blockXLocation != -1) {
                    String string = this.getBlockSelectionText(PlatformLineDelimiter);
                    if (string.length() > 0) {
                        TextTransfer textTransfer = TextTransfer.getInstance();
                        Object[] objectArray = new Object[]{string};
                        Transfer[] transferArray = new Transfer[]{textTransfer};
                        this.clipboard.setContents(objectArray, transferArray, n2);
                        return true;
                    }
                } else {
                    int n3 = this.selection.y - this.selection.x;
                    if (n3 > 0) {
                        this.setClipboardContent(this.selection.x, n3, n2);
                        return true;
                    }
                }
            }
            catch (SWTError sWTError) {
                if (sWTError.code == 2002) break block7;
                throw sWTError;
            }
        }
        return false;
    }

    public int getAlignment() {
        this.checkWidget();
        return this.alignment;
    }

    public boolean getAlwaysShowScrollBars() {
        this.checkWidget();
        return this.alwaysShowScroll;
    }

    int getAvailableHeightAbove(int n2) {
        int n3 = this.verticalScrollOffset;
        if (n3 == -1) {
            int n4 = this.topIndex - 1;
            n3 = -this.topIndexY;
            if (this.topIndexY > 0) {
                n3 += this.renderer.getLineHeight(n4--);
            }
            while (n2 > n3 && n4 >= 0) {
                n3 += this.renderer.getLineHeight(n4--);
            }
        }
        return Math.min(n2, n3);
    }

    int getAvailableHeightBellow(int n2) {
        int n3 = this.getPartialBottomIndex();
        int n4 = this.getLinePixel(n3);
        int n5 = this.renderer.getLineHeight(n3);
        int n6 = 0;
        int n7 = this.clientAreaHeight - this.topMargin - this.bottomMargin;
        if (n4 + n5 > n7) {
            n6 = n5 - (n7 - n4);
        }
        int n8 = n3 + 1;
        int n9 = this.content.getLineCount();
        while (n2 > n6 && n8 < n9) {
            n6 += this.renderer.getLineHeight(n8++);
        }
        return Math.min(n2, n6);
    }

    public Color getMarginColor() {
        this.checkWidget();
        return this.marginColor != null ? this.marginColor : this.getBackground();
    }

    String getModelDelimitedText(String string) {
        int n2 = string.length();
        if (n2 == 0) {
            return string;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        StringBuffer stringBuffer = new StringBuffer(n2);
        String string2 = this.getLineDelimiter();
        while (n5 < n2) {
            if (n3 != -1) {
                n3 = string.indexOf(13, n5);
            }
            if (n4 != -1) {
                n4 = string.indexOf(10, n5);
            }
            if (n4 == -1 && n3 == -1) break;
            if (n3 < n4 && n3 != -1 || n4 == -1) {
                stringBuffer.append(string.substring(n5, n3));
                n5 = n4 == n3 + 1 ? n4 + 1 : n3 + 1;
            } else {
                stringBuffer.append(string.substring(n5, n4));
                n5 = n4 + 1;
            }
            if (this.isSingleLine()) break;
            stringBuffer.append(string2);
        }
        if (!(n5 >= n2 || this.isSingleLine() && stringBuffer.length() != 0)) {
            stringBuffer.append(string.substring(n5));
        }
        return stringBuffer.toString();
    }

    boolean checkDragDetect(Event event) {
        if (!this.isListening(29)) {
            return false;
        }
        if (event.button != 1) {
            return false;
        }
        if (this.blockSelection && this.blockXLocation != -1) {
            Rectangle rectangle = this.getBlockSelectionRectangle();
            if (rectangle.contains(event.x, event.y)) {
                return this.dragDetect(event);
            }
        } else {
            if (this.selection.x == this.selection.y) {
                return false;
            }
            int n2 = this.getOffsetAtPoint(event.x, event.y, null, true);
            if (this.selection.x <= n2 && n2 < this.selection.y) {
                return this.dragDetect(event);
            }
        }
        return false;
    }

    void createKeyBindings() {
        int n2 = this.isMirrored() ? 0x1000003 : 0x1000004;
        int n3 = this.isMirrored() ? 0x1000004 : 0x1000003;
        this.setKeyBinding(0x1000001, 0x1000001);
        this.setKeyBinding(0x1000002, 0x1000002);
        if (IS_MAC) {
            this.setKeyBinding(n3 | SWT.MOD1, 0x1000007);
            this.setKeyBinding(n2 | SWT.MOD1, 0x1000008);
            this.setKeyBinding(0x1000007, 17039367);
            this.setKeyBinding(0x1000008, 17039368);
            this.setKeyBinding(0x1000001 | SWT.MOD1, 17039367);
            this.setKeyBinding(0x1000002 | SWT.MOD1, 17039368);
            this.setKeyBinding(n2 | SWT.MOD3, 0x1040004);
            this.setKeyBinding(n3 | SWT.MOD3, 17039363);
        } else {
            this.setKeyBinding(0x1000007, 0x1000007);
            this.setKeyBinding(0x1000008, 0x1000008);
            this.setKeyBinding(0x1000007 | SWT.MOD1, 17039367);
            this.setKeyBinding(0x1000008 | SWT.MOD1, 17039368);
            this.setKeyBinding(n2 | SWT.MOD1, 0x1040004);
            this.setKeyBinding(n3 | SWT.MOD1, 17039363);
        }
        this.setKeyBinding(0x1000005, 0x1000005);
        this.setKeyBinding(0x1000006, 0x1000006);
        this.setKeyBinding(0x1000005 | SWT.MOD1, 17039365);
        this.setKeyBinding(0x1000006 | SWT.MOD1, 17039366);
        this.setKeyBinding(n2, 0x1000004);
        this.setKeyBinding(n3, 0x1000003);
        this.setKeyBinding(0x1000001 | SWT.MOD2, 0x1020001);
        this.setKeyBinding(0x1000002 | SWT.MOD2, 0x1020002);
        if (IS_MAC) {
            this.setKeyBinding(n3 | SWT.MOD1 | SWT.MOD2, 16908295);
            this.setKeyBinding(n2 | SWT.MOD1 | SWT.MOD2, 16908296);
            this.setKeyBinding(0x1000007 | SWT.MOD2, 17170439);
            this.setKeyBinding(0x1000008 | SWT.MOD2, 17170440);
            this.setKeyBinding(0x1000001 | SWT.MOD1 | SWT.MOD2, 17170439);
            this.setKeyBinding(0x1000002 | SWT.MOD1 | SWT.MOD2, 17170440);
            this.setKeyBinding(n2 | SWT.MOD2 | SWT.MOD3, 17170436);
            this.setKeyBinding(n3 | SWT.MOD2 | SWT.MOD3, 17170435);
        } else {
            this.setKeyBinding(0x1000007 | SWT.MOD2, 16908295);
            this.setKeyBinding(0x1000008 | SWT.MOD2, 16908296);
            this.setKeyBinding(0x1000007 | SWT.MOD1 | SWT.MOD2, 17170439);
            this.setKeyBinding(0x1000008 | SWT.MOD1 | SWT.MOD2, 17170440);
            this.setKeyBinding(n2 | SWT.MOD1 | SWT.MOD2, 17170436);
            this.setKeyBinding(n3 | SWT.MOD1 | SWT.MOD2, 17170435);
        }
        this.setKeyBinding(0x1000005 | SWT.MOD2, 16908293);
        this.setKeyBinding(0x1000006 | SWT.MOD2, 16908294);
        this.setKeyBinding(0x1000005 | SWT.MOD1 | SWT.MOD2, 17170437);
        this.setKeyBinding(0x1000006 | SWT.MOD1 | SWT.MOD2, 0x1060006);
        this.setKeyBinding(n2 | SWT.MOD2, 16908292);
        this.setKeyBinding(n3 | SWT.MOD2, 16908291);
        this.setKeyBinding(0x58 | SWT.MOD1, 131199);
        this.setKeyBinding(0x43 | SWT.MOD1, 17039369);
        this.setKeyBinding(0x56 | SWT.MOD1, 16908297);
        if (IS_MAC) {
            this.setKeyBinding(0x7F | SWT.MOD2, 127);
            this.setKeyBinding(8 | SWT.MOD3, 262152);
            this.setKeyBinding(0x7F | SWT.MOD3, 262271);
        } else {
            this.setKeyBinding(0x7F | SWT.MOD2, 131199);
            this.setKeyBinding(0x1000009 | SWT.MOD1, 17039369);
            this.setKeyBinding(0x1000009 | SWT.MOD2, 16908297);
        }
        this.setKeyBinding(8 | SWT.MOD2, 8);
        this.setKeyBinding(8, 8);
        this.setKeyBinding(127, 127);
        this.setKeyBinding(8 | SWT.MOD1, 262152);
        this.setKeyBinding(0x7F | SWT.MOD1, 262271);
        this.setKeyBinding(0x1000009, 0x1000009);
    }

    void createCaretBitmaps() {
        int n2 = 3;
        Display display = this.getDisplay();
        if (this.leftCaretBitmap != null) {
            if (this.defaultCaret != null && this.leftCaretBitmap.equals(this.defaultCaret.getImage())) {
                this.defaultCaret.setImage(null);
            }
            this.leftCaretBitmap.dispose();
        }
        int n3 = this.renderer.getLineHeight();
        this.leftCaretBitmap = new Image((Device)display, n2, n3);
        GC gC = new GC(this.leftCaretBitmap);
        gC.setBackground(display.getSystemColor(2));
        gC.fillRectangle(0, 0, n2, n3);
        gC.setForeground(display.getSystemColor(1));
        gC.drawLine(0, 0, 0, n3);
        gC.drawLine(0, 0, n2 - 1, 0);
        gC.drawLine(0, 1, 1, 1);
        gC.dispose();
        if (this.rightCaretBitmap != null) {
            if (this.defaultCaret != null && this.rightCaretBitmap.equals(this.defaultCaret.getImage())) {
                this.defaultCaret.setImage(null);
            }
            this.rightCaretBitmap.dispose();
        }
        this.rightCaretBitmap = new Image((Device)display, n2, n3);
        gC = new GC(this.rightCaretBitmap);
        gC.setBackground(display.getSystemColor(2));
        gC.fillRectangle(0, 0, n2, n3);
        gC.setForeground(display.getSystemColor(1));
        gC.drawLine(n2 - 1, 0, n2 - 1, n3);
        gC.drawLine(0, 0, n2 - 1, 0);
        gC.drawLine(n2 - 1, 1, 1, 1);
        gC.dispose();
    }

    public void cut() {
        this.checkWidget();
        if (this.copySelection(1)) {
            if (this.blockSelection && this.blockXLocation != -1) {
                this.insertBlockSelectionText('\u0000', 0);
            } else {
                this.doDelete();
            }
        }
    }

    void doAutoScroll(Event event) {
        int n2 = this.getCaretLine();
        if (event.y > this.clientAreaHeight - this.bottomMargin && n2 != this.content.getLineCount() - 1) {
            this.doAutoScroll(1024, event.y - (this.clientAreaHeight - this.bottomMargin));
        } else if (event.y < this.topMargin && n2 != 0) {
            this.doAutoScroll(128, this.topMargin - event.y);
        } else if (event.x < this.leftMargin && !this.wordWrap) {
            this.doAutoScroll(0x1000003, this.leftMargin - event.x);
        } else if (event.x > this.clientAreaWidth - this.rightMargin && !this.wordWrap) {
            this.doAutoScroll(0x1000004, event.x - (this.clientAreaWidth - this.rightMargin));
        } else {
            this.endAutoScroll();
        }
    }

    void doAutoScroll(int n2, int n3) {
        this.autoScrollDistance = n3;
        if (this.autoScrollDirection == n2) {
            return;
        }
        Runnable runnable = null;
        Display display = this.getDisplay();
        if (n2 == 128) {
            runnable = new StyledText$1(this, display);
            this.autoScrollDirection = n2;
            display.timerExec(50, runnable);
        } else if (n2 == 1024) {
            runnable = new StyledText$2(this, display);
            this.autoScrollDirection = n2;
            display.timerExec(50, runnable);
        } else if (n2 == 0x1000004) {
            runnable = new StyledText$3(this, display);
            this.autoScrollDirection = n2;
            display.timerExec(10, runnable);
        } else if (n2 == 0x1000003) {
            runnable = new StyledText$4(this, display);
            this.autoScrollDirection = n2;
            display.timerExec(10, runnable);
        }
    }

    void doBackspace() {
        Event event = new Event();
        event.text = "";
        if (this.selection.x != this.selection.y) {
            event.start = this.selection.x;
            event.end = this.selection.y;
            this.sendKeyEvent(event);
        } else if (this.caretOffset > 0) {
            int n2 = this.content.getLineAtOffset(this.caretOffset);
            int n3 = this.content.getOffsetAtLine(n2);
            if (this.caretOffset == n3) {
                n3 = this.content.getOffsetAtLine(n2 - 1);
                event.start = n3 + this.content.getLine(n2 - 1).length();
                event.end = this.caretOffset;
            } else {
                boolean bl2 = false;
                String string = this.content.getLine(n2);
                char c2 = string.charAt(this.caretOffset - n3 - 1);
                if ('\udc00' <= c2 && c2 <= '\udfff' && this.caretOffset - n3 - 2 >= 0) {
                    c2 = string.charAt(this.caretOffset - n3 - 2);
                    bl2 = '\ud800' <= c2 && c2 <= '\udbff';
                }
                TextLayout textLayout = this.renderer.getTextLayout(n2);
                int n4 = textLayout.getPreviousOffset(this.caretOffset - n3, bl2 ? 2 : 1);
                this.renderer.disposeTextLayout(textLayout);
                event.start = n4 + n3;
                event.end = this.caretOffset;
            }
            this.sendKeyEvent(event);
        }
    }

    void doBlockColumn(boolean bl2) {
        int n2;
        int n3;
        int[] nArray;
        int n4;
        int n5;
        int n6;
        if (this.blockXLocation == -1) {
            this.setBlockSelectionOffset(this.caretOffset, false);
        }
        if ((n6 = this.getOffsetAtPoint(n5 = this.blockXLocation - this.horizontalScrollOffset, n4 = this.blockYLocation - this.getVerticalScrollOffset(), nArray = new int[1], true)) != -1) {
            n3 = this.content.getLineAtOffset(n6 += nArray[0]);
            n2 = bl2 ? this.getClusterNext(n6, n3) : this.getClusterPrevious(n6, n3);
            int n7 = n6 = n2 != n6 ? n2 : -1;
        }
        if (n6 != -1) {
            this.setBlockSelectionOffset(n6, true);
            this.showCaret();
        } else {
            n3 = bl2 ? this.renderer.averageCharWidth : -this.renderer.averageCharWidth;
            n2 = Math.max(this.clientAreaWidth - this.rightMargin - this.leftMargin, this.renderer.getWidth());
            n5 = Math.max(0, Math.min(this.blockXLocation + n3, n2)) - this.horizontalScrollOffset;
            this.setBlockSelectionLocation(n5, n4, true);
            Rectangle rectangle = new Rectangle(n5, n4, 0, 0);
            this.showLocation(rectangle, true);
        }
    }

    void doBlockContentStartEnd(boolean bl2) {
        if (this.blockXLocation == -1) {
            this.setBlockSelectionOffset(this.caretOffset, false);
        }
        int n2 = bl2 ? this.content.getCharCount() : 0;
        this.setBlockSelectionOffset(n2, true);
        this.showCaret();
    }

    void doBlockWord(boolean bl2) {
        Object object;
        int n2;
        int n3;
        int[] nArray;
        int n4;
        int n5;
        int n6;
        if (this.blockXLocation == -1) {
            this.setBlockSelectionOffset(this.caretOffset, false);
        }
        if ((n6 = this.getOffsetAtPoint(n5 = this.blockXLocation - this.horizontalScrollOffset, n4 = this.blockYLocation - this.getVerticalScrollOffset(), nArray = new int[1], true)) != -1) {
            n3 = this.content.getLineAtOffset(n6 += nArray[0]);
            n2 = this.content.getOffsetAtLine(n3);
            object = this.content.getLine(n3);
            int n7 = ((String)object).length();
            int n8 = n6;
            if (bl2) {
                if (n6 < n2 + n7) {
                    n8 = this.getWordNext(n6, 4);
                }
            } else if (n6 > n2) {
                n8 = this.getWordPrevious(n6, 4);
            }
            int n9 = n6 = n8 != n6 ? n8 : -1;
        }
        if (n6 != -1) {
            this.setBlockSelectionOffset(n6, true);
            this.showCaret();
        } else {
            n3 = (bl2 ? this.renderer.averageCharWidth : -this.renderer.averageCharWidth) * 6;
            n2 = Math.max(this.clientAreaWidth - this.rightMargin - this.leftMargin, this.renderer.getWidth());
            n5 = Math.max(0, Math.min(this.blockXLocation + n3, n2)) - this.horizontalScrollOffset;
            this.setBlockSelectionLocation(n5, n4, true);
            object = new Rectangle(n5, n4, 0, 0);
            this.showLocation((Rectangle)object, true);
        }
    }

    void doBlockLineVertical(boolean bl2) {
        if (this.blockXLocation == -1) {
            this.setBlockSelectionOffset(this.caretOffset, false);
        }
        int n2 = this.blockYLocation - this.getVerticalScrollOffset();
        int n3 = this.getLineIndex(n2);
        if (bl2) {
            if (n3 > 0) {
                n2 = this.getLinePixel(n3 - 1);
                this.setBlockSelectionLocation(this.blockXLocation - this.horizontalScrollOffset, n2, true);
                if (n2 < this.topMargin) {
                    this.scrollVertical(n2 - this.topMargin, true);
                }
            }
        } else {
            int n4 = this.content.getLineCount();
            if (n3 + 1 < n4) {
                n2 = this.getLinePixel(n3 + 2) - 1;
                this.setBlockSelectionLocation(this.blockXLocation - this.horizontalScrollOffset, n2, true);
                int n5 = this.clientAreaHeight - this.bottomMargin;
                if (n2 > n5) {
                    this.scrollVertical(n2 - n5, true);
                }
            }
        }
    }

    void doBlockLineHorizontal(boolean bl2) {
        int n2;
        if (this.blockXLocation == -1) {
            this.setBlockSelectionOffset(this.caretOffset, false);
        }
        int n3 = this.blockXLocation - this.horizontalScrollOffset;
        int n4 = this.blockYLocation - this.getVerticalScrollOffset();
        int n5 = this.getLineIndex(n4);
        int n6 = this.content.getOffsetAtLine(n5);
        String string = this.content.getLine(n5);
        int n7 = string.length();
        int[] nArray = new int[1];
        int n8 = this.getOffsetAtPoint(n3, n4, nArray, true);
        if (n8 != -1) {
            n2 = n8 += nArray[0];
            if (bl2) {
                if (n8 < n6 + n7) {
                    n2 = n6 + n7;
                }
            } else if (n8 > n6) {
                n2 = n6;
            }
            n8 = n2 != n8 ? n2 : -1;
        } else if (!bl2) {
            n8 = n6 + n7;
        }
        if (n8 != -1) {
            this.setBlockSelectionOffset(n8, true);
            this.showCaret();
        } else {
            n2 = Math.max(this.clientAreaWidth - this.rightMargin - this.leftMargin, this.renderer.getWidth());
            n3 = (bl2 ? n2 : 0) - this.horizontalScrollOffset;
            this.setBlockSelectionLocation(n3, n4, true);
            Rectangle rectangle = new Rectangle(n3, n4, 0, 0);
            this.showLocation(rectangle, true);
        }
    }

    void doBlockSelection(boolean bl2) {
        if (this.caretOffset > this.selectionAnchor) {
            this.selection.x = this.selectionAnchor;
            this.selection.y = this.caretOffset;
        } else {
            this.selection.x = this.caretOffset;
            this.selection.y = this.selectionAnchor;
        }
        this.updateCaretVisibility();
        this.setCaretLocation();
        super.redraw();
        if (bl2) {
            this.sendSelectionEvent();
        }
        this.sendAccessibleTextCaretMoved();
    }

    void doContent(char c2) {
        if (this.blockSelection && this.blockXLocation != -1) {
            this.insertBlockSelectionText(c2, 0);
            return;
        }
        Event event = new Event();
        event.start = this.selection.x;
        event.end = this.selection.y;
        if (c2 == '\r' || c2 == '\n') {
            if (!this.isSingleLine()) {
                event.text = this.getLineDelimiter();
            }
        } else if (this.selection.x == this.selection.y && this.overwrite && c2 != '\t') {
            String string;
            int n2 = this.content.getLineAtOffset(event.end);
            int n3 = this.content.getOffsetAtLine(n2);
            if (event.end < n3 + (string = this.content.getLine(n2)).length()) {
                ++event.end;
            }
            event.text = new String(new char[]{c2});
        } else {
            event.text = new String(new char[]{c2});
        }
        if (event.text != null) {
            if (this.textLimit > 0 && this.content.getCharCount() - (event.end - event.start) >= this.textLimit) {
                return;
            }
            this.sendKeyEvent(event);
        }
    }

    void doContentEnd() {
        if (this.isSingleLine()) {
            this.doLineEnd();
        } else {
            int n2 = this.content.getCharCount();
            this.setCaretOffset(n2, -1);
            this.showCaret();
        }
    }

    void doContentStart() {
        this.setCaretOffset(0, -1);
        this.showCaret();
    }

    void doCursorPrevious() {
        if (this.selection.y - this.selection.x > 0) {
            this.setCaretOffset(this.selection.x, 1);
            this.showCaret();
        } else {
            this.doSelectionCursorPrevious();
        }
    }

    void doCursorNext() {
        if (this.selection.y - this.selection.x > 0) {
            this.setCaretOffset(this.selection.y, 0);
            this.showCaret();
        } else {
            this.doSelectionCursorNext();
        }
    }

    void doDelete() {
        Event event = new Event();
        event.text = "";
        if (this.selection.x != this.selection.y) {
            event.start = this.selection.x;
            event.end = this.selection.y;
            this.sendKeyEvent(event);
        } else if (this.caretOffset < this.content.getCharCount()) {
            int n2;
            int n3 = this.content.getLineAtOffset(this.caretOffset);
            int n4 = this.content.getOffsetAtLine(n3);
            if (this.caretOffset == n4 + (n2 = this.content.getLine(n3).length())) {
                event.start = this.caretOffset;
                event.end = this.content.getOffsetAtLine(n3 + 1);
            } else {
                event.start = this.caretOffset;
                event.end = this.getClusterNext(this.caretOffset, n3);
            }
            this.sendKeyEvent(event);
        }
    }

    void doDeleteWordNext() {
        if (this.selection.x != this.selection.y) {
            this.doDelete();
        } else {
            Event event = new Event();
            event.text = "";
            event.start = this.caretOffset;
            event.end = this.getWordNext(this.caretOffset, 4);
            this.sendKeyEvent(event);
        }
    }

    void doDeleteWordPrevious() {
        if (this.selection.x != this.selection.y) {
            this.doBackspace();
        } else {
            Event event = new Event();
            event.text = "";
            event.start = this.getWordPrevious(this.caretOffset, 4);
            event.end = this.caretOffset;
            this.sendKeyEvent(event);
        }
    }

    void doLineDown(boolean bl2) {
        int n2;
        int n3;
        int n4 = this.getCaretLine();
        int n5 = this.content.getLineCount();
        int n6 = 0;
        boolean bl3 = false;
        if (this.wordWrap || this.visualWrap) {
            int n7;
            n3 = this.content.getOffsetAtLine(n4);
            n2 = this.caretOffset - n3;
            TextLayout textLayout = this.renderer.getTextLayout(n4);
            int n8 = this.getVisualLineIndex(textLayout, n2);
            if (n8 == (n7 = textLayout.getLineCount()) - 1) {
                bl3 = n4 == n5 - 1;
                ++n4;
            } else {
                n6 = textLayout.getLineBounds((int)(n8 + 1)).y;
                ++n6;
            }
            this.renderer.disposeTextLayout(textLayout);
        } else {
            bl3 = n4 == n5 - 1;
            ++n4;
        }
        if (bl3) {
            this.setCaretOffset(this.content.getCharCount(), -1);
        } else {
            int[] nArray = new int[1];
            n2 = this.getOffsetAtPoint(this.columnX, n6, n4, nArray);
            this.setCaretOffset(n2, nArray[0]);
        }
        n3 = this.columnX;
        n2 = this.horizontalScrollOffset;
        if (bl2) {
            this.setMouseWordSelectionAnchor();
            this.doSelection(0x1000004);
        }
        this.showCaret();
        int n9 = n2 - this.horizontalScrollOffset;
        this.columnX = n3 + n9;
    }

    void doLineEnd() {
        int n2;
        int n3 = this.getCaretLine();
        int n4 = this.content.getOffsetAtLine(n3);
        if (this.wordWrap || this.visualWrap) {
            TextLayout textLayout = this.renderer.getTextLayout(n3);
            int n5 = this.caretOffset - n4;
            int n6 = this.getVisualLineIndex(textLayout, n5);
            int[] nArray = textLayout.getLineOffsets();
            n2 = n4 + nArray[n6 + 1];
            this.renderer.disposeTextLayout(textLayout);
        } else {
            int n7 = this.content.getLine(n3).length();
            n2 = n4 + n7;
        }
        this.setCaretOffset(n2, 0);
        this.showCaret();
    }

    void doLineStart() {
        int n2 = this.getCaretLine();
        int n3 = this.content.getOffsetAtLine(n2);
        if (this.wordWrap || this.visualWrap) {
            TextLayout textLayout = this.renderer.getTextLayout(n2);
            int n4 = this.caretOffset - n3;
            int n5 = this.getVisualLineIndex(textLayout, n4);
            int[] nArray = textLayout.getLineOffsets();
            n3 += nArray[n5];
            this.renderer.disposeTextLayout(textLayout);
        }
        this.setCaretOffset(n3, 1);
        this.showCaret();
    }

    void doLineUp(boolean bl2) {
        int n2;
        int n3;
        int n4 = this.getCaretLine();
        int n5 = 0;
        boolean bl3 = false;
        if (this.wordWrap || this.visualWrap) {
            n3 = this.content.getOffsetAtLine(n4);
            n2 = this.caretOffset - n3;
            TextLayout textLayout = this.renderer.getTextLayout(n4);
            int n6 = this.getVisualLineIndex(textLayout, n2);
            if (n6 == 0) {
                boolean bl4 = bl3 = n4 == 0;
                if (!bl3) {
                    n5 = this.renderer.getLineHeight(--n4) - 1;
                    --n5;
                }
            } else {
                n5 = textLayout.getLineBounds((int)(n6 - 1)).y;
                ++n5;
            }
            this.renderer.disposeTextLayout(textLayout);
        } else {
            bl3 = n4 == 0;
            --n4;
        }
        if (bl3) {
            this.setCaretOffset(0, -1);
        } else {
            int[] nArray = new int[1];
            n2 = this.getOffsetAtPoint(this.columnX, n5, n4, nArray);
            this.setCaretOffset(n2, nArray[0]);
        }
        n3 = this.columnX;
        n2 = this.horizontalScrollOffset;
        if (bl2) {
            this.setMouseWordSelectionAnchor();
        }
        this.showCaret();
        if (bl2) {
            this.doSelection(0x1000003);
        }
        int n7 = n2 - this.horizontalScrollOffset;
        this.columnX = n3 + n7;
    }

    void doMouseLinkCursor() {
        Display display = this.getDisplay();
        Point point = display.getCursorLocation();
        point = display.map(null, (Control)this, point);
        this.doMouseLinkCursor(point.x, point.y);
    }

    void doMouseLinkCursor(int n2, int n3) {
        int n4 = this.getOffsetAtPoint(n2, n3, null, true);
        Display display = this.getDisplay();
        Cursor cursor = this.cursor;
        if (this.renderer.hasLink(n4)) {
            cursor = display.getSystemCursor(21);
        } else if (this.cursor == null) {
            int n5 = this.blockSelection ? 2 : 19;
            cursor = display.getSystemCursor(n5);
        }
        if (cursor != this.getCursor()) {
            super.setCursor(cursor);
        }
    }

    void doMouseLocationChange(int n2, int n3, boolean bl2) {
        boolean bl3;
        int[] nArray;
        int n4;
        int n5 = this.getLineIndex(n3);
        this.updateCaretDirection = true;
        if (this.blockSelection) {
            n2 = Math.max(this.leftMargin, Math.min(n2, this.clientAreaWidth - this.rightMargin));
            n3 = Math.max(this.topMargin, Math.min(n3, this.clientAreaHeight - this.bottomMargin));
            if (this.doubleClickEnabled && this.clickCount > 1) {
                boolean bl4;
                boolean bl5 = bl4 = (this.clickCount & 1) == 0;
                if (bl4) {
                    Point point = this.getPointAtOffset(this.doubleClickSelection.x);
                    int[] nArray2 = new int[1];
                    int n6 = this.getOffsetAtPoint(n2, n3, nArray2, true);
                    if (n6 != -1) {
                        if (n2 > point.x) {
                            n6 = this.getWordNext(n6 + nArray2[0], 8);
                            this.setBlockSelectionOffset(this.doubleClickSelection.x, n6, true);
                        } else {
                            n6 = this.getWordPrevious(n6 + nArray2[0], 16);
                            this.setBlockSelectionOffset(this.doubleClickSelection.y, n6, true);
                        }
                    } else if (n2 > point.x) {
                        this.setBlockSelectionLocation(point.x, point.y, n2, n3, true);
                    } else {
                        Point point2 = this.getPointAtOffset(this.doubleClickSelection.y);
                        this.setBlockSelectionLocation(point2.x, point2.y, n2, n3, true);
                    }
                } else {
                    this.setBlockSelectionLocation(this.blockXLocation, n3, true);
                }
                return;
            }
            if (bl2) {
                if (this.blockXLocation == -1) {
                    this.setBlockSelectionOffset(this.caretOffset, false);
                }
            } else {
                this.clearBlockSelection(true, false);
            }
            if ((n4 = this.getOffsetAtPoint(n2, n3, nArray = new int[1], true)) != -1) {
                if (bl2) {
                    this.setBlockSelectionOffset(n4 + nArray[0], true);
                    return;
                }
            } else {
                if (this.isFixedLineHeight() && this.renderer.fixedPitch) {
                    int n7 = this.renderer.averageCharWidth;
                    n2 = (n2 + n7 / 2 - this.leftMargin + this.horizontalScrollOffset) / n7 * n7 + this.leftMargin - this.horizontalScrollOffset;
                }
                this.setBlockSelectionLocation(n2, n3, true);
                return;
            }
        }
        if (n5 < 0 || this.isSingleLine() && n5 > 0) {
            return;
        }
        nArray = new int[1];
        n4 = this.getOffsetAtPoint(n2, n3, nArray);
        int n8 = nArray[0];
        if (this.doubleClickEnabled && this.clickCount > 1) {
            n4 = this.doMouseWordSelect(n2, n4, n5);
        }
        int n9 = this.content.getLineAtOffset(n4);
        boolean bl6 = 0 <= n3 && n3 < this.clientAreaHeight || n9 == 0 || n9 == this.content.getLineCount() - 1;
        boolean bl7 = bl3 = 0 <= n2 && n2 < this.clientAreaWidth || this.wordWrap || n9 != this.content.getLineAtOffset(this.caretOffset);
        if (bl6 && bl3 && (n4 != this.caretOffset || n8 != this.caretAlignment)) {
            this.setCaretOffset(n4, n8);
            if (bl2) {
                this.doMouseSelection();
            }
            this.showCaret();
        }
        if (!bl2) {
            this.setCaretOffset(n4, n8);
            this.clearSelection(true);
        }
    }

    void doMouseSelection() {
        if (this.caretOffset <= this.selection.x || this.caretOffset > this.selection.x && this.caretOffset < this.selection.y && this.selectionAnchor == this.selection.x) {
            this.doSelection(0x1000003);
        } else {
            this.doSelection(0x1000004);
        }
    }

    int doMouseWordSelect(int n2, int n3, int n4) {
        if (n3 < this.selectionAnchor && this.selectionAnchor == this.selection.x) {
            this.selectionAnchor = this.doubleClickSelection.y;
        } else if (n3 > this.selectionAnchor && this.selectionAnchor == this.selection.y) {
            this.selectionAnchor = this.doubleClickSelection.x;
        }
        if (0 <= n2 && n2 < this.clientAreaWidth) {
            boolean bl2;
            boolean bl3 = bl2 = (this.clickCount & 1) == 0;
            if (this.caretOffset == this.selection.x) {
                n3 = bl2 ? this.getWordPrevious(n3, 16) : this.content.getOffsetAtLine(n4);
            } else if (bl2) {
                n3 = this.getWordNext(n3, 8);
            } else {
                int n5 = this.content.getCharCount();
                if (n4 + 1 < this.content.getLineCount()) {
                    n5 = this.content.getOffsetAtLine(n4 + 1);
                }
                n3 = n5;
            }
        }
        return n3;
    }

    void doPageDown(boolean bl2, int n2) {
        int n3;
        if (this.isSingleLine()) {
            return;
        }
        int n4 = this.columnX;
        int n5 = this.horizontalScrollOffset;
        if (this.isFixedLineHeight()) {
            n3 = this.content.getLineCount();
            int n6 = this.getCaretLine();
            if (n6 < n3 - 1) {
                int n7 = this.renderer.getLineHeight();
                int n8 = (n2 == -1 ? this.clientAreaHeight : n2) / n7;
                int n9 = Math.min(n3 - n6 - 1, n8);
                n9 = Math.max(1, n9);
                int[] nArray = new int[1];
                int n10 = this.getOffsetAtPoint(this.columnX, this.getLinePixel(n6 + n9), nArray);
                this.setCaretOffset(n10, nArray[0]);
                if (bl2) {
                    this.doSelection(0x1000004);
                }
                int n11 = n3 * this.getVerticalIncrement();
                int n12 = this.clientAreaHeight;
                int n13 = this.getVerticalScrollOffset();
                int n14 = n13 + n9 * this.getVerticalIncrement();
                if (n14 + n12 > n11) {
                    n14 = n11 - n12;
                }
                if (n14 > n13) {
                    this.scrollVertical(n14 - n13, true);
                }
            }
        } else {
            Rectangle rectangle;
            int n15;
            int n16;
            Object object;
            int n17;
            int n18;
            int n19;
            n3 = this.content.getLineCount();
            int n20 = this.getCaretLine();
            if (n2 == -1) {
                n19 = this.getPartialBottomIndex();
                n18 = this.getLinePixel(n19);
                n17 = this.renderer.getLineHeight(n19);
                n2 = n18;
                if (n18 + n17 <= this.clientAreaHeight) {
                    n2 += n17;
                } else if (this.wordWrap || this.visualWrap) {
                    object = this.renderer.getTextLayout(n19);
                    n16 = this.clientAreaHeight - n18;
                    for (n15 = 0; n15 < ((TextLayout)object).getLineCount(); ++n15) {
                        rectangle = ((TextLayout)object).getLineBounds(n15);
                        if (!rectangle.contains(rectangle.x, n16)) continue;
                        n2 += rectangle.y;
                        break;
                    }
                    this.renderer.disposeTextLayout((TextLayout)object);
                }
            } else {
                n19 = this.getLineIndex(n2);
                n18 = this.getLinePixel(n19);
                if (this.wordWrap || this.visualWrap) {
                    object = this.renderer.getTextLayout(n19);
                    n16 = n2 - n18;
                    for (n15 = 0; n15 < ((TextLayout)object).getLineCount(); ++n15) {
                        rectangle = ((TextLayout)object).getLineBounds(n15);
                        if (!rectangle.contains(rectangle.x, n16)) continue;
                        n2 = n18 + rectangle.y + rectangle.height;
                        break;
                    }
                    this.renderer.disposeTextLayout((TextLayout)object);
                } else {
                    n2 = n18 + this.renderer.getLineHeight(n19);
                }
            }
            n18 = n2;
            if (this.wordWrap || this.visualWrap) {
                object = this.renderer.getTextLayout(n20);
                n16 = this.caretOffset - this.content.getOffsetAtLine(n20);
                n19 = this.getVisualLineIndex((TextLayout)object, n16);
                n18 += ((TextLayout)object).getLineBounds((int)n19).y;
                this.renderer.disposeTextLayout((TextLayout)object);
            }
            n19 = n20;
            n17 = this.renderer.getLineHeight(n19);
            while (n18 - n17 >= 0 && n19 < n3 - 1) {
                n18 -= n17;
                n17 = this.renderer.getLineHeight(++n19);
            }
            object = new int[1];
            n16 = this.getOffsetAtPoint(this.columnX, n18, n19, (int[])object);
            this.setCaretOffset(n16, (int)object[0]);
            if (bl2) {
                this.doSelection(0x1000004);
            }
            n2 = this.getAvailableHeightBellow(n2);
            this.scrollVertical(n2, true);
            if (n2 == 0) {
                this.setCaretLocation();
            }
        }
        this.showCaret();
        n3 = n5 - this.horizontalScrollOffset;
        this.columnX = n4 + n3;
    }

    void doPageEnd() {
        if (this.isSingleLine()) {
            this.doLineEnd();
        } else {
            int n2;
            if (this.wordWrap || this.visualWrap) {
                int n3;
                int n4 = this.getPartialBottomIndex();
                TextLayout textLayout = this.renderer.getTextLayout(n4);
                int n5 = this.clientAreaHeight - this.bottomMargin - this.getLinePixel(n4);
                for (n3 = textLayout.getLineCount() - 1; n3 >= 0; --n3) {
                    Rectangle rectangle = textLayout.getLineBounds(n3);
                    if (n5 >= rectangle.y + rectangle.height) break;
                }
                n2 = n3 == -1 && n4 > 0 ? this.content.getOffsetAtLine(n4 - 1) + this.content.getLine(n4 - 1).length() : this.content.getOffsetAtLine(n4) + Math.max(0, textLayout.getLineOffsets()[n3 + 1] - 1);
                this.renderer.disposeTextLayout(textLayout);
            } else {
                int n6 = this.getBottomIndex();
                n2 = this.content.getOffsetAtLine(n6) + this.content.getLine(n6).length();
            }
            if (this.caretOffset < n2) {
                this.setCaretOffset(n2, 1);
                this.showCaret();
            }
        }
    }

    void doPageStart() {
        int n2;
        if (this.wordWrap || this.visualWrap) {
            int n3;
            int n4;
            int n5;
            if (this.topIndexY > 0) {
                n5 = this.topIndex - 1;
                n4 = this.renderer.getLineHeight(n5) - this.topIndexY;
            } else {
                n5 = this.topIndex;
                n4 = -this.topIndexY;
            }
            TextLayout textLayout = this.renderer.getTextLayout(n5);
            int n6 = textLayout.getLineCount();
            for (n3 = 0; n3 < n6; ++n3) {
                Rectangle rectangle = textLayout.getLineBounds(n3);
                if (n4 <= rectangle.y) break;
            }
            n2 = n3 == n6 ? this.content.getOffsetAtLine(n5 + 1) : this.content.getOffsetAtLine(n5) + textLayout.getLineOffsets()[n3];
            this.renderer.disposeTextLayout(textLayout);
        } else {
            n2 = this.content.getOffsetAtLine(this.topIndex);
        }
        if (this.caretOffset > n2) {
            this.setCaretOffset(n2, 1);
            this.showCaret();
        }
    }

    void doPageUp(boolean bl2, int n2) {
        int n3;
        if (this.isSingleLine()) {
            return;
        }
        int n4 = this.horizontalScrollOffset;
        int n5 = this.columnX;
        if (this.isFixedLineHeight()) {
            n3 = this.getCaretLine();
            if (n3 > 0) {
                int n6;
                int n7;
                int n8 = this.renderer.getLineHeight();
                int n9 = (n2 == -1 ? this.clientAreaHeight : n2) / n8;
                int n10 = Math.max(1, Math.min(n3, n9));
                int[] nArray = new int[1];
                int n11 = this.getOffsetAtPoint(this.columnX, this.getLinePixel(n3 -= n10), nArray);
                this.setCaretOffset(n11, nArray[0]);
                if (bl2) {
                    this.doSelection(0x1000003);
                }
                if ((n7 = Math.max(0, (n6 = this.getVerticalScrollOffset()) - n10 * this.getVerticalIncrement())) < n6) {
                    this.scrollVertical(n7 - n6, true);
                }
            }
        } else {
            int n12;
            Object object;
            int n13;
            int n14;
            int n15;
            n3 = this.getCaretLine();
            if (n2 == -1) {
                if (this.topIndexY == 0) {
                    n2 = this.clientAreaHeight;
                } else {
                    if (this.topIndex > 0) {
                        n15 = this.topIndex - 1;
                        n14 = this.renderer.getLineHeight(n15);
                        n2 = this.clientAreaHeight - this.topIndexY;
                        n13 = n14 - this.topIndexY;
                    } else {
                        n15 = this.topIndex;
                        n14 = this.renderer.getLineHeight(n15);
                        n2 = this.clientAreaHeight - (n14 + this.topIndexY);
                        n13 = -this.topIndexY;
                    }
                    if (this.wordWrap || this.visualWrap) {
                        object = this.renderer.getTextLayout(n15);
                        for (n12 = 0; n12 < ((TextLayout)object).getLineCount(); ++n12) {
                            Rectangle rectangle = ((TextLayout)object).getLineBounds(n12);
                            if (!rectangle.contains(rectangle.x, n13)) continue;
                            n2 += n14 - (rectangle.y + rectangle.height);
                            break;
                        }
                        this.renderer.disposeTextLayout((TextLayout)object);
                    }
                }
            } else {
                n15 = this.getLineIndex(this.clientAreaHeight - n2);
                n13 = this.getLinePixel(n15);
                if (this.wordWrap || this.visualWrap) {
                    object = this.renderer.getTextLayout(n15);
                    n12 = n13;
                    for (int i2 = 0; i2 < ((TextLayout)object).getLineCount(); ++i2) {
                        Rectangle rectangle = ((TextLayout)object).getLineBounds(i2);
                        if (!rectangle.contains(rectangle.x, n12)) continue;
                        n2 = this.clientAreaHeight - (n13 + rectangle.y);
                        break;
                    }
                    this.renderer.disposeTextLayout((TextLayout)object);
                } else {
                    n2 = this.clientAreaHeight - n13;
                }
            }
            n13 = n2;
            if (this.wordWrap || this.visualWrap) {
                object = this.renderer.getTextLayout(n3);
                n12 = this.caretOffset - this.content.getOffsetAtLine(n3);
                n15 = this.getVisualLineIndex((TextLayout)object, n12);
                n13 += ((TextLayout)object).getBounds().height - ((TextLayout)object).getLineBounds((int)n15).y;
                this.renderer.disposeTextLayout((TextLayout)object);
            }
            n15 = n3;
            n14 = this.renderer.getLineHeight(n15);
            while (n13 - n14 >= 0 && n15 > 0) {
                n13 -= n14;
                n14 = this.renderer.getLineHeight(--n15);
            }
            n14 = this.renderer.getLineHeight(n15);
            object = new int[1];
            n12 = this.getOffsetAtPoint(this.columnX, n14 - n13, n15, (int[])object);
            this.setCaretOffset(n12, (int)object[0]);
            if (bl2) {
                this.doSelection(0x1000003);
            }
            n2 = this.getAvailableHeightAbove(n2);
            this.scrollVertical(-n2, true);
            if (n2 == 0) {
                this.setCaretLocation();
            }
        }
        this.showCaret();
        n3 = n4 - this.horizontalScrollOffset;
        this.columnX = n5 + n3;
    }

    void doSelection(int n2) {
        int n3 = -1;
        int n4 = -1;
        if (this.selectionAnchor == -1) {
            this.selectionAnchor = this.selection.x;
        }
        if (n2 == 0x1000003) {
            if (this.caretOffset < this.selection.x) {
                n4 = this.selection.x;
                n3 = this.selection.x = this.caretOffset;
                if (this.selection.y != this.selectionAnchor) {
                    n4 = this.selection.y;
                    this.selection.y = this.selectionAnchor;
                }
            } else if (this.selectionAnchor == this.selection.x && this.caretOffset < this.selection.y) {
                n4 = this.selection.y;
                n3 = this.selection.y = this.caretOffset;
            }
        } else if (this.caretOffset > this.selection.y) {
            n3 = this.selection.y;
            n4 = this.selection.y = this.caretOffset;
            if (this.selection.x != this.selectionAnchor) {
                n3 = this.selection.x;
                this.selection.x = this.selectionAnchor;
            }
        } else if (this.selectionAnchor == this.selection.y && this.caretOffset > this.selection.x) {
            n3 = this.selection.x;
            n4 = this.selection.x = this.caretOffset;
        }
        if (n3 != -1 && n4 != -1) {
            this.internalRedrawRange(n3, n4 - n3);
            this.sendSelectionEvent();
        }
        this.sendAccessibleTextCaretMoved();
    }

    void doSelectionCursorNext() {
        int n2 = this.getCaretLine();
        int n3 = this.content.getOffsetAtLine(n2);
        int n4 = this.caretOffset - n3;
        if (n4 < this.content.getLine(n2).length()) {
            TextLayout textLayout = this.renderer.getTextLayout(n2);
            n4 = textLayout.getNextOffset(n4, 2);
            int n5 = textLayout.getLineOffsets()[textLayout.getLineIndex(n4)];
            this.renderer.disposeTextLayout(textLayout);
            int n6 = n4 + n3;
            int n7 = n4 == n5 ? 1 : 0;
            this.setCaretOffset(n6, n7);
            this.showCaret();
        } else if (n2 < this.content.getLineCount() - 1 && !this.isSingleLine()) {
            int n8 = this.content.getOffsetAtLine(++n2);
            int n9 = 0;
            this.setCaretOffset(n8, n9);
            this.showCaret();
        }
    }

    void doSelectionCursorPrevious() {
        int n2 = this.getCaretLine();
        int n3 = this.content.getOffsetAtLine(n2);
        int n4 = this.caretOffset - n3;
        if (n4 > 0) {
            int n5 = this.getClusterPrevious(this.caretOffset, n2);
            this.setCaretOffset(n5, 1);
            this.showCaret();
        } else if (n2 > 0) {
            n3 = this.content.getOffsetAtLine(--n2);
            int n6 = n3 + this.content.getLine(n2).length();
            this.setCaretOffset(n6, 1);
            this.showCaret();
        }
    }

    void doSelectionLineDown() {
        int n2 = this.columnX = this.getPointAtOffset((int)this.caretOffset).x;
        this.doLineDown(true);
        this.columnX = n2;
    }

    void doSelectionLineUp() {
        int n2 = this.columnX = this.getPointAtOffset((int)this.caretOffset).x;
        this.doLineUp(true);
        this.columnX = n2;
    }

    void doSelectionPageDown(int n2) {
        int n3 = this.columnX = this.getPointAtOffset((int)this.caretOffset).x;
        this.doPageDown(true, n2);
        this.columnX = n3;
    }

    void doSelectionPageUp(int n2) {
        int n3 = this.columnX = this.getPointAtOffset((int)this.caretOffset).x;
        this.doPageUp(true, n2);
        this.columnX = n3;
    }

    void doSelectionWordNext() {
        int n2 = this.getWordNext(this.caretOffset, 4);
        if (!this.isSingleLine() || this.content.getLineAtOffset(this.caretOffset) == this.content.getLineAtOffset(n2)) {
            this.setCaretOffset(n2, 1);
            this.showCaret();
        }
    }

    void doSelectionWordPrevious() {
        int n2 = this.getWordPrevious(this.caretOffset, 4);
        this.setCaretOffset(n2, 1);
        this.showCaret();
    }

    void doVisualPrevious() {
        int n2 = this.getClusterPrevious(this.caretOffset, this.getCaretLine());
        this.setCaretOffset(n2, -1);
        this.showCaret();
    }

    void doVisualNext() {
        int n2 = this.getClusterNext(this.caretOffset, this.getCaretLine());
        this.setCaretOffset(n2, -1);
        this.showCaret();
    }

    void doWordNext() {
        if (this.selection.y - this.selection.x > 0) {
            this.setCaretOffset(this.selection.y, -1);
            this.showCaret();
        } else {
            this.doSelectionWordNext();
        }
    }

    void doWordPrevious() {
        if (this.selection.y - this.selection.x > 0) {
            this.setCaretOffset(this.selection.x, -1);
            this.showCaret();
        } else {
            this.doSelectionWordPrevious();
        }
    }

    void endAutoScroll() {
        this.autoScrollDirection = 0;
    }

    @Override
    public Color getBackground() {
        this.checkWidget();
        if (this.background == null) {
            return this.getDisplay().getSystemColor(25);
        }
        return this.background;
    }

    public int getBaseline() {
        this.checkWidget();
        return this.renderer.getBaseline();
    }

    public int getBaseline(int n2) {
        this.checkWidget();
        if (0 > n2 || n2 > this.content.getCharCount()) {
            SWT.error(6);
        }
        if (this.isFixedLineHeight()) {
            return this.renderer.getBaseline();
        }
        int n3 = this.content.getLineAtOffset(n2);
        int n4 = this.content.getOffsetAtLine(n3);
        TextLayout textLayout = this.renderer.getTextLayout(n3);
        int n5 = textLayout.getLineIndex(Math.min(n2 - n4, textLayout.getText().length()));
        FontMetrics fontMetrics = textLayout.getLineMetrics(n5);
        this.renderer.disposeTextLayout(textLayout);
        return fontMetrics.getAscent() + fontMetrics.getLeading();
    }

    public boolean getBidiColoring() {
        this.checkWidget();
        return this.bidiColoring;
    }

    public boolean getBlockSelection() {
        this.checkWidget();
        return this.blockSelection;
    }

    Rectangle getBlockSelectionPosition() {
        int n2;
        int n3;
        int n4;
        int n5 = this.getLineIndex(this.blockYAnchor - this.getVerticalScrollOffset());
        if (n5 > (n4 = this.getLineIndex(this.blockYLocation - this.getVerticalScrollOffset()))) {
            n3 = n5;
            n5 = n4;
            n4 = n3;
        }
        if ((n3 = this.blockXAnchor) > (n2 = this.blockXLocation)) {
            n3 = this.blockXLocation;
            n2 = this.blockXAnchor;
        }
        return new Rectangle(n3 - this.horizontalScrollOffset, n5, n2 - this.horizontalScrollOffset, n4);
    }

    public Rectangle getBlockSelectionBounds() {
        Rectangle rectangle;
        if (this.blockSelection && this.blockXLocation != -1) {
            rectangle = this.getBlockSelectionRectangle();
        } else {
            Point point = this.getPointAtOffset(this.selection.x);
            Point point2 = this.getPointAtOffset(this.selection.y);
            int n2 = this.getLineHeight(this.selection.y);
            rectangle = new Rectangle(point.x, point.y, point2.x - point.x, point2.y + n2 - point.y);
            if (this.selection.x == this.selection.y) {
                rectangle.width = this.getCaretWidth();
            }
        }
        rectangle.x += this.horizontalScrollOffset;
        rectangle.y += this.getVerticalScrollOffset();
        return rectangle;
    }

    Rectangle getBlockSelectionRectangle() {
        Rectangle rectangle = this.getBlockSelectionPosition();
        rectangle.y = this.getLinePixel(rectangle.y);
        rectangle.width -= rectangle.x;
        rectangle.height = this.getLinePixel(rectangle.height + 1) - rectangle.y;
        return rectangle;
    }

    String getBlockSelectionText(String string) {
        Rectangle rectangle = this.getBlockSelectionPosition();
        int n2 = rectangle.y;
        int n3 = rectangle.height;
        int n4 = rectangle.x;
        int n5 = rectangle.width;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = n2; i2 <= n3; ++i2) {
            int n6;
            int n7 = this.getOffsetAtPoint(n4, 0, i2, null);
            if (n7 > (n6 = this.getOffsetAtPoint(n5, 0, i2, null))) {
                int n8 = n7;
                n7 = n6;
                n6 = n8;
            }
            String string2 = this.content.getTextRange(n7, n6 - n7);
            stringBuffer.append(string2);
            if (i2 >= n3) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    int getBottomIndex() {
        int n2;
        if (this.isFixedLineHeight()) {
            int n3 = 1;
            int n4 = this.renderer.getLineHeight();
            if (n4 != 0) {
                int n5 = this.topIndex * n4 - this.getVerticalScrollOffset();
                n3 = (this.clientAreaHeight - n5) / n4;
            }
            n2 = Math.min(this.content.getLineCount() - 1, this.topIndex + Math.max(0, n3 - 1));
        } else {
            int n6;
            int n7;
            int n8 = this.clientAreaHeight - this.bottomMargin;
            n2 = this.getLineIndex(n8);
            if (n2 > 0 && (n7 = this.getLinePixel(n2)) + (n6 = this.renderer.getLineHeight(n2)) > n8 && this.getLinePixel(n2 - 1) >= this.topMargin) {
                --n2;
            }
        }
        return n2;
    }

    public int getBottomMargin() {
        this.checkWidget();
        return this.bottomMargin;
    }

    Rectangle getBoundsAtOffset(int n2) {
        int n3;
        Rectangle rectangle;
        int n4 = this.content.getLineAtOffset(n2);
        int n5 = this.content.getOffsetAtLine(n4);
        String string = this.content.getLine(n4);
        if (string.length() != 0) {
            TextLayout textLayout = this.renderer.getTextLayout(n4);
            int n6 = Math.min(textLayout.getText().length(), Math.max(0, n2 - n5));
            if (this.caretAlignment == 0 && n6 != 0) {
                n6 = textLayout.getPreviousOffset(n6, 2);
                Point point = textLayout.getLocation(n6, true);
                rectangle = new Rectangle(point.x, point.y, 0, this.renderer.getLineHeight());
            } else {
                rectangle = textLayout.getBounds(n6, n6);
            }
            this.renderer.disposeTextLayout(textLayout);
        } else {
            rectangle = new Rectangle(0, 0, 0, this.renderer.getLineHeight());
        }
        if (n2 == this.caretOffset && !this.wordWrap && !this.visualWrap && n2 == (n3 = n5 + string.length())) {
            rectangle.width += this.getCaretWidth();
        }
        rectangle.x += this.leftMargin - this.horizontalScrollOffset;
        rectangle.y += this.getLinePixel(n4);
        return rectangle;
    }

    public int getCaretOffset() {
        this.checkWidget();
        return this.caretOffset;
    }

    int getCaretWidth() {
        Caret caret = this.getCaret();
        if (caret == null) {
            return 0;
        }
        return caret.getSize().x;
    }

    Object getClipboardContent(int n2) {
        TextTransfer textTransfer = TextTransfer.getInstance();
        return this.clipboard.getContents(textTransfer, n2);
    }

    int getClusterNext(int n2, int n3) {
        int n4 = this.content.getOffsetAtLine(n3);
        TextLayout textLayout = this.renderer.getTextLayout(n3);
        n2 -= n4;
        n2 = textLayout.getNextOffset(n2, 2);
        this.renderer.disposeTextLayout(textLayout);
        return n2 += n4;
    }

    int getClusterPrevious(int n2, int n3) {
        int n4 = this.content.getOffsetAtLine(n3);
        TextLayout textLayout = this.renderer.getTextLayout(n3);
        n2 -= n4;
        n2 = textLayout.getPreviousOffset(n2, 2);
        this.renderer.disposeTextLayout(textLayout);
        return n2 += n4;
    }

    public StyledTextContent getContent() {
        this.checkWidget();
        return this.content;
    }

    @Override
    public boolean getDragDetect() {
        this.checkWidget();
        return this.dragDetect;
    }

    public boolean getDoubleClickEnabled() {
        this.checkWidget();
        return this.doubleClickEnabled;
    }

    public boolean getEditable() {
        this.checkWidget();
        return this.editable;
    }

    @Override
    public Color getForeground() {
        this.checkWidget();
        if (this.foreground == null) {
            return this.getDisplay().getSystemColor(24);
        }
        return this.foreground;
    }

    int getHorizontalIncrement() {
        return this.renderer.averageCharWidth;
    }

    public int getHorizontalIndex() {
        this.checkWidget();
        return this.horizontalScrollOffset / this.getHorizontalIncrement();
    }

    public int getHorizontalPixel() {
        this.checkWidget();
        return this.horizontalScrollOffset;
    }

    public int getIndent() {
        this.checkWidget();
        return this.indent;
    }

    public boolean getJustify() {
        this.checkWidget();
        return this.justify;
    }

    public int getKeyBinding(int n2) {
        this.checkWidget();
        Integer n3 = (Integer)this.keyActionMap.get(n2);
        return n3 == null ? 0 : n3;
    }

    public int getCharCount() {
        this.checkWidget();
        return this.content.getCharCount();
    }

    public String getLine(int n2) {
        this.checkWidget();
        if (n2 < 0 || n2 > 0 && n2 >= this.content.getLineCount()) {
            SWT.error(6);
        }
        return this.content.getLine(n2);
    }

    public int getLineAlignment(int n2) {
        this.checkWidget();
        if (n2 < 0 || n2 > this.content.getLineCount()) {
            SWT.error(5);
        }
        return this.renderer.getLineAlignment(n2, this.alignment);
    }

    public int getLineAtOffset(int n2) {
        this.checkWidget();
        if (n2 < 0 || n2 > this.getCharCount()) {
            SWT.error(6);
        }
        return this.content.getLineAtOffset(n2);
    }

    public Color getLineBackground(int n2) {
        this.checkWidget();
        if (n2 < 0 || n2 > this.content.getLineCount()) {
            SWT.error(5);
        }
        return this.isListening(3001) ? null : this.renderer.getLineBackground(n2, null);
    }

    public Bullet getLineBullet(int n2) {
        this.checkWidget();
        if (n2 < 0 || n2 > this.content.getLineCount()) {
            SWT.error(5);
        }
        return this.isListening(3002) ? null : this.renderer.getLineBullet(n2, null);
    }

    StyledTextEvent getLineBackgroundData(int n2, String string) {
        return this.sendLineEvent(3001, n2, string);
    }

    public int getLineCount() {
        this.checkWidget();
        return this.content.getLineCount();
    }

    int getLineCountWhole() {
        if (this.isFixedLineHeight()) {
            int n2 = this.renderer.getLineHeight();
            return n2 != 0 ? this.clientAreaHeight / n2 : 1;
        }
        return this.getBottomIndex() - this.topIndex + 1;
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return this.content.getLineDelimiter();
    }

    public int getLineHeight() {
        this.checkWidget();
        return this.renderer.getLineHeight();
    }

    public int getLineHeight(int n2) {
        this.checkWidget();
        if (0 > n2 || n2 > this.content.getCharCount()) {
            SWT.error(6);
        }
        if (this.isFixedLineHeight()) {
            return this.renderer.getLineHeight();
        }
        int n3 = this.content.getLineAtOffset(n2);
        int n4 = this.content.getOffsetAtLine(n3);
        TextLayout textLayout = this.renderer.getTextLayout(n3);
        int n5 = textLayout.getLineIndex(Math.min(n2 - n4, textLayout.getText().length()));
        int n6 = textLayout.getLineBounds((int)n5).height;
        this.renderer.disposeTextLayout(textLayout);
        return n6;
    }

    public int getLineIndent(int n2) {
        this.checkWidget();
        if (n2 < 0 || n2 > this.content.getLineCount()) {
            SWT.error(5);
        }
        return this.isListening(3002) ? 0 : this.renderer.getLineIndent(n2, this.indent);
    }

    public boolean getLineJustify(int n2) {
        this.checkWidget();
        if (n2 < 0 || n2 > this.content.getLineCount()) {
            SWT.error(5);
        }
        return this.isListening(3002) ? false : this.renderer.getLineJustify(n2, this.justify);
    }

    public int getLineSpacing() {
        this.checkWidget();
        return this.lineSpacing;
    }

    StyledTextEvent getLineStyleData(int n2, String string) {
        return this.sendLineEvent(3002, n2, string);
    }

    public int getLinePixel(int n2) {
        this.checkWidget();
        int n3 = this.content.getLineCount();
        n2 = Math.max(0, Math.min(n3, n2));
        if (this.isFixedLineHeight()) {
            int n4 = this.renderer.getLineHeight();
            return n2 * n4 - this.getVerticalScrollOffset() + this.topMargin;
        }
        if (n2 == this.topIndex) {
            return this.topIndexY + this.topMargin;
        }
        int n5 = this.topIndexY;
        if (n2 > this.topIndex) {
            for (int i2 = this.topIndex; i2 < n2; ++i2) {
                n5 += this.renderer.getLineHeight(i2);
            }
        } else {
            for (int i3 = this.topIndex - 1; i3 >= n2; --i3) {
                n5 -= this.renderer.getLineHeight(i3);
            }
        }
        return n5 + this.topMargin;
    }

    public int getLineIndex(int n2) {
        this.checkWidget();
        n2 -= this.topMargin;
        if (this.isFixedLineHeight()) {
            int n3 = this.renderer.getLineHeight();
            int n4 = (n2 + this.getVerticalScrollOffset()) / n3;
            int n5 = this.content.getLineCount();
            n4 = Math.max(0, Math.min(n5 - 1, n4));
            return n4;
        }
        if (n2 == this.topIndexY) {
            return this.topIndex;
        }
        int n6 = this.topIndex;
        if (n2 < this.topIndexY) {
            while (n2 < this.topIndexY && n6 > 0) {
                n2 += this.renderer.getLineHeight(--n6);
            }
        } else {
            int n7 = this.content.getLineCount();
            int n8 = this.renderer.getLineHeight(n6);
            while (n2 - n8 >= this.topIndexY && n6 < n7 - 1) {
                n2 -= n8;
                n8 = this.renderer.getLineHeight(++n6);
            }
        }
        return n6;
    }

    public int[] getLineTabStops(int n2) {
        this.checkWidget();
        if (n2 < 0 || n2 > this.content.getLineCount()) {
            SWT.error(5);
        }
        if (this.isListening(3002)) {
            return null;
        }
        int[] nArray = this.renderer.getLineTabStops(n2, null);
        if (nArray == null) {
            nArray = this.tabs;
        }
        if (nArray == null) {
            return new int[]{this.renderer.tabWidth};
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    public int getLineWrapIndent(int n2) {
        this.checkWidget();
        if (n2 < 0 || n2 > this.content.getLineCount()) {
            SWT.error(5);
        }
        return this.isListening(3002) ? 0 : this.renderer.getLineWrapIndent(n2, this.wrapIndent);
    }

    public int getLeftMargin() {
        this.checkWidget();
        return this.leftMargin - this.alignmentMargin;
    }

    public Point getLocationAtOffset(int n2) {
        this.checkWidget();
        if (n2 < 0 || n2 > this.getCharCount()) {
            SWT.error(6);
        }
        return this.getPointAtOffset(n2);
    }

    public int getOffsetAtLine(int n2) {
        this.checkWidget();
        if (n2 < 0 || n2 > 0 && n2 >= this.content.getLineCount()) {
            SWT.error(6);
        }
        return this.content.getOffsetAtLine(n2);
    }

    public int getOffsetAtLocation(Point point) {
        int[] nArray;
        int n2;
        this.checkWidget();
        if (point == null) {
            SWT.error(4);
        }
        if ((n2 = this.getOffsetAtPoint(point.x, point.y, nArray = new int[1], true)) == -1) {
            SWT.error(5);
        }
        return n2 + nArray[0];
    }

    int getOffsetAtPoint(int n2, int n3, int[] nArray) {
        int n4 = this.getLineIndex(n3);
        return this.getOffsetAtPoint(n2, n3 -= this.getLinePixel(n4), n4, nArray);
    }

    int getOffsetAtPoint(int n2, int n3, int n4, int[] nArray) {
        TextLayout textLayout = this.renderer.getTextLayout(n4);
        int[] nArray2 = new int[1];
        int n5 = textLayout.getOffset(n2 += this.horizontalScrollOffset - this.leftMargin, n3, nArray2);
        if (nArray != null) {
            nArray[0] = 1;
        }
        if (nArray2[0] != 0) {
            int n6 = textLayout.getLineIndex(n5 + nArray2[0]);
            int n7 = textLayout.getLineOffsets()[n6];
            if (n5 + nArray2[0] == n7) {
                n5 += nArray2[0];
                if (nArray != null) {
                    nArray[0] = 0;
                }
            } else {
                int n8;
                String string = this.content.getLine(n4);
                int n9 = 0;
                if (nArray != null) {
                    for (n8 = n5; n8 > 0 && Character.isDigit(string.charAt(n8)); --n8) {
                    }
                    n9 = n8 == 0 && Character.isDigit(string.charAt(n8)) ? (this.isMirrored() ? 1 : 0) : textLayout.getLevel(n8) & 1;
                }
                n5 += nArray2[0];
                if (nArray != null) {
                    n8 = textLayout.getLevel(n5) & 1;
                    nArray[0] = (n9 ^ n8) != 0 ? 0 : 1;
                }
            }
        }
        this.renderer.disposeTextLayout(textLayout);
        return n5 + this.content.getOffsetAtLine(n4);
    }

    int getOffsetAtPoint(int n2, int n3, int[] nArray, boolean bl2) {
        if (bl2 && n3 + this.getVerticalScrollOffset() < 0 || n2 + this.horizontalScrollOffset < 0) {
            return -1;
        }
        int n4 = this.getPartialBottomIndex();
        int n5 = this.getLinePixel(n4 + 1);
        if (bl2 && n3 > n5) {
            return -1;
        }
        int n6 = this.getLineIndex(n3);
        int n7 = this.content.getOffsetAtLine(n6);
        TextLayout textLayout = this.renderer.getTextLayout(n6);
        int n8 = textLayout.getOffset(n2 += this.horizontalScrollOffset - this.leftMargin, n3 -= this.getLinePixel(n6), nArray);
        Rectangle rectangle = textLayout.getLineBounds(textLayout.getLineIndex(n8));
        this.renderer.disposeTextLayout(textLayout);
        if (bl2 && (rectangle.x > n2 || n2 > rectangle.x + rectangle.width)) {
            return -1;
        }
        return n8 + n7;
    }

    @Override
    public int getOrientation() {
        return super.getOrientation();
    }

    int getPartialBottomIndex() {
        if (this.isFixedLineHeight()) {
            int n2 = this.renderer.getLineHeight();
            int n3 = Compatibility.ceil(this.clientAreaHeight, n2);
            return Math.max(0, Math.min(this.content.getLineCount(), this.topIndex + n3) - 1);
        }
        return this.getLineIndex(this.clientAreaHeight - this.bottomMargin);
    }

    int getPartialTopIndex() {
        if (this.isFixedLineHeight()) {
            int n2 = this.renderer.getLineHeight();
            return this.getVerticalScrollOffset() / n2;
        }
        return this.topIndexY <= 0 ? this.topIndex : this.topIndex - 1;
    }

    String getPlatformDelimitedText(StyledText$TextWriter styledText$TextWriter) {
        int n2 = styledText$TextWriter.getStart() + styledText$TextWriter.getCharCount();
        int n3 = this.content.getLineAtOffset(styledText$TextWriter.getStart());
        int n4 = this.content.getLineAtOffset(n2);
        String string = this.content.getLine(n4);
        int n5 = this.content.getOffsetAtLine(n4);
        for (int i2 = n3; i2 <= n4; ++i2) {
            styledText$TextWriter.writeLine(this.content.getLine(i2), this.content.getOffsetAtLine(i2));
            if (i2 >= n4) continue;
            styledText$TextWriter.writeLineDelimiter(PlatformLineDelimiter);
        }
        if (n2 > n5 + string.length()) {
            styledText$TextWriter.writeLineDelimiter(PlatformLineDelimiter);
        }
        styledText$TextWriter.close();
        return styledText$TextWriter.toString();
    }

    public int[] getRanges() {
        int[] nArray;
        this.checkWidget();
        if (!this.isListening(3002) && (nArray = this.renderer.getRanges(0, this.content.getCharCount())) != null) {
            return nArray;
        }
        return new int[0];
    }

    public int[] getRanges(int n2, int n3) {
        int[] nArray;
        this.checkWidget();
        int n4 = this.getCharCount();
        int n5 = n2 + n3;
        if (n2 > n5 || n2 < 0 || n5 > n4) {
            SWT.error(6);
        }
        if (!this.isListening(3002) && (nArray = this.renderer.getRanges(n2, n3)) != null) {
            return nArray;
        }
        return new int[0];
    }

    public int getRightMargin() {
        this.checkWidget();
        return this.rightMargin;
    }

    public Point getSelection() {
        this.checkWidget();
        return new Point(this.selection.x, this.selection.y);
    }

    public Point getSelectionRange() {
        this.checkWidget();
        return new Point(this.selection.x, this.selection.y - this.selection.x);
    }

    public int[] getSelectionRanges() {
        this.checkWidget();
        if (this.blockSelection && this.blockXLocation != -1) {
            Rectangle rectangle = this.getBlockSelectionPosition();
            int n2 = rectangle.y;
            int n3 = rectangle.height;
            int n4 = rectangle.x;
            int n5 = rectangle.width;
            int[] nArray = new int[(n3 - n2 + 1) * 2];
            int n6 = 0;
            for (int i2 = n2; i2 <= n3; ++i2) {
                int n7;
                int n8 = this.getOffsetAtPoint(n4, 0, i2, null);
                if (n8 > (n7 = this.getOffsetAtPoint(n5, 0, i2, null))) {
                    int n9 = n8;
                    n8 = n7;
                    n7 = n9;
                }
                nArray[n6++] = n8;
                nArray[n6++] = n7 - n8;
            }
            return nArray;
        }
        return new int[]{this.selection.x, this.selection.y - this.selection.x};
    }

    public Color getSelectionBackground() {
        this.checkWidget();
        if (this.selectionBackground == null) {
            return this.getDisplay().getSystemColor(26);
        }
        return this.selectionBackground;
    }

    public int getSelectionCount() {
        this.checkWidget();
        if (this.blockSelection && this.blockXLocation != -1) {
            return this.getBlockSelectionText(this.content.getLineDelimiter()).length();
        }
        return this.getSelectionRange().y;
    }

    public Color getSelectionForeground() {
        this.checkWidget();
        if (this.selectionForeground == null) {
            return this.getDisplay().getSystemColor(27);
        }
        return this.selectionForeground;
    }

    public String getSelectionText() {
        this.checkWidget();
        if (this.blockSelection && this.blockXLocation != -1) {
            return this.getBlockSelectionText(this.content.getLineDelimiter());
        }
        return this.content.getTextRange(this.selection.x, this.selection.y - this.selection.x);
    }

    StyledTextEvent getBidiSegments(int n2, String string) {
        int n3;
        char[] cArray;
        if (!this.isListening(3007)) {
            if (!this.bidiColoring) {
                return null;
            }
            StyledTextEvent styledTextEvent = new StyledTextEvent(this.content);
            styledTextEvent.segments = this.getBidiSegmentsCompatibility(string, n2);
            return styledTextEvent;
        }
        StyledTextEvent styledTextEvent = this.sendLineEvent(3007, n2, string);
        if (styledTextEvent == null || styledTextEvent.segments == null || styledTextEvent.segments.length == 0) {
            return null;
        }
        int[] nArray = styledTextEvent.segments;
        int n4 = string.length();
        if (nArray[0] > n4) {
            SWT.error(5);
        }
        boolean bl2 = (cArray = styledTextEvent.segmentsChars) != null;
        for (n3 = 1; n3 < nArray.length; ++n3) {
            if (!(!bl2 ? nArray[n3] <= nArray[n3 - 1] : nArray[n3] < nArray[n3 - 1]) && nArray[n3] <= n4) continue;
            SWT.error(5);
        }
        if (bl2 && !this.visualWrap) {
            for (n3 = 0; n3 < cArray.length; ++n3) {
                if (cArray[n3] != '\n' && cArray[n3] != '\r') continue;
                this.visualWrap = true;
                this.setVariableLineHeight();
                break;
            }
        }
        return styledTextEvent;
    }

    int[] getBidiSegmentsCompatibility(String string, int n2) {
        int n3;
        int n4 = string.length();
        StyleRange[] styleRangeArray = null;
        StyledTextEvent styledTextEvent = this.getLineStyleData(n2, string);
        styleRangeArray = styledTextEvent != null ? styledTextEvent.styles : this.renderer.getStyleRanges(n2, n4, true);
        if (styleRangeArray == null || styleRangeArray.length == 0) {
            return new int[]{0, n4};
        }
        int n5 = 1;
        for (n3 = 0; n3 < styleRangeArray.length && styleRangeArray[n3].start == 0 && styleRangeArray[n3].length == n4; ++n3) {
        }
        int[] nArray = new int[(styleRangeArray.length - n3) * 2 + 2];
        for (int i2 = n3; i2 < styleRangeArray.length; ++i2) {
            StyleRange styleRange = styleRangeArray[i2];
            int n6 = Math.max(styleRange.start - n2, 0);
            int n7 = Math.max(styleRange.start + styleRange.length - n2, n6);
            n7 = Math.min(n7, string.length());
            if (i2 > 0 && n5 > 1 && (n6 >= nArray[n5 - 2] && n6 <= nArray[n5 - 1] || n7 >= nArray[n5 - 2] && n7 <= nArray[n5 - 1]) && styleRange.similarTo(styleRangeArray[i2 - 1])) {
                nArray[n5 - 2] = Math.min(nArray[n5 - 2], n6);
                nArray[n5 - 1] = Math.max(nArray[n5 - 1], n7);
                continue;
            }
            if (n6 > nArray[n5 - 1]) {
                nArray[n5] = n6;
                ++n5;
            }
            nArray[n5] = n7;
            ++n5;
        }
        if (n4 > nArray[n5 - 1]) {
            nArray[n5] = n4;
            ++n5;
        }
        if (n5 == nArray.length) {
            return nArray;
        }
        int[] nArray2 = new int[n5];
        System.arraycopy(nArray, 0, nArray2, 0, n5);
        return nArray2;
    }

    public StyleRange getStyleRangeAtOffset(int n2) {
        StyleRange[] styleRangeArray;
        this.checkWidget();
        if (n2 < 0 || n2 >= this.getCharCount()) {
            SWT.error(5);
        }
        if (!this.isListening(3002) && (styleRangeArray = this.renderer.getStyleRanges(n2, 1, true)) != null) {
            return styleRangeArray[0];
        }
        return null;
    }

    public StyleRange[] getStyleRanges() {
        this.checkWidget();
        return this.getStyleRanges(0, this.content.getCharCount(), true);
    }

    public StyleRange[] getStyleRanges(boolean bl2) {
        this.checkWidget();
        return this.getStyleRanges(0, this.content.getCharCount(), bl2);
    }

    public StyleRange[] getStyleRanges(int n2, int n3) {
        this.checkWidget();
        return this.getStyleRanges(n2, n3, true);
    }

    public StyleRange[] getStyleRanges(int n2, int n3, boolean bl2) {
        StyleRange[] styleRangeArray;
        this.checkWidget();
        int n4 = this.getCharCount();
        int n5 = n2 + n3;
        if (n2 > n5 || n2 < 0 || n5 > n4) {
            SWT.error(6);
        }
        if (!this.isListening(3002) && (styleRangeArray = this.renderer.getStyleRanges(n2, n3, bl2)) != null) {
            return styleRangeArray;
        }
        return new StyleRange[0];
    }

    public int getTabs() {
        this.checkWidget();
        return this.tabLength;
    }

    public int[] getTabStops() {
        this.checkWidget();
        if (this.tabs == null) {
            return new int[]{this.renderer.tabWidth};
        }
        int[] nArray = new int[this.tabs.length];
        System.arraycopy(this.tabs, 0, nArray, 0, this.tabs.length);
        return nArray;
    }

    public String getText() {
        this.checkWidget();
        return this.content.getTextRange(0, this.getCharCount());
    }

    public String getText(int n2, int n3) {
        this.checkWidget();
        int n4 = this.getCharCount();
        if (n2 < 0 || n2 >= n4 || n3 < 0 || n3 >= n4 || n2 > n3) {
            SWT.error(6);
        }
        return this.content.getTextRange(n2, n3 - n2 + 1);
    }

    public Rectangle getTextBounds(int n2, int n3) {
        Rectangle rectangle;
        this.checkWidget();
        int n4 = this.getCharCount();
        if (n2 < 0 || n2 >= n4 || n3 < 0 || n3 >= n4 || n2 > n3) {
            SWT.error(6);
        }
        int n5 = this.content.getLineAtOffset(n2);
        int n6 = this.content.getLineAtOffset(n3);
        int n7 = this.getLinePixel(n5);
        int n8 = 0;
        int n9 = Integer.MAX_VALUE;
        int n10 = 0;
        for (int i2 = n5; i2 <= n6; ++i2) {
            int n11 = this.content.getOffsetAtLine(i2);
            TextLayout textLayout = this.renderer.getTextLayout(i2);
            int n12 = textLayout.getText().length();
            if (n12 > 0) {
                if (i2 == n5) {
                    rectangle = i2 == n6 ? textLayout.getBounds(n2 - n11, n3 - n11) : textLayout.getBounds(n2 - n11, n12);
                    n7 += rectangle.y;
                } else {
                    rectangle = i2 == n6 ? textLayout.getBounds(0, n3 - n11) : textLayout.getBounds();
                }
                n9 = Math.min(n9, rectangle.x);
                n10 = Math.max(n10, rectangle.x + rectangle.width);
                n8 += rectangle.height;
            } else {
                n8 += this.renderer.getLineHeight();
            }
            this.renderer.disposeTextLayout(textLayout);
        }
        rectangle = new Rectangle(n9, n7, n10 - n9, n8);
        rectangle.x += this.leftMargin - this.horizontalScrollOffset;
        return rectangle;
    }

    public String getTextRange(int n2, int n3) {
        this.checkWidget();
        int n4 = this.getCharCount();
        int n5 = n2 + n3;
        if (n2 > n5 || n2 < 0 || n5 > n4) {
            SWT.error(6);
        }
        return this.content.getTextRange(n2, n3);
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.textLimit;
    }

    public int getTopIndex() {
        this.checkWidget();
        return this.topIndex;
    }

    public int getTopMargin() {
        this.checkWidget();
        return this.topMargin;
    }

    public int getTopPixel() {
        this.checkWidget();
        return this.getVerticalScrollOffset();
    }

    int getVerticalIncrement() {
        return this.renderer.getLineHeight();
    }

    int getVerticalScrollOffset() {
        if (this.verticalScrollOffset == -1) {
            this.renderer.calculate(0, this.topIndex);
            int n2 = 0;
            for (int i2 = 0; i2 < this.topIndex; ++i2) {
                n2 += this.renderer.getLineHeight(i2);
            }
            this.verticalScrollOffset = n2 -= this.topIndexY;
        }
        return this.verticalScrollOffset;
    }

    int getVisualLineIndex(TextLayout textLayout, int n2) {
        int n3 = textLayout.getLineIndex(n2);
        int[] nArray = textLayout.getLineOffsets();
        Caret caret = this.getCaret();
        if (caret != null && n3 != 0 && n2 == nArray[n3]) {
            int n4 = textLayout.getLineBounds((int)n3).y;
            int n5 = caret.getLocation().y - this.getLinePixel(this.getCaretLine());
            if (n4 > n5) {
                --n3;
            }
            this.caretAlignment = 1;
        }
        return n3;
    }

    int getCaretDirection() {
        if (!this.isBidiCaret()) {
            return -1;
        }
        if (this.ime.getCompositionOffset() != -1) {
            return -1;
        }
        if (!this.updateCaretDirection && this.caretDirection != 0) {
            return this.caretDirection;
        }
        this.updateCaretDirection = false;
        int n2 = this.getCaretLine();
        int n3 = this.content.getOffsetAtLine(n2);
        String string = this.content.getLine(n2);
        int n4 = this.caretOffset - n3;
        int n5 = string.length();
        if (n5 == 0) {
            return this.isMirrored() ? 131072 : 16384;
        }
        if (this.caretAlignment == 0 && n4 > 0) {
            --n4;
        }
        if (n4 == n5 && n4 > 0) {
            --n4;
        }
        while (n4 > 0 && Character.isDigit(string.charAt(n4))) {
            --n4;
        }
        if (n4 == 0 && Character.isDigit(string.charAt(n4))) {
            return this.isMirrored() ? 131072 : 16384;
        }
        TextLayout textLayout = this.renderer.getTextLayout(n2);
        int n6 = textLayout.getLevel(n4);
        this.renderer.disposeTextLayout(textLayout);
        return (n6 & 1) != 0 ? 131072 : 16384;
    }

    int getCaretLine() {
        return this.content.getLineAtOffset(this.caretOffset);
    }

    int getWrapWidth() {
        if (this.wordWrap && !this.isSingleLine()) {
            int n2 = this.clientAreaWidth - this.leftMargin - this.rightMargin;
            return n2 > 0 ? n2 : 1;
        }
        return -1;
    }

    int getWordNext(int n2, int n3) {
        return this.getWordNext(n2, n3, false);
    }

    int getWordNext(int n2, int n3, boolean bl2) {
        String string;
        int n4;
        int n5;
        if (n2 >= this.getCharCount()) {
            n5 = n2;
            int n6 = this.content.getLineCount() - 1;
            n4 = this.content.getOffsetAtLine(n6);
            string = this.content.getLine(n6);
        } else {
            int n7;
            int n8 = this.content.getLineAtOffset(n2);
            n4 = this.content.getOffsetAtLine(n8);
            if (n2 >= n4 + (n7 = (string = this.content.getLine(n8)).length())) {
                n5 = this.content.getOffsetAtLine(n8 + 1);
            } else {
                TextLayout textLayout = this.renderer.getTextLayout(n8);
                n5 = n4 + textLayout.getNextOffset(n2 - n4, n3);
                this.renderer.disposeTextLayout(textLayout);
            }
        }
        if (bl2) {
            return n5;
        }
        return this.sendWordBoundaryEvent(3009, n3, n2, n5, string, n4);
    }

    int getWordPrevious(int n2, int n3) {
        return this.getWordPrevious(n2, n3, false);
    }

    int getWordPrevious(int n2, int n3, boolean bl2) {
        String string;
        int n4;
        int n5;
        if (n2 <= 0) {
            n5 = 0;
            int n6 = this.content.getLineAtOffset(n5);
            n4 = this.content.getOffsetAtLine(n6);
            string = this.content.getLine(n6);
        } else {
            int n7 = this.content.getLineAtOffset(n2);
            n4 = this.content.getOffsetAtLine(n7);
            string = this.content.getLine(n7);
            if (n2 == n4) {
                String string2 = this.content.getLine(n7 - 1);
                int n8 = this.content.getOffsetAtLine(n7 - 1);
                n5 = n8 + string2.length();
            } else {
                int n9 = Math.min(n2 - n4, string.length());
                TextLayout textLayout = this.renderer.getTextLayout(n7);
                n5 = n4 + textLayout.getPreviousOffset(n9, n3);
                this.renderer.disposeTextLayout(textLayout);
            }
        }
        if (bl2) {
            return n5;
        }
        return this.sendWordBoundaryEvent(3010, n3, n2, n5, string, n4);
    }

    public boolean getWordWrap() {
        this.checkWidget();
        return this.wordWrap;
    }

    public int getWrapIndent() {
        this.checkWidget();
        return this.wrapIndent;
    }

    Point getPointAtOffset(int n2) {
        Point point;
        int n3 = this.content.getLineAtOffset(n2);
        String string = this.content.getLine(n3);
        int n4 = this.content.getOffsetAtLine(n3);
        int n5 = Math.max(0, n2 - n4);
        int n6 = string.length();
        if (n3 < this.content.getLineCount() - 1) {
            int n7 = this.content.getOffsetAtLine(n3 + 1) - 1;
            if (n6 < n5 && n5 <= n7) {
                n5 = n6;
            }
        }
        TextLayout textLayout = this.renderer.getTextLayout(n3);
        if (n6 != 0 && n5 <= n6) {
            if (n5 == n6) {
                n5 = textLayout.getPreviousOffset(n5, 2);
                point = textLayout.getLocation(n5, true);
            } else {
                switch (this.caretAlignment) {
                    case 1: {
                        point = textLayout.getLocation(n5, false);
                        break;
                    }
                    default: {
                        boolean bl2;
                        boolean bl3 = bl2 = n5 == 0;
                        if (this.wordWrap && !bl2 && (n2 != this.caretOffset || this.selection.x != this.selection.y)) {
                            int[] nArray;
                            for (int n8 : nArray = textLayout.getLineOffsets()) {
                                if (n8 != n5) continue;
                                bl2 = true;
                                break;
                            }
                        }
                        if (bl2) {
                            point = textLayout.getLocation(n5, false);
                            break;
                        }
                        n5 = textLayout.getPreviousOffset(n5, 2);
                        point = textLayout.getLocation(n5, true);
                        break;
                    }
                }
            }
        } else {
            point = new Point(textLayout.getIndent(), 0);
        }
        this.renderer.disposeTextLayout(textLayout);
        point.x += this.leftMargin - this.horizontalScrollOffset;
        point.y += this.getLinePixel(n3);
        return point;
    }

    public void insert(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        if (this.blockSelection) {
            this.insertBlockSelectionText(string, false);
        } else {
            Point point = this.getSelectionRange();
            this.replaceTextRange(point.x, point.y, string);
        }
    }

    int insertBlockSelectionText(String string, boolean bl2) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = 1;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            n7 = string.charAt(i2);
            if (n7 != 10 && n7 != 13) continue;
            ++n8;
            if (n7 != 13 || i2 + 1 >= string.length() || string.charAt(i2 + 1) != '\n') continue;
            ++i2;
        }
        String[] stringArray = new String[n8];
        n7 = 0;
        n8 = 0;
        for (n6 = 0; n6 < string.length(); ++n6) {
            n5 = string.charAt(n6);
            if (n5 != 10 && n5 != 13) continue;
            stringArray[n8++] = string.substring(n7, n6);
            if (n5 == 13 && n6 + 1 < string.length() && string.charAt(n6 + 1) == '\n') {
                ++n6;
            }
            n7 = n6 + 1;
        }
        stringArray[n8++] = string.substring(n7);
        if (bl2) {
            n6 = 0;
            for (n5 = 0; n5 < stringArray.length; ++n5) {
                int n9 = stringArray[n5].length();
                n6 = Math.max(n6, n9);
            }
            for (n5 = 0; n5 < stringArray.length; ++n5) {
                String string2 = stringArray[n5];
                n4 = string2.length();
                if (n4 >= n6) continue;
                int n10 = n6 - n4;
                StringBuffer stringBuffer = new StringBuffer(n4 + n10);
                stringBuffer.append(string2);
                for (n3 = 0; n3 < n10; ++n3) {
                    stringBuffer.append(' ');
                }
                stringArray[n5] = stringBuffer.toString();
            }
        }
        if (this.blockXLocation != -1) {
            Rectangle rectangle = this.getBlockSelectionPosition();
            n6 = rectangle.y;
            n5 = rectangle.height;
            n2 = rectangle.x;
            n4 = rectangle.width;
        } else {
            n6 = n5 = this.getCaretLine();
            n2 = n4 = this.getPointAtOffset((int)this.caretOffset).x;
        }
        n7 = this.caretOffset;
        int n11 = this.getCaretLine();
        int n12 = 0;
        for (n3 = n6; n3 <= n5; ++n3) {
            String string3 = n12 < n8 ? stringArray[n12++] : "";
            int n13 = this.sendTextEvent(n2, n4, n3, string3, bl2);
            if (n3 != n11) continue;
            n7 = n13;
        }
        while (n12 < n8) {
            int n14 = this.sendTextEvent(n2, n2, n3, stringArray[n12++], bl2);
            if (n3 == n11) {
                n7 = n14;
            }
            ++n3;
        }
        return n7;
    }

    void insertBlockSelectionText(char c2, int n2) {
        int n3;
        if (c2 == '\r' || c2 == '\n') {
            return;
        }
        Rectangle rectangle = this.getBlockSelectionPosition();
        int n4 = rectangle.y;
        int n5 = rectangle.height;
        int n6 = rectangle.x;
        int n7 = rectangle.width;
        int[] nArray = new int[1];
        int n8 = 0;
        int n9 = 0;
        String string = c2 != '\u0000' ? new String(new char[]{c2}) : "";
        int n10 = string.length();
        for (n3 = n4; n3 <= n5; ++n3) {
            boolean bl2;
            String string2 = this.content.getLine(n3);
            int n11 = this.content.getOffsetAtLine(n3);
            int n12 = n11 + string2.length();
            int n13 = this.getLinePixel(n3);
            int n14 = this.getOffsetAtPoint(n6, n13, nArray, true);
            boolean bl3 = bl2 = n14 == -1;
            n14 = bl2 ? (n6 < this.leftMargin ? n11 : n12) : (n14 += nArray[0]);
            int n15 = this.getOffsetAtPoint(n7, n13, nArray, true);
            n15 = n15 == -1 ? (n7 < this.leftMargin ? n11 : n12) : (n15 += nArray[0]);
            if (n14 > n15) {
                int n16 = n14;
                n14 = n15;
                n15 = n16;
            }
            if (n14 == n15 && !bl2) {
                switch (n2) {
                    case 8: {
                        if (n14 <= n11) break;
                        n14 = this.getClusterPrevious(n14, n3);
                        break;
                    }
                    case 127: {
                        if (n15 >= n12) break;
                        n15 = this.getClusterNext(n15, n3);
                    }
                }
            }
            if (bl2) {
                if (string2.length() >= n9) {
                    n9 = string2.length();
                    n8 = n12 + n10;
                }
            } else {
                n8 = n14 + n10;
                n9 = this.content.getCharCount();
            }
            Event event = new Event();
            event.text = string;
            event.start = n14;
            event.end = n15;
            this.sendKeyEvent(event);
        }
        n3 = this.getPointAtOffset((int)n8).x;
        int n17 = this.getVerticalScrollOffset();
        this.setBlockSelectionLocation(n3, this.blockYAnchor - n17, n3, this.blockYLocation - n17, false);
    }

    void installDefaultContent() {
        this.textChangeListener = new StyledText$5(this);
        this.content = new DefaultContent();
        this.content.addTextChangeListener(this.textChangeListener);
    }

    void installListeners() {
        ScrollBar scrollBar = this.getVerticalBar();
        ScrollBar scrollBar2 = this.getHorizontalBar();
        this.listener = event -> {
            switch (event.type) {
                case 12: {
                    this.handleDispose(event);
                    break;
                }
                case 1: {
                    this.handleKeyDown(event);
                    break;
                }
                case 2: {
                    this.handleKeyUp(event);
                    break;
                }
                case 35: {
                    this.handleMenuDetect(event);
                    break;
                }
                case 3: {
                    this.handleMouseDown(event);
                    break;
                }
                case 4: {
                    this.handleMouseUp(event);
                    break;
                }
                case 5: {
                    this.handleMouseMove(event);
                    break;
                }
                case 9: {
                    this.handlePaint(event);
                    break;
                }
                case 11: {
                    this.handleResize(event);
                    break;
                }
                case 31: {
                    this.handleTraverse(event);
                }
            }
        };
        this.addListener(12, this.listener);
        this.addListener(1, this.listener);
        this.addListener(2, this.listener);
        this.addListener(35, this.listener);
        this.addListener(3, this.listener);
        this.addListener(4, this.listener);
        this.addListener(5, this.listener);
        this.addListener(9, this.listener);
        this.addListener(11, this.listener);
        this.addListener(31, this.listener);
        this.ime.addListener(43, event -> {
            switch (event.detail) {
                case 3: {
                    this.handleCompositionSelection(event);
                    break;
                }
                case 1: {
                    this.handleCompositionChanged(event);
                    break;
                }
                case 2: {
                    this.handleCompositionOffset(event);
                }
            }
        });
        if (scrollBar != null) {
            scrollBar.addListener(13, event -> this.handleVerticalScroll(event));
        }
        if (scrollBar2 != null) {
            scrollBar2.addListener(13, event -> this.handleHorizontalScroll(event));
        }
    }

    void internalRedrawRange(int n2, int n3) {
        int n4;
        Rectangle rectangle;
        if (n3 <= 0) {
            return;
        }
        int n5 = n2 + n3;
        int n6 = this.content.getLineAtOffset(n2);
        int n7 = this.content.getLineAtOffset(n5);
        int n8 = this.getPartialBottomIndex();
        int n9 = this.getPartialTopIndex();
        if (n6 > n8 || n7 < n9) {
            return;
        }
        if (n9 > n6) {
            n6 = n9;
            n2 = 0;
        } else {
            n2 -= this.content.getOffsetAtLine(n6);
        }
        if (n8 < n7) {
            n7 = n8 + 1;
            n5 = 0;
        } else {
            n5 -= this.content.getOffsetAtLine(n7);
        }
        TextLayout textLayout = this.renderer.getTextLayout(n6);
        int n10 = this.leftMargin - this.horizontalScrollOffset;
        int n11 = this.getLinePixel(n6);
        int[] nArray = textLayout.getLineOffsets();
        int n12 = textLayout.getLineIndex(Math.min(n2, textLayout.getText().length()));
        if ((this.wordWrap || this.visualWrap) && n12 > 0 && nArray[n12] == n2) {
            rectangle = textLayout.getLineBounds(n12 - 1);
            rectangle.x = rectangle.width;
            rectangle.width = this.clientAreaWidth - this.rightMargin - rectangle.x;
            rectangle.x += n10;
            rectangle.y += n11;
            super.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
        }
        if (n6 == n7 && n12 == (n4 = textLayout.getLineIndex(Math.min(n5, textLayout.getText().length())))) {
            Rectangle rectangle2 = textLayout.getBounds(n2, n5 - 1);
            rectangle2.x += n10;
            rectangle2.y += n11;
            super.redraw(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, false);
            this.renderer.disposeTextLayout(textLayout);
            return;
        }
        rectangle = textLayout.getBounds(n2, nArray[n12 + 1] - 1);
        if (rectangle.height == 0) {
            Rectangle rectangle3 = textLayout.getLineBounds(n12);
            rectangle.x = rectangle3.width;
            rectangle.y = rectangle3.y;
            rectangle.height = rectangle3.height;
        }
        rectangle.x += n10;
        rectangle.y += n11;
        rectangle.width = this.clientAreaWidth - this.rightMargin - rectangle.x;
        super.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
        if (n6 != n7) {
            this.renderer.disposeTextLayout(textLayout);
            textLayout = this.renderer.getTextLayout(n7);
            nArray = textLayout.getLineOffsets();
        }
        int n13 = textLayout.getLineIndex(Math.min(n5, textLayout.getText().length()));
        Rectangle rectangle4 = textLayout.getBounds(nArray[n13], n5 - 1);
        if (rectangle4.height == 0) {
            Rectangle rectangle5 = textLayout.getLineBounds(n13);
            rectangle4.y = rectangle5.y;
            rectangle4.height = rectangle5.height;
        }
        rectangle4.x += n10;
        rectangle4.y += this.getLinePixel(n7);
        super.redraw(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height, false);
        this.renderer.disposeTextLayout(textLayout);
        int n14 = rectangle.y + rectangle.height;
        if (rectangle4.y > n14) {
            super.redraw(this.leftMargin, n14, this.clientAreaWidth - this.rightMargin - this.leftMargin, rectangle4.y - n14, false);
        }
    }

    void handleCompositionOffset(Event event) {
        int[] nArray = new int[1];
        event.index = this.getOffsetAtPoint(event.x, event.y, nArray, true);
        event.count = nArray[0];
    }

    void handleCompositionSelection(Event event) {
        if (event.start != event.end) {
            int n2 = this.getCharCount();
            event.start = Math.max(0, Math.min(event.start, n2));
            event.end = Math.max(0, Math.min(event.end, n2));
            if (event.text != null) {
                this.setSelection(event.start, event.end);
            } else {
                event.text = this.getTextRange(event.start, event.end - event.start);
            }
        } else {
            event.start = this.selection.x;
            event.end = this.selection.y;
            event.text = this.getSelectionText();
        }
    }

    void handleCompositionChanged(Event event) {
        String string = event.text;
        int n2 = event.start;
        int n3 = event.end;
        int n4 = this.content.getCharCount();
        n2 = Math.min(n2, n4);
        n3 = Math.min(n3, n4);
        int n5 = string.length();
        if (n5 == this.ime.getCommitCount()) {
            this.content.replaceTextRange(n2, n3 - n2, "");
            this.setCaretOffset(this.ime.getCompositionOffset(), -1);
            this.caretWidth = 0;
            this.caretDirection = 0;
        } else {
            this.content.replaceTextRange(n2, n3 - n2, string);
            int n6 = -1;
            if (this.ime.getWideCaret()) {
                n2 = this.ime.getCompositionOffset();
                int n7 = this.getCaretLine();
                int n8 = this.content.getOffsetAtLine(n7);
                TextLayout textLayout = this.renderer.getTextLayout(n7);
                this.caretWidth = textLayout.getBounds((int)(n2 - n8), (int)(n2 + n5 - 1 - n8)).width;
                this.renderer.disposeTextLayout(textLayout);
                n6 = 1;
            }
            this.setCaretOffset(this.ime.getCaretOffset(), n6);
        }
        this.showCaret();
    }

    void handleDispose(Event event) {
        this.removeListener(12, this.listener);
        this.notifyListeners(12, event);
        event.type = 0;
        this.clipboard.dispose();
        if (this.renderer != null) {
            this.renderer.dispose();
            this.renderer = null;
        }
        if (this.content != null) {
            this.content.removeTextChangeListener(this.textChangeListener);
            this.content = null;
        }
        if (this.defaultCaret != null) {
            this.defaultCaret.dispose();
            this.defaultCaret = null;
        }
        if (this.leftCaretBitmap != null) {
            this.leftCaretBitmap.dispose();
            this.leftCaretBitmap = null;
        }
        if (this.rightCaretBitmap != null) {
            this.rightCaretBitmap.dispose();
            this.rightCaretBitmap = null;
        }
        if (this.isBidiCaret()) {
            BidiUtil.removeLanguageListener(this);
        }
        this.selectionBackground = null;
        this.selectionForeground = null;
        this.marginColor = null;
        this.textChangeListener = null;
        this.selection = null;
        this.doubleClickSelection = null;
        this.keyActionMap = null;
        this.background = null;
        this.foreground = null;
        this.clipboard = null;
        this.tabs = null;
    }

    void handleHorizontalScroll(Event event) {
        int n2 = this.getHorizontalBar().getSelection() - this.horizontalScrollOffset;
        this.scrollHorizontal(n2, false);
    }

    void handleKey(Event event) {
        int n2;
        int n3;
        this.caretAlignment = 0;
        if (event.keyCode != 0) {
            n3 = this.getKeyBinding(event.keyCode | event.stateMask);
        } else {
            n3 = this.getKeyBinding(event.character | event.stateMask);
            if (n3 == 0 && (event.stateMask & 0x40000) != 0 && event.character <= '\u001f') {
                n2 = event.character + 64;
                n3 = this.getKeyBinding(n2 | event.stateMask);
            }
        }
        if (n3 == 0) {
            n2 = 0;
            if (IS_MAC) {
                n2 = (event.stateMask & 0x440000) != 0 ? 1 : 0;
            } else {
                int n4 = n2 = (event.stateMask ^ 0x10000) == 0 || (event.stateMask ^ 0x40000) == 0 || (event.stateMask ^ 0x30000) == 0 || (event.stateMask ^ 0x60000) == 0 ? 1 : 0;
            }
            if (n2 == 0 && event.character > '\u001f' && event.character != '\u007f' || event.character == '\r' || event.character == '\n' || event.character == '\t') {
                this.doContent(event.character);
                this.update();
            }
        } else {
            this.invokeAction(n3);
        }
    }

    void handleKeyDown(Event event) {
        if (this.clipboardSelection == null) {
            this.clipboardSelection = new Point(this.selection.x, this.selection.y);
        }
        this.newOrientation = 0;
        event.stateMask &= SWT.MODIFIER_MASK;
        Event event2 = new Event();
        event2.character = event.character;
        event2.keyCode = event.keyCode;
        event2.keyLocation = event.keyLocation;
        event2.stateMask = event.stateMask;
        event2.doit = event.doit;
        this.notifyListeners(3005, event2);
        if (event2.doit) {
            if ((event.stateMask & SWT.MODIFIER_MASK) == 262144 && event.keyCode == 131072 && this.isBidiCaret()) {
                this.newOrientation = event.keyLocation == 16384 ? 0x2000000 : 0x4000000;
            }
            this.handleKey(event);
        }
    }

    void handleKeyUp(Event event) {
        if (this.clipboardSelection != null && (this.clipboardSelection.x != this.selection.x || this.clipboardSelection.y != this.selection.y)) {
            this.copySelection(2);
        }
        this.clipboardSelection = null;
        if (this.newOrientation != 0) {
            if (this.newOrientation != this.getOrientation()) {
                Event event2 = new Event();
                event2.doit = true;
                this.notifyListeners(44, event2);
                if (event2.doit) {
                    this.setOrientation(this.newOrientation);
                }
            }
            this.newOrientation = 0;
        }
    }

    void handleMenuDetect(Event event) {
        if (event.detail == 1) {
            Point point = this.getDisplay().map((Control)this, null, this.getPointAtOffset(this.caretOffset));
            event.x = point.x;
            event.y = point.y + this.getLineHeight(this.caretOffset);
        }
    }

    void handleMouseDown(Event event) {
        String string;
        this.forceFocus();
        if (this.dragDetect && this.checkDragDetect(event)) {
            return;
        }
        if (event.button == 2 && (string = (String)this.getClipboardContent(2)) != null && string.length() > 0) {
            this.doMouseLocationChange(event.x, event.y, false);
            Event event2 = new Event();
            event2.start = this.selection.x;
            event2.end = this.selection.y;
            event2.text = this.getModelDelimitedText(string);
            this.sendKeyEvent(event2);
        }
        if (event.button != 1 || IS_MAC && (event.stateMask & SWT.MOD4) != 0) {
            return;
        }
        this.clickCount = event.count;
        if (this.clickCount == 1) {
            boolean bl2 = (event.stateMask & SWT.MOD2) != 0;
            this.doMouseLocationChange(event.x, event.y, bl2);
        } else if (this.doubleClickEnabled) {
            boolean bl3 = (this.clickCount & 1) == 0;
            int n2 = this.getOffsetAtPoint(event.x, event.y, null);
            int n3 = this.content.getLineAtOffset(n2);
            int n4 = this.content.getOffsetAtLine(n3);
            if (bl3) {
                int n5 = this.blockSelection ? n4 : 0;
                int n6 = this.blockSelection ? n4 + this.content.getLine(n3).length() : this.content.getCharCount();
                int n7 = Math.max(n5, this.getWordPrevious(n2, 16));
                int n8 = Math.min(n6, this.getWordNext(n7, 8));
                this.setSelection(n7, n8 - n7, false, true);
                this.sendSelectionEvent();
            } else if (this.blockSelection) {
                this.setBlockSelectionLocation(this.leftMargin, event.y, this.clientAreaWidth - this.rightMargin, event.y, true);
            } else {
                int n9 = this.content.getCharCount();
                if (n3 + 1 < this.content.getLineCount()) {
                    n9 = this.content.getOffsetAtLine(n3 + 1);
                }
                this.setSelection(n4, n9 - n4, false, false);
                this.sendSelectionEvent();
            }
            this.doubleClickSelection = new Point(this.selection.x, this.selection.y);
            this.showCaret();
        }
    }

    void handleMouseMove(Event event) {
        if (this.clickCount > 0) {
            this.update();
            this.doAutoScroll(event);
            this.doMouseLocationChange(event.x, event.y, true);
        }
        if (this.renderer.hasLinks) {
            this.doMouseLinkCursor(event.x, event.y);
        }
    }

    void handleMouseUp(Event event) {
        this.clickCount = 0;
        this.endAutoScroll();
        if (event.button == 1) {
            this.copySelection(2);
        }
    }

    void handlePaint(Event event) {
        if (event.width == 0 || event.height == 0) {
            return;
        }
        if (this.clientAreaWidth == 0 || this.clientAreaHeight == 0) {
            return;
        }
        int n2 = this.getLineIndex(event.y);
        int n3 = this.getLinePixel(n2);
        int n4 = event.y + event.height;
        GC gC = event.gc;
        Color color = this.getBackground();
        Color color2 = this.getForeground();
        if (n4 > 0) {
            int n5 = this.isSingleLine() ? 1 : this.content.getLineCount();
            int n6 = this.leftMargin - this.horizontalScrollOffset;
            for (int i2 = n2; n3 < n4 && i2 < n5; n3 += this.renderer.drawLine(i2, n6, n3, gC, color, color2), ++i2) {
            }
            if (n3 < n4) {
                gC.setBackground(color);
                this.drawBackground(gC, 0, n3, this.clientAreaWidth, n4 - n3);
            }
        }
        if (this.blockSelection && this.blockXLocation != -1) {
            gC.setBackground(this.getSelectionBackground());
            Rectangle rectangle = this.getBlockSelectionRectangle();
            gC.drawRectangle(rectangle.x, rectangle.y, Math.max(1, rectangle.width - 1), Math.max(1, rectangle.height - 1));
            gC.setAdvanced(true);
            if (gC.getAdvanced()) {
                gC.setAlpha(100);
                gC.fillRectangle(rectangle);
                gC.setAdvanced(false);
            }
        }
        gC.setBackground(this.marginColor != null ? this.marginColor : color);
        if (this.topMargin > 0) {
            this.drawBackground(gC, 0, 0, this.clientAreaWidth, this.topMargin);
        }
        if (this.bottomMargin > 0) {
            this.drawBackground(gC, 0, this.clientAreaHeight - this.bottomMargin, this.clientAreaWidth, this.bottomMargin);
        }
        if (this.leftMargin - this.alignmentMargin > 0) {
            this.drawBackground(gC, 0, 0, this.leftMargin - this.alignmentMargin, this.clientAreaHeight);
        }
        if (this.rightMargin > 0) {
            this.drawBackground(gC, this.clientAreaWidth - this.rightMargin, 0, this.rightMargin, this.clientAreaHeight);
        }
    }

    void handleResize(Event event) {
        int n2 = this.clientAreaHeight;
        int n3 = this.clientAreaWidth;
        Rectangle rectangle = this.getClientArea();
        this.clientAreaHeight = rectangle.height;
        this.clientAreaWidth = rectangle.width;
        if (!this.alwaysShowScroll && this.ignoreResize != 0) {
            return;
        }
        this.redrawMargins(n2, n3);
        if (this.wordWrap) {
            if (n3 != this.clientAreaWidth) {
                this.renderer.reset(0, this.content.getLineCount());
                this.verticalScrollOffset = -1;
                this.renderer.calculateIdle();
                super.redraw();
            }
            if (n2 != this.clientAreaHeight) {
                if (n2 == 0) {
                    this.topIndexY = 0;
                }
                this.setScrollBars(true);
            }
            this.setCaretLocation();
        } else {
            ScrollBar scrollBar;
            this.renderer.calculateClientArea();
            this.setScrollBars(true);
            this.claimRightFreeSpace();
            if (this.clientAreaWidth != 0 && (scrollBar = this.getHorizontalBar()) != null && scrollBar.getVisible() && this.horizontalScrollOffset != scrollBar.getSelection()) {
                scrollBar.setSelection(this.horizontalScrollOffset);
                this.horizontalScrollOffset = scrollBar.getSelection();
            }
        }
        this.updateCaretVisibility();
        this.claimBottomFreeSpace();
        this.setAlignment();
    }

    void handleTextChanged(TextChangedEvent textChangedEvent) {
        int n2 = this.ime.getCompositionOffset();
        if (n2 != -1 && this.lastTextChangeStart < n2) {
            this.ime.setCompositionOffset(n2 + this.lastTextChangeNewCharCount - this.lastTextChangeReplaceCharCount);
        }
        int n3 = this.content.getLineAtOffset(this.lastTextChangeStart);
        this.resetCache(n3, 0);
        if (!this.isFixedLineHeight() && this.topIndex > n3) {
            this.topIndex = n3;
            if (this.topIndex < 0) {
                System.err.println("StyledText: topIndex was " + this.topIndex + ", lastTextChangeStart = " + this.lastTextChangeStart + ", content.getClass() = " + this.content.getClass());
                this.topIndex = 0;
            }
            this.topIndexY = 0;
            super.redraw();
        } else {
            int n4 = n3 + this.lastTextChangeNewLineCount;
            int n5 = this.getLinePixel(n3);
            int n6 = this.getLinePixel(n4 + 1);
            if (this.lastLineBottom != n6) {
                super.redraw();
            } else {
                super.redraw(0, n5, this.clientAreaWidth, n6 - n5, false);
                this.redrawLinesBullet(this.renderer.redrawLines);
            }
        }
        this.renderer.redrawLines = null;
        if (!this.blockSelection || this.blockXLocation == -1) {
            this.updateSelection(this.lastTextChangeStart, this.lastTextChangeReplaceCharCount, this.lastTextChangeNewCharCount);
        }
        if (this.lastTextChangeReplaceLineCount > 0 || this.wordWrap || this.visualWrap) {
            this.claimBottomFreeSpace();
        }
        if (this.lastTextChangeReplaceCharCount > 0) {
            this.claimRightFreeSpace();
        }
        this.sendAccessibleTextChanged(this.lastTextChangeStart, this.lastTextChangeNewCharCount, 0);
        this.lastCharCount += this.lastTextChangeNewCharCount;
        this.lastCharCount -= this.lastTextChangeReplaceCharCount;
        this.setAlignment();
    }

    void handleTextChanging(TextChangingEvent textChangingEvent) {
        int n2;
        if (textChangingEvent.replaceCharCount < 0) {
            textChangingEvent.start += textChangingEvent.replaceCharCount;
            textChangingEvent.replaceCharCount *= -1;
        }
        this.lastTextChangeStart = textChangingEvent.start;
        this.lastTextChangeNewLineCount = textChangingEvent.newLineCount;
        this.lastTextChangeNewCharCount = textChangingEvent.newCharCount;
        this.lastTextChangeReplaceLineCount = textChangingEvent.replaceLineCount;
        this.lastTextChangeReplaceCharCount = textChangingEvent.replaceCharCount;
        int n3 = this.content.getLineAtOffset(textChangingEvent.start);
        int n4 = this.getLinePixel(n3 + textChangingEvent.replaceLineCount + 1);
        this.lastLineBottom = n2 = this.getLinePixel(n3 + 1) + textChangingEvent.newLineCount * this.renderer.getLineHeight();
        if (n4 < 0 && n2 < 0) {
            this.lastLineBottom += n4 - n2;
            this.verticalScrollOffset += n2 - n4;
            this.calculateTopIndex(n2 - n4);
            this.setScrollBars(true);
        } else {
            this.scrollText(n4, n2);
        }
        this.sendAccessibleTextChanged(this.lastTextChangeStart, 0, this.lastTextChangeReplaceCharCount);
        this.renderer.textChanging(textChangingEvent);
        int n5 = this.content.getCharCount() - textChangingEvent.replaceCharCount + textChangingEvent.newCharCount;
        if (this.caretOffset > n5) {
            this.setCaretOffset(n5, -1);
        }
    }

    void handleTextSet(TextChangedEvent textChangedEvent) {
        this.reset();
        int n2 = this.getCharCount();
        this.sendAccessibleTextChanged(0, n2, this.lastCharCount);
        this.lastCharCount = n2;
        this.setAlignment();
    }

    void handleTraverse(Event event) {
        switch (event.detail) {
            case 2: 
            case 256: 
            case 512: {
                event.doit = true;
                break;
            }
            case 4: 
            case 8: 
            case 16: {
                if ((this.getStyle() & 4) != 0) {
                    event.doit = true;
                    break;
                }
                if (this.editable && (event.stateMask & SWT.MODIFIER_MASK) == 0) break;
                event.doit = true;
            }
        }
    }

    void handleVerticalScroll(Event event) {
        int n2 = this.getVerticalBar().getSelection() - this.getVerticalScrollOffset();
        this.scrollVertical(n2, false);
    }

    void initializeAccessible() {
        this.acc = this.getAccessible();
        this.accAdapter = new StyledText$6(this);
        this.acc.addAccessibleListener(this.accAdapter);
        this.accTextExtendedAdapter = new StyledText$7(this);
        this.acc.addAccessibleTextListener(this.accTextExtendedAdapter);
        this.accEditableTextListener = new StyledText$8(this);
        this.acc.addAccessibleEditableTextListener(this.accEditableTextListener);
        this.accAttributeAdapter = new StyledText$9(this);
        this.acc.addAccessibleAttributeListener(this.accAttributeAdapter);
        this.accControlAdapter = new StyledText$10(this);
        this.acc.addAccessibleControlListener(this.accControlAdapter);
        this.addListener(15, event -> this.acc.setFocus(-1));
    }

    @Override
    public void dispose() {
        if (!this.isDisposed()) {
            this.acc.removeAccessibleControlListener(this.accControlAdapter);
            this.acc.removeAccessibleAttributeListener(this.accAttributeAdapter);
            this.acc.removeAccessibleEditableTextListener(this.accEditableTextListener);
            this.acc.removeAccessibleTextListener(this.accTextExtendedAdapter);
            this.acc.removeAccessibleListener(this.accAdapter);
        }
        super.dispose();
    }

    String getAssociatedLabel() {
        Control[] controlArray = this.getParent().getChildren();
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            if (controlArray[i2] != this) continue;
            if (i2 <= 0) break;
            Control control = controlArray[i2 - 1];
            if (control instanceof Label) {
                return ((Label)control).getText();
            }
            if (!(control instanceof CLabel)) break;
            return ((CLabel)control).getText();
        }
        return null;
    }

    String stripMnemonic(String string) {
        int n2 = 0;
        int n3 = string.length();
        while (true) {
            if (n2 < n3 && string.charAt(n2) != '&') {
                ++n2;
                continue;
            }
            if (++n2 >= n3) {
                return string;
            }
            if (string.charAt(n2) != '&') {
                return string.substring(0, n2 - 1) + string.substring(n2, n3);
            }
            if (++n2 >= n3) break;
        }
        return string;
    }

    char _findMnemonic(String string) {
        if (string == null) {
            return '\u0000';
        }
        int n2 = 0;
        int n3 = string.length();
        while (true) {
            if (n2 < n3 && string.charAt(n2) != '&') {
                ++n2;
                continue;
            }
            if (++n2 >= n3) {
                return '\u0000';
            }
            if (string.charAt(n2) != '&') {
                return Character.toLowerCase(string.charAt(n2));
            }
            if (++n2 >= n3) break;
        }
        return '\u0000';
    }

    public void invokeAction(int n2) {
        this.checkWidget();
        if (this.blockSelection && this.invokeBlockAction(n2)) {
            return;
        }
        this.updateCaretDirection = true;
        switch (n2) {
            case 0x1000001: {
                this.doLineUp(false);
                this.clearSelection(true);
                break;
            }
            case 0x1000002: {
                this.doLineDown(false);
                this.clearSelection(true);
                break;
            }
            case 0x1000007: {
                this.doLineStart();
                this.clearSelection(true);
                break;
            }
            case 0x1000008: {
                this.doLineEnd();
                this.clearSelection(true);
                break;
            }
            case 0x1000003: {
                this.doCursorPrevious();
                this.clearSelection(true);
                break;
            }
            case 0x1000004: {
                this.doCursorNext();
                this.clearSelection(true);
                break;
            }
            case 0x1000005: {
                this.doPageUp(false, -1);
                this.clearSelection(true);
                break;
            }
            case 0x1000006: {
                this.doPageDown(false, -1);
                this.clearSelection(true);
                break;
            }
            case 17039363: {
                this.doWordPrevious();
                this.clearSelection(true);
                break;
            }
            case 0x1040004: {
                this.doWordNext();
                this.clearSelection(true);
                break;
            }
            case 17039367: {
                this.doContentStart();
                this.clearSelection(true);
                break;
            }
            case 17039368: {
                this.doContentEnd();
                this.clearSelection(true);
                break;
            }
            case 17039365: {
                this.doPageStart();
                this.clearSelection(true);
                break;
            }
            case 17039366: {
                this.doPageEnd();
                this.clearSelection(true);
                break;
            }
            case 0x1020001: {
                this.doSelectionLineUp();
                break;
            }
            case 262209: {
                this.selectAll();
                break;
            }
            case 0x1020002: {
                this.doSelectionLineDown();
                break;
            }
            case 16908295: {
                this.doLineStart();
                this.doSelection(0x1000003);
                break;
            }
            case 16908296: {
                this.doLineEnd();
                this.doSelection(0x1000004);
                break;
            }
            case 16908291: {
                this.doSelectionCursorPrevious();
                this.doSelection(0x1000003);
                break;
            }
            case 16908292: {
                this.doSelectionCursorNext();
                this.doSelection(0x1000004);
                break;
            }
            case 16908293: {
                this.doSelectionPageUp(-1);
                break;
            }
            case 16908294: {
                this.doSelectionPageDown(-1);
                break;
            }
            case 17170435: {
                this.doSelectionWordPrevious();
                this.doSelection(0x1000003);
                break;
            }
            case 17170436: {
                this.doSelectionWordNext();
                this.doSelection(0x1000004);
                break;
            }
            case 17170439: {
                this.doContentStart();
                this.doSelection(0x1000003);
                break;
            }
            case 17170440: {
                this.doContentEnd();
                this.doSelection(0x1000004);
                break;
            }
            case 17170437: {
                this.doPageStart();
                this.doSelection(0x1000003);
                break;
            }
            case 0x1060006: {
                this.doPageEnd();
                this.doSelection(0x1000004);
                break;
            }
            case 131199: {
                this.cut();
                break;
            }
            case 17039369: {
                this.copy();
                break;
            }
            case 16908297: {
                this.paste();
                break;
            }
            case 8: {
                this.doBackspace();
                break;
            }
            case 127: {
                this.doDelete();
                break;
            }
            case 262152: {
                this.doDeleteWordPrevious();
                break;
            }
            case 262271: {
                this.doDeleteWordNext();
                break;
            }
            case 0x1000009: {
                this.overwrite = !this.overwrite;
                break;
            }
            case 0x100000A: {
                this.setBlockSelection(!this.blockSelection);
            }
        }
    }

    boolean invokeBlockAction(int n2) {
        switch (n2) {
            case 0x1000001: 
            case 0x1000002: 
            case 0x1000003: 
            case 0x1000004: 
            case 0x1000005: 
            case 0x1000006: 
            case 0x1000007: 
            case 0x1000008: 
            case 17039363: 
            case 0x1040004: 
            case 17039365: 
            case 17039366: 
            case 17039367: 
            case 17039368: {
                this.clearBlockSelection(false, false);
                return false;
            }
            case 0x1020001: {
                this.doBlockLineVertical(true);
                return true;
            }
            case 0x1020002: {
                this.doBlockLineVertical(false);
                return true;
            }
            case 16908295: {
                this.doBlockLineHorizontal(false);
                return true;
            }
            case 16908296: {
                this.doBlockLineHorizontal(true);
                return false;
            }
            case 16908291: {
                this.doBlockColumn(false);
                return true;
            }
            case 16908292: {
                this.doBlockColumn(true);
                return true;
            }
            case 17170435: {
                this.doBlockWord(false);
                return true;
            }
            case 17170436: {
                this.doBlockWord(true);
                return true;
            }
            case 262209: {
                return false;
            }
            case 17170439: {
                this.doBlockContentStartEnd(false);
                break;
            }
            case 17170440: {
                this.doBlockContentStartEnd(true);
                break;
            }
            case 16908293: 
            case 16908294: 
            case 17170437: 
            case 0x1060006: {
                return true;
            }
            case 131199: 
            case 16908297: 
            case 17039369: {
                return false;
            }
            case 8: 
            case 127: {
                if (this.blockXLocation != -1) {
                    this.insertBlockSelectionText('\u0000', n2);
                    return true;
                }
                return false;
            }
            case 262152: 
            case 262271: {
                return this.blockXLocation != -1;
            }
        }
        return false;
    }

    boolean isBidiCaret() {
        return BidiUtil.isBidiPlatform();
    }

    boolean isFixedLineHeight() {
        return this.fixedLineHeight;
    }

    boolean isLineDelimiter(int n2) {
        int n3 = this.content.getLineAtOffset(n2);
        int n4 = this.content.getOffsetAtLine(n3);
        int n5 = n2 - n4;
        return n5 > this.content.getLine(n3).length();
    }

    boolean isMirrored() {
        return (this.getStyle() & 0x8000000) != 0;
    }

    public boolean isTextSelected() {
        this.checkWidget();
        if (this.blockSelection && this.blockXLocation != -1) {
            Rectangle rectangle = this.getBlockSelectionPosition();
            return !rectangle.isEmpty();
        }
        return this.selection.y != this.selection.x;
    }

    boolean isSingleLine() {
        return (this.getStyle() & 4) != 0;
    }

    void modifyContent(Event event, boolean bl2) {
        event.doit = true;
        this.notifyListeners(25, event);
        if (event.doit) {
            StyledTextEvent styledTextEvent = null;
            int n2 = event.end - event.start;
            if (this.isListening(3000)) {
                styledTextEvent = new StyledTextEvent(this.content);
                styledTextEvent.start = event.start;
                styledTextEvent.end = event.start + event.text.length();
                styledTextEvent.text = this.content.getTextRange(event.start, n2);
            }
            if (bl2 && event.text.length() == 0) {
                int n3 = this.content.getLineAtOffset(event.start);
                int n4 = this.content.getOffsetAtLine(n3);
                TextLayout textLayout = this.renderer.getTextLayout(n3);
                int n5 = textLayout.getLevel(event.start - n4);
                int n6 = this.content.getLineAtOffset(event.end);
                if (n3 != n6) {
                    this.renderer.disposeTextLayout(textLayout);
                    n4 = this.content.getOffsetAtLine(n6);
                    textLayout = this.renderer.getTextLayout(n6);
                }
                int n7 = textLayout.getLevel(event.end - n4);
                this.renderer.disposeTextLayout(textLayout);
                this.caretAlignment = n5 != n7 ? 0 : 1;
            }
            this.content.replaceTextRange(event.start, n2, event.text);
            if (bl2 && (!this.blockSelection || this.blockXLocation == -1)) {
                this.setSelection(event.start + event.text.length(), 0, true, false);
                this.showCaret();
            }
            this.notifyListeners(24, event);
            if (this.isListening(3000)) {
                this.notifyListeners(3000, styledTextEvent);
            }
        }
    }

    void paintObject(GC gC, int n2, int n3, int n4, int n5, StyleRange styleRange, Bullet bullet, int n6) {
        if (this.isListening(3008)) {
            StyledTextEvent styledTextEvent = new StyledTextEvent(this.content);
            styledTextEvent.gc = gC;
            styledTextEvent.x = n2;
            styledTextEvent.y = n3;
            styledTextEvent.ascent = n4;
            styledTextEvent.descent = n5;
            styledTextEvent.style = styleRange;
            styledTextEvent.bullet = bullet;
            styledTextEvent.bulletIndex = n6;
            this.notifyListeners(3008, styledTextEvent);
        }
    }

    public void paste() {
        this.checkWidget();
        String string = (String)this.getClipboardContent(1);
        if (string != null && string.length() > 0) {
            int n2;
            if (this.blockSelection) {
                boolean bl2 = this.isFixedLineHeight() && this.renderer.fixedPitch;
                int n3 = this.insertBlockSelectionText(string, bl2);
                this.setCaretOffset(n3, -1);
                this.clearBlockSelection(true, true);
                this.setCaretLocation();
                return;
            }
            Event event = new Event();
            event.start = this.selection.x;
            event.end = this.selection.y;
            String string2 = this.getModelDelimitedText(string);
            if (this.textLimit > 0 && (n2 = this.getCharCount() - (this.selection.y - this.selection.x)) + string2.length() > this.textLimit) {
                int n4 = this.textLimit - n2;
                string2 = string2.substring(0, Math.max(n4, 0));
            }
            event.text = string2;
            this.sendKeyEvent(event);
        }
    }

    public void print() {
        this.checkWidget();
        Printer printer = new Printer();
        StyledTextPrintOptions styledTextPrintOptions = new StyledTextPrintOptions();
        styledTextPrintOptions.printTextForeground = true;
        styledTextPrintOptions.printTextBackground = true;
        styledTextPrintOptions.printTextFontStyle = true;
        styledTextPrintOptions.printLineBackground = true;
        new StyledText$Printing(this, printer, styledTextPrintOptions).run();
        printer.dispose();
    }

    public Runnable print(Printer printer) {
        this.checkWidget();
        if (printer == null) {
            SWT.error(4);
        }
        StyledTextPrintOptions styledTextPrintOptions = new StyledTextPrintOptions();
        styledTextPrintOptions.printTextForeground = true;
        styledTextPrintOptions.printTextBackground = true;
        styledTextPrintOptions.printTextFontStyle = true;
        styledTextPrintOptions.printLineBackground = true;
        return this.print(printer, styledTextPrintOptions);
    }

    public Runnable print(Printer printer, StyledTextPrintOptions styledTextPrintOptions) {
        this.checkWidget();
        if (printer == null || styledTextPrintOptions == null) {
            SWT.error(4);
        }
        return new StyledText$Printing(this, printer, styledTextPrintOptions);
    }

    @Override
    public void redraw() {
        super.redraw();
        int n2 = this.getPartialBottomIndex() - this.topIndex + 1;
        this.renderer.reset(this.topIndex, n2);
        this.renderer.calculate(this.topIndex, n2);
        this.setScrollBars(false);
        this.doMouseLinkCursor();
    }

    @Override
    public void redraw(int n2, int n3, int n4, int n5, boolean bl2) {
        super.redraw(n2, n3, n4, n5, bl2);
        if (n5 > 0) {
            int n6 = this.getLineIndex(n3);
            int n7 = this.getLineIndex(n3 + n5);
            this.resetCache(n6, n7 - n6 + 1);
            this.doMouseLinkCursor();
        }
    }

    void redrawLines(int n2, int n3, boolean bl2) {
        int n4 = n2 + n3 - 1;
        int n5 = this.getPartialBottomIndex();
        int n6 = this.getPartialTopIndex();
        if (n2 > n5 || n4 < n6) {
            return;
        }
        if (n2 < n6) {
            n2 = n6;
        }
        if (n4 > n5) {
            n4 = n5;
        }
        int n7 = this.getLinePixel(n2);
        int n8 = this.getLinePixel(n4 + 1);
        if (bl2) {
            n8 = this.clientAreaHeight - this.bottomMargin;
        }
        int n9 = this.clientAreaWidth - this.leftMargin - this.rightMargin;
        super.redraw(this.leftMargin, n7, n9, n8 - n7, true);
    }

    void redrawLinesBullet(int[] nArray) {
        if (nArray == null) {
            return;
        }
        int n2 = this.getPartialTopIndex();
        int n3 = this.getPartialBottomIndex();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n4 = nArray[i2];
            if (n2 > n4 || n4 > n3) continue;
            int n5 = -1;
            Bullet bullet = this.renderer.getLineBullet(n4, null);
            if (bullet != null) {
                StyleRange styleRange = bullet.style;
                GlyphMetrics glyphMetrics = styleRange.metrics;
                n5 = glyphMetrics.width;
            }
            if (n5 == -1) {
                n5 = this.getClientArea().width;
            }
            int n6 = this.renderer.getLineHeight(n4);
            int n7 = this.getLinePixel(n4);
            super.redraw(0, n7, n5, n6, false);
        }
    }

    void redrawMargins(int n2, int n3) {
        int n4;
        if (n3 != this.clientAreaWidth && this.rightMargin > 0) {
            n4 = (n3 < this.clientAreaWidth ? n3 : this.clientAreaWidth) - this.rightMargin;
            super.redraw(n4, 0, this.rightMargin, n2, false);
        }
        if (n2 != this.clientAreaHeight && this.bottomMargin > 0) {
            n4 = (n2 < this.clientAreaHeight ? n2 : this.clientAreaHeight) - this.bottomMargin;
            super.redraw(0, n4, n3, this.bottomMargin, false);
        }
    }

    public void redrawRange(int n2, int n3, boolean bl2) {
        this.checkWidget();
        int n4 = n2 + n3;
        int n5 = this.content.getCharCount();
        if (n2 > n4 || n2 < 0 || n4 > n5) {
            SWT.error(6);
        }
        int n6 = this.content.getLineAtOffset(n2);
        int n7 = this.content.getLineAtOffset(n4);
        this.resetCache(n6, n7 - n6 + 1);
        this.internalRedrawRange(n2, n3);
        this.doMouseLinkCursor();
    }

    public void removeBidiSegmentListener(BidiSegmentListener bidiSegmentListener) {
        this.checkWidget();
        if (bidiSegmentListener == null) {
            SWT.error(4);
        }
        this.removeListener(3007, bidiSegmentListener);
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        super.redraw();
    }

    public void removeCaretListener(CaretListener caretListener) {
        this.checkWidget();
        if (caretListener == null) {
            SWT.error(4);
        }
        this.removeListener(3011, caretListener);
    }

    public void removeExtendedModifyListener(ExtendedModifyListener extendedModifyListener) {
        this.checkWidget();
        if (extendedModifyListener == null) {
            SWT.error(4);
        }
        this.removeListener(3000, extendedModifyListener);
    }

    public void removeLineBackgroundListener(LineBackgroundListener lineBackgroundListener) {
        this.checkWidget();
        if (lineBackgroundListener == null) {
            SWT.error(4);
        }
        this.removeListener(3001, lineBackgroundListener);
    }

    public void removeLineStyleListener(LineStyleListener lineStyleListener) {
        this.checkWidget();
        if (lineStyleListener == null) {
            SWT.error(4);
        }
        this.removeListener(3002, lineStyleListener);
        this.setCaretLocation();
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            SWT.error(4);
        }
        this.removeListener(24, modifyListener);
    }

    public void removePaintObjectListener(PaintObjectListener paintObjectListener) {
        this.checkWidget();
        if (paintObjectListener == null) {
            SWT.error(4);
        }
        this.removeListener(3008, paintObjectListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        this.removeListener(13, selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            SWT.error(4);
        }
        this.removeListener(25, verifyListener);
    }

    public void removeVerifyKeyListener(VerifyKeyListener verifyKeyListener) {
        if (verifyKeyListener == null) {
            SWT.error(4);
        }
        this.removeListener(3005, verifyKeyListener);
    }

    public void removeWordMovementListener(MovementListener movementListener) {
        this.checkWidget();
        if (movementListener == null) {
            SWT.error(4);
        }
        this.removeListener(3009, movementListener);
        this.removeListener(3010, movementListener);
    }

    public void replaceStyleRanges(int n2, int n3, StyleRange[] styleRangeArray) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (styleRangeArray == null) {
            SWT.error(4);
        }
        this.setStyleRanges(n2, n3, null, styleRangeArray, false);
    }

    public void replaceTextRange(int n2, int n3, String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        int n4 = this.getCharCount();
        int n5 = n2 + n3;
        if (n2 > n5 || n2 < 0 || n5 > n4) {
            SWT.error(6);
        }
        Event event = new Event();
        event.start = n2;
        event.end = n5;
        event.text = string;
        this.modifyContent(event, false);
    }

    void reset() {
        ScrollBar scrollBar = this.getVerticalBar();
        ScrollBar scrollBar2 = this.getHorizontalBar();
        this.setCaretOffset(0, -1);
        this.topIndex = 0;
        this.topIndexY = 0;
        this.verticalScrollOffset = 0;
        this.horizontalScrollOffset = 0;
        this.resetSelection();
        this.renderer.setContent(this.content);
        if (scrollBar != null) {
            scrollBar.setSelection(0);
        }
        if (scrollBar2 != null) {
            scrollBar2.setSelection(0);
        }
        this.resetCache(0, 0);
        this.setCaretLocation();
        super.redraw();
    }

    void resetBidiData() {
        this.caretDirection = 0;
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        this.keyActionMap.clear();
        this.createKeyBindings();
        super.redraw();
    }

    void resetCache(int n2, int n3) {
        int n4 = this.renderer.maxWidthLineIndex;
        this.renderer.reset(n2, n3);
        this.renderer.calculateClientArea();
        if (0 <= n4 && n4 < this.content.getLineCount()) {
            this.renderer.calculate(n4, 1);
        }
        this.setScrollBars(true);
        if (!this.isFixedLineHeight()) {
            if (this.topIndex > n2) {
                this.verticalScrollOffset = -1;
            }
            this.renderer.calculateIdle();
        }
    }

    void resetSelection() {
        this.selection.x = this.selection.y = this.caretOffset;
        this.selectionAnchor = -1;
        this.sendAccessibleTextCaretMoved();
    }

    @Override
    public void scroll(int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        super.scroll(n2, n3, n4, n5, n6, n7, false);
        if (bl2) {
            int n8 = n2 - n4;
            int n9 = n3 - n5;
            Control[] controlArray = this.getChildren();
            for (int i2 = 0; i2 < controlArray.length; ++i2) {
                Control control = controlArray[i2];
                Rectangle rectangle = control.getBounds();
                control.setLocation(rectangle.x + n8, rectangle.y + n9);
            }
        }
    }

    boolean scrollHorizontal(int n2, boolean bl2) {
        if (n2 == 0) {
            return false;
        }
        if (this.wordWrap) {
            return false;
        }
        ScrollBar scrollBar = this.getHorizontalBar();
        if (scrollBar != null && bl2) {
            scrollBar.setSelection(this.horizontalScrollOffset + n2);
        }
        int n3 = this.clientAreaHeight - this.topMargin - this.bottomMargin;
        if (n2 > 0) {
            int n4 = this.leftMargin + n2;
            int n5 = this.clientAreaWidth - n4 - this.rightMargin;
            if (n5 > 0) {
                this.scroll(this.leftMargin, this.topMargin, n4, this.topMargin, n5, n3, true);
            }
            if (n4 > n5) {
                super.redraw(this.leftMargin + n5, this.topMargin, n2 - n5, n3, true);
            }
        } else {
            int n6 = this.leftMargin - n2;
            int n7 = this.clientAreaWidth - n6 - this.rightMargin;
            if (n7 > 0) {
                this.scroll(n6, this.topMargin, this.leftMargin, this.topMargin, n7, n3, true);
            }
            if (n6 > n7) {
                super.redraw(this.leftMargin + n7, this.topMargin, -n2 - n7, n3, true);
            }
        }
        this.horizontalScrollOffset += n2;
        this.setCaretLocation();
        return true;
    }

    boolean scrollVertical(int n2, boolean bl2) {
        if (n2 == 0) {
            return false;
        }
        if (this.verticalScrollOffset != -1) {
            int n3;
            int n4;
            ScrollBar scrollBar = this.getVerticalBar();
            if (scrollBar != null && bl2) {
                scrollBar.setSelection(this.verticalScrollOffset + n2);
            }
            int n5 = 0;
            if (n2 > 0) {
                n4 = this.topMargin + n2;
                n3 = this.clientAreaHeight - n4 - this.bottomMargin;
                if (n3 > 0) {
                    n5 = -n2;
                }
            } else {
                n4 = this.topMargin - n2;
                n3 = this.clientAreaHeight - n4 - this.bottomMargin;
                if (n3 > 0) {
                    n5 = -n2;
                }
            }
            Control[] controlArray = this.getChildren();
            for (n3 = 0; n3 < controlArray.length; ++n3) {
                Control control = controlArray[n3];
                Rectangle rectangle = control.getBounds();
                control.setLocation(rectangle.x, rectangle.y + n5);
            }
            this.verticalScrollOffset += n2;
            this.calculateTopIndex(n2);
            super.redraw();
        } else {
            this.calculateTopIndex(n2);
            super.redraw();
        }
        this.setCaretLocation();
        return true;
    }

    void scrollText(int n2, int n3) {
        if (n2 == n3) {
            return;
        }
        int n4 = n3 - n2;
        int n5 = this.clientAreaWidth - this.leftMargin - this.rightMargin;
        int n6 = n4 > 0 ? this.clientAreaHeight - n2 - this.bottomMargin : this.clientAreaHeight - n3 - this.bottomMargin;
        this.scroll(this.leftMargin, n3, this.leftMargin, n2, n5, n6, true);
        if (0 < n2 + n6 && this.topMargin > n2) {
            super.redraw(this.leftMargin, n4, n5, this.topMargin, false);
        }
        if (0 < n3 + n6 && this.topMargin > n3) {
            super.redraw(this.leftMargin, 0, n5, this.topMargin, false);
        }
        if (this.clientAreaHeight - this.bottomMargin < n2 + n6 && this.clientAreaHeight > n2) {
            super.redraw(this.leftMargin, this.clientAreaHeight - this.bottomMargin + n4, n5, this.bottomMargin, false);
        }
        if (this.clientAreaHeight - this.bottomMargin < n3 + n6 && this.clientAreaHeight > n3) {
            super.redraw(this.leftMargin, this.clientAreaHeight - this.bottomMargin, n5, this.bottomMargin, false);
        }
    }

    void sendAccessibleTextCaretMoved() {
        if (this.caretOffset != this.accCaretOffset) {
            this.accCaretOffset = this.caretOffset;
            this.getAccessible().textCaretMoved(this.caretOffset);
        }
    }

    void sendAccessibleTextChanged(int n2, int n3, int n4) {
        Accessible accessible = this.getAccessible();
        if (n4 != 0) {
            accessible.textChanged(1, n2, n4);
        }
        if (n3 != 0) {
            accessible.textChanged(0, n2, n3);
        }
    }

    public void selectAll() {
        this.checkWidget();
        if (this.blockSelection) {
            this.renderer.calculate(0, this.content.getLineCount());
            this.setScrollBars(false);
            int n2 = this.getVerticalScrollOffset();
            int n3 = this.leftMargin - this.horizontalScrollOffset;
            int n4 = this.topMargin - n2;
            int n5 = this.renderer.getWidth() - this.rightMargin - this.horizontalScrollOffset;
            int n6 = this.renderer.getHeight() - this.bottomMargin - n2;
            this.setBlockSelectionLocation(n3, n4, n5, n6, false);
            return;
        }
        this.setSelection(0, Math.max(this.getCharCount(), 0));
    }

    void sendKeyEvent(Event event) {
        if (this.editable) {
            this.modifyContent(event, true);
        }
    }

    StyledTextEvent sendLineEvent(int n2, int n3, String string) {
        StyledTextEvent styledTextEvent = null;
        if (this.isListening(n2)) {
            styledTextEvent = new StyledTextEvent(this.content);
            styledTextEvent.detail = n3;
            styledTextEvent.text = string;
            styledTextEvent.alignment = this.alignment;
            styledTextEvent.indent = this.indent;
            styledTextEvent.wrapIndent = this.wrapIndent;
            styledTextEvent.justify = this.justify;
            this.notifyListeners(n2, styledTextEvent);
        }
        return styledTextEvent;
    }

    void sendSelectionEvent() {
        this.getAccessible().textSelectionChanged();
        Event event = new Event();
        event.x = this.selection.x;
        event.y = this.selection.y;
        this.notifyListeners(13, event);
    }

    int sendTextEvent(int n2, int n3, int n4, String string, boolean bl2) {
        int n5;
        int n6;
        int n7;
        int n8;
        Object object;
        int n9 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        if (n4 < this.content.getLineCount()) {
            object = new int[1];
            n8 = this.getOffsetAtPoint(n2, this.getLinePixel(n4), (int[])object, true);
            if (n8 == -1) {
                n7 = this.content.getOffsetAtLine(n4);
                n6 = this.content.getLine(n4).length();
                n8 = n5 = n7 + n6;
                if (bl2) {
                    TextLayout textLayout = this.renderer.getTextLayout(n4);
                    n9 = textLayout.getBounds().width;
                    this.renderer.disposeTextLayout(textLayout);
                }
            } else {
                n5 = n2 == n3 ? (n8 += object[0]) : this.getOffsetAtPoint(n3, 0, n4, null);
                bl2 = false;
            }
        } else {
            n8 = n5 = this.content.getCharCount();
            stringBuffer.append(this.content.getLineDelimiter());
        }
        if (n8 > n5) {
            int n10 = n8;
            n8 = n5;
            n5 = n10;
        }
        if (bl2) {
            int n11 = n2 - n9 + this.horizontalScrollOffset - this.leftMargin;
            n7 = n11 / this.renderer.averageCharWidth;
            for (n6 = 0; n6 < n7; ++n6) {
                stringBuffer.append(' ');
            }
        }
        stringBuffer.append(string);
        object = new Event();
        object.start = n8;
        object.end = n5;
        object.text = stringBuffer.toString();
        this.sendKeyEvent((Event)object);
        return object.start + object.text.length();
    }

    int sendWordBoundaryEvent(int n2, int n3, int n4, int n5, String string, int n6) {
        if (this.isListening(n2)) {
            StyledTextEvent styledTextEvent = new StyledTextEvent(this.content);
            styledTextEvent.detail = n6;
            styledTextEvent.text = string;
            styledTextEvent.count = n3;
            styledTextEvent.start = n4;
            styledTextEvent.end = n5;
            this.notifyListeners(n2, styledTextEvent);
            n4 = styledTextEvent.end;
            if (n4 != n5) {
                int n7 = this.getCharCount();
                if (n4 < 0) {
                    n4 = 0;
                } else if (n4 > n7) {
                    n4 = n7;
                } else if (this.isLineDelimiter(n4)) {
                    SWT.error(5);
                }
            }
            return n4;
        }
        return n5;
    }

    void setAlignment() {
        if ((this.getStyle() & 4) == 0) {
            return;
        }
        int n2 = this.renderer.getLineAlignment(0, this.alignment);
        int n3 = 0;
        if (n2 != 16384) {
            this.renderer.calculate(0, 1);
            int n4 = this.renderer.getWidth() - this.alignmentMargin;
            n3 = this.clientAreaWidth - n4;
            if (n3 < 0) {
                n3 = 0;
            }
            if (n2 == 0x1000000) {
                n3 /= 2;
            }
        }
        if (this.alignmentMargin != n3) {
            this.leftMargin -= this.alignmentMargin;
            this.leftMargin += n3;
            this.alignmentMargin = n3;
            this.resetCache(0, 1);
            this.setCaretLocation();
            super.redraw();
        }
    }

    public void setAlignment(int n2) {
        this.checkWidget();
        if ((n2 &= 0x1024000) == 0 || this.alignment == n2) {
            return;
        }
        this.alignment = n2;
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        this.setAlignment();
        super.redraw();
    }

    public void setAlwaysShowScrollBars(boolean bl2) {
        this.checkWidget();
        if (bl2 == this.alwaysShowScroll) {
            return;
        }
        this.alwaysShowScroll = bl2;
        this.setScrollBars(true);
    }

    @Override
    public void setBackground(Color color) {
        this.checkWidget();
        this.background = color;
        super.setBackground(color);
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        super.redraw();
    }

    public void setBlockSelection(boolean bl2) {
        int n2;
        this.checkWidget();
        if ((this.getStyle() & 4) != 0) {
            return;
        }
        if (bl2 == this.blockSelection) {
            return;
        }
        if (this.wordWrap) {
            return;
        }
        this.blockSelection = bl2;
        if (this.cursor == null) {
            Display display = this.getDisplay();
            n2 = bl2 ? 2 : 19;
            super.setCursor(display.getSystemCursor(n2));
        }
        if (bl2) {
            int n3 = this.selection.x;
            n2 = this.selection.y;
            if (n3 != n2) {
                this.setBlockSelectionOffset(n3, n2, false);
            }
        } else {
            this.clearBlockSelection(false, false);
        }
    }

    public void setBlockSelectionBounds(Rectangle rectangle) {
        this.checkWidget();
        if (rectangle == null) {
            SWT.error(4);
        }
        this.setBlockSelectionBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setBlockSelectionBounds(int n2, int n3, int n4, int n5) {
        this.checkWidget();
        int n6 = this.getVerticalScrollOffset();
        if (!this.blockSelection) {
            int n7 = this.getOffsetAtPoint(n2 -= this.horizontalScrollOffset, n3 -= n6, null);
            int n8 = this.getOffsetAtPoint(n2 + n4 - 1, n3 + n5 - 1, null);
            this.setSelection(n7, n8 - n7, false, false);
            this.setCaretLocation();
            return;
        }
        int n9 = this.topMargin;
        int n10 = this.leftMargin;
        int n11 = this.renderer.getHeight() - this.bottomMargin;
        int n12 = Math.max(this.clientAreaWidth, this.renderer.getWidth()) - this.rightMargin;
        int n13 = Math.max(n10, Math.min(n12, n2)) - this.horizontalScrollOffset;
        int n14 = Math.max(n9, Math.min(n11, n3)) - n6;
        int n15 = Math.max(n10, Math.min(n12, n2 + n4)) - this.horizontalScrollOffset;
        int n16 = Math.max(n9, Math.min(n11, n3 + n5 - 1)) - n6;
        if (this.isFixedLineHeight() && this.renderer.fixedPitch) {
            int n17 = this.renderer.averageCharWidth;
            n13 = (n13 - this.leftMargin + this.horizontalScrollOffset) / n17 * n17 + this.leftMargin - this.horizontalScrollOffset;
            n15 = (n15 + n17 / 2 - this.leftMargin + this.horizontalScrollOffset) / n17 * n17 + this.leftMargin - this.horizontalScrollOffset;
        }
        this.setBlockSelectionLocation(n13, n14, n15, n16, false);
    }

    void setBlockSelectionLocation(int n2, int n3, boolean bl2) {
        int n4 = this.getVerticalScrollOffset();
        this.blockXLocation = n2 + this.horizontalScrollOffset;
        this.blockYLocation = n3 + n4;
        int[] nArray = new int[1];
        int n5 = this.getOffsetAtPoint(n2, n3, nArray);
        this.setCaretOffset(n5, nArray[0]);
        if (this.blockXAnchor == -1) {
            this.blockXAnchor = this.blockXLocation;
            this.blockYAnchor = this.blockYLocation;
            this.selectionAnchor = this.caretOffset;
        }
        this.doBlockSelection(bl2);
    }

    void setBlockSelectionLocation(int n2, int n3, int n4, int n5, boolean bl2) {
        int n6 = this.getVerticalScrollOffset();
        this.blockXAnchor = n2 + this.horizontalScrollOffset;
        this.blockYAnchor = n3 + n6;
        this.selectionAnchor = this.getOffsetAtPoint(n2, n3, null);
        this.setBlockSelectionLocation(n4, n5, bl2);
    }

    void setBlockSelectionOffset(int n2, boolean bl2) {
        Point point = this.getPointAtOffset(n2);
        int n3 = this.getVerticalScrollOffset();
        this.blockXLocation = point.x + this.horizontalScrollOffset;
        this.blockYLocation = point.y + n3;
        this.setCaretOffset(n2, -1);
        if (this.blockXAnchor == -1) {
            this.blockXAnchor = this.blockXLocation;
            this.blockYAnchor = this.blockYLocation;
            this.selectionAnchor = this.caretOffset;
        }
        this.doBlockSelection(bl2);
    }

    void setBlockSelectionOffset(int n2, int n3, boolean bl2) {
        int n4 = this.getVerticalScrollOffset();
        Point point = this.getPointAtOffset(n2);
        this.blockXAnchor = point.x + this.horizontalScrollOffset;
        this.blockYAnchor = point.y + n4;
        this.selectionAnchor = n2;
        this.setBlockSelectionOffset(n3, bl2);
    }

    @Override
    public void setCaret(Caret caret) {
        this.checkWidget();
        super.setCaret(caret);
        this.caretDirection = 0;
        if (caret != null) {
            this.setCaretLocation();
        }
    }

    public void setBidiColoring(boolean bl2) {
        this.checkWidget();
        this.bidiColoring = bl2;
    }

    public void setBottomMargin(int n2) {
        this.checkWidget();
        this.setMargins(this.leftMargin, this.topMargin, this.rightMargin, n2);
    }

    void setCaretLocation() {
        Point point = this.getPointAtOffset(this.caretOffset);
        this.setCaretLocation(point, this.getCaretDirection());
    }

    void setCaretLocation(Point point, int n2) {
        Caret caret = this.getCaret();
        if (caret != null) {
            int n3;
            boolean bl2 = caret == this.defaultCaret;
            int n4 = n3 = this.renderer.getLineHeight();
            if (!this.isFixedLineHeight() && bl2 && (n4 = this.getBoundsAtOffset((int)this.caretOffset).height) != n3) {
                n2 = -1;
            }
            int n5 = n2;
            if (this.isMirrored()) {
                if (n5 == 16384) {
                    n5 = 131072;
                } else if (n5 == 131072) {
                    n5 = 16384;
                }
            }
            if (bl2 && n5 == 131072) {
                point.x -= caret.getSize().x - 1;
            }
            if (bl2) {
                caret.setBounds(point.x, point.y, this.caretWidth, n4);
            } else {
                caret.setLocation(point);
            }
            if (n2 != this.caretDirection) {
                this.caretDirection = n2;
                if (bl2) {
                    if (n5 == -1) {
                        this.defaultCaret.setImage(null);
                    } else if (n5 == 16384) {
                        this.defaultCaret.setImage(this.leftCaretBitmap);
                    } else if (n5 == 131072) {
                        this.defaultCaret.setImage(this.rightCaretBitmap);
                    }
                }
                if (this.caretDirection == 16384) {
                    BidiUtil.setKeyboardLanguage(0);
                } else if (this.caretDirection == 131072) {
                    BidiUtil.setKeyboardLanguage(1);
                }
            }
            this.updateCaretVisibility();
        }
        this.columnX = point.x;
    }

    public void setCaretOffset(int n2) {
        this.checkWidget();
        int n3 = this.getCharCount();
        if (n3 > 0 && n2 != this.caretOffset) {
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > n3) {
                n2 = n3;
            } else if (this.isLineDelimiter(n2)) {
                SWT.error(5);
            }
            this.setCaretOffset(n2, 0);
            if (this.blockSelection) {
                this.clearBlockSelection(true, false);
            } else {
                this.clearSelection(false);
            }
        }
        this.setCaretLocation();
    }

    void setCaretOffset(int n2, int n3) {
        if (this.caretOffset != n2) {
            this.caretOffset = n2;
            if (this.isListening(3011)) {
                StyledTextEvent styledTextEvent = new StyledTextEvent(this.content);
                styledTextEvent.end = this.caretOffset;
                this.notifyListeners(3011, styledTextEvent);
            }
        }
        if (n3 != -1) {
            this.caretAlignment = n3;
        }
    }

    void setClipboardContent(int n2, int n3, int n4) {
        Transfer[] transferArray;
        Object[] objectArray;
        if (n4 == 2 && !IS_GTK) {
            return;
        }
        TextTransfer textTransfer = TextTransfer.getInstance();
        StyledText$TextWriter styledText$TextWriter = new StyledText$TextWriter(this, n2, n3);
        String string = this.getPlatformDelimitedText(styledText$TextWriter);
        if (n4 == 2) {
            objectArray = new Object[]{string};
            transferArray = new Transfer[]{textTransfer};
        } else {
            RTFTransfer rTFTransfer = RTFTransfer.getInstance();
            StyledText$RTFWriter styledText$RTFWriter = new StyledText$RTFWriter(this, n2, n3);
            String string2 = this.getPlatformDelimitedText(styledText$RTFWriter);
            objectArray = new Object[]{string2, string};
            transferArray = new Transfer[]{rTFTransfer, textTransfer};
        }
        this.clipboard.setContents(objectArray, transferArray, n4);
    }

    public void setContent(StyledTextContent styledTextContent) {
        this.checkWidget();
        if (styledTextContent == null) {
            SWT.error(4);
        }
        if (this.content != null) {
            this.content.removeTextChangeListener(this.textChangeListener);
        }
        this.content = styledTextContent;
        this.content.addTextChangeListener(this.textChangeListener);
        this.reset();
    }

    @Override
    public void setCursor(Cursor cursor) {
        this.checkWidget();
        if (cursor != null && cursor.isDisposed()) {
            SWT.error(5);
        }
        this.cursor = cursor;
        if (cursor == null) {
            Display display = this.getDisplay();
            int n2 = this.blockSelection ? 2 : 19;
            super.setCursor(display.getSystemCursor(n2));
        } else {
            super.setCursor(cursor);
        }
    }

    public void setDoubleClickEnabled(boolean bl2) {
        this.checkWidget();
        this.doubleClickEnabled = bl2;
    }

    @Override
    public void setDragDetect(boolean bl2) {
        this.checkWidget();
        this.dragDetect = bl2;
    }

    public void setEditable(boolean bl2) {
        this.checkWidget();
        this.editable = bl2;
    }

    @Override
    public void setFont(Font font) {
        int n2;
        this.checkWidget();
        int n3 = this.renderer.getLineHeight();
        super.setFont(font);
        this.renderer.setFont(this.getFont(), this.tabLength);
        if (this.isFixedLineHeight() && (n2 = this.renderer.getLineHeight()) != n3) {
            int n4 = this.getVerticalScrollOffset() * n2 / n3 - this.getVerticalScrollOffset();
            this.scrollVertical(n4, true);
        }
        this.resetCache(0, this.content.getLineCount());
        this.claimBottomFreeSpace();
        this.calculateScrollBars();
        if (this.isBidiCaret()) {
            this.createCaretBitmaps();
        }
        this.caretDirection = 0;
        this.setCaretLocation();
        super.redraw();
    }

    @Override
    public void setForeground(Color color) {
        this.checkWidget();
        this.foreground = color;
        super.setForeground(this.getForeground());
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        super.redraw();
    }

    public void setHorizontalIndex(int n2) {
        int n3;
        this.checkWidget();
        if (this.getCharCount() == 0) {
            return;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (this.clientAreaWidth > 0 && (n2 *= this.getHorizontalIncrement()) > (n3 = this.renderer.getWidth()) - this.clientAreaWidth) {
            n2 = Math.max(0, n3 - this.clientAreaWidth);
        }
        this.scrollHorizontal(n2 - this.horizontalScrollOffset, true);
    }

    public void setHorizontalPixel(int n2) {
        int n3;
        this.checkWidget();
        if (this.getCharCount() == 0) {
            return;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (this.clientAreaWidth > 0 && n2 > (n3 = this.renderer.getWidth()) - this.clientAreaWidth) {
            n2 = Math.max(0, n3 - this.clientAreaWidth);
        }
        this.scrollHorizontal(n2 - this.horizontalScrollOffset, true);
    }

    public void setIndent(int n2) {
        this.checkWidget();
        if (this.indent == n2 || n2 < 0) {
            return;
        }
        this.indent = n2;
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        super.redraw();
    }

    public void setJustify(boolean bl2) {
        this.checkWidget();
        if (this.justify == bl2) {
            return;
        }
        this.justify = bl2;
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        super.redraw();
    }

    public void setKeyBinding(int n2, int n3) {
        this.checkWidget();
        int n4 = n2 & SWT.MODIFIER_MASK;
        int n5 = n2 & 0x100FFFF;
        char c2 = (char)n5;
        if (Character.isDefined(n5) && Character.isLetter(c2)) {
            char c3 = Character.toUpperCase(c2);
            int n6 = c3 | n4;
            if (n3 == 0) {
                this.keyActionMap.remove(n6);
            } else {
                this.keyActionMap.put(n6, n3);
            }
            c3 = Character.toLowerCase(c2);
            n6 = c3 | n4;
            if (n3 == 0) {
                this.keyActionMap.remove(n6);
            } else {
                this.keyActionMap.put(n6, n3);
            }
        } else if (n3 == 0) {
            this.keyActionMap.remove(n2);
        } else {
            this.keyActionMap.put(n2, n3);
        }
    }

    public void setLeftMargin(int n2) {
        this.checkWidget();
        this.setMargins(n2, this.topMargin, this.rightMargin, this.bottomMargin);
    }

    public void setLineAlignment(int n2, int n3, int n4) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (n2 < 0 || n2 + n3 > this.content.getLineCount()) {
            SWT.error(5);
        }
        this.renderer.setLineAlignment(n2, n3, n4);
        this.resetCache(n2, n3);
        this.redrawLines(n2, n3, false);
        int n5 = this.getCaretLine();
        if (n2 <= n5 && n5 < n2 + n3) {
            this.setCaretLocation();
        }
        this.setAlignment();
    }

    public void setLineBackground(int n2, int n3, Color color) {
        this.checkWidget();
        if (this.isListening(3001)) {
            return;
        }
        if (n2 < 0 || n2 + n3 > this.content.getLineCount()) {
            SWT.error(5);
        }
        if (color != null) {
            this.renderer.setLineBackground(n2, n3, color);
        } else {
            this.renderer.clearLineBackground(n2, n3);
        }
        this.redrawLines(n2, n3, false);
    }

    public void setLineBullet(int n2, int n3, Bullet bullet) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (n2 < 0 || n2 + n3 > this.content.getLineCount()) {
            SWT.error(5);
        }
        int n4 = this.getLinePixel(n2 + n3);
        this.renderer.setLineBullet(n2, n3, bullet);
        this.resetCache(n2, n3);
        int n5 = this.getLinePixel(n2 + n3);
        this.redrawLines(n2, n3, n4 != n5);
        int n6 = this.getCaretLine();
        if (n2 <= n6 && n6 < n2 + n3) {
            this.setCaretLocation();
        }
    }

    void setVariableLineHeight() {
        if (!this.fixedLineHeight) {
            return;
        }
        this.fixedLineHeight = false;
        this.renderer.calculateIdle();
    }

    public void setLineIndent(int n2, int n3, int n4) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (n2 < 0 || n2 + n3 > this.content.getLineCount()) {
            SWT.error(5);
        }
        int n5 = this.getLinePixel(n2 + n3);
        this.renderer.setLineIndent(n2, n3, n4);
        this.resetCache(n2, n3);
        int n6 = this.getLinePixel(n2 + n3);
        this.redrawLines(n2, n3, n5 != n6);
        int n7 = this.getCaretLine();
        if (n2 <= n7 && n7 < n2 + n3) {
            this.setCaretLocation();
        }
    }

    public void setLineJustify(int n2, int n3, boolean bl2) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (n2 < 0 || n2 + n3 > this.content.getLineCount()) {
            SWT.error(5);
        }
        this.renderer.setLineJustify(n2, n3, bl2);
        this.resetCache(n2, n3);
        this.redrawLines(n2, n3, false);
        int n4 = this.getCaretLine();
        if (n2 <= n4 && n4 < n2 + n3) {
            this.setCaretLocation();
        }
    }

    public void setLineSpacing(int n2) {
        this.checkWidget();
        if (this.lineSpacing == n2 || n2 < 0) {
            return;
        }
        this.lineSpacing = n2;
        this.setVariableLineHeight();
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        super.redraw();
    }

    public void setLineTabStops(int n2, int n3, int[] nArray) {
        int n4;
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (n2 < 0 || n2 + n3 > this.content.getLineCount()) {
            SWT.error(5);
        }
        if (nArray != null) {
            n4 = 0;
            int[] nArray2 = new int[nArray.length];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (nArray[i2] < n4) {
                    SWT.error(5);
                }
                nArray2[i2] = n4 = nArray[i2];
            }
            this.renderer.setLineTabStops(n2, n3, nArray2);
        } else {
            this.renderer.setLineTabStops(n2, n3, null);
        }
        this.resetCache(n2, n3);
        this.redrawLines(n2, n3, false);
        n4 = this.getCaretLine();
        if (n2 <= n4 && n4 < n2 + n3) {
            this.setCaretLocation();
        }
    }

    public void setLineWrapIndent(int n2, int n3, int n4) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (n2 < 0 || n2 + n3 > this.content.getLineCount()) {
            SWT.error(5);
        }
        int n5 = this.getLinePixel(n2 + n3);
        this.renderer.setLineWrapIndent(n2, n3, n4);
        this.resetCache(n2, n3);
        int n6 = this.getLinePixel(n2 + n3);
        this.redrawLines(n2, n3, n5 != n6);
        int n7 = this.getCaretLine();
        if (n2 <= n7 && n7 < n2 + n3) {
            this.setCaretLocation();
        }
    }

    public void setMarginColor(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        this.marginColor = color;
        super.redraw();
    }

    public void setMargins(int n2, int n3, int n4, int n5) {
        this.checkWidget();
        this.leftMargin = Math.max(0, n2);
        this.topMargin = Math.max(0, n3);
        this.rightMargin = Math.max(0, n4);
        this.bottomMargin = Math.max(0, n5);
        this.resetCache(0, this.content.getLineCount());
        this.setScrollBars(true);
        this.setCaretLocation();
        this.setAlignment();
        super.redraw();
    }

    void setMouseWordSelectionAnchor() {
        if (this.clickCount > 1) {
            if (this.caretOffset < this.doubleClickSelection.x) {
                this.selectionAnchor = this.doubleClickSelection.y;
            } else if (this.caretOffset > this.doubleClickSelection.y) {
                this.selectionAnchor = this.doubleClickSelection.x;
            }
        }
    }

    @Override
    public void setOrientation(int n2) {
        int n3 = this.getOrientation();
        super.setOrientation(n2);
        int n4 = this.getOrientation();
        if (n3 != n4) {
            this.resetBidiData();
        }
    }

    public void setRightMargin(int n2) {
        this.checkWidget();
        this.setMargins(this.leftMargin, this.topMargin, n2, this.bottomMargin);
    }

    void setScrollBar(ScrollBar scrollBar, int n2, int n3, int n4) {
        int n5 = 1;
        if (n2 < n3) {
            scrollBar.setMaximum(n3 - n4);
            scrollBar.setThumb(n2 - n4);
            scrollBar.setPageIncrement(n2 - n4);
            if (!this.alwaysShowScroll) {
                scrollBar.setVisible(true);
            }
        } else if (scrollBar.getThumb() != n5 || scrollBar.getMaximum() != n5) {
            scrollBar.setValues(scrollBar.getSelection(), scrollBar.getMinimum(), n5, n5, scrollBar.getIncrement(), n5);
        }
    }

    void setScrollBars(boolean bl2) {
        ++this.ignoreResize;
        if (!this.isFixedLineHeight() || !this.alwaysShowScroll) {
            bl2 = true;
        }
        ScrollBar scrollBar = bl2 ? this.getVerticalBar() : null;
        ScrollBar scrollBar2 = this.getHorizontalBar();
        int n2 = this.clientAreaHeight;
        int n3 = this.clientAreaWidth;
        if (!this.alwaysShowScroll) {
            if (scrollBar != null) {
                scrollBar.setVisible(false);
            }
            if (scrollBar2 != null) {
                scrollBar2.setVisible(false);
            }
        }
        if (scrollBar != null) {
            this.setScrollBar(scrollBar, this.clientAreaHeight, this.renderer.getHeight(), this.topMargin + this.bottomMargin);
        }
        if (scrollBar2 != null && !this.wordWrap) {
            this.setScrollBar(scrollBar2, this.clientAreaWidth, this.renderer.getWidth(), this.leftMargin + this.rightMargin);
            if (!this.alwaysShowScroll && scrollBar2.getVisible() && scrollBar != null) {
                this.setScrollBar(scrollBar, this.clientAreaHeight, this.renderer.getHeight(), this.topMargin + this.bottomMargin);
                if (scrollBar.getVisible()) {
                    this.setScrollBar(scrollBar2, this.clientAreaWidth, this.renderer.getWidth(), this.leftMargin + this.rightMargin);
                }
            }
        }
        if (!this.alwaysShowScroll) {
            this.redrawMargins(n2, n3);
        }
        --this.ignoreResize;
    }

    public void setSelection(int n2) {
        this.setSelection(n2, n2);
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            SWT.error(4);
        }
        this.setSelection(point.x, point.y);
    }

    public void setSelectionBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        this.selectionBackground = color;
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        super.redraw();
    }

    public void setSelectionForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        this.selectionForeground = color;
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        super.redraw();
    }

    public void setSelection(int n2, int n3) {
        this.setSelectionRange(n2, n3 - n2);
        this.showSelection();
    }

    void setSelection(int n2, int n3, boolean bl2, boolean bl3) {
        int n4;
        int n5 = n2 + n3;
        if (n2 > n5) {
            n4 = n5;
            n5 = n2;
            n2 = n4;
        }
        if (this.selection.x != n2 || this.selection.y != n5 || n3 > 0 && this.selectionAnchor != this.selection.x || n3 < 0 && this.selectionAnchor != this.selection.y) {
            if (this.blockSelection && bl3) {
                if (n3 < 0) {
                    this.setBlockSelectionOffset(n5, n2, bl2);
                } else {
                    this.setBlockSelectionOffset(n2, n5, bl2);
                }
            } else {
                n4 = this.selection.x;
                int n6 = this.selection.y - this.selection.x;
                int n7 = this.content.getCharCount();
                int n8 = Math.min(this.selection.x, n7);
                int n9 = Math.min(this.selection.y, n7);
                if (n3 < 0) {
                    this.selectionAnchor = this.selection.y = n5;
                    this.selection.x = n2;
                    this.setCaretOffset(n2, 0);
                } else {
                    this.selectionAnchor = this.selection.x = n2;
                    this.selection.y = n5;
                    this.setCaretOffset(n5, 0);
                }
                n8 = Math.min(n8, this.selection.x);
                n9 = Math.max(n9, this.selection.y);
                if (n9 - n8 > 0) {
                    this.internalRedrawRange(n8, n9 - n8);
                }
                if (bl2 && (n6 != n5 - n2 || n6 != 0 && n4 != n2)) {
                    this.sendSelectionEvent();
                }
                this.sendAccessibleTextCaretMoved();
            }
        }
    }

    public void setSelectionRange(int n2, int n3) {
        this.checkWidget();
        int n4 = this.getCharCount();
        n2 = Math.max(0, Math.min(n2, n4));
        int n5 = n2 + n3;
        if (n5 < 0) {
            n3 = -n2;
        } else if (n5 > n4) {
            n3 = n4 - n2;
        }
        if (this.isLineDelimiter(n2) || this.isLineDelimiter(n2 + n3)) {
            SWT.error(5);
        }
        this.setSelection(n2, n3, false, true);
        this.setCaretLocation();
    }

    public void setStyleRange(StyleRange styleRange) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (styleRange != null) {
            if (styleRange.isUnstyled()) {
                this.setStyleRanges(styleRange.start, styleRange.length, null, null, false);
            } else {
                this.setStyleRanges(styleRange.start, 0, null, new StyleRange[]{styleRange}, false);
            }
        } else {
            this.setStyleRanges(0, 0, null, null, true);
        }
    }

    public void setStyleRanges(int n2, int n3, int[] nArray, StyleRange[] styleRangeArray) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (nArray == null || styleRangeArray == null) {
            this.setStyleRanges(n2, n3, null, null, false);
        } else {
            this.setStyleRanges(n2, n3, nArray, styleRangeArray, false);
        }
    }

    public void setStyleRanges(int[] nArray, StyleRange[] styleRangeArray) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (nArray == null || styleRangeArray == null) {
            this.setStyleRanges(0, 0, null, null, true);
        } else {
            this.setStyleRanges(0, 0, nArray, styleRangeArray, true);
        }
    }

    void setStyleRanges(int n2, int n3, int[] nArray, StyleRange[] styleRangeArray, boolean bl2) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = this.content.getCharCount();
        int n11 = n2 + n3;
        if (n2 > n11 || n2 < 0) {
            SWT.error(6);
        }
        if (styleRangeArray != null) {
            if (n11 > n10) {
                SWT.error(6);
            }
            if (nArray != null && nArray.length != styleRangeArray.length << 1) {
                SWT.error(5);
            }
            n9 = 0;
            n8 = 0;
            for (n7 = 0; n7 < styleRangeArray.length; ++n7) {
                if (styleRangeArray[n7] == null) {
                    SWT.error(5);
                }
                if (nArray != null) {
                    n6 = nArray[n7 << 1];
                    n5 = nArray[(n7 << 1) + 1];
                } else {
                    n6 = styleRangeArray[n7].start;
                    n5 = styleRangeArray[n7].length;
                }
                if (n5 < 0) {
                    SWT.error(5);
                }
                if (0 > n6 || n6 + n5 > n10) {
                    SWT.error(5);
                }
                if (n9 > n6) {
                    SWT.error(5);
                }
                n8 |= styleRangeArray[n7].isVariableHeight();
                n9 = n6 + n5;
            }
            if (n8 != 0) {
                this.setVariableLineHeight();
            }
        }
        n9 = n2;
        n8 = n11;
        if (styleRangeArray != null && styleRangeArray.length > 0) {
            if (nArray != null) {
                n9 = nArray[0];
                n8 = nArray[nArray.length - 2] + nArray[nArray.length - 1];
            } else {
                n9 = styleRangeArray[0].start;
                n8 = styleRangeArray[styleRangeArray.length - 1].start + styleRangeArray[styleRangeArray.length - 1].length;
            }
        }
        n7 = 0;
        if (!this.isFixedLineHeight() && !bl2) {
            n6 = this.content.getLineAtOffset(Math.max(n11, n8));
            n5 = this.getPartialTopIndex();
            n4 = this.getPartialBottomIndex();
            if (n5 <= n6 && n6 <= n4) {
                n7 = this.getLinePixel(n6 + 1);
            }
        }
        if (bl2) {
            this.renderer.setStyleRanges(null, null);
        } else {
            this.renderer.updateRanges(n2, n3, n3);
        }
        if (styleRangeArray != null && styleRangeArray.length > 0) {
            this.renderer.setStyleRanges(nArray, styleRangeArray);
        }
        if (bl2) {
            this.resetCache(0, this.content.getLineCount());
            super.redraw();
        } else {
            n6 = this.content.getLineAtOffset(Math.min(n2, n9));
            n5 = this.content.getLineAtOffset(Math.max(n11, n8));
            this.resetCache(n6, n5 - n6 + 1);
            n4 = this.getPartialTopIndex();
            int n12 = this.getPartialBottomIndex();
            if (n6 <= n12 && n5 >= n4) {
                int n13 = 0;
                int n14 = this.clientAreaHeight;
                if (n4 <= n6 && n6 <= n12) {
                    n13 = Math.max(0, this.getLinePixel(n6));
                }
                if (n4 <= n5 && n5 <= n12) {
                    n14 = this.getLinePixel(n5 + 1);
                }
                if (!this.isFixedLineHeight() && n14 != n7) {
                    n14 = this.clientAreaHeight;
                }
                super.redraw(0, n13, this.clientAreaWidth, n14 - n13, false);
            }
        }
        n6 = this.columnX;
        this.setCaretLocation();
        this.columnX = n6;
        this.doMouseLinkCursor();
    }

    public void setStyleRanges(StyleRange[] styleRangeArray) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (styleRangeArray == null) {
            SWT.error(4);
        }
        this.setStyleRanges(0, 0, null, styleRangeArray, true);
    }

    public void setTabs(int n2) {
        this.checkWidget();
        this.tabLength = n2;
        this.renderer.setFont(null, n2);
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        super.redraw();
    }

    public void setTabStops(int[] nArray) {
        this.checkWidget();
        if (nArray != null) {
            int n2 = 0;
            int[] nArray2 = new int[nArray.length];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (nArray[i2] < n2) {
                    SWT.error(5);
                }
                nArray2[i2] = n2 = nArray[i2];
            }
            this.tabs = nArray2;
        } else {
            this.tabs = null;
        }
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        super.redraw();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        Event event = new Event();
        event.start = 0;
        event.end = this.getCharCount();
        event.text = string;
        event.doit = true;
        this.notifyListeners(25, event);
        if (event.doit) {
            StyledTextEvent styledTextEvent = null;
            if (this.isListening(3000)) {
                styledTextEvent = new StyledTextEvent(this.content);
                styledTextEvent.start = event.start;
                styledTextEvent.end = event.start + event.text.length();
                styledTextEvent.text = this.content.getTextRange(event.start, event.end - event.start);
            }
            this.content.setText(event.text);
            this.notifyListeners(24, event);
            if (styledTextEvent != null) {
                this.notifyListeners(3000, styledTextEvent);
            }
        }
    }

    @Override
    public void setTextDirection(int n2) {
        this.checkWidget();
        int n3 = this.getStyle();
        super.setTextDirection(n2);
        if (this.isAutoDirection() || n3 != this.getStyle()) {
            this.resetBidiData();
        }
    }

    public void setTextLimit(int n2) {
        this.checkWidget();
        if (n2 == 0) {
            SWT.error(7);
        }
        this.textLimit = n2;
    }

    public void setTopIndex(int n2) {
        int n3;
        this.checkWidget();
        if (this.getCharCount() == 0) {
            return;
        }
        int n4 = this.content.getLineCount();
        if (this.isFixedLineHeight()) {
            int n5 = Math.max(1, Math.min(n4, this.getLineCountWhole()));
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > n4 - n5) {
                n2 = n4 - n5;
            }
            n3 = this.getLinePixel(n2);
        } else {
            n3 = this.getLinePixel(n2 = Math.max(0, Math.min(n4 - 1, n2)));
            n3 = n3 > 0 ? this.getAvailableHeightBellow(n3) : this.getAvailableHeightAbove(n3);
        }
        this.scrollVertical(n3, true);
    }

    public void setTopMargin(int n2) {
        this.checkWidget();
        this.setMargins(this.leftMargin, n2, this.rightMargin, this.bottomMargin);
    }

    public void setTopPixel(int n2) {
        this.checkWidget();
        if (this.getCharCount() == 0) {
            return;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = this.content.getLineCount();
        int n4 = this.clientAreaHeight - this.topMargin - this.bottomMargin;
        int n5 = this.getVerticalScrollOffset();
        if (this.isFixedLineHeight()) {
            int n6 = Math.max(0, n3 * this.getVerticalIncrement() - n4);
            if (n2 > n6) {
                n2 = n6;
            }
            n2 -= n5;
        } else if ((n2 -= n5) > 0) {
            n2 = this.getAvailableHeightBellow(n2);
        }
        this.scrollVertical(n2, true);
    }

    public void setWordWrap(boolean bl2) {
        this.checkWidget();
        if ((this.getStyle() & 4) != 0) {
            return;
        }
        if (this.wordWrap == bl2) {
            return;
        }
        if (this.wordWrap && this.blockSelection) {
            this.setBlockSelection(false);
        }
        this.wordWrap = bl2;
        this.setVariableLineHeight();
        this.resetCache(0, this.content.getLineCount());
        this.horizontalScrollOffset = 0;
        ScrollBar scrollBar = this.getHorizontalBar();
        if (scrollBar != null) {
            scrollBar.setVisible(!this.wordWrap);
        }
        this.setScrollBars(true);
        this.setCaretLocation();
        super.redraw();
    }

    public void setWrapIndent(int n2) {
        this.checkWidget();
        if (this.wrapIndent == n2 || n2 < 0) {
            return;
        }
        this.wrapIndent = n2;
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        super.redraw();
    }

    boolean showLocation(Rectangle rectangle, boolean bl2) {
        boolean bl3 = false;
        if (rectangle.y < this.topMargin) {
            bl3 = this.scrollVertical(rectangle.y - this.topMargin, true);
        } else if (rectangle.y + rectangle.height > this.clientAreaHeight - this.bottomMargin) {
            bl3 = this.clientAreaHeight - this.topMargin - this.bottomMargin <= 0 ? this.scrollVertical(rectangle.y - this.topMargin, true) : this.scrollVertical(rectangle.y + rectangle.height - (this.clientAreaHeight - this.bottomMargin), true);
        }
        int n2 = this.clientAreaWidth - this.rightMargin - this.leftMargin;
        if (n2 > 0) {
            int n3;
            int n4 = n3 = bl2 ? n2 / 4 : 0;
            if (rectangle.x < this.leftMargin) {
                int n5 = Math.max(this.leftMargin - rectangle.x, n3);
                int n6 = this.horizontalScrollOffset;
                bl3 = this.scrollHorizontal(-Math.min(n6, n5), true);
            } else if (rectangle.x + rectangle.width > this.clientAreaWidth - this.rightMargin) {
                int n7 = Math.max(rectangle.x + rectangle.width - (this.clientAreaWidth - this.rightMargin), n3);
                int n8 = this.renderer.getWidth() - this.horizontalScrollOffset - this.clientAreaWidth;
                bl3 = this.scrollHorizontal(Math.min(n8, n7), true);
            }
        }
        return bl3;
    }

    void showCaret() {
        Rectangle rectangle = this.getBoundsAtOffset(this.caretOffset);
        if (!this.showLocation(rectangle, true)) {
            this.setCaretLocation();
        }
    }

    public void showSelection() {
        boolean bl2;
        int n2;
        int n3;
        boolean bl3;
        this.checkWidget();
        boolean bl4 = bl3 = this.caretOffset == this.selection.x;
        if (bl3) {
            n3 = this.selection.y;
            n2 = this.selection.x;
        } else {
            n3 = this.selection.x;
            n2 = this.selection.y;
        }
        Rectangle rectangle = this.getBoundsAtOffset(n3);
        Rectangle rectangle2 = this.getBoundsAtOffset(n2);
        int n4 = this.clientAreaWidth - this.leftMargin - this.rightMargin;
        boolean bl5 = bl3 ? rectangle.x - rectangle2.x <= n4 : (bl2 = rectangle2.x - rectangle.x <= n4);
        if (bl2) {
            if (this.showLocation(rectangle, false)) {
                rectangle2 = this.getBoundsAtOffset(n2);
            }
            rectangle2.width = n2 == this.caretOffset ? this.getCaretWidth() : 0;
            this.showLocation(rectangle2, false);
        } else {
            this.showLocation(rectangle2, true);
        }
    }

    void updateCaretVisibility() {
        Caret caret = this.getCaret();
        if (caret != null) {
            if (this.blockSelection && this.blockXLocation != -1) {
                caret.setVisible(false);
            } else {
                Point point = caret.getLocation();
                Point point2 = caret.getSize();
                boolean bl2 = this.topMargin <= point.y + point2.y && point.y <= this.clientAreaHeight - this.bottomMargin && this.leftMargin <= point.x + point2.x && point.x <= this.clientAreaWidth - this.rightMargin;
                caret.setVisible(bl2);
            }
        }
    }

    void updateSelection(int n2, int n3, int n4) {
        if (this.selection.y <= n2) {
            if (this.wordWrap || this.visualWrap) {
                this.setCaretLocation();
            }
            return;
        }
        if (this.selection.x < n2) {
            this.internalRedrawRange(this.selection.x, n2 - this.selection.x);
        }
        if (this.selection.y > n2 + n3 && this.selection.x < n2 + n3) {
            int n5 = n4 - n3;
            int n6 = n2 + n4;
            this.internalRedrawRange(n6, this.selection.y + n5 - n6);
        }
        if (this.selection.y > n2 && this.selection.x < n2 + n3) {
            this.setSelection(n2 + n4, 0, true, false);
        } else {
            this.setSelection(this.selection.x + n4 - n3, this.selection.y - this.selection.x, true, false);
        }
        this.setCaretLocation();
    }

    static {
        String string = SWT.getPlatform();
        IS_MAC = "cocoa".equals(string);
        IS_GTK = "gtk".equals(string);
    }
}

