/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.OS;

public class URLTransfer
extends ByteArrayTransfer {
    static URLTransfer _instance = new URLTransfer();
    static final String CFSTR_INETURLW = "UniformResourceLocatorW";
    static final int CFSTR_INETURLIDW = URLTransfer.registerType("UniformResourceLocatorW");
    static final String CFSTR_INETURL = "UniformResourceLocator";
    static final int CFSTR_INETURLID = URLTransfer.registerType("UniformResourceLocator");

    private URLTransfer() {
    }

    public static URLTransfer getInstance() {
        return _instance;
    }

    @Override
    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkURL(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        transferData.result = -2147467259;
        String string = (String)object;
        if (transferData.type == CFSTR_INETURLIDW) {
            int n2 = string.length();
            char[] cArray = new char[n2 + 1];
            string.getChars(0, n2, cArray, 0);
            int n3 = cArray.length * 2;
            int n4 = OS.GlobalAlloc(64, n3);
            OS.MoveMemory(n4, cArray, n3);
            transferData.stgmedium = new STGMEDIUM();
            transferData.stgmedium.tymed = 1;
            transferData.stgmedium.unionField = n4;
            transferData.stgmedium.pUnkForRelease = 0;
            transferData.result = 0;
        } else if (transferData.type == CFSTR_INETURLID) {
            int n5 = string.length();
            char[] cArray = new char[n5 + 1];
            string.getChars(0, n5, cArray, 0);
            int n6 = OS.GetACP();
            int n7 = OS.WideCharToMultiByte(n6, 0, cArray, -1, null, 0, null, null);
            if (n7 == 0) {
                transferData.stgmedium = new STGMEDIUM();
                transferData.result = -2147221402;
                return;
            }
            int n8 = OS.GlobalAlloc(64, n7);
            OS.WideCharToMultiByte(n6, 0, cArray, -1, n8, n7, null, null);
            transferData.stgmedium = new STGMEDIUM();
            transferData.stgmedium.tymed = 1;
            transferData.stgmedium.unionField = n8;
            transferData.stgmedium.pUnkForRelease = 0;
            transferData.result = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Object nativeToJava(TransferData var1_1) {
        block21: {
            if (!this.isSupportedType(var1_1) || var1_1.pIDataObject == 0) {
                return null;
            }
            var2_2 = new IDataObject(var1_1.pIDataObject);
            var2_2.AddRef();
            var3_3 = new STGMEDIUM();
            var4_4 = var1_1.formatetc;
            var3_3.tymed = 1;
            var1_1.result = this.getData(var2_2, var4_4, var3_3);
            var2_2.Release();
            if (var1_1.result != 0) {
                return null;
            }
            var5_5 = var3_3.unionField;
            if (var1_1.type == URLTransfer.CFSTR_INETURLIDW) {
                var6_6 = OS.GlobalSize(var5_5) / 2 * 2;
                if (var6_6 == 0) {
                    var7_8 = null;
                    return var7_8;
                }
                var7_9 = new char[var6_6 / 2];
                var8_12 = OS.GlobalLock(var5_5);
                if (var8_12 == 0) {
                    var9_14 = null;
                    return var9_14;
                }
                try {
                    OS.MoveMemory(var7_9, var8_12, var6_6);
                    var9_15 = var7_9.length;
                    for (var10_18 = 0; var10_18 < var7_9.length; ++var10_18) {
                        if (var7_9[var10_18] != '\u0000') continue;
                        var9_15 = var10_18;
                        break;
                    }
                    var10_19 = new String(var7_9, 0, var9_15);
                    return var10_19;
                }
                finally {
                    OS.GlobalUnlock(var5_5);
                }
            }
            if (var1_1.type != URLTransfer.CFSTR_INETURLID) break block21;
            var6_7 = OS.GlobalLock(var5_5);
            if (var6_7 != 0) ** GOTO lbl-1000
            var7_10 = null;
            return var7_10;
lbl-1000:
            // 1 sources

            {
                var7_11 = OS.GetACP();
                var8_13 = OS.MultiByteToWideChar(var7_11, 1, var6_7, -1, null, 0);
                if (var8_13 != 0) ** break block22
                var9_16 = null;
                OS.GlobalUnlock(var5_5);
            }
            return var9_16;
            {
                var9_17 = new char[var8_13 - 1];
                OS.MultiByteToWideChar(var7_11, 1, var6_7, -1, var9_17, var9_17.length);
                var10_20 = new String(var9_17);
                OS.GlobalUnlock(var5_5);
            }
            return var10_20;
            {
                catch (Throwable var12_22) {
                    OS.GlobalUnlock(var5_5);
                    throw var12_22;
                }
            }
            finally {
                OS.GlobalFree(var5_5);
            }
        }
        return null;
    }

    @Override
    protected int[] getTypeIds() {
        return new int[]{CFSTR_INETURLIDW, CFSTR_INETURLID};
    }

    @Override
    protected String[] getTypeNames() {
        return new String[]{CFSTR_INETURLW, CFSTR_INETURL};
    }

    boolean checkURL(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    @Override
    protected boolean validate(Object object) {
        return this.checkURL(object);
    }
}

