/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.util.Arrays;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextLayout$1MetaFileEnumProc;
import org.eclipse.swt.graphics.TextLayout$StyleItem;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.gdip.Rect;
import org.eclipse.swt.internal.win32.EMREXTCREATEFONTINDIRECTW;
import org.eclipse.swt.internal.win32.LOGBRUSH;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LOGFONTA;
import org.eclipse.swt.internal.win32.LOGFONTW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.OUTLINETEXTMETRIC;
import org.eclipse.swt.internal.win32.OUTLINETEXTMETRICA;
import org.eclipse.swt.internal.win32.OUTLINETEXTMETRICW;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCRIPT_ANALYSIS;
import org.eclipse.swt.internal.win32.SCRIPT_CONTROL;
import org.eclipse.swt.internal.win32.SCRIPT_FONTPROPERTIES;
import org.eclipse.swt.internal.win32.SCRIPT_ITEM;
import org.eclipse.swt.internal.win32.SCRIPT_LOGATTR;
import org.eclipse.swt.internal.win32.SCRIPT_PROPERTIES;
import org.eclipse.swt.internal.win32.SCRIPT_STATE;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;

public final class TextLayout
extends Resource {
    Font font;
    String text;
    String segmentsText;
    int lineSpacingInPoints = 0;
    int ascentInPixels = -1;
    int descentInPixels = -1;
    int alignment;
    int wrapWidth = -1;
    int orientation = 0x2000000;
    int textDirection = 0x2000000;
    int indent;
    int wrapIndent;
    boolean justify;
    int[] tabs;
    int[] segments;
    char[] segmentsChars;
    TextLayout$StyleItem[] styles = new TextLayout$StyleItem[2];
    int stylesCount;
    TextLayout$StyleItem[] allRuns;
    TextLayout$StyleItem[][] runs;
    int[] lineOffset;
    int[] lineY;
    int[] lineWidth;
    int mLangFontLink2;
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';
    static final int SCRIPT_VISATTR_SIZEOF = 2;
    static final int GOFFSET_SIZEOF = 8;
    static final byte[] CLSID_CMultiLanguage = new byte[16];
    static final byte[] IID_IMLangFontLink2 = new byte[16];
    static final int MERGE_MAX = 512;
    static final int TOO_MANY_RUNS = 1024;
    static final int UNDERLINE_IME_DOT = 65536;
    static final int UNDERLINE_IME_DASH = 131072;
    static final int UNDERLINE_IME_THICK = 196608;

    public TextLayout(Device device) {
        super(device);
        this.styles[0] = new TextLayout$StyleItem(this);
        this.styles[1] = new TextLayout$StyleItem(this);
        this.stylesCount = 2;
        this.text = "";
        int[] nArray = new int[1];
        OS.OleInitialize(0);
        if (OS.CoCreateInstance(CLSID_CMultiLanguage, 0, 1, IID_IMLangFontLink2, nArray) == 0) {
            this.mLangFontLink2 = nArray[0];
        }
        this.init();
    }

    RECT addClipRect(TextLayout$StyleItem textLayout$StyleItem, RECT rECT, RECT rECT2, int n2, int n3) {
        if (rECT2 != null) {
            boolean bl2;
            if (rECT == null) {
                rECT = new RECT();
                OS.SetRect(rECT, -1, rECT2.top, -1, rECT2.bottom);
            }
            boolean bl3 = bl2 = (this.orientation & 0x4000000) != 0;
            if (textLayout$StyleItem.start <= n2 && n2 <= textLayout$StyleItem.start + textLayout$StyleItem.length) {
                if (textLayout$StyleItem.analysis.fRTL ^ bl2) {
                    rECT.right = rECT2.left;
                } else {
                    rECT.left = rECT2.left;
                }
            }
            if (textLayout$StyleItem.start <= n3 && n3 <= textLayout$StyleItem.start + textLayout$StyleItem.length) {
                if (textLayout$StyleItem.analysis.fRTL ^ bl2) {
                    rECT.left = rECT2.right;
                } else {
                    rECT.right = rECT2.right;
                }
            }
        }
        return rECT;
    }

    void breakRun(TextLayout$StyleItem textLayout$StyleItem) {
        if (textLayout$StyleItem.psla != 0) {
            return;
        }
        char[] cArray = new char[textLayout$StyleItem.length];
        this.segmentsText.getChars(textLayout$StyleItem.start, textLayout$StyleItem.start + textLayout$StyleItem.length, cArray, 0);
        int n2 = OS.GetProcessHeap();
        textLayout$StyleItem.psla = OS.HeapAlloc(n2, 8, SCRIPT_LOGATTR.sizeof * cArray.length);
        if (textLayout$StyleItem.psla == 0) {
            SWT.error(2);
        }
        OS.ScriptBreak(cArray, cArray.length, textLayout$StyleItem.analysis, textLayout$StyleItem.psla);
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    void computeRuns(GC gC) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Object object;
        if (this.runs != null) {
            return;
        }
        int n7 = gC != null ? gC.handle : this.device.internal_new_GC(null);
        int n8 = OS.CreateCompatibleDC(n7);
        this.allRuns = this.itemize();
        for (int i2 = 0; i2 < this.allRuns.length - 1; ++i2) {
            object = this.allRuns[i2];
            OS.SelectObject(n8, this.getItemFont((TextLayout$StyleItem)object));
            this.shape(n8, (TextLayout$StyleItem)object);
        }
        SCRIPT_LOGATTR sCRIPT_LOGATTR = new SCRIPT_LOGATTR();
        object = new SCRIPT_PROPERTIES();
        int n9 = this.indent;
        int n10 = 0;
        int n11 = 1;
        for (n6 = 0; n6 < this.allRuns.length - 1; ++n6) {
            int n12;
            int n13;
            TextLayout$StyleItem textLayout$StyleItem = this.allRuns[n6];
            if (this.tabs != null && textLayout$StyleItem.tab) {
                n5 = this.tabs.length;
                for (n4 = 0; n4 < n5; ++n4) {
                    if (this.tabs[n4] <= n9) continue;
                    textLayout$StyleItem.width = this.tabs[n4] - n9;
                    break;
                }
                if (n4 == n5) {
                    int n14 = n3 = n5 > 1 ? this.tabs[n5 - 1] - this.tabs[n5 - 2] : this.tabs[0];
                    if (n3 > 0) {
                        for (n13 = this.tabs[n5 - 1]; n13 <= n9; n13 += n3) {
                        }
                        textLayout$StyleItem.width = n13 - n9;
                    }
                }
                if ((n13 = textLayout$StyleItem.length) > 1) {
                    n3 = n4 + n13 - 1;
                    if (n3 < n5) {
                        textLayout$StyleItem.width += this.tabs[n3] - this.tabs[n4];
                    } else {
                        if (n4 < n5) {
                            textLayout$StyleItem.width += this.tabs[n5 - 1] - this.tabs[n4];
                            n13 -= n5 - 1 - n4;
                        }
                        n12 = n5 > 1 ? this.tabs[n5 - 1] - this.tabs[n5 - 2] : this.tabs[0];
                        textLayout$StyleItem.width += n12 * (n13 - 1);
                    }
                }
            }
            if (this.wrapWidth != -1 && n9 + textLayout$StyleItem.width > this.wrapWidth && !textLayout$StyleItem.tab && !textLayout$StyleItem.lineBreak) {
                TextLayout$StyleItem textLayout$StyleItem2;
                n5 = 0;
                int[] nArray = new int[textLayout$StyleItem.length];
                if (textLayout$StyleItem.style != null && textLayout$StyleItem.style.metrics != null) {
                    nArray[0] = textLayout$StyleItem.width;
                } else {
                    OS.ScriptGetLogicalWidths(textLayout$StyleItem.analysis, textLayout$StyleItem.length, textLayout$StyleItem.glyphCount, textLayout$StyleItem.advances, textLayout$StyleItem.clusters, textLayout$StyleItem.visAttrs, nArray);
                }
                n13 = 0;
                n3 = this.wrapWidth - n9;
                while (n13 + nArray[n5] < n3) {
                    n13 += nArray[n5++];
                }
                n12 = n5;
                int n15 = n6;
                while (n6 >= n10) {
                    this.breakRun(textLayout$StyleItem);
                    while (n5 >= 0) {
                        OS.MoveMemory(sCRIPT_LOGATTR, textLayout$StyleItem.psla + n5 * SCRIPT_LOGATTR.sizeof, SCRIPT_LOGATTR.sizeof);
                        if (sCRIPT_LOGATTR.fSoftBreak || sCRIPT_LOGATTR.fWhiteSpace) break;
                        --n5;
                    }
                    if (n5 == 0 && n6 != n10 && !textLayout$StyleItem.tab && sCRIPT_LOGATTR.fSoftBreak && !sCRIPT_LOGATTR.fWhiteSpace) {
                        OS.MoveMemory((SCRIPT_PROPERTIES)object, this.device.scripts[textLayout$StyleItem.analysis.eScript], SCRIPT_PROPERTIES.sizeof);
                        n2 = ((SCRIPT_PROPERTIES)object).langid;
                        textLayout$StyleItem2 = this.allRuns[n6 - 1];
                        OS.MoveMemory((SCRIPT_PROPERTIES)object, this.device.scripts[textLayout$StyleItem2.analysis.eScript], SCRIPT_PROPERTIES.sizeof);
                        if (((SCRIPT_PROPERTIES)object).langid == n2 || n2 == 0 || ((SCRIPT_PROPERTIES)object).langid == 0) {
                            this.breakRun(textLayout$StyleItem2);
                            OS.MoveMemory(sCRIPT_LOGATTR, textLayout$StyleItem2.psla + (textLayout$StyleItem2.length - 1) * SCRIPT_LOGATTR.sizeof, SCRIPT_LOGATTR.sizeof);
                            if (!sCRIPT_LOGATTR.fWhiteSpace) {
                                n5 = -1;
                            }
                        }
                    }
                    if (n5 >= 0 || n6 == n10) break;
                    textLayout$StyleItem = this.allRuns[--n6];
                    n5 = textLayout$StyleItem.length - 1;
                }
                int n16 = n2 = n5 == 0 && n6 != n10 && !textLayout$StyleItem.tab ? 1 : 0;
                if (n2 != 0) {
                    this.breakRun(textLayout$StyleItem);
                    OS.MoveMemory(sCRIPT_LOGATTR, textLayout$StyleItem.psla + n5 * SCRIPT_LOGATTR.sizeof, SCRIPT_LOGATTR.sizeof);
                    int n17 = n2 = !sCRIPT_LOGATTR.fWhiteSpace ? 1 : 0;
                }
                if (n2 != 0) {
                    textLayout$StyleItem = this.allRuns[--n6];
                    n5 = textLayout$StyleItem.length;
                } else if (n5 <= 0 && n6 == n10) {
                    if (n12 == 0 && n15 > n10) {
                        n6 = n15 - 1;
                        textLayout$StyleItem = this.allRuns[n6];
                        n5 = textLayout$StyleItem.length;
                    } else {
                        n6 = n15;
                        textLayout$StyleItem = this.allRuns[n6];
                        n5 = Math.max(1, n12);
                    }
                }
                this.breakRun(textLayout$StyleItem);
                while (n5 < textLayout$StyleItem.length) {
                    OS.MoveMemory(sCRIPT_LOGATTR, textLayout$StyleItem.psla + n5 * SCRIPT_LOGATTR.sizeof, SCRIPT_LOGATTR.sizeof);
                    if (!sCRIPT_LOGATTR.fWhiteSpace) break;
                    ++n5;
                }
                if (0 < n5 && n5 < textLayout$StyleItem.length) {
                    textLayout$StyleItem2 = new TextLayout$StyleItem(this);
                    textLayout$StyleItem2.start = textLayout$StyleItem.start + n5;
                    textLayout$StyleItem2.length = textLayout$StyleItem.length - n5;
                    textLayout$StyleItem2.style = textLayout$StyleItem.style;
                    textLayout$StyleItem2.analysis = this.cloneScriptAnalysis(textLayout$StyleItem.analysis);
                    textLayout$StyleItem.free();
                    textLayout$StyleItem.length = n5;
                    OS.SelectObject(n8, this.getItemFont(textLayout$StyleItem));
                    textLayout$StyleItem.analysis.fNoGlyphIndex = false;
                    this.shape(n8, textLayout$StyleItem);
                    OS.SelectObject(n8, this.getItemFont(textLayout$StyleItem2));
                    textLayout$StyleItem2.analysis.fNoGlyphIndex = false;
                    this.shape(n8, textLayout$StyleItem2);
                    TextLayout$StyleItem[] textLayout$StyleItemArray = new TextLayout$StyleItem[this.allRuns.length + 1];
                    System.arraycopy(this.allRuns, 0, textLayout$StyleItemArray, 0, n6 + 1);
                    System.arraycopy(this.allRuns, n6 + 1, textLayout$StyleItemArray, n6 + 2, this.allRuns.length - n6 - 1);
                    this.allRuns = textLayout$StyleItemArray;
                    this.allRuns[n6 + 1] = textLayout$StyleItem2;
                }
                if (n6 != this.allRuns.length - 2) {
                    textLayout$StyleItem.lineBreak = true;
                    textLayout$StyleItem.softBreak = true;
                }
            }
            n9 += textLayout$StyleItem.width;
            if (!textLayout$StyleItem.lineBreak) continue;
            n10 = n6 + 1;
            n9 = textLayout$StyleItem.softBreak ? this.wrapIndent : this.indent;
            ++n11;
        }
        n9 = 0;
        this.runs = new TextLayout$StyleItem[n11][];
        this.lineOffset = new int[n11 + 1];
        this.lineY = new int[n11 + 1];
        this.lineWidth = new int[n11];
        n6 = 0;
        int n18 = 0;
        n5 = Math.max(0, DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.ascentInPixels));
        n4 = Math.max(0, DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.descentInPixels));
        TextLayout$StyleItem[] textLayout$StyleItemArray = new TextLayout$StyleItem[this.allRuns.length];
        for (n3 = 0; n3 < this.allRuns.length; ++n3) {
            TextLayout$StyleItem textLayout$StyleItem = this.allRuns[n3];
            textLayout$StyleItemArray[n6++] = textLayout$StyleItem;
            n9 += textLayout$StyleItem.width;
            n5 = Math.max(n5, textLayout$StyleItem.ascentInPoints);
            n4 = Math.max(n4, textLayout$StyleItem.descentInPoints);
            if (!textLayout$StyleItem.lineBreak && n3 != this.allRuns.length - 1) continue;
            if (!(n6 != 1 || n3 != this.allRuns.length - 1 && textLayout$StyleItem.softBreak)) {
                TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
                OS.SelectObject(n8, this.getItemFont(textLayout$StyleItem));
                OS.GetTextMetrics(n8, tEXTMETRIC);
                textLayout$StyleItem.ascentInPoints = DPIUtil.autoScaleDown((Drawable)this.getDevice(), tEXTMETRIC.tmAscent);
                textLayout$StyleItem.descentInPoints = DPIUtil.autoScaleDown((Drawable)this.getDevice(), tEXTMETRIC.tmDescent);
                n5 = Math.max(n5, textLayout$StyleItem.ascentInPoints);
                n4 = Math.max(n4, textLayout$StyleItem.descentInPoints);
            }
            this.runs[n18] = new TextLayout$StyleItem[n6];
            System.arraycopy(textLayout$StyleItemArray, 0, this.runs[n18], 0, n6);
            if (this.justify && this.wrapWidth != -1 && textLayout$StyleItem.softBreak && n9 > 0) {
                int n19 = this.wrapIndent;
                if (n18 == 0) {
                    n19 = this.indent;
                } else {
                    TextLayout$StyleItem[] textLayout$StyleItemArray2 = this.runs[n18 - 1];
                    TextLayout$StyleItem textLayout$StyleItem3 = textLayout$StyleItemArray2[textLayout$StyleItemArray2.length - 1];
                    if (textLayout$StyleItem3.lineBreak && !textLayout$StyleItem3.softBreak) {
                        n19 = this.indent;
                    }
                }
                n9 += n19;
                n2 = OS.GetProcessHeap();
                int n20 = 0;
                for (int i3 = 0; i3 < this.runs[n18].length; ++i3) {
                    TextLayout$StyleItem textLayout$StyleItem4 = this.runs[n18][i3];
                    int n21 = textLayout$StyleItem4.width * this.wrapWidth / n9;
                    if (n21 != textLayout$StyleItem4.width) {
                        textLayout$StyleItem4.justify = OS.HeapAlloc(n2, 8, textLayout$StyleItem4.glyphCount * 4);
                        if (textLayout$StyleItem4.justify == 0) {
                            SWT.error(2);
                        }
                        OS.ScriptJustify(textLayout$StyleItem4.visAttrs, textLayout$StyleItem4.advances, textLayout$StyleItem4.glyphCount, n21 - textLayout$StyleItem4.width, 2, textLayout$StyleItem4.justify);
                        textLayout$StyleItem4.width = n21;
                    }
                    n20 += textLayout$StyleItem4.width;
                }
                n9 = n20;
            }
            this.lineWidth[n18] = n9;
            TextLayout$StyleItem textLayout$StyleItem5 = this.runs[n18][n6 - 1];
            n2 = textLayout$StyleItem5.start + textLayout$StyleItem5.length;
            this.runs[n18] = this.reorder(this.runs[n18], n3 == this.allRuns.length - 1);
            textLayout$StyleItem5 = this.runs[n18][n6 - 1];
            if (textLayout$StyleItem.softBreak && textLayout$StyleItem != textLayout$StyleItem5) {
                textLayout$StyleItem.lineBreak = false;
                textLayout$StyleItem.softBreak = false;
                textLayout$StyleItem5.lineBreak = true;
                textLayout$StyleItem5.softBreak = true;
            }
            n9 = this.getLineIndent(n18);
            for (int i4 = 0; i4 < this.runs[n18].length; ++i4) {
                this.runs[n18][i4].x = n9;
                n9 += this.runs[n18][i4].width;
            }
            this.lineY[++n18] = this.lineY[n18 - 1] + n5 + n4 + this.lineSpacingInPoints;
            this.lineOffset[n18] = n2;
            n9 = 0;
            n6 = 0;
            n5 = Math.max(0, DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.ascentInPixels));
            n4 = Math.max(0, DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.descentInPixels));
        }
        if (n8 != 0) {
            OS.DeleteDC(n8);
        }
        if (gC == null) {
            this.device.internal_dispose_GC(n7, null);
        }
    }

    @Override
    void destroy() {
        this.freeRuns();
        this.font = null;
        this.text = null;
        this.segmentsText = null;
        this.tabs = null;
        this.styles = null;
        this.runs = null;
        this.lineOffset = null;
        this.lineY = null;
        this.lineWidth = null;
        this.segments = null;
        this.segmentsChars = null;
        if (this.mLangFontLink2 != 0) {
            OS.VtblCall(2, this.mLangFontLink2);
            this.mLangFontLink2 = 0;
        }
        OS.OleUninitialize();
    }

    SCRIPT_ANALYSIS cloneScriptAnalysis(SCRIPT_ANALYSIS sCRIPT_ANALYSIS) {
        SCRIPT_ANALYSIS sCRIPT_ANALYSIS2 = new SCRIPT_ANALYSIS();
        sCRIPT_ANALYSIS2.eScript = sCRIPT_ANALYSIS.eScript;
        sCRIPT_ANALYSIS2.fRTL = sCRIPT_ANALYSIS.fRTL;
        sCRIPT_ANALYSIS2.fLayoutRTL = sCRIPT_ANALYSIS.fLayoutRTL;
        sCRIPT_ANALYSIS2.fLinkBefore = sCRIPT_ANALYSIS.fLinkBefore;
        sCRIPT_ANALYSIS2.fLinkAfter = sCRIPT_ANALYSIS.fLinkAfter;
        sCRIPT_ANALYSIS2.fLogicalOrder = sCRIPT_ANALYSIS.fLogicalOrder;
        sCRIPT_ANALYSIS2.fNoGlyphIndex = sCRIPT_ANALYSIS.fNoGlyphIndex;
        sCRIPT_ANALYSIS2.s = new SCRIPT_STATE();
        sCRIPT_ANALYSIS2.s.uBidiLevel = sCRIPT_ANALYSIS.s.uBidiLevel;
        sCRIPT_ANALYSIS2.s.fOverrideDirection = sCRIPT_ANALYSIS.s.fOverrideDirection;
        sCRIPT_ANALYSIS2.s.fInhibitSymSwap = sCRIPT_ANALYSIS.s.fInhibitSymSwap;
        sCRIPT_ANALYSIS2.s.fCharShape = sCRIPT_ANALYSIS.s.fCharShape;
        sCRIPT_ANALYSIS2.s.fDigitSubstitute = sCRIPT_ANALYSIS.s.fDigitSubstitute;
        sCRIPT_ANALYSIS2.s.fInhibitLigate = sCRIPT_ANALYSIS.s.fInhibitLigate;
        sCRIPT_ANALYSIS2.s.fDisplayZWG = sCRIPT_ANALYSIS.s.fDisplayZWG;
        sCRIPT_ANALYSIS2.s.fArabicNumContext = sCRIPT_ANALYSIS.s.fArabicNumContext;
        sCRIPT_ANALYSIS2.s.fGcpClusters = sCRIPT_ANALYSIS.s.fGcpClusters;
        sCRIPT_ANALYSIS2.s.fReserved = sCRIPT_ANALYSIS.s.fReserved;
        sCRIPT_ANALYSIS2.s.fEngineReserved = sCRIPT_ANALYSIS.s.fEngineReserved;
        return sCRIPT_ANALYSIS2;
    }

    int[] computePolyline(int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = n5 - n3;
        int n8 = 2 * n7;
        int n9 = Compatibility.ceil(n4 - n2, n8);
        if (n9 == 0 && n4 - n2 > 2) {
            n9 = 1;
        }
        if ((n6 = (2 * n9 + 1) * 2) < 0) {
            return new int[0];
        }
        int[] nArray = new int[n6];
        for (int i2 = 0; i2 < n9; ++i2) {
            int n10 = 4 * i2;
            nArray[n10] = n2 + n8 * i2;
            nArray[n10 + 1] = n5;
            nArray[n10 + 2] = nArray[n10] + n8 / 2;
            nArray[n10 + 3] = n3;
        }
        nArray[n6 - 2] = n2 + n8 * n9;
        nArray[n6 - 1] = n5;
        return nArray;
    }

    int createGdipBrush(int n2, int n3) {
        int n4 = (n3 & 0xFF) << 24 | n2 >> 16 & 0xFF | n2 & 0xFF00 | (n2 & 0xFF) << 16;
        int n5 = Gdip.Color_new(n4);
        int n6 = Gdip.SolidBrush_new(n5);
        Gdip.Color_delete(n5);
        return n6;
    }

    int createGdipBrush(Color color, int n2) {
        return this.createGdipBrush(color.handle, n2);
    }

    public void draw(GC gC, int n2, int n3) {
        this.checkLayout();
        this.drawInPixels(gC, DPIUtil.autoScaleUp((Drawable)this.getDevice(), n2), DPIUtil.autoScaleUp((Drawable)this.getDevice(), n3));
    }

    void drawInPixels(GC gC, int n2, int n3) {
        this.drawInPixels(gC, n2, n3, -1, -1, null, null);
    }

    public void draw(GC gC, int n2, int n3, int n4, int n5, Color color, Color color2) {
        this.checkLayout();
        this.drawInPixels(gC, DPIUtil.autoScaleUp((Drawable)this.getDevice(), n2), DPIUtil.autoScaleUp((Drawable)this.getDevice(), n3), n4, n5, color, color2);
    }

    void drawInPixels(GC gC, int n2, int n3, int n4, int n5, Color color, Color color2) {
        this.drawInPixels(gC, n2, n3, n4, n5, color, color2, 0);
    }

    public void draw(GC gC, int n2, int n3, int n4, int n5, Color color, Color color2, int n6) {
        this.checkLayout();
        this.drawInPixels(gC, DPIUtil.autoScaleUp((Drawable)this.getDevice(), n2), DPIUtil.autoScaleUp((Drawable)this.getDevice(), n3), n4, n5, color, color2, n6);
    }

    void drawInPixels(GC gC, int n2, int n3, int n4, int n5, Color color, Color color2, int n6) {
        int n7;
        int n8;
        this.computeRuns(gC);
        if (gC == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (color2 != null && color2.isDisposed()) {
            SWT.error(5);
        }
        if ((n8 = this.text.length()) == 0 && n6 == 0) {
            return;
        }
        int n9 = gC.handle;
        Rectangle rectangle = gC.getClippingInPixels();
        GCData gCData = gC.data;
        int n10 = gCData.gdipGraphics;
        int n11 = gCData.foreground;
        int n12 = OS.GetSysColor(OS.COLOR_HOTLIGHT);
        int n13 = gCData.alpha;
        boolean bl2 = n10 != 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        if (bl2) {
            gC.checkGC(1);
            n14 = gC.getFgBrush();
        } else {
            n16 = OS.SaveDC(n9);
            if ((gCData.style & 0x8000000) != 0) {
                OS.SetLayout(n9, OS.GetLayout(n9) | 1);
            }
        }
        boolean bl3 = n4 <= n5 && n4 != -1 && n5 != -1;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        int n22 = 0;
        if (bl3 || (n6 & 0x100000) != 0 && (n6 & 0x30000) != 0) {
            int n23 = color != null ? color.handle : OS.GetSysColor(OS.COLOR_HIGHLIGHTTEXT);
            int n24 = n7 = color2 != null ? color2.handle : OS.GetSysColor(OS.COLOR_HIGHLIGHT);
            if (bl2) {
                n17 = this.createGdipBrush(n7, n13);
                n18 = this.createGdipBrush(n23, n13);
            } else {
                n21 = OS.CreateSolidBrush(n7);
                n22 = n23;
            }
            if (bl3) {
                n4 = this.translateOffset(Math.min(Math.max(0, n4), n8 - 1));
                n5 = this.translateOffset(Math.min(Math.max(0, n5), n8 - 1));
            }
        }
        RECT rECT = new RECT();
        OS.SetBkMode(n9, 1);
        block0: for (n7 = 0; n7 < this.runs.length; ++n7) {
            int n25;
            int n26;
            int n27;
            int n28 = n2 + this.getLineIndent(n7);
            int n29 = n3 + DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.lineY[n7]);
            TextLayout$StyleItem[] textLayout$StyleItemArray = this.runs[n7];
            int n30 = DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.lineY[n7 + 1] - this.lineY[n7] - this.lineSpacingInPoints);
            if ((n6 & 0x30000) != 0 && (bl3 || (n6 & 0x100000) != 0)) {
                n27 = 0;
                if (n7 == this.runs.length - 1 && (n6 & 0x100000) != 0) {
                    n27 = 1;
                } else {
                    TextLayout$StyleItem textLayout$StyleItem = textLayout$StyleItemArray[textLayout$StyleItemArray.length - 1];
                    if (textLayout$StyleItem.lineBreak && !textLayout$StyleItem.softBreak) {
                        if (n4 <= textLayout$StyleItem.start && textLayout$StyleItem.start <= n5) {
                            n27 = 1;
                        }
                    } else {
                        n26 = textLayout$StyleItem.start + textLayout$StyleItem.length - 1;
                        if (n4 <= n26 && n26 < n5 && (n6 & 0x10000) != 0) {
                            n27 = 1;
                        }
                    }
                }
                if (n27 != 0) {
                    int n31 = (n6 & 0x10000) != 0 ? (OS.IsWin95 ? Short.MAX_VALUE : 0x6FFFFFF) : n30 / 3;
                    if (bl2) {
                        Gdip.Graphics_FillRectangle(n10, n17, n28 + this.lineWidth[n7], n29, n31, n30);
                    } else {
                        OS.SelectObject(n9, n21);
                        OS.PatBlt(n9, n28 + this.lineWidth[n7], n29, n31, n30, 15728673);
                    }
                }
            }
            if (n28 > rectangle.x + rectangle.width || n28 + this.lineWidth[n7] < rectangle.x) continue;
            n27 = n28;
            for (n25 = 0; n25 < textLayout$StyleItemArray.length; ++n25) {
                TextLayout$StyleItem textLayout$StyleItem = textLayout$StyleItemArray[n25];
                if (textLayout$StyleItem.length == 0) continue;
                if (n28 > rectangle.x + rectangle.width) break;
                if (n28 + textLayout$StyleItem.width >= rectangle.x && (!textLayout$StyleItem.lineBreak || textLayout$StyleItem.softBreak)) {
                    OS.SetRect(rECT, n28, n29, n28 + textLayout$StyleItem.width, n29 + n30);
                    if (bl2) {
                        this.drawRunBackgroundGDIP(textLayout$StyleItem, n10, rECT, n4, n5, n13, n17, bl3);
                    } else {
                        this.drawRunBackground(textLayout$StyleItem, n9, rECT, n4, n5, n21, bl3);
                    }
                }
                n28 += textLayout$StyleItem.width;
            }
            n25 = Math.max(0, this.ascentInPixels);
            n26 = 0;
            for (int i2 = 0; i2 < textLayout$StyleItemArray.length; ++i2) {
                n25 = Math.max(n25, DPIUtil.autoScaleUp((Drawable)this.getDevice(), textLayout$StyleItemArray[i2].ascentInPoints));
                n26 = Math.min(n26, textLayout$StyleItemArray[i2].underlinePos);
            }
            RECT rECT2 = null;
            RECT rECT3 = null;
            RECT rECT4 = null;
            RECT rECT5 = null;
            n28 = n27;
            for (int i3 = 0; i3 < textLayout$StyleItemArray.length; ++i3) {
                boolean bl4;
                TextLayout$StyleItem textLayout$StyleItem = textLayout$StyleItemArray[i3];
                TextStyle textStyle = textLayout$StyleItem.style;
                boolean bl5 = bl4 = textStyle != null && (textStyle.underline || textStyle.strikeout || textStyle.borderStyle != 0);
                if (textLayout$StyleItem.length == 0) continue;
                if (n28 > rectangle.x + rectangle.width) continue block0;
                if (n28 + textLayout$StyleItem.width >= rectangle.x) {
                    boolean bl6;
                    boolean bl7 = bl6 = textLayout$StyleItem.tab && !bl4;
                    if (!(bl6 || textLayout$StyleItem.lineBreak && !textLayout$StyleItem.softBreak || textStyle != null && textStyle.metrics != null)) {
                        int n32;
                        OS.SetRect(rECT, n28, n29, n28 + textLayout$StyleItem.width, n29 + n30);
                        if (bl2) {
                            int n33;
                            n32 = this.getItemFont(textLayout$StyleItem);
                            if (n32 != n20) {
                                n20 = n32;
                                if (n19 != 0) {
                                    Gdip.Font_delete(n19);
                                }
                                n33 = OS.SelectObject(n9, n32);
                                n19 = Gdip.Font_new(n9, n32);
                                OS.SelectObject(n9, n33);
                                if (n19 == 0) {
                                    SWT.error(2);
                                }
                                if (!Gdip.Font_IsAvailable(n19)) {
                                    Gdip.Font_delete(n19);
                                    n19 = 0;
                                }
                            }
                            n33 = n14;
                            if (textStyle != null && textStyle.underline && textStyle.underlineStyle == 4) {
                                if (n15 == 0) {
                                    n15 = this.createGdipBrush(n12, n13);
                                }
                                n33 = n15;
                            }
                            if (n19 != 0 && !textLayout$StyleItem.analysis.fNoGlyphIndex) {
                                rECT5 = this.drawRunTextGDIP(n10, textLayout$StyleItem, rECT, n19, n25, n33, n18, n4, n5, n13);
                            } else {
                                int n34 = textStyle != null && textStyle.underline && textStyle.underlineStyle == 4 ? n12 : n11;
                                rECT5 = this.drawRunTextGDIPRaster(n10, textLayout$StyleItem, rECT, n25, n34, n22, n4, n5);
                            }
                            rECT3 = this.drawUnderlineGDIP(n10, n2, n29 + n25, n26, n29 + n30, textLayout$StyleItemArray, i3, n33, n18, rECT3, rECT5, n4, n5, n13, rectangle);
                            rECT4 = this.drawStrikeoutGDIP(n10, n2, n29 + n25, textLayout$StyleItemArray, i3, n33, n18, rECT4, rECT5, n4, n5, n13, rectangle);
                            rECT2 = this.drawBorderGDIP(n10, n2, n29, n30, textLayout$StyleItemArray, i3, n33, n18, rECT2, rECT5, n4, n5, n13, rectangle);
                        } else {
                            n32 = textStyle != null && textStyle.underline && textStyle.underlineStyle == 4 ? n12 : n11;
                            rECT5 = this.drawRunText(n9, textLayout$StyleItem, rECT, n25, n32, n22, n4, n5);
                            rECT3 = this.drawUnderline(n9, n2, n29 + n25, n26, n29 + n30, textLayout$StyleItemArray, i3, n32, n22, rECT3, rECT5, n4, n5, rectangle);
                            rECT4 = this.drawStrikeout(n9, n2, n29 + n25, textLayout$StyleItemArray, i3, n32, n22, rECT4, rECT5, n4, n5, rectangle);
                            rECT2 = this.drawBorder(n9, n2, n29, n30, textLayout$StyleItemArray, i3, n32, n22, rECT2, rECT5, n4, n5, rectangle);
                        }
                    }
                }
                n28 += textLayout$StyleItem.width;
            }
        }
        if (n17 != 0) {
            Gdip.SolidBrush_delete(n17);
        }
        if (n18 != 0) {
            Gdip.SolidBrush_delete(n18);
        }
        if (n15 != 0) {
            Gdip.SolidBrush_delete(n15);
        }
        if (n19 != 0) {
            Gdip.Font_delete(n19);
        }
        if (n16 != 0) {
            OS.RestoreDC(n9, n16);
        }
        if (n21 != 0) {
            OS.DeleteObject(n21);
        }
    }

    RECT drawBorder(int n2, int n3, int n4, int n5, TextLayout$StyleItem[] textLayout$StyleItemArray, int n6, int n7, int n8, RECT rECT, RECT rECT2, int n9, int n10, Rectangle rectangle) {
        boolean bl2;
        TextLayout$StyleItem textLayout$StyleItem = textLayout$StyleItemArray[n6];
        TextStyle textStyle = textLayout$StyleItem.style;
        if (textStyle == null) {
            return null;
        }
        if (textStyle.borderStyle == 0) {
            return null;
        }
        rECT = this.addClipRect(textLayout$StyleItem, rECT, rECT2, n9, n10);
        boolean bl3 = bl2 = rectangle != null && n3 + textLayout$StyleItem.x + textLayout$StyleItem.width > rectangle.x + rectangle.width;
        if (n6 + 1 >= textLayout$StyleItemArray.length || bl2 || !textStyle.isAdherentBorder(textLayout$StyleItemArray[n6 + 1].style)) {
            int n11;
            boolean bl4;
            int n12;
            int n13 = textLayout$StyleItem.x;
            int n14 = textLayout$StyleItem.start;
            int n15 = textLayout$StyleItem.start + textLayout$StyleItem.length - 1;
            for (n12 = n6; n12 > 0 && textStyle.isAdherentBorder(textLayout$StyleItemArray[n12 - 1].style); --n12) {
                n13 = textLayout$StyleItemArray[n12 - 1].x;
                n14 = Math.min(n14, textLayout$StyleItemArray[n12 - 1].start);
                n15 = Math.max(n15, textLayout$StyleItemArray[n12 - 1].start + textLayout$StyleItemArray[n12 - 1].length - 1);
            }
            n12 = n9 <= n10 && n9 != -1 && n10 != -1 ? 1 : 0;
            boolean bl5 = bl4 = n12 != 0 && n9 <= n14 && n15 <= n10;
            if (textStyle.borderColor != null) {
                n7 = textStyle.borderColor.handle;
                rECT = null;
            } else if (bl4) {
                n7 = n8;
                rECT = null;
            } else if (textStyle.foreground != null) {
                n7 = textStyle.foreground.handle;
            }
            int n16 = 1;
            int n17 = 1;
            int n18 = 0;
            switch (textStyle.borderStyle) {
                case 1: {
                    break;
                }
                case 2: {
                    n18 = 1;
                    n17 = 4;
                    break;
                }
                case 4: {
                    n18 = 2;
                    n17 = 2;
                }
            }
            int n19 = OS.SelectObject(n2, OS.GetStockObject(5));
            LOGBRUSH lOGBRUSH = new LOGBRUSH();
            lOGBRUSH.lbStyle = 0;
            lOGBRUSH.lbColor = n7;
            int n20 = OS.ExtCreatePen(n18 | 0x10000, n16, lOGBRUSH, 0, null);
            int n21 = OS.SelectObject(n2, n20);
            RECT rECT3 = new RECT();
            OS.SetRect(rECT3, n3 + n13, n4, n3 + textLayout$StyleItem.x + textLayout$StyleItem.width, n4 + n5);
            if (rectangle != null) {
                if (rECT3.left < rectangle.x) {
                    n11 = rECT3.left % n17;
                    rECT3.left = rectangle.x / n17 * n17 + n11 - n17;
                }
                if (rECT3.right > rectangle.x + rectangle.width) {
                    n11 = rECT3.right % n17;
                    rECT3.right = (rectangle.x + rectangle.width) / n17 * n17 + n11 + n17;
                }
            }
            OS.Rectangle(n2, rECT3.left, rECT3.top, rECT3.right, rECT3.bottom);
            OS.SelectObject(n2, n21);
            OS.DeleteObject(n20);
            if (rECT != null) {
                n11 = OS.SaveDC(n2);
                if (rECT.left == -1) {
                    rECT.left = 0;
                }
                if (rECT.right == -1) {
                    rECT.right = 524287;
                }
                OS.IntersectClipRect(n2, rECT.left, rECT.top, rECT.right, rECT.bottom);
                lOGBRUSH.lbColor = n8;
                int n22 = OS.ExtCreatePen(n18 | 0x10000, n16, lOGBRUSH, 0, null);
                n21 = OS.SelectObject(n2, n22);
                OS.Rectangle(n2, rECT3.left, rECT3.top, rECT3.right, rECT3.bottom);
                OS.RestoreDC(n2, n11);
                OS.SelectObject(n2, n21);
                OS.DeleteObject(n22);
            }
            OS.SelectObject(n2, n19);
            return null;
        }
        return rECT;
    }

    RECT drawBorderGDIP(int n2, int n3, int n4, int n5, TextLayout$StyleItem[] textLayout$StyleItemArray, int n6, int n7, int n8, RECT rECT, RECT rECT2, int n9, int n10, int n11, Rectangle rectangle) {
        boolean bl2;
        TextLayout$StyleItem textLayout$StyleItem = textLayout$StyleItemArray[n6];
        TextStyle textStyle = textLayout$StyleItem.style;
        if (textStyle == null) {
            return null;
        }
        if (textStyle.borderStyle == 0) {
            return null;
        }
        rECT = this.addClipRect(textLayout$StyleItem, rECT, rECT2, n9, n10);
        boolean bl3 = bl2 = rectangle != null && n3 + textLayout$StyleItem.x + textLayout$StyleItem.width > rectangle.x + rectangle.width;
        if (n6 + 1 >= textLayout$StyleItemArray.length || bl2 || !textStyle.isAdherentBorder(textLayout$StyleItemArray[n6 + 1].style)) {
            int n12;
            int n13 = textLayout$StyleItem.x;
            int n14 = textLayout$StyleItem.start;
            int n15 = textLayout$StyleItem.start + textLayout$StyleItem.length - 1;
            for (n12 = n6; n12 > 0 && textStyle.isAdherentBorder(textLayout$StyleItemArray[n12 - 1].style); --n12) {
                n13 = textLayout$StyleItemArray[n12 - 1].x;
                n14 = Math.min(n14, textLayout$StyleItemArray[n12 - 1].start);
                n15 = Math.max(n15, textLayout$StyleItemArray[n12 - 1].start + textLayout$StyleItemArray[n12 - 1].length - 1);
            }
            n12 = n9 <= n10 && n9 != -1 && n10 != -1 ? 1 : 0;
            boolean bl4 = n12 != 0 && n9 <= n14 && n15 <= n10;
            int n16 = n7;
            if (textStyle.borderColor != null) {
                n16 = this.createGdipBrush(textStyle.borderColor, n11);
                rECT = null;
            } else if (bl4) {
                n16 = n8;
                rECT = null;
            } else if (textStyle.foreground != null) {
                n16 = this.createGdipBrush(textStyle.foreground, n11);
            }
            boolean bl5 = true;
            int n17 = 0;
            switch (textStyle.borderStyle) {
                case 1: {
                    break;
                }
                case 2: {
                    n17 = 1;
                    break;
                }
                case 4: {
                    n17 = 2;
                }
            }
            int n18 = Gdip.Pen_new(n16, (float)bl5);
            Gdip.Pen_SetDashStyle(n18, n17);
            Gdip.Graphics_SetPixelOffsetMode(n2, 3);
            int n19 = Gdip.Graphics_GetSmoothingMode(n2);
            Gdip.Graphics_SetSmoothingMode(n2, 3);
            if (rECT != null) {
                int n20 = Gdip.Graphics_Save(n2);
                if (rECT.left == -1) {
                    rECT.left = 0;
                }
                if (rECT.right == -1) {
                    rECT.right = 524287;
                }
                Rect rect = new Rect();
                rect.X = rECT.left;
                rect.Y = rECT.top;
                rect.Width = rECT.right - rECT.left;
                rect.Height = rECT.bottom - rECT.top;
                Gdip.Graphics_SetClip(n2, rect, 4);
                Gdip.Graphics_DrawRectangle(n2, n18, n3 + n13, n4, textLayout$StyleItem.x + textLayout$StyleItem.width - n13 - 1, n5 - 1);
                Gdip.Graphics_Restore(n2, n20);
                n20 = Gdip.Graphics_Save(n2);
                Gdip.Graphics_SetClip(n2, rect, 1);
                int n21 = Gdip.Pen_new(n8, (float)bl5);
                Gdip.Pen_SetDashStyle(n21, n17);
                Gdip.Graphics_DrawRectangle(n2, n21, n3 + n13, n4, textLayout$StyleItem.x + textLayout$StyleItem.width - n13 - 1, n5 - 1);
                Gdip.Pen_delete(n21);
                Gdip.Graphics_Restore(n2, n20);
            } else {
                Gdip.Graphics_DrawRectangle(n2, n18, n3 + n13, n4, textLayout$StyleItem.x + textLayout$StyleItem.width - n13 - 1, n5 - 1);
            }
            Gdip.Graphics_SetPixelOffsetMode(n2, 4);
            Gdip.Graphics_SetSmoothingMode(n2, n19);
            Gdip.Pen_delete(n18);
            if (n16 != n8 && n16 != n7) {
                Gdip.SolidBrush_delete(n16);
            }
            return null;
        }
        return rECT;
    }

    void drawRunBackground(TextLayout$StyleItem textLayout$StyleItem, int n2, RECT rECT, int n3, int n4, int n5, boolean bl2) {
        boolean bl3;
        int n6 = textLayout$StyleItem.start + textLayout$StyleItem.length - 1;
        boolean bl4 = bl3 = bl2 && n3 <= textLayout$StyleItem.start && n4 >= n6;
        if (bl3) {
            OS.SelectObject(n2, n5);
            OS.PatBlt(n2, rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top, 15728673);
        } else {
            int n7;
            if (textLayout$StyleItem.style != null && textLayout$StyleItem.style.background != null) {
                n7 = textLayout$StyleItem.style.background.handle;
                int n8 = OS.CreateSolidBrush(n7);
                int n9 = OS.SelectObject(n2, n8);
                OS.PatBlt(n2, rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top, 15728673);
                OS.SelectObject(n2, n9);
                OS.DeleteObject(n8);
            }
            int n10 = n7 = bl2 && n3 <= n6 && textLayout$StyleItem.start <= n4 ? 1 : 0;
            if (n7 != 0) {
                this.getPartialSelection(textLayout$StyleItem, n3, n4, rECT);
                OS.SelectObject(n2, n5);
                OS.PatBlt(n2, rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top, 15728673);
            }
        }
    }

    void drawRunBackgroundGDIP(TextLayout$StyleItem textLayout$StyleItem, int n2, RECT rECT, int n3, int n4, int n5, int n6, boolean bl2) {
        boolean bl3;
        int n7 = textLayout$StyleItem.start + textLayout$StyleItem.length - 1;
        boolean bl4 = bl3 = bl2 && n3 <= textLayout$StyleItem.start && n4 >= n7;
        if (bl3) {
            Gdip.Graphics_FillRectangle(n2, n6, rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top);
        } else {
            int n8;
            if (textLayout$StyleItem.style != null && textLayout$StyleItem.style.background != null) {
                n8 = this.createGdipBrush(textLayout$StyleItem.style.background, n5);
                Gdip.Graphics_FillRectangle(n2, n8, rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top);
                Gdip.SolidBrush_delete(n8);
            }
            int n9 = n8 = bl2 && n3 <= n7 && textLayout$StyleItem.start <= n4 ? 1 : 0;
            if (n8 != 0) {
                this.getPartialSelection(textLayout$StyleItem, n3, n4, rECT);
                if (rECT.left > rECT.right) {
                    int n10 = rECT.left;
                    rECT.left = rECT.right;
                    rECT.right = n10;
                }
                Gdip.Graphics_FillRectangle(n2, n6, rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top);
            }
        }
    }

    RECT drawRunText(int n2, TextLayout$StyleItem textLayout$StyleItem, RECT rECT, int n3, int n4, int n5, int n6, int n7) {
        int n8 = textLayout$StyleItem.start + textLayout$StyleItem.length - 1;
        boolean bl2 = n6 <= n7 && n6 != -1 && n7 != -1;
        boolean bl3 = bl2 && n6 <= textLayout$StyleItem.start && n7 >= n8;
        boolean bl4 = bl2 && !bl3 && n6 <= n8 && textLayout$StyleItem.start <= n7;
        int n9 = (this.orientation & 0x4000000) != 0 ? -1 : 0;
        int n10 = rECT.left + n9;
        int n11 = rECT.top + (n3 - DPIUtil.autoScaleUp((Drawable)this.getDevice(), textLayout$StyleItem.ascentInPoints));
        int n12 = this.getItemFont(textLayout$StyleItem);
        OS.SelectObject(n2, n12);
        if (bl3) {
            n4 = n5;
        } else if (textLayout$StyleItem.style != null && textLayout$StyleItem.style.foreground != null) {
            n4 = textLayout$StyleItem.style.foreground.handle;
        }
        OS.SetTextColor(n2, n4);
        OS.ScriptTextOut(n2, textLayout$StyleItem.psc, n10, n11, 0, null, textLayout$StyleItem.analysis, 0, 0, textLayout$StyleItem.glyphs, textLayout$StyleItem.glyphCount, textLayout$StyleItem.advances, textLayout$StyleItem.justify, textLayout$StyleItem.goffsets);
        if (bl4) {
            this.getPartialSelection(textLayout$StyleItem, n6, n7, rECT);
            OS.SetTextColor(n2, n5);
            OS.ScriptTextOut(n2, textLayout$StyleItem.psc, n10, n11, 4, rECT, textLayout$StyleItem.analysis, 0, 0, textLayout$StyleItem.glyphs, textLayout$StyleItem.glyphCount, textLayout$StyleItem.advances, textLayout$StyleItem.justify, textLayout$StyleItem.goffsets);
        }
        return bl3 || bl4 ? rECT : null;
    }

    RECT drawRunTextGDIP(int n2, TextLayout$StyleItem textLayout$StyleItem, RECT rECT, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        boolean bl2;
        int n10 = textLayout$StyleItem.start + textLayout$StyleItem.length - 1;
        boolean bl3 = n7 <= n8 && n7 != -1 && n8 != -1;
        boolean bl4 = bl3 && n7 <= textLayout$StyleItem.start && n8 >= n10;
        boolean bl5 = bl3 && !bl4 && n7 <= n10 && textLayout$StyleItem.start <= n8;
        int n11 = rECT.top + n4;
        if (textLayout$StyleItem.style != null && textLayout$StyleItem.style.rise != 0) {
            n11 -= DPIUtil.autoScaleUp((Drawable)this.getDevice(), textLayout$StyleItem.style.rise);
        }
        int n12 = rECT.left;
        int n13 = n5;
        if (bl4) {
            n13 = n6;
        } else if (textLayout$StyleItem.style != null && textLayout$StyleItem.style.foreground != null) {
            n13 = this.createGdipBrush(textLayout$StyleItem.style.foreground, n9);
        }
        int n14 = 0;
        Rect rect = null;
        if (bl5) {
            rect = new Rect();
            this.getPartialSelection(textLayout$StyleItem, n7, n8, rECT);
            rect.X = rECT.left;
            rect.Y = rECT.top;
            rect.Width = rECT.right - rECT.left;
            rect.Height = rECT.bottom - rECT.top;
            n14 = Gdip.Graphics_Save(n2);
            Gdip.Graphics_SetClip(n2, rect, 4);
        }
        int n15 = 0;
        boolean bl6 = bl2 = (this.orientation & 0x4000000) != 0;
        if (bl2) {
            switch (Gdip.Brush_GetType(n13)) {
                case 4: {
                    Gdip.LinearGradientBrush_ScaleTransform(n13, -1.0f, 1.0f, 0);
                    Gdip.LinearGradientBrush_TranslateTransform(n13, -2 * n12 - textLayout$StyleItem.width, 0.0f, 0);
                    break;
                }
                case 2: {
                    Gdip.TextureBrush_ScaleTransform(n13, -1.0f, 1.0f, 0);
                    Gdip.TextureBrush_TranslateTransform(n13, -2 * n12 - textLayout$StyleItem.width, 0.0f, 0);
                }
            }
            n15 = Gdip.Graphics_Save(n2);
            Gdip.Graphics_ScaleTransform(n2, -1.0f, 1.0f, 0);
            Gdip.Graphics_TranslateTransform(n2, -2 * n12 - textLayout$StyleItem.width, 0.0f, 0);
        }
        int[] nArray = new int[textLayout$StyleItem.glyphCount];
        float[] fArray = new float[textLayout$StyleItem.glyphCount * 2];
        OS.memmove(nArray, textLayout$StyleItem.justify != 0 ? textLayout$StyleItem.justify : textLayout$StyleItem.advances, textLayout$StyleItem.glyphCount * 4);
        int n16 = n12;
        int n17 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            fArray[n17++] = n16;
            fArray[n17++] = n11;
            n16 += nArray[i2];
        }
        Gdip.Graphics_DrawDriverString(n2, textLayout$StyleItem.glyphs, textLayout$StyleItem.glyphCount, n3, n13, fArray, 0, 0);
        if (bl5) {
            if (bl2) {
                Gdip.Graphics_Restore(n2, n15);
            }
            Gdip.Graphics_Restore(n2, n14);
            n14 = Gdip.Graphics_Save(n2);
            Gdip.Graphics_SetClip(n2, rect, 1);
            if (bl2) {
                n15 = Gdip.Graphics_Save(n2);
                Gdip.Graphics_ScaleTransform(n2, -1.0f, 1.0f, 0);
                Gdip.Graphics_TranslateTransform(n2, -2 * n12 - textLayout$StyleItem.width, 0.0f, 0);
            }
            Gdip.Graphics_DrawDriverString(n2, textLayout$StyleItem.glyphs, textLayout$StyleItem.glyphCount, n3, n6, fArray, 0, 0);
            Gdip.Graphics_Restore(n2, n14);
        }
        if (bl2) {
            switch (Gdip.Brush_GetType(n13)) {
                case 4: {
                    Gdip.LinearGradientBrush_ResetTransform(n13);
                    break;
                }
                case 2: {
                    Gdip.TextureBrush_ResetTransform(n13);
                }
            }
            Gdip.Graphics_Restore(n2, n15);
        }
        if (n13 != n6 && n13 != n5) {
            Gdip.SolidBrush_delete(n13);
        }
        return bl4 || bl5 ? rECT : null;
    }

    RECT drawRunTextGDIPRaster(int n2, TextLayout$StyleItem textLayout$StyleItem, RECT rECT, int n3, int n4, int n5, int n6, int n7) {
        int n8 = 0;
        Gdip.Graphics_SetPixelOffsetMode(n2, 3);
        int n9 = Gdip.Region_new();
        if (n9 == 0) {
            SWT.error(2);
        }
        Gdip.Graphics_GetClip(n2, n9);
        if (!Gdip.Region_IsInfinite(n9, n2)) {
            n8 = Gdip.Region_GetHRGN(n9, n2);
        }
        Gdip.Region_delete(n9);
        Gdip.Graphics_SetPixelOffsetMode(n2, 4);
        float[] fArray = null;
        int n10 = Gdip.Matrix_new(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        if (n10 == 0) {
            SWT.error(2);
        }
        Gdip.Graphics_GetTransform(n2, n10);
        if (!Gdip.Matrix_IsIdentity(n10)) {
            fArray = new float[6];
            Gdip.Matrix_GetElements(n10, fArray);
        }
        Gdip.Matrix_delete(n10);
        int n11 = Gdip.Graphics_GetHDC(n2);
        int n12 = OS.SaveDC(n11);
        if (fArray != null) {
            OS.SetGraphicsMode(n11, 2);
            OS.SetWorldTransform(n11, fArray);
        }
        if (n8 != 0) {
            OS.SelectClipRgn(n11, n8);
            OS.DeleteObject(n8);
        }
        if ((this.orientation & 0x4000000) != 0) {
            OS.SetLayout(n11, OS.GetLayout(n11) | 1);
        }
        OS.SetBkMode(n11, 1);
        RECT rECT2 = this.drawRunText(n11, textLayout$StyleItem, rECT, n3, n4, n5, n6, n7);
        OS.RestoreDC(n11, n12);
        Gdip.Graphics_ReleaseHDC(n2, n11);
        return rECT2;
    }

    RECT drawStrikeout(int n2, int n3, int n4, TextLayout$StyleItem[] textLayout$StyleItemArray, int n5, int n6, int n7, RECT rECT, RECT rECT2, int n8, int n9, Rectangle rectangle) {
        boolean bl2;
        TextLayout$StyleItem textLayout$StyleItem = textLayout$StyleItemArray[n5];
        TextStyle textStyle = textLayout$StyleItem.style;
        if (textStyle == null) {
            return null;
        }
        if (!textStyle.strikeout) {
            return null;
        }
        rECT = this.addClipRect(textLayout$StyleItem, rECT, rECT2, n8, n9);
        boolean bl3 = bl2 = rectangle != null && n3 + textLayout$StyleItem.x + textLayout$StyleItem.width > rectangle.x + rectangle.width;
        if (n5 + 1 >= textLayout$StyleItemArray.length || bl2 || !textStyle.isAdherentStrikeout(textLayout$StyleItemArray[n5 + 1].style)) {
            boolean bl4;
            int n10;
            int n11 = textLayout$StyleItem.x;
            int n12 = textLayout$StyleItem.start;
            int n13 = textLayout$StyleItem.start + textLayout$StyleItem.length - 1;
            for (n10 = n5; n10 > 0 && textStyle.isAdherentStrikeout(textLayout$StyleItemArray[n10 - 1].style); --n10) {
                n11 = textLayout$StyleItemArray[n10 - 1].x;
                n12 = Math.min(n12, textLayout$StyleItemArray[n10 - 1].start);
                n13 = Math.max(n13, textLayout$StyleItemArray[n10 - 1].start + textLayout$StyleItemArray[n10 - 1].length - 1);
            }
            n10 = n8 <= n9 && n8 != -1 && n9 != -1 ? 1 : 0;
            boolean bl5 = bl4 = n10 != 0 && n8 <= n12 && n13 <= n9;
            if (textStyle.strikeoutColor != null) {
                n6 = textStyle.strikeoutColor.handle;
                rECT = null;
            } else if (bl4) {
                n6 = n7;
                rECT = null;
            } else if (textStyle.foreground != null) {
                n6 = textStyle.foreground.handle;
            }
            RECT rECT3 = new RECT();
            int n14 = DPIUtil.autoScaleUp((Drawable)this.getDevice(), textStyle.rise);
            OS.SetRect(rECT3, n3 + n11, n4 - textLayout$StyleItem.strikeoutPos - n14, n3 + textLayout$StyleItem.x + textLayout$StyleItem.width, n4 - textLayout$StyleItem.strikeoutPos + textLayout$StyleItem.strikeoutThickness - n14);
            int n15 = OS.CreateSolidBrush(n6);
            OS.FillRect(n2, rECT3, n15);
            OS.DeleteObject(n15);
            if (rECT != null) {
                int n16 = OS.CreateSolidBrush(n7);
                if (rECT.left == -1) {
                    rECT.left = 0;
                }
                if (rECT.right == -1) {
                    rECT.right = 524287;
                }
                OS.SetRect(rECT, Math.max(rECT3.left, rECT.left), rECT3.top, Math.min(rECT3.right, rECT.right), rECT3.bottom);
                OS.FillRect(n2, rECT, n16);
                OS.DeleteObject(n16);
            }
            return null;
        }
        return rECT;
    }

    RECT drawStrikeoutGDIP(int n2, int n3, int n4, TextLayout$StyleItem[] textLayout$StyleItemArray, int n5, int n6, int n7, RECT rECT, RECT rECT2, int n8, int n9, int n10, Rectangle rectangle) {
        boolean bl2;
        TextLayout$StyleItem textLayout$StyleItem = textLayout$StyleItemArray[n5];
        TextStyle textStyle = textLayout$StyleItem.style;
        if (textStyle == null) {
            return null;
        }
        if (!textStyle.strikeout) {
            return null;
        }
        rECT = this.addClipRect(textLayout$StyleItem, rECT, rECT2, n8, n9);
        boolean bl3 = bl2 = rectangle != null && n3 + textLayout$StyleItem.x + textLayout$StyleItem.width > rectangle.x + rectangle.width;
        if (n5 + 1 >= textLayout$StyleItemArray.length || bl2 || !textStyle.isAdherentStrikeout(textLayout$StyleItemArray[n5 + 1].style)) {
            int n11;
            int n12 = textLayout$StyleItem.x;
            int n13 = textLayout$StyleItem.start;
            int n14 = textLayout$StyleItem.start + textLayout$StyleItem.length - 1;
            for (n11 = n5; n11 > 0 && textStyle.isAdherentStrikeout(textLayout$StyleItemArray[n11 - 1].style); --n11) {
                n12 = textLayout$StyleItemArray[n11 - 1].x;
                n13 = Math.min(n13, textLayout$StyleItemArray[n11 - 1].start);
                n14 = Math.max(n14, textLayout$StyleItemArray[n11 - 1].start + textLayout$StyleItemArray[n11 - 1].length - 1);
            }
            n11 = n8 <= n9 && n8 != -1 && n9 != -1 ? 1 : 0;
            boolean bl4 = n11 != 0 && n8 <= n13 && n14 <= n9;
            int n15 = n6;
            if (textStyle.strikeoutColor != null) {
                n15 = this.createGdipBrush(textStyle.strikeoutColor, n10);
                rECT = null;
            } else if (bl4) {
                n15 = n7;
                rECT = null;
            } else if (textStyle.foreground != null) {
                n15 = this.createGdipBrush(textStyle.foreground, n10);
            }
            int n16 = DPIUtil.autoScaleUp((Drawable)this.getDevice(), textStyle.rise);
            if (rECT != null) {
                int n17 = Gdip.Graphics_Save(n2);
                if (rECT.left == -1) {
                    rECT.left = 0;
                }
                if (rECT.right == -1) {
                    rECT.right = 524287;
                }
                Rect rect = new Rect();
                rect.X = rECT.left;
                rect.Y = rECT.top;
                rect.Width = rECT.right - rECT.left;
                rect.Height = rECT.bottom - rECT.top;
                Gdip.Graphics_SetClip(n2, rect, 4);
                Gdip.Graphics_FillRectangle(n2, n15, n3 + n12, n4 - textLayout$StyleItem.strikeoutPos - n16, textLayout$StyleItem.x + textLayout$StyleItem.width - n12, textLayout$StyleItem.strikeoutThickness);
                Gdip.Graphics_Restore(n2, n17);
                n17 = Gdip.Graphics_Save(n2);
                Gdip.Graphics_SetClip(n2, rect, 1);
                Gdip.Graphics_FillRectangle(n2, n7, n3 + n12, n4 - textLayout$StyleItem.strikeoutPos - n16, textLayout$StyleItem.x + textLayout$StyleItem.width - n12, textLayout$StyleItem.strikeoutThickness);
                Gdip.Graphics_Restore(n2, n17);
            } else {
                Gdip.Graphics_FillRectangle(n2, n15, n3 + n12, n4 - textLayout$StyleItem.strikeoutPos - n16, textLayout$StyleItem.x + textLayout$StyleItem.width - n12, textLayout$StyleItem.strikeoutThickness);
            }
            if (n15 != n7 && n15 != n6) {
                Gdip.SolidBrush_delete(n15);
            }
            return null;
        }
        return rECT;
    }

    RECT drawUnderline(int n2, int n3, int n4, int n5, int n6, TextLayout$StyleItem[] textLayout$StyleItemArray, int n7, int n8, int n9, RECT rECT, RECT rECT2, int n10, int n11, Rectangle rectangle) {
        boolean bl2;
        TextLayout$StyleItem textLayout$StyleItem = textLayout$StyleItemArray[n7];
        TextStyle textStyle = textLayout$StyleItem.style;
        if (textStyle == null) {
            return null;
        }
        if (!textStyle.underline) {
            return null;
        }
        rECT = this.addClipRect(textLayout$StyleItem, rECT, rECT2, n10, n11);
        boolean bl3 = bl2 = rectangle != null && n3 + textLayout$StyleItem.x + textLayout$StyleItem.width > rectangle.x + rectangle.width;
        if (n7 + 1 >= textLayout$StyleItemArray.length || bl2 || !textStyle.isAdherentUnderline(textLayout$StyleItemArray[n7 + 1].style)) {
            boolean bl4;
            int n12;
            int n13 = textLayout$StyleItem.x;
            int n14 = textLayout$StyleItem.start;
            int n15 = textLayout$StyleItem.start + textLayout$StyleItem.length - 1;
            for (n12 = n7; n12 > 0 && textStyle.isAdherentUnderline(textLayout$StyleItemArray[n12 - 1].style); --n12) {
                n13 = textLayout$StyleItemArray[n12 - 1].x;
                n14 = Math.min(n14, textLayout$StyleItemArray[n12 - 1].start);
                n15 = Math.max(n15, textLayout$StyleItemArray[n12 - 1].start + textLayout$StyleItemArray[n12 - 1].length - 1);
            }
            n12 = n10 <= n11 && n10 != -1 && n11 != -1 ? 1 : 0;
            boolean bl5 = bl4 = n12 != 0 && n10 <= n14 && n15 <= n11;
            if (textStyle.underlineColor != null) {
                n8 = textStyle.underlineColor.handle;
                rECT = null;
            } else if (bl4) {
                n8 = n9;
                rECT = null;
            } else if (textStyle.foreground != null) {
                n8 = textStyle.foreground.handle;
            }
            RECT rECT3 = new RECT();
            int n16 = DPIUtil.autoScaleUp((Drawable)this.getDevice(), textStyle.rise);
            OS.SetRect(rECT3, n3 + n13, n4 - n5 - n16, n3 + textLayout$StyleItem.x + textLayout$StyleItem.width, n4 - n5 + textLayout$StyleItem.underlineThickness - n16);
            if (rECT != null) {
                if (rECT.left == -1) {
                    rECT.left = 0;
                }
                if (rECT.right == -1) {
                    rECT.right = 524287;
                }
                OS.SetRect(rECT, Math.max(rECT3.left, rECT.left), rECT3.top, Math.min(rECT3.right, rECT.right), rECT3.bottom);
            }
            switch (textStyle.underlineStyle) {
                case 2: 
                case 3: {
                    int n17 = 1;
                    int n18 = 2 * n17;
                    int n19 = Math.min(rECT3.top - n18 / 2, n6 - n18 - 1);
                    int[] nArray = this.computePolyline(rECT3.left, n19, rECT3.right, n19 + n18);
                    int n20 = OS.CreatePen(0, n17, n8);
                    int n21 = OS.SelectObject(n2, n20);
                    int n22 = OS.SaveDC(n2);
                    OS.IntersectClipRect(n2, rECT3.left, n19, rECT3.right + 1, n19 + n18 + 1);
                    OS.Polyline(n2, nArray, nArray.length / 2);
                    int n23 = nArray.length;
                    if (n23 >= 2 && n17 <= 1) {
                        OS.SetPixel(n2, nArray[n23 - 2], nArray[n23 - 1], n8);
                    }
                    OS.SelectObject(n2, n21);
                    OS.DeleteObject(n20);
                    OS.RestoreDC(n2, n22);
                    if (rECT == null) break;
                    n20 = OS.CreatePen(0, n17, n9);
                    n21 = OS.SelectObject(n2, n20);
                    n22 = OS.SaveDC(n2);
                    OS.IntersectClipRect(n2, rECT.left, n19, rECT.right + 1, n19 + n18 + 1);
                    OS.Polyline(n2, nArray, nArray.length / 2);
                    if (n23 >= 2 && n17 <= 1) {
                        OS.SetPixel(n2, nArray[n23 - 2], nArray[n23 - 1], n9);
                    }
                    OS.SelectObject(n2, n21);
                    OS.DeleteObject(n20);
                    OS.RestoreDC(n2, n22);
                    break;
                }
                case 0: 
                case 1: 
                case 4: 
                case 196608: {
                    int n24;
                    if (textStyle.underlineStyle == 196608) {
                        rECT3.top -= textLayout$StyleItem.underlineThickness;
                        if (rECT != null) {
                            rECT.top -= textLayout$StyleItem.underlineThickness;
                        }
                    }
                    int n25 = n24 = textStyle.underlineStyle == 1 ? rECT3.bottom + textLayout$StyleItem.underlineThickness * 2 : rECT3.bottom;
                    if (n24 > n6) {
                        OS.OffsetRect(rECT3, 0, n6 - n24);
                        if (rECT != null) {
                            OS.OffsetRect(rECT, 0, n6 - n24);
                        }
                    }
                    int n26 = OS.CreateSolidBrush(n8);
                    OS.FillRect(n2, rECT3, n26);
                    if (textStyle.underlineStyle == 1) {
                        OS.SetRect(rECT3, rECT3.left, rECT3.top + textLayout$StyleItem.underlineThickness * 2, rECT3.right, rECT3.bottom + textLayout$StyleItem.underlineThickness * 2);
                        OS.FillRect(n2, rECT3, n26);
                    }
                    OS.DeleteObject(n26);
                    if (rECT == null) break;
                    int n27 = OS.CreateSolidBrush(n9);
                    OS.FillRect(n2, rECT, n27);
                    if (textStyle.underlineStyle == 1) {
                        OS.SetRect(rECT, rECT.left, rECT3.top, rECT.right, rECT3.bottom);
                        OS.FillRect(n2, rECT, n27);
                    }
                    OS.DeleteObject(n27);
                    break;
                }
                case 65536: 
                case 131072: {
                    int n28 = textStyle.underlineStyle == 131072 ? 1 : 2;
                    int n29 = OS.CreatePen(n28, 1, n8);
                    int n30 = OS.SelectObject(n2, n29);
                    int n31 = DPIUtil.autoScaleUp((Drawable)this.getDevice(), textLayout$StyleItem.descentInPoints);
                    OS.SetRect(rECT3, rECT3.left, n4 + n31, rECT3.right, n4 + n31 + textLayout$StyleItem.underlineThickness);
                    OS.MoveToEx(n2, rECT3.left, rECT3.top, 0);
                    OS.LineTo(n2, rECT3.right, rECT3.top);
                    OS.SelectObject(n2, n30);
                    OS.DeleteObject(n29);
                    if (rECT == null) break;
                    n29 = OS.CreatePen(n28, 1, n9);
                    n30 = OS.SelectObject(n2, n29);
                    OS.SetRect(rECT, rECT.left, rECT3.top, rECT.right, rECT3.bottom);
                    OS.MoveToEx(n2, rECT.left, rECT.top, 0);
                    OS.LineTo(n2, rECT.right, rECT.top);
                    OS.SelectObject(n2, n30);
                    OS.DeleteObject(n29);
                    break;
                }
            }
            return null;
        }
        return rECT;
    }

    RECT drawUnderlineGDIP(int n2, int n3, int n4, int n5, int n6, TextLayout$StyleItem[] textLayout$StyleItemArray, int n7, int n8, int n9, RECT rECT, RECT rECT2, int n10, int n11, int n12, Rectangle rectangle) {
        boolean bl2;
        TextLayout$StyleItem textLayout$StyleItem = textLayout$StyleItemArray[n7];
        TextStyle textStyle = textLayout$StyleItem.style;
        if (textStyle == null) {
            return null;
        }
        if (!textStyle.underline) {
            return null;
        }
        rECT = this.addClipRect(textLayout$StyleItem, rECT, rECT2, n10, n11);
        boolean bl3 = bl2 = rectangle != null && n3 + textLayout$StyleItem.x + textLayout$StyleItem.width > rectangle.x + rectangle.width;
        if (n7 + 1 >= textLayout$StyleItemArray.length || bl2 || !textStyle.isAdherentUnderline(textLayout$StyleItemArray[n7 + 1].style)) {
            int n13;
            int n14 = textLayout$StyleItem.x;
            int n15 = textLayout$StyleItem.start;
            int n16 = textLayout$StyleItem.start + textLayout$StyleItem.length - 1;
            for (n13 = n7; n13 > 0 && textStyle.isAdherentUnderline(textLayout$StyleItemArray[n13 - 1].style); --n13) {
                n14 = textLayout$StyleItemArray[n13 - 1].x;
                n15 = Math.min(n15, textLayout$StyleItemArray[n13 - 1].start);
                n16 = Math.max(n16, textLayout$StyleItemArray[n13 - 1].start + textLayout$StyleItemArray[n13 - 1].length - 1);
            }
            n13 = n10 <= n11 && n10 != -1 && n11 != -1 ? 1 : 0;
            boolean bl4 = n13 != 0 && n10 <= n15 && n16 <= n11;
            int n17 = n8;
            if (textStyle.underlineColor != null) {
                n17 = this.createGdipBrush(textStyle.underlineColor, n12);
                rECT = null;
            } else if (bl4) {
                n17 = n9;
                rECT = null;
            } else if (textStyle.foreground != null) {
                n17 = this.createGdipBrush(textStyle.foreground, n12);
            }
            RECT rECT3 = new RECT();
            int n18 = DPIUtil.autoScaleUp((Drawable)this.getDevice(), textStyle.rise);
            OS.SetRect(rECT3, n3 + n14, n4 - n5 - n18, n3 + textLayout$StyleItem.x + textLayout$StyleItem.width, n4 - n5 + textLayout$StyleItem.underlineThickness - n18);
            Rect rect = null;
            if (rECT != null) {
                if (rECT.left == -1) {
                    rECT.left = 0;
                }
                if (rECT.right == -1) {
                    rECT.right = 524287;
                }
                OS.SetRect(rECT, Math.max(rECT3.left, rECT.left), rECT3.top, Math.min(rECT3.right, rECT.right), rECT3.bottom);
                rect = new Rect();
                rect.X = rECT.left;
                rect.Y = rECT.top;
                rect.Width = rECT.right - rECT.left;
                rect.Height = rECT.bottom - rECT.top;
            }
            int n19 = 0;
            Gdip.Graphics_SetPixelOffsetMode(n2, 3);
            int n20 = Gdip.Graphics_GetSmoothingMode(n2);
            Gdip.Graphics_SetSmoothingMode(n2, 3);
            switch (textStyle.underlineStyle) {
                case 2: 
                case 3: {
                    int n21 = 1;
                    int n22 = 2 * n21;
                    int n23 = Math.min(rECT3.top - n22 / 2, n6 - n22 - 1);
                    int[] nArray = this.computePolyline(rECT3.left, n23, rECT3.right, n23 + n22);
                    int n24 = Gdip.Pen_new(n17, n21);
                    n19 = Gdip.Graphics_Save(n2);
                    if (rect != null) {
                        Gdip.Graphics_SetClip(n2, rect, 4);
                    } else {
                        Rect rect2 = new Rect();
                        rect2.X = rECT3.left;
                        rect2.Y = n23;
                        rect2.Width = rECT3.right - rECT3.left;
                        rect2.Height = n22 + 1;
                        Gdip.Graphics_SetClip(n2, rect2, 1);
                    }
                    Gdip.Graphics_DrawLines(n2, n24, nArray, nArray.length / 2);
                    if (rect != null) {
                        int n25 = Gdip.Pen_new(n9, n21);
                        Gdip.Graphics_Restore(n2, n19);
                        n19 = Gdip.Graphics_Save(n2);
                        Gdip.Graphics_SetClip(n2, rect, 1);
                        Gdip.Graphics_DrawLines(n2, n25, nArray, nArray.length / 2);
                        Gdip.Pen_delete(n25);
                    }
                    Gdip.Graphics_Restore(n2, n19);
                    Gdip.Pen_delete(n24);
                    if (n19 == 0) break;
                    Gdip.Graphics_Restore(n2, n19);
                    break;
                }
                case 0: 
                case 1: 
                case 4: 
                case 196608: {
                    int n26;
                    if (textStyle.underlineStyle == 196608) {
                        rECT3.top -= textLayout$StyleItem.underlineThickness;
                    }
                    int n27 = n26 = textStyle.underlineStyle == 1 ? rECT3.bottom + textLayout$StyleItem.underlineThickness * 2 : rECT3.bottom;
                    if (n26 > n6) {
                        OS.OffsetRect(rECT3, 0, n6 - n26);
                    }
                    if (rect != null) {
                        rect.Y = rECT3.top;
                        if (textStyle.underlineStyle == 196608) {
                            rect.Height = textLayout$StyleItem.underlineThickness * 2;
                        }
                        if (textStyle.underlineStyle == 1) {
                            rect.Height = textLayout$StyleItem.underlineThickness * 3;
                        }
                        n19 = Gdip.Graphics_Save(n2);
                        Gdip.Graphics_SetClip(n2, rect, 4);
                    }
                    Gdip.Graphics_FillRectangle(n2, n17, rECT3.left, rECT3.top, rECT3.right - rECT3.left, rECT3.bottom - rECT3.top);
                    if (textStyle.underlineStyle == 1) {
                        Gdip.Graphics_FillRectangle(n2, n17, rECT3.left, rECT3.top + textLayout$StyleItem.underlineThickness * 2, rECT3.right - rECT3.left, rECT3.bottom - rECT3.top);
                    }
                    if (rect == null) break;
                    Gdip.Graphics_Restore(n2, n19);
                    n19 = Gdip.Graphics_Save(n2);
                    Gdip.Graphics_SetClip(n2, rect, 1);
                    Gdip.Graphics_FillRectangle(n2, n9, rECT3.left, rECT3.top, rECT3.right - rECT3.left, rECT3.bottom - rECT3.top);
                    if (textStyle.underlineStyle == 1) {
                        Gdip.Graphics_FillRectangle(n2, n9, rECT3.left, rECT3.top + textLayout$StyleItem.underlineThickness * 2, rECT3.right - rECT3.left, rECT3.bottom - rECT3.top);
                    }
                    Gdip.Graphics_Restore(n2, n19);
                    break;
                }
                case 65536: 
                case 131072: {
                    int n28 = Gdip.Pen_new(n17, 1.0f);
                    int n29 = textStyle.underlineStyle == 65536 ? 2 : 1;
                    Gdip.Pen_SetDashStyle(n28, n29);
                    if (rect != null) {
                        n19 = Gdip.Graphics_Save(n2);
                        Gdip.Graphics_SetClip(n2, rect, 4);
                    }
                    int n30 = DPIUtil.autoScaleUp((Drawable)this.getDevice(), textLayout$StyleItem.descentInPoints);
                    Gdip.Graphics_DrawLine(n2, n28, rECT3.left, n4 + n30, textLayout$StyleItem.width - textLayout$StyleItem.length, n4 + n30);
                    if (rect != null) {
                        Gdip.Graphics_Restore(n2, n19);
                        n19 = Gdip.Graphics_Save(n2);
                        Gdip.Graphics_SetClip(n2, rect, 1);
                        int n31 = Gdip.Pen_new(n17, 1.0f);
                        Gdip.Pen_SetDashStyle(n31, n29);
                        Gdip.Graphics_DrawLine(n2, n31, rECT3.left, n4 + n30, textLayout$StyleItem.width - textLayout$StyleItem.length, n4 + n30);
                        Gdip.Graphics_Restore(n2, n19);
                        Gdip.Pen_delete(n31);
                    }
                    Gdip.Pen_delete(n28);
                    break;
                }
            }
            if (n17 != n9 && n17 != n8) {
                Gdip.SolidBrush_delete(n17);
            }
            Gdip.Graphics_SetPixelOffsetMode(n2, 4);
            Gdip.Graphics_SetSmoothingMode(n2, n20);
            return null;
        }
        return rECT;
    }

    void freeRuns() {
        if (this.allRuns == null) {
            return;
        }
        for (int i2 = 0; i2 < this.allRuns.length; ++i2) {
            TextLayout$StyleItem textLayout$StyleItem = this.allRuns[i2];
            textLayout$StyleItem.free();
        }
        this.allRuns = null;
        this.runs = null;
        this.segmentsText = null;
    }

    public int getAlignment() {
        this.checkLayout();
        return this.alignment;
    }

    public int getAscent() {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.ascentInPixels);
    }

    public Rectangle getBounds() {
        this.checkLayout();
        this.computeRuns(null);
        int n2 = 0;
        if (this.wrapWidth != -1) {
            n2 = this.wrapWidth;
        } else {
            for (int i2 = 0; i2 < this.runs.length; ++i2) {
                n2 = Math.max(n2, this.lineWidth[i2] + this.getLineIndent(i2));
            }
        }
        return new Rectangle(0, 0, DPIUtil.autoScaleDown((Drawable)this.getDevice(), n2), this.lineY[this.lineY.length - 1]);
    }

    public Rectangle getBounds(int n2, int n3) {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getBoundsInPixels(n2, n3));
    }

    Rectangle getBoundsInPixels(int n2, int n3) {
        this.computeRuns(null);
        int n4 = this.text.length();
        if (n4 == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (n2 > n3) {
            return new Rectangle(0, 0, 0, 0);
        }
        n2 = Math.min(Math.max(0, n2), n4 - 1);
        n3 = Math.min(Math.max(0, n3), n4 - 1);
        n2 = this.translateOffset(n2);
        n3 = this.translateOffset(n3);
        n4 = this.segmentsText.length();
        char c2 = this.segmentsText.charAt(n2);
        if ('\udc00' <= c2 && c2 <= '\udfff' && n2 - 1 >= 0 && '\ud800' <= (c2 = this.segmentsText.charAt(n2 - 1)) && c2 <= '\udbff') {
            --n2;
        }
        if ('\ud800' <= (c2 = this.segmentsText.charAt(n3)) && c2 <= '\udbff' && n3 + 1 < n4 && '\udc00' <= (c2 = this.segmentsText.charAt(n3 + 1)) && c2 <= '\udfff') {
            ++n3;
        }
        int n5 = Integer.MAX_VALUE;
        int n6 = 0;
        int n7 = Integer.MAX_VALUE;
        int n8 = 0;
        boolean bl2 = (this.orientation & 0x4000000) != 0;
        for (int i2 = 0; i2 < this.allRuns.length - 1; ++i2) {
            int n9;
            Object object;
            Object object2;
            TextLayout$StyleItem textLayout$StyleItem = this.allRuns[i2];
            int n10 = textLayout$StyleItem.start + textLayout$StyleItem.length;
            if (n10 <= n2) continue;
            if (textLayout$StyleItem.start > n3) break;
            int n11 = textLayout$StyleItem.x;
            int n12 = textLayout$StyleItem.x + textLayout$StyleItem.width;
            if (textLayout$StyleItem.start <= n2 && n2 < n10) {
                object2 = 0;
                if (textLayout$StyleItem.style != null && textLayout$StyleItem.style.metrics != null) {
                    object = textLayout$StyleItem.style.metrics;
                    object2 = ((GlyphMetrics)object).getWidthInPixels() * (n2 - textLayout$StyleItem.start);
                } else if (!textLayout$StyleItem.tab) {
                    object = new int[1];
                    n9 = textLayout$StyleItem.justify != 0 ? textLayout$StyleItem.justify : textLayout$StyleItem.advances;
                    OS.ScriptCPtoX(n2 - textLayout$StyleItem.start, false, textLayout$StyleItem.length, textLayout$StyleItem.glyphCount, textLayout$StyleItem.clusters, textLayout$StyleItem.visAttrs, n9, textLayout$StyleItem.analysis, (int[])object);
                    object2 = bl2 ? (Object)(textLayout$StyleItem.width - object[0]) : object[0];
                }
                if (textLayout$StyleItem.analysis.fRTL ^ bl2) {
                    n12 = textLayout$StyleItem.x + object2;
                } else {
                    n11 = textLayout$StyleItem.x + object2;
                }
            }
            if (textLayout$StyleItem.start <= n3 && n3 < n10) {
                object2 = textLayout$StyleItem.width;
                if (textLayout$StyleItem.style != null && textLayout$StyleItem.style.metrics != null) {
                    object = textLayout$StyleItem.style.metrics;
                    object2 = ((GlyphMetrics)object).getWidthInPixels() * (n3 - textLayout$StyleItem.start + 1);
                } else if (!textLayout$StyleItem.tab) {
                    object = new int[1];
                    n9 = textLayout$StyleItem.justify != 0 ? textLayout$StyleItem.justify : textLayout$StyleItem.advances;
                    OS.ScriptCPtoX(n3 - textLayout$StyleItem.start, true, textLayout$StyleItem.length, textLayout$StyleItem.glyphCount, textLayout$StyleItem.clusters, textLayout$StyleItem.visAttrs, n9, textLayout$StyleItem.analysis, (int[])object);
                    object2 = bl2 ? (Object)(textLayout$StyleItem.width - object[0]) : object[0];
                }
                if (textLayout$StyleItem.analysis.fRTL ^ bl2) {
                    n11 = textLayout$StyleItem.x + object2;
                } else {
                    n12 = textLayout$StyleItem.x + object2;
                }
            }
            for (object2 = 0; object2 < this.runs.length && this.lineOffset[object2 + 1] <= textLayout$StyleItem.start; ++object2) {
            }
            n5 = Math.min(n5, n11);
            n6 = Math.max(n6, n12);
            n7 = Math.min(n7, DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.lineY[object2]));
            n8 = Math.max(n8, DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.lineY[object2 + 1] - this.lineSpacingInPoints));
        }
        return new Rectangle(n5, n7, n6 - n5, n8 - n7);
    }

    public int getDescent() {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.descentInPixels);
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    public int getIndent() {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getIndentInPixels());
    }

    int getIndentInPixels() {
        return this.indent;
    }

    public boolean getJustify() {
        this.checkLayout();
        return this.justify;
    }

    int getItemFont(TextLayout$StyleItem textLayout$StyleItem) {
        if (textLayout$StyleItem.fallbackFont != 0) {
            return textLayout$StyleItem.fallbackFont;
        }
        if (textLayout$StyleItem.style != null && textLayout$StyleItem.style.font != null) {
            return textLayout$StyleItem.style.font.handle;
        }
        if (this.font != null) {
            return this.font.handle;
        }
        return this.device.systemFont.handle;
    }

    public int getLevel(int n2) {
        this.checkLayout();
        this.computeRuns(null);
        int n3 = this.text.length();
        if (0 > n2 || n2 > n3) {
            SWT.error(6);
        }
        n2 = this.translateOffset(n2);
        for (int i2 = 1; i2 < this.allRuns.length; ++i2) {
            if (this.allRuns[i2].start <= n2) continue;
            return this.allRuns[i2 - 1].analysis.s.uBidiLevel;
        }
        return (this.resolveTextDirection() & 0x4000000) != 0 ? 1 : 0;
    }

    public Rectangle getLineBounds(int n2) {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getLineBoundsInPixels(n2));
    }

    Rectangle getLineBoundsInPixels(int n2) {
        this.computeRuns(null);
        if (0 > n2 || n2 >= this.runs.length) {
            SWT.error(6);
        }
        int n3 = this.getLineIndent(n2);
        int n4 = DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.lineY[n2]);
        int n5 = this.lineWidth[n2];
        int n6 = DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.lineY[n2 + 1] - this.lineY[n2] - this.lineSpacingInPoints);
        return new Rectangle(n3, n4, n5, n6);
    }

    public int getLineCount() {
        this.checkLayout();
        this.computeRuns(null);
        return this.runs.length;
    }

    int getLineIndent(int n2) {
        TextLayout$StyleItem[] textLayout$StyleItemArray;
        int n3 = this.wrapIndent;
        if (n2 == 0) {
            n3 = this.indent;
        } else {
            TextLayout$StyleItem[] textLayout$StyleItemArray2 = this.runs[n2 - 1];
            textLayout$StyleItemArray = textLayout$StyleItemArray2[textLayout$StyleItemArray2.length - 1];
            if (textLayout$StyleItemArray.lineBreak && !textLayout$StyleItemArray.softBreak) {
                n3 = this.indent;
            }
        }
        if (this.wrapWidth != -1) {
            boolean bl2 = true;
            if (this.justify) {
                textLayout$StyleItemArray = this.runs[n2];
                if (textLayout$StyleItemArray[textLayout$StyleItemArray.length - 1].softBreak) {
                    bl2 = false;
                }
            }
            if (bl2) {
                int n4 = this.lineWidth[n2] + n3;
                switch (this.alignment) {
                    case 0x1000000: {
                        n3 += (this.wrapWidth - n4) / 2;
                        break;
                    }
                    case 131072: {
                        n3 += this.wrapWidth - n4;
                    }
                }
            }
        }
        return n3;
    }

    public int getLineIndex(int n2) {
        this.checkLayout();
        this.computeRuns(null);
        int n3 = this.text.length();
        if (0 > n2 || n2 > n3) {
            SWT.error(6);
        }
        n2 = this.translateOffset(n2);
        for (int i2 = 0; i2 < this.runs.length; ++i2) {
            if (this.lineOffset[i2 + 1] <= n2) continue;
            return i2;
        }
        return this.runs.length - 1;
    }

    public FontMetrics getLineMetrics(int n2) {
        this.checkLayout();
        this.computeRuns(null);
        if (0 > n2 || n2 >= this.runs.length) {
            SWT.error(6);
        }
        int n3 = this.device.internal_new_GC(null);
        int n4 = OS.CreateCompatibleDC(n3);
        TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.SelectObject(n4, this.font != null ? this.font.handle : this.device.systemFont.handle);
        OS.GetTextMetrics(n4, tEXTMETRIC);
        OS.DeleteDC(n4);
        this.device.internal_dispose_GC(n3, null);
        int n5 = DPIUtil.autoScaleDown((Drawable)this.getDevice(), Math.max(tEXTMETRIC.tmAscent, this.ascentInPixels));
        int n6 = DPIUtil.autoScaleDown((Drawable)this.getDevice(), Math.max(tEXTMETRIC.tmDescent, this.descentInPixels));
        int n7 = DPIUtil.autoScaleDown((Drawable)this.getDevice(), tEXTMETRIC.tmInternalLeading);
        if (this.text.length() != 0) {
            TextLayout$StyleItem[] textLayout$StyleItemArray = this.runs[n2];
            for (int i2 = 0; i2 < textLayout$StyleItemArray.length; ++i2) {
                TextLayout$StyleItem textLayout$StyleItem = textLayout$StyleItemArray[i2];
                if (textLayout$StyleItem.ascentInPoints > n5) {
                    n5 = textLayout$StyleItem.ascentInPoints;
                    n7 = textLayout$StyleItem.leadingInPoints;
                }
                n6 = Math.max(n6, textLayout$StyleItem.descentInPoints);
            }
        }
        tEXTMETRIC.tmAscent = DPIUtil.autoScaleUp((Drawable)this.getDevice(), n5);
        tEXTMETRIC.tmDescent = DPIUtil.autoScaleUp((Drawable)this.getDevice(), n6);
        tEXTMETRIC.tmHeight = DPIUtil.autoScaleUp((Drawable)this.getDevice(), n5 + n6);
        tEXTMETRIC.tmInternalLeading = DPIUtil.autoScaleUp((Drawable)this.getDevice(), n7);
        tEXTMETRIC.tmAveCharWidth = 0;
        return FontMetrics.win32_new(tEXTMETRIC);
    }

    public int[] getLineOffsets() {
        this.checkLayout();
        this.computeRuns(null);
        int[] nArray = new int[this.lineOffset.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = this.untranslateOffset(this.lineOffset[i2]);
        }
        return nArray;
    }

    public Point getLocation(int n2, boolean bl2) {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getLocationInPixels(n2, bl2));
    }

    Point getLocationInPixels(int n2, boolean bl2) {
        int n3;
        this.computeRuns(null);
        int n4 = this.text.length();
        if (0 > n2 || n2 > n4) {
            SWT.error(6);
        }
        n4 = this.segmentsText.length();
        n2 = this.translateOffset(n2);
        for (n3 = 0; n3 < this.runs.length && this.lineOffset[n3 + 1] <= n2; ++n3) {
        }
        n3 = Math.min(n3, this.runs.length - 1);
        if (n2 == n4) {
            return new Point(this.getLineIndent(n3) + this.lineWidth[n3], DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.lineY[n3]));
        }
        char c2 = this.segmentsText.charAt(n2);
        if (bl2) {
            if ('\ud800' <= c2 && c2 <= '\udbff' && n2 + 1 < n4 && '\udc00' <= (c2 = this.segmentsText.charAt(n2 + 1)) && c2 <= '\udfff') {
                ++n2;
            }
        } else if ('\udc00' <= c2 && c2 <= '\udfff' && n2 - 1 >= 0 && '\ud800' <= (c2 = this.segmentsText.charAt(n2 - 1)) && c2 <= '\udbff') {
            --n2;
        }
        int n5 = -1;
        int n6 = this.allRuns.length;
        while (n6 - n5 > 1) {
            int n7;
            int n8 = (n6 + n5) / 2;
            TextLayout$StyleItem textLayout$StyleItem = this.allRuns[n8];
            if (textLayout$StyleItem.start > n2) {
                n6 = n8;
                continue;
            }
            if (textLayout$StyleItem.start + textLayout$StyleItem.length <= n2) {
                n5 = n8;
                continue;
            }
            if (textLayout$StyleItem.style != null && textLayout$StyleItem.style.metrics != null) {
                GlyphMetrics glyphMetrics = textLayout$StyleItem.style.metrics;
                n7 = glyphMetrics.getWidthInPixels() * (n2 - textLayout$StyleItem.start + (bl2 ? 1 : 0));
            } else if (textLayout$StyleItem.tab) {
                n7 = bl2 || n2 == n4 ? textLayout$StyleItem.width : 0;
            } else {
                int n9 = n2 - textLayout$StyleItem.start;
                int n10 = textLayout$StyleItem.length;
                int n11 = textLayout$StyleItem.glyphCount;
                int[] nArray = new int[1];
                int n12 = textLayout$StyleItem.justify != 0 ? textLayout$StyleItem.justify : textLayout$StyleItem.advances;
                OS.ScriptCPtoX(n9, bl2, n10, n11, textLayout$StyleItem.clusters, textLayout$StyleItem.visAttrs, n12, textLayout$StyleItem.analysis, nArray);
                n7 = (this.orientation & 0x4000000) != 0 ? textLayout$StyleItem.width - nArray[0] : nArray[0];
            }
            return new Point(textLayout$StyleItem.x + n7, DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.lineY[n3]));
        }
        return new Point(0, 0);
    }

    public int getNextOffset(int n2, int n3) {
        this.checkLayout();
        return this._getOffset(n2, n3, true);
    }

    int _getOffset(int n2, int n3, boolean bl2) {
        int n4;
        this.computeRuns(null);
        int n5 = this.text.length();
        if (0 > n2 || n2 > n5) {
            SWT.error(6, null, " [offset value: " + n2 + "]");
        }
        if (bl2 && n2 == n5) {
            return n5;
        }
        if (!bl2 && n2 == 0) {
            return 0;
        }
        int n6 = n4 = bl2 ? 1 : -1;
        if ((n3 & 1) != 0) {
            return n2 + n4;
        }
        n5 = this.segmentsText.length();
        n2 = this.translateOffset(n2);
        SCRIPT_LOGATTR sCRIPT_LOGATTR = new SCRIPT_LOGATTR();
        SCRIPT_PROPERTIES sCRIPT_PROPERTIES = new SCRIPT_PROPERTIES();
        int n7 = bl2 ? 0 : this.allRuns.length - 1;
        n2 = this.validadeOffset(n2, n4);
        do {
            boolean bl3;
            TextLayout$StyleItem textLayout$StyleItem = this.allRuns[n7];
            if (textLayout$StyleItem.start > n2 || n2 >= textLayout$StyleItem.start + textLayout$StyleItem.length) continue;
            if (textLayout$StyleItem.lineBreak && !textLayout$StyleItem.softBreak) {
                return this.untranslateOffset(textLayout$StyleItem.start);
            }
            if (textLayout$StyleItem.tab) {
                return this.untranslateOffset(textLayout$StyleItem.start);
            }
            OS.MoveMemory(sCRIPT_PROPERTIES, this.device.scripts[textLayout$StyleItem.analysis.eScript], SCRIPT_PROPERTIES.sizeof);
            boolean bl4 = bl3 = sCRIPT_PROPERTIES.fNeedsCaretInfo || sCRIPT_PROPERTIES.fNeedsWordBreaking;
            if (bl3) {
                this.breakRun(textLayout$StyleItem);
            }
            while (textLayout$StyleItem.start <= n2 && n2 < textLayout$StyleItem.start + textLayout$StyleItem.length) {
                if (bl3) {
                    OS.MoveMemory(sCRIPT_LOGATTR, textLayout$StyleItem.psla + (n2 - textLayout$StyleItem.start) * SCRIPT_LOGATTR.sizeof, SCRIPT_LOGATTR.sizeof);
                }
                switch (n3) {
                    case 2: {
                        if (sCRIPT_PROPERTIES.fNeedsCaretInfo && (sCRIPT_LOGATTR.fInvalid || !sCRIPT_LOGATTR.fCharStop)) break;
                        char c2 = this.segmentsText.charAt(n2);
                        if ('\udc00' <= c2 && c2 <= '\udfff' && n2 > 0 && '\ud800' <= (c2 = this.segmentsText.charAt(n2 - 1)) && c2 <= '\udbff') {
                            n2 += n4;
                        }
                        return this.untranslateOffset(n2);
                    }
                    case 4: 
                    case 16: {
                        char c3;
                        char c2;
                        if (!(sCRIPT_PROPERTIES.fNeedsWordBreaking ? !sCRIPT_LOGATTR.fInvalid && sCRIPT_LOGATTR.fWordStop : n2 > 0 && ((c2 = (char)(Character.isLetterOrDigit(this.segmentsText.charAt(n2)) ? 1 : 0)) != (c3 = Character.isLetterOrDigit(this.segmentsText.charAt(n2 - 1))) || c2 == '\u0000') && !Character.isWhitespace(this.segmentsText.charAt(n2)))) break;
                        return this.untranslateOffset(n2);
                    }
                    case 8: {
                        if (n2 <= 0) break;
                        char c2 = (char)(Character.isLetterOrDigit(this.segmentsText.charAt(n2)) ? 1 : 0);
                        char c3 = Character.isLetterOrDigit(this.segmentsText.charAt(n2 - 1));
                        if (c2 != '\u0000' || c3 == '\u0000') break;
                        return this.untranslateOffset(n2);
                    }
                }
                n2 = this.validadeOffset(n2, n4);
            }
        } while (0 <= (n7 += n4) && n7 < this.allRuns.length - 1 && 0 <= n2 && n2 < n5);
        return bl2 ? this.text.length() : 0;
    }

    public int getOffset(Point point, int[] nArray) {
        this.checkLayout();
        if (point == null) {
            SWT.error(4);
        }
        return this.getOffsetInPixels(DPIUtil.autoScaleUp((Drawable)this.getDevice(), point), nArray);
    }

    int getOffsetInPixels(Point point, int[] nArray) {
        return this.getOffsetInPixels(point.x, point.y, nArray);
    }

    public int getOffset(int n2, int n3, int[] nArray) {
        this.checkLayout();
        return this.getOffsetInPixels(DPIUtil.autoScaleUp((Drawable)this.getDevice(), n2), DPIUtil.autoScaleUp((Drawable)this.getDevice(), n3), nArray);
    }

    int getOffsetInPixels(int n2, int n3, int[] nArray) {
        int n4;
        this.computeRuns(null);
        if (nArray != null && nArray.length < 1) {
            SWT.error(5);
        }
        int n5 = this.runs.length;
        for (n4 = 0; n4 < n5 && DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.lineY[n4 + 1]) <= n3; ++n4) {
        }
        n4 = Math.min(n4, this.runs.length - 1);
        TextLayout$StyleItem[] textLayout$StyleItemArray = this.runs[n4];
        int n6 = this.getLineIndent(n4);
        if (n2 >= n6 + this.lineWidth[n4]) {
            n2 = n6 + this.lineWidth[n4] - 1;
        }
        if (n2 < n6) {
            n2 = n6;
        }
        int n7 = -1;
        int n8 = textLayout$StyleItemArray.length;
        while (n8 - n7 > 1) {
            char c2;
            GlyphMetrics glyphMetrics;
            int n9 = (n8 + n7) / 2;
            TextLayout$StyleItem textLayout$StyleItem = textLayout$StyleItemArray[n9];
            if (textLayout$StyleItem.x > n2) {
                n8 = n9;
                continue;
            }
            if (textLayout$StyleItem.x + textLayout$StyleItem.width <= n2) {
                n7 = n9;
                continue;
            }
            if (textLayout$StyleItem.lineBreak && !textLayout$StyleItem.softBreak) {
                return this.untranslateOffset(textLayout$StyleItem.start);
            }
            int n10 = n2 - textLayout$StyleItem.x;
            if (textLayout$StyleItem.style != null && textLayout$StyleItem.style.metrics != null && (glyphMetrics = textLayout$StyleItem.style.metrics).getWidthInPixels() > 0) {
                if (nArray != null) {
                    nArray[0] = n10 % glyphMetrics.getWidthInPixels() < glyphMetrics.getWidthInPixels() / 2 ? 0 : 1;
                }
                return this.untranslateOffset(textLayout$StyleItem.start + n10 / glyphMetrics.getWidthInPixels());
            }
            if (textLayout$StyleItem.tab) {
                if (nArray != null) {
                    nArray[0] = n2 < textLayout$StyleItem.x + textLayout$StyleItem.width / 2 ? 0 : 1;
                }
                return this.untranslateOffset(textLayout$StyleItem.start);
            }
            int n11 = textLayout$StyleItem.length;
            int n12 = textLayout$StyleItem.glyphCount;
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            if ((this.orientation & 0x4000000) != 0) {
                n10 = textLayout$StyleItem.width - n10;
            }
            int n13 = textLayout$StyleItem.justify != 0 ? textLayout$StyleItem.justify : textLayout$StyleItem.advances;
            OS.ScriptXtoCP(n10, n11, n12, textLayout$StyleItem.clusters, textLayout$StyleItem.visAttrs, n13, textLayout$StyleItem.analysis, nArray2, nArray3);
            int n14 = textLayout$StyleItem.start + nArray2[0];
            int n15 = this.segmentsText.length();
            char c3 = c2 = n14 < n15 ? this.segmentsText.charAt(n14) : (char)'\u0000';
            if ('\ud800' <= c2 && c2 <= '\udbff' && nArray3[0] <= 1) {
                if (n14 + 1 < n15 && '\udc00' <= (c2 = this.segmentsText.charAt(n14 + 1)) && c2 <= '\udfff' && nArray != null) {
                    nArray[0] = 0;
                }
            } else if ('\udc00' <= c2 && c2 <= '\udfff' && nArray3[0] <= 1) {
                if (n14 - 1 >= 0 && '\ud800' <= (c2 = this.segmentsText.charAt(n14 - 1)) && c2 <= '\udbff') {
                    --n14;
                    if (nArray != null) {
                        nArray[0] = 2;
                    }
                }
            } else if (nArray != null) {
                nArray[0] = nArray3[0];
            }
            return this.untranslateOffset(n14);
        }
        if (nArray != null) {
            nArray[0] = 0;
        }
        if (textLayout$StyleItemArray.length == 1) {
            TextLayout$StyleItem textLayout$StyleItem = textLayout$StyleItemArray[0];
            if (textLayout$StyleItem.lineBreak && !textLayout$StyleItem.softBreak) {
                return this.untranslateOffset(textLayout$StyleItem.start);
            }
        }
        return this.untranslateOffset(this.lineOffset[n4 + 1]);
    }

    public int getOrientation() {
        this.checkLayout();
        return this.orientation;
    }

    void getPartialSelection(TextLayout$StyleItem textLayout$StyleItem, int n2, int n3, RECT rECT) {
        int n4 = textLayout$StyleItem.start + textLayout$StyleItem.length - 1;
        int n5 = Math.max(n2, textLayout$StyleItem.start) - textLayout$StyleItem.start;
        int n6 = Math.min(n3, n4) - textLayout$StyleItem.start;
        int n7 = textLayout$StyleItem.length;
        int n8 = textLayout$StyleItem.glyphCount;
        int[] nArray = new int[1];
        int n9 = rECT.left;
        int n10 = textLayout$StyleItem.justify != 0 ? textLayout$StyleItem.justify : textLayout$StyleItem.advances;
        OS.ScriptCPtoX(n5, false, n7, n8, textLayout$StyleItem.clusters, textLayout$StyleItem.visAttrs, n10, textLayout$StyleItem.analysis, nArray);
        int n11 = (this.orientation & 0x4000000) != 0 ? textLayout$StyleItem.width - nArray[0] : nArray[0];
        rECT.left = n9 + n11;
        OS.ScriptCPtoX(n6, true, n7, n8, textLayout$StyleItem.clusters, textLayout$StyleItem.visAttrs, n10, textLayout$StyleItem.analysis, nArray);
        n11 = (this.orientation & 0x4000000) != 0 ? textLayout$StyleItem.width - nArray[0] : nArray[0];
        rECT.right = n9 + n11;
    }

    public int getPreviousOffset(int n2, int n3) {
        this.checkLayout();
        return this._getOffset(n2, n3, false);
    }

    public int[] getRanges() {
        this.checkLayout();
        int[] nArray = new int[this.stylesCount * 2];
        int n2 = 0;
        for (int i2 = 0; i2 < this.stylesCount - 1; ++i2) {
            if (this.styles[i2].style == null) continue;
            nArray[n2++] = this.styles[i2].start;
            nArray[n2++] = this.styles[i2 + 1].start - 1;
        }
        if (n2 != nArray.length) {
            int[] nArray2 = new int[n2];
            System.arraycopy(nArray, 0, nArray2, 0, n2);
            nArray = nArray2;
        }
        return nArray;
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    public char[] getSegmentsChars() {
        this.checkLayout();
        return this.segmentsChars;
    }

    String getSegmentsText() {
        int n2;
        int n3;
        int n4 = this.text.length();
        if (n4 == 0) {
            return this.text;
        }
        if (this.segments == null) {
            return this.text;
        }
        int n5 = this.segments.length;
        if (n5 == 0) {
            return this.text;
        }
        if (this.segmentsChars == null) {
            if (n5 == 1) {
                return this.text;
            }
            if (n5 == 2 && this.segments[0] == 0 && this.segments[1] == n4) {
                return this.text;
            }
        }
        char[] cArray = new char[n4];
        this.text.getChars(0, n4, cArray, 0);
        char[] cArray2 = new char[n4 + n5];
        int n6 = 0;
        int n7 = 0;
        int n8 = n3 = (this.resolveTextDirection() & 0x4000000) != 0 ? 8207 : 8206;
        while (n6 < n4) {
            if (n7 < n5 && n6 == this.segments[n7]) {
                n2 = this.segmentsChars != null && this.segmentsChars.length > n7 ? this.segmentsChars[n7] : n3;
                cArray2[n6 + n7++] = n2;
                continue;
            }
            cArray2[n6 + n7] = cArray[n6++];
        }
        while (n7 < n5) {
            this.segments[n7] = n6;
            n2 = this.segmentsChars != null && this.segmentsChars.length > n7 ? this.segmentsChars[n7] : n3;
            cArray2[n6 + n7++] = n2;
        }
        return new String(cArray2, 0, cArray2.length);
    }

    public int getSpacing() {
        this.checkLayout();
        return this.lineSpacingInPoints;
    }

    public TextStyle getStyle(int n2) {
        this.checkLayout();
        int n3 = this.text.length();
        if (0 > n2 || n2 >= n3) {
            SWT.error(6);
        }
        for (int i2 = 1; i2 < this.stylesCount; ++i2) {
            if (this.styles[i2].start <= n2) continue;
            return this.styles[i2 - 1].style;
        }
        return null;
    }

    public TextStyle[] getStyles() {
        this.checkLayout();
        TextStyle[] textStyleArray = new TextStyle[this.stylesCount];
        int n2 = 0;
        for (int i2 = 0; i2 < this.stylesCount; ++i2) {
            if (this.styles[i2].style == null) continue;
            textStyleArray[n2++] = this.styles[i2].style;
        }
        if (n2 != textStyleArray.length) {
            TextStyle[] textStyleArray2 = new TextStyle[n2];
            System.arraycopy(textStyleArray, 0, textStyleArray2, 0, n2);
            textStyleArray = textStyleArray2;
        }
        return textStyleArray;
    }

    public int[] getTabs() {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getTabsInPixels());
    }

    int[] getTabsInPixels() {
        return this.tabs;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getTextDirection() {
        this.checkLayout();
        return this.resolveTextDirection();
    }

    public int getWidth() {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getWidthInPixels());
    }

    int getWidthInPixels() {
        return this.wrapWidth;
    }

    public int getWrapIndent() {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getWrapIndentInPixels());
    }

    int getWrapIndentInPixels() {
        return this.wrapIndent;
    }

    @Override
    public boolean isDisposed() {
        return this.device == null;
    }

    TextLayout$StyleItem[] itemize() {
        this.segmentsText = this.getSegmentsText();
        int n2 = this.segmentsText.length();
        SCRIPT_CONTROL sCRIPT_CONTROL = new SCRIPT_CONTROL();
        SCRIPT_STATE sCRIPT_STATE = new SCRIPT_STATE();
        int n3 = n2 + 1;
        if ((this.resolveTextDirection() & 0x4000000) != 0) {
            sCRIPT_STATE.uBidiLevel = 1;
            sCRIPT_STATE.fArabicNumContext = true;
        }
        OS.ScriptApplyDigitSubstitution(null, sCRIPT_CONTROL, sCRIPT_STATE);
        int n4 = OS.GetProcessHeap();
        int n5 = OS.HeapAlloc(n4, 8, n3 * SCRIPT_ITEM.sizeof);
        if (n5 == 0) {
            SWT.error(2);
        }
        int[] nArray = new int[1];
        char[] cArray = new char[n2];
        this.segmentsText.getChars(0, n2, cArray, 0);
        OS.ScriptItemize(cArray, n2, n3, sCRIPT_CONTROL, sCRIPT_STATE, n5, nArray);
        TextLayout$StyleItem[] textLayout$StyleItemArray = this.merge(n5, nArray[0]);
        OS.HeapFree(n4, 0, n5);
        return textLayout$StyleItemArray;
    }

    TextLayout$StyleItem[] merge(int n2, int n3) {
        TextLayout$StyleItem textLayout$StyleItem;
        if (this.styles.length > this.stylesCount) {
            TextLayout$StyleItem[] textLayout$StyleItemArray = new TextLayout$StyleItem[this.stylesCount];
            System.arraycopy(this.styles, 0, textLayout$StyleItemArray, 0, this.stylesCount);
            this.styles = textLayout$StyleItemArray;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = this.segmentsText.length();
        int n7 = 0;
        int n8 = 0;
        TextLayout$StyleItem[] textLayout$StyleItemArray = new TextLayout$StyleItem[n3 + this.stylesCount];
        SCRIPT_ITEM sCRIPT_ITEM = new SCRIPT_ITEM();
        int n9 = -1;
        int n10 = 0;
        boolean bl2 = false;
        boolean bl3 = n3 > 1024;
        SCRIPT_PROPERTIES sCRIPT_PROPERTIES = new SCRIPT_PROPERTIES();
        while (n5 < n6) {
            char c2;
            int n11;
            textLayout$StyleItem = new TextLayout$StyleItem(this);
            textLayout$StyleItem.start = n5;
            textLayout$StyleItem.style = this.styles[n8].style;
            textLayout$StyleItemArray[n4++] = textLayout$StyleItem;
            OS.MoveMemory(sCRIPT_ITEM, n2 + n7 * SCRIPT_ITEM.sizeof, SCRIPT_ITEM.sizeof);
            textLayout$StyleItem.analysis = sCRIPT_ITEM.a;
            sCRIPT_ITEM.a = new SCRIPT_ANALYSIS();
            if (bl2) {
                textLayout$StyleItem.analysis.fLinkBefore = true;
                bl2 = false;
            }
            char c3 = this.segmentsText.charAt(n5);
            switch (c3) {
                case '\n': 
                case '\r': {
                    textLayout$StyleItem.lineBreak = true;
                    break;
                }
                case '\t': {
                    textLayout$StyleItem.tab = true;
                }
            }
            if (n9 == -1) {
                n10 = n7 + 1;
                OS.MoveMemory(sCRIPT_ITEM, n2 + n10 * SCRIPT_ITEM.sizeof, SCRIPT_ITEM.sizeof);
                n9 = sCRIPT_ITEM.iCharPos;
                if (n10 < n3 && c3 == '\r' && this.segmentsText.charAt(n9) == '\n') {
                    n10 = n7 + 2;
                    OS.MoveMemory(sCRIPT_ITEM, n2 + n10 * SCRIPT_ITEM.sizeof, SCRIPT_ITEM.sizeof);
                    n9 = sCRIPT_ITEM.iCharPos;
                }
                if (n10 < n3 && bl3 && !textLayout$StyleItem.lineBreak) {
                    OS.MoveMemory(sCRIPT_PROPERTIES, this.device.scripts[textLayout$StyleItem.analysis.eScript], SCRIPT_PROPERTIES.sizeof);
                    if (!sCRIPT_PROPERTIES.fComplex || textLayout$StyleItem.tab) {
                        for (n11 = 0; n11 < 512 && n10 != n3 && (c2 = this.segmentsText.charAt(n9)) != '\n' && c2 != '\r' && c2 == '\t' == textLayout$StyleItem.tab; ++n11) {
                            OS.MoveMemory(sCRIPT_PROPERTIES, this.device.scripts[sCRIPT_ITEM.a.eScript], SCRIPT_PROPERTIES.sizeof);
                            if (!textLayout$StyleItem.tab && sCRIPT_PROPERTIES.fComplex) break;
                            OS.MoveMemory(sCRIPT_ITEM, n2 + ++n10 * SCRIPT_ITEM.sizeof, SCRIPT_ITEM.sizeof);
                            n9 = sCRIPT_ITEM.iCharPos;
                        }
                    }
                }
            }
            if ((n11 = this.translateOffset(this.styles[n8 + 1].start)) <= n9) {
                ++n8;
                n5 = n11;
                if (n5 < n9 && 0 < n5 && n5 < n6) {
                    c2 = this.segmentsText.charAt(n5 - 1);
                    char c4 = this.segmentsText.charAt(n5);
                    if (Character.isLetter(c2) && Character.isLetter(c4)) {
                        textLayout$StyleItem.analysis.fLinkAfter = true;
                        bl2 = true;
                    }
                }
            }
            if (n9 <= n11) {
                n7 = n10;
                n5 = n9;
                n9 = -1;
            }
            textLayout$StyleItem.length = n5 - textLayout$StyleItem.start;
        }
        textLayout$StyleItem = new TextLayout$StyleItem(this);
        textLayout$StyleItem.start = n6;
        OS.MoveMemory(sCRIPT_ITEM, n2 + n3 * SCRIPT_ITEM.sizeof, SCRIPT_ITEM.sizeof);
        textLayout$StyleItem.analysis = sCRIPT_ITEM.a;
        textLayout$StyleItemArray[n4++] = textLayout$StyleItem;
        if (textLayout$StyleItemArray.length != n4) {
            TextLayout$StyleItem[] textLayout$StyleItemArray2 = new TextLayout$StyleItem[n4];
            System.arraycopy(textLayout$StyleItemArray, 0, textLayout$StyleItemArray2, 0, n4);
            return textLayout$StyleItemArray2;
        }
        return textLayout$StyleItemArray;
    }

    int resolveTextDirection() {
        return this.textDirection == 0x6000000 ? BidiUtil.resolveTextDirection(this.text) : this.textDirection;
    }

    TextLayout$StyleItem[] reorder(TextLayout$StyleItem[] textLayout$StyleItemArray, boolean bl2) {
        int n2;
        int n3 = textLayout$StyleItemArray.length;
        if (n3 <= 1) {
            return textLayout$StyleItemArray;
        }
        byte[] byArray = new byte[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            byArray[i2] = (byte)(textLayout$StyleItemArray[i2].analysis.s.uBidiLevel & 0x1F);
        }
        TextLayout$StyleItem textLayout$StyleItem = textLayout$StyleItemArray[n3 - 1];
        if (textLayout$StyleItem.lineBreak && !textLayout$StyleItem.softBreak) {
            byArray[n3 - 1] = 0;
        }
        int[] nArray = new int[n3];
        OS.ScriptLayout(n3, byArray, null, nArray);
        TextLayout$StyleItem[] textLayout$StyleItemArray2 = new TextLayout$StyleItem[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            textLayout$StyleItemArray2[nArray[n2]] = textLayout$StyleItemArray[n2];
        }
        if ((this.orientation & 0x4000000) != 0) {
            if (bl2) {
                --n3;
            }
            for (n2 = 0; n2 < n3 / 2; ++n2) {
                TextLayout$StyleItem textLayout$StyleItem2 = textLayout$StyleItemArray2[n2];
                textLayout$StyleItemArray2[n2] = textLayout$StyleItemArray2[n3 - n2 - 1];
                textLayout$StyleItemArray2[n3 - n2 - 1] = textLayout$StyleItem2;
            }
        }
        return textLayout$StyleItemArray2;
    }

    public void setAlignment(int n2) {
        this.checkLayout();
        int n3 = 16924672;
        if ((n2 &= n3) == 0) {
            return;
        }
        if ((n2 & 0x4000) != 0) {
            n2 = 16384;
        }
        if ((n2 & 0x20000) != 0) {
            n2 = 131072;
        }
        if (this.alignment == n2) {
            return;
        }
        this.freeRuns();
        this.alignment = n2;
    }

    public void setAscent(int n2) {
        this.checkLayout();
        if (n2 < -1) {
            SWT.error(5);
        }
        if (this.ascentInPixels == (n2 = DPIUtil.autoScaleUp((Drawable)this.getDevice(), n2))) {
            return;
        }
        this.freeRuns();
        this.ascentInPixels = n2;
    }

    public void setDescent(int n2) {
        this.checkLayout();
        if (n2 < -1) {
            SWT.error(5);
        }
        if (this.descentInPixels == (n2 = DPIUtil.autoScaleUp((Drawable)this.getDevice(), n2))) {
            return;
        }
        this.freeRuns();
        this.descentInPixels = n2;
    }

    public void setFont(Font font) {
        Font font2;
        this.checkLayout();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if ((font2 = this.font) == font) {
            return;
        }
        this.font = font;
        if (font2 != null && font2.equals(font)) {
            return;
        }
        this.freeRuns();
    }

    public void setIndent(int n2) {
        this.checkLayout();
        this.setIndentInPixels(DPIUtil.autoScaleUp((Drawable)this.getDevice(), n2));
    }

    void setIndentInPixels(int n2) {
        if (n2 < 0) {
            return;
        }
        if (this.indent == n2) {
            return;
        }
        this.freeRuns();
        this.indent = n2;
    }

    public void setJustify(boolean bl2) {
        this.checkLayout();
        if (this.justify == bl2) {
            return;
        }
        this.freeRuns();
        this.justify = bl2;
    }

    public void setOrientation(int n2) {
        this.checkLayout();
        int n3 = 0x6000000;
        if ((n2 &= n3) == 0) {
            return;
        }
        if ((n2 & 0x2000000) != 0) {
            n2 = 0x2000000;
        }
        if (this.orientation == n2) {
            return;
        }
        this.textDirection = this.orientation = n2;
        this.freeRuns();
    }

    public void setSegments(int[] nArray) {
        this.checkLayout();
        if (this.segments == null && nArray == null) {
            return;
        }
        if (this.segments != null && nArray != null && this.segments.length == nArray.length) {
            int n2;
            for (n2 = 0; n2 < nArray.length && this.segments[n2] == nArray[n2]; ++n2) {
            }
            if (n2 == nArray.length) {
                return;
            }
        }
        this.freeRuns();
        this.segments = nArray;
    }

    public void setSegmentsChars(char[] cArray) {
        this.checkLayout();
        if (this.segmentsChars == null && cArray == null) {
            return;
        }
        if (this.segmentsChars != null && cArray != null && this.segmentsChars.length == cArray.length) {
            int n2;
            for (n2 = 0; n2 < cArray.length && this.segmentsChars[n2] == cArray[n2]; ++n2) {
            }
            if (n2 == cArray.length) {
                return;
            }
        }
        this.freeRuns();
        this.segmentsChars = cArray;
    }

    public void setSpacing(int n2) {
        this.checkLayout();
        if (n2 < 0) {
            SWT.error(5);
        }
        if (this.lineSpacingInPoints == n2) {
            return;
        }
        this.freeRuns();
        this.lineSpacingInPoints = n2;
    }

    public void setStyle(TextStyle textStyle, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        this.checkLayout();
        int n8 = this.text.length();
        if (n8 == 0) {
            return;
        }
        if (n2 > n3) {
            return;
        }
        n2 = Math.min(Math.max(0, n2), n8 - 1);
        n3 = Math.min(Math.max(0, n3), n8 - 1);
        int n9 = -1;
        int n10 = this.stylesCount;
        while (n10 - n9 > 1) {
            int n11 = (n10 + n9) / 2;
            if (this.styles[n11 + 1].start > n2) {
                n10 = n11;
                continue;
            }
            n9 = n11;
        }
        if (0 <= n10 && n10 < this.stylesCount) {
            TextLayout$StyleItem textLayout$StyleItem = this.styles[n10];
            if (textLayout$StyleItem.start == n2 && this.styles[n10 + 1].start - 1 == n3 && (textStyle == null ? textLayout$StyleItem.style == null : textStyle.equals(textLayout$StyleItem.style))) {
                return;
            }
        }
        this.freeRuns();
        for (n7 = n6 = n10; n7 < this.stylesCount && this.styles[n7 + 1].start <= n3; ++n7) {
        }
        if (n6 == n7) {
            n5 = this.styles[n6].start;
            n4 = this.styles[n7 + 1].start - 1;
            if (n5 == n2 && n4 == n3) {
                this.styles[n6].style = textStyle;
                return;
            }
            if (n5 != n2 && n4 != n3) {
                int n12 = this.stylesCount + 2;
                if (n12 > this.styles.length) {
                    int n13 = Math.min(n12 + 1024, Math.max(64, n12 * 2));
                    TextLayout$StyleItem[] textLayout$StyleItemArray = new TextLayout$StyleItem[n13];
                    System.arraycopy(this.styles, 0, textLayout$StyleItemArray, 0, this.stylesCount);
                    this.styles = textLayout$StyleItemArray;
                }
                System.arraycopy(this.styles, n7 + 1, this.styles, n7 + 3, this.stylesCount - n7 - 1);
                TextLayout$StyleItem textLayout$StyleItem = new TextLayout$StyleItem(this);
                textLayout$StyleItem.start = n2;
                textLayout$StyleItem.style = textStyle;
                this.styles[n6 + 1] = textLayout$StyleItem;
                textLayout$StyleItem = new TextLayout$StyleItem(this);
                textLayout$StyleItem.start = n3 + 1;
                textLayout$StyleItem.style = this.styles[n6].style;
                this.styles[n6 + 2] = textLayout$StyleItem;
                this.stylesCount = n12;
                return;
            }
        }
        if (n2 == this.styles[n6].start) {
            --n6;
        }
        if (n3 == this.styles[n7 + 1].start - 1) {
            ++n7;
        }
        if ((n5 = this.stylesCount + 1 - (n7 - n6 - 1)) > this.styles.length) {
            n4 = Math.min(n5 + 1024, Math.max(64, n5 * 2));
            TextLayout$StyleItem[] textLayout$StyleItemArray = new TextLayout$StyleItem[n4];
            System.arraycopy(this.styles, 0, textLayout$StyleItemArray, 0, this.stylesCount);
            this.styles = textLayout$StyleItemArray;
        }
        System.arraycopy(this.styles, n7, this.styles, n6 + 2, this.stylesCount - n7);
        TextLayout$StyleItem textLayout$StyleItem = new TextLayout$StyleItem(this);
        textLayout$StyleItem.start = n2;
        textLayout$StyleItem.style = textStyle;
        this.styles[n6 + 1] = textLayout$StyleItem;
        this.styles[n6 + 2].start = n3 + 1;
        this.stylesCount = n5;
    }

    public void setTabs(int[] nArray) {
        this.checkLayout();
        if (this.tabs == null && nArray == null) {
            return;
        }
        this.setTabsInPixels(DPIUtil.autoScaleUp((Drawable)this.getDevice(), nArray));
    }

    void setTabsInPixels(int[] nArray) {
        if (Arrays.equals(this.tabs, nArray)) {
            return;
        }
        this.freeRuns();
        this.tabs = nArray;
    }

    public void setText(String string) {
        this.checkLayout();
        if (string == null) {
            SWT.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.freeRuns();
        this.text = string;
        this.styles = new TextLayout$StyleItem[2];
        this.styles[0] = new TextLayout$StyleItem(this);
        this.styles[1] = new TextLayout$StyleItem(this);
        this.styles[1].start = string.length();
        this.stylesCount = 2;
    }

    public void setTextDirection(int n2) {
        this.checkLayout();
        int n3 = 0x6000000;
        if ((n2 &= n3) == 0) {
            return;
        }
        if (n2 != 0x6000000) {
            if ((n2 & 0x2000000) != 0) {
                n2 = 0x2000000;
            }
            if (this.textDirection == n2) {
                return;
            }
        }
        this.textDirection = n2;
        this.freeRuns();
    }

    public void setWidth(int n2) {
        this.checkLayout();
        this.setWidthInPixels(n2 != -1 ? DPIUtil.autoScaleUp((Drawable)this.getDevice(), n2) : n2);
    }

    void setWidthInPixels(int n2) {
        if (n2 < -1 || n2 == 0) {
            SWT.error(5);
        }
        if (this.wrapWidth == n2) {
            return;
        }
        this.freeRuns();
        this.wrapWidth = n2;
    }

    public void setWrapIndent(int n2) {
        this.checkLayout();
        this.setWrapIndentInPixels(DPIUtil.autoScaleUp((Drawable)this.getDevice(), n2));
    }

    void setWrapIndentInPixels(int n2) {
        if (n2 < 0) {
            return;
        }
        if (this.wrapIndent == n2) {
            return;
        }
        this.freeRuns();
        this.wrapIndent = n2;
    }

    boolean shape(int n2, TextLayout$StyleItem textLayout$StyleItem, char[] cArray, int[] nArray, int n3, SCRIPT_PROPERTIES sCRIPT_PROPERTIES) {
        short[] sArray;
        boolean bl2;
        boolean bl3 = bl2 = !sCRIPT_PROPERTIES.fComplex && !textLayout$StyleItem.analysis.fNoGlyphIndex;
        if (bl2 && OS.ScriptGetCMap(n2, textLayout$StyleItem.psc, cArray, cArray.length, 0, sArray = new short[cArray.length]) != 0) {
            if (textLayout$StyleItem.psc != 0) {
                OS.ScriptFreeCache(textLayout$StyleItem.psc);
                nArray[0] = 0;
                OS.MoveMemory(textLayout$StyleItem.psc, new int[1], OS.PTR_SIZEOF);
            }
            return false;
        }
        int n4 = OS.ScriptShape(n2, textLayout$StyleItem.psc, cArray, cArray.length, n3, textLayout$StyleItem.analysis, textLayout$StyleItem.glyphs, textLayout$StyleItem.clusters, textLayout$StyleItem.visAttrs, nArray);
        textLayout$StyleItem.glyphCount = nArray[0];
        if (bl2) {
            return true;
        }
        if (n4 != -2147220992) {
            int n5;
            if (textLayout$StyleItem.analysis.fNoGlyphIndex) {
                return true;
            }
            SCRIPT_FONTPROPERTIES sCRIPT_FONTPROPERTIES = new SCRIPT_FONTPROPERTIES();
            sCRIPT_FONTPROPERTIES.cBytes = SCRIPT_FONTPROPERTIES.sizeof;
            OS.ScriptGetFontProperties(n2, textLayout$StyleItem.psc, sCRIPT_FONTPROPERTIES);
            short[] sArray2 = new short[nArray[0]];
            OS.MoveMemory(sArray2, textLayout$StyleItem.glyphs, sArray2.length * 2);
            for (n5 = 0; n5 < sArray2.length && sArray2[n5] != sCRIPT_FONTPROPERTIES.wgDefault; ++n5) {
            }
            if (n5 == sArray2.length) {
                return true;
            }
        }
        if (textLayout$StyleItem.psc != 0) {
            OS.ScriptFreeCache(textLayout$StyleItem.psc);
            nArray[0] = 0;
            OS.MoveMemory(textLayout$StyleItem.psc, new int[1], OS.PTR_SIZEOF);
        }
        textLayout$StyleItem.glyphCount = 0;
        return false;
    }

    void shape(int n2, TextLayout$StyleItem textLayout$StyleItem) {
        Object object;
        Object object2;
        if (textLayout$StyleItem.lineBreak) {
            return;
        }
        if (textLayout$StyleItem.glyphs != 0) {
            return;
        }
        int[] nArray = new int[1];
        char[] cArray = new char[textLayout$StyleItem.length];
        this.segmentsText.getChars(textLayout$StyleItem.start, textLayout$StyleItem.start + textLayout$StyleItem.length, cArray, 0);
        int n3 = cArray.length * 3 / 2 + 16;
        int n4 = OS.GetProcessHeap();
        textLayout$StyleItem.glyphs = OS.HeapAlloc(n4, 8, n3 * 2);
        if (textLayout$StyleItem.glyphs == 0) {
            SWT.error(2);
        }
        textLayout$StyleItem.clusters = OS.HeapAlloc(n4, 8, n3 * 2);
        if (textLayout$StyleItem.clusters == 0) {
            SWT.error(2);
        }
        textLayout$StyleItem.visAttrs = OS.HeapAlloc(n4, 8, n3 * 2);
        if (textLayout$StyleItem.visAttrs == 0) {
            SWT.error(2);
        }
        textLayout$StyleItem.psc = OS.HeapAlloc(n4, 8, OS.PTR_SIZEOF);
        if (textLayout$StyleItem.psc == 0) {
            SWT.error(2);
        }
        short s2 = textLayout$StyleItem.analysis.eScript;
        SCRIPT_PROPERTIES sCRIPT_PROPERTIES = new SCRIPT_PROPERTIES();
        OS.MoveMemory(sCRIPT_PROPERTIES, this.device.scripts[s2], SCRIPT_PROPERTIES.sizeof);
        boolean bl2 = this.shape(n2, textLayout$StyleItem, cArray, nArray, n3, sCRIPT_PROPERTIES);
        if (!bl2 && sCRIPT_PROPERTIES.fPrivateUseArea) {
            textLayout$StyleItem.analysis.fNoGlyphIndex = true;
            bl2 = this.shape(n2, textLayout$StyleItem, cArray, nArray, n3, sCRIPT_PROPERTIES);
        }
        if (!bl2) {
            int n5;
            int n6;
            int n7;
            int n8 = OS.GetCurrentObject(n2, 6);
            int n9 = 0;
            object2 = new char[Math.min(cArray.length, 2)];
            object = new SCRIPT_LOGATTR();
            this.breakRun(textLayout$StyleItem);
            int n10 = 0;
            for (n7 = 0; n7 < cArray.length; ++n7) {
                OS.MoveMemory((SCRIPT_LOGATTR)object, textLayout$StyleItem.psla + n7 * SCRIPT_LOGATTR.sizeof, SCRIPT_LOGATTR.sizeof);
                if (((SCRIPT_LOGATTR)object).fWhiteSpace) continue;
                object2[n10++] = cArray[n7];
                if (n10 == ((char[])object2).length) break;
            }
            if (n10 > 0) {
                Callback callback;
                int n11;
                n7 = OS.HeapAlloc(n4, 8, OS.SCRIPT_STRING_ANALYSIS_sizeof());
                int n12 = OS.CreateEnhMetaFile(n2, null, null, null);
                n6 = OS.SelectObject(n12, n8);
                int n13 = 6304;
                if (OS.ScriptStringAnalyse(n12, object2, n10, 0, -1, n13, 0, null, null, 0, 0, 0, n7) == 0) {
                    OS.ScriptStringOut(n7, 0, 0, 0, null, 0, 0, false);
                    OS.ScriptStringFree(n7);
                }
                OS.HeapFree(n4, 0, n7);
                OS.SelectObject(n12, n6);
                n5 = OS.CloseEnhMetaFile(n12);
                EMREXTCREATEFONTINDIRECTW eMREXTCREATEFONTINDIRECTW = new EMREXTCREATEFONTINDIRECTW();
                TextLayout$1MetaFileEnumProc textLayout$1MetaFileEnumProc = new TextLayout$1MetaFileEnumProc(this, eMREXTCREATEFONTINDIRECTW);
                boolean bl3 = false;
                if (bl3) {
                    textLayout$1MetaFileEnumProc.metaFileEnumProc(0, 0, 0, 0, 0);
                }
                if ((n11 = (callback = new Callback(textLayout$1MetaFileEnumProc, "metaFileEnumProc", 5)).getAddress()) == 0) {
                    SWT.error(3);
                }
                OS.EnumEnhMetaFile(0, n5, n11, 0, null);
                OS.DeleteEnhMetaFile(n5);
                callback.dispose();
                n9 = OS.CreateFontIndirectW(eMREXTCREATEFONTINDIRECTW.elfw.elfLogFont);
            } else {
                for (n7 = 0; n7 < this.allRuns.length - 1; ++n7) {
                    LOGFONT lOGFONT;
                    TextLayout$StyleItem textLayout$StyleItem2;
                    if (this.allRuns[n7] != textLayout$StyleItem) continue;
                    if (n7 > 0) {
                        textLayout$StyleItem2 = this.allRuns[n7 - 1];
                        if (textLayout$StyleItem2.analysis.eScript == textLayout$StyleItem.analysis.eScript) {
                            n6 = this.getItemFont(textLayout$StyleItem2);
                            lOGFONT = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
                            OS.GetObject(n6, LOGFONT.sizeof, lOGFONT);
                            n9 = OS.CreateFontIndirect(lOGFONT);
                        }
                    }
                    if (n9 != 0 || n7 + 1 >= this.allRuns.length - 1) break;
                    textLayout$StyleItem2 = this.allRuns[n7 + 1];
                    if (textLayout$StyleItem2.analysis.eScript != textLayout$StyleItem.analysis.eScript) break;
                    OS.SelectObject(n2, this.getItemFont(textLayout$StyleItem2));
                    this.shape(n2, textLayout$StyleItem2);
                    n6 = this.getItemFont(textLayout$StyleItem2);
                    lOGFONT = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
                    OS.GetObject(n6, LOGFONT.sizeof, lOGFONT);
                    n9 = OS.CreateFontIndirect(lOGFONT);
                    break;
                }
            }
            if (n9 != 0) {
                OS.SelectObject(n2, n9);
                bl2 = this.shape(n2, textLayout$StyleItem, cArray, nArray, n3, sCRIPT_PROPERTIES);
                if (bl2) {
                    textLayout$StyleItem.fallbackFont = n9;
                }
            }
            if (!bl2 && !sCRIPT_PROPERTIES.fComplex) {
                textLayout$StyleItem.analysis.fNoGlyphIndex = true;
                bl2 = this.shape(n2, textLayout$StyleItem, cArray, nArray, n3, sCRIPT_PROPERTIES);
                if (bl2) {
                    textLayout$StyleItem.fallbackFont = n9;
                } else {
                    textLayout$StyleItem.analysis.fNoGlyphIndex = false;
                }
            }
            if (!bl2 && this.mLangFontLink2 != 0) {
                int[] nArray2 = new int[1];
                int[] nArray3 = new int[1];
                int[] nArray4 = new int[1];
                OS.VtblCall(4, this.mLangFontLink2, cArray, cArray.length, 0, nArray3, nArray4);
                if (OS.VtblCall(10, this.mLangFontLink2, n2, nArray3[0], (int)cArray[0], nArray2) == 0) {
                    LOGFONT lOGFONT = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
                    OS.GetObject(nArray2[0], LOGFONT.sizeof, lOGFONT);
                    OS.VtblCall(8, this.mLangFontLink2, nArray2[0]);
                    n5 = OS.CreateFontIndirect(lOGFONT);
                    int n14 = OS.SelectObject(n2, n5);
                    bl2 = this.shape(n2, textLayout$StyleItem, cArray, nArray, n3, sCRIPT_PROPERTIES);
                    if (bl2) {
                        textLayout$StyleItem.fallbackFont = n5;
                    } else {
                        OS.SelectObject(n2, n14);
                        OS.DeleteObject(n5);
                    }
                }
            }
            if (!bl2) {
                OS.SelectObject(n2, n8);
            }
            if (n9 != 0 && n9 != textLayout$StyleItem.fallbackFont) {
                OS.DeleteObject(n9);
            }
        }
        if (!bl2) {
            OS.ScriptShape(n2, textLayout$StyleItem.psc, cArray, cArray.length, n3, textLayout$StyleItem.analysis, textLayout$StyleItem.glyphs, textLayout$StyleItem.clusters, textLayout$StyleItem.visAttrs, nArray);
            textLayout$StyleItem.glyphCount = nArray[0];
        }
        int[] nArray5 = new int[3];
        textLayout$StyleItem.advances = OS.HeapAlloc(n4, 8, textLayout$StyleItem.glyphCount * 4);
        if (textLayout$StyleItem.advances == 0) {
            SWT.error(2);
        }
        textLayout$StyleItem.goffsets = OS.HeapAlloc(n4, 8, textLayout$StyleItem.glyphCount * 8);
        if (textLayout$StyleItem.goffsets == 0) {
            SWT.error(2);
        }
        OS.ScriptPlace(n2, textLayout$StyleItem.psc, textLayout$StyleItem.glyphs, textLayout$StyleItem.glyphCount, textLayout$StyleItem.visAttrs, textLayout$StyleItem.analysis, textLayout$StyleItem.advances, textLayout$StyleItem.goffsets, nArray5);
        textLayout$StyleItem.width = nArray5[0] + nArray5[1] + nArray5[2];
        TextStyle textStyle = textLayout$StyleItem.style;
        if (textStyle != null) {
            object2 = null;
            if ((textStyle.underline || textStyle.strikeout) && OS.GetOutlineTextMetrics(n2, OUTLINETEXTMETRIC.sizeof, (OUTLINETEXTMETRIC)(object2 = (Object)(OS.IsUnicode ? new OUTLINETEXTMETRICW() : new OUTLINETEXTMETRICA()))) == 0) {
                object2 = null;
            }
            if (textStyle.metrics != null) {
                object = textStyle.metrics;
                textLayout$StyleItem.width = ((GlyphMetrics)object).getWidthInPixels() * Math.max(1, textLayout$StyleItem.glyphCount);
                textLayout$StyleItem.ascentInPoints = ((GlyphMetrics)object).ascent;
                textLayout$StyleItem.descentInPoints = ((GlyphMetrics)object).descent;
                textLayout$StyleItem.leadingInPoints = 0;
            } else {
                object = null;
                if (object2 != null) {
                    object = OS.IsUnicode ? ((OUTLINETEXTMETRICW)object2).otmTextMetrics : ((OUTLINETEXTMETRICA)object2).otmTextMetrics;
                } else {
                    object = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
                    OS.GetTextMetrics(n2, (TEXTMETRIC)object);
                }
                textLayout$StyleItem.ascentInPoints = DPIUtil.autoScaleDown((Drawable)this.getDevice(), ((TEXTMETRIC)object).tmAscent);
                textLayout$StyleItem.descentInPoints = DPIUtil.autoScaleDown((Drawable)this.getDevice(), ((TEXTMETRIC)object).tmDescent);
                textLayout$StyleItem.leadingInPoints = DPIUtil.autoScaleDown((Drawable)this.getDevice(), ((TEXTMETRIC)object).tmInternalLeading);
            }
            if (object2 != null) {
                textLayout$StyleItem.underlinePos = object2.otmsUnderscorePosition;
                textLayout$StyleItem.underlineThickness = Math.max(1, object2.otmsUnderscoreSize);
                textLayout$StyleItem.strikeoutPos = object2.otmsStrikeoutPosition;
                textLayout$StyleItem.strikeoutThickness = Math.max(1, object2.otmsStrikeoutSize);
            } else {
                textLayout$StyleItem.underlinePos = 1;
                textLayout$StyleItem.underlineThickness = 1;
                textLayout$StyleItem.strikeoutPos = DPIUtil.autoScaleUp((Drawable)this.getDevice(), textLayout$StyleItem.ascentInPoints) / 2;
                textLayout$StyleItem.strikeoutThickness = 1;
            }
            textLayout$StyleItem.ascentInPoints += textStyle.rise;
            textLayout$StyleItem.descentInPoints -= textStyle.rise;
        } else {
            object2 = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
            OS.GetTextMetrics(n2, (TEXTMETRIC)object2);
            textLayout$StyleItem.ascentInPoints = DPIUtil.autoScaleDown((Drawable)this.getDevice(), object2.tmAscent);
            textLayout$StyleItem.descentInPoints = DPIUtil.autoScaleDown((Drawable)this.getDevice(), object2.tmDescent);
            textLayout$StyleItem.leadingInPoints = DPIUtil.autoScaleDown((Drawable)this.getDevice(), object2.tmInternalLeading);
        }
    }

    int validadeOffset(int n2, int n3) {
        n2 = this.untranslateOffset(n2);
        return this.translateOffset(n2 + n3);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "TextLayout {*DISPOSED*}";
        }
        return "TextLayout {}";
    }

    int translateOffset(int n2) {
        int n3 = this.text.length();
        if (n3 == 0) {
            return n2;
        }
        if (this.segments == null) {
            return n2;
        }
        int n4 = this.segments.length;
        if (n4 == 0) {
            return n2;
        }
        if (this.segmentsChars == null) {
            if (n4 == 1) {
                return n2;
            }
            if (n4 == 2 && this.segments[0] == 0 && this.segments[1] == n3) {
                return n2;
            }
        }
        for (int i2 = 0; i2 < n4 && n2 - i2 >= this.segments[i2]; ++i2) {
            ++n2;
        }
        return n2;
    }

    int untranslateOffset(int n2) {
        int n3 = this.text.length();
        if (n3 == 0) {
            return n2;
        }
        if (this.segments == null) {
            return n2;
        }
        int n4 = this.segments.length;
        if (n4 == 0) {
            return n2;
        }
        if (this.segmentsChars == null) {
            if (n4 == 1) {
                return n2;
            }
            if (n4 == 2 && this.segments[0] == 0 && this.segments[1] == n3) {
                return n2;
            }
        }
        for (int i2 = 0; i2 < n4 && n2 > this.segments[i2]; --n2, ++i2) {
        }
        return n2;
    }

    static {
        OS.IIDFromString("{275c23e2-3747-11d0-9fea-00aa003f8646}\u0000".toCharArray(), CLSID_CMultiLanguage);
        OS.IIDFromString("{DCCFC162-2B38-11d2-B7EC-00C04F8F5D9A}\u0000".toCharArray(), IID_IMLangFontLink2);
    }
}

