/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.ImageLoaderEvent;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.internal.image.FileFormat;
import org.eclipse.swt.internal.image.LEDataInputStream;
import org.eclipse.swt.internal.image.PngChunk;
import org.eclipse.swt.internal.image.PngChunkReader;
import org.eclipse.swt.internal.image.PngDecodingDataStream;
import org.eclipse.swt.internal.image.PngEncoder;
import org.eclipse.swt.internal.image.PngIdatChunk;
import org.eclipse.swt.internal.image.PngIhdrChunk;
import org.eclipse.swt.internal.image.PngInputStream;
import org.eclipse.swt.internal.image.PngPlteChunk;
import org.eclipse.swt.internal.image.PngTrnsChunk;

public final class PNGFileFormat
extends FileFormat {
    static final int SIGNATURE_LENGTH = 8;
    static final int PRIME = 65521;
    PngIhdrChunk headerChunk;
    PngPlteChunk paletteChunk;
    ImageData imageData;
    byte[] data;
    byte[] alphaPalette;
    byte headerByte1;
    byte headerByte2;
    int adler;

    void readSignature() {
        byte[] byArray = new byte[8];
        this.inputStream.read(byArray);
    }

    @Override
    ImageData[] loadFromByteStream() {
        try {
            this.readSignature();
            PngChunkReader pngChunkReader = new PngChunkReader(this.inputStream);
            this.headerChunk = pngChunkReader.getIhdrChunk();
            int n2 = this.headerChunk.getWidth();
            int n3 = this.headerChunk.getHeight();
            if (n2 <= 0 || n3 <= 0) {
                SWT.error(40);
            }
            int n4 = this.getAlignedBytesPerRow() * n3;
            this.data = new byte[n4];
            this.imageData = ImageData.internal_new(n2, n3, this.headerChunk.getSwtBitsPerPixel(), new PaletteData(0, 0, 0), 4, this.data, 0, null, null, -1, -1, 5, 0, 0, 0, 0);
            if (this.headerChunk.usesDirectColor()) {
                this.imageData.palette = this.headerChunk.getPaletteData();
            }
            while (pngChunkReader.hasMoreChunks()) {
                this.readNextChunk(pngChunkReader);
            }
            return new ImageData[]{this.imageData};
        }
        catch (IOException iOException) {
            SWT.error(40);
            return null;
        }
    }

    void readNextChunk(PngChunkReader pngChunkReader) {
        PngChunk pngChunk = pngChunkReader.readNextChunk();
        switch (pngChunk.getChunkType()) {
            case 3: {
                break;
            }
            case 1: {
                if (this.headerChunk.usesDirectColor()) break;
                this.paletteChunk = (PngPlteChunk)pngChunk;
                this.imageData.palette = this.paletteChunk.getPaletteData();
                break;
            }
            case 5: {
                PngTrnsChunk pngTrnsChunk = (PngTrnsChunk)pngChunk;
                if (pngTrnsChunk.getTransparencyType(this.headerChunk) == 0) {
                    this.imageData.transparentPixel = pngTrnsChunk.getSwtTransparentPixel(this.headerChunk);
                    break;
                }
                this.alphaPalette = pngTrnsChunk.getAlphaValues(this.headerChunk, this.paletteChunk);
                int n2 = 0;
                int n3 = -1;
                for (int i2 = 0; i2 < this.alphaPalette.length; ++i2) {
                    if ((this.alphaPalette[i2] & 0xFF) == 255) continue;
                    ++n2;
                    n3 = i2;
                }
                if (n2 == 0) {
                    this.alphaPalette = null;
                    break;
                }
                if (n2 != true || this.alphaPalette[n3] != 0) break;
                this.alphaPalette = null;
                this.imageData.transparentPixel = n3;
                break;
            }
            case 2: {
                if (pngChunkReader.readPixelData()) {
                    SWT.error(40);
                    break;
                }
                PngIdatChunk pngIdatChunk = (PngIdatChunk)pngChunk;
                this.readPixelData(pngIdatChunk, pngChunkReader);
                break;
            }
            default: {
                if (!pngChunk.isCritical()) break;
                SWT.error(20);
            }
        }
    }

    @Override
    void unloadIntoByteStream(ImageLoader imageLoader) {
        PngEncoder pngEncoder = new PngEncoder(imageLoader);
        pngEncoder.encode(this.outputStream);
    }

    @Override
    boolean isFileFormat(LEDataInputStream lEDataInputStream) {
        try {
            byte[] byArray = new byte[8];
            lEDataInputStream.read(byArray);
            lEDataInputStream.unread(byArray);
            if ((byArray[0] & 0xFF) != 137) {
                return false;
            }
            if ((byArray[1] & 0xFF) != 80) {
                return false;
            }
            if ((byArray[2] & 0xFF) != 78) {
                return false;
            }
            if ((byArray[3] & 0xFF) != 71) {
                return false;
            }
            if ((byArray[4] & 0xFF) != 13) {
                return false;
            }
            if ((byArray[5] & 0xFF) != 10) {
                return false;
            }
            if ((byArray[6] & 0xFF) != 26) {
                return false;
            }
            return (byArray[7] & 0xFF) == 10;
        }
        catch (Exception exception) {
            return false;
        }
    }

    byte[] validateBitDepth(byte[] byArray) {
        if (this.headerChunk.getBitDepth() > 8) {
            byte[] byArray2 = new byte[byArray.length / 2];
            PNGFileFormat.compress16BitDepthTo8BitDepth(byArray, 0, byArray2, 0, byArray2.length);
            return byArray2;
        }
        return byArray;
    }

    void setPixelData(byte[] byArray, ImageData imageData) {
        switch (this.headerChunk.getColorType()) {
            case 4: {
                int n2 = imageData.width;
                int n3 = imageData.height;
                int n4 = imageData.bytesPerLine;
                int n5 = this.getAlignedBytesPerRow();
                if (this.headerChunk.getBitDepth() > 8) {
                    n5 /= 2;
                }
                byte[] byArray2 = new byte[n4 * n3];
                byte[] byArray3 = new byte[n2 * n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n6 = n5 * i2;
                    int n7 = n4 * i2;
                    int n8 = n2 * i2;
                    for (int i3 = 0; i3 < n2; ++i3) {
                        byte by2 = byArray[n6];
                        byte by3 = byArray[n6 + 1];
                        byArray2[n7 + 0] = by2;
                        byArray2[n7 + 1] = by2;
                        byArray2[n7 + 2] = by2;
                        byArray3[n8] = by3;
                        n6 += 2;
                        n7 += 3;
                        ++n8;
                    }
                }
                imageData.data = byArray2;
                imageData.alphaData = byArray3;
                break;
            }
            case 6: {
                int n9 = imageData.width;
                int n10 = imageData.height;
                int n11 = imageData.bytesPerLine;
                int n12 = this.getAlignedBytesPerRow();
                if (this.headerChunk.getBitDepth() > 8) {
                    n12 /= 2;
                }
                byte[] byArray4 = new byte[n11 * n10];
                byte[] byArray5 = new byte[n9 * n10];
                for (int i4 = 0; i4 < n10; ++i4) {
                    int n13 = n12 * i4;
                    int n14 = n11 * i4;
                    int n15 = n9 * i4;
                    for (int i5 = 0; i5 < n9; ++i5) {
                        byArray4[n14 + 0] = byArray[n13 + 0];
                        byArray4[n14 + 1] = byArray[n13 + 1];
                        byArray4[n14 + 2] = byArray[n13 + 2];
                        byArray5[n15] = byArray[n13 + 3];
                        n13 += 4;
                        n14 += 3;
                        ++n15;
                    }
                }
                imageData.data = byArray4;
                imageData.alphaData = byArray5;
                break;
            }
            case 3: {
                imageData.data = byArray;
                if (this.alphaPalette == null) break;
                int n16 = imageData.width * imageData.height;
                byte[] byArray6 = new byte[n16];
                byte[] byArray7 = new byte[n16];
                imageData.getPixels(0, 0, n16, byArray7, 0);
                for (int i6 = 0; i6 < byArray7.length; ++i6) {
                    byArray6[i6] = this.alphaPalette[byArray7[i6] & 0xFF];
                }
                imageData.alphaData = byArray6;
                break;
            }
            default: {
                int n17 = imageData.height;
                int n18 = imageData.bytesPerLine;
                int n19 = this.getAlignedBytesPerRow();
                if (this.headerChunk.getBitDepth() > 8) {
                    n19 /= 2;
                }
                if (n18 != n19) {
                    for (int i7 = 0; i7 < n17; ++i7) {
                        System.arraycopy(byArray, i7 * n19, imageData.data, i7 * n18, n19);
                    }
                    break;
                }
                imageData.data = byArray;
            }
        }
    }

    void setImageDataValues(byte[] byArray, ImageData imageData) {
        byte[] byArray2 = this.validateBitDepth(byArray);
        this.setPixelData(byArray2, imageData);
    }

    void readPixelData(PngIdatChunk pngIdatChunk, PngChunkReader pngChunkReader) {
        InputStream inputStream = new PngInputStream(pngIdatChunk, pngChunkReader);
        boolean bl2 = System.getProperty("org.eclipse.swt.internal.image.PNGFileFormat_3.2") != null;
        BufferedInputStream bufferedInputStream = bl2 ? null : new BufferedInputStream(new InflaterInputStream(inputStream));
        inputStream = bufferedInputStream != null ? bufferedInputStream : new PngDecodingDataStream(inputStream);
        byte by2 = this.headerChunk.getInterlaceMethod();
        if (by2 == 0) {
            this.readNonInterlacedImage(inputStream);
        } else {
            this.readInterlacedImage(inputStream);
        }
        while (inputStream.available() > 0) {
            inputStream.read();
        }
        inputStream.close();
    }

    int getAlignedBytesPerRow() {
        return (this.getBytesPerRow(this.headerChunk.getWidth()) + 3) / 4 * 4;
    }

    int getBytesPerRow() {
        return this.getBytesPerRow(this.headerChunk.getWidth());
    }

    int getBytesPerPixel() {
        int n2 = this.headerChunk.getBitsPerPixel();
        return (n2 + 7) / 8;
    }

    int getBytesPerRow(int n2) {
        int n3 = this.headerChunk.getBitsPerPixel();
        int n4 = n3 * n2;
        int n5 = 8;
        return (n4 + (n5 - 1)) / n5;
    }

    void readInterlaceFrame(InputStream inputStream, int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.headerChunk.getWidth();
        int n8 = this.getAlignedBytesPerRow();
        int n9 = this.headerChunk.getHeight();
        if (n4 >= n9 || n5 >= n7) {
            return;
        }
        int n10 = (n7 - n5 + n3 - 1) / n3;
        int n11 = this.getBytesPerRow(n10);
        byte[] byArray = new byte[n11];
        byte[] byArray2 = new byte[n11];
        byte[] byArray3 = byArray;
        byte[] byArray4 = byArray2;
        for (int i2 = n4; i2 < n9; i2 += n2) {
            int n12;
            int n13;
            int n14;
            int n15;
            byte by2 = (byte)inputStream.read();
            for (int i3 = 0; i3 != n11; i3 += inputStream.read(byArray3, i3, n11 - i3)) {
            }
            this.filterRow(byArray3, byArray4, by2);
            if (this.headerChunk.getBitDepth() >= 8) {
                n15 = this.getBytesPerPixel();
                n14 = i2 * n8 + n5 * n15;
                for (n13 = 0; n13 < byArray3.length; n13 += n15) {
                    for (n12 = 0; n12 < n15; ++n12) {
                        this.data[n14 + n12] = byArray3[n13 + n12];
                    }
                    n14 += n3 * n15;
                }
            } else {
                int n16;
                n15 = this.headerChunk.getBitDepth();
                n14 = 8 / n15;
                n13 = n5;
                n12 = i2 * n8;
                int n17 = 0;
                for (n16 = 0; n16 < n15; ++n16) {
                    n17 <<= 1;
                    n17 |= 1;
                }
                n16 = 8 - n15;
                for (int i4 = 0; i4 < byArray3.length; ++i4) {
                    for (int i5 = n16; i5 >= 0; i5 -= n15) {
                        if (n13 < n7) {
                            int n18 = n12 + n13 * n15 / 8;
                            int n19 = byArray3[i4] >> i5 & n17;
                            int n20 = n16 - n15 * (n13 % n14);
                            int n21 = n18;
                            this.data[n21] = (byte)(this.data[n21] | n19 << n20);
                        }
                        n13 += n3;
                    }
                }
            }
            byArray3 = byArray3 == byArray ? byArray2 : byArray;
            byArray4 = byArray4 == byArray ? byArray2 : byArray;
        }
        this.setImageDataValues(this.data, this.imageData);
        this.fireInterlacedFrameEvent(n6);
    }

    void readInterlacedImage(InputStream inputStream) {
        this.readInterlaceFrame(inputStream, 8, 8, 0, 0, 0);
        this.readInterlaceFrame(inputStream, 8, 8, 0, 4, 1);
        this.readInterlaceFrame(inputStream, 8, 4, 4, 0, 2);
        this.readInterlaceFrame(inputStream, 4, 4, 0, 2, 3);
        this.readInterlaceFrame(inputStream, 4, 2, 2, 0, 4);
        this.readInterlaceFrame(inputStream, 2, 2, 0, 1, 5);
        this.readInterlaceFrame(inputStream, 2, 1, 1, 0, 6);
    }

    void fireInterlacedFrameEvent(int n2) {
        if (this.loader.hasListeners()) {
            ImageData imageData = (ImageData)this.imageData.clone();
            boolean bl2 = n2 == 6;
            this.loader.notifyListeners(new ImageLoaderEvent(this.loader, imageData, n2, bl2));
        }
    }

    void readNonInterlacedImage(InputStream inputStream) {
        int n2 = 0;
        int n3 = this.getAlignedBytesPerRow();
        int n4 = this.getBytesPerRow();
        byte[] byArray = new byte[n4];
        byte[] byArray2 = new byte[n4];
        byte[] byArray3 = byArray;
        byte[] byArray4 = byArray2;
        int n5 = this.headerChunk.getHeight();
        for (int i2 = 0; i2 < n5; ++i2) {
            byte by2 = (byte)inputStream.read();
            for (int i3 = 0; i3 != n4; i3 += inputStream.read(byArray3, i3, n4 - i3)) {
            }
            this.filterRow(byArray3, byArray4, by2);
            System.arraycopy(byArray3, 0, this.data, n2, n4);
            n2 += n3;
            byArray3 = byArray3 == byArray ? byArray2 : byArray;
            byArray4 = byArray4 == byArray ? byArray2 : byArray;
        }
        this.setImageDataValues(this.data, this.imageData);
    }

    static void compress16BitDepthTo8BitDepth(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            byte by2;
            int n5 = n2 + 2 * i2;
            int n6 = n3 + i2;
            byArray2[n6] = by2 = byArray[n5];
        }
    }

    static int compress16BitDepthTo8BitDepth(int n2) {
        return n2 >> 8;
    }

    void filterRow(byte[] byArray, byte[] byArray2, int n2) {
        int n3 = this.headerChunk.getFilterByteOffset();
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                for (int i2 = n3; i2 < byArray.length; ++i2) {
                    int n4 = byArray[i2] & 0xFF;
                    int n5 = byArray[i2 - n3] & 0xFF;
                    byArray[i2] = (byte)(n4 + n5 & 0xFF);
                }
                break;
            }
            case 2: {
                for (int i3 = 0; i3 < byArray.length; ++i3) {
                    int n6 = byArray[i3] & 0xFF;
                    int n7 = byArray2[i3] & 0xFF;
                    byArray[i3] = (byte)(n6 + n7 & 0xFF);
                }
                break;
            }
            case 3: {
                for (int i4 = 0; i4 < byArray.length; ++i4) {
                    int n8 = i4 < n3 ? 0 : byArray[i4 - n3] & 0xFF;
                    int n9 = byArray2[i4] & 0xFF;
                    int n10 = byArray[i4] & 0xFF;
                    byArray[i4] = (byte)(n10 + (n8 + n9) / 2 & 0xFF);
                }
                break;
            }
            case 4: {
                for (int i5 = 0; i5 < byArray.length; ++i5) {
                    int n11 = i5 < n3 ? 0 : byArray[i5 - n3] & 0xFF;
                    int n12 = i5 < n3 ? 0 : byArray2[i5 - n3] & 0xFF;
                    int n13 = byArray2[i5] & 0xFF;
                    int n14 = Math.abs(n13 - n12);
                    int n15 = Math.abs(n11 - n12);
                    int n16 = Math.abs(n11 - n12 + n13 - n12);
                    int n17 = 0;
                    n17 = n14 <= n15 && n14 <= n16 ? n11 : (n15 <= n16 ? n13 : n12);
                    int n18 = byArray[i5] & 0xFF;
                    byArray[i5] = (byte)(n18 + n17 & 0xFF);
                }
                break;
            }
        }
    }
}

