/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.INITCOMMONCONTROLSEX;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MARGINS;
import org.eclipse.swt.internal.win32.NMCUSTOMDRAW;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMREBARCHEVRON;
import org.eclipse.swt.internal.win32.NMREBARCHILDSIZE;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.REBARBANDINFO;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Event;

public class CoolBar
extends Composite {
    CoolItem[] items;
    CoolItem[] originalItems;
    boolean locked;
    boolean ignoreResize;
    static final int ReBarProc;
    static final TCHAR ReBarClass;
    static final int SEPARATOR_WIDTH = 2;
    static final int MAX_WIDTH = Short.MAX_VALUE;
    static final int DEFAULT_COOLBAR_WIDTH = 0;
    static final int DEFAULT_COOLBAR_HEIGHT = 0;

    public CoolBar(Composite composite, int n2) {
        super(composite, CoolBar.checkStyle(n2));
        if ((n2 & 0x200) != 0) {
            this.style |= 0x200;
            int n3 = OS.GetWindowLong(this.handle, -16);
            OS.SetWindowLong(this.handle, -16, n3 | 0x80);
        } else {
            this.style |= 0x100;
        }
    }

    @Override
    int callWindowProc(int n2, int n3, int n4, int n5) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.CallWindowProc(ReBarProc, n2, n3, n4, n5);
    }

    static int checkStyle(int n2) {
        return (n2 |= 0x80000) & 0xFFFFFCFF;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    Point computeSizeInPixels(int n2, int n3, boolean bl2) {
        int n4;
        int n5 = 0;
        int n6 = 0;
        int n7 = this.getBorderWidthInPixels();
        int n8 = n2 == -1 ? 16383 : n2 + n7 * 2;
        int n9 = n3 == -1 ? 16383 : n3 + n7 * 2;
        int n10 = OS.SendMessage(this.handle, 1036, 0, 0);
        if (n10 != 0) {
            this.ignoreResize = true;
            n4 = 0;
            if (OS.IsWindowVisible(this.handle)) {
                if (OS.COMCTL32_MAJOR >= 6) {
                    n4 = 1;
                    OS.UpdateWindow(this.handle);
                    OS.DefWindowProc(this.handle, 11, 0, 0);
                } else {
                    n4 = this.getDrawing() ? 1 : 0;
                    if (n4 != 0) {
                        OS.UpdateWindow(this.handle);
                        OS.SendMessage(this.handle, 11, 0, 0);
                    }
                }
            }
            RECT rECT = new RECT();
            OS.GetWindowRect(this.handle, rECT);
            int n11 = rECT.right - rECT.left;
            int n12 = rECT.bottom - rECT.top;
            int n13 = 30;
            this.SetWindowPos(this.handle, 0, 0, 0, n8, n9, n13);
            RECT rECT2 = new RECT();
            OS.SendMessage(this.handle, 1033, n10 - 1, rECT2);
            n6 = Math.max(n6, rECT2.bottom);
            this.SetWindowPos(this.handle, 0, 0, 0, n11, n12, n13);
            REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
            rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
            rEBARBANDINFO.fMask = 513;
            int n14 = 0;
            for (int i2 = 0; i2 < n10; ++i2) {
                OS.SendMessage(this.handle, OS.RB_GETBANDINFO, i2, rEBARBANDINFO);
                if ((rEBARBANDINFO.fStyle & 1) != 0) {
                    n5 = Math.max(n5, n14);
                    n14 = 0;
                }
                n14 += rEBARBANDINFO.cxIdeal + this.getMargin(i2);
            }
            n5 = Math.max(n5, n14);
            if (n4 != 0) {
                if (OS.COMCTL32_MAJOR >= 6) {
                    OS.DefWindowProc(this.handle, 11, 1, 0);
                } else {
                    OS.SendMessage(this.handle, 11, 1, 0);
                }
            }
            this.ignoreResize = false;
        }
        if (n5 == 0) {
            n5 = 0;
        }
        if (n6 == 0) {
            n6 = 0;
        }
        if ((this.style & 0x200) != 0) {
            n4 = n5;
            n5 = n6;
            n6 = n4;
        }
        if (n2 != -1) {
            n5 = n2;
        }
        if (n3 != -1) {
            n6 = n3;
        }
        return new Point(n5 += n7 * 2, n6 += n7 * 2);
    }

    @Override
    void createHandle() {
        super.createHandle();
        this.state &= 0xFFFFFEFD;
        int n2 = OS.GetStockObject(13);
        OS.SendMessage(this.handle, 48, n2, 0);
    }

    void createItem(CoolItem coolItem, int n2) {
        boolean bl2;
        int n3;
        int n4 = OS.SendMessage(this.handle, 1036, 0, 0);
        if (0 > n2 || n2 > n4) {
            this.error(6);
        }
        for (n3 = 0; n3 < this.items.length && this.items[n3] != null; ++n3) {
        }
        if (n3 == this.items.length) {
            CoolItem[] coolItemArray = new CoolItem[this.items.length + 4];
            System.arraycopy(this.items, 0, coolItemArray, 0, this.items.length);
            this.items = coolItemArray;
        }
        int n5 = OS.GetProcessHeap();
        int n6 = OS.HeapAlloc(n5, 8, TCHAR.sizeof);
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 261;
        rEBARBANDINFO.fStyle = 192;
        if ((coolItem.style & 4) != 0) {
            rEBARBANDINFO.fStyle |= 0x200;
        }
        rEBARBANDINFO.lpText = n6;
        rEBARBANDINFO.wID = n3;
        int n7 = this.getLastIndexOfRow(n2 - 1);
        boolean bl3 = bl2 = n2 == n7 + 1;
        if (bl2) {
            rEBARBANDINFO.fMask |= 0x40;
            rEBARBANDINFO.cx = Short.MAX_VALUE;
        }
        if (n2 == 0 && n4 > 0) {
            this.getItem(0).setWrap(false);
        }
        if (OS.SendMessage(this.handle, OS.RB_INSERTBAND, n2, rEBARBANDINFO) == 0) {
            this.error(14);
        }
        if (bl2) {
            this.resizeToPreferredWidth(n7);
        }
        OS.HeapFree(n5, 0, n6);
        coolItem.id = n3;
        this.items[coolItem.id] = coolItem;
        int n8 = this.originalItems.length;
        CoolItem[] coolItemArray = new CoolItem[n8 + 1];
        System.arraycopy(this.originalItems, 0, coolItemArray, 0, n2);
        System.arraycopy(this.originalItems, n2, coolItemArray, n2 + 1, n8 - n2);
        coolItemArray[n2] = coolItem;
        this.originalItems = coolItemArray;
    }

    @Override
    void createWidget() {
        super.createWidget();
        this.items = new CoolItem[4];
        this.originalItems = new CoolItem[0];
    }

    void destroyItem(CoolItem coolItem) {
        Control control;
        int n2;
        int n3 = OS.SendMessage(this.handle, 1040, coolItem.id, 0);
        int n4 = OS.SendMessage(this.handle, 1036, 0, 0);
        if (n4 != 0 && n3 == (n2 = this.getLastIndexOfRow(n3))) {
            this.resizeToMaximumWidth(n2 - 1);
        }
        boolean bl2 = (control = coolItem.control) != null && !control.isDisposed() && control.getVisible();
        CoolItem coolItem2 = null;
        if (coolItem.getWrap() && n3 + 1 < n4) {
            coolItem2 = this.getItem(n3 + 1);
            boolean bl3 = this.ignoreResize = !coolItem2.getWrap();
        }
        if (OS.SendMessage(this.handle, 1026, n3, 0) == 0) {
            this.error(15);
        }
        this.items[coolItem.id] = null;
        coolItem.id = -1;
        if (this.ignoreResize) {
            coolItem2.setWrap(true);
            this.ignoreResize = false;
        }
        if (bl2) {
            control.setVisible(true);
        }
        for (n3 = 0; n3 < this.originalItems.length && this.originalItems[n3] != coolItem; ++n3) {
        }
        int n5 = this.originalItems.length - 1;
        CoolItem[] coolItemArray = new CoolItem[n5];
        System.arraycopy(this.originalItems, 0, coolItemArray, 0, n3);
        System.arraycopy(this.originalItems, n3 + 1, coolItemArray, n3, n5 - n3);
        this.originalItems = coolItemArray;
    }

    @Override
    void drawThemeBackground(int n2, int n3, RECT rECT) {
        Object object;
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && this.background == -1 && (this.style & 0x800000) != 0 && (object = this.findBackgroundControl()) != null && ((Control)object).backgroundImage != null) {
            this.fillBackground(n2, ((Control)object).getBackgroundPixel(), rECT);
            return;
        }
        object = new RECT();
        OS.GetClientRect(this.handle, (RECT)object);
        OS.MapWindowPoints(this.handle, n3, (RECT)object, 2);
        POINT pOINT = new POINT();
        OS.SetWindowOrgEx(n2, -((RECT)object).left, -((RECT)object).top, pOINT);
        OS.SendMessage(this.handle, 791, n2, 12);
        OS.SetWindowOrgEx(n2, pOINT.x, pOINT.y, null);
    }

    @Override
    Control findThemeControl() {
        if ((this.style & 0x800000) != 0) {
            return this;
        }
        return this.background == -1 && this.backgroundImage == null ? this : super.findThemeControl();
    }

    int getMargin(int n2) {
        Object object;
        int n3 = 0;
        if (OS.COMCTL32_MAJOR >= 6) {
            object = new MARGINS();
            OS.SendMessage(this.handle, 1064, 0, (MARGINS)object);
            n3 += ((MARGINS)object).cxLeftWidth + ((MARGINS)object).cxRightWidth;
        }
        object = new RECT();
        OS.SendMessage(this.handle, 1058, n2, (RECT)object);
        n3 = (this.style & 0x800000) != 0 ? ((this.style & 0x200) != 0 ? (n3 += ((RECT)object).top + 4) : (n3 += ((RECT)object).left + 4)) : ((this.style & 0x200) != 0 ? (n3 += ((RECT)object).top + ((RECT)object).bottom) : (n3 += ((RECT)object).left + ((RECT)object).right));
        if ((this.style & 0x800000) == 0 && !this.isLastItemOfRow(n2)) {
            n3 += 2;
        }
        return n3;
    }

    public CoolItem getItem(int n2) {
        this.checkWidget();
        int n3 = OS.SendMessage(this.handle, 1036, 0, 0);
        if (0 > n2 || n2 >= n3) {
            this.error(6);
        }
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 256;
        OS.SendMessage(this.handle, OS.RB_GETBANDINFO, n2, rEBARBANDINFO);
        return this.items[rEBARBANDINFO.wID];
    }

    public int getItemCount() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 1036, 0, 0);
    }

    public int[] getItemOrder() {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 1036, 0, 0);
        int[] nArray = new int[n2];
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 256;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            OS.SendMessage(this.handle, OS.RB_GETBANDINFO, i2, rEBARBANDINFO);
            CoolItem coolItem = this.items[rEBARBANDINFO.wID];
            for (n3 = 0; n3 < this.originalItems.length && this.originalItems[n3] != coolItem; ++n3) {
            }
            if (n3 == this.originalItems.length) {
                this.error(8);
            }
            nArray[i2] = n3;
        }
        return nArray;
    }

    public CoolItem[] getItems() {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 1036, 0, 0);
        CoolItem[] coolItemArray = new CoolItem[n2];
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 256;
        for (int i2 = 0; i2 < n2; ++i2) {
            OS.SendMessage(this.handle, OS.RB_GETBANDINFO, i2, rEBARBANDINFO);
            coolItemArray[i2] = this.items[rEBARBANDINFO.wID];
        }
        return coolItemArray;
    }

    public Point[] getItemSizes() {
        this.checkWidget();
        Point[] pointArray = this.getItemSizesInPixels();
        if (pointArray != null) {
            for (int i2 = 0; i2 < pointArray.length; ++i2) {
                pointArray[i2] = DPIUtil.autoScaleDown(pointArray[i2]);
            }
        }
        return pointArray;
    }

    Point[] getItemSizesInPixels() {
        int n2 = OS.SendMessage(this.handle, 1036, 0, 0);
        Point[] pointArray = new Point[n2];
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 32;
        int n3 = (this.style & 0x800000) == 0 ? 2 : 0;
        MARGINS mARGINS = new MARGINS();
        for (int i2 = 0; i2 < n2; ++i2) {
            RECT rECT = new RECT();
            OS.SendMessage(this.handle, 1033, i2, rECT);
            OS.SendMessage(this.handle, OS.RB_GETBANDINFO, i2, rEBARBANDINFO);
            if (OS.COMCTL32_MAJOR >= 6) {
                OS.SendMessage(this.handle, 1064, 0, mARGINS);
                rECT.left -= mARGINS.cxLeftWidth;
                rECT.right += mARGINS.cxRightWidth;
            }
            if (!this.isLastItemOfRow(i2)) {
                rECT.right += n3;
            }
            pointArray[i2] = (this.style & 0x200) != 0 ? new Point(rEBARBANDINFO.cyChild, rECT.right - rECT.left) : new Point(rECT.right - rECT.left, rEBARBANDINFO.cyChild);
        }
        return pointArray;
    }

    int getLastIndexOfRow(int n2) {
        int n3 = OS.SendMessage(this.handle, 1036, 0, 0);
        if (n3 == 0) {
            return -1;
        }
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 1;
        for (int i2 = n2 + 1; i2 < n3; ++i2) {
            OS.SendMessage(this.handle, OS.RB_GETBANDINFO, i2, rEBARBANDINFO);
            if ((rEBARBANDINFO.fStyle & 1) == 0) continue;
            return i2 - 1;
        }
        return n3 - 1;
    }

    boolean isLastItemOfRow(int n2) {
        int n3 = OS.SendMessage(this.handle, 1036, 0, 0);
        if (n2 + 1 == n3) {
            return true;
        }
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 1;
        OS.SendMessage(this.handle, OS.RB_GETBANDINFO, n2 + 1, rEBARBANDINFO);
        return (rEBARBANDINFO.fStyle & 1) != 0;
    }

    public boolean getLocked() {
        this.checkWidget();
        return this.locked;
    }

    public int[] getWrapIndices() {
        this.checkWidget();
        CoolItem[] coolItemArray = this.getItems();
        int[] nArray = new int[coolItemArray.length];
        int n2 = 0;
        for (int i2 = 0; i2 < coolItemArray.length; ++i2) {
            if (!coolItemArray[i2].getWrap()) continue;
            nArray[n2++] = i2;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    public int indexOf(CoolItem coolItem) {
        this.checkWidget();
        if (coolItem == null) {
            this.error(4);
        }
        if (coolItem.isDisposed()) {
            this.error(5);
        }
        return OS.SendMessage(this.handle, 1040, coolItem.id, 0);
    }

    void resizeToPreferredWidth(int n2) {
        int n3 = OS.SendMessage(this.handle, 1036, 0, 0);
        if (0 <= n2 && n2 < n3) {
            REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
            rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
            rEBARBANDINFO.fMask = 512;
            OS.SendMessage(this.handle, OS.RB_GETBANDINFO, n2, rEBARBANDINFO);
            RECT rECT = new RECT();
            OS.SendMessage(this.handle, 1058, n2, rECT);
            rEBARBANDINFO.cx = rEBARBANDINFO.cxIdeal + rECT.left;
            if ((this.style & 0x800000) == 0) {
                rEBARBANDINFO.cx += rECT.right;
            }
            rEBARBANDINFO.fMask = 64;
            OS.SendMessage(this.handle, OS.RB_SETBANDINFO, n2, rEBARBANDINFO);
        }
    }

    void resizeToMaximumWidth(int n2) {
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 64;
        rEBARBANDINFO.cx = Short.MAX_VALUE;
        OS.SendMessage(this.handle, OS.RB_SETBANDINFO, n2, rEBARBANDINFO);
    }

    @Override
    void releaseChildren(boolean bl2) {
        if (this.items != null) {
            for (int i2 = 0; i2 < this.items.length; ++i2) {
                CoolItem coolItem = this.items[i2];
                if (coolItem == null || coolItem.isDisposed()) continue;
                coolItem.release(false);
            }
            this.items = null;
        }
        super.releaseChildren(bl2);
    }

    @Override
    void removeControl(Control control) {
        super.removeControl(control);
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            CoolItem coolItem = this.items[i2];
            if (coolItem == null || coolItem.control != control) continue;
            coolItem.setControl(null);
        }
    }

    @Override
    void reskinChildren(int n2) {
        if (this.items != null) {
            for (int i2 = 0; i2 < this.items.length; ++i2) {
                CoolItem coolItem = this.items[i2];
                if (coolItem == null) continue;
                coolItem.reskin(n2);
            }
        }
        super.reskinChildren(n2);
    }

    @Override
    void setBackgroundPixel(int n2) {
        if (n2 == -1) {
            n2 = this.defaultBackground();
        }
        OS.SendMessage(this.handle, 1043, 0, n2);
        this.setItemColors(OS.SendMessage(this.handle, 1046, 0, 0), n2);
        if (!OS.IsWindowVisible(this.handle)) {
            return;
        }
        if (OS.IsWinCE) {
            OS.InvalidateRect(this.handle, null, true);
        } else {
            int n3 = 1157;
            OS.RedrawWindow(this.handle, null, 0, n3);
        }
    }

    @Override
    void setForegroundPixel(int n2) {
        if (n2 == -1) {
            n2 = this.defaultForeground();
        }
        OS.SendMessage(this.handle, 1045, 0, n2);
        this.setItemColors(n2, OS.SendMessage(this.handle, 1044, 0, 0));
    }

    void setItemColors(int n2, int n3) {
        int n4 = OS.SendMessage(this.handle, 1036, 0, 0);
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 2;
        rEBARBANDINFO.clrFore = n2;
        rEBARBANDINFO.clrBack = n3;
        for (int i2 = 0; i2 < n4; ++i2) {
            OS.SendMessage(this.handle, OS.RB_SETBANDINFO, i2, rEBARBANDINFO);
        }
    }

    public void setItemLayout(int[] nArray, int[] nArray2, Point[] pointArray) {
        this.checkWidget();
        if (pointArray == null) {
            this.error(4);
        }
        Point[] pointArray2 = new Point[pointArray.length];
        for (int i2 = 0; i2 < pointArray.length; ++i2) {
            pointArray2[i2] = DPIUtil.autoScaleUp(pointArray[i2]);
        }
        this.setItemLayoutInPixels(nArray, nArray2, pointArray2);
    }

    void setItemLayoutInPixels(int[] nArray, int[] nArray2, Point[] pointArray) {
        this.setRedraw(false);
        this.setItemOrder(nArray);
        this.setWrapIndices(nArray2);
        this.setItemSizes(pointArray);
        this.setRedraw(true);
    }

    void setItemOrder(int[] nArray) {
        int n2;
        int n3;
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length != (n3 = OS.SendMessage(this.handle, 1036, 0, 0))) {
            this.error(5);
        }
        boolean[] blArray = new boolean[n3];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            n2 = nArray[i2];
            if (n2 < 0 || n2 >= n3) {
                this.error(6);
            }
            if (blArray[n2]) {
                this.error(5);
            }
            blArray[n2] = true;
        }
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            int n4 = this.originalItems[nArray[n2]].id;
            int n5 = OS.SendMessage(this.handle, 1040, n4, 0);
            if (n5 == n2) continue;
            int n6 = this.getLastIndexOfRow(n5);
            int n7 = this.getLastIndexOfRow(n2);
            if (n5 == n6) {
                this.resizeToPreferredWidth(n5);
            }
            if (n2 == n7) {
                this.resizeToPreferredWidth(n2);
            }
            OS.SendMessage(this.handle, 1063, n5, n2);
            if (n5 == n6 && n5 - 1 >= 0) {
                this.resizeToMaximumWidth(n5 - 1);
            }
            if (n2 != n7) continue;
            this.resizeToMaximumWidth(n2);
        }
    }

    void setItemSizes(Point[] pointArray) {
        int n2;
        if (pointArray == null) {
            this.error(4);
        }
        if (pointArray.length != (n2 = OS.SendMessage(this.handle, 1036, 0, 0))) {
            this.error(5);
        }
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 256;
        for (int i2 = 0; i2 < n2; ++i2) {
            OS.SendMessage(this.handle, OS.RB_GETBANDINFO, i2, rEBARBANDINFO);
            this.items[rEBARBANDINFO.wID].setSizeInPixels(pointArray[i2].x, pointArray[i2].y);
        }
    }

    public void setLocked(boolean bl2) {
        this.checkWidget();
        this.locked = bl2;
        int n2 = OS.SendMessage(this.handle, 1036, 0, 0);
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            OS.SendMessage(this.handle, OS.RB_GETBANDINFO, i2, rEBARBANDINFO);
            rEBARBANDINFO.fStyle = bl2 ? (rEBARBANDINFO.fStyle |= 0x100) : (rEBARBANDINFO.fStyle &= 0xFFFFFEFF);
            OS.SendMessage(this.handle, OS.RB_SETBANDINFO, i2, rEBARBANDINFO);
        }
    }

    public void setWrapIndices(int[] nArray) {
        int n2;
        this.checkWidget();
        if (nArray == null) {
            nArray = new int[]{};
        }
        int n3 = this.getItemCount();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] >= 0 && nArray[i2] < n3) continue;
            this.error(6);
        }
        this.setRedraw(false);
        CoolItem[] coolItemArray = this.getItems();
        for (n2 = 0; n2 < coolItemArray.length; ++n2) {
            CoolItem coolItem = coolItemArray[n2];
            if (!coolItem.getWrap()) continue;
            this.resizeToPreferredWidth(n2 - 1);
            coolItem.setWrap(false);
        }
        this.resizeToMaximumWidth(n3 - 1);
        for (n2 = 0; n2 < nArray.length; ++n2) {
            int n4 = nArray[n2];
            if (0 > n4 || n4 >= coolItemArray.length) continue;
            CoolItem coolItem = coolItemArray[n4];
            coolItem.setWrap(true);
            this.resizeToMaximumWidth(n4 - 1);
        }
        this.setRedraw(true);
    }

    @Override
    int widgetStyle() {
        int n2 = super.widgetStyle() | 0x40 | 4;
        n2 |= 0x8200;
        if ((this.style & 0x800000) == 0) {
            n2 |= 0x400;
        }
        return n2;
    }

    @Override
    TCHAR windowClass() {
        return ReBarClass;
    }

    @Override
    int windowProc() {
        return ReBarProc;
    }

    @Override
    LRESULT WM_COMMAND(int n2, int n3) {
        LRESULT lRESULT = super.WM_COMMAND(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        return LRESULT.ZERO;
    }

    @Override
    LRESULT WM_ERASEBKGND(int n2, int n3) {
        LRESULT lRESULT = super.WM_ERASEBKGND(n2, n3);
        if (OS.COMCTL32_MAJOR < 6 || !OS.IsAppThemed()) {
            this.drawBackground(n2);
            return null;
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_NOTIFY(int n2, int n3) {
        LRESULT lRESULT = super.WM_NOTIFY(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        return LRESULT.ZERO;
    }

    @Override
    LRESULT WM_SETREDRAW(int n2, int n3) {
        LRESULT lRESULT = super.WM_SETREDRAW(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.COMCTL32_MAJOR >= 6) {
            return LRESULT.ZERO;
        }
        Rectangle rectangle = this.getBoundsInPixels();
        int n4 = this.callWindowProc(this.handle, 11, n2, n3);
        OS.DefWindowProc(this.handle, 11, n2, n3);
        if (!rectangle.equals(this.getBoundsInPixels())) {
            this.parent.redrawInPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        }
        return new LRESULT(n4);
    }

    @Override
    LRESULT WM_SIZE(int n2, int n3) {
        if (this.ignoreResize) {
            int n4 = this.callWindowProc(this.handle, 5, n2, n3);
            if (n4 == 0) {
                return LRESULT.ZERO;
            }
            return new LRESULT(n4);
        }
        return super.WM_SIZE(n2, n3);
    }

    @Override
    LRESULT wmNotifyChild(NMHDR nMHDR, int n2, int n3) {
        switch (nMHDR.code) {
            case -835: {
                int n4;
                int n5 = OS.GetMessagePos();
                POINT pOINT = new POINT();
                OS.POINTSTOPOINT(pOINT, n5);
                OS.ScreenToClient(this.handle, pOINT);
                int n6 = n4 = this.display.lastButton != 0 ? this.display.lastButton : 1;
                if (this.sendDragEvent(n4, pOINT.x, pOINT.y)) break;
                return LRESULT.ONE;
            }
            case -839: {
                NMREBARCHILDSIZE nMREBARCHILDSIZE = new NMREBARCHILDSIZE();
                OS.MoveMemory(nMREBARCHILDSIZE, n3, NMREBARCHILDSIZE.sizeof);
                if (nMREBARCHILDSIZE.uBand == -1) break;
                CoolItem coolItem = this.items[nMREBARCHILDSIZE.wID];
                Control control = coolItem.control;
                if (control == null) break;
                int n7 = nMREBARCHILDSIZE.rcChild_right - nMREBARCHILDSIZE.rcChild_left;
                int n8 = nMREBARCHILDSIZE.rcChild_bottom - nMREBARCHILDSIZE.rcChild_top;
                control.setBoundsInPixels(nMREBARCHILDSIZE.rcChild_left, nMREBARCHILDSIZE.rcChild_top, n7, n8);
                break;
            }
            case -831: {
                if (this.ignoreResize) break;
                Point point = this.getSizeInPixels();
                int n9 = this.getBorderWidthInPixels();
                int n10 = OS.SendMessage(this.handle, 1051, 0, 0);
                if ((this.style & 0x200) != 0) {
                    this.setSizeInPixels(n10 + 2 * n9, point.y);
                    break;
                }
                this.setSizeInPixels(point.x, n10 + 2 * n9);
                break;
            }
            case -841: {
                NMREBARCHEVRON nMREBARCHEVRON = new NMREBARCHEVRON();
                OS.MoveMemory(nMREBARCHEVRON, n3, NMREBARCHEVRON.sizeof);
                CoolItem coolItem = this.items[nMREBARCHEVRON.wID];
                if (coolItem == null) break;
                Event event = new Event();
                event.detail = 4;
                if ((this.style & 0x200) != 0) {
                    event.setLocationInPixels(nMREBARCHEVRON.right, nMREBARCHEVRON.top);
                } else {
                    event.setLocationInPixels(nMREBARCHEVRON.left, nMREBARCHEVRON.bottom);
                }
                coolItem.sendSelectionEvent(13, event, false);
                break;
            }
            case -12: {
                if (OS.COMCTL32_MAJOR < 6 || this.findBackgroundControl() == null && (this.style & 0x800000) == 0) break;
                NMCUSTOMDRAW nMCUSTOMDRAW = new NMCUSTOMDRAW();
                OS.MoveMemory(nMCUSTOMDRAW, n3, NMCUSTOMDRAW.sizeof);
                switch (nMCUSTOMDRAW.dwDrawStage) {
                    case 3: {
                        return new LRESULT(68);
                    }
                    case 4: {
                        this.drawBackground(nMCUSTOMDRAW.hdc);
                    }
                }
            }
        }
        return super.wmNotifyChild(nMHDR, n2, n3);
    }

    static {
        ReBarClass = new TCHAR(0, "ReBarWindow32", true);
        INITCOMMONCONTROLSEX iNITCOMMONCONTROLSEX = new INITCOMMONCONTROLSEX();
        iNITCOMMONCONTROLSEX.dwSize = INITCOMMONCONTROLSEX.sizeof;
        iNITCOMMONCONTROLSEX.dwICC = 1024;
        OS.InitCommonControlsEx(iNITCOMMONCONTROLSEX);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, ReBarClass, wNDCLASS);
        ReBarProc = wNDCLASS.lpfnWndProc;
    }
}

