/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.io.Serializable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.ACCEL;
import org.eclipse.swt.internal.win32.CREATESTRUCT;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MENUITEMINFO;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.STARTUPINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WINDOWPLACEMENT;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class Decorations
extends Canvas {
    Image image;
    Image smallImage;
    Image largeImage;
    Image[] images;
    Menu menuBar;
    Menu[] menus;
    Control savedFocus;
    Button defaultButton;
    Button saveDefault;
    int swFlags;
    int nAccel;
    int hAccel;
    boolean moved;
    boolean resized;
    boolean opened;
    int oldX = Integer.MIN_VALUE;
    int oldY = Integer.MIN_VALUE;
    int oldWidth = Integer.MIN_VALUE;
    int oldHeight = Integer.MIN_VALUE;
    RECT maxRect = new RECT();

    Decorations() {
    }

    public Decorations(Composite composite, int n2) {
        super(composite, Decorations.checkStyle(n2));
    }

    void _setMaximized(boolean bl2) {
        int n2 = this.swFlags = bl2 ? OS.SW_SHOWMAXIMIZED : OS.SW_RESTORE;
        if (OS.IsWinCE) {
            if (bl2) {
                int n3;
                RECT rECT = new RECT();
                OS.SystemParametersInfo(48, 0, rECT, 0);
                int n4 = rECT.right - rECT.left;
                int n5 = rECT.bottom - rECT.top;
                if (OS.IsPPC && this.menuBar != null) {
                    n3 = this.menuBar.hwndCB;
                    RECT rECT2 = new RECT();
                    OS.GetWindowRect(n3, rECT2);
                    n5 -= rECT2.bottom - rECT2.top;
                }
                n3 = 52;
                this.SetWindowPos(this.handle, 0, rECT.left, rECT.top, n4, n5, n3);
            }
        } else {
            if (!OS.IsWindowVisible(this.handle)) {
                return;
            }
            if (bl2 == OS.IsZoomed(this.handle)) {
                return;
            }
            OS.ShowWindow(this.handle, this.swFlags);
            OS.UpdateWindow(this.handle);
        }
    }

    void _setMinimized(boolean bl2) {
        if (OS.IsWinCE) {
            return;
        }
        int n2 = this.swFlags = bl2 ? 7 : OS.SW_RESTORE;
        if (!OS.IsWindowVisible(this.handle)) {
            return;
        }
        if (bl2 == OS.IsIconic(this.handle)) {
            return;
        }
        int n3 = this.swFlags;
        if (n3 == 7 && this.handle == OS.GetActiveWindow()) {
            n3 = 6;
        }
        OS.ShowWindow(this.handle, n3);
        OS.UpdateWindow(this.handle);
    }

    void addMenu(Menu menu) {
        if (this.menus == null) {
            this.menus = new Menu[4];
        }
        for (int i2 = 0; i2 < this.menus.length; ++i2) {
            if (this.menus[i2] != null) continue;
            this.menus[i2] = menu;
            return;
        }
        Menu[] menuArray = new Menu[this.menus.length + 4];
        menuArray[this.menus.length] = menu;
        System.arraycopy(this.menus, 0, menuArray, 0, this.menus.length);
        this.menus = menuArray;
    }

    void bringToTop() {
        OS.BringWindowToTop(this.handle);
    }

    static int checkStyle(int n2) {
        if ((n2 & 8) != 0) {
            n2 &= 0xFFFFF30F;
        } else if ((n2 & 0x800000) != 0) {
            n2 |= 0x20;
        }
        if (OS.IsWinCE) {
            if ((n2 & 0x80) != 0) {
                n2 &= 0xFFFFFF7F;
            }
            if ((n2 & 0x400) != 0) {
                n2 &= 0xFFFFFBFF;
            }
            return n2;
        }
        if ((n2 & 0x4C0) != 0) {
            n2 |= 0x20;
        }
        if ((n2 & 0x480) != 0) {
            n2 |= 0x40;
        }
        if ((n2 & 0x40) != 0) {
            n2 |= 0x20;
        }
        return n2;
    }

    @Override
    void checkBorder() {
    }

    void checkComposited(Composite composite) {
    }

    @Override
    void checkOpened() {
        if (!this.opened) {
            this.resized = false;
        }
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    int callWindowProc(int n2, int n3, int n4, int n5) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.DefMDIChildProc(n2, n3, n4, n5);
    }

    void closeWidget() {
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit && !this.isDisposed()) {
            this.dispose();
        }
    }

    int compare(ImageData imageData, ImageData imageData2, int n2, int n3, int n4) {
        int n5;
        int n6 = Math.abs(imageData.width - n2);
        if (n6 == (n5 = Math.abs(imageData2.width - n2))) {
            int n7;
            int n8 = imageData.getTransparencyType();
            if (n8 == (n7 = imageData2.getTransparencyType())) {
                if (imageData.depth == imageData2.depth) {
                    return 0;
                }
                return imageData.depth > imageData2.depth && imageData.depth <= n4 ? -1 : 1;
            }
            if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(5, 1)) {
                if (n8 == 1) {
                    return -1;
                }
                if (n7 == 1) {
                    return 1;
                }
            }
            if (n8 == 2) {
                return -1;
            }
            if (n7 == 2) {
                return 1;
            }
            if (n8 == 4) {
                return -1;
            }
            if (n7 == 4) {
                return 1;
            }
            return 0;
        }
        return n6 < n5 ? -1 : 1;
    }

    @Override
    Widget computeTabGroup() {
        return this;
    }

    @Override
    Control computeTabRoot() {
        return this;
    }

    @Override
    Rectangle computeTrimInPixels(int n2, int n3, int n4, int n5) {
        this.checkWidget();
        RECT rECT = new RECT();
        OS.SetRect(rECT, n2, n3, n2 + n4, n3 + n5);
        int n6 = OS.GetWindowLong(this.handle, -16);
        int n7 = OS.GetWindowLong(this.handle, -20);
        boolean bl2 = OS.IsWinCE ? false : OS.GetMenu(this.handle) != 0;
        OS.AdjustWindowRectEx(rECT, n6, bl2, n7);
        if (this.horizontalBar != null) {
            rECT.bottom += OS.GetSystemMetrics(3);
        }
        if (this.verticalBar != null) {
            rECT.right += OS.GetSystemMetrics(2);
        }
        if (bl2) {
            RECT rECT2 = new RECT();
            OS.SetRect(rECT2, 0, 0, rECT.right - rECT.left, rECT.bottom - rECT.top);
            OS.SendMessage(this.handle, 131, 0, rECT2);
            while (rECT2.bottom - rECT2.top < n5 && rECT2.bottom - rECT2.top != 0) {
                rECT.top -= OS.GetSystemMetrics(15) - OS.GetSystemMetrics(6);
                OS.SetRect(rECT2, 0, 0, rECT.right - rECT.left, rECT.bottom - rECT.top);
                OS.SendMessage(this.handle, 131, 0, rECT2);
            }
        }
        return new Rectangle(rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top);
    }

    void createAccelerators() {
        this.nAccel = 0;
        this.hAccel = 0;
        int n2 = 0;
        MenuItem[] menuItemArray = this.display.items;
        if (this.menuBar == null || menuItemArray == null) {
            if (!OS.IsPPC) {
                return;
            }
            n2 = 1;
        } else {
            n2 = OS.IsPPC ? menuItemArray.length + 1 : menuItemArray.length;
        }
        ACCEL aCCEL = new ACCEL();
        byte[] byArray = new byte[ACCEL.sizeof];
        byte[] byArray2 = new byte[n2 * ACCEL.sizeof];
        if (this.menuBar != null && menuItemArray != null) {
            for (int i2 = 0; i2 < menuItemArray.length; ++i2) {
                Menu menu;
                MenuItem menuItem = menuItemArray[i2];
                if (menuItem == null || menuItem.accelerator == 0) continue;
                if (menu.parent != this) continue;
                for (menu = menuItem.parent; menu != null && menu != this.menuBar; menu = menu.getParentMenu()) {
                }
                if (menu != this.menuBar || !menuItem.fillAccel(aCCEL)) continue;
                OS.MoveMemory(byArray, aCCEL, ACCEL.sizeof);
                System.arraycopy(byArray, 0, byArray2, this.nAccel * ACCEL.sizeof, ACCEL.sizeof);
                ++this.nAccel;
            }
        }
        if (OS.IsPPC) {
            aCCEL.fVirt = (byte)9;
            aCCEL.key = (short)81;
            aCCEL.cmd = 1;
            OS.MoveMemory(byArray, aCCEL, ACCEL.sizeof);
            System.arraycopy(byArray, 0, byArray2, this.nAccel * ACCEL.sizeof, ACCEL.sizeof);
            ++this.nAccel;
        }
        if (this.nAccel != 0) {
            this.hAccel = OS.CreateAcceleratorTable(byArray2, this.nAccel);
        }
    }

    @Override
    void createHandle() {
        super.createHandle();
        if (this.parent != null || (this.style & 4) != 0) {
            this.setParent();
            this.setSystemMenu();
        }
    }

    @Override
    void createWidget() {
        super.createWidget();
        this.swFlags = OS.IsWinCE ? OS.SW_SHOWMAXIMIZED : 4;
        this.hAccel = -1;
    }

    void destroyAccelerators() {
        if (this.hAccel != 0 && this.hAccel != -1) {
            OS.DestroyAcceleratorTable(this.hAccel);
        }
        this.hAccel = -1;
    }

    @Override
    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.isValidThread()) {
            this.error(22);
        }
        if (!(this instanceof Shell)) {
            if (!this.traverseDecorations(true)) {
                Shell shell = this.getShell();
                shell.setFocus();
            }
            this.setVisible(false);
        }
        super.dispose();
    }

    Menu findMenu(int n2) {
        if (this.menus == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.menus.length; ++i2) {
            Menu menu = this.menus[i2];
            if (menu == null || n2 != menu.handle) continue;
            return menu;
        }
        return null;
    }

    void fixDecorations(Decorations decorations, Control control, Menu[] menuArray) {
        if (this == decorations) {
            return;
        }
        if (control == this.savedFocus) {
            this.savedFocus = null;
        }
        if (control == this.defaultButton) {
            this.defaultButton = null;
        }
        if (control == this.saveDefault) {
            this.saveDefault = null;
        }
        if (menuArray == null) {
            return;
        }
        Menu menu = control.menu;
        if (menu != null) {
            for (int i2 = 0; i2 < menuArray.length; ++i2) {
                if (menuArray[i2] != menu) continue;
                control.setMenu(null);
                return;
            }
            menu.fixMenus(decorations);
            this.destroyAccelerators();
            decorations.destroyAccelerators();
        }
    }

    @Override
    Rectangle getBoundsInPixels() {
        this.checkWidget();
        if (!OS.IsWinCE && OS.IsIconic(this.handle)) {
            WINDOWPLACEMENT wINDOWPLACEMENT = new WINDOWPLACEMENT();
            wINDOWPLACEMENT.length = WINDOWPLACEMENT.sizeof;
            OS.GetWindowPlacement(this.handle, wINDOWPLACEMENT);
            if ((wINDOWPLACEMENT.flags & 2) != 0) {
                int n2 = this.maxRect.right - this.maxRect.left;
                int n3 = this.maxRect.bottom - this.maxRect.top;
                return new Rectangle(this.maxRect.left, this.maxRect.top, n2, n3);
            }
            int n4 = wINDOWPLACEMENT.right - wINDOWPLACEMENT.left;
            int n5 = wINDOWPLACEMENT.bottom - wINDOWPLACEMENT.top;
            return new Rectangle(wINDOWPLACEMENT.left, wINDOWPLACEMENT.top, n4, n5);
        }
        return super.getBoundsInPixels();
    }

    @Override
    Rectangle getClientAreaInPixels() {
        this.checkWidget();
        if (OS.IsHPC) {
            Rectangle rectangle = super.getClientAreaInPixels();
            if (this.menuBar != null) {
                int n2 = this.menuBar.hwndCB;
                int n3 = OS.CommandBar_Height(n2);
                rectangle.y += n3;
                rectangle.height = Math.max(0, rectangle.height - n3);
            }
            return rectangle;
        }
        if (!OS.IsWinCE && OS.IsIconic(this.handle)) {
            WINDOWPLACEMENT wINDOWPLACEMENT = new WINDOWPLACEMENT();
            wINDOWPLACEMENT.length = WINDOWPLACEMENT.sizeof;
            OS.GetWindowPlacement(this.handle, wINDOWPLACEMENT);
            if ((wINDOWPLACEMENT.flags & 2) != 0) {
                return new Rectangle(0, 0, this.oldWidth, this.oldHeight);
            }
            int n4 = wINDOWPLACEMENT.right - wINDOWPLACEMENT.left;
            int n5 = wINDOWPLACEMENT.bottom - wINDOWPLACEMENT.top;
            if (this.horizontalBar != null) {
                n4 -= OS.GetSystemMetrics(3);
            }
            if (this.verticalBar != null) {
                n5 -= OS.GetSystemMetrics(2);
            }
            RECT rECT = new RECT();
            int n6 = OS.GetWindowLong(this.handle, -16);
            int n7 = OS.GetWindowLong(this.handle, -20);
            boolean bl2 = OS.IsWinCE ? false : OS.GetMenu(this.handle) != 0;
            OS.AdjustWindowRectEx(rECT, n6, bl2, n7);
            n4 = Math.max(0, n4 - (rECT.right - rECT.left));
            n5 = Math.max(0, n5 - (rECT.bottom - rECT.top));
            return new Rectangle(0, 0, n4, n5);
        }
        return super.getClientAreaInPixels();
    }

    public Button getDefaultButton() {
        this.checkWidget();
        if (this.defaultButton != null && this.defaultButton.isDisposed()) {
            return null;
        }
        return this.defaultButton;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public Image[] getImages() {
        this.checkWidget();
        if (this.images == null) {
            return new Image[0];
        }
        Image[] imageArray = new Image[this.images.length];
        System.arraycopy(this.images, 0, imageArray, 0, this.images.length);
        return imageArray;
    }

    @Override
    Point getLocationInPixels() {
        this.checkWidget();
        if (!OS.IsWinCE && OS.IsIconic(this.handle)) {
            WINDOWPLACEMENT wINDOWPLACEMENT = new WINDOWPLACEMENT();
            wINDOWPLACEMENT.length = WINDOWPLACEMENT.sizeof;
            OS.GetWindowPlacement(this.handle, wINDOWPLACEMENT);
            if ((wINDOWPLACEMENT.flags & 2) != 0) {
                return new Point(this.maxRect.left, this.maxRect.top);
            }
            return new Point(wINDOWPLACEMENT.left, wINDOWPLACEMENT.top);
        }
        return super.getLocationInPixels();
    }

    public boolean getMaximized() {
        this.checkWidget();
        if (OS.IsWinCE) {
            return this.swFlags == OS.SW_SHOWMAXIMIZED;
        }
        if (OS.IsWindowVisible(this.handle)) {
            return OS.IsZoomed(this.handle);
        }
        return this.swFlags == OS.SW_SHOWMAXIMIZED;
    }

    public Menu getMenuBar() {
        this.checkWidget();
        return this.menuBar;
    }

    public boolean getMinimized() {
        this.checkWidget();
        if (OS.IsWinCE) {
            return false;
        }
        if (OS.IsWindowVisible(this.handle)) {
            return OS.IsIconic(this.handle);
        }
        return this.swFlags == 7;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    @Override
    Point getSizeInPixels() {
        this.checkWidget();
        if (!OS.IsWinCE && OS.IsIconic(this.handle)) {
            WINDOWPLACEMENT wINDOWPLACEMENT = new WINDOWPLACEMENT();
            wINDOWPLACEMENT.length = WINDOWPLACEMENT.sizeof;
            OS.GetWindowPlacement(this.handle, wINDOWPLACEMENT);
            if ((wINDOWPLACEMENT.flags & 2) != 0) {
                int n2 = this.maxRect.right - this.maxRect.left;
                int n3 = this.maxRect.bottom - this.maxRect.top;
                return new Point(n2, n3);
            }
            int n4 = wINDOWPLACEMENT.right - wINDOWPLACEMENT.left;
            int n5 = wINDOWPLACEMENT.bottom - wINDOWPLACEMENT.top;
            return new Point(n4, n5);
        }
        return super.getSizeInPixels();
    }

    public String getText() {
        this.checkWidget();
        int n2 = OS.GetWindowTextLength(this.handle);
        if (n2 == 0) {
            return "";
        }
        TCHAR tCHAR = new TCHAR(0, n2 + 1);
        OS.GetWindowText(this.handle, tCHAR, n2 + 1);
        return tCHAR.toString(0, n2);
    }

    @Override
    public boolean isReparentable() {
        this.checkWidget();
        return false;
    }

    @Override
    boolean isTabGroup() {
        return true;
    }

    @Override
    boolean isTabItem() {
        return false;
    }

    @Override
    Decorations menuShell() {
        return this;
    }

    @Override
    void releaseChildren(boolean bl2) {
        if (this.menuBar != null) {
            this.menuBar.release(false);
            this.menuBar = null;
        }
        super.releaseChildren(bl2);
        if (this.menus != null) {
            for (int i2 = 0; i2 < this.menus.length; ++i2) {
                Menu menu = this.menus[i2];
                if (menu == null || menu.isDisposed()) continue;
                menu.dispose();
            }
            this.menus = null;
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.smallImage != null) {
            this.smallImage.dispose();
        }
        if (this.largeImage != null) {
            this.largeImage.dispose();
        }
        this.image = null;
        this.largeImage = null;
        this.smallImage = null;
        this.images = null;
        this.savedFocus = null;
        this.saveDefault = null;
        this.defaultButton = null;
        if (this.hAccel != 0 && this.hAccel != -1) {
            OS.DestroyAcceleratorTable(this.hAccel);
        }
        this.hAccel = -1;
    }

    void removeMenu(Menu menu) {
        if (this.menus == null) {
            return;
        }
        for (int i2 = 0; i2 < this.menus.length; ++i2) {
            if (this.menus[i2] != menu) continue;
            this.menus[i2] = null;
            return;
        }
    }

    @Override
    void reskinChildren(int n2) {
        if (this.menuBar != null) {
            this.menuBar.reskin(n2);
        }
        if (this.menus != null) {
            for (int i2 = 0; i2 < this.menus.length; ++i2) {
                Menu menu = this.menus[i2];
                if (menu == null) continue;
                menu.reskin(n2);
            }
        }
        super.reskinChildren(n2);
    }

    boolean restoreFocus() {
        if (this.display.ignoreRestoreFocus) {
            return true;
        }
        if (this.savedFocus != null && this.savedFocus.isDisposed()) {
            this.savedFocus = null;
        }
        return this.savedFocus != null && this.savedFocus.setSavedFocus();
    }

    void saveFocus() {
        Control control = this.display._getFocusControl();
        if (control != null && control != this && this == control.menuShell()) {
            this.setSavedFocus(control);
        }
    }

    @Override
    void setBoundsInPixels(int n2, int n3, int n4, int n5, int n6, boolean bl2) {
        this.swFlags = 4;
        if (OS.IsWinCE) {
            this.swFlags = OS.SW_RESTORE;
        } else if (OS.IsIconic(this.handle)) {
            this.setPlacement(n2, n3, n4, n5, n6);
            return;
        }
        this.forceResize();
        RECT rECT = new RECT();
        OS.GetWindowRect(this.handle, rECT);
        boolean bl3 = true;
        if ((2 & n6) == 0) {
            boolean bl4 = bl3 = rECT.left == n2 && rECT.top == n3;
            if (!bl3) {
                this.moved = true;
            }
        }
        boolean bl5 = true;
        if ((1 & n6) == 0) {
            boolean bl6 = bl5 = rECT.right - rECT.left == n4 && rECT.bottom - rECT.top == n5;
            if (!bl5) {
                this.resized = true;
            }
        }
        if (!OS.IsWinCE && OS.IsZoomed(this.handle)) {
            if (bl3 && bl5) {
                return;
            }
            this.setPlacement(n2, n3, n4, n5, n6);
            this._setMaximized(false);
            return;
        }
        super.setBoundsInPixels(n2, n3, n4, n5, n6, bl2);
    }

    public void setDefaultButton(Button button) {
        this.checkWidget();
        if (button != null) {
            if (button.isDisposed()) {
                this.error(5);
            }
            if (button.menuShell() != this) {
                this.error(32);
            }
        }
        this.setDefaultButton(button, true);
    }

    void setDefaultButton(Button button, boolean bl2) {
        if (button == null) {
            if (this.defaultButton == this.saveDefault) {
                if (bl2) {
                    this.saveDefault = null;
                }
                return;
            }
        } else {
            if ((button.style & 8) == 0) {
                return;
            }
            if (button == this.defaultButton) {
                if (bl2) {
                    this.saveDefault = this.defaultButton;
                }
                return;
            }
        }
        if (this.defaultButton != null && !this.defaultButton.isDisposed()) {
            this.defaultButton.setDefault(false);
        }
        if ((this.defaultButton = button) == null) {
            this.defaultButton = this.saveDefault;
        }
        if (this.defaultButton != null && !this.defaultButton.isDisposed()) {
            this.defaultButton.setDefault(true);
        }
        if (bl2) {
            this.saveDefault = this.defaultButton;
        }
        if (this.saveDefault != null && this.saveDefault.isDisposed()) {
            this.saveDefault = null;
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.image = image;
        this.setImages(image, null);
    }

    void setImages(Image image, Image[] imageArray) {
        int n2;
        if (OS.IsWinCE) {
            return;
        }
        if (this.smallImage != null) {
            this.smallImage.dispose();
        }
        if (this.largeImage != null) {
            this.largeImage.dispose();
        }
        this.largeImage = null;
        this.smallImage = null;
        int n3 = 0;
        int n4 = 0;
        Image image2 = null;
        Image image3 = null;
        if (image != null) {
            image2 = image3 = image;
        } else if (imageArray != null && imageArray.length > 0) {
            n2 = this.display.getIconDepth();
            ImageData[] imageDataArray = null;
            if (imageArray.length > 1) {
                Image[] imageArray2 = new Image[imageArray.length];
                System.arraycopy(imageArray, 0, imageArray2, 0, imageArray.length);
                imageDataArray = new ImageData[imageArray.length];
                for (int i2 = 0; i2 < imageDataArray.length; ++i2) {
                    imageDataArray[i2] = imageArray[i2].getImageData(DPIUtil.getDeviceZoom());
                }
                imageArray = imageArray2;
                this.sort(imageArray, imageDataArray, OS.GetSystemMetrics(49), OS.GetSystemMetrics(50), n2);
            }
            image2 = imageArray[0];
            if (imageArray.length > 1) {
                this.sort(imageArray, imageDataArray, OS.GetSystemMetrics(11), OS.GetSystemMetrics(12), n2);
            }
            image3 = imageArray[0];
        }
        if (image2 != null) {
            switch (image2.type) {
                case 0: {
                    this.smallImage = Display.createIcon(image2);
                    n3 = this.smallImage.handle;
                    break;
                }
                case 1: {
                    n3 = image2.handle;
                }
            }
        }
        OS.SendMessage(this.handle, 128, 0, n3);
        if (image3 != null) {
            switch (image3.type) {
                case 0: {
                    this.largeImage = Display.createIcon(image3);
                    n4 = this.largeImage.handle;
                    break;
                }
                case 1: {
                    n4 = image3.handle;
                }
            }
        }
        OS.SendMessage(this.handle, 128, 1, n4);
        if (!OS.IsWinCE && n3 == 0 && n4 == 0 && (this.style & 0x800) != 0) {
            n2 = 1025;
            OS.RedrawWindow(this.handle, null, 0, n2);
        }
    }

    public void setImages(Image[] imageArray) {
        this.checkWidget();
        if (imageArray == null) {
            this.error(5);
        }
        for (int i2 = 0; i2 < imageArray.length; ++i2) {
            if (imageArray[i2] != null && !imageArray[i2].isDisposed()) continue;
            this.error(5);
        }
        this.images = imageArray;
        this.setImages(null, imageArray);
    }

    public void setMaximized(boolean bl2) {
        this.checkWidget();
        Display.lpStartupInfo = null;
        this._setMaximized(bl2);
    }

    public void setMenuBar(Menu menu) {
        this.checkWidget();
        if (this.menuBar == menu) {
            return;
        }
        if (menu != null) {
            if (menu.isDisposed()) {
                this.error(5);
            }
            if ((menu.style & 2) == 0) {
                this.error(33);
            }
            if (menu.parent != this) {
                this.error(32);
            }
        }
        if (OS.IsWinCE) {
            if (OS.IsHPC) {
                boolean bl2;
                boolean bl3 = bl2 = this.menuBar != menu;
                if (this.menuBar != null) {
                    OS.CommandBar_Show(this.menuBar.hwndCB, false);
                }
                this.menuBar = menu;
                if (this.menuBar != null) {
                    OS.CommandBar_Show(this.menuBar.hwndCB, true);
                }
                if (bl2) {
                    this.sendEvent(11);
                    if (this.isDisposed()) {
                        return;
                    }
                    if (this.layout != null) {
                        this.markLayout(false, false);
                        this.updateLayout(true, false);
                    }
                }
            } else {
                if (OS.IsPPC) {
                    boolean bl4;
                    boolean bl5 = bl4 = this.getMaximized() && this.menuBar != menu;
                    if (this.menuBar != null) {
                        OS.ShowWindow(this.menuBar.hwndCB, 0);
                    }
                    this.menuBar = menu;
                    if (this.menuBar != null) {
                        OS.ShowWindow(this.menuBar.hwndCB, 5);
                    }
                    if (bl4) {
                        this._setMaximized(true);
                    }
                }
                if (OS.IsSP) {
                    if (this.menuBar != null) {
                        OS.ShowWindow(this.menuBar.hwndCB, 0);
                    }
                    this.menuBar = menu;
                    if (this.menuBar != null) {
                        OS.ShowWindow(this.menuBar.hwndCB, 5);
                    }
                }
            }
        } else {
            if (menu != null) {
                this.display.removeBar(menu);
            }
            this.menuBar = menu;
            int n2 = this.menuBar != null ? this.menuBar.handle : 0;
            OS.SetMenu(this.handle, n2);
        }
        this.destroyAccelerators();
    }

    public void setMinimized(boolean bl2) {
        this.checkWidget();
        Display.lpStartupInfo = null;
        this._setMinimized(bl2);
    }

    @Override
    public void setOrientation(int n2) {
        super.setOrientation(n2);
        if (this.menus != null) {
            for (int i2 = 0; i2 < this.menus.length; ++i2) {
                Menu menu = this.menus[i2];
                if (menu == null || menu.isDisposed() || (menu.getStyle() & 8) == 0) continue;
                menu._setOrientation(menu.getOrientation());
            }
        }
    }

    void setParent() {
        int n2 = this.parent.handle;
        this.display.lockActiveWindow = true;
        OS.SetParent(this.handle, n2);
        if (!OS.IsWindowVisible(n2)) {
            OS.ShowWindow(this.handle, 8);
        }
        int n3 = OS.GetWindowLong(this.handle, -16);
        OS.SetWindowLong(this.handle, -16, (n3 &= 0xBFFFFFFF) | Integer.MIN_VALUE);
        OS.SetWindowLongPtr(this.handle, -12, 0);
        int n4 = 19;
        this.SetWindowPos(this.handle, 1, 0, 0, 0, 0, n4);
        this.display.lockActiveWindow = false;
    }

    void setPlacement(int n2, int n3, int n4, int n5, int n6) {
        WINDOWPLACEMENT wINDOWPLACEMENT = new WINDOWPLACEMENT();
        wINDOWPLACEMENT.length = WINDOWPLACEMENT.sizeof;
        OS.GetWindowPlacement(this.handle, wINDOWPLACEMENT);
        wINDOWPLACEMENT.showCmd = 8;
        if (OS.IsIconic(this.handle)) {
            wINDOWPLACEMENT.showCmd = 7;
        } else if (OS.IsZoomed(this.handle)) {
            wINDOWPLACEMENT.showCmd = OS.SW_SHOWMAXIMIZED;
        }
        boolean bl2 = true;
        if ((n6 & 2) == 0) {
            bl2 = wINDOWPLACEMENT.left != n2 || wINDOWPLACEMENT.top != n3;
            wINDOWPLACEMENT.right = n2 + (wINDOWPLACEMENT.right - wINDOWPLACEMENT.left);
            wINDOWPLACEMENT.bottom = n3 + (wINDOWPLACEMENT.bottom - wINDOWPLACEMENT.top);
            wINDOWPLACEMENT.left = n2;
            wINDOWPLACEMENT.top = n3;
        }
        boolean bl3 = true;
        if ((n6 & 1) == 0) {
            bl3 = wINDOWPLACEMENT.right - wINDOWPLACEMENT.left != n4 || wINDOWPLACEMENT.bottom - wINDOWPLACEMENT.top != n5;
            wINDOWPLACEMENT.right = wINDOWPLACEMENT.left + n4;
            wINDOWPLACEMENT.bottom = wINDOWPLACEMENT.top + n5;
        }
        OS.SetWindowPlacement(this.handle, wINDOWPLACEMENT);
        if (OS.IsIconic(this.handle)) {
            Serializable serializable;
            if (bl2) {
                this.moved = true;
                serializable = this.getLocationInPixels();
                this.oldX = serializable.x;
                this.oldY = serializable.y;
                this.sendEvent(10);
                if (this.isDisposed()) {
                    return;
                }
            }
            if (bl3) {
                this.resized = true;
                serializable = this.getClientAreaInPixels();
                this.oldWidth = ((Rectangle)serializable).width;
                this.oldHeight = ((Rectangle)serializable).height;
                this.sendEvent(11);
                if (this.isDisposed()) {
                    return;
                }
                if (this.layout != null) {
                    this.markLayout(false, false);
                    this.updateLayout(true, false);
                }
            }
        }
    }

    void setSavedFocus(Control control) {
        this.savedFocus = control;
    }

    void setSystemMenu() {
        if (OS.IsWinCE) {
            return;
        }
        int n2 = OS.GetSystemMenu(this.handle, false);
        if (n2 == 0) {
            return;
        }
        int n3 = OS.GetMenuItemCount(n2);
        if ((this.style & 0x10) == 0) {
            OS.DeleteMenu(n2, 61440, 0);
        }
        if ((this.style & 0x80) == 0) {
            OS.DeleteMenu(n2, 61472, 0);
        }
        if ((this.style & 0x400) == 0) {
            OS.DeleteMenu(n2, 61488, 0);
        }
        if ((this.style & 0x480) == 0) {
            OS.DeleteMenu(n2, 61728, 0);
        }
        int n4 = OS.GetMenuItemCount(n2);
        if ((this.style & 0x40) == 0 || n4 != n3) {
            int n5;
            OS.DeleteMenu(n2, 61744, 0);
            MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
            mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
            mENUITEMINFO.fMask = 2;
            for (n5 = 0; !(n5 >= n4 || OS.GetMenuItemInfo(n2, n5, true, mENUITEMINFO) && mENUITEMINFO.wID == 61536); ++n5) {
            }
            if (n5 != n4) {
                OS.DeleteMenu(n2, n5 - 1, 1024);
                if ((this.style & 0x40) == 0) {
                    OS.DeleteMenu(n2, 61536, 0);
                }
            }
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        TCHAR tCHAR = new TCHAR(0, string, true);
        if ((this.state & 0x4000) != 0) {
            int n2 = OS.GetProcessHeap();
            int n3 = tCHAR.length() * TCHAR.sizeof;
            int n4 = OS.HeapAlloc(n2, 8, n3);
            OS.MoveMemory(n4, tCHAR, n3);
            OS.DefWindowProc(this.handle, 12, 0, n4);
            if (n4 != 0) {
                OS.HeapFree(n2, 0, n4);
            }
        } else {
            OS.SetWindowText(this.handle, tCHAR);
        }
        if ((this.state & 0x400000) != 0) {
            this.updateTextDirection(0x6000000);
        }
    }

    @Override
    public void setVisible(boolean bl2) {
        this.checkWidget();
        if (!this.getDrawing() ? (this.state & 0x10) == 0 == bl2 : bl2 == OS.IsWindowVisible(this.handle)) {
            return;
        }
        if (bl2) {
            int n2;
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            if (OS.IsHPC && this.menuBar != null) {
                n2 = this.menuBar.hwndCB;
                OS.CommandBar_DrawMenuBar(n2, 0);
            }
            if (!this.getDrawing()) {
                this.state &= 0xFFFFFFEF;
            } else {
                if (OS.IsWinCE) {
                    OS.ShowWindow(this.handle, 5);
                } else {
                    STARTUPINFO sTARTUPINFO;
                    if (this.menuBar != null) {
                        this.display.removeBar(this.menuBar);
                        OS.DrawMenuBar(this.handle);
                    }
                    if ((sTARTUPINFO = Display.lpStartupInfo) != null && (sTARTUPINFO.dwFlags & 1) != 0) {
                        OS.ShowWindow(this.handle, sTARTUPINFO.wShowWindow);
                    } else {
                        OS.ShowWindow(this.handle, this.swFlags);
                    }
                }
                if (this.isDisposed()) {
                    return;
                }
                this.opened = true;
                if (!this.moved) {
                    this.moved = true;
                    Point point = this.getLocationInPixels();
                    this.oldX = point.x;
                    this.oldY = point.y;
                }
                if (!this.resized) {
                    this.resized = true;
                    Rectangle rectangle = this.getClientAreaInPixels();
                    this.oldWidth = rectangle.width;
                    this.oldHeight = rectangle.height;
                }
                n2 = 1;
                if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0) && !OS.IsAppThemed()) {
                    int n3 = n2 = !OS.IsHungAppWindow(this.handle) ? 1 : 0;
                }
                if (n2 != 0) {
                    OS.UpdateWindow(this.handle);
                }
            }
        } else {
            if (!OS.IsWinCE) {
                this.swFlags = OS.IsIconic(this.handle) ? 7 : (OS.IsZoomed(this.handle) ? OS.SW_SHOWMAXIMIZED : 4);
            }
            if (!this.getDrawing()) {
                this.state |= 0x10;
            } else {
                OS.ShowWindow(this.handle, 0);
            }
            if (this.isDisposed()) {
                return;
            }
            this.sendEvent(23);
        }
    }

    void sort(Image[] imageArray, ImageData[] imageDataArray, int n2, int n3, int n4) {
        int n5 = imageArray.length;
        if (n5 <= 1) {
            return;
        }
        for (int i2 = n5 / 2; i2 > 0; i2 /= 2) {
            for (int i3 = i2; i3 < n5; ++i3) {
                for (int i4 = i3 - i2; i4 >= 0; i4 -= i2) {
                    if (this.compare(imageDataArray[i4], imageDataArray[i4 + i2], n2, n3, n4) < 0) continue;
                    Image image = imageArray[i4];
                    imageArray[i4] = imageArray[i4 + i2];
                    imageArray[i4 + i2] = image;
                    ImageData imageData = imageDataArray[i4];
                    imageDataArray[i4] = imageDataArray[i4 + i2];
                    imageDataArray[i4 + i2] = imageData;
                }
            }
        }
    }

    @Override
    boolean translateAccelerator(MSG mSG) {
        if (!this.isEnabled() || !this.isActive()) {
            return false;
        }
        if (this.menuBar != null && !this.menuBar.isEnabled()) {
            return false;
        }
        if (this.translateMDIAccelerator(mSG) || this.translateMenuAccelerator(mSG)) {
            return true;
        }
        Decorations decorations = this.parent.menuShell();
        return decorations.translateAccelerator(mSG);
    }

    boolean translateMenuAccelerator(MSG mSG) {
        if (this.hAccel == -1) {
            this.createAccelerators();
        }
        return this.hAccel != 0 && OS.TranslateAccelerator(this.handle, this.hAccel, mSG) != 0;
    }

    boolean translateMDIAccelerator(MSG mSG) {
        if (!(this instanceof Shell)) {
            Shell shell = this.getShell();
            int n2 = shell.hwndMDIClient;
            if (n2 != 0 && OS.TranslateMDISysAccel(n2, mSG)) {
                return true;
            }
            if (mSG.message == 256) {
                if (OS.GetKeyState(17) >= 0) {
                    return false;
                }
                switch (mSG.wParam) {
                    case 115: {
                        OS.PostMessage(this.handle, 16, 0, 0);
                        return true;
                    }
                    case 117: {
                        if (!this.traverseDecorations(true)) break;
                        return true;
                    }
                }
                return false;
            }
            if (mSG.message == 260) {
                switch (mSG.wParam) {
                    case 115: {
                        OS.PostMessage(shell.handle, 16, 0, 0);
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    boolean traverseDecorations(boolean bl2) {
        int n2;
        int n3;
        Control[] controlArray = this.parent._getChildren();
        int n4 = controlArray.length;
        for (n3 = 0; n3 < n4 && controlArray[n3] != this; ++n3) {
        }
        int n5 = n3;
        int n6 = n2 = bl2 ? 1 : -1;
        while ((n3 = (n3 + n2 + n4) % n4) != n5) {
            Control control = controlArray[n3];
            if (control.isDisposed() || !(control instanceof Decorations) || !control.setFocus()) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean traverseItem(boolean bl2) {
        return false;
    }

    @Override
    boolean traverseReturn() {
        if (this.defaultButton == null || this.defaultButton.isDisposed()) {
            return false;
        }
        if (!this.defaultButton.isVisible() || !this.defaultButton.isEnabled()) {
            return false;
        }
        this.defaultButton.click();
        return true;
    }

    @Override
    CREATESTRUCT widgetCreateStruct() {
        return new CREATESTRUCT();
    }

    @Override
    int widgetExtStyle() {
        int n2 = super.widgetExtStyle() | 0x40;
        n2 &= 0xFFFFFDFF;
        if ((this.style & 8) != 0) {
            return n2;
        }
        if (OS.IsPPC && (this.style & 0x40) != 0) {
            n2 |= Integer.MIN_VALUE;
        }
        if ((this.style & 0x10) != 0) {
            return n2;
        }
        if ((this.style & 0x800) != 0) {
            n2 |= 1;
        }
        return n2;
    }

    @Override
    int widgetParent() {
        Shell shell = this.getShell();
        return shell.hwndMDIClient();
    }

    @Override
    int widgetStyle() {
        int n2 = super.widgetStyle() & 0xEFFEFFFF;
        n2 &= 0xFF7FFFFF;
        if ((this.style & 8) != 0) {
            if (this.parent == null) {
                n2 |= 0x80000 | OS.WS_MINIMIZEBOX;
            }
            return n2;
        }
        if ((this.style & 0x20) != 0) {
            n2 |= 0xC00000;
        }
        if ((this.style & 0x80) != 0) {
            n2 |= OS.WS_MINIMIZEBOX;
        }
        if ((this.style & 0x400) != 0) {
            n2 |= OS.WS_MAXIMIZEBOX;
        }
        if ((this.style & 0x10) != 0) {
            if (!OS.IsPPC) {
                n2 |= 0x40000;
            }
        } else if ((this.style & 0x800) == 0) {
            n2 |= 0x800000;
        }
        if (!OS.IsPPC && !OS.IsSP && (this.style & 0x40) != 0) {
            n2 |= 0x80000;
        }
        return n2;
    }

    @Override
    int windowProc(int n2, int n3, int n4, int n5) {
        switch (n3) {
            case 32768: 
            case 32769: {
                if (this.hAccel == -1) {
                    this.createAccelerators();
                }
                return n3 == 32768 ? this.nAccel : this.hAccel;
            }
        }
        return super.windowProc(n2, n3, n4, n5);
    }

    @Override
    LRESULT WM_ACTIVATE(int n2, int n3) {
        int n4;
        Object object;
        LRESULT lRESULT = super.WM_ACTIVATE(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.GetParent(n3) == this.handle) {
            TCHAR tCHAR = new TCHAR(0, 128);
            OS.GetClassName(n3, tCHAR, tCHAR.length());
            object = tCHAR.toString(0, tCHAR.strlen());
            if (((String)object).equals("SunAwtWindow")) {
                return LRESULT.ZERO;
            }
        }
        if ((n4 = OS.LOWORD(n2)) != 0) {
            if (OS.HIWORD(n2) != 0) {
                return lRESULT;
            }
            object = this.display.findControl(n3);
            if ((object == null || object instanceof Shell) && this instanceof Shell) {
                Event event = new Event();
                event.detail = n4 == 2 ? 3 : 0;
                this.sendEvent(26, event);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
            }
            if (this.restoreFocus()) {
                return LRESULT.ZERO;
            }
        } else {
            Control control;
            object = this.display;
            boolean bl2 = ((Display)object).isXMouseActive();
            if (bl2) {
                ((Display)object).lockActiveWindow = true;
            }
            if (((control = ((Display)object).findControl(n3)) == null || control instanceof Shell) && this instanceof Shell) {
                this.sendEvent(27);
                if (!this.isDisposed()) {
                    Shell shell = this.getShell();
                    shell.setActiveControl(null);
                }
            }
            if (bl2) {
                ((Display)object).lockActiveWindow = false;
            }
            if (this.isDisposed()) {
                return LRESULT.ZERO;
            }
            this.saveFocus();
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_CLOSE(int n2, int n3) {
        LRESULT lRESULT = super.WM_CLOSE(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.isEnabled() && this.isActive()) {
            this.closeWidget();
        }
        return LRESULT.ZERO;
    }

    @Override
    LRESULT WM_HOTKEY(int n2, int n3) {
        LRESULT lRESULT = super.WM_HOTKEY(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.IsSP && OS.HIWORD(n3) == 27) {
            if ((this.style & 0x40) != 0) {
                OS.PostMessage(this.handle, 16, 0, 0);
            } else {
                OS.SHSendBackToFocusWindow(786, n2, n3);
            }
            return LRESULT.ZERO;
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_KILLFOCUS(int n2, int n3) {
        LRESULT lRESULT = super.WM_KILLFOCUS(n2, n3);
        this.saveFocus();
        return lRESULT;
    }

    @Override
    LRESULT WM_MOVE(int n2, int n3) {
        if (this.moved) {
            Point point = this.getLocationInPixels();
            if (point.x == this.oldX && point.y == this.oldY) {
                return null;
            }
            this.oldX = point.x;
            this.oldY = point.y;
        }
        return super.WM_MOVE(n2, n3);
    }

    @Override
    LRESULT WM_NCACTIVATE(int n2, int n3) {
        LRESULT lRESULT = super.WM_NCACTIVATE(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (n2 == 0) {
            if (this.display.lockActiveWindow) {
                return LRESULT.ZERO;
            }
            Control control = this.display.findControl(n3);
            if (control != null) {
                Shell shell = this.getShell();
                Decorations decorations = control.menuShell();
                if (decorations.getShell() == shell) {
                    if (this instanceof Shell) {
                        return LRESULT.ONE;
                    }
                    if (this.display.ignoreRestoreFocus && this.display.lastHittest != 1) {
                        lRESULT = LRESULT.ONE;
                    }
                }
            }
        }
        if (!(this instanceof Shell)) {
            int n4 = this.getShell().handle;
            OS.SendMessage(n4, 134, n2, n3);
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_QUERYOPEN(int n2, int n3) {
        LRESULT lRESULT = super.WM_QUERYOPEN(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        this.sendEvent(20);
        return lRESULT;
    }

    @Override
    LRESULT WM_SETFOCUS(int n2, int n3) {
        LRESULT lRESULT = super.WM_SETFOCUS(n2, n3);
        if (this.isDisposed()) {
            return lRESULT;
        }
        if (this.savedFocus != this) {
            this.restoreFocus();
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_SIZE(int n2, int n3) {
        LRESULT lRESULT = null;
        boolean bl2 = true;
        if (this.resized) {
            int n4 = 0;
            int n5 = 0;
            switch (n2) {
                case 2: {
                    OS.GetWindowRect(this.handle, this.maxRect);
                }
                case 0: {
                    n4 = OS.LOWORD(n3);
                    n5 = OS.HIWORD(n3);
                    break;
                }
                case 1: {
                    Rectangle rectangle = this.getClientAreaInPixels();
                    n4 = rectangle.width;
                    n5 = rectangle.height;
                }
            }
            boolean bl3 = bl2 = n4 != this.oldWidth || n5 != this.oldHeight;
            if (bl2) {
                this.oldWidth = n4;
                this.oldHeight = n5;
            }
        }
        if (bl2) {
            lRESULT = super.WM_SIZE(n2, n3);
            if (this.isDisposed()) {
                return lRESULT;
            }
        }
        if (n2 == 1) {
            this.sendEvent(19);
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_SYSCOMMAND(int n2, int n3) {
        LRESULT lRESULT = super.WM_SYSCOMMAND(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (!(this instanceof Shell)) {
            int n4 = n2 & 0xFFF0;
            switch (n4) {
                case 61536: {
                    OS.PostMessage(this.handle, 16, 0, 0);
                    return LRESULT.ZERO;
                }
                case 61504: {
                    this.traverseDecorations(true);
                    return LRESULT.ZERO;
                }
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_WINDOWPOSCHANGING(int n2, int n3) {
        LRESULT lRESULT = super.WM_WINDOWPOSCHANGING(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.display.lockActiveWindow) {
            WINDOWPOS wINDOWPOS = new WINDOWPOS();
            OS.MoveMemory(wINDOWPOS, n3, WINDOWPOS.sizeof);
            wINDOWPOS.flags |= 4;
            OS.MoveMemory(n3, wINDOWPOS, WINDOWPOS.sizeof);
        }
        return lRESULT;
    }
}

