/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.DefaultExceptionHandler;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.HIGHCONTRAST;
import org.eclipse.swt.internal.win32.ICONINFO;
import org.eclipse.swt.internal.win32.INPUT;
import org.eclipse.swt.internal.win32.KEYBDINPUT;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LOGFONTA;
import org.eclipse.swt.internal.win32.LOGFONTW;
import org.eclipse.swt.internal.win32.MONITORINFO;
import org.eclipse.swt.internal.win32.MOUSEINPUT;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMLVDISPINFO;
import org.eclipse.swt.internal.win32.NONCLIENTMETRICS;
import org.eclipse.swt.internal.win32.NONCLIENTMETRICSA;
import org.eclipse.swt.internal.win32.NONCLIENTMETRICSW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.STARTUPINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.swt.widgets.TaskBar;
import org.eclipse.swt.widgets.TaskItem;
import org.eclipse.swt.widgets.TouchSource;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.Widget;

public class Display
extends Device {
    public MSG msg = new MSG();
    static String APP_NAME = "SWT";
    static String APP_VERSION = "";
    Event[] eventQueue;
    Callback windowCallback;
    int windowProc;
    int threadId;
    TCHAR windowClass;
    TCHAR windowShadowClass;
    TCHAR windowOwnDCClass;
    static int WindowClassCount;
    static final String WindowName = "SWT_Window";
    static final String WindowShadowName = "SWT_WindowShadow";
    static final String WindowOwnDCName = "SWT_WindowOwnDC";
    EventTable eventTable;
    EventTable filterTable;
    boolean useOwnDC;
    int freeSlot;
    int[] indexTable;
    Control lastControl;
    Control lastGetControl;
    int lastHwnd;
    int lastGetHwnd;
    Control[] controlTable;
    static final int GROW_SIZE = 1024;
    static final int SWT_OBJECT_INDEX;
    static final boolean USE_PROPERTY;
    static STARTUPINFO lpStartupInfo;
    int hButtonTheme;
    int hEditTheme;
    int hExplorerBarTheme;
    int hScrollBarTheme;
    int hTabTheme;
    static final char[] BUTTON;
    static final char[] EDIT;
    static final char[] EXPLORER;
    static final char[] EXPLORERBAR;
    static final char[] SCROLLBAR;
    static final char[] LISTVIEW;
    static final char[] TAB;
    static final char[] TREEVIEW;
    int focusEvent;
    Control focusControl;
    boolean fixFocus;
    Menu[] bars;
    Menu[] popups;
    MenuItem[] items;
    static final int ID_START = 108;
    Callback msgFilterCallback;
    int msgFilterProc;
    int filterHook;
    MSG hookMsg = new MSG();
    boolean runDragDrop = true;
    boolean dragCancelled = false;
    Callback foregroundIdleCallback;
    int foregroundIdleProc;
    int idleHook;
    boolean ignoreNextKey;
    Callback getMsgCallback;
    Callback embeddedCallback;
    int getMsgProc;
    int msgHook;
    int embeddedHwnd;
    int embeddedProc;
    static final String AWT_WINDOW_CLASS = "SunAwtWindow";
    static final short[] ACCENTS;
    Synchronizer synchronizer = new Synchronizer(this);
    Consumer runtimeExceptionHandler = DefaultExceptionHandler.RUNTIME_EXCEPTION_HANDLER;
    Consumer errorHandler = DefaultExceptionHandler.RUNTIME_ERROR_HANDLER;
    boolean runMessages = true;
    boolean runMessagesInIdle = false;
    boolean runMessagesInMessageProc = true;
    static final String RUN_MESSAGES_IN_IDLE_KEY = "org.eclipse.swt.internal.win32.runMessagesInIdle";
    static final String RUN_MESSAGES_IN_MESSAGE_PROC_KEY = "org.eclipse.swt.internal.win32.runMessagesInMessageProc";
    static final String USE_OWNDC_KEY = "org.eclipse.swt.internal.win32.useOwnDC";
    static final String ACCEL_KEY_HIT = "org.eclipse.swt.internal.win32.accelKeyHit";
    Thread thread;
    Runnable[] disposeList;
    Composite[] layoutDeferred;
    int layoutDeferredCount;
    Tray tray;
    int nextTrayId;
    TaskBar taskBar;
    static final String TASKBAR_EVENT = "/SWTINTERNAL_ID";
    static final String LAUNCHER_PREFIX = "--launcher.openFile ";
    int[] timerIds;
    Runnable[] timerList;
    int nextTimerId = 101;
    static final int SETTINGS_ID = 100;
    static final int SETTINGS_DELAY = 2000;
    boolean lastHighContrast;
    boolean sendSettings;
    RECT clickRect;
    int clickCount;
    int lastTime;
    int lastButton;
    int lastClickHwnd;
    int scrollRemainder;
    int scrollHRemainder;
    int lastKey;
    int lastMouse;
    int lastAscii;
    boolean lastVirtual;
    boolean lastNull;
    boolean lastDead;
    byte[] keyboard = new byte[256];
    boolean accelKeyHit;
    boolean mnemonicKeyHit;
    boolean lockActiveWindow;
    boolean captureChanged;
    boolean xMouse;
    double magStartDistance;
    double lastDistance;
    double rotationAngle;
    int lastX;
    int lastY;
    TouchSource[] touchSources;
    int nextToolTipId;
    boolean ignoreRestoreFocus;
    Control lastHittestControl;
    int lastHittest;
    Callback messageCallback;
    int hwndMessage;
    int messageProc;
    LOGFONT lfSystemFont;
    Font systemFont;
    Image errorImage;
    Image infoImage;
    Image questionImage;
    Image warningIcon;
    Cursor[] cursors = new Cursor[22];
    Resource[] resources;
    static final int RESOURCE_SIZE = 27;
    ImageList[] imageList;
    ImageList[] toolImageList;
    ImageList[] toolHotImageList;
    ImageList[] toolDisabledImageList;
    int lpCustColors;
    Image upArrow;
    Image downArrow;
    char[] tableBuffer;
    NMHDR hdr = new NMHDR();
    NMLVDISPINFO plvfi = new NMLVDISPINFO();
    int hwndParent;
    int columnCount;
    boolean[] columnVisible;
    int resizeCount;
    static final int RESIZE_LIMIT = 4;
    Object data;
    String[] keys;
    Object[] values;
    static final int[][] KeyTable;
    static Display Default;
    static Display[] Displays;
    Monitor[] monitors = null;
    int monitorCount = 0;
    Shell[] modalShells;
    Dialog modalDialog;
    static boolean TrimEnabled;
    static final int SWT_GETACCELCOUNT = 32768;
    static final int SWT_GETACCEL = 32769;
    static final int SWT_KEYMSG = 32770;
    static final int SWT_DESTROY = 32771;
    static final int SWT_TRAYICONMSG = 32772;
    static final int SWT_NULL = 32773;
    static final int SWT_RUNASYNC = 32774;
    static int TASKBARCREATED;
    static int TASKBARBUTTONCREATED;
    static int SWT_RESTORECARET;
    static int DI_GETDRAGIMAGE;
    static int SWT_OPENDOC;
    int hitCount;
    Widget[] skinList = new Widget[1024];
    int skinCount;
    static final String PACKAGE_PREFIX = "org.eclipse.swt.widgets.";

    static void setDevice(Device device) {
        CurrentDevice = device;
    }

    public Display() {
        this(null);
    }

    public Display(DeviceData deviceData) {
        super(deviceData);
    }

    Control _getFocusControl() {
        return this.findControl(OS.GetFocus());
    }

    void addBar(Menu menu) {
        int n2;
        if (this.bars == null) {
            this.bars = new Menu[4];
        }
        int n3 = this.bars.length;
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.bars[n2] != menu) continue;
            return;
        }
        for (n2 = 0; n2 < n3 && this.bars[n2] != null; ++n2) {
        }
        if (n2 == n3) {
            Menu[] menuArray = new Menu[n3 + 4];
            System.arraycopy(this.bars, 0, menuArray, 0, n3);
            this.bars = menuArray;
        }
        this.bars[n2] = menu;
    }

    void addControl(int n2, Control control) {
        int n3;
        if (n2 == 0) {
            return;
        }
        if (this.freeSlot == -1) {
            this.freeSlot = this.indexTable.length;
            n3 = this.freeSlot + 1024;
            int[] nArray = new int[n3];
            Control[] controlArray = new Control[n3];
            System.arraycopy(this.indexTable, 0, nArray, 0, this.freeSlot);
            System.arraycopy(this.controlTable, 0, controlArray, 0, this.freeSlot);
            for (int i2 = this.freeSlot; i2 < n3 - 1; ++i2) {
                nArray[i2] = i2 + 1;
            }
            nArray[n3 - 1] = -1;
            this.indexTable = nArray;
            this.controlTable = controlArray;
        }
        if (USE_PROPERTY) {
            OS.SetProp(n2, SWT_OBJECT_INDEX, this.freeSlot + 1);
        } else {
            OS.SetWindowLongPtr(n2, -21, this.freeSlot + 1);
        }
        n3 = this.freeSlot;
        this.freeSlot = this.indexTable[n3];
        this.indexTable[n3] = -2;
        this.controlTable[n3] = control;
    }

    void addSkinnableWidget(Widget widget) {
        if (this.skinCount >= this.skinList.length) {
            Widget[] widgetArray = new Widget[this.skinList.length + 1024];
            System.arraycopy(this.skinList, 0, widgetArray, 0, this.skinList.length);
            this.skinList = widgetArray;
        }
        this.skinList[this.skinCount++] = widget;
    }

    public void addFilter(int n2, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            this.filterTable = new EventTable();
        }
        this.filterTable.hook(n2, listener);
    }

    void addLayoutDeferred(Composite composite) {
        if (this.layoutDeferred == null) {
            this.layoutDeferred = new Composite[64];
        }
        if (this.layoutDeferredCount == this.layoutDeferred.length) {
            Composite[] compositeArray = new Composite[this.layoutDeferred.length + 64];
            System.arraycopy(this.layoutDeferred, 0, compositeArray, 0, this.layoutDeferred.length);
            this.layoutDeferred = compositeArray;
        }
        this.layoutDeferred[this.layoutDeferredCount++] = composite;
    }

    public void addListener(int n2, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(n2, listener);
    }

    void addMenuItem(MenuItem menuItem) {
        if (this.items == null) {
            this.items = new MenuItem[64];
        }
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            if (this.items[i2] != null) continue;
            menuItem.id = i2 + 108;
            this.items[i2] = menuItem;
            return;
        }
        menuItem.id = this.items.length + 108;
        MenuItem[] menuItemArray = new MenuItem[this.items.length + 64];
        menuItemArray[this.items.length] = menuItem;
        System.arraycopy(this.items, 0, menuItemArray, 0, this.items.length);
        this.items = menuItemArray;
    }

    void addPopup(Menu menu) {
        int n2;
        if (this.popups == null) {
            this.popups = new Menu[4];
        }
        int n3 = this.popups.length;
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.popups[n2] != menu) continue;
            return;
        }
        for (n2 = 0; n2 < n3 && this.popups[n2] != null; ++n2) {
        }
        if (n2 == n3) {
            Menu[] menuArray = new Menu[n3 + 4];
            System.arraycopy(this.popups, 0, menuArray, 0, n3);
            this.popups = menuArray;
        }
        this.popups[n2] = menu;
    }

    int asciiKey(int n2) {
        if (OS.IsWinCE) {
            return 0;
        }
        for (int i2 = 0; i2 < this.keyboard.length; ++i2) {
            this.keyboard[i2] = 0;
        }
        if (!OS.GetKeyboardState(this.keyboard)) {
            return 0;
        }
        if (OS.IsUnicode) {
            char[] cArray = new char[1];
            if (OS.ToUnicode(n2, n2, this.keyboard, cArray, 1, 0) == 1) {
                return cArray[0];
            }
        } else {
            short[] sArray = new short[1];
            if (OS.ToAscii(n2, n2, this.keyboard, sArray, 0) == 1) {
                return sArray[0];
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncExec(Runnable runnable) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            this.synchronizer.asyncExec(runnable);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void beep() {
        this.checkDevice();
        OS.MessageBeep(0);
    }

    protected void checkSubclass() {
        if (!Display.isValidClass(this.getClass())) {
            this.error(43);
        }
    }

    @Override
    protected void checkDevice() {
        if (this.thread == null) {
            this.error(24);
        }
        if (this.thread != Thread.currentThread() && this.threadId != OS.GetCurrentThreadId()) {
            this.error(22);
        }
        if (this.isDisposed()) {
            this.error(45);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkDisplay(Thread thread, boolean bl2) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            for (int i2 = 0; i2 < Displays.length; ++i2) {
                if (Displays[i2] == null) continue;
                if (!bl2) {
                    SWT.error(20, null, " [multiple displays]");
                }
                if (Display.Displays[i2].thread != thread) continue;
                SWT.error(22);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    void clearModal(Shell shell) {
        int n2;
        if (this.modalShells == null) {
            return;
        }
        int n3 = this.modalShells.length;
        for (n2 = 0; n2 < n3 && this.modalShells[n2] != shell; ++n2) {
            if (this.modalShells[n2] != null) continue;
            return;
        }
        if (n2 == n3) {
            return;
        }
        System.arraycopy(this.modalShells, n2 + 1, this.modalShells, n2, --n3 - n2);
        this.modalShells[n3] = null;
        if (n2 == 0 && this.modalShells[0] == null) {
            this.modalShells = null;
        }
        Shell[] shellArray = this.getShells();
        for (int i2 = 0; i2 < shellArray.length; ++i2) {
            shellArray[i2].updateModal();
        }
    }

    int controlKey(int n2) {
        int n3 = OS.CharUpper((short)n2);
        if (64 <= n3 && n3 <= 95) {
            return n3 & 0xBF;
        }
        return n2;
    }

    public void close() {
        this.checkDevice();
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit) {
            this.dispose();
        }
    }

    @Override
    protected void create(DeviceData deviceData) {
        this.checkSubclass();
        this.thread = Thread.currentThread();
        Display.checkDisplay(this.thread, true);
        this.createDisplay(deviceData);
        Display.register(this);
        if (Default == null) {
            Default = this;
        }
    }

    void createDisplay(DeviceData deviceData) {
    }

    static int create32bitDIB(Image image) {
        byte[] byArray;
        Object object;
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        byte[] byArray2 = null;
        switch (image.type) {
            case 1: {
                object = new ICONINFO();
                OS.GetIconInfo(image.handle, (ICONINFO)object);
                n5 = ((ICONINFO)object).hbmColor;
                n4 = ((ICONINFO)object).hbmMask;
                break;
            }
            case 0: {
                ImageData imageData = image.getImageData(DPIUtil.getDeviceZoom());
                n5 = image.handle;
                n3 = imageData.alpha;
                byArray2 = imageData.alphaData;
                n2 = imageData.transparentPixel;
            }
        }
        object = new BITMAP();
        OS.GetObject(n5, BITMAP.sizeof, (BITMAP)object);
        int n6 = ((BITMAP)object).bmWidth;
        int n7 = ((BITMAP)object).bmHeight;
        int n8 = OS.GetDC(0);
        int n9 = OS.CreateCompatibleDC(n8);
        int n10 = OS.SelectObject(n9, n5);
        int n11 = OS.CreateCompatibleDC(n8);
        BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
        bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
        bITMAPINFOHEADER.biWidth = n6;
        bITMAPINFOHEADER.biHeight = -n7;
        bITMAPINFOHEADER.biPlanes = 1;
        bITMAPINFOHEADER.biBitCount = (short)32;
        bITMAPINFOHEADER.biCompression = 0;
        byte[] byArray3 = new byte[BITMAPINFOHEADER.sizeof];
        OS.MoveMemory(byArray3, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
        int[] nArray = new int[1];
        int n12 = OS.CreateDIBSection(0, byArray3, 0, nArray, 0, 0);
        if (n12 == 0) {
            SWT.error(2);
        }
        int n13 = OS.SelectObject(n11, n12);
        BITMAP bITMAP = new BITMAP();
        OS.GetObject(n12, BITMAP.sizeof, bITMAP);
        int n14 = bITMAP.bmWidthBytes * bITMAP.bmHeight;
        OS.BitBlt(n11, 0, 0, n6, n7, n9, 0, 0, 0xCC0020);
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        if (n2 != -1) {
            if (((BITMAP)object).bmBitsPixel <= 8) {
                byArray = new byte[4];
                OS.GetDIBColorTable(n9, n2, 1, byArray);
                by4 = byArray[0];
                by3 = byArray[1];
                by2 = byArray[2];
            } else {
                switch (((BITMAP)object).bmBitsPixel) {
                    case 16: {
                        by4 = (byte)((n2 & 0x1F) << 3);
                        by3 = (byte)((n2 & 0x3E0) >> 2);
                        by2 = (byte)((n2 & 0x7C00) >> 7);
                        break;
                    }
                    case 24: {
                        by4 = (byte)((n2 & 0xFF0000) >> 16);
                        by3 = (byte)((n2 & 0xFF00) >> 8);
                        by2 = (byte)(n2 & 0xFF);
                        break;
                    }
                    case 32: {
                        by4 = (byte)((n2 & 0xFF000000) >>> 24);
                        by3 = (byte)((n2 & 0xFF0000) >> 16);
                        by2 = (byte)((n2 & 0xFF00) >> 8);
                    }
                }
            }
        }
        byArray = new byte[n14];
        OS.MoveMemory(byArray, nArray[0], n14);
        if (n4 != 0) {
            OS.SelectObject(n9, n4);
            int n15 = 0;
            for (int i2 = 0; i2 < n7; ++i2) {
                for (int i3 = 0; i3 < n6; ++i3) {
                    if (OS.GetPixel(n9, i3, i2) != 0) {
                        byArray[n15 + 3] = 0;
                        byArray[n15 + 2] = 0;
                        byArray[n15 + 1] = 0;
                        byArray[n15 + 0] = 0;
                    } else {
                        byArray[n15 + 3] = -1;
                    }
                    n15 += 4;
                }
            }
        } else if (n3 != -1) {
            int n16 = 0;
            for (int i4 = 0; i4 < n7; ++i4) {
                for (int i5 = 0; i5 < n6; ++i5) {
                    int n17 = (byArray[n16 + 0] & 0xFF) * n3 + 128;
                    n17 = n17 + (n17 >> 8) >> 8;
                    int n18 = (byArray[n16 + 1] & 0xFF) * n3 + 128;
                    n18 = n18 + (n18 >> 8) >> 8;
                    int n19 = (byArray[n16 + 2] & 0xFF) * n3 + 128;
                    n19 = n19 + (n19 >> 8) >> 8;
                    byArray[n16 + 0] = (byte)n17;
                    byArray[n16 + 1] = (byte)n18;
                    byArray[n16 + 2] = (byte)n19;
                    byArray[n16 + 3] = (byte)n3;
                    n16 += 4;
                }
            }
        } else if (byArray2 != null) {
            int n20 = 0;
            int n21 = 0;
            for (int i6 = 0; i6 < n7; ++i6) {
                for (int i7 = 0; i7 < n6; ++i7) {
                    int n22 = byArray2[n21++] & 0xFF;
                    int n23 = (byArray[n20 + 0] & 0xFF) * n22 + 128;
                    n23 = n23 + (n23 >> 8) >> 8;
                    int n24 = (byArray[n20 + 1] & 0xFF) * n22 + 128;
                    n24 = n24 + (n24 >> 8) >> 8;
                    int n25 = (byArray[n20 + 2] & 0xFF) * n22 + 128;
                    n25 = n25 + (n25 >> 8) >> 8;
                    byArray[n20 + 0] = (byte)n23;
                    byArray[n20 + 1] = (byte)n24;
                    byArray[n20 + 2] = (byte)n25;
                    byArray[n20 + 3] = (byte)n22;
                    n20 += 4;
                }
            }
        } else if (n2 != -1) {
            int n26 = 0;
            for (int i8 = 0; i8 < n7; ++i8) {
                for (int i9 = 0; i9 < n6; ++i9) {
                    if (byArray[n26] == by4 && byArray[n26 + 1] == by3 && byArray[n26 + 2] == by2) {
                        byArray[n26 + 3] = 0;
                        byArray[n26 + 2] = 0;
                        byArray[n26 + 1] = 0;
                        byArray[n26 + 0] = 0;
                    } else {
                        byArray[n26 + 3] = -1;
                    }
                    n26 += 4;
                }
            }
        } else {
            int n27 = 0;
            for (int i10 = 0; i10 < n7; ++i10) {
                for (int i11 = 0; i11 < n6; ++i11) {
                    byArray[n27 + 3] = -1;
                    n27 += 4;
                }
            }
        }
        OS.MoveMemory(nArray[0], byArray, n14);
        OS.SelectObject(n9, n10);
        OS.SelectObject(n11, n13);
        OS.DeleteObject(n9);
        OS.DeleteObject(n11);
        OS.ReleaseDC(0, n8);
        if (n5 != image.handle && n5 != 0) {
            OS.DeleteObject(n5);
        }
        if (n4 != 0) {
            OS.DeleteObject(n4);
        }
        return n12;
    }

    static int create32bitDIB(int n2, int n3, byte[] byArray, int n4) {
        byte[] byArray2;
        BITMAP bITMAP = new BITMAP();
        OS.GetObject(n2, BITMAP.sizeof, bITMAP);
        int n5 = bITMAP.bmWidth;
        int n6 = bITMAP.bmHeight;
        int n7 = OS.GetDC(0);
        int n8 = OS.CreateCompatibleDC(n7);
        int n9 = OS.SelectObject(n8, n2);
        int n10 = OS.CreateCompatibleDC(n7);
        BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
        bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
        bITMAPINFOHEADER.biWidth = n5;
        bITMAPINFOHEADER.biHeight = -n6;
        bITMAPINFOHEADER.biPlanes = 1;
        bITMAPINFOHEADER.biBitCount = (short)32;
        bITMAPINFOHEADER.biCompression = 0;
        byte[] byArray3 = new byte[BITMAPINFOHEADER.sizeof];
        OS.MoveMemory(byArray3, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
        int[] nArray = new int[1];
        int n11 = OS.CreateDIBSection(0, byArray3, 0, nArray, 0, 0);
        if (n11 == 0) {
            SWT.error(2);
        }
        int n12 = OS.SelectObject(n10, n11);
        BITMAP bITMAP2 = new BITMAP();
        OS.GetObject(n11, BITMAP.sizeof, bITMAP2);
        int n13 = bITMAP2.bmWidthBytes * bITMAP2.bmHeight;
        OS.BitBlt(n10, 0, 0, n5, n6, n8, 0, 0, 0xCC0020);
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        if (n4 != -1) {
            if (bITMAP.bmBitsPixel <= 8) {
                byArray2 = new byte[4];
                OS.GetDIBColorTable(n8, n4, 1, byArray2);
                by4 = byArray2[0];
                by3 = byArray2[1];
                by2 = byArray2[2];
            } else {
                switch (bITMAP.bmBitsPixel) {
                    case 16: {
                        by4 = (byte)((n4 & 0x1F) << 3);
                        by3 = (byte)((n4 & 0x3E0) >> 2);
                        by2 = (byte)((n4 & 0x7C00) >> 7);
                        break;
                    }
                    case 24: {
                        by4 = (byte)((n4 & 0xFF0000) >> 16);
                        by3 = (byte)((n4 & 0xFF00) >> 8);
                        by2 = (byte)(n4 & 0xFF);
                        break;
                    }
                    case 32: {
                        by4 = (byte)((n4 & 0xFF000000) >>> 24);
                        by3 = (byte)((n4 & 0xFF0000) >> 16);
                        by2 = (byte)((n4 & 0xFF00) >> 8);
                    }
                }
            }
        }
        OS.SelectObject(n8, n9);
        OS.SelectObject(n10, n12);
        OS.DeleteObject(n8);
        OS.DeleteObject(n10);
        OS.ReleaseDC(0, n7);
        byArray2 = new byte[n13];
        OS.MoveMemory(byArray2, nArray[0], n13);
        if (n3 != -1) {
            int n14 = 0;
            for (int i2 = 0; i2 < n6; ++i2) {
                for (int i3 = 0; i3 < n5; ++i3) {
                    byArray2[n14 + 3] = (byte)n3;
                    n14 += 4;
                }
            }
        } else if (byArray != null) {
            int n15 = 0;
            int n16 = 0;
            for (int i4 = 0; i4 < n6; ++i4) {
                for (int i5 = 0; i5 < n5; ++i5) {
                    byArray2[n15 + 3] = byArray[n16++];
                    n15 += 4;
                }
            }
        } else if (n4 != -1) {
            int n17 = 0;
            for (int i6 = 0; i6 < n6; ++i6) {
                for (int i7 = 0; i7 < n5; ++i7) {
                    byArray2[n17 + 3] = byArray2[n17] == by4 && byArray2[n17 + 1] == by3 && byArray2[n17 + 2] == by2 ? 0 : -1;
                    n17 += 4;
                }
            }
        }
        OS.MoveMemory(nArray[0], byArray2, n13);
        return n11;
    }

    static Image createIcon(Image image) {
        int n2;
        int n3;
        int n4;
        int n5;
        Device device = image.getDevice();
        ImageData imageData = image.getImageData(DPIUtil.getDeviceZoom());
        if (imageData.alpha == -1 && imageData.alphaData == null) {
            ImageData imageData2 = imageData.getTransparencyMask();
            return new Image(device, imageData, imageData2);
        }
        int n6 = imageData.width;
        int n7 = imageData.height;
        int n8 = device.internal_new_GC(null);
        int n9 = OS.CreateCompatibleDC(n8);
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(5, 1)) {
            n5 = Display.create32bitDIB(image.handle, imageData.alpha, imageData.alphaData, imageData.transparentPixel);
            n4 = OS.CreateBitmap(n6, n7, 1, 1, null);
            n3 = OS.SelectObject(n9, n4);
            OS.PatBlt(n9, 0, 0, n6, n7, 66);
        } else {
            n4 = Display.createMaskFromAlpha(imageData, n6, n7);
            n5 = OS.CreateCompatibleBitmap(n8, n6, n7);
            n3 = OS.SelectObject(n9, n5);
            int n10 = OS.CreateCompatibleDC(n8);
            n2 = OS.SelectObject(n10, image.handle);
            OS.PatBlt(n9, 0, 0, n6, n7, 66);
            OS.BitBlt(n9, 0, 0, n6, n7, n10, 0, 0, 0x660046);
            OS.SelectObject(n10, n4);
            OS.BitBlt(n9, 0, 0, n6, n7, n10, 0, 0, 8913094);
            OS.SelectObject(n10, image.handle);
            OS.BitBlt(n9, 0, 0, n6, n7, n10, 0, 0, 0x660046);
            OS.SelectObject(n10, n2);
            OS.DeleteDC(n10);
        }
        OS.SelectObject(n9, n3);
        OS.DeleteDC(n9);
        device.internal_dispose_GC(n8, null);
        ICONINFO iCONINFO = new ICONINFO();
        iCONINFO.fIcon = true;
        iCONINFO.hbmColor = n5;
        iCONINFO.hbmMask = n4;
        n2 = OS.CreateIconIndirect(iCONINFO);
        if (n2 == 0) {
            SWT.error(2);
        }
        OS.DeleteObject(n5);
        OS.DeleteObject(n4);
        return Image.win32_new(device, 1, n2);
    }

    static int createMaskFromAlpha(ImageData imageData, int n2, int n3) {
        int n4;
        int n5;
        int n6 = imageData.width;
        int n7 = imageData.height;
        ImageData imageData2 = ImageData.internal_new(n6, n7, 1, new PaletteData(new RGB(0, 0, 0), new RGB(255, 255, 255)), 2, null, 1, null, null, -1, -1, -1, 0, 0, 0, 0);
        int n8 = 0;
        for (n5 = 0; n5 < imageData2.height; ++n5) {
            for (n4 = 0; n4 < imageData2.width; ++n4) {
                imageData2.setPixel(n4, n5, (imageData.alphaData[n8++] & 0xFF) <= 127 ? 1 : 0);
            }
        }
        n5 = OS.CreateBitmap(n6, n7, 1, 1, imageData2.data);
        if (n6 != n2 || n7 != n3) {
            n4 = OS.GetDC(0);
            int n9 = OS.CreateCompatibleDC(n4);
            OS.SelectObject(n9, n5);
            int n10 = OS.CreateCompatibleDC(n4);
            int n11 = OS.CreateBitmap(n2, n3, 1, 1, null);
            OS.SelectObject(n10, n11);
            if (!OS.IsWinCE) {
                OS.SetStretchBltMode(n10, 3);
            }
            OS.StretchBlt(n10, 0, 0, n2, n3, n9, 0, 0, n6, n7, 0xCC0020);
            OS.DeleteDC(n9);
            OS.DeleteDC(n10);
            OS.ReleaseDC(0, n4);
            OS.DeleteObject(n5);
            n5 = n11;
        }
        return n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deregister(Display display) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            for (int i2 = 0; i2 < Displays.length; ++i2) {
                if (display != Displays[i2]) continue;
                Display.Displays[i2] = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    protected void destroy() {
        if (this == Default) {
            Default = null;
        }
        Display.deregister(this);
        this.destroyDisplay();
    }

    void destroyDisplay() {
    }

    public void disposeExec(Runnable runnable) {
        this.checkDevice();
        if (this.disposeList == null) {
            this.disposeList = new Runnable[4];
        }
        for (int i2 = 0; i2 < this.disposeList.length; ++i2) {
            if (this.disposeList[i2] != null) continue;
            this.disposeList[i2] = runnable;
            return;
        }
        Runnable[] runnableArray = new Runnable[this.disposeList.length + 4];
        System.arraycopy(this.disposeList, 0, runnableArray, 0, this.disposeList.length);
        runnableArray[this.disposeList.length] = runnable;
        this.disposeList = runnableArray;
    }

    void drawMenuBars() {
        if (this.bars == null) {
            return;
        }
        for (int i2 = 0; i2 < this.bars.length; ++i2) {
            Menu menu = this.bars[i2];
            if (menu == null || menu.isDisposed()) continue;
            menu.update();
        }
        this.bars = null;
    }

    int embeddedProc(int n2, int n3, int n4, int n5) {
        switch (n3) {
            case 32770: {
                MSG mSG = new MSG();
                OS.MoveMemory(mSG, n5, MSG.sizeof);
                OS.TranslateMessage(mSG);
                OS.DispatchMessage(mSG);
                int n6 = OS.GetProcessHeap();
                OS.HeapFree(n6, 0, n5);
                break;
            }
            case 32771: {
                OS.DestroyWindow(n2);
                if (this.embeddedCallback != null) {
                    this.embeddedCallback.dispose();
                }
                if (this.getMsgCallback != null) {
                    this.getMsgCallback.dispose();
                }
                this.getMsgCallback = null;
                this.embeddedCallback = null;
                this.getMsgProc = 0;
                this.embeddedProc = 0;
            }
        }
        return OS.DefWindowProc(n2, n3, n4, n5);
    }

    void error(int n2) {
        SWT.error(n2);
    }

    boolean filterEvent(Event event) {
        if (this.filterTable != null) {
            int n2 = event.type;
            this.sendPreEvent(n2);
            try {
                this.filterTable.sendEvent(event);
            }
            finally {
                this.sendPostEvent(n2);
            }
        }
        return false;
    }

    boolean filters(int n2) {
        if (this.filterTable == null) {
            return false;
        }
        return this.filterTable.hooks(n2);
    }

    boolean filterMessage(MSG mSG) {
        Control control;
        int n2 = mSG.message;
        if (256 <= n2 && n2 <= 264 && (control = this.findControl(mSG.hwnd)) != null && (this.translateAccelerator(mSG, control) || this.translateMnemonic(mSG, control) || this.translateTraversal(mSG, control))) {
            this.lastKey = 0;
            this.lastAscii = 0;
            this.lastDead = false;
            this.lastNull = false;
            this.lastVirtual = false;
            return true;
        }
        return false;
    }

    Control findControl(int n2) {
        if (n2 == 0) {
            return null;
        }
        int n3 = 0;
        do {
            Control control;
            if ((control = this.getControl(n2)) != null) {
                return control;
            }
            n3 = OS.GetWindow(n2, 4);
        } while ((n2 = OS.GetParent(n2)) != 0 && n2 != n3);
        return null;
    }

    public Widget findWidget(int n2) {
        this.checkDevice();
        return this.getControl(n2);
    }

    public Widget findWidget(int n2, int n3) {
        this.checkDevice();
        Control control = this.getControl(n2);
        return control != null ? control.findItem(n3) : null;
    }

    public Widget findWidget(Widget widget, int n2) {
        this.checkDevice();
        if (widget instanceof Control) {
            return this.findWidget(((Control)widget).handle, n2);
        }
        return null;
    }

    int foregroundIdleProc(int n2, int n3, int n4) {
        if (n2 >= 0 && this.runMessages && this.getMessageCount() != 0) {
            int n5;
            MSG mSG;
            this.sendPostExternalEventDispatchEvent();
            if (this.runMessagesInIdle) {
                if (this.runMessagesInMessageProc) {
                    OS.PostMessage(this.hwndMessage, 32774, 0, 0);
                } else {
                    this.runAsyncMessages(false);
                }
            }
            if (!OS.PeekMessage(mSG = new MSG(), 0, 0, 0, n5 = 458754)) {
                this.wakeThread();
            }
            this.sendPreExternalEventDispatchEvent();
        }
        return OS.CallNextHookEx(this.idleHook, n2, n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display findDisplay(Thread thread) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            for (int i2 = 0; i2 < Displays.length; ++i2) {
                Display display = Displays[i2];
                if (display == null || display.thread != thread) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return display;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    TouchSource findTouchSource(int n2, Monitor monitor) {
        int n3;
        if (this.touchSources == null) {
            this.touchSources = new TouchSource[4];
        }
        int n4 = this.touchSources.length;
        for (n3 = 0; n3 < n4; ++n3) {
            if (this.touchSources[n3] == null || this.touchSources[n3].handle != n2) continue;
            return this.touchSources[n3];
        }
        for (n3 = 0; n3 < n4 && this.touchSources[n3] != null; ++n3) {
        }
        if (n3 == n4) {
            TouchSource[] touchSourceArray = new TouchSource[n4 + 4];
            System.arraycopy(this.touchSources, 0, touchSourceArray, 0, n4);
            this.touchSources = touchSourceArray;
        }
        this.touchSources[n3] = new TouchSource(n2, true, monitor.getBounds());
        return this.touchSources[n3];
    }

    public Shell getActiveShell() {
        this.checkDevice();
        Control control = this.findControl(OS.GetActiveWindow());
        return control != null ? control.getShell() : null;
    }

    public Menu getMenuBar() {
        this.checkDevice();
        return null;
    }

    @Override
    public Rectangle getBounds() {
        this.checkDevice();
        return DPIUtil.autoScaleDown(this.getBoundsInPixels());
    }

    Rectangle getBoundsInPixels() {
        this.checkDevice();
        if (OS.GetSystemMetrics(80) < 2) {
            int n2 = OS.GetSystemMetrics(0);
            int n3 = OS.GetSystemMetrics(1);
            return new Rectangle(0, 0, n2, n3);
        }
        int n4 = OS.GetSystemMetrics(76);
        int n5 = OS.GetSystemMetrics(77);
        int n6 = OS.GetSystemMetrics(78);
        int n7 = OS.GetSystemMetrics(79);
        return new Rectangle(n4, n5, n6, n7);
    }

    public static Display getCurrent() {
        return Display.findDisplay(Thread.currentThread());
    }

    int getClickCount(int n2, int n3, int n4, int n5) {
        switch (n2) {
            case 3: {
                int n6 = OS.GetDoubleClickTime();
                if (this.clickRect == null) {
                    this.clickRect = new RECT();
                }
                int n7 = Math.abs(this.lastTime - this.getLastEventTime());
                POINT pOINT = new POINT();
                OS.POINTSTOPOINT(pOINT, n5);
                this.clickCount = this.lastClickHwnd == n4 && this.lastButton == n3 && n7 <= n6 && OS.PtInRect(this.clickRect, pOINT) ? ++this.clickCount : 1;
            }
            case 8: {
                this.lastButton = n3;
                this.lastClickHwnd = n4;
                this.lastTime = this.getLastEventTime();
                int n8 = OS.GetSystemMetrics(36) / 2;
                int n9 = OS.GetSystemMetrics(37) / 2;
                int n10 = OS.GET_X_LPARAM(n5);
                int n11 = OS.GET_Y_LPARAM(n5);
                OS.SetRect(this.clickRect, n10 - n8, n11 - n9, n10 + n8, n11 + n9);
            }
            case 4: {
                return this.clickCount;
            }
        }
        return 0;
    }

    @Override
    public Rectangle getClientArea() {
        this.checkDevice();
        return DPIUtil.autoScaleDown(this.getClientAreaInPixels());
    }

    Rectangle getClientAreaInPixels() {
        this.checkDevice();
        if (OS.GetSystemMetrics(80) < 2) {
            RECT rECT = new RECT();
            OS.SystemParametersInfo(48, 0, rECT, 0);
            int n2 = rECT.right - rECT.left;
            int n3 = rECT.bottom - rECT.top;
            return new Rectangle(rECT.left, rECT.top, n2, n3);
        }
        int n4 = OS.GetSystemMetrics(76);
        int n5 = OS.GetSystemMetrics(77);
        int n6 = OS.GetSystemMetrics(78);
        int n7 = OS.GetSystemMetrics(79);
        return new Rectangle(n4, n5, n6, n7);
    }

    Control getControl(int n2) {
        Control control;
        if (n2 == 0) {
            return null;
        }
        if (this.lastControl != null && this.lastHwnd == n2) {
            return this.lastControl;
        }
        if (this.lastGetControl != null && this.lastGetHwnd == n2) {
            return this.lastGetControl;
        }
        int n3 = USE_PROPERTY ? OS.GetProp(n2, SWT_OBJECT_INDEX) - 1 : OS.GetWindowLongPtr(n2, -21) - 1;
        if (0 <= n3 && n3 < this.controlTable.length && (control = this.controlTable[n3]) != null && control.checkHandle(n2)) {
            this.lastGetHwnd = n2;
            this.lastGetControl = control;
            return control;
        }
        return null;
    }

    public Control getCursorControl() {
        this.checkDevice();
        POINT pOINT = new POINT();
        if (!OS.GetCursorPos(pOINT)) {
            return null;
        }
        return this.findControl(OS.WindowFromPoint(pOINT));
    }

    public Point getCursorLocation() {
        this.checkDevice();
        return DPIUtil.autoScaleDown(this.getCursorLocationInPixels());
    }

    Point getCursorLocationInPixels() {
        POINT pOINT = new POINT();
        OS.GetCursorPos(pOINT);
        return new Point(pOINT.x, pOINT.y);
    }

    public Point[] getCursorSizes() {
        this.checkDevice();
        return new Point[]{new Point(OS.GetSystemMetrics(13), OS.GetSystemMetrics(14))};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display getDefault() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (Default == null) {
                Default = new Display();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return Default;
        }
    }

    static boolean isValidClass(Class clazz) {
        String string = clazz.getName();
        int n2 = string.lastIndexOf(46);
        return string.substring(0, n2 + 1).equals(PACKAGE_PREFIX);
    }

    public Object getData(String string) {
        this.checkDevice();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(RUN_MESSAGES_IN_IDLE_KEY)) {
            return new Boolean(this.runMessagesInIdle);
        }
        if (string.equals(RUN_MESSAGES_IN_MESSAGE_PROC_KEY)) {
            return new Boolean(this.runMessagesInMessageProc);
        }
        if (string.equals(USE_OWNDC_KEY)) {
            return new Boolean(this.useOwnDC);
        }
        if (string.equals(ACCEL_KEY_HIT)) {
            return new Boolean(this.accelKeyHit);
        }
        if (this.keys == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.keys.length; ++i2) {
            if (!this.keys[i2].equals(string)) continue;
            return this.values[i2];
        }
        return null;
    }

    public Object getData() {
        this.checkDevice();
        return this.data;
    }

    public int getDismissalAlignment() {
        this.checkDevice();
        return 16384;
    }

    public int getDoubleClickTime() {
        this.checkDevice();
        return OS.GetDoubleClickTime();
    }

    public Control getFocusControl() {
        this.checkDevice();
        if (this.focusControl != null && !this.focusControl.isDisposed()) {
            return this.focusControl;
        }
        return this._getFocusControl();
    }

    String getFontName(LOGFONT lOGFONT) {
        int n2;
        char[] cArray;
        if (OS.IsUnicode) {
            cArray = ((LOGFONTW)lOGFONT).lfFaceName;
        } else {
            cArray = new char[32];
            byte[] byArray = ((LOGFONTA)lOGFONT).lfFaceName;
            OS.MultiByteToWideChar(0, 1, byArray, byArray.length, cArray, cArray.length);
        }
        for (n2 = 0; n2 < cArray.length && cArray[n2] != '\u0000'; ++n2) {
        }
        return new String(cArray, 0, n2);
    }

    public boolean getHighContrast() {
        this.checkDevice();
        if (OS.IsWinCE) {
            return false;
        }
        HIGHCONTRAST hIGHCONTRAST = new HIGHCONTRAST();
        hIGHCONTRAST.cbSize = HIGHCONTRAST.sizeof;
        OS.SystemParametersInfo(66, 0, hIGHCONTRAST, 0);
        return (hIGHCONTRAST.dwFlags & 1) != 0;
    }

    public int getIconDepth() {
        TCHAR tCHAR;
        this.checkDevice();
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(5, 1) && this.getDepth() >= 24) {
            return 32;
        }
        TCHAR tCHAR2 = new TCHAR(0, "Control Panel\\Desktop\\WindowMetrics", true);
        int[] nArray = new int[1];
        int n2 = OS.RegOpenKeyEx(-2147483647, tCHAR2, 0, 131097, nArray);
        if (n2 != 0) {
            return 4;
        }
        int n3 = 4;
        TCHAR tCHAR3 = new TCHAR(0, "Shell Icon BPP", true);
        int[] nArray2 = new int[1];
        n2 = OS.RegQueryValueEx(nArray[0], tCHAR3, 0, null, (TCHAR)null, nArray2);
        if (n2 == 0 && (n2 = OS.RegQueryValueEx(nArray[0], tCHAR3, 0, null, tCHAR = new TCHAR(0, nArray2[0] / TCHAR.sizeof), nArray2)) == 0) {
            try {
                n3 = Integer.parseInt(tCHAR.toString(0, tCHAR.strlen()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        OS.RegCloseKey(nArray[0]);
        return n3;
    }

    public Point[] getIconSizes() {
        this.checkDevice();
        return new Point[]{new Point(OS.GetSystemMetrics(49), OS.GetSystemMetrics(50)), new Point(OS.GetSystemMetrics(11), OS.GetSystemMetrics(12))};
    }

    ImageList getImageList(int n2, int n3, int n4) {
        Object object;
        int n5;
        if (this.imageList == null) {
            this.imageList = new ImageList[4];
        }
        int n6 = this.imageList.length;
        for (n5 = 0; n5 < n6 && (object = this.imageList[n5]) != null; ++n5) {
            Point point = ((ImageList)object).getImageSize();
            if (point.x != n3 || point.y != n4 || ((ImageList)object).getStyle() != n2) continue;
            ((ImageList)object).addRef();
            return object;
        }
        if (n5 == n6) {
            object = new ImageList[n6 + 4];
            System.arraycopy(this.imageList, 0, object, 0, n6);
            this.imageList = object;
        }
        this.imageList[n5] = object = new ImageList(n2, n3, n4);
        ((ImageList)object).addRef();
        return object;
    }

    ImageList getImageListToolBar(int n2, int n3, int n4) {
        Object object;
        int n5;
        if (this.toolImageList == null) {
            this.toolImageList = new ImageList[4];
        }
        int n6 = this.toolImageList.length;
        for (n5 = 0; n5 < n6 && (object = this.toolImageList[n5]) != null; ++n5) {
            Point point = ((ImageList)object).getImageSize();
            if (point.x != n3 || point.y != n4 || ((ImageList)object).getStyle() != n2) continue;
            ((ImageList)object).addRef();
            return object;
        }
        if (n5 == n6) {
            object = new ImageList[n6 + 4];
            System.arraycopy(this.toolImageList, 0, object, 0, n6);
            this.toolImageList = object;
        }
        this.toolImageList[n5] = object = new ImageList(n2, n3, n4);
        ((ImageList)object).addRef();
        return object;
    }

    ImageList getImageListToolBarDisabled(int n2, int n3, int n4) {
        Object object;
        int n5;
        if (this.toolDisabledImageList == null) {
            this.toolDisabledImageList = new ImageList[4];
        }
        int n6 = this.toolDisabledImageList.length;
        for (n5 = 0; n5 < n6 && (object = this.toolDisabledImageList[n5]) != null; ++n5) {
            Point point = ((ImageList)object).getImageSize();
            if (point.x != n3 || point.y != n4 || ((ImageList)object).getStyle() != n2) continue;
            ((ImageList)object).addRef();
            return object;
        }
        if (n5 == n6) {
            object = new ImageList[n6 + 4];
            System.arraycopy(this.toolDisabledImageList, 0, object, 0, n6);
            this.toolDisabledImageList = object;
        }
        this.toolDisabledImageList[n5] = object = new ImageList(n2, n3, n4);
        ((ImageList)object).addRef();
        return object;
    }

    ImageList getImageListToolBarHot(int n2, int n3, int n4) {
        Object object;
        int n5;
        if (this.toolHotImageList == null) {
            this.toolHotImageList = new ImageList[4];
        }
        int n6 = this.toolHotImageList.length;
        for (n5 = 0; n5 < n6 && (object = this.toolHotImageList[n5]) != null; ++n5) {
            Point point = ((ImageList)object).getImageSize();
            if (point.x != n3 || point.y != n4 || ((ImageList)object).getStyle() != n2) continue;
            ((ImageList)object).addRef();
            return object;
        }
        if (n5 == n6) {
            object = new ImageList[n6 + 4];
            System.arraycopy(this.toolHotImageList, 0, object, 0, n6);
            this.toolHotImageList = object;
        }
        this.toolHotImageList[n5] = object = new ImageList(n2, n3, n4);
        ((ImageList)object).addRef();
        return object;
    }

    int getLastEventTime() {
        return OS.IsWinCE ? OS.GetTickCount() : OS.GetMessageTime();
    }

    MenuItem getMenuItem(int n2) {
        if (this.items == null) {
            return null;
        }
        if (0 <= (n2 -= 108) && n2 < this.items.length) {
            return this.items[n2];
        }
        return null;
    }

    int getMessageCount() {
        return this.synchronizer.getMessageCount();
    }

    Shell getModalShell() {
        if (this.modalShells == null) {
            return null;
        }
        int n2 = this.modalShells.length;
        while (--n2 >= 0) {
            Shell shell = this.modalShells[n2];
            if (shell == null) continue;
            return shell;
        }
        return null;
    }

    Dialog getModalDialog() {
        return this.modalDialog;
    }

    public Monitor[] getMonitors() {
        this.checkDevice();
        if (OS.IsWinCE || OS.WIN32_VERSION < OS.VERSION(4, 10)) {
            return new Monitor[]{this.getPrimaryMonitor()};
        }
        this.monitors = new Monitor[4];
        Callback callback = new Callback(this, "monitorEnumProc", 4);
        int n2 = callback.getAddress();
        if (n2 == 0) {
            this.error(3);
        }
        OS.EnumDisplayMonitors(0, null, n2, 0);
        callback.dispose();
        Monitor[] monitorArray = new Monitor[this.monitorCount];
        System.arraycopy(this.monitors, 0, monitorArray, 0, this.monitorCount);
        this.monitors = null;
        this.monitorCount = 0;
        return monitorArray;
    }

    int getMsgProc(int n2, int n3, int n4) {
        if (this.embeddedHwnd == 0) {
            int n5 = OS.GetModuleHandle(null);
            this.embeddedHwnd = OS.CreateWindowEx(0, this.windowClass, null, OS.WS_OVERLAPPED, 0, 0, 0, 0, 0, 0, n5, null);
            this.embeddedCallback = new Callback(this, "embeddedProc", 4);
            this.embeddedProc = this.embeddedCallback.getAddress();
            if (this.embeddedProc == 0) {
                this.error(3);
            }
            OS.SetWindowLongPtr(this.embeddedHwnd, -4, this.embeddedProc);
        }
        if (n2 >= 0 && (n3 & 1) != 0) {
            MSG mSG = new MSG();
            OS.MoveMemory(mSG, n4, MSG.sizeof);
            block0 : switch (mSG.message) {
                case 256: 
                case 257: 
                case 260: 
                case 261: {
                    Control control = this.findControl(mSG.hwnd);
                    if (control == null) break;
                    int n6 = OS.GetProcessHeap();
                    int n7 = OS.HeapAlloc(n6, 8, MSG.sizeof);
                    OS.MoveMemory(n7, mSG, MSG.sizeof);
                    OS.PostMessage(this.hwndMessage, 32770, n3, n7);
                    switch (mSG.wParam) {
                        case 16: 
                        case 17: 
                        case 18: 
                        case 20: 
                        case 144: 
                        case 145: {
                            break block0;
                        }
                    }
                    mSG.message = 0;
                    OS.MoveMemory(n4, mSG, MSG.sizeof);
                }
            }
        }
        return OS.CallNextHookEx(this.msgHook, n2, n3, n4);
    }

    public Monitor getPrimaryMonitor() {
        this.checkDevice();
        if (OS.IsWinCE || OS.WIN32_VERSION < OS.VERSION(4, 10)) {
            Monitor monitor = new Monitor();
            int n2 = OS.GetSystemMetrics(0);
            int n3 = OS.GetSystemMetrics(1);
            Rectangle rectangle = new Rectangle(0, 0, n2, n3);
            rectangle = DPIUtil.autoScaleDown(rectangle);
            monitor.setBounds(rectangle);
            RECT rECT = new RECT();
            OS.SystemParametersInfo(48, 0, rECT, 0);
            Rectangle rectangle2 = new Rectangle(rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top);
            rectangle2 = DPIUtil.autoScaleDown(rectangle2);
            monitor.setClientArea(rectangle2);
            return monitor;
        }
        this.monitors = new Monitor[4];
        Callback callback = new Callback(this, "monitorEnumProc", 4);
        int n4 = callback.getAddress();
        if (n4 == 0) {
            this.error(3);
        }
        OS.EnumDisplayMonitors(0, null, n4, 0);
        callback.dispose();
        Monitor monitor = null;
        MONITORINFO mONITORINFO = new MONITORINFO();
        mONITORINFO.cbSize = MONITORINFO.sizeof;
        for (int i2 = 0; i2 < this.monitorCount; ++i2) {
            Monitor monitor2 = this.monitors[i2];
            OS.GetMonitorInfo(this.monitors[i2].handle, mONITORINFO);
            if ((mONITORINFO.dwFlags & 1) == 0) continue;
            monitor = monitor2;
            break;
        }
        this.monitors = null;
        this.monitorCount = 0;
        return monitor;
    }

    public Shell[] getShells() {
        this.checkDevice();
        int n2 = 0;
        Shell[] shellArray = new Shell[16];
        for (int i2 = 0; i2 < this.controlTable.length; ++i2) {
            int n3;
            Control control = this.controlTable[i2];
            if (control == null || !(control instanceof Shell)) continue;
            for (n3 = 0; n3 < n2 && shellArray[n3] != control; ++n3) {
            }
            if (n3 != n2) continue;
            if (n2 == shellArray.length) {
                Shell[] shellArray2 = new Shell[n2 + 16];
                System.arraycopy(shellArray, 0, shellArray2, 0, n2);
                shellArray = shellArray2;
            }
            shellArray[n2++] = (Shell)control;
        }
        if (n2 == shellArray.length) {
            return shellArray;
        }
        Shell[] shellArray3 = new Shell[n2];
        System.arraycopy(shellArray, 0, shellArray3, 0, n2);
        return shellArray3;
    }

    Image getSortImage(int n2) {
        switch (n2) {
            case 128: {
                if (this.upArrow != null) {
                    return this.upArrow;
                }
                Color color = this.getSystemColor(18);
                Color color2 = this.getSystemColor(20);
                Color color3 = this.getSystemColor(22);
                PaletteData paletteData = new PaletteData(color.getRGB(), color2.getRGB(), color3.getRGB());
                ImageData imageData = new ImageData(8, 8, 4, paletteData);
                imageData.transparentPixel = 2;
                this.upArrow = new Image((Device)this, imageData);
                GC gC = new GC(this.upArrow);
                gC.setBackground(color3);
                gC.fillRectangle(0, 0, 8, 8);
                gC.setForeground(color);
                int[] nArray = new int[]{0, 6, 1, 6, 1, 4, 2, 4, 2, 2, 3, 2, 3, 1};
                gC.drawPolyline(nArray);
                gC.setForeground(color2);
                int[] nArray2 = new int[]{0, 7, 7, 7, 7, 6, 6, 6, 6, 4, 5, 4, 5, 2, 4, 2, 4, 1};
                gC.drawPolyline(nArray2);
                gC.dispose();
                return this.upArrow;
            }
            case 1024: {
                if (this.downArrow != null) {
                    return this.downArrow;
                }
                Color color = this.getSystemColor(18);
                Color color4 = this.getSystemColor(20);
                Color color5 = this.getSystemColor(22);
                PaletteData paletteData = new PaletteData(color.getRGB(), color4.getRGB(), color5.getRGB());
                ImageData imageData = new ImageData(8, 8, 4, paletteData);
                imageData.transparentPixel = 2;
                this.downArrow = new Image((Device)this, imageData);
                GC gC = new GC(this.downArrow);
                gC.setBackground(color5);
                gC.fillRectangle(0, 0, 8, 8);
                gC.setForeground(color);
                int[] nArray = new int[]{7, 0, 0, 0, 0, 1, 1, 1, 1, 3, 2, 3, 2, 5, 3, 5, 3, 6};
                gC.drawPolyline(nArray);
                gC.setForeground(color4);
                int[] nArray3 = new int[]{4, 6, 4, 5, 5, 5, 5, 3, 6, 3, 6, 1, 7, 1};
                gC.drawPolyline(nArray3);
                gC.dispose();
                return this.downArrow;
            }
        }
        return null;
    }

    public Synchronizer getSynchronizer() {
        this.checkDevice();
        return this.synchronizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getSyncThread() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.synchronizer.syncThread;
        }
    }

    @Override
    public Color getSystemColor(int n2) {
        this.checkDevice();
        int n3 = 0;
        switch (n2) {
            case 17: {
                n3 = OS.GetSysColor(OS.COLOR_3DDKSHADOW);
                break;
            }
            case 18: {
                n3 = OS.GetSysColor(OS.COLOR_3DSHADOW);
                break;
            }
            case 19: {
                n3 = OS.GetSysColor(OS.COLOR_3DLIGHT);
                break;
            }
            case 20: {
                n3 = OS.GetSysColor(OS.COLOR_3DHIGHLIGHT);
                break;
            }
            case 22: {
                n3 = OS.GetSysColor(OS.COLOR_3DFACE);
                break;
            }
            case 23: {
                n3 = OS.GetSysColor(OS.COLOR_WINDOWFRAME);
                break;
            }
            case 21: 
            case 24: {
                n3 = OS.GetSysColor(OS.COLOR_WINDOWTEXT);
                break;
            }
            case 25: {
                n3 = OS.GetSysColor(OS.COLOR_WINDOW);
                break;
            }
            case 26: {
                n3 = OS.GetSysColor(OS.COLOR_HIGHLIGHT);
                break;
            }
            case 27: {
                n3 = OS.GetSysColor(OS.COLOR_HIGHLIGHTTEXT);
                break;
            }
            case 36: {
                n3 = OS.GetSysColor(OS.COLOR_HOTLIGHT);
                break;
            }
            case 28: {
                n3 = OS.GetSysColor(OS.COLOR_INFOTEXT);
                break;
            }
            case 29: {
                n3 = OS.GetSysColor(OS.COLOR_INFOBK);
                break;
            }
            case 30: {
                n3 = OS.GetSysColor(OS.COLOR_CAPTIONTEXT);
                break;
            }
            case 31: {
                n3 = OS.GetSysColor(OS.COLOR_ACTIVECAPTION);
                break;
            }
            case 32: {
                n3 = OS.GetSysColor(OS.COLOR_GRADIENTACTIVECAPTION);
                if (n3 != 0) break;
                n3 = OS.GetSysColor(OS.COLOR_ACTIVECAPTION);
                break;
            }
            case 33: {
                n3 = OS.GetSysColor(OS.COLOR_INACTIVECAPTIONTEXT);
                break;
            }
            case 34: {
                n3 = OS.GetSysColor(OS.COLOR_INACTIVECAPTION);
                break;
            }
            case 35: {
                n3 = OS.GetSysColor(OS.COLOR_GRADIENTINACTIVECAPTION);
                if (n3 != 0) break;
                n3 = OS.GetSysColor(OS.COLOR_INACTIVECAPTION);
                break;
            }
            default: {
                return super.getSystemColor(n2);
            }
        }
        return Color.win32_new(this, n3);
    }

    public Cursor getSystemCursor(int n2) {
        this.checkDevice();
        if (0 > n2 || n2 >= this.cursors.length) {
            return null;
        }
        if (this.cursors[n2] == null) {
            this.cursors[n2] = new Cursor(this, n2);
        }
        return this.cursors[n2];
    }

    @Override
    public Font getSystemFont() {
        this.checkDevice();
        if (this.systemFont != null) {
            return this.systemFont;
        }
        int n2 = 0;
        if (!OS.IsWinCE) {
            NONCLIENTMETRICS nONCLIENTMETRICS = OS.IsUnicode ? new NONCLIENTMETRICSW() : new NONCLIENTMETRICSA();
            nONCLIENTMETRICS.cbSize = NONCLIENTMETRICS.sizeof;
            if (OS.SystemParametersInfo(41, 0, nONCLIENTMETRICS, 0)) {
                LOGFONT lOGFONT = OS.IsUnicode ? nONCLIENTMETRICS.lfMessageFont : ((NONCLIENTMETRICSA)nONCLIENTMETRICS).lfMessageFont;
                n2 = OS.CreateFontIndirect(lOGFONT);
                LOGFONT lOGFONT2 = this.lfSystemFont = n2 != 0 ? lOGFONT : null;
            }
        }
        if (n2 == 0) {
            n2 = OS.GetStockObject(17);
        }
        if (n2 == 0) {
            n2 = OS.GetStockObject(13);
        }
        this.systemFont = Font.win32_new(this, n2);
        return this.systemFont;
    }

    public Image getSystemImage(int n2) {
        this.checkDevice();
        switch (n2) {
            case 1: {
                if (this.errorImage != null) {
                    return this.errorImage;
                }
                int n3 = OS.LoadImage(0, 32513, 1, 0, 0, 32768);
                this.errorImage = Image.win32_new(this, 1, n3);
                return this.errorImage;
            }
            case 2: 
            case 16: {
                if (this.infoImage != null) {
                    return this.infoImage;
                }
                int n4 = OS.LoadImage(0, 32516, 1, 0, 0, 32768);
                this.infoImage = Image.win32_new(this, 1, n4);
                return this.infoImage;
            }
            case 4: {
                if (this.questionImage != null) {
                    return this.questionImage;
                }
                int n5 = OS.LoadImage(0, 32514, 1, 0, 0, 32768);
                this.questionImage = Image.win32_new(this, 1, n5);
                return this.questionImage;
            }
            case 8: {
                if (this.warningIcon != null) {
                    return this.warningIcon;
                }
                int n6 = OS.LoadImage(0, 32515, 1, 0, 0, 32768);
                this.warningIcon = Image.win32_new(this, 1, n6);
                return this.warningIcon;
            }
        }
        return null;
    }

    public Menu getSystemMenu() {
        this.checkDevice();
        return null;
    }

    public TaskBar getSystemTaskBar() {
        this.checkDevice();
        if (this.taskBar != null) {
            return this.taskBar;
        }
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 1)) {
            this.taskBar = new TaskBar(this, 0);
        }
        return this.taskBar;
    }

    public Tray getSystemTray() {
        this.checkDevice();
        if (this.tray != null) {
            return this.tray;
        }
        if (!OS.IsWinCE) {
            this.tray = new Tray(this, 0);
        }
        return this.tray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getThread() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.thread;
        }
    }

    public boolean getTouchEnabled() {
        this.checkDevice();
        int n2 = OS.GetSystemMetrics(94);
        return (n2 & 0xC0) == 192;
    }

    int hButtonTheme() {
        if (this.hButtonTheme != 0) {
            return this.hButtonTheme;
        }
        this.hButtonTheme = OS.OpenThemeData(this.hwndMessage, BUTTON);
        return this.hButtonTheme;
    }

    int hEditTheme() {
        if (this.hEditTheme != 0) {
            return this.hEditTheme;
        }
        this.hEditTheme = OS.OpenThemeData(this.hwndMessage, EDIT);
        return this.hEditTheme;
    }

    int hExplorerBarTheme() {
        if (this.hExplorerBarTheme != 0) {
            return this.hExplorerBarTheme;
        }
        this.hExplorerBarTheme = OS.OpenThemeData(this.hwndMessage, EXPLORERBAR);
        return this.hExplorerBarTheme;
    }

    int hScrollBarTheme() {
        if (this.hScrollBarTheme != 0) {
            return this.hScrollBarTheme;
        }
        this.hScrollBarTheme = OS.OpenThemeData(this.hwndMessage, SCROLLBAR);
        return this.hScrollBarTheme;
    }

    int hTabTheme() {
        if (this.hTabTheme != 0) {
            return this.hTabTheme;
        }
        this.hTabTheme = OS.OpenThemeData(this.hwndMessage, TAB);
        return this.hTabTheme;
    }

    @Override
    public int internal_new_GC(GCData gCData) {
        int n2;
        if (this.isDisposed()) {
            this.error(45);
        }
        if ((n2 = OS.GetDC(0)) == 0) {
            this.error(2);
        }
        if (gCData != null) {
            int n3 = 0x6000000;
            if ((gCData.style & n3) != 0) {
                gCData.layout = (gCData.style & 0x4000000) != 0 ? 1 : 0;
            } else {
                gCData.style |= 0x2000000;
            }
            gCData.device = this;
            gCData.font = this.getSystemFont();
        }
        return n2;
    }

    @Override
    protected void init() {
        int[] nArray;
        int n2;
        String string;
        int n3;
        super.init();
        DPIUtil.setDeviceZoom(this.getDeviceZoom());
        char[] cArray = null;
        if (APP_NAME != null && !"SWT".equalsIgnoreCase(APP_NAME) && !OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 1)) {
            n3 = APP_NAME.length();
            cArray = new char[n3 + 1];
            APP_NAME.getChars(0, n3, cArray, 0);
            int[] nArray2 = new int[1];
            if (OS.GetCurrentProcessExplicitAppUserModelID(nArray2) != 0) {
                OS.SetCurrentProcessExplicitAppUserModelID(cArray);
            }
            if (nArray2[0] != 0) {
                OS.CoTaskMemFree(nArray2[0]);
            }
        }
        this.windowCallback = new Callback(this, "windowProc", 4);
        this.windowProc = this.windowCallback.getAddress();
        if (this.windowProc == 0) {
            this.error(3);
        }
        this.threadId = OS.GetCurrentThreadId();
        this.windowClass = new TCHAR(0, WindowName + WindowClassCount, true);
        this.windowShadowClass = new TCHAR(0, WindowShadowName + WindowClassCount, true);
        this.windowOwnDCClass = new TCHAR(0, WindowOwnDCName + WindowClassCount, true);
        ++WindowClassCount;
        n3 = OS.GetProcessHeap();
        int n4 = OS.GetModuleHandle(null);
        WNDCLASS wNDCLASS = new WNDCLASS();
        wNDCLASS.hInstance = n4;
        wNDCLASS.lpfnWndProc = this.windowProc;
        wNDCLASS.style = 8200;
        wNDCLASS.hCursor = OS.LoadCursor(0, 32512);
        if (!OS.IsWinCE) {
            TCHAR tCHAR = new TCHAR(0, 260);
            while (OS.GetModuleFileName(0, tCHAR, tCHAR.length()) == tCHAR.length()) {
                tCHAR = new TCHAR(0, tCHAR.length() + 260);
            }
            if (OS.ExtractIconEx(tCHAR, -1, null, null, 1) != 0 && ((string = tCHAR.toString(0, tCHAR.strlen())).endsWith("java.exe") || string.endsWith("javaw.exe"))) {
                wNDCLASS.hIcon = OS.LoadIcon(0, 32512);
            }
        }
        int n5 = this.windowClass.length() * TCHAR.sizeof;
        wNDCLASS.lpszClassName = OS.HeapAlloc(n3, 8, n5);
        OS.MoveMemory(wNDCLASS.lpszClassName, this.windowClass, n5);
        OS.RegisterClass(wNDCLASS);
        OS.HeapFree(n3, 0, wNDCLASS.lpszClassName);
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(5, 1)) {
            wNDCLASS.style |= 0x20000;
        }
        n5 = this.windowShadowClass.length() * TCHAR.sizeof;
        wNDCLASS.lpszClassName = OS.HeapAlloc(n3, 8, n5);
        OS.MoveMemory(wNDCLASS.lpszClassName, this.windowShadowClass, n5);
        OS.RegisterClass(wNDCLASS);
        OS.HeapFree(n3, 0, wNDCLASS.lpszClassName);
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(5, 1)) {
            wNDCLASS.style |= 0x20;
        }
        n5 = this.windowOwnDCClass.length() * TCHAR.sizeof;
        wNDCLASS.lpszClassName = OS.HeapAlloc(n3, 8, n5);
        OS.MoveMemory(wNDCLASS.lpszClassName, this.windowOwnDCClass, n5);
        OS.RegisterClass(wNDCLASS);
        OS.HeapFree(n3, 0, wNDCLASS.lpszClassName);
        this.hwndMessage = OS.CreateWindowEx(0, this.windowClass, null, OS.WS_OVERLAPPED, 0, 0, 0, 0, 0, 0, n4, null);
        string = "SWT_Window_" + APP_NAME;
        OS.SetWindowText(this.hwndMessage, new TCHAR(0, string, true));
        this.messageCallback = new Callback(this, "messageProc", 4);
        this.messageProc = this.messageCallback.getAddress();
        if (this.messageProc == 0) {
            this.error(3);
        }
        OS.SetWindowLongPtr(this.hwndMessage, -4, this.messageProc);
        if (!OS.IsWinCE) {
            this.msgFilterCallback = new Callback(this, "msgFilterProc", 3);
            this.msgFilterProc = this.msgFilterCallback.getAddress();
            if (this.msgFilterProc == 0) {
                this.error(3);
            }
            this.filterHook = OS.SetWindowsHookEx(-1, this.msgFilterProc, 0, this.threadId);
        }
        if (!OS.IsWinCE) {
            this.foregroundIdleCallback = new Callback(this, "foregroundIdleProc", 3);
            this.foregroundIdleProc = this.foregroundIdleCallback.getAddress();
            if (this.foregroundIdleProc == 0) {
                this.error(3);
            }
            this.idleHook = OS.SetWindowsHookEx(11, this.foregroundIdleProc, 0, this.threadId);
        }
        TASKBARCREATED = OS.RegisterWindowMessage(new TCHAR(0, "TaskbarCreated", true));
        TASKBARBUTTONCREATED = OS.RegisterWindowMessage(new TCHAR(0, "TaskbarButtonCreated", true));
        SWT_RESTORECARET = OS.RegisterWindowMessage(new TCHAR(0, "SWT_RESTORECARET", true));
        DI_GETDRAGIMAGE = OS.RegisterWindowMessage(new TCHAR(0, "ShellGetDragImage", true));
        SWT_OPENDOC = OS.RegisterWindowMessage(new TCHAR(0, "SWT_OPENDOC", true));
        if (!OS.IsWinCE) {
            OS.OleInitialize(0);
        }
        if (cArray != null && (n2 = OS.CoCreateInstance(TaskBar.CLSID_DestinationList, 0, 1, TaskBar.IID_ICustomDestinationList, nArray = new int[1])) == 0) {
            OS.VtblCall(10, nArray[0], cArray);
            OS.VtblCall(2, nArray[0]);
        }
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
            OS.BufferedPaintInit();
        }
        this.indexTable = new int[1024];
        this.controlTable = new Control[1024];
        for (int i2 = 0; i2 < 1023; ++i2) {
            this.indexTable[i2] = i2 + 1;
        }
        this.indexTable[1023] = -1;
        this.lastHighContrast = this.getHighContrast();
    }

    @Override
    public void internal_dispose_GC(int n2, GCData gCData) {
        OS.ReleaseDC(0, n2);
    }

    boolean isXMouseActive() {
        boolean bl2 = false;
        TCHAR tCHAR = new TCHAR(0, "Control Panel\\Desktop", true);
        int[] nArray = new int[1];
        int n2 = OS.RegOpenKeyEx(-2147483647, tCHAR, 0, 131097, nArray);
        if (n2 == 0) {
            TCHAR tCHAR2 = new TCHAR(0, "UserPreferencesMask", true);
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[]{4};
            n2 = OS.RegQueryValueEx(nArray[0], tCHAR2, 0, null, nArray2, nArray3);
            if (n2 == 0) {
                bl2 = (nArray2[0] & 1) != 0;
            }
            OS.RegCloseKey(nArray[0]);
        }
        return bl2;
    }

    boolean isValidThread() {
        return this.thread == Thread.currentThread();
    }

    public Point map(Control control, Control control2, Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        point = DPIUtil.autoScaleUp(point);
        return DPIUtil.autoScaleDown(this.mapInPixels(control, control2, point));
    }

    Point mapInPixels(Control control, Control control2, Point point) {
        return this.mapInPixels(control, control2, point.x, point.y);
    }

    public Point map(Control control, Control control2, int n2, int n3) {
        this.checkDevice();
        n2 = DPIUtil.autoScaleUp(n2);
        n3 = DPIUtil.autoScaleUp(n3);
        return DPIUtil.autoScaleDown(this.mapInPixels(control, control2, n2, n3));
    }

    Point mapInPixels(Control control, Control control2, int n2, int n3) {
        if (control != null && control.isDisposed()) {
            this.error(5);
        }
        if (control2 != null && control2.isDisposed()) {
            this.error(5);
        }
        if (control == control2) {
            return new Point(n2, n3);
        }
        int n4 = control != null ? control.handle : 0;
        int n5 = control2 != null ? control2.handle : 0;
        POINT pOINT = new POINT();
        pOINT.x = n2;
        pOINT.y = n3;
        OS.MapWindowPoints(n4, n5, pOINT, 1);
        return new Point(pOINT.x, pOINT.y);
    }

    public Rectangle map(Control control, Control control2, Rectangle rectangle) {
        this.checkDevice();
        if (rectangle == null) {
            this.error(4);
        }
        rectangle = DPIUtil.autoScaleUp(rectangle);
        return DPIUtil.autoScaleDown(this.mapInPixels(control, control2, rectangle));
    }

    Rectangle mapInPixels(Control control, Control control2, Rectangle rectangle) {
        return this.mapInPixels(control, control2, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rectangle map(Control control, Control control2, int n2, int n3, int n4, int n5) {
        this.checkDevice();
        n2 = DPIUtil.autoScaleUp(n2);
        n3 = DPIUtil.autoScaleUp(n3);
        n4 = DPIUtil.autoScaleUp(n4);
        n5 = DPIUtil.autoScaleUp(n5);
        return DPIUtil.autoScaleDown(this.mapInPixels(control, control2, n2, n3, n4, n5));
    }

    Rectangle mapInPixels(Control control, Control control2, int n2, int n3, int n4, int n5) {
        if (control != null && control.isDisposed()) {
            this.error(5);
        }
        if (control2 != null && control2.isDisposed()) {
            this.error(5);
        }
        if (control == control2) {
            return new Rectangle(n2, n3, n4, n5);
        }
        int n6 = control != null ? control.handle : 0;
        int n7 = control2 != null ? control2.handle : 0;
        RECT rECT = new RECT();
        rECT.left = n2;
        rECT.top = n3;
        rECT.right = n2 + n4;
        rECT.bottom = n3 + n5;
        OS.MapWindowPoints(n6, n7, rECT, 2);
        return new Rectangle(rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top);
    }

    static char mbcsToWcs(int n2) {
        return Display.mbcsToWcs(n2, 0);
    }

    static char mbcsToWcs(int n2, int n3) {
        char[] cArray;
        byte[] byArray;
        if (OS.IsUnicode) {
            return (char)n2;
        }
        int n4 = n2 & 0xFFFF;
        if (n4 <= 127) {
            return (char)n2;
        }
        int n5 = n3 != 0 ? n3 : 0;
        int n6 = OS.MultiByteToWideChar(n5, 1, byArray = n4 <= 255 ? new byte[]{(byte)n4} : new byte[]{(byte)(n4 >> 8 & 0xFF), (byte)(n4 & 0xFF)}, byArray.length, cArray = new char[1], 1);
        if (n6 == 0) {
            return '\u0000';
        }
        return cArray[0];
    }

    int messageProc(int n2, int n3, int n4, int n5) {
        switch (n3) {
            case 32774: {
                if (!this.runMessagesInIdle) break;
                this.runAsyncMessages(false);
                break;
            }
            case 32770: {
                int n6;
                boolean bl2 = false;
                MSG mSG = new MSG();
                OS.MoveMemory(mSG, n5, MSG.sizeof);
                Control control = this.findControl(mSG.hwnd);
                if (control != null) {
                    int n7;
                    n6 = 0;
                    block12 : switch (mSG.message) {
                        case 256: 
                        case 260: {
                            if (OS.IsWinCE) break;
                            switch (mSG.wParam) {
                                case 16: 
                                case 17: 
                                case 18: 
                                case 20: 
                                case 144: 
                                case 145: {
                                    break block12;
                                }
                            }
                            n7 = OS.MapVirtualKey(mSG.wParam, 2);
                            if (n7 == 0) break;
                            int n8 = n6 = (n7 & (OS.IsWinNT ? Integer.MIN_VALUE : 32768)) != 0 ? 1 : 0;
                            if (n6 != 0) break;
                            for (int i2 = 0; i2 < ACCENTS.length; ++i2) {
                                short s2 = OS.VkKeyScan(ACCENTS[i2]);
                                if (s2 == -1 || (s2 & 0xFF) != mSG.wParam) continue;
                                int n9 = s2 >> 8;
                                if (OS.GetKeyState(16) < 0 != ((n9 & 1) != 0) || OS.GetKeyState(17) < 0 != ((n9 & 2) != 0) || OS.GetKeyState(18) < 0 != ((n9 & 4) != 0)) continue;
                                if ((n9 & 7) == 0) break block12;
                                n6 = 1;
                                break block12;
                            }
                            break;
                        }
                    }
                    if (n6 == 0 && !this.ignoreNextKey) {
                        mSG.hwnd = control.handle;
                        n7 = 10420227;
                        do {
                            if (bl2 |= this.filterMessage(mSG)) continue;
                            OS.TranslateMessage(mSG);
                            bl2 |= OS.DispatchMessage(mSG) == 1;
                        } while (OS.PeekMessage(mSG, mSG.hwnd, 256, 264, n7));
                    }
                    block18 : switch (mSG.message) {
                        case 256: 
                        case 260: {
                            switch (mSG.wParam) {
                                case 16: 
                                case 17: 
                                case 18: 
                                case 20: 
                                case 144: 
                                case 145: {
                                    break block18;
                                }
                            }
                            this.ignoreNextKey = n6;
                        }
                    }
                }
                switch (mSG.wParam) {
                    case 16: 
                    case 17: 
                    case 18: 
                    case 20: 
                    case 144: 
                    case 145: {
                        bl2 = true;
                    }
                }
                if (bl2) {
                    n6 = OS.GetProcessHeap();
                    OS.HeapFree(n6, 0, n5);
                } else {
                    OS.PostMessage(this.embeddedHwnd, 32770, n4, n5);
                }
                return 0;
            }
            case 32772: {
                if (this.tray != null) {
                    TrayItem[] trayItemArray = this.tray.items;
                    for (int i3 = 0; i3 < trayItemArray.length; ++i3) {
                        TrayItem trayItem = trayItemArray[i3];
                        if (trayItem == null || trayItem.id != n4) continue;
                        return trayItem.messageProc(n2, n3, n4, n5);
                    }
                }
                return 0;
            }
            case 28: {
                int n10;
                Shell shell;
                int n11;
                if (n4 == 0 || this.isXMouseActive() || (n11 = OS.GetActiveWindow()) != 0 && OS.IsWindowEnabled(n11)) break;
                Shell shell2 = shell = this.modalDialog != null ? this.modalDialog.parent : this.getModalShell();
                if (shell == null || shell.isDisposed()) break;
                int n12 = shell.handle;
                if (OS.IsWindowEnabled(n12)) {
                    shell.bringToTop();
                    if (shell.isDisposed()) break;
                }
                if ((n10 = OS.GetLastActivePopup(n12)) == 0 || n10 == shell.handle || this.getControl(n10) != null || !OS.IsWindowEnabled(n10)) break;
                OS.SetActiveWindow(n10);
                break;
            }
            case 22: {
                if (n4 == 0) break;
                this.dispose();
                break;
            }
            case 17: {
                Event event = new Event();
                this.sendEvent(21, event);
                if (event.doit) break;
                return 0;
            }
            case 800: {
                this.sendSettings = true;
            }
            case 26: {
                if (this.lastHighContrast != this.getHighContrast()) {
                    this.sendSettings = true;
                    this.lastHighContrast = this.getHighContrast();
                }
                if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                    this.sendSettings = true;
                }
                switch (n4) {
                    case 0: 
                    case 1: 
                    case 67: {
                        this.sendSettings = true;
                        this.lastHighContrast = this.getHighContrast();
                    }
                }
                if (!this.sendSettings) break;
                OS.SetTimer(this.hwndMessage, 100, 2000, 0);
                break;
            }
            case 794: {
                if (OS.COMCTL32_MAJOR < 6) break;
                if (this.hButtonTheme != 0) {
                    OS.CloseThemeData(this.hButtonTheme);
                }
                if (this.hEditTheme != 0) {
                    OS.CloseThemeData(this.hEditTheme);
                }
                if (this.hExplorerBarTheme != 0) {
                    OS.CloseThemeData(this.hExplorerBarTheme);
                }
                if (this.hScrollBarTheme != 0) {
                    OS.CloseThemeData(this.hScrollBarTheme);
                }
                if (this.hTabTheme != 0) {
                    OS.CloseThemeData(this.hTabTheme);
                }
                this.hTabTheme = 0;
                this.hScrollBarTheme = 0;
                this.hExplorerBarTheme = 0;
                this.hEditTheme = 0;
                this.hButtonTheme = 0;
                break;
            }
            case 275: {
                if (n4 == 100) {
                    this.sendSettings = false;
                    OS.KillTimer(this.hwndMessage, 100);
                    this.runSettings();
                    break;
                }
                this.runTimer(n4);
                break;
            }
            default: {
                Object object;
                if (n3 == TASKBARCREATED && this.tray != null) {
                    object = this.tray.items;
                    for (int i4 = 0; i4 < ((TrayItem[])object).length; ++i4) {
                        Object object2 = object[i4];
                        if (object2 == null) continue;
                        ((TrayItem)object2).recreate();
                    }
                }
                if (n3 != SWT_OPENDOC || (object = this.getSharedData(n4, n5)) == null) break;
                if (((String)object).startsWith(TASKBAR_EVENT)) {
                    String string = ((String)object).substring(TASKBAR_EVENT.length());
                    int n13 = Integer.parseInt(string);
                    MenuItem menuItem = this.getMenuItem(n13);
                    if (menuItem != null) {
                        menuItem.sendSelectionEvent(13);
                    }
                } else {
                    Event event = new Event();
                    event.text = object;
                    this.sendEvent(46, event);
                }
                this.wakeThread();
            }
        }
        return OS.DefWindowProc(n2, n3, n4, n5);
    }

    String getSharedData(int n2, int n3) {
        int n4;
        if (OS.IsWinCE) {
            return null;
        }
        int[] nArray = new int[1];
        if (n2 == OS.GetCurrentProcessId()) {
            nArray[0] = n3;
        } else {
            n4 = OS.OpenProcess(80, false, n2);
            if (n4 == 0) {
                return null;
            }
            OS.DuplicateHandle(n4, n3, OS.GetCurrentProcess(), nArray, 2, false, 2);
            OS.CloseHandle(n4);
        }
        n4 = OS.MapViewOfFile(nArray[0], 4, 0, 0, 0);
        if (n4 == 0) {
            return null;
        }
        int n5 = OS.IsUnicode ? OS.wcslen(n4) : OS.strlen(n4);
        TCHAR tCHAR = new TCHAR(0, n5);
        int n6 = tCHAR.length() * TCHAR.sizeof;
        OS.MoveMemory(tCHAR, n4, n6);
        String string = tCHAR.toString(0, n5);
        OS.UnmapViewOfFile(n4);
        if (n3 != nArray[0]) {
            OS.CloseHandle(nArray[0]);
        }
        return string;
    }

    int monitorEnumProc(int n2, int n3, int n4, int n5) {
        Monitor[] monitorArray;
        if (this.monitorCount >= this.monitors.length) {
            monitorArray = new Monitor[this.monitors.length + 4];
            System.arraycopy(this.monitors, 0, monitorArray, 0, this.monitors.length);
            this.monitors = monitorArray;
        }
        monitorArray = new MONITORINFO();
        monitorArray.cbSize = MONITORINFO.sizeof;
        OS.GetMonitorInfo(n2, (MONITORINFO)monitorArray);
        Monitor monitor = new Monitor();
        monitor.handle = n2;
        Rectangle rectangle = new Rectangle(monitorArray.rcMonitor_left, monitorArray.rcMonitor_top, monitorArray.rcMonitor_right - monitorArray.rcMonitor_left, monitorArray.rcMonitor_bottom - monitorArray.rcMonitor_top);
        monitor.setBounds(DPIUtil.autoScaleDown(rectangle));
        Rectangle rectangle2 = new Rectangle(monitorArray.rcWork_left, monitorArray.rcWork_top, monitorArray.rcWork_right - monitorArray.rcWork_left, monitorArray.rcWork_bottom - monitorArray.rcWork_top);
        monitor.setClientArea(DPIUtil.autoScaleDown(rectangle2));
        this.monitors[this.monitorCount++] = monitor;
        return 1;
    }

    int msgFilterProc(int n2, int n3, int n4) {
        switch (n2) {
            case 16896: {
                if (this.runDragDrop || this.dragCancelled) break;
                OS.MoveMemory(this.hookMsg, n4, MSG.sizeof);
                if (this.hookMsg.message != 512) break;
                this.dragCancelled = true;
                OS.SendMessage(this.hookMsg.hwnd, 31, 0, 0);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                int n5;
                MSG mSG;
                if (!this.runMessages) break;
                OS.MoveMemory(this.hookMsg, n4, MSG.sizeof);
                if (this.hookMsg.message != 0 || OS.PeekMessage(mSG = new MSG(), 0, 0, 0, n5 = 10420226) || !this.runAsyncMessages(false)) break;
                this.wakeThread();
            }
        }
        return OS.CallNextHookEx(this.filterHook, n2, n3, n4);
    }

    int numpadKey(int n2) {
        switch (n2) {
            case 96: {
                return 48;
            }
            case 97: {
                return 49;
            }
            case 98: {
                return 50;
            }
            case 99: {
                return 51;
            }
            case 100: {
                return 52;
            }
            case 101: {
                return 53;
            }
            case 102: {
                return 54;
            }
            case 103: {
                return 55;
            }
            case 104: {
                return 56;
            }
            case 105: {
                return 57;
            }
            case 106: {
                return 42;
            }
            case 107: {
                return 43;
            }
            case 108: {
                return 0;
            }
            case 109: {
                return 45;
            }
            case 110: {
                return 46;
            }
            case 111: {
                return 47;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean post(Event var1_1) {
        var2_2 = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            if (var1_1 == null) {
                this.error(4);
            }
            var3_3 = var1_1.type;
            switch (var3_3) {
                case 1: 
                case 2: {
                    var4_4 = new KEYBDINPUT();
                    var4_4.wVk = (short)Display.untranslateKey(var1_1.keyCode);
                    if (var4_4.wVk == 0) {
                        var5_6 = var1_1.character;
                        switch (var5_6) {
                            case 8: {
                                var4_4.wVk = (short)8;
                                break;
                            }
                            case 13: {
                                var4_4.wVk = (short)13;
                                break;
                            }
                            case 127: {
                                var4_4.wVk = (short)46;
                                break;
                            }
                            case 27: {
                                var4_4.wVk = (short)27;
                                break;
                            }
                            case 9: {
                                var4_4.wVk = (short)9;
                                break;
                            }
                            case 10: {
                                // ** MonitorExit[var2_2] (shouldn't be in output)
                                return false;
                            }
                            default: {
                                if (OS.IsWinCE) {
                                    var4_4.wVk = (short)OS.CharUpper((short)var5_6);
                                    break;
                                }
                                var4_4.wVk = OS.VkKeyScan((short)Display.wcsToMbcs((char)var5_6, 0));
                                if (var4_4.wVk == -1) {
                                    // ** MonitorExit[var2_2] (shouldn't be in output)
                                    return false;
                                }
                                var4_4.wVk = (short)(var4_4.wVk & 255);
                            }
                        }
                    }
                    var4_4.dwFlags = var3_3 == 2 ? 2 : 0;
                    switch (var4_4.wVk) {
                        case 3: 
                        case 33: 
                        case 34: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 111: 
                        case 144: {
                            var4_4.dwFlags |= 1;
                        }
                    }
                    var5_6 = OS.GetProcessHeap();
                    var6_10 = OS.HeapAlloc(var5_6, 8, INPUT.sizeof);
                    OS.MoveMemory(var6_10, new int[]{1}, 4);
                    OS.MoveMemory(var6_10 + OS.PTR_SIZEOF, var4_4, KEYBDINPUT.sizeof);
                    var7_12 = OS.SendInput(1, var6_10, INPUT.sizeof) != 0;
                    OS.HeapFree(var5_6, 0, var6_10);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return var7_12;
                }
                case 3: 
                case 4: 
                case 5: 
                case 37: {
                    var4_5 = new MOUSEINPUT();
                    if (var3_3 != 5) ** GOTO lbl77
                    var4_5.dwFlags = 32769;
                    var5_7 = 0;
                    var6_11 = 0;
                    var7_13 = 0;
                    var8_14 = 0;
                    if (OS.WIN32_VERSION >= OS.VERSION(5, 0)) {
                        var4_5.dwFlags |= 16384;
                        var5_7 = OS.GetSystemMetrics(76);
                        var6_11 = OS.GetSystemMetrics(77);
                        var7_13 = OS.GetSystemMetrics(78);
                        var8_14 = OS.GetSystemMetrics(79);
                    } else {
                        var7_13 = OS.GetSystemMetrics(0);
                        var8_14 = OS.GetSystemMetrics(1);
                    }
                    var9_15 = var1_1.getLocationInPixels();
                    var4_5.dx = ((var9_15.x - var5_7) * 65535 + var7_13 - 2) / (var7_13 - 1);
                    var4_5.dy = ((var9_15.y - var6_11) * 65535 + var8_14 - 2) / (var8_14 - 1);
                    ** GOTO lbl122
lbl77:
                    // 1 sources

                    if (var3_3 != 37) ** GOTO lbl95
                    if (OS.WIN32_VERSION < OS.VERSION(5, 0)) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return false;
                    }
                    var4_5.dwFlags = 2048;
                    switch (var1_1.detail) {
                        case 2: {
                            var4_5.mouseData = var1_1.count * 120;
                            ** GOTO lbl122
                        }
                        case 1: {
                            var5_8 = new int[1];
                            OS.SystemParametersInfo(104, 0, var5_8, 0);
                            var4_5.mouseData = var1_1.count * 120 / var5_8[0];
                            ** GOTO lbl122
                        }
                        default: {
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return false;
                        }
                    }
lbl95:
                    // 1 sources

                    switch (var1_1.button) {
                        case 1: {
                            var4_5.dwFlags = var3_3 == 3 ? 2 : 4;
                            break;
                        }
                        case 2: {
                            var4_5.dwFlags = var3_3 == 3 ? 32 : 64;
                            break;
                        }
                        case 3: {
                            var4_5.dwFlags = var3_3 == 3 ? 8 : 16;
                            break;
                        }
                        case 4: {
                            if (OS.WIN32_VERSION < OS.VERSION(5, 0)) {
                                // ** MonitorExit[var2_2] (shouldn't be in output)
                                return false;
                            }
                            var4_5.dwFlags = var3_3 == 3 ? 128 : 256;
                            var4_5.mouseData = 1;
                            break;
                        }
                        case 5: {
                            if (OS.WIN32_VERSION < OS.VERSION(5, 0)) {
                                // ** MonitorExit[var2_2] (shouldn't be in output)
                                return false;
                            }
                            var4_5.dwFlags = var3_3 == 3 ? 128 : 256;
                            var4_5.mouseData = 2;
                            break;
                        }
                        default: {
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return false;
                        }
                    }
lbl122:
                    // 8 sources

                    var5_9 = OS.GetProcessHeap();
                    var6_11 = OS.HeapAlloc(var5_9, 8, INPUT.sizeof);
                    OS.MoveMemory(var6_11, new int[]{0}, 4);
                    OS.MoveMemory(var6_11 + OS.PTR_SIZEOF, var4_5, MOUSEINPUT.sizeof);
                    var7_13 = OS.SendInput(1, var6_11, INPUT.sizeof) != 0 ? 1 : 0;
                    OS.HeapFree(var5_9, 0, var6_11);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return (boolean)var7_13;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    void postEvent(Event event) {
        int n2;
        if (this.eventQueue == null) {
            this.eventQueue = new Event[4];
        }
        int n3 = this.eventQueue.length;
        for (n2 = 0; n2 < n3 && this.eventQueue[n2] != null; ++n2) {
        }
        if (n2 == n3) {
            Event[] eventArray = new Event[n3 + 4];
            System.arraycopy(this.eventQueue, 0, eventArray, 0, n3);
            this.eventQueue = eventArray;
        }
        this.eventQueue[n2] = event;
    }

    public boolean readAndDispatch() {
        this.checkDevice();
        lpStartupInfo = null;
        this.drawMenuBars();
        this.runSkin();
        this.runDeferredLayouts();
        this.runPopups();
        if (OS.PeekMessage(this.msg, 0, 0, 0, 1)) {
            if (!this.filterMessage(this.msg)) {
                OS.TranslateMessage(this.msg);
                OS.DispatchMessage(this.msg);
            }
            this.runDeferredEvents();
            return true;
        }
        return this.isDisposed() || this.runMessages && this.runAsyncMessages(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void register(Display display) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            for (int i2 = 0; i2 < Displays.length; ++i2) {
                if (Displays[i2] != null) continue;
                Display.Displays[i2] = display;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            Display[] displayArray = new Display[Displays.length + 4];
            System.arraycopy(Displays, 0, displayArray, 0, Displays.length);
            displayArray[Display.Displays.length] = display;
            Displays = displayArray;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    protected void release() {
        Object object;
        int n2;
        this.sendEvent(12, new Event());
        Shell[] shellArray = this.getShells();
        for (n2 = 0; n2 < shellArray.length; ++n2) {
            object = shellArray[n2];
            if (((Widget)object).isDisposed()) continue;
            ((Shell)object).dispose();
        }
        if (this.tray != null) {
            this.tray.dispose();
        }
        this.tray = null;
        if (this.taskBar != null) {
            this.taskBar.dispose();
        }
        this.taskBar = null;
        while (this.readAndDispatch()) {
        }
        if (this.disposeList != null) {
            for (n2 = 0; n2 < this.disposeList.length; ++n2) {
                object = this.disposeList[n2];
                if (object == null) continue;
                try {
                    object.run();
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    this.runtimeExceptionHandler.accept(runtimeException);
                    continue;
                }
                catch (Error error) {
                    this.errorHandler.accept(error);
                }
            }
        }
        this.disposeList = null;
        this.synchronizer.releaseSynchronizer();
        this.synchronizer = null;
        this.releaseDisplay();
        super.release();
    }

    void releaseDisplay() {
        int n2;
        if (this.embeddedHwnd != 0) {
            OS.PostMessage(this.embeddedHwnd, 32771, 0, 0);
        }
        if (OS.COMCTL32_MAJOR >= 6) {
            if (this.hButtonTheme != 0) {
                OS.CloseThemeData(this.hButtonTheme);
            }
            if (this.hEditTheme != 0) {
                OS.CloseThemeData(this.hEditTheme);
            }
            if (this.hExplorerBarTheme != 0) {
                OS.CloseThemeData(this.hExplorerBarTheme);
            }
            if (this.hScrollBarTheme != 0) {
                OS.CloseThemeData(this.hScrollBarTheme);
            }
            if (this.hTabTheme != 0) {
                OS.CloseThemeData(this.hTabTheme);
            }
            this.hTabTheme = 0;
            this.hScrollBarTheme = 0;
            this.hExplorerBarTheme = 0;
            this.hEditTheme = 0;
            this.hButtonTheme = 0;
        }
        if (!OS.IsWinCE) {
            if (this.msgHook != 0) {
                OS.UnhookWindowsHookEx(this.msgHook);
            }
            this.msgHook = 0;
        }
        if (!OS.IsWinCE) {
            if (this.filterHook != 0) {
                OS.UnhookWindowsHookEx(this.filterHook);
            }
            this.filterHook = 0;
            this.msgFilterCallback.dispose();
            this.msgFilterCallback = null;
            this.msgFilterProc = 0;
        }
        if (!OS.IsWinCE) {
            if (this.idleHook != 0) {
                OS.UnhookWindowsHookEx(this.idleHook);
            }
            this.idleHook = 0;
            this.foregroundIdleCallback.dispose();
            this.foregroundIdleCallback = null;
            this.foregroundIdleProc = 0;
        }
        OS.KillTimer(this.hwndMessage, 100);
        if (this.hwndMessage != 0) {
            OS.DestroyWindow(this.hwndMessage);
        }
        this.hwndMessage = 0;
        this.messageCallback.dispose();
        this.messageCallback = null;
        this.messageProc = 0;
        int n3 = OS.GetProcessHeap();
        int n4 = OS.GetModuleHandle(null);
        OS.UnregisterClass(this.windowClass, n4);
        OS.UnregisterClass(this.windowShadowClass, n4);
        OS.UnregisterClass(this.windowOwnDCClass, n4);
        this.windowOwnDCClass = null;
        this.windowShadowClass = null;
        this.windowClass = null;
        this.windowCallback.dispose();
        this.windowCallback = null;
        this.windowProc = 0;
        if (this.systemFont != null) {
            this.systemFont.dispose();
        }
        this.systemFont = null;
        this.lfSystemFont = null;
        if (this.errorImage != null) {
            this.errorImage.dispose();
        }
        if (this.infoImage != null) {
            this.infoImage.dispose();
        }
        if (this.questionImage != null) {
            this.questionImage.dispose();
        }
        if (this.warningIcon != null) {
            this.warningIcon.dispose();
        }
        this.warningIcon = null;
        this.questionImage = null;
        this.infoImage = null;
        this.errorImage = null;
        if (this.upArrow != null) {
            this.upArrow.dispose();
        }
        if (this.downArrow != null) {
            this.downArrow.dispose();
        }
        this.downArrow = null;
        this.upArrow = null;
        for (n2 = 0; n2 < this.cursors.length; ++n2) {
            if (this.cursors[n2] == null) continue;
            this.cursors[n2].dispose();
        }
        this.cursors = null;
        if (this.resources != null) {
            for (n2 = 0; n2 < this.resources.length; ++n2) {
                if (this.resources[n2] == null) continue;
                this.resources[n2].dispose();
            }
            this.resources = null;
        }
        if (this.lpCustColors != 0) {
            OS.HeapFree(n3, 0, this.lpCustColors);
        }
        this.lpCustColors = 0;
        if (!OS.IsWinCE) {
            OS.OleUninitialize();
        }
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
            OS.BufferedPaintUnInit();
        }
        this.thread = null;
        this.hookMsg = null;
        this.msg = null;
        this.keyboard = null;
        this.modalDialog = null;
        this.modalShells = null;
        this.data = null;
        this.keys = null;
        this.values = null;
        this.popups = null;
        this.bars = null;
        this.indexTable = null;
        this.timerIds = null;
        this.controlTable = null;
        this.lastHittestControl = null;
        this.lastGetControl = null;
        this.lastControl = null;
        this.toolDisabledImageList = null;
        this.toolHotImageList = null;
        this.toolImageList = null;
        this.imageList = null;
        this.timerList = null;
        this.tableBuffer = null;
        this.columnVisible = null;
        this.filterTable = null;
        this.eventTable = null;
        this.items = null;
        this.clickRect = null;
        this.hdr = null;
        this.plvfi = null;
        this.monitors = null;
        this.touchSources = null;
        this.threadId = 0;
    }

    void releaseImageList(ImageList imageList) {
        int n2 = this.imageList.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.imageList[i2] != imageList) continue;
            if (imageList.removeRef() > 0) {
                return;
            }
            imageList.dispose();
            System.arraycopy(this.imageList, i2 + 1, this.imageList, i2, --n2 - i2);
            this.imageList[n2] = null;
            for (int i3 = 0; i3 < n2; ++i3) {
                if (this.imageList[i3] == null) continue;
                return;
            }
            this.imageList = null;
            return;
        }
    }

    void releaseToolImageList(ImageList imageList) {
        int n2 = this.toolImageList.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.toolImageList[i2] != imageList) continue;
            if (imageList.removeRef() > 0) {
                return;
            }
            imageList.dispose();
            System.arraycopy(this.toolImageList, i2 + 1, this.toolImageList, i2, --n2 - i2);
            this.toolImageList[n2] = null;
            for (int i3 = 0; i3 < n2; ++i3) {
                if (this.toolImageList[i3] == null) continue;
                return;
            }
            this.toolImageList = null;
            return;
        }
    }

    void releaseToolHotImageList(ImageList imageList) {
        int n2 = this.toolHotImageList.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.toolHotImageList[i2] != imageList) continue;
            if (imageList.removeRef() > 0) {
                return;
            }
            imageList.dispose();
            System.arraycopy(this.toolHotImageList, i2 + 1, this.toolHotImageList, i2, --n2 - i2);
            this.toolHotImageList[n2] = null;
            for (int i3 = 0; i3 < n2; ++i3) {
                if (this.toolHotImageList[i3] == null) continue;
                return;
            }
            this.toolHotImageList = null;
            return;
        }
    }

    void releaseToolDisabledImageList(ImageList imageList) {
        int n2 = this.toolDisabledImageList.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.toolDisabledImageList[i2] != imageList) continue;
            if (imageList.removeRef() > 0) {
                return;
            }
            imageList.dispose();
            System.arraycopy(this.toolDisabledImageList, i2 + 1, this.toolDisabledImageList, i2, --n2 - i2);
            this.toolDisabledImageList[n2] = null;
            for (int i3 = 0; i3 < n2; ++i3) {
                if (this.toolDisabledImageList[i3] == null) continue;
                return;
            }
            this.toolDisabledImageList = null;
            return;
        }
    }

    public void removeFilter(int n2, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            return;
        }
        this.filterTable.unhook(n2, listener);
        if (this.filterTable.size() == 0) {
            this.filterTable = null;
        }
    }

    public void removeListener(int n2, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n2, listener);
    }

    void removeBar(Menu menu) {
        if (this.bars == null) {
            return;
        }
        for (int i2 = 0; i2 < this.bars.length; ++i2) {
            if (this.bars[i2] != menu) continue;
            this.bars[i2] = null;
            return;
        }
    }

    Control removeControl(int n2) {
        int n3;
        if (n2 == 0) {
            return null;
        }
        this.lastGetControl = null;
        this.lastControl = null;
        Control control = null;
        if (USE_PROPERTY) {
            n3 = OS.RemoveProp(n2, SWT_OBJECT_INDEX) - 1;
        } else {
            n3 = OS.GetWindowLongPtr(n2, -21) - 1;
            OS.SetWindowLongPtr(n2, -21, 0);
        }
        if (0 <= n3 && n3 < this.controlTable.length) {
            control = this.controlTable[n3];
            this.controlTable[n3] = null;
            this.indexTable[n3] = this.freeSlot;
            this.freeSlot = n3;
        }
        return control;
    }

    void removeMenuItem(MenuItem menuItem) {
        if (this.items == null) {
            return;
        }
        this.items[menuItem.id - 108] = null;
    }

    void removePopup(Menu menu) {
        if (this.popups == null) {
            return;
        }
        for (int i2 = 0; i2 < this.popups.length; ++i2) {
            if (this.popups[i2] != menu) continue;
            this.popups[i2] = null;
            return;
        }
    }

    boolean runAsyncMessages(boolean bl2) {
        return this.synchronizer.runAsyncMessages(bl2);
    }

    boolean runDeferredEvents() {
        Event event;
        boolean bl2 = false;
        while (this.eventQueue != null && (event = this.eventQueue[0]) != null) {
            Widget widget;
            int n2 = this.eventQueue.length;
            System.arraycopy(this.eventQueue, 1, this.eventQueue, 0, --n2);
            this.eventQueue[n2] = null;
            Widget widget2 = event.widget;
            if (widget2 == null || widget2.isDisposed() || (widget = event.item) != null && widget.isDisposed()) continue;
            bl2 = true;
            widget2.sendEvent(event);
        }
        this.eventQueue = null;
        return bl2;
    }

    boolean runDeferredLayouts() {
        if (this.layoutDeferredCount != 0) {
            Composite[] compositeArray = this.layoutDeferred;
            int n2 = this.layoutDeferredCount;
            this.layoutDeferred = null;
            this.layoutDeferredCount = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                Composite composite = compositeArray[i2];
                if (composite.isDisposed()) continue;
                composite.setLayoutDeferred(false);
            }
            return true;
        }
        return false;
    }

    boolean runPopups() {
        Menu menu;
        if (this.popups == null) {
            return false;
        }
        boolean bl2 = false;
        while (this.popups != null && (menu = this.popups[0]) != null) {
            int n2 = this.popups.length;
            System.arraycopy(this.popups, 1, this.popups, 0, --n2);
            this.popups[n2] = null;
            this.runDeferredEvents();
            if (!menu.isDisposed()) {
                menu._setVisible(true);
            }
            bl2 = true;
        }
        this.popups = null;
        return bl2;
    }

    void runSettings() {
        Font font = this.getSystemFont();
        this.saveResources();
        this.updateImages();
        this.sendEvent(39, null);
        Font font2 = this.getSystemFont();
        boolean bl2 = font.equals(font2);
        Shell[] shellArray = this.getShells();
        for (int i2 = 0; i2 < shellArray.length; ++i2) {
            Shell shell = shellArray[i2];
            if (shell.isDisposed()) continue;
            if (!bl2) {
                shell.updateFont(font, font2);
            }
            shell.layout(true, true);
        }
    }

    boolean runSkin() {
        if (this.skinCount > 0) {
            Widget[] widgetArray = this.skinList;
            int n2 = this.skinCount;
            this.skinList = new Widget[1024];
            this.skinCount = 0;
            if (this.eventTable != null && this.eventTable.hooks(45)) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    Widget widget = widgetArray[i2];
                    if (widget == null || widget.isDisposed()) continue;
                    widget.state &= 0xFFDFFFFF;
                    widgetArray[i2] = null;
                    Event event = new Event();
                    event.widget = widget;
                    this.sendEvent(45, event);
                }
            }
            return true;
        }
        return false;
    }

    boolean runTimer(int n2) {
        if (this.timerList != null && this.timerIds != null) {
            for (int i2 = 0; i2 < this.timerIds.length; ++i2) {
                if (this.timerIds[i2] != n2) continue;
                OS.KillTimer(this.hwndMessage, this.timerIds[i2]);
                this.timerIds[i2] = 0;
                Runnable runnable = this.timerList[i2];
                this.timerList[i2] = null;
                if (runnable != null) {
                    try {
                        runnable.run();
                    }
                    catch (RuntimeException runtimeException) {
                        this.runtimeExceptionHandler.accept(runtimeException);
                    }
                    catch (Error error) {
                        this.errorHandler.accept(error);
                    }
                }
                return true;
            }
        }
        return false;
    }

    void saveResources() {
        Object object;
        int n2 = 0;
        if (this.resources == null) {
            this.resources = new Resource[27];
        } else {
            n2 = this.resources.length;
            object = new Resource[n2 + 27];
            System.arraycopy(this.resources, 0, object, 0, n2);
            this.resources = object;
        }
        if (this.systemFont != null && !OS.IsWinCE) {
            object = OS.IsUnicode ? new NONCLIENTMETRICSW() : new NONCLIENTMETRICSA();
            object.cbSize = NONCLIENTMETRICS.sizeof;
            if (OS.SystemParametersInfo(41, 0, (NONCLIENTMETRICS)object, 0)) {
                LOGFONT lOGFONT;
                LOGFONT lOGFONT2 = lOGFONT = OS.IsUnicode ? ((NONCLIENTMETRICSW)object).lfMessageFont : ((NONCLIENTMETRICSA)object).lfMessageFont;
                if (this.lfSystemFont == null || lOGFONT.lfCharSet != this.lfSystemFont.lfCharSet || lOGFONT.lfHeight != this.lfSystemFont.lfHeight || lOGFONT.lfWidth != this.lfSystemFont.lfWidth || lOGFONT.lfEscapement != this.lfSystemFont.lfEscapement || lOGFONT.lfOrientation != this.lfSystemFont.lfOrientation || lOGFONT.lfWeight != this.lfSystemFont.lfWeight || lOGFONT.lfItalic != this.lfSystemFont.lfItalic || lOGFONT.lfUnderline != this.lfSystemFont.lfUnderline || lOGFONT.lfStrikeOut != this.lfSystemFont.lfStrikeOut || lOGFONT.lfCharSet != this.lfSystemFont.lfCharSet || lOGFONT.lfOutPrecision != this.lfSystemFont.lfOutPrecision || lOGFONT.lfClipPrecision != this.lfSystemFont.lfClipPrecision || lOGFONT.lfQuality != this.lfSystemFont.lfQuality || lOGFONT.lfPitchAndFamily != this.lfSystemFont.lfPitchAndFamily || !this.getFontName(lOGFONT).equals(this.getFontName(this.lfSystemFont))) {
                    this.resources[n2++] = this.systemFont;
                    this.lfSystemFont = lOGFONT;
                    this.systemFont = null;
                }
            }
        }
        if (this.errorImage != null) {
            this.resources[n2++] = this.errorImage;
        }
        if (this.infoImage != null) {
            this.resources[n2++] = this.infoImage;
        }
        if (this.questionImage != null) {
            this.resources[n2++] = this.questionImage;
        }
        if (this.warningIcon != null) {
            this.resources[n2++] = this.warningIcon;
        }
        this.warningIcon = null;
        this.questionImage = null;
        this.infoImage = null;
        this.errorImage = null;
        for (int i2 = 0; i2 < this.cursors.length; ++i2) {
            if (this.cursors[i2] != null) {
                this.resources[n2++] = this.cursors[i2];
            }
            this.cursors[i2] = null;
        }
        if (n2 < 27) {
            Resource[] resourceArray = new Resource[n2];
            System.arraycopy(this.resources, 0, resourceArray, 0, n2);
            this.resources = resourceArray;
        }
    }

    void sendEvent(int n2, Event event) {
        if (this.eventTable == null && this.filterTable == null) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.display = this;
        event.type = n2;
        if (event.time == 0) {
            event.time = this.getLastEventTime();
        }
        if (!this.filterEvent(event) && this.eventTable != null) {
            this.sendEvent(this.eventTable, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendEvent(EventTable eventTable, Event event) {
        int n2 = event.type;
        this.sendPreEvent(n2);
        try {
            eventTable.sendEvent(event);
        }
        finally {
            this.sendPostEvent(n2);
        }
    }

    void sendPreEvent(int n2) {
        if (n2 != 50 && n2 != 51 && n2 != 52 && n2 != 53 && this.eventTable != null && this.eventTable.hooks(50)) {
            Event event = new Event();
            event.detail = n2;
            this.sendEvent(50, event);
        }
    }

    void sendPostEvent(int n2) {
        if (n2 != 50 && n2 != 51 && n2 != 52 && n2 != 53 && this.eventTable != null && this.eventTable.hooks(51)) {
            Event event = new Event();
            event.detail = n2;
            this.sendEvent(51, event);
        }
    }

    public void sendPreExternalEventDispatchEvent() {
        if (this.eventTable != null && this.eventTable.hooks(52)) {
            this.sendEvent(52, null);
        }
    }

    public void sendPostExternalEventDispatchEvent() {
        if (this.eventTable != null && this.eventTable.hooks(53)) {
            this.sendEvent(53, null);
        }
    }

    public void setCursorLocation(int n2, int n3) {
        this.checkDevice();
        this.setCursorLocationInPixels(DPIUtil.autoScaleUp(n2), DPIUtil.autoScaleUp(n3));
    }

    void setCursorLocationInPixels(int n2, int n3) {
        OS.SetCursorPos(n2, n3);
    }

    public void setCursorLocation(Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        this.setCursorLocation(point.x, point.y);
    }

    public void setData(String string, Object object) {
        this.checkDevice();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(RUN_MESSAGES_IN_IDLE_KEY)) {
            Boolean bl2 = (Boolean)object;
            this.runMessagesInIdle = bl2 != null && bl2 != false;
            return;
        }
        if (string.equals(RUN_MESSAGES_IN_MESSAGE_PROC_KEY)) {
            Boolean bl3 = (Boolean)object;
            this.runMessagesInMessageProc = bl3 != null && bl3 != false;
            return;
        }
        if (string.equals(USE_OWNDC_KEY)) {
            Boolean bl4 = (Boolean)object;
            this.useOwnDC = bl4 != null && bl4 != false;
            return;
        }
        if (string.equals(ACCEL_KEY_HIT)) {
            Boolean bl5 = (Boolean)object;
            this.accelKeyHit = bl5 != null && bl5 != false;
            return;
        }
        if (object == null) {
            int n2;
            if (this.keys == null) {
                return;
            }
            for (n2 = 0; n2 < this.keys.length && !this.keys[n2].equals(string); ++n2) {
            }
            if (n2 == this.keys.length) {
                return;
            }
            if (this.keys.length == 1) {
                this.keys = null;
                this.values = null;
            } else {
                String[] stringArray = new String[this.keys.length - 1];
                Object[] objectArray = new Object[this.values.length - 1];
                System.arraycopy(this.keys, 0, stringArray, 0, n2);
                System.arraycopy(this.keys, n2 + 1, stringArray, n2, stringArray.length - n2);
                System.arraycopy(this.values, 0, objectArray, 0, n2);
                System.arraycopy(this.values, n2 + 1, objectArray, n2, objectArray.length - n2);
                this.keys = stringArray;
                this.values = objectArray;
            }
            return;
        }
        if (this.keys == null) {
            this.keys = new String[]{string};
            this.values = new Object[]{object};
            return;
        }
        for (int i2 = 0; i2 < this.keys.length; ++i2) {
            if (!this.keys[i2].equals(string)) continue;
            this.values[i2] = object;
            return;
        }
        String[] stringArray = new String[this.keys.length + 1];
        Object[] objectArray = new Object[this.values.length + 1];
        System.arraycopy(this.keys, 0, stringArray, 0, this.keys.length);
        System.arraycopy(this.values, 0, objectArray, 0, this.values.length);
        stringArray[this.keys.length] = string;
        objectArray[this.values.length] = object;
        this.keys = stringArray;
        this.values = objectArray;
    }

    public void setData(Object object) {
        this.checkDevice();
        this.data = object;
    }

    public static String getAppName() {
        return APP_NAME;
    }

    public static String getAppVersion() {
        return APP_VERSION;
    }

    public static void setAppName(String string) {
        APP_NAME = string;
    }

    public static void setAppVersion(String string) {
        APP_VERSION = string;
    }

    void setModalDialog(Dialog dialog) {
        this.modalDialog = dialog;
        Shell[] shellArray = this.getShells();
        for (int i2 = 0; i2 < shellArray.length; ++i2) {
            shellArray[i2].updateModal();
        }
    }

    void setModalShell(Shell shell) {
        Shell[] shellArray;
        int n2;
        if (this.modalShells == null) {
            this.modalShells = new Shell[4];
        }
        int n3 = this.modalShells.length;
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.modalShells[n2] == shell) {
                return;
            }
            if (this.modalShells[n2] == null) break;
        }
        if (n2 == n3) {
            shellArray = new Shell[n3 + 4];
            System.arraycopy(this.modalShells, 0, shellArray, 0, n3);
            this.modalShells = shellArray;
        }
        this.modalShells[n2] = shell;
        shellArray = this.getShells();
        for (int i2 = 0; i2 < shellArray.length; ++i2) {
            shellArray[i2].updateModal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSynchronizer(Synchronizer synchronizer) {
        this.checkDevice();
        if (synchronizer == null) {
            this.error(4);
        }
        if (synchronizer == this.synchronizer) {
            return;
        }
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            Synchronizer synchronizer2 = this.synchronizer;
            this.synchronizer = synchronizer;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (synchronizer2 != null) {
                synchronizer2.moveAllEventsTo(synchronizer);
            }
            return;
        }
    }

    public final void setRuntimeExceptionHandler(Consumer consumer) {
        this.checkDevice();
        this.runtimeExceptionHandler = Objects.requireNonNull(consumer);
    }

    public final Consumer getRuntimeExceptionHandler() {
        return this.runtimeExceptionHandler;
    }

    public final void setErrorHandler(Consumer consumer) {
        this.checkDevice();
        this.errorHandler = Objects.requireNonNull(consumer);
    }

    public final Consumer getErrorHandler() {
        return this.errorHandler;
    }

    int shiftedKey(int n2) {
        if (OS.IsWinCE) {
            return 0;
        }
        for (int i2 = 0; i2 < this.keyboard.length; ++i2) {
            this.keyboard[i2] = 0;
        }
        this.keyboard[16] = (byte)(this.keyboard[16] | 0x80);
        if (OS.IsUnicode) {
            char[] cArray = new char[1];
            if (OS.ToUnicode(n2, n2, this.keyboard, cArray, 1, 0) == 1) {
                return cArray[0];
            }
        } else {
            short[] sArray = new short[1];
            if (OS.ToAscii(n2, n2, this.keyboard, sArray, 0) == 1) {
                return sArray[0];
            }
        }
        return 0;
    }

    public boolean sleep() {
        this.checkDevice();
        if (this.runMessages && this.getMessageCount() != 0) {
            return true;
        }
        this.sendPreExternalEventDispatchEvent();
        if (OS.IsWinCE) {
            OS.MsgWaitForMultipleObjectsEx(0, 0, -1, 127, 4);
            this.sendPostExternalEventDispatchEvent();
            return true;
        }
        boolean bl2 = OS.WaitMessage();
        this.sendPostExternalEventDispatchEvent();
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncExec(Runnable runnable) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            Synchronizer synchronizer = this.synchronizer;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            synchronizer.syncExec(runnable);
            return;
        }
    }

    public void timerExec(int n2, Runnable runnable) {
        int n3;
        int n4;
        this.checkDevice();
        if (runnable == null) {
            this.error(4);
        }
        if (this.timerList == null) {
            this.timerList = new Runnable[4];
        }
        if (this.timerIds == null) {
            this.timerIds = new int[4];
        }
        for (n4 = 0; n4 < this.timerList.length && this.timerList[n4] != runnable; ++n4) {
        }
        int n5 = 0;
        if (n4 != this.timerList.length) {
            n5 = this.timerIds[n4];
            if (n2 < 0) {
                OS.KillTimer(this.hwndMessage, n5);
                this.timerList[n4] = null;
                this.timerIds[n4] = 0;
                return;
            }
        } else {
            if (n2 < 0) {
                return;
            }
            for (n4 = 0; n4 < this.timerList.length && this.timerList[n4] != null; ++n4) {
            }
            n5 = this.nextTimerId++;
            if (n4 == this.timerList.length) {
                Runnable[] runnableArray = new Runnable[this.timerList.length + 4];
                System.arraycopy(this.timerList, 0, runnableArray, 0, this.timerList.length);
                this.timerList = runnableArray;
                int[] nArray = new int[this.timerIds.length + 4];
                System.arraycopy(this.timerIds, 0, nArray, 0, this.timerIds.length);
                this.timerIds = nArray;
            }
        }
        if ((n3 = OS.SetTimer(this.hwndMessage, n5, n2, 0)) != 0) {
            this.timerList[n4] = runnable;
            this.timerIds[n4] = n3;
        }
    }

    boolean translateAccelerator(MSG mSG, Control control) {
        this.accelKeyHit = true;
        boolean bl2 = control.translateAccelerator(mSG);
        this.accelKeyHit = false;
        return bl2;
    }

    static int translateKey(int n2) {
        for (int i2 = 0; i2 < KeyTable.length; ++i2) {
            if (KeyTable[i2][0] != n2) continue;
            return KeyTable[i2][1];
        }
        return 0;
    }

    boolean translateMnemonic(MSG mSG, Control control) {
        switch (mSG.message) {
            case 258: 
            case 262: {
                return control.translateMnemonic(mSG);
            }
        }
        return false;
    }

    boolean translateTraversal(MSG mSG, Control control) {
        switch (mSG.message) {
            case 256: {
                switch (mSG.wParam) {
                    case 9: 
                    case 13: 
                    case 27: 
                    case 33: 
                    case 34: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: {
                        return control.translateTraversal(mSG);
                    }
                }
                break;
            }
            case 260: {
                switch (mSG.wParam) {
                    case 18: {
                        return control.translateTraversal(mSG);
                    }
                }
            }
        }
        return false;
    }

    static int untranslateKey(int n2) {
        for (int i2 = 0; i2 < KeyTable.length; ++i2) {
            if (KeyTable[i2][1] != n2) continue;
            return KeyTable[i2][0];
        }
        return 0;
    }

    public void update() {
        int n2;
        Object object;
        this.checkDevice();
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10) && OS.IsHungAppWindow(this.hwndMessage)) {
            object = new MSG();
            n2 = 3;
            OS.PeekMessage((MSG)object, this.hwndMessage, 32773, 32773, n2);
        }
        object = this.getShells();
        for (n2 = 0; n2 < ((Shell[])object).length; ++n2) {
            Shell shell = object[n2];
            if (shell.isDisposed()) continue;
            shell.update(true);
        }
    }

    void updateImages() {
        if (this.upArrow != null) {
            this.upArrow.dispose();
        }
        if (this.downArrow != null) {
            this.downArrow.dispose();
        }
        this.downArrow = null;
        this.upArrow = null;
        for (int i2 = 0; i2 < this.controlTable.length; ++i2) {
            Control control = this.controlTable[i2];
            if (control == null) continue;
            control.updateImages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wake() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            if (this.thread == Thread.currentThread()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.wakeThread();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void wakeThread() {
        if (OS.IsWinCE) {
            OS.PostMessage(this.hwndMessage, 0, 0, 0);
        } else {
            OS.PostThreadMessage(this.threadId, 0, 0, 0);
        }
    }

    static int wcsToMbcs(char c2, int n2) {
        if (OS.IsUnicode) {
            return c2;
        }
        if (c2 <= '\u007f') {
            return c2;
        }
        TCHAR tCHAR = new TCHAR(n2, c2, false);
        return tCHAR.tcharAt(0);
    }

    static int wcsToMbcs(char c2) {
        return Display.wcsToMbcs(c2, 0);
    }

    int windowProc(int n2, int n3, int n4, int n5) {
        Control control;
        if (this.columnVisible != null && n3 == 78 && this.hwndParent == n2) {
            OS.MoveMemory(this.hdr, n5, NMHDR.sizeof);
            switch (this.hdr.code) {
                case -177: 
                case -150: {
                    OS.MoveMemory(this.plvfi, n5, NMLVDISPINFO.sizeof);
                    if (0 > this.plvfi.iSubItem || this.plvfi.iSubItem >= this.columnCount || this.columnVisible[this.plvfi.iSubItem]) break;
                    return 0;
                }
            }
        }
        if (n3 == TASKBARBUTTONCREATED && this.taskBar != null) {
            TaskItem[] taskItemArray = this.taskBar.items;
            for (int i2 = 0; i2 < taskItemArray.length; ++i2) {
                TaskItem taskItem = taskItemArray[i2];
                if (taskItem == null || taskItem.shell == null || taskItem.shell.handle != n2) continue;
                taskItem.recreate();
                break;
            }
        }
        if (n3 == 132) {
            if (this.hitCount++ >= 1024) {
                try {
                    Thread.sleep(1L);
                }
                catch (Throwable throwable) {}
            }
        } else {
            this.hitCount = 0;
        }
        if (this.lastControl != null && this.lastHwnd == n2) {
            return this.lastControl.windowProc(n2, n3, n4, n5);
        }
        int n6 = USE_PROPERTY ? OS.GetProp(n2, SWT_OBJECT_INDEX) - 1 : OS.GetWindowLongPtr(n2, -21) - 1;
        if (0 <= n6 && n6 < this.controlTable.length && (control = this.controlTable[n6]) != null) {
            this.lastHwnd = n2;
            this.lastControl = control;
            return control.windowProc(n2, n3, n4, n5);
        }
        return OS.DefWindowProc(n2, n3, n4, n5);
    }

    int textWidth(String string, int n2) {
        int n3 = 0;
        RECT rECT = new RECT();
        int n4 = OS.GetDC(n2);
        int n5 = OS.SendMessage(n2, 49, 0, 0);
        if (n5 != 0) {
            n3 = OS.SelectObject(n4, n5);
        }
        int n6 = 3104;
        TCHAR tCHAR = new TCHAR(0, string, false);
        OS.DrawText(n4, tCHAR, tCHAR.length(), rECT, n6);
        if (n5 != 0) {
            OS.SelectObject(n4, n3);
        }
        OS.ReleaseDC(n2, n4);
        return rECT.right - rECT.left;
    }

    String wrapText(String string, int n2, int n3) {
        String string2 = "\r\n";
        string = Display.withCrLf(string);
        int n4 = string.length();
        if (n3 <= 0 || n4 == 0 || n4 == 1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n5 = 0;
        int n6 = 0;
        while (n5 < n4) {
            boolean bl2;
            n6 = string.indexOf(string2, n5);
            boolean bl3 = bl2 = n6 == -1;
            if (bl2) {
                n6 = n4;
            }
            int n7 = n6 + string2.length();
            while (n6 > n5 + 1 && Character.isWhitespace(string.charAt(n6 - 1))) {
                --n6;
            }
            int n8 = n5;
            int n9 = n5;
            int n10 = n5;
            while (n10 < n6) {
                int n11 = n8;
                int n12 = n9;
                n8 = n10;
                while (n10 < n6 && !Character.isWhitespace(string.charAt(n10))) {
                    ++n10;
                }
                n9 = n10 - 1;
                String string3 = string.substring(n5, n9 + 1);
                int n13 = this.textWidth(string3, n2);
                while (n10 < n6 && Character.isWhitespace(string.charAt(n10))) {
                    ++n10;
                }
                if (n13 <= n3) continue;
                if (n11 == n8) {
                    while (n8 < n9 && (n13 = this.textWidth(string3 = string.substring(n5, n8 + 1), n2)) < n3) {
                        ++n8;
                    }
                    if (n8 == n11) {
                        ++n8;
                    }
                    n12 = n8 - 1;
                }
                string3 = string.substring(n5, n12 + 1);
                stringBuffer.append(string3);
                stringBuffer.append(string2);
                n10 = n8;
                n5 = n8;
                n9 = n8;
            }
            if (n5 < n6) {
                stringBuffer.append(string.substring(n5, n6));
            }
            if (!bl2) {
                stringBuffer.append(string2);
            }
            n5 = n7;
        }
        return stringBuffer.toString();
    }

    static String withCrLf(String string) {
        int n2 = string.length();
        if (n2 == 0) {
            return string;
        }
        int n3 = string.indexOf(10, 0);
        if (n3 == -1) {
            return string;
        }
        if (n3 > 0 && string.charAt(n3 - 1) == '\r') {
            return string;
        }
        ++n3;
        int n4 = 1;
        while (n3 < n2 && (n3 = string.indexOf(10, n3)) != -1) {
            ++n4;
            ++n3;
        }
        n3 = 0;
        StringBuffer stringBuffer = new StringBuffer(n4 += n2);
        while (n3 < n2) {
            int n5 = string.indexOf(10, n3);
            if (n5 == -1) {
                n5 = n2;
            }
            stringBuffer.append(string.substring(n3, n5));
            n3 = n5;
            if (n3 >= n2) continue;
            stringBuffer.append("\r\n");
            ++n3;
        }
        return stringBuffer.toString();
    }

    static char[] withCrLf(char[] cArray) {
        int n2 = cArray.length;
        if (n2 == 0) {
            return cArray;
        }
        int n3 = 0;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (cArray[i2] != '\n' || ++n3 != 1 || i2 <= 0 || cArray[i2 - 1] != '\r') continue;
            return cArray;
        }
        if (n3 == 0) {
            return cArray;
        }
        char[] cArray2 = new char[n3 += n2];
        int n4 = 0;
        for (int i3 = 0; i3 < n2 && n4 < n3; ++i3) {
            if (cArray[i3] == '\n') {
                cArray2[n4++] = 13;
            }
            cArray2[n4++] = cArray[i3];
        }
        return cArray2;
    }

    static {
        USE_PROPERTY = !OS.IsWinCE;
        SWT_OBJECT_INDEX = USE_PROPERTY ? OS.GlobalAddAtom(new TCHAR(0, "SWT_OBJECT_INDEX", true)) : 0;
        if (!OS.IsWinCE) {
            lpStartupInfo = new STARTUPINFO();
            Display.lpStartupInfo.cb = STARTUPINFO.sizeof;
            OS.GetStartupInfo(lpStartupInfo);
        }
        BUTTON = new char[]{'B', 'U', 'T', 'T', 'O', 'N', '\u0000'};
        EDIT = new char[]{'E', 'D', 'I', 'T', '\u0000'};
        EXPLORER = new char[]{'E', 'X', 'P', 'L', 'O', 'R', 'E', 'R', '\u0000'};
        EXPLORERBAR = new char[]{'E', 'X', 'P', 'L', 'O', 'R', 'E', 'R', 'B', 'A', 'R', '\u0000'};
        SCROLLBAR = new char[]{'S', 'C', 'R', 'O', 'L', 'L', 'B', 'A', 'R', '\u0000'};
        LISTVIEW = new char[]{'L', 'I', 'S', 'T', 'V', 'I', 'E', 'W', '\u0000'};
        TAB = new char[]{'T', 'A', 'B', '\u0000'};
        TREEVIEW = new char[]{'T', 'R', 'E', 'E', 'V', 'I', 'E', 'W', '\u0000'};
        ACCENTS = new short[]{126, 96, 39, 94, 34};
        KeyTable = new int[][]{{18, 65536}, {16, 131072}, {17, 262144}, {38, 0x1000001}, {40, 0x1000002}, {37, 0x1000003}, {39, 0x1000004}, {33, 0x1000005}, {34, 0x1000006}, {36, 0x1000007}, {35, 0x1000008}, {45, 0x1000009}, {8, 8}, {13, 13}, {46, 127}, {27, 27}, {13, 10}, {9, 9}, {112, 0x100000A}, {113, 0x100000B}, {114, 0x100000C}, {115, 0x100000D}, {116, 0x100000E}, {117, 0x100000F}, {118, 0x1000010}, {119, 0x1000011}, {120, 0x1000012}, {121, 0x1000013}, {122, 0x1000014}, {123, 0x1000015}, {124, 0x1000016}, {125, 0x1000017}, {126, 0x1000018}, {127, 0x1000019}, {128, 0x100001A}, {129, 0x100001B}, {130, 0x100001C}, {131, 0x100001D}, {106, 16777258}, {107, 16777259}, {13, 0x1000050}, {109, 16777261}, {110, 16777262}, {111, 16777263}, {96, 0x1000030}, {97, 0x1000031}, {98, 16777266}, {99, 0x1000033}, {100, 16777268}, {101, 16777269}, {102, 16777270}, {103, 16777271}, {104, 16777272}, {105, 16777273}, {20, 16777298}, {144, 16777299}, {145, 16777300}, {19, 0x1000055}, {3, 16777302}, {44, 16777303}};
        Displays = new Display[4];
        TrimEnabled = false;
        DeviceFinder = () -> {
            Display display = Display.getCurrent();
            if (display == null) {
                display = Display.getDefault();
            }
            Display.setDevice(display);
        };
    }
}

