/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MENUBARINFO;
import org.eclipse.swt.internal.win32.MENUINFO;
import org.eclipse.swt.internal.win32.MENUITEMINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SHMENUBARINFO;
import org.eclipse.swt.internal.win32.TBBUTTON;
import org.eclipse.swt.internal.win32.TBBUTTONINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Menu
extends Widget {
    public int handle;
    int x;
    int y;
    int hBrush;
    int hwndCB;
    int id0;
    int id1;
    int foreground = -1;
    int background = -1;
    Image backgroundImage;
    boolean hasLocation;
    MenuItem cascade;
    Decorations parent;
    ImageList imageList;
    MenuItem selectedMenuItem;
    static final int ID_PPC = 100;
    static final int ID_SPMM = 102;
    static final int ID_SPBM = 103;
    static final int ID_SPMB = 104;
    static final int ID_SPBB = 105;
    static final int ID_SPSOFTKEY0 = 106;
    static final int ID_SPSOFTKEY1 = 107;
    static final int ID_TOOLTIP_TIMER = 110;

    public Menu(Control control) {
        this(Menu.checkNull(control).menuShell(), 8);
    }

    public Menu(Decorations decorations, int n2) {
        this(decorations, Menu.checkStyle(n2), 0);
    }

    public Menu(Menu menu) {
        this(Menu.checkNull((Menu)menu).parent, 4);
    }

    public Menu(MenuItem menuItem) {
        this(Menu.checkNull((MenuItem)menuItem).parent);
    }

    Menu(Decorations decorations, int n2, int n3) {
        super(decorations, Menu.checkStyle(n2));
        this.parent = decorations;
        this.handle = n3;
        this.checkOrientation(decorations);
        this.createWidget();
    }

    void _setVisible(boolean bl2) {
        int n2;
        if ((this.style & 6) != 0) {
            return;
        }
        int n3 = this.parent.handle;
        if (bl2) {
            n2 = 0;
            if (OS.GetKeyState(1) >= 0) {
                n2 |= 2;
            }
            if ((this.style & 0x4000000) != 0) {
                n2 |= 8;
            }
            if ((this.parent.style & 0x8000000) != 0) {
                n2 &= 0xFFFFFFF7;
                if ((this.style & 0x2000000) != 0) {
                    n2 |= 8;
                }
            }
            int n4 = this.x;
            int n5 = this.y;
            if (!this.hasLocation) {
                int n6 = OS.GetMessagePos();
                n4 = OS.GET_X_LPARAM(n6);
                n5 = OS.GET_Y_LPARAM(n6);
            }
            this.hasLocation = false;
            Display display = this.display;
            display.sendPreExternalEventDispatchEvent();
            boolean bl3 = OS.TrackPopupMenu(this.handle, n2, n4, n5, 0, n3, null);
            display.sendPostExternalEventDispatchEvent();
            if (!bl3 && this.GetMenuItemCount(this.handle) == 0) {
                OS.SendMessage(n3, 287, OS.MAKEWPARAM(0, 65535), 0);
            }
        } else {
            OS.SendMessage(n3, 31, 0, 0);
        }
        n2 = OS.GetFocus();
        if (n2 != 0) {
            OS.NotifyWinEvent(32773, n2, -4, 0);
        }
    }

    public void addHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(helpListener);
        this.addListener(28, typedListener);
    }

    public void addMenuListener(MenuListener menuListener) {
        this.checkWidget();
        if (menuListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(menuListener);
        this.addListener(23, typedListener);
        this.addListener(22, typedListener);
    }

    static Control checkNull(Control control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    static Menu checkNull(Menu menu) {
        if (menu == null) {
            SWT.error(4);
        }
        return menu;
    }

    static MenuItem checkNull(MenuItem menuItem) {
        if (menuItem == null) {
            SWT.error(4);
        }
        return menuItem;
    }

    static int checkStyle(int n2) {
        return Menu.checkBits(n2, 8, 2, 4, 0, 0, 0);
    }

    void createHandle() {
        if (this.handle != 0) {
            return;
        }
        if ((this.style & 2) != 0) {
            if (OS.IsPPC) {
                int n2 = this.parent.handle;
                SHMENUBARINFO sHMENUBARINFO = new SHMENUBARINFO();
                sHMENUBARINFO.cbSize = SHMENUBARINFO.sizeof;
                sHMENUBARINFO.hwndParent = n2;
                sHMENUBARINFO.dwFlags = 2;
                sHMENUBARINFO.nToolBarId = 100;
                sHMENUBARINFO.hInstRes = OS.GetLibraryHandle();
                boolean bl2 = OS.SHCreateMenuBar(sHMENUBARINFO);
                this.hwndCB = sHMENUBARINFO.hwndMB;
                if (!bl2) {
                    this.error(2);
                }
                OS.SendMessage(this.hwndCB, 1046, 0, 0);
                return;
            }
            if (OS.IsSP) {
                MenuItem menuItem;
                Menu menu;
                int n3;
                int n4 = (this.style & 0x80000) != 0 ? ((this.style & 0x100000) != 0 ? 105 : 103) : ((this.style & 0x100000) != 0 ? 104 : 102);
                SHMENUBARINFO sHMENUBARINFO = new SHMENUBARINFO();
                sHMENUBARINFO.cbSize = SHMENUBARINFO.sizeof;
                sHMENUBARINFO.hwndParent = this.parent.handle;
                sHMENUBARINFO.dwFlags = 2;
                sHMENUBARINFO.nToolBarId = n4;
                sHMENUBARINFO.hInstRes = OS.GetLibraryHandle();
                if (!OS.SHCreateMenuBar(sHMENUBARINFO)) {
                    this.error(2);
                }
                this.hwndCB = sHMENUBARINFO.hwndMB;
                OS.ShowWindow(this.hwndCB, 0);
                TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
                tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
                tBBUTTONINFO.dwMask = 32;
                if (n4 == 102 || n4 == 104) {
                    n3 = OS.SendMessage(this.hwndCB, 1425, 0, 106);
                    OS.RemoveMenu(n3, 0, 1024);
                    menu = new Menu(this.parent, 4, n3);
                    menuItem = new MenuItem(this, menu, 64, 0);
                } else {
                    menuItem = new MenuItem(this, null, 8, 0);
                }
                tBBUTTONINFO.idCommand = this.id0 = menuItem.id;
                OS.SendMessage(this.hwndCB, OS.TB_SETBUTTONINFO, 106, tBBUTTONINFO);
                if (n4 == 102 || n4 == 103) {
                    n3 = OS.SendMessage(this.hwndCB, 1425, 0, 107);
                    OS.RemoveMenu(n3, 0, 1024);
                    menu = new Menu(this.parent, 4, n3);
                    menuItem = new MenuItem(this, menu, 64, 1);
                } else {
                    menuItem = new MenuItem(this, null, 8, 1);
                }
                tBBUTTONINFO.idCommand = this.id1 = menuItem.id;
                OS.SendMessage(this.hwndCB, OS.TB_SETBUTTONINFO, 107, tBBUTTONINFO);
                n3 = 3;
                int n5 = OS.MAKELPARAM(n3, n3);
                OS.SendMessage(this.hwndCB, 1427, 27, n5);
                return;
            }
            this.handle = OS.CreateMenu();
            if (this.handle == 0) {
                this.error(2);
            }
            if (OS.IsHPC) {
                int n6 = this.parent.handle;
                this.hwndCB = OS.CommandBar_Create(OS.GetModuleHandle(null), n6, 1);
                if (this.hwndCB == 0) {
                    this.error(2);
                }
                OS.CommandBar_Show(this.hwndCB, false);
                OS.CommandBar_InsertMenubarEx(this.hwndCB, 0, this.handle, 0);
                if ((this.parent.style & 0x40) != 0 && (this.parent.style & 0x20) == 0) {
                    OS.CommandBar_AddAdornments(this.hwndCB, 0, 0);
                }
            }
        } else {
            this.handle = OS.CreatePopupMenu();
            if (this.handle == 0) {
                this.error(2);
            }
        }
    }

    void createItem(MenuItem menuItem, int n2) {
        int n3 = this.GetMenuItemCount(this.handle);
        if (0 > n2 || n2 > n3) {
            this.error(6);
        }
        this.display.addMenuItem(menuItem);
        boolean bl2 = false;
        if ((OS.IsPPC || OS.IsSP) && this.hwndCB != 0) {
            if (OS.IsSP) {
                return;
            }
            TBBUTTON tBBUTTON = new TBBUTTON();
            tBBUTTON.idCommand = menuItem.id;
            tBBUTTON.fsStyle = (byte)16;
            if ((menuItem.style & 0x40) != 0) {
                tBBUTTON.fsStyle = (byte)(tBBUTTON.fsStyle | 0x88);
            }
            if ((menuItem.style & 2) != 0) {
                tBBUTTON.fsStyle = 1;
            }
            tBBUTTON.fsState = (byte)4;
            tBBUTTON.iBitmap = -2;
            bl2 = OS.SendMessage(this.hwndCB, OS.TB_INSERTBUTTON, n2, tBBUTTON) != 0;
        } else if (OS.IsWinCE) {
            int n4 = 1024;
            TCHAR tCHAR = null;
            if ((menuItem.style & 2) != 0) {
                n4 |= 0x800;
            } else {
                tCHAR = new TCHAR(0, " ", true);
            }
            bl2 = OS.InsertMenu(this.handle, n2, n4, menuItem.id, tCHAR);
            if (bl2) {
                MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
                mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
                mENUITEMINFO.fMask = 32;
                mENUITEMINFO.dwItemData = menuItem.id;
                bl2 = OS.SetMenuItemInfo(this.handle, n2, true, mENUITEMINFO);
            }
        } else {
            int n5 = OS.GetProcessHeap();
            TCHAR tCHAR = new TCHAR(0, " ", true);
            int n6 = tCHAR.length() * TCHAR.sizeof;
            int n7 = OS.HeapAlloc(n5, 8, n6);
            OS.MoveMemory(n7, tCHAR, n6);
            MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
            mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
            mENUITEMINFO.fMask = 50;
            mENUITEMINFO.wID = menuItem.id;
            mENUITEMINFO.dwItemData = menuItem.id;
            mENUITEMINFO.fType = menuItem.widgetStyle();
            mENUITEMINFO.dwTypeData = n7;
            bl2 = OS.InsertMenuItem(this.handle, n2, true, mENUITEMINFO);
            if (n7 != 0) {
                OS.HeapFree(n5, 0, n7);
            }
        }
        if (!bl2) {
            this.display.removeMenuItem(menuItem);
            this.error(14);
        }
        this.redraw();
    }

    void createWidget() {
        this.createHandle();
        this.parent.addMenu(this);
    }

    int defaultBackground() {
        return OS.GetSysColor(OS.COLOR_MENU);
    }

    int defaultForeground() {
        return OS.GetSysColor(OS.COLOR_MENUTEXT);
    }

    void destroyAccelerators() {
        this.parent.destroyAccelerators();
    }

    void destroyItem(MenuItem menuItem) {
        if (OS.IsWinCE) {
            if ((OS.IsPPC || OS.IsSP) && this.hwndCB != 0) {
                int n2;
                if (OS.IsSP) {
                    this.redraw();
                    return;
                }
                int n3 = OS.SendMessage(this.hwndCB, 1049, menuItem.id, 0);
                if (OS.SendMessage(this.hwndCB, 1046, n3, 0) == 0) {
                    this.error(15);
                }
                if ((n2 = OS.SendMessage(this.hwndCB, 1048, 0, 0)) == 0 && this.imageList != null) {
                    OS.SendMessage(this.handle, 1072, 0, 0);
                    this.display.releaseImageList(this.imageList);
                    this.imageList = null;
                }
            } else {
                int n4 = 0;
                MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
                mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
                mENUITEMINFO.fMask = 32;
                while (OS.GetMenuItemInfo(this.handle, n4, true, mENUITEMINFO) && mENUITEMINFO.dwItemData != menuItem.id) {
                    ++n4;
                }
                if (mENUITEMINFO.dwItemData != menuItem.id) {
                    this.error(15);
                }
                if (!OS.DeleteMenu(this.handle, n4, 1024)) {
                    this.error(15);
                }
            }
        } else if (!OS.DeleteMenu(this.handle, menuItem.id, 0)) {
            this.error(15);
        }
        this.redraw();
    }

    @Override
    void destroyWidget() {
        MenuItem menuItem = this.cascade;
        int n2 = this.handle;
        int n3 = this.hwndCB;
        this.releaseHandle();
        if (OS.IsWinCE && n3 != 0) {
            OS.CommandBar_Destroy(n3);
        } else if (menuItem != null) {
            if (!OS.IsSP) {
                menuItem.setMenu(null, true);
            }
        } else if (n2 != 0) {
            OS.DestroyMenu(n2);
        }
    }

    void fixMenus(Decorations decorations) {
        MenuItem[] menuItemArray = this.getItems();
        for (int i2 = 0; i2 < menuItemArray.length; ++i2) {
            menuItemArray[i2].fixMenus(decorations);
        }
        this.parent.removeMenu(this);
        decorations.addMenu(this);
        this.parent = decorations;
    }

    Color getBackground() {
        this.checkWidget();
        return Color.win32_new(this.display, this.background != -1 ? this.background : this.defaultBackground());
    }

    Image getBackgroundImage() {
        this.checkWidget();
        return this.backgroundImage;
    }

    Rectangle getBounds() {
        this.checkWidget();
        if (OS.IsWinCE) {
            return new Rectangle(0, 0, 0, 0);
        }
        if ((this.style & 2) != 0) {
            if (this.parent.menuBar != this) {
                return new Rectangle(0, 0, 0, 0);
            }
            int n2 = this.parent.handle;
            MENUBARINFO mENUBARINFO = new MENUBARINFO();
            mENUBARINFO.cbSize = MENUBARINFO.sizeof;
            if (OS.GetMenuBarInfo(n2, -3, 0, mENUBARINFO)) {
                int n3 = mENUBARINFO.right - mENUBARINFO.left;
                int n4 = mENUBARINFO.bottom - mENUBARINFO.top;
                return new Rectangle(mENUBARINFO.left, mENUBARINFO.top, n3, n4);
            }
        } else {
            RECT rECT;
            RECT rECT2;
            int n5 = this.GetMenuItemCount(this.handle);
            if (n5 != 0 && OS.GetMenuItemRect(0, this.handle, 0, rECT2 = new RECT()) && OS.GetMenuItemRect(0, this.handle, n5 - 1, rECT = new RECT())) {
                int n6 = rECT2.left - 2;
                int n7 = rECT2.top - 2;
                int n8 = rECT.right - rECT.left + 4;
                int n9 = rECT.bottom - rECT2.top + 4;
                return new Rectangle(n6, n7, n8, n9);
            }
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public MenuItem getDefaultItem() {
        this.checkWidget();
        if (OS.IsWinCE) {
            return null;
        }
        int n2 = OS.GetMenuDefaultItem(this.handle, 0, 1);
        if (n2 == -1) {
            return null;
        }
        MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
        mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
        mENUITEMINFO.fMask = 2;
        if (OS.GetMenuItemInfo(this.handle, n2, false, mENUITEMINFO)) {
            return this.display.getMenuItem(mENUITEMINFO.wID);
        }
        return null;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    Color getForeground() {
        this.checkWidget();
        return Color.win32_new(this.display, this.foreground != -1 ? this.foreground : this.defaultForeground());
    }

    public MenuItem getItem(int n2) {
        this.checkWidget();
        int n3 = 0;
        if ((OS.IsPPC || OS.IsSP) && this.hwndCB != 0) {
            if (OS.IsPPC) {
                TBBUTTON tBBUTTON = new TBBUTTON();
                int n4 = OS.SendMessage(this.hwndCB, 1047, n2, tBBUTTON);
                if (n4 == 0) {
                    this.error(8);
                }
                n3 = tBBUTTON.idCommand;
            }
            if (OS.IsSP) {
                if (0 > n2 || n2 > 1) {
                    this.error(8);
                }
                n3 = n2 == 0 ? this.id0 : this.id1;
            }
        } else {
            MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
            mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
            mENUITEMINFO.fMask = 32;
            if (!OS.GetMenuItemInfo(this.handle, n2, true, mENUITEMINFO)) {
                this.error(6);
            }
            n3 = mENUITEMINFO.dwItemData;
        }
        return this.display.getMenuItem(n3);
    }

    public int getItemCount() {
        this.checkWidget();
        return this.GetMenuItemCount(this.handle);
    }

    public MenuItem[] getItems() {
        MenuItem[] menuItemArray;
        int n2;
        this.checkWidget();
        if ((OS.IsPPC || OS.IsSP) && this.hwndCB != 0) {
            if (OS.IsSP) {
                MenuItem[] menuItemArray2 = new MenuItem[]{this.display.getMenuItem(this.id0), this.display.getMenuItem(this.id1)};
                return menuItemArray2;
            }
            int n3 = OS.SendMessage(this.hwndCB, 1048, 0, 0);
            TBBUTTON tBBUTTON = new TBBUTTON();
            MenuItem[] menuItemArray3 = new MenuItem[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                OS.SendMessage(this.hwndCB, 1047, i2, tBBUTTON);
                menuItemArray3[i2] = this.display.getMenuItem(tBBUTTON.idCommand);
            }
            return menuItemArray3;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = n2 = OS.IsWinCE ? 4 : OS.GetMenuItemCount(this.handle);
        if (n2 < 0) {
            int n7 = OS.GetLastError();
            SWT.error(36, null, " [GetLastError=0x" + Integer.toHexString(n7) + "]");
        }
        MenuItem[] menuItemArray4 = new MenuItem[n2];
        MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
        mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
        mENUITEMINFO.fMask = 32;
        while (OS.GetMenuItemInfo(this.handle, n4, true, mENUITEMINFO)) {
            if (n5 == menuItemArray4.length) {
                menuItemArray = new MenuItem[n5 + 4];
                System.arraycopy(menuItemArray4, 0, menuItemArray, 0, n5);
                menuItemArray4 = menuItemArray;
            }
            if ((menuItemArray = this.display.getMenuItem(mENUITEMINFO.dwItemData)) != null) {
                menuItemArray4[n5++] = menuItemArray;
            }
            ++n4;
        }
        if (n5 == menuItemArray4.length) {
            return menuItemArray4;
        }
        menuItemArray = new MenuItem[n5];
        System.arraycopy(menuItemArray4, 0, menuItemArray, 0, n5);
        return menuItemArray;
    }

    int GetMenuItemCount(int n2) {
        if (OS.IsWinCE) {
            if ((OS.IsPPC || OS.IsSP) && this.hwndCB != 0) {
                return OS.IsSP ? 2 : OS.SendMessage(this.hwndCB, 1048, 0, 0);
            }
            int n3 = 0;
            MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
            mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
            while (OS.GetMenuItemInfo(n2, n3, true, mENUITEMINFO)) {
                ++n3;
            }
            return n3;
        }
        return OS.GetMenuItemCount(n2);
    }

    @Override
    String getNameText() {
        String string = "";
        MenuItem[] menuItemArray = this.getItems();
        int n2 = menuItemArray.length;
        if (n2 > 0) {
            for (int i2 = 0; i2 <= n2 - 1; ++i2) {
                string = string + (menuItemArray[i2] == null ? "null" : menuItemArray[i2].getNameText()) + (i2 < n2 - 1 ? ", " : "");
            }
        }
        return string;
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Decorations getParent() {
        this.checkWidget();
        return this.parent;
    }

    public MenuItem getParentItem() {
        this.checkWidget();
        return this.cascade;
    }

    public Menu getParentMenu() {
        this.checkWidget();
        if (this.cascade != null) {
            return this.cascade.parent;
        }
        return null;
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public boolean getVisible() {
        Menu menu;
        Menu[] menuArray;
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return this == this.parent.menuShell().menuBar;
        }
        if ((this.style & 8) != 0) {
            menuArray = this.display.popups;
            if (menuArray == null) {
                return false;
            }
            for (int i2 = 0; i2 < menuArray.length; ++i2) {
                if (menuArray[i2] != this) continue;
                return true;
            }
        }
        menuArray = this.getShell();
        for (menu = menuArray.activeMenu; menu != null && menu != this; menu = menu.getParentMenu()) {
        }
        return this == menu;
    }

    void hideCurrentToolTip() {
        if (this.selectedMenuItem != null) {
            this.selectedMenuItem.hideToolTip();
        }
    }

    int imageIndex(Image image) {
        if (this.hwndCB == 0 || image == null) {
            return -2;
        }
        if (this.imageList == null) {
            Rectangle rectangle = image.getBoundsInPixels();
            this.imageList = this.display.getImageList(this.style & 0x4000000, rectangle.width, rectangle.height);
            int n2 = this.imageList.add(image);
            int n3 = this.imageList.getHandle();
            OS.SendMessage(this.hwndCB, 1072, 0, n3);
            return n2;
        }
        int n4 = this.imageList.indexOf(image);
        if (n4 == -1) {
            n4 = this.imageList.add(image);
        } else {
            this.imageList.put(n4, image);
        }
        return n4;
    }

    public int indexOf(MenuItem menuItem) {
        this.checkWidget();
        if (menuItem == null) {
            this.error(4);
        }
        if (menuItem.isDisposed()) {
            this.error(5);
        }
        if (menuItem.parent != this) {
            return -1;
        }
        if ((OS.IsPPC || OS.IsSP) && this.hwndCB != 0) {
            if (OS.IsPPC) {
                return OS.SendMessage(this.hwndCB, 1049, menuItem.id, 0);
            }
            if (OS.IsSP) {
                if (menuItem.id == this.id0) {
                    return 0;
                }
                if (menuItem.id == this.id1) {
                    return 1;
                }
                return -1;
            }
        }
        int n2 = 0;
        MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
        mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
        mENUITEMINFO.fMask = 32;
        while (OS.GetMenuItemInfo(this.handle, n2, true, mENUITEMINFO)) {
            if (mENUITEMINFO.dwItemData == menuItem.id) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public boolean isEnabled() {
        this.checkWidget();
        Menu menu = this.getParentMenu();
        if (menu == null) {
            return this.getEnabled() && this.parent.isEnabled();
        }
        return this.getEnabled() && menu.isEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    void redraw() {
        if (!this.isVisible()) {
            return;
        }
        if ((this.style & 2) != 0) {
            this.display.addBar(this);
        } else {
            this.update();
        }
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.hwndCB = 0;
        this.handle = 0;
        this.cascade = null;
    }

    @Override
    void releaseChildren(boolean bl2) {
        MenuItem[] menuItemArray = this.getItems();
        for (int i2 = 0; i2 < menuItemArray.length; ++i2) {
            MenuItem menuItem = menuItemArray[i2];
            if (menuItem == null || menuItem.isDisposed()) continue;
            if (OS.IsPPC && this.hwndCB != 0) {
                menuItem.dispose();
                continue;
            }
            menuItem.release(false);
        }
        super.releaseChildren(bl2);
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if ((this.style & 2) != 0) {
            this.display.removeBar(this);
            if (this == this.parent.menuBar) {
                this.parent.setMenuBar(null);
            }
        } else if ((this.style & 8) != 0) {
            this.display.removePopup(this);
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.backgroundImage = null;
        if (this.hBrush != 0) {
            OS.DeleteObject(this.hBrush);
        }
        this.hBrush = 0;
        if (OS.IsPPC && this.hwndCB != 0 && this.imageList != null) {
            OS.SendMessage(this.hwndCB, 1072, 0, 0);
            this.display.releaseToolImageList(this.imageList);
            this.imageList = null;
        }
        if (this.parent != null) {
            this.parent.removeMenu(this);
        }
        this.parent = null;
    }

    public void removeHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, helpListener);
    }

    public void removeMenuListener(MenuListener menuListener) {
        this.checkWidget();
        if (menuListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(23, menuListener);
        this.eventTable.unhook(22, menuListener);
    }

    @Override
    void reskinChildren(int n2) {
        MenuItem[] menuItemArray = this.getItems();
        for (int i2 = 0; i2 < menuItemArray.length; ++i2) {
            MenuItem menuItem = menuItemArray[i2];
            menuItem.reskin(n2);
        }
        super.reskinChildren(n2);
    }

    void setBackground(Color color) {
        this.checkWidget();
        int n2 = -1;
        if (color != null) {
            if (color.isDisposed()) {
                this.error(5);
            }
            n2 = color.handle;
        }
        if (n2 == this.background) {
            return;
        }
        this.background = n2;
        this.updateBackground();
    }

    void setBackgroundImage(Image image) {
        this.checkWidget();
        if (image != null) {
            if (image.isDisposed()) {
                this.error(5);
            }
            if (image.type != 0) {
                this.error(5);
            }
        }
        if (this.backgroundImage == image) {
            return;
        }
        this.backgroundImage = image;
        this.updateBackground();
    }

    void setForeground(Color color) {
        this.checkWidget();
        int n2 = -1;
        if (color != null) {
            if (color.isDisposed()) {
                this.error(5);
            }
            n2 = color.handle;
        }
        if (n2 == this.foreground) {
            return;
        }
        this.foreground = n2;
        this.updateForeground();
    }

    public void setDefaultItem(MenuItem menuItem) {
        this.checkWidget();
        int n2 = -1;
        if (menuItem != null) {
            if (menuItem.isDisposed()) {
                this.error(5);
            }
            if (menuItem.parent != this) {
                return;
            }
            n2 = menuItem.id;
        }
        if (OS.IsWinCE) {
            return;
        }
        int n3 = OS.GetMenuDefaultItem(this.handle, 0, 1);
        if (n2 == n3) {
            return;
        }
        OS.SetMenuDefaultItem(this.handle, n2, 0);
        this.redraw();
    }

    public void setEnabled(boolean bl2) {
        this.checkWidget();
        this.state &= 0xFFFFFFF7;
        if (!bl2) {
            this.state |= 8;
        }
    }

    public void setLocation(int n2, int n3) {
        this.checkWidget();
        this.setLocationInPixels(DPIUtil.autoScaleUp(n2), DPIUtil.autoScaleUp(n3));
    }

    void setLocationInPixels(int n2, int n3) {
        if ((this.style & 6) != 0) {
            return;
        }
        this.x = n2;
        this.y = n3;
        this.hasLocation = true;
    }

    public void setLocation(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        point = DPIUtil.autoScaleUp(point);
        this.setLocationInPixels(point.x, point.y);
    }

    public void setOrientation(int n2) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        this._setOrientation(n2);
    }

    void _setOrientation(int n2) {
        if (OS.IsWinCE) {
            return;
        }
        if (OS.WIN32_VERSION < OS.VERSION(4, 10)) {
            return;
        }
        int n3 = 0x6000000;
        if ((n2 & n3) == 0 || (n2 & n3) == n3) {
            return;
        }
        this.style &= ~n3;
        this.style |= n2 & n3;
        this.style &= Integer.MAX_VALUE;
        MenuItem[] menuItemArray = this.getItems();
        for (int i2 = 0; i2 < menuItemArray.length; ++i2) {
            menuItemArray[i2].setOrientation(n2);
        }
    }

    public void setVisible(boolean bl2) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        if (bl2) {
            this.display.addPopup(this);
        } else {
            this.display.removePopup(this);
            this._setVisible(false);
        }
    }

    void update() {
        if (OS.IsPPC || OS.IsSP) {
            return;
        }
        if (OS.IsHPC) {
            Menu menu = this.parent.menuBar;
            if (menu != null) {
                Menu menu2;
                for (menu2 = this; menu2 != null && menu2 != menu; menu2 = menu2.getParentMenu()) {
                }
                if (menu2 == menu) {
                    OS.CommandBar_DrawMenuBar(menu.hwndCB, 0);
                    OS.CommandBar_Show(menu.hwndCB, true);
                }
            }
            return;
        }
        if (OS.IsWinCE) {
            return;
        }
        if ((this.style & 2) != 0) {
            if (this == this.parent.menuBar) {
                OS.DrawMenuBar(this.parent.handle);
            }
            return;
        }
        if (OS.WIN32_VERSION < OS.VERSION(4, 10)) {
            return;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        MenuItem[] menuItemArray = this.getItems();
        for (int i2 = 0; i2 < menuItemArray.length; ++i2) {
            MenuItem menuItem = menuItemArray[i2];
            if (menuItem.image != null) {
                bl3 = true;
                if (true && bl2) break;
            }
            if ((menuItem.style & 0x30) == 0) continue;
            bl2 = true;
            if (true && bl3) break;
        }
        if (!OS.IsWin95 && OS.WIN32_VERSION < OS.VERSION(6, 0)) {
            MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
            mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
            mENUITEMINFO.fMask = 128;
            for (int i3 = 0; i3 < menuItemArray.length; ++i3) {
                MenuItem menuItem = menuItemArray[i3];
                if ((this.style & 2) != 0 || menuItem.image != null && this.foreground == -1) continue;
                mENUITEMINFO.hbmpItem = bl3 || this.foreground != -1 ? -1 : 0;
                OS.SetMenuItemInfo(this.handle, menuItem.id, false, mENUITEMINFO);
            }
        }
        MENUINFO mENUINFO = new MENUINFO();
        mENUINFO.cbSize = MENUINFO.sizeof;
        mENUINFO.fMask = 16;
        OS.GetMenuInfo(this.handle, mENUINFO);
        mENUINFO.dwStyle = bl3 && !bl2 ? (mENUINFO.dwStyle |= 0x4000000) : (mENUINFO.dwStyle &= 0xFBFFFFFF);
        OS.SetMenuInfo(this.handle, mENUINFO);
    }

    void updateBackground() {
        if (this.hBrush != 0) {
            OS.DeleteObject(this.hBrush);
        }
        this.hBrush = 0;
        if (this.backgroundImage != null) {
            this.hBrush = OS.CreatePatternBrush(this.backgroundImage.handle);
        } else if (this.background != -1) {
            this.hBrush = OS.CreateSolidBrush(this.background);
        }
        MENUINFO mENUINFO = new MENUINFO();
        mENUINFO.cbSize = MENUINFO.sizeof;
        mENUINFO.fMask = 2;
        mENUINFO.hbrBack = this.hBrush;
        OS.SetMenuInfo(this.handle, mENUINFO);
    }

    void updateForeground() {
        if (OS.WIN32_VERSION < OS.VERSION(4, 10)) {
            return;
        }
        MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
        mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
        int n2 = 0;
        while (OS.GetMenuItemInfo(this.handle, n2, true, mENUITEMINFO)) {
            mENUITEMINFO.fMask = 128;
            mENUITEMINFO.hbmpItem = -1;
            OS.SetMenuItemInfo(this.handle, n2, true, mENUITEMINFO);
            ++n2;
        }
        this.redraw();
    }

    LRESULT wmTimer(int n2, int n3) {
        if (n2 == 110) {
            POINT pOINT = new POINT();
            OS.GetCursorPos(pOINT);
            if (this.selectedMenuItem != null) {
                RECT rECT = new RECT();
                boolean bl2 = OS.GetMenuItemRect(0, this.selectedMenuItem.parent.handle, this.selectedMenuItem.index, rECT);
                if (!bl2) {
                    return null;
                }
                if (OS.PtInRect(rECT, pOINT)) {
                    this.selectedMenuItem.showTooltip(pOINT.x, pOINT.y + OS.GetSystemMetrics(14) / 2 + 5);
                } else {
                    this.selectedMenuItem.showTooltip((rECT.right + rECT.left) / 2, rECT.bottom + 5);
                }
            }
        }
        return null;
    }
}

