/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCROLLBARINFO;
import org.eclipse.swt.internal.win32.SCROLLINFO;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ScrollBar
extends Widget {
    Scrollable parent;
    int increment;
    int pageIncrement;

    ScrollBar(Scrollable scrollable, int n2) {
        super(scrollable, ScrollBar.checkStyle(n2));
        this.parent = scrollable;
        this.createWidget();
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n2) {
        return ScrollBar.checkBits(n2, 256, 512, 0, 0, 0, 0);
    }

    void createWidget() {
        this.increment = 1;
        this.pageIncrement = 10;
    }

    @Override
    void destroyWidget() {
        int n2 = this.hwndScrollBar();
        int n3 = this.scrollBarType();
        if (OS.IsWinCE) {
            SCROLLINFO sCROLLINFO = new SCROLLINFO();
            sCROLLINFO.cbSize = SCROLLINFO.sizeof;
            sCROLLINFO.fMask = 3;
            sCROLLINFO.nPage = 101;
            sCROLLINFO.nMax = 100;
            sCROLLINFO.nMin = 0;
            OS.SetScrollInfo(n2, n3, sCROLLINFO, true);
        } else {
            OS.ShowScrollBar(n2, n3, false);
        }
        this.parent.destroyScrollBar(this.style);
        this.releaseHandle();
    }

    Rectangle getBounds() {
        int n2;
        int n3;
        this.parent.forceResize();
        RECT rECT = new RECT();
        OS.GetClientRect(this.parent.scrolledHandle(), rECT);
        int n4 = 0;
        int n5 = 0;
        if ((this.style & 0x100) != 0) {
            n5 = rECT.bottom - rECT.top;
            n3 = rECT.right - rECT.left;
            n2 = OS.GetSystemMetrics(3);
        } else {
            n4 = rECT.right - rECT.left;
            n3 = OS.GetSystemMetrics(2);
            n2 = rECT.bottom - rECT.top;
        }
        return new Rectangle(n4, n5, n3, n2);
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public int getIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public int getMaximum() {
        this.checkWidget();
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        sCROLLINFO.fMask = 1;
        int n2 = this.hwndScrollBar();
        int n3 = this.scrollBarType();
        OS.GetScrollInfo(n2, n3, sCROLLINFO);
        return sCROLLINFO.nMax;
    }

    public int getMinimum() {
        this.checkWidget();
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        sCROLLINFO.fMask = 1;
        int n2 = this.hwndScrollBar();
        int n3 = this.scrollBarType();
        OS.GetScrollInfo(n2, n3, sCROLLINFO);
        return sCROLLINFO.nMin;
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public Scrollable getParent() {
        this.checkWidget();
        return this.parent;
    }

    public int getSelection() {
        this.checkWidget();
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        sCROLLINFO.fMask = 4;
        int n2 = this.hwndScrollBar();
        int n3 = this.scrollBarType();
        OS.GetScrollInfo(n2, n3, sCROLLINFO);
        return sCROLLINFO.nPos;
    }

    public Point getSize() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getSizeInPixels());
    }

    Point getSizeInPixels() {
        int n2;
        int n3;
        this.parent.forceResize();
        RECT rECT = new RECT();
        OS.GetClientRect(this.parent.scrolledHandle(), rECT);
        if ((this.style & 0x100) != 0) {
            n3 = rECT.right - rECT.left;
            n2 = OS.GetSystemMetrics(3);
        } else {
            n3 = OS.GetSystemMetrics(2);
            n2 = rECT.bottom - rECT.top;
        }
        return new Point(n3, n2);
    }

    public int getThumb() {
        this.checkWidget();
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        sCROLLINFO.fMask = 2;
        int n2 = this.hwndScrollBar();
        int n3 = this.scrollBarType();
        OS.GetScrollInfo(n2, n3, sCROLLINFO);
        if (sCROLLINFO.nPage != 0) {
            --sCROLLINFO.nPage;
        }
        return sCROLLINFO.nPage;
    }

    public Rectangle getThumbBounds() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getThumbBoundsInPixels());
    }

    Rectangle getThumbBoundsInPixels() {
        int n2;
        int n3;
        int n4;
        int n5;
        this.parent.forceResize();
        SCROLLBARINFO sCROLLBARINFO = new SCROLLBARINFO();
        sCROLLBARINFO.cbSize = SCROLLBARINFO.sizeof;
        if ((this.style & 0x100) != 0) {
            OS.GetScrollBarInfo(this.parent.handle, -6, sCROLLBARINFO);
            n5 = sCROLLBARINFO.rcScrollBar.left + sCROLLBARINFO.xyThumbTop;
            n4 = sCROLLBARINFO.rcScrollBar.top;
            n3 = sCROLLBARINFO.xyThumbBottom - sCROLLBARINFO.xyThumbTop;
            n2 = sCROLLBARINFO.rcScrollBar.bottom - sCROLLBARINFO.rcScrollBar.top;
        } else {
            OS.GetScrollBarInfo(this.parent.handle, -5, sCROLLBARINFO);
            n5 = sCROLLBARINFO.rcScrollBar.left;
            n4 = sCROLLBARINFO.rcScrollBar.top + sCROLLBARINFO.xyThumbTop;
            n3 = sCROLLBARINFO.rcScrollBar.right - sCROLLBARINFO.rcScrollBar.left;
            n2 = sCROLLBARINFO.xyThumbBottom - sCROLLBARINFO.xyThumbTop;
        }
        RECT rECT = new RECT();
        rECT.left = n5;
        rECT.top = n4;
        rECT.right = n5 + n3;
        rECT.bottom = n4 + n2;
        OS.MapWindowPoints(0, this.parent.handle, rECT, 2);
        return new Rectangle(rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top);
    }

    public Rectangle getThumbTrackBounds() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getThumbTrackBoundsInPixels());
    }

    Rectangle getThumbTrackBoundsInPixels() {
        int n2;
        int n3;
        int n4;
        this.parent.forceResize();
        SCROLLBARINFO sCROLLBARINFO = new SCROLLBARINFO();
        sCROLLBARINFO.cbSize = SCROLLBARINFO.sizeof;
        int n5 = 0;
        int n6 = 0;
        if ((this.style & 0x100) != 0) {
            OS.GetScrollBarInfo(this.parent.handle, -6, sCROLLBARINFO);
            n4 = OS.GetSystemMetrics(3);
            n6 = sCROLLBARINFO.rcScrollBar.top;
            n3 = sCROLLBARINFO.rcScrollBar.right - sCROLLBARINFO.rcScrollBar.left;
            n2 = n4;
            if (n3 <= 2 * n4) {
                n5 = sCROLLBARINFO.rcScrollBar.left + n3 / 2;
                n3 = 0;
            } else {
                n5 = sCROLLBARINFO.rcScrollBar.left + n4;
                n3 -= 2 * n4;
            }
        } else {
            OS.GetScrollBarInfo(this.parent.handle, -5, sCROLLBARINFO);
            n4 = OS.GetSystemMetrics(20);
            n5 = sCROLLBARINFO.rcScrollBar.left;
            n3 = n4;
            n2 = sCROLLBARINFO.rcScrollBar.bottom - sCROLLBARINFO.rcScrollBar.top;
            if (n2 <= 2 * n4) {
                n6 = sCROLLBARINFO.rcScrollBar.top + n2 / 2;
                n2 = 0;
            } else {
                n6 = sCROLLBARINFO.rcScrollBar.top + n4;
                n2 -= 2 * n4;
            }
        }
        RECT rECT = new RECT();
        rECT.left = n5;
        rECT.top = n6;
        rECT.right = n5 + n3;
        rECT.bottom = n6 + n2;
        OS.MapWindowPoints(0, this.parent.handle, rECT, 2);
        return new Rectangle(rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top);
    }

    public boolean getVisible() {
        this.checkWidget();
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
            SCROLLBARINFO sCROLLBARINFO = new SCROLLBARINFO();
            sCROLLBARINFO.cbSize = SCROLLBARINFO.sizeof;
            int n2 = (this.style & 0x200) != 0 ? -5 : -6;
            OS.GetScrollBarInfo(this.hwndScrollBar(), n2, sCROLLBARINFO);
            return (sCROLLBARINFO.rgstate[0] & 0x8000) == 0;
        }
        return (this.state & 0x10) == 0;
    }

    int hwndScrollBar() {
        return this.parent.scrolledHandle();
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.parent.isVisible();
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.parent.horizontalBar == this) {
            this.parent.horizontalBar = null;
        }
        if (this.parent.verticalBar == this) {
            this.parent.verticalBar = null;
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    int scrollBarType() {
        return (this.style & 0x200) != 0 ? 1 : 0;
    }

    public void setEnabled(boolean bl2) {
        this.checkWidget();
        if (!OS.IsWinCE) {
            int n2 = this.hwndScrollBar();
            int n3 = this.scrollBarType();
            int n4 = bl2 ? 0 : 3;
            OS.EnableScrollBar(n2, n3, n4);
            this.state = bl2 ? (this.state &= 0xFFFFFFF7) : (this.state |= 8);
        }
    }

    public void setIncrement(int n2) {
        this.checkWidget();
        if (n2 < 1) {
            return;
        }
        this.increment = n2;
    }

    public void setMaximum(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        int n3 = this.hwndScrollBar();
        int n4 = this.scrollBarType();
        sCROLLINFO.fMask = 9;
        OS.GetScrollInfo(n3, n4, sCROLLINFO);
        if (n2 - sCROLLINFO.nMin - sCROLLINFO.nPage < 1) {
            return;
        }
        sCROLLINFO.nMax = n2;
        this.SetScrollInfo(n3, n4, sCROLLINFO, true);
    }

    public void setMinimum(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        int n3 = this.hwndScrollBar();
        int n4 = this.scrollBarType();
        sCROLLINFO.fMask = 9;
        OS.GetScrollInfo(n3, n4, sCROLLINFO);
        if (sCROLLINFO.nMax - n2 - sCROLLINFO.nPage < 1) {
            return;
        }
        sCROLLINFO.nMin = n2;
        this.SetScrollInfo(n3, n4, sCROLLINFO, true);
    }

    public void setPageIncrement(int n2) {
        this.checkWidget();
        if (n2 < 1) {
            return;
        }
        this.pageIncrement = n2;
    }

    boolean SetScrollInfo(int n2, int n3, SCROLLINFO sCROLLINFO, boolean bl2) {
        boolean bl3 = false;
        boolean bl4 = this.getVisible();
        ScrollBar scrollBar = null;
        if (!OS.IsWinCE) {
            switch (n3) {
                case 0: {
                    scrollBar = this.parent.getVerticalBar();
                    break;
                }
                case 1: {
                    scrollBar = this.parent.getHorizontalBar();
                }
            }
            boolean bl5 = bl3 = scrollBar != null && scrollBar.getVisible();
        }
        if (!bl4 || (this.state & 8) != 0) {
            bl2 = false;
        }
        boolean bl6 = OS.SetScrollInfo(n2, n3, sCROLLINFO, bl2);
        if (!bl4 && !OS.IsWinCE) {
            OS.ShowScrollBar(n2, !bl3 ? 3 : n3, false);
        }
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0) && bl4 && scrollBar != null && !bl3) {
            OS.ShowScrollBar(n2, n3 == 0 ? 1 : 0, false);
        }
        if ((this.state & 8) != 0 && !OS.IsWinCE) {
            OS.EnableScrollBar(n2, n3, 3);
        }
        return bl6;
    }

    public void setSelection(int n2) {
        this.checkWidget();
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        int n3 = this.hwndScrollBar();
        int n4 = this.scrollBarType();
        sCROLLINFO.fMask = 4;
        sCROLLINFO.nPos = n2;
        this.SetScrollInfo(n3, n4, sCROLLINFO, true);
    }

    public void setThumb(int n2) {
        this.checkWidget();
        if (n2 < 1) {
            return;
        }
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        int n3 = this.hwndScrollBar();
        int n4 = this.scrollBarType();
        sCROLLINFO.fMask = 11;
        OS.GetScrollInfo(n3, n4, sCROLLINFO);
        sCROLLINFO.nPage = n2;
        if (sCROLLINFO.nPage != 0) {
            ++sCROLLINFO.nPage;
        }
        this.SetScrollInfo(n3, n4, sCROLLINFO, true);
    }

    public void setValues(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.checkWidget();
        if (n3 < 0) {
            return;
        }
        if (n4 < 0) {
            return;
        }
        if (n5 < 1) {
            return;
        }
        if (n6 < 1) {
            return;
        }
        if (n7 < 1) {
            return;
        }
        this.increment = n6;
        this.pageIncrement = n7;
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        sCROLLINFO.fMask = 15;
        sCROLLINFO.nPos = n2;
        sCROLLINFO.nMin = n3;
        sCROLLINFO.nMax = n4;
        sCROLLINFO.nPage = n5;
        if (sCROLLINFO.nPage != 0) {
            ++sCROLLINFO.nPage;
        }
        int n8 = this.hwndScrollBar();
        int n9 = this.scrollBarType();
        this.SetScrollInfo(n8, n9, sCROLLINFO, true);
    }

    public void setVisible(boolean bl2) {
        Object object;
        this.checkWidget();
        if (bl2 == this.getVisible()) {
            return;
        }
        if (OS.IsWinCE) {
            SCROLLINFO sCROLLINFO = new SCROLLINFO();
            sCROLLINFO.cbSize = SCROLLINFO.sizeof;
            int n2 = this.hwndScrollBar();
            int n3 = this.scrollBarType();
            sCROLLINFO.fMask = 3;
            if (bl2) {
                sCROLLINFO.fMask |= 8;
            }
            OS.GetScrollInfo(n2, n3, sCROLLINFO);
            if (sCROLLINFO.nPage == sCROLLINFO.nMax - sCROLLINFO.nMin + 1) {
                int n4 = sCROLLINFO.nMax++;
                OS.SetScrollInfo(n2, n3, sCROLLINFO, false);
                sCROLLINFO.nMax = n4;
                OS.SetScrollInfo(n2, n3, sCROLLINFO, true);
            }
            return;
        }
        this.state = bl2 ? this.state & 0xFFFFFFEF : this.state | 0x10;
        int n5 = this.hwndScrollBar();
        int n6 = this.scrollBarType();
        if (!bl2 && OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            object = new SCROLLBARINFO();
            ((SCROLLBARINFO)object).cbSize = SCROLLBARINFO.sizeof;
            int n7 = (this.style & 0x200) != 0 ? -6 : -5;
            OS.GetScrollBarInfo(n5, n7, (SCROLLBARINFO)object);
            if ((((SCROLLBARINFO)object).rgstate[0] & 0x8000) != 0) {
                OS.ShowScrollBar(n5, n6 == 1 ? 0 : 1, true);
                n6 = 3;
            }
        }
        if (OS.ShowScrollBar(n5, n6, bl2)) {
            if ((this.state & 8) == 0) {
                object = new SCROLLINFO();
                ((SCROLLINFO)object).cbSize = SCROLLINFO.sizeof;
                ((SCROLLINFO)object).fMask = 3;
                OS.GetScrollInfo(n5, n6, (SCROLLINFO)object);
                if (((SCROLLINFO)object).nMax - ((SCROLLINFO)object).nMin - ((SCROLLINFO)object).nPage >= 0) {
                    OS.EnableScrollBar(n5, n6, 0);
                }
            }
            this.sendEvent(bl2 ? 22 : 23);
        }
    }

    LRESULT wmScrollChild(int n2, int n3) {
        int n4 = OS.LOWORD(n2);
        if (n4 == 8) {
            return null;
        }
        Event event = new Event();
        switch (n4) {
            case 4: {
                event.detail = 0;
                break;
            }
            case 5: {
                event.detail = 1;
                break;
            }
            case 6: {
                event.detail = 0x1000007;
                break;
            }
            case 7: {
                event.detail = 0x1000008;
                break;
            }
            case 1: {
                event.detail = 0x1000002;
                break;
            }
            case 0: {
                event.detail = 0x1000001;
                break;
            }
            case 3: {
                event.detail = 0x1000006;
                break;
            }
            case 2: {
                event.detail = 0x1000005;
            }
        }
        this.sendSelectionEvent(13, event, true);
        return null;
    }
}

