/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TBBUTTONINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ToolItem
extends Item {
    ToolBar parent;
    Control control;
    String toolTipText;
    Image disabledImage;
    Image hotImage;
    Image disabledImage2;
    int id;
    short cx;

    public ToolItem(ToolBar toolBar, int n2) {
        super(toolBar, ToolItem.checkStyle(n2));
        this.parent = toolBar;
        toolBar.createItem(this, toolBar.getItemCount());
    }

    public ToolItem(ToolBar toolBar, int n2, int n3) {
        super(toolBar, ToolItem.checkStyle(n2));
        this.parent = toolBar;
        toolBar.createItem(this, n3);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n2) {
        return ToolItem.checkBits(n2, 8, 32, 16, 2, 4, 0);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void click(boolean bl2) {
        int n2 = this.parent.handle;
        if (OS.GetKeyState(1) < 0) {
            return;
        }
        int n3 = OS.SendMessage(n2, 1049, this.id, 0);
        RECT rECT = new RECT();
        OS.SendMessage(n2, 1053, n3, rECT);
        int n4 = OS.SendMessage(n2, 1095, 0, 0);
        int n5 = rECT.top + (rECT.bottom - rECT.top) / 2;
        int n6 = OS.MAKELPARAM(bl2 ? rECT.right - 1 : rECT.left, n5);
        this.parent.ignoreMouse = true;
        OS.SendMessage(n2, 513, 0, n6);
        OS.SendMessage(n2, 514, 0, n6);
        this.parent.ignoreMouse = false;
        if (n4 != -1) {
            OS.SendMessage(n2, 1096, n4, 0);
        }
    }

    Widget[] computeTabList() {
        if (this.isTabGroup() && this.getEnabled()) {
            if ((this.style & 2) != 0) {
                if (this.control != null) {
                    return this.control.computeTabList();
                }
            } else {
                return new Widget[]{this};
            }
        }
        return new Widget[0];
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getBoundsInPixels());
    }

    Rectangle getBoundsInPixels() {
        int n2 = this.parent.handle;
        int n3 = OS.SendMessage(n2, 1049, this.id, 0);
        RECT rECT = new RECT();
        OS.SendMessage(n2, 1053, n3, rECT);
        int n4 = rECT.right - rECT.left;
        int n5 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n4, n5);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public Image getDisabledImage() {
        this.checkWidget();
        return this.disabledImage;
    }

    public boolean getEnabled() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return (this.state & 8) == 0;
        }
        int n2 = this.parent.handle;
        int n3 = OS.SendMessage(n2, 1042, this.id, 0);
        return (n3 & 4) != 0;
    }

    public Image getHotImage() {
        this.checkWidget();
        return this.hotImage;
    }

    public ToolBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        int n2 = this.parent.handle;
        int n3 = OS.SendMessage(n2, 1042, this.id, 0);
        return (n3 & 1) != 0;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getWidthInPixels());
    }

    int getWidthInPixels() {
        int n2 = this.parent.handle;
        int n3 = OS.SendMessage(n2, 1049, this.id, 0);
        RECT rECT = new RECT();
        OS.SendMessage(n2, 1053, n3, rECT);
        return rECT.right - rECT.left;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    boolean isTabGroup() {
        int n2;
        ToolItem[] toolItemArray = this.parent._getTabItemList();
        if (toolItemArray != null) {
            for (n2 = 0; n2 < toolItemArray.length; ++n2) {
                if (toolItemArray[n2] != this) continue;
                return true;
            }
        }
        if ((this.style & 2) != 0) {
            return true;
        }
        n2 = this.parent.indexOf(this);
        if (n2 == 0) {
            return true;
        }
        ToolItem toolItem = this.parent.getItem(n2 - 1);
        return (toolItem.getStyle() & 2) != 0;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.releaseImages();
        this.control = null;
        this.toolTipText = null;
        this.hotImage = null;
        this.disabledImage = null;
        if (this.disabledImage2 != null) {
            this.disabledImage2.dispose();
        }
        this.disabledImage2 = null;
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
        this.id = -1;
    }

    void releaseImages() {
        TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
        tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
        tBBUTTONINFO.dwMask = 9;
        int n2 = this.parent.handle;
        OS.SendMessage(n2, OS.TB_GETBUTTONINFO, this.id, tBBUTTONINFO);
        if ((tBBUTTONINFO.fsStyle & 1) == 0 && tBBUTTONINFO.iImage != -2) {
            ImageList imageList = this.parent.getImageList();
            ImageList imageList2 = this.parent.getHotImageList();
            ImageList imageList3 = this.parent.getDisabledImageList();
            if (imageList != null) {
                imageList.put(tBBUTTONINFO.iImage, null);
            }
            if (imageList2 != null) {
                imageList2.put(tBBUTTONINFO.iImage, null);
            }
            if (imageList3 != null) {
                imageList3.put(tBBUTTONINFO.iImage, null);
            }
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void resizeControl() {
        if (this.control != null && !this.control.isDisposed()) {
            Rectangle rectangle = this.getBounds();
            this.control.setSize(rectangle.width, rectangle.height);
            Rectangle rectangle2 = this.control.getBounds();
            rectangle2.x = rectangle.x + (rectangle.width - rectangle2.width) / 2;
            rectangle2.y = rectangle.y + (rectangle.height - rectangle2.height) / 2;
            this.control.setLocation(rectangle2.x, rectangle2.y);
        }
    }

    void selectRadio() {
        ToolItem[] toolItemArray = this.parent.getItems();
        for (int i2 = 0; i2 < toolItemArray.length && toolItemArray[i2] != this; ++i2) {
        }
        for (int i3 = i2 - 1; i3 >= 0 && toolItemArray[i3].setRadioSelection(false); --i3) {
        }
        for (int i4 = i2 + 1; i4 < toolItemArray.length && toolItemArray[i4].setRadioSelection(false); ++i4) {
        }
        this.setSelection(true);
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if ((this.style & 2) == 0) {
            return;
        }
        this.control = control;
        if ((this.parent.style & 0x240) != 0) {
            boolean bl2 = false;
            int n2 = this.parent.handle;
            TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
            tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
            tBBUTTONINFO.dwMask = 12;
            OS.SendMessage(n2, OS.TB_GETBUTTONINFO, this.id, tBBUTTONINFO);
            if (control == null) {
                if ((tBBUTTONINFO.fsStyle & 1) == 0) {
                    bl2 = true;
                    tBBUTTONINFO.fsStyle = (byte)(tBBUTTONINFO.fsStyle & 0xFFFFFFBF);
                    tBBUTTONINFO.fsStyle = (byte)(tBBUTTONINFO.fsStyle | 1);
                    tBBUTTONINFO.fsState = (this.state & 8) != 0 ? (byte)(tBBUTTONINFO.fsState & 0xFFFFFFFB) : (byte)(tBBUTTONINFO.fsState | 4);
                }
            } else if ((tBBUTTONINFO.fsStyle & 1) != 0) {
                bl2 = true;
                tBBUTTONINFO.fsStyle = (byte)(tBBUTTONINFO.fsStyle & 0xFFFFFFFE);
                tBBUTTONINFO.fsStyle = (byte)(tBBUTTONINFO.fsStyle | 0x40);
                tBBUTTONINFO.fsState = (byte)(tBBUTTONINFO.fsState & 0xFFFFFFFB);
                tBBUTTONINFO.dwMask |= 1;
                tBBUTTONINFO.iImage = -2;
            }
            if (bl2) {
                OS.SendMessage(n2, OS.TB_SETBUTTONINFO, this.id, tBBUTTONINFO);
                if (OS.SendMessage(n2, 1064, 0, 0) > 1) {
                    OS.InvalidateRect(n2, null, true);
                }
            }
        }
        this.resizeControl();
    }

    public void setEnabled(boolean bl2) {
        this.checkWidget();
        int n2 = this.parent.handle;
        int n3 = OS.SendMessage(n2, 1042, this.id, 0);
        if ((n3 & 4) != 0 == bl2) {
            return;
        }
        if (bl2) {
            n3 |= 4;
            this.state &= 0xFFFFFFF7;
        } else {
            n3 &= 0xFFFFFFFB;
            this.state |= 8;
        }
        OS.SendMessage(n2, 1041, this.id, n3);
        if ((this.style & 2) == 0 && this.image != null) {
            this.updateImages(bl2 && this.parent.getEnabled());
        }
    }

    public void setDisabledImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.disabledImage = image;
        this.updateImages(this.getEnabled() && this.parent.getEnabled());
    }

    public void setHotImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.hotImage = image;
        this.updateImages(this.getEnabled() && this.parent.getEnabled());
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        super.setImage(image);
        this.updateImages(this.getEnabled() && this.parent.getEnabled());
    }

    boolean setRadioSelection(boolean bl2) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != bl2) {
            this.setSelection(bl2);
            this.sendSelectionEvent(13);
        }
        return true;
    }

    public void setSelection(boolean bl2) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        int n2 = this.parent.handle;
        int n3 = OS.SendMessage(n2, 1042, this.id, 0);
        if ((n3 & 1) != 0 == bl2) {
            return;
        }
        n3 = bl2 ? (n3 |= 1) : (n3 &= 0xFFFFFFFE);
        OS.SendMessage(n2, 1041, this.id, n3);
        if (!((this.style & 0x30) == 0 || this.getEnabled() && this.parent.getEnabled())) {
            this.updateImages(false);
        }
    }

    @Override
    boolean setTabItemFocus() {
        if (this.parent.setTabItemFocus()) {
            int n2 = this.parent.handle;
            int n3 = OS.SendMessage(n2, 1049, this.id, 0);
            OS.SendMessage(n2, 1096, n3, 0);
            return true;
        }
        return false;
    }

    void _setText(String string) {
        int n2 = this.parent.handle;
        TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
        tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
        tBBUTTONINFO.dwMask = 10;
        tBBUTTONINFO.fsStyle = (byte)(this.widgetStyle() | 0x10);
        int n3 = OS.GetProcessHeap();
        int n4 = 0;
        if (string.length() != 0) {
            int n5;
            tBBUTTONINFO.fsStyle = (byte)(tBBUTTONINFO.fsStyle | 0x40);
            TCHAR tCHAR = OS.IsUnicode && (this.style & Integer.MIN_VALUE) != 0 ? (((n5 = OS.GetWindowLong(n2, -20)) & 0x400000) != 0 ? new TCHAR(this.parent.getCodePage(), '\u202a' + string, true) : new TCHAR(this.parent.getCodePage(), '\u202b' + string, true)) : new TCHAR(this.parent.getCodePage(), string, true);
            n5 = tCHAR.length() * TCHAR.sizeof;
            n4 = OS.HeapAlloc(n3, 8, n5);
            OS.MoveMemory(n4, tCHAR, n5);
            tBBUTTONINFO.pszText = n4;
        }
        OS.SendMessage(n2, OS.TB_SETBUTTONINFO, this.id, tBBUTTONINFO);
        if (n4 != 0) {
            OS.HeapFree(n3, 0, n4);
        }
    }

    @Override
    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if (string.equals(this.text)) {
            return;
        }
        super.setText(string);
        if ((this.state & 0x400000) == 0 || !this.updateTextDirection(0x6000000)) {
            this._setText(string);
        }
        this.parent.setDropDownItems(false);
        int n2 = this.parent.handle;
        int n3 = OS.SendMessage(n2, 49, 0, 0);
        OS.SendMessage(n2, 48, n3, 0);
        this.parent.setDropDownItems(true);
        this.parent.layoutItems();
    }

    @Override
    boolean updateTextDirection(int n2) {
        if (super.updateTextDirection(n2) && this.text.length() != 0) {
            this._setText(this.text);
            return true;
        }
        return false;
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
    }

    public void setWidth(int n2) {
        this.checkWidget();
        this.setWidthInPixels(DPIUtil.autoScaleUp(n2));
    }

    void setWidthInPixels(int n2) {
        if ((this.style & 2) == 0) {
            return;
        }
        if (n2 < 0) {
            return;
        }
        int n3 = this.parent.handle;
        TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
        tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
        tBBUTTONINFO.dwMask = 64;
        tBBUTTONINFO.cx = this.cx = (short)n2;
        OS.SendMessage(n3, OS.TB_SETBUTTONINFO, this.id, tBBUTTONINFO);
        this.parent.layoutItems();
    }

    void updateImages(boolean bl2) {
        Object object;
        if ((this.style & 2) != 0) {
            return;
        }
        int n2 = this.parent.handle;
        TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
        tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
        tBBUTTONINFO.dwMask = 1;
        OS.SendMessage(n2, OS.TB_GETBUTTONINFO, this.id, tBBUTTONINFO);
        if (tBBUTTONINFO.iImage == -2 && this.image == null) {
            return;
        }
        ImageList imageList = this.parent.getImageList();
        ImageList imageList2 = this.parent.getHotImageList();
        ImageList imageList3 = this.parent.getDisabledImageList();
        if (tBBUTTONINFO.iImage == -2) {
            object = this.image.getBoundsInPixels();
            int n3 = this.parent.style & 0x4000000;
            if (imageList == null) {
                imageList = this.display.getImageListToolBar(n3, ((Rectangle)object).width, ((Rectangle)object).height);
            }
            if (imageList3 == null) {
                imageList3 = this.display.getImageListToolBarDisabled(n3, ((Rectangle)object).width, ((Rectangle)object).height);
            }
            if (imageList2 == null) {
                imageList2 = this.display.getImageListToolBarHot(n3, ((Rectangle)object).width, ((Rectangle)object).height);
            }
            Image image = this.disabledImage;
            if (this.disabledImage == null) {
                if (this.disabledImage2 != null) {
                    this.disabledImage2.dispose();
                }
                this.disabledImage2 = null;
                image = this.image;
                if (!bl2) {
                    image = this.disabledImage2 = new Image((Device)this.display, this.image, 1);
                }
            }
            Image image2 = this.image;
            Image image3 = this.hotImage;
            if ((this.style & 0x30) != 0 && !bl2) {
                image2 = image3 = image;
            }
            tBBUTTONINFO.iImage = imageList.add(image2);
            imageList3.add(image);
            imageList2.add(image3 != null ? image3 : image2);
            this.parent.setImageList(imageList);
            this.parent.setDisabledImageList(imageList3);
            this.parent.setHotImageList(imageList2);
        } else {
            object = null;
            if (imageList3 != null) {
                if (this.image != null) {
                    if (this.disabledImage2 != null) {
                        this.disabledImage2.dispose();
                    }
                    this.disabledImage2 = null;
                    object = this.disabledImage;
                    if (this.disabledImage == null) {
                        object = this.image;
                        if (!bl2) {
                            this.disabledImage2 = new Image((Device)this.display, this.image, 1);
                            object = this.disabledImage2;
                        }
                    }
                }
                imageList3.put(tBBUTTONINFO.iImage, (Image)object);
            }
            Object object2 = this.image;
            Object object3 = this.hotImage;
            if ((this.style & 0x30) != 0 && !bl2) {
                object2 = object3 = object;
            }
            if (imageList != null) {
                imageList.put(tBBUTTONINFO.iImage, (Image)object2);
            }
            if (imageList2 != null) {
                imageList2.put(tBBUTTONINFO.iImage, (Image)(object3 != null ? object3 : object2));
            }
            if (this.image == null) {
                tBBUTTONINFO.iImage = -2;
            }
        }
        tBBUTTONINFO.dwMask |= 0x40;
        tBBUTTONINFO.cx = 0;
        OS.SendMessage(n2, OS.TB_SETBUTTONINFO, this.id, tBBUTTONINFO);
        int n4 = OS.SendMessage(n2, 49, 0, 0);
        OS.SendMessage(n2, 48, n4, 0);
        this.parent.layoutItems();
    }

    int widgetStyle() {
        if ((this.style & 4) != 0) {
            return 8;
        }
        if ((this.style & 8) != 0) {
            return 0;
        }
        if ((this.style & 0x20) != 0) {
            return 2;
        }
        if ((this.style & 0x10) != 0) {
            return 2;
        }
        if ((this.style & 2) != 0) {
            return 1;
        }
        return 0;
    }

    LRESULT wmCommandChild(int n2, int n3) {
        if ((this.style & 0x10) != 0 && (this.parent.getStyle() & 0x400000) == 0) {
            this.selectRadio();
        }
        this.sendSelectionEvent(13);
        return null;
    }
}

