/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.HDITEM;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TOOLINFO;
import org.eclipse.swt.internal.win32.TVITEM;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;

public class TreeColumn
extends Item {
    Tree parent;
    boolean resizable = true;
    boolean moveable;
    String toolTipText;
    int id;

    public TreeColumn(Tree tree, int n2) {
        super(tree, TreeColumn.checkStyle(n2));
        this.parent = tree;
        tree.createItem(this, tree.getColumnCount());
    }

    public TreeColumn(Tree tree, int n2, int n3) {
        super(tree, TreeColumn.checkStyle(n2));
        this.parent = tree;
        tree.createItem(this, n3);
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n2) {
        return TreeColumn.checkBits(n2, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public boolean getMoveable() {
        this.checkWidget();
        return this.moveable;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    public Tree getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getResizable() {
        this.checkWidget();
        return this.resizable;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getWidthInPixels());
    }

    int getWidthInPixels() {
        int n2 = this.parent.indexOf(this);
        if (n2 == -1) {
            return 0;
        }
        int n3 = this.parent.hwndHeader;
        if (n3 == 0) {
            return 0;
        }
        HDITEM hDITEM = new HDITEM();
        hDITEM.mask = 1;
        OS.SendMessage(n3, OS.HDM_GETITEM, n2, hDITEM);
        return hDITEM.cxy;
    }

    public void pack() {
        Object object;
        int n2;
        RECT rECT;
        this.checkWidget();
        int n3 = this.parent.indexOf(this);
        if (n3 == -1) {
            return;
        }
        int n4 = 0;
        int n5 = this.parent.handle;
        int n6 = this.parent.hwndHeader;
        RECT rECT2 = new RECT();
        OS.SendMessage(n6, 4615, n3, rECT2);
        int n7 = OS.GetDC(n5);
        int n8 = 0;
        int n9 = OS.SendMessage(n5, 49, 0, 0);
        if (n9 != 0) {
            n8 = OS.SelectObject(n7, n9);
        }
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 28;
        tVITEM.hItem = OS.SendMessage(n5, 4362, 0, 0);
        while (tVITEM.hItem != 0) {
            OS.SendMessage(n5, OS.TVM_GETITEM, 0, tVITEM);
            RECT rECT3 = rECT = tVITEM.lParam != -1 ? this.parent.items[tVITEM.lParam] : null;
            if (rECT != null) {
                Object object2;
                int n10;
                n2 = 0;
                if (this.parent.hooks(41)) {
                    n10 = (tVITEM.state & 2) != 0 ? 2 : 0;
                    object2 = this.parent.sendMeasureItemEvent((TreeItem)((Object)rECT), n3, n7, n10);
                    if (this.isDisposed() || this.parent.isDisposed()) break;
                    object = ((Event)object2).getBoundsInPixels();
                    n2 = ((Rectangle)object).x + ((Rectangle)object).width;
                } else {
                    n10 = ((TreeItem)((Object)rECT)).fontHandle(n3);
                    if (n10 != -1) {
                        n10 = OS.SelectObject(n7, n10);
                    }
                    object2 = ((TreeItem)((Object)rECT)).getBounds(n3, true, true, false, false, false, n7);
                    if (n10 != -1) {
                        OS.SelectObject(n7, n10);
                    }
                    n2 = ((RECT)object2).right;
                }
                n4 = Math.max(n4, n2 - rECT2.left);
            }
            tVITEM.hItem = OS.SendMessage(n5, 4362, 6, tVITEM.hItem);
        }
        rECT = new RECT();
        n2 = 3072;
        TCHAR tCHAR = new TCHAR(this.parent.getCodePage(), this.text, false);
        OS.DrawText(n7, tCHAR, tCHAR.length(), rECT, n2);
        int n11 = rECT.right - rECT.left + 12;
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            n11 += 3;
        }
        if (this.image != null || this.parent.sortColumn == this) {
            object = null;
            if (this.parent.sortColumn == this && this.parent.sortDirection != 0) {
                if (OS.COMCTL32_MAJOR < 6) {
                    object = this.display.getSortImage(this.parent.sortDirection);
                } else {
                    n11 += 10;
                }
            } else {
                object = this.image;
            }
            if (object != null) {
                Rectangle rectangle = ((Image)object).getBoundsInPixels();
                n11 += rectangle.width;
            }
            int n12 = 0;
            n12 = n6 != 0 && OS.COMCTL32_VERSION >= OS.VERSION(5, 80) ? OS.SendMessage(n6, 4629, 0, 0) : OS.GetSystemMetrics(45) * 3;
            n11 += n12 * 2;
        }
        if (n9 != 0) {
            OS.SelectObject(n7, n8);
        }
        OS.ReleaseDC(n5, n7);
        int n13 = this.parent.linesVisible ? 1 : 0;
        this.setWidthInPixels(Math.max(n11, n4 + n13));
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.parent.sortColumn == this) {
            this.parent.sortColumn = null;
        }
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, controlListener);
        this.eventTable.unhook(11, controlListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setAlignment(int n2) {
        this.checkWidget();
        if ((n2 & 0x1024000) == 0) {
            return;
        }
        int n3 = this.parent.indexOf(this);
        if (n3 == -1 || n3 == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= n2 & 0x1024000;
        int n4 = this.parent.hwndHeader;
        if (n4 == 0) {
            return;
        }
        HDITEM hDITEM = new HDITEM();
        hDITEM.mask = 4;
        OS.SendMessage(n4, OS.HDM_GETITEM, n3, hDITEM);
        hDITEM.fmt &= 0xFFFFFFFC;
        if ((this.style & 0x4000) == 16384) {
            hDITEM.fmt |= 0;
        }
        if ((this.style & 0x1000000) == 0x1000000) {
            hDITEM.fmt |= 2;
        }
        if ((this.style & 0x20000) == 131072) {
            hDITEM.fmt |= 1;
        }
        OS.SendMessage(n4, OS.HDM_SETITEM, n3, hDITEM);
        if (n3 != 0) {
            int n5 = this.parent.handle;
            this.parent.forceResize();
            RECT rECT = new RECT();
            RECT rECT2 = new RECT();
            OS.GetClientRect(n5, rECT);
            OS.SendMessage(n4, 4615, n3, rECT2);
            rECT.left = rECT2.left;
            rECT.right = rECT2.right;
            OS.InvalidateRect(n5, rECT, true);
        }
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        super.setImage(image);
        if (this.parent.sortColumn != this || this.parent.sortDirection != 0) {
            this.setImage(image, false, false);
        }
    }

    void setImage(Image image, boolean bl2, boolean bl3) {
        int n2 = this.parent.indexOf(this);
        if (n2 == -1) {
            return;
        }
        int n3 = this.parent.hwndHeader;
        if (n3 == 0) {
            return;
        }
        HDITEM hDITEM = new HDITEM();
        hDITEM.mask = 52;
        OS.SendMessage(n3, OS.HDM_GETITEM, n2, hDITEM);
        hDITEM.fmt &= 0xFFFFEFFF;
        if (image != null) {
            if (bl2) {
                hDITEM.mask &= 0xFFFFFFDF;
                hDITEM.fmt &= 0xFFFFF7FF;
                hDITEM.fmt |= 0x2000;
                hDITEM.hbm = image.handle;
            } else {
                hDITEM.mask &= 0xFFFFFFEF;
                hDITEM.fmt &= 0xFFFFDFFF;
                hDITEM.fmt |= 0x800;
                hDITEM.iImage = this.parent.imageIndexHeader(image);
            }
            if (bl3) {
                hDITEM.fmt |= 0x1000;
            }
        } else {
            hDITEM.mask &= 0xFFFFFFCF;
            hDITEM.fmt &= 0xFFFFD7FF;
        }
        OS.SendMessage(n3, OS.HDM_SETITEM, n2, hDITEM);
    }

    public void setMoveable(boolean bl2) {
        this.checkWidget();
        this.moveable = bl2;
    }

    public void setResizable(boolean bl2) {
        this.checkWidget();
        this.resizable = bl2;
    }

    void setSortDirection(int n2) {
        if (OS.COMCTL32_MAJOR >= 6) {
            int n3 = this.parent.hwndHeader;
            if (n3 != 0) {
                int n4 = this.parent.indexOf(this);
                if (n4 == -1) {
                    return;
                }
                HDITEM hDITEM = new HDITEM();
                hDITEM.mask = 36;
                OS.SendMessage(n3, OS.HDM_GETITEM, n4, hDITEM);
                switch (n2) {
                    case 128: {
                        hDITEM.fmt &= 0xFFFFF5FF;
                        hDITEM.fmt |= 0x400;
                        if (this.image != null) break;
                        hDITEM.mask &= 0xFFFFFFDF;
                        break;
                    }
                    case 1024: {
                        hDITEM.fmt &= 0xFFFFF3FF;
                        hDITEM.fmt |= 0x200;
                        if (this.image != null) break;
                        hDITEM.mask &= 0xFFFFFFDF;
                        break;
                    }
                    case 0: {
                        hDITEM.fmt &= 0xFFFFF9FF;
                        if (this.image != null) {
                            hDITEM.fmt |= 0x800;
                            hDITEM.iImage = this.parent.imageIndexHeader(this.image);
                            break;
                        }
                        hDITEM.fmt &= 0xFFFFF7FF;
                        hDITEM.mask &= 0xFFFFFFDF;
                    }
                }
                OS.SendMessage(n3, OS.HDM_SETITEM, n4, hDITEM);
                if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
                    int n5 = this.parent.handle;
                    this.parent.forceResize();
                    RECT rECT = new RECT();
                    RECT rECT2 = new RECT();
                    OS.GetClientRect(n5, rECT);
                    OS.SendMessage(n3, 4615, n4, rECT2);
                    rECT.left = rECT2.left;
                    rECT.right = rECT2.right;
                    OS.InvalidateRect(n5, rECT, true);
                }
            }
        } else {
            switch (n2) {
                case 128: 
                case 1024: {
                    this.setImage(this.display.getSortImage(n2), true, true);
                    break;
                }
                case 0: {
                    this.setImage(this.image, false, false);
                }
            }
        }
    }

    @Override
    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        int n2 = this.parent.indexOf(this);
        if (n2 == -1) {
            return;
        }
        super.setText(string);
        boolean bl2 = !OS.IsWinCE && OS.WIN32_VERSION <= OS.VERSION(4, 10);
        int n3 = OS.GetProcessHeap();
        TCHAR tCHAR = new TCHAR(this.parent.getCodePage(), this.fixMnemonic(string, bl2), true);
        int n4 = tCHAR.length() * TCHAR.sizeof;
        int n5 = OS.HeapAlloc(n3, 8, n4);
        OS.MoveMemory(n5, tCHAR, n4);
        int n6 = this.parent.hwndHeader;
        if (n6 == 0) {
            return;
        }
        HDITEM hDITEM = new HDITEM();
        hDITEM.mask = 2;
        hDITEM.pszText = n5;
        int n7 = OS.SendMessage(n6, OS.HDM_SETITEM, n2, hDITEM);
        if (n5 != 0) {
            OS.HeapFree(n3, 0, n5);
        }
        if (n7 == 0) {
            this.error(13);
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        int n2 = this.parent.headerToolTipHandle;
        if (n2 == 0) {
            this.parent.createHeaderToolTips();
            this.parent.updateHeaderToolTips();
        }
    }

    public void setWidth(int n2) {
        this.checkWidget();
        this.setWidthInPixels(DPIUtil.autoScaleUp(n2));
    }

    void setWidthInPixels(int n2) {
        if (n2 < 0) {
            return;
        }
        int n3 = this.parent.indexOf(this);
        if (n3 == -1) {
            return;
        }
        int n4 = this.parent.hwndHeader;
        if (n4 == 0) {
            return;
        }
        HDITEM hDITEM = new HDITEM();
        hDITEM.mask = 1;
        hDITEM.cxy = n2;
        OS.SendMessage(n4, OS.HDM_SETITEM, n3, hDITEM);
        RECT rECT = new RECT();
        OS.SendMessage(n4, 4615, n3, rECT);
        this.parent.forceResize();
        int n5 = this.parent.handle;
        RECT rECT2 = new RECT();
        OS.GetClientRect(n5, rECT2);
        rECT2.left = rECT.left;
        OS.InvalidateRect(n5, rECT2, true);
        this.parent.setScrollWidth();
    }

    void updateToolTip(int n2) {
        RECT rECT;
        int n3;
        int n4 = this.parent.headerToolTipHandle;
        if (n4 != 0 && OS.SendMessage(n3 = this.parent.hwndHeader, 4615, n2, rECT = new RECT()) != 0) {
            TOOLINFO tOOLINFO = new TOOLINFO();
            tOOLINFO.cbSize = TOOLINFO.sizeof;
            tOOLINFO.hwnd = n3;
            tOOLINFO.uId = this.id;
            tOOLINFO.left = rECT.left;
            tOOLINFO.top = rECT.top;
            tOOLINFO.right = rECT.right;
            tOOLINFO.bottom = rECT.bottom;
            OS.SendMessage(n4, OS.TTM_NEWTOOLRECT, 0, tOOLINFO);
        }
    }
}

