/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.XErrorEvent$Buffer;

public class XErrorEvent
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int DISPLAY;
    public static final int RESOURCEID;
    public static final int SERIAL;
    public static final int ERROR_CODE;
    public static final int REQUEST_CODE;
    public static final int MINOR_CODE;

    protected XErrorEvent(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected XErrorEvent create(long l2, ByteBuffer byteBuffer) {
        return new XErrorEvent(l2, byteBuffer);
    }

    public XErrorEvent(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), XErrorEvent.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int type() {
        return XErrorEvent.ntype(this.address());
    }

    public long display() {
        return XErrorEvent.ndisplay(this.address());
    }

    public long resourceid() {
        return XErrorEvent.nresourceid(this.address());
    }

    public long serial() {
        return XErrorEvent.nserial(this.address());
    }

    public byte error_code() {
        return XErrorEvent.nerror_code(this.address());
    }

    public byte request_code() {
        return XErrorEvent.nrequest_code(this.address());
    }

    public byte minor_code() {
        return XErrorEvent.nminor_code(this.address());
    }

    public XErrorEvent type(int n2) {
        XErrorEvent.ntype(this.address(), n2);
        return this;
    }

    public XErrorEvent display(long l2) {
        XErrorEvent.ndisplay(this.address(), l2);
        return this;
    }

    public XErrorEvent resourceid(long l2) {
        XErrorEvent.nresourceid(this.address(), l2);
        return this;
    }

    public XErrorEvent serial(long l2) {
        XErrorEvent.nserial(this.address(), l2);
        return this;
    }

    public XErrorEvent error_code(byte by2) {
        XErrorEvent.nerror_code(this.address(), by2);
        return this;
    }

    public XErrorEvent request_code(byte by2) {
        XErrorEvent.nrequest_code(this.address(), by2);
        return this;
    }

    public XErrorEvent minor_code(byte by2) {
        XErrorEvent.nminor_code(this.address(), by2);
        return this;
    }

    public XErrorEvent set(int n2, long l2, long l3, long l4, byte by2, byte by3, byte by4) {
        this.type(n2);
        this.display(l2);
        this.resourceid(l3);
        this.serial(l4);
        this.error_code(by2);
        this.request_code(by3);
        this.minor_code(by4);
        return this;
    }

    public XErrorEvent set(XErrorEvent xErrorEvent) {
        MemoryUtil.memCopy(xErrorEvent.address(), this.address(), SIZEOF);
        return this;
    }

    public static XErrorEvent malloc() {
        return new XErrorEvent(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XErrorEvent calloc() {
        return new XErrorEvent(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XErrorEvent create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new XErrorEvent(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static XErrorEvent create(long l2) {
        return new XErrorEvent(l2, null);
    }

    public static XErrorEvent createSafe(long l2) {
        return l2 == 0L ? null : new XErrorEvent(l2, null);
    }

    public static XErrorEvent$Buffer malloc(int n2) {
        return new XErrorEvent$Buffer(MemoryUtil.nmemAllocChecked(XErrorEvent.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static XErrorEvent$Buffer calloc(int n2) {
        return new XErrorEvent$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static XErrorEvent$Buffer create(int n2) {
        ByteBuffer byteBuffer = XErrorEvent.__create(n2, SIZEOF);
        return new XErrorEvent$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n2, n2);
    }

    public static XErrorEvent$Buffer create(long l2, int n2) {
        return new XErrorEvent$Buffer(l2, n2);
    }

    public static XErrorEvent$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : new XErrorEvent$Buffer(l2, n2);
    }

    public static XErrorEvent mallocStack() {
        return XErrorEvent.malloc(MemoryStack.stackGet());
    }

    public static XErrorEvent callocStack() {
        return XErrorEvent.calloc(MemoryStack.stackGet());
    }

    public static XErrorEvent mallocStack(MemoryStack memoryStack) {
        return XErrorEvent.malloc(memoryStack);
    }

    public static XErrorEvent callocStack(MemoryStack memoryStack) {
        return XErrorEvent.calloc(memoryStack);
    }

    public static XErrorEvent$Buffer mallocStack(int n2) {
        return XErrorEvent.malloc(n2, MemoryStack.stackGet());
    }

    public static XErrorEvent$Buffer callocStack(int n2) {
        return XErrorEvent.calloc(n2, MemoryStack.stackGet());
    }

    public static XErrorEvent$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return XErrorEvent.malloc(n2, memoryStack);
    }

    public static XErrorEvent$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return XErrorEvent.calloc(n2, memoryStack);
    }

    public static XErrorEvent malloc(MemoryStack memoryStack) {
        return new XErrorEvent(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XErrorEvent calloc(MemoryStack memoryStack) {
        return new XErrorEvent(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static XErrorEvent$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new XErrorEvent$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static XErrorEvent$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new XErrorEvent$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int ntype(long l2) {
        return UNSAFE.getInt(null, l2 + (long)TYPE);
    }

    public static long ndisplay(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)DISPLAY);
    }

    public static long nresourceid(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)RESOURCEID);
    }

    public static long nserial(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)SERIAL);
    }

    public static byte nerror_code(long l2) {
        return UNSAFE.getByte(null, l2 + (long)ERROR_CODE);
    }

    public static byte nrequest_code(long l2) {
        return UNSAFE.getByte(null, l2 + (long)REQUEST_CODE);
    }

    public static byte nminor_code(long l2) {
        return UNSAFE.getByte(null, l2 + (long)MINOR_CODE);
    }

    public static void ntype(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)TYPE, n2);
    }

    public static void ndisplay(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)DISPLAY, Checks.check(l3));
    }

    public static void nresourceid(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)RESOURCEID, l3);
    }

    public static void nserial(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)SERIAL, l3);
    }

    public static void nerror_code(long l2, byte by2) {
        UNSAFE.putByte(null, l2 + (long)ERROR_CODE, by2);
    }

    public static void nrequest_code(long l2, byte by2) {
        UNSAFE.putByte(null, l2 + (long)REQUEST_CODE, by2);
    }

    public static void nminor_code(long l2, byte by2) {
        UNSAFE.putByte(null, l2 + (long)MINOR_CODE, by2);
    }

    public static void validate(long l2) {
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)DISPLAY));
    }

    static {
        Struct$Layout struct$Layout = XErrorEvent.__struct(XErrorEvent.__member(4), XErrorEvent.__member(POINTER_SIZE), XErrorEvent.__member(CLONG_SIZE), XErrorEvent.__member(CLONG_SIZE), XErrorEvent.__member(1), XErrorEvent.__member(1), XErrorEvent.__member(1));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        TYPE = struct$Layout.offsetof(0);
        DISPLAY = struct$Layout.offsetof(1);
        RESOURCEID = struct$Layout.offsetof(2);
        SERIAL = struct$Layout.offsetof(3);
        ERROR_CODE = struct$Layout.offsetof(4);
        REQUEST_CODE = struct$Layout.offsetof(5);
        MINOR_CODE = struct$Layout.offsetof(6);
    }
}

