/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.windows.TOUCHINPUT$Buffer;

public class TOUCHINPUT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int HSOURCE;
    public static final int DWID;
    public static final int DWFLAGS;
    public static final int DWMASK;
    public static final int DWTIME;
    public static final int DWEXTRAINFO;
    public static final int CXCONTACT;
    public static final int CYCONTACT;

    protected TOUCHINPUT(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected TOUCHINPUT create(long l2, ByteBuffer byteBuffer) {
        return new TOUCHINPUT(l2, byteBuffer);
    }

    public TOUCHINPUT(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), TOUCHINPUT.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int x() {
        return TOUCHINPUT.nx(this.address());
    }

    public int y() {
        return TOUCHINPUT.ny(this.address());
    }

    public long hSource() {
        return TOUCHINPUT.nhSource(this.address());
    }

    public int dwID() {
        return TOUCHINPUT.ndwID(this.address());
    }

    public int dwFlags() {
        return TOUCHINPUT.ndwFlags(this.address());
    }

    public int dwMask() {
        return TOUCHINPUT.ndwMask(this.address());
    }

    public int dwTime() {
        return TOUCHINPUT.ndwTime(this.address());
    }

    public long dwExtraInfo() {
        return TOUCHINPUT.ndwExtraInfo(this.address());
    }

    public int cxContact() {
        return TOUCHINPUT.ncxContact(this.address());
    }

    public int cyContact() {
        return TOUCHINPUT.ncyContact(this.address());
    }

    public static TOUCHINPUT malloc() {
        return new TOUCHINPUT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static TOUCHINPUT calloc() {
        return new TOUCHINPUT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static TOUCHINPUT create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new TOUCHINPUT(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static TOUCHINPUT create(long l2) {
        return new TOUCHINPUT(l2, null);
    }

    public static TOUCHINPUT createSafe(long l2) {
        return l2 == 0L ? null : new TOUCHINPUT(l2, null);
    }

    public static TOUCHINPUT$Buffer malloc(int n2) {
        return new TOUCHINPUT$Buffer(MemoryUtil.nmemAllocChecked(TOUCHINPUT.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static TOUCHINPUT$Buffer calloc(int n2) {
        return new TOUCHINPUT$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static TOUCHINPUT$Buffer create(int n2) {
        ByteBuffer byteBuffer = TOUCHINPUT.__create(n2, SIZEOF);
        return new TOUCHINPUT$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n2, n2);
    }

    public static TOUCHINPUT$Buffer create(long l2, int n2) {
        return new TOUCHINPUT$Buffer(l2, n2);
    }

    public static TOUCHINPUT$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : new TOUCHINPUT$Buffer(l2, n2);
    }

    public static TOUCHINPUT mallocStack() {
        return TOUCHINPUT.malloc(MemoryStack.stackGet());
    }

    public static TOUCHINPUT callocStack() {
        return TOUCHINPUT.calloc(MemoryStack.stackGet());
    }

    public static TOUCHINPUT mallocStack(MemoryStack memoryStack) {
        return TOUCHINPUT.malloc(memoryStack);
    }

    public static TOUCHINPUT callocStack(MemoryStack memoryStack) {
        return TOUCHINPUT.calloc(memoryStack);
    }

    public static TOUCHINPUT$Buffer mallocStack(int n2) {
        return TOUCHINPUT.malloc(n2, MemoryStack.stackGet());
    }

    public static TOUCHINPUT$Buffer callocStack(int n2) {
        return TOUCHINPUT.calloc(n2, MemoryStack.stackGet());
    }

    public static TOUCHINPUT$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return TOUCHINPUT.malloc(n2, memoryStack);
    }

    public static TOUCHINPUT$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return TOUCHINPUT.calloc(n2, memoryStack);
    }

    public static TOUCHINPUT malloc(MemoryStack memoryStack) {
        return new TOUCHINPUT(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static TOUCHINPUT calloc(MemoryStack memoryStack) {
        return new TOUCHINPUT(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static TOUCHINPUT$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new TOUCHINPUT$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static TOUCHINPUT$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new TOUCHINPUT$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int nx(long l2) {
        return UNSAFE.getInt(null, l2 + (long)X);
    }

    public static int ny(long l2) {
        return UNSAFE.getInt(null, l2 + (long)Y);
    }

    public static long nhSource(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)HSOURCE);
    }

    public static int ndwID(long l2) {
        return UNSAFE.getInt(null, l2 + (long)DWID);
    }

    public static int ndwFlags(long l2) {
        return UNSAFE.getInt(null, l2 + (long)DWFLAGS);
    }

    public static int ndwMask(long l2) {
        return UNSAFE.getInt(null, l2 + (long)DWMASK);
    }

    public static int ndwTime(long l2) {
        return UNSAFE.getInt(null, l2 + (long)DWTIME);
    }

    public static long ndwExtraInfo(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)DWEXTRAINFO);
    }

    public static int ncxContact(long l2) {
        return UNSAFE.getInt(null, l2 + (long)CXCONTACT);
    }

    public static int ncyContact(long l2) {
        return UNSAFE.getInt(null, l2 + (long)CYCONTACT);
    }

    static {
        Struct$Layout struct$Layout = TOUCHINPUT.__struct(TOUCHINPUT.__member(4), TOUCHINPUT.__member(4), TOUCHINPUT.__member(POINTER_SIZE), TOUCHINPUT.__member(4), TOUCHINPUT.__member(4), TOUCHINPUT.__member(4), TOUCHINPUT.__member(4), TOUCHINPUT.__member(POINTER_SIZE), TOUCHINPUT.__member(4), TOUCHINPUT.__member(4));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        X = struct$Layout.offsetof(0);
        Y = struct$Layout.offsetof(1);
        HSOURCE = struct$Layout.offsetof(2);
        DWID = struct$Layout.offsetof(3);
        DWFLAGS = struct$Layout.offsetof(4);
        DWMASK = struct$Layout.offsetof(5);
        DWTIME = struct$Layout.offsetof(6);
        DWEXTRAINFO = struct$Layout.offsetof(7);
        CXCONTACT = struct$Layout.offsetof(8);
        CYCONTACT = struct$Layout.offsetof(9);
    }
}

