/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.swt;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.lwjgl.system.Platform;
import org.lwjgl.vulkan.VkPhysicalDevice;
import org.lwjgl.vulkan.swt.PlatformVKCanvas;
import org.lwjgl.vulkan.swt.VKData;

public class VKCanvas
extends Canvas {
    private static PlatformVKCanvas platformCanvas;
    public long surface;

    public VKCanvas(Composite composite, int n2, VKData vKData) {
        super(composite, platformCanvas.checkStyle(composite, n2));
        if (Platform.get() == Platform.WINDOWS) {
            platformCanvas.resetStyle(composite);
        }
        if (vKData == null) {
            SWT.error(4);
        }
        this.surface = platformCanvas.create(this, vKData);
    }

    public boolean getPhysicalDevicePresentationSupport(VkPhysicalDevice vkPhysicalDevice, int n2) {
        return platformCanvas.getPhysicalDevicePresentationSupport(vkPhysicalDevice, n2);
    }

    static {
        String string;
        switch (Platform.get()) {
            case WINDOWS: {
                string = "org.lwjgl.vulkan.swt.PlatformWin32VKCanvas";
                break;
            }
            default: {
                throw new AssertionError((Object)"NYI");
            }
        }
        try {
            Class<?> clazz = VKCanvas.class.getClassLoader().loadClass(string);
            platformCanvas = (PlatformVKCanvas)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)("Platform-specific VKCanvas class not found: " + string));
        }
        catch (InstantiationException instantiationException) {
            throw new AssertionError((Object)("Could not instantiate platform-specific VKCanvas class: " + string));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)("Could not instantiate platform-specific VKCanvas class: " + string));
        }
    }
}

