/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.fastinfoset.util;

import com.sun.xml.internal.fastinfoset.CommonResourceBundle;

public abstract class KeyIntMap {
    public static final int NOT_PRESENT = -1;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x100000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    int _readOnlyMapSize;
    int _size;
    int _capacity;
    int _threshold;
    final float _loadFactor;

    public KeyIntMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.illegalInitialCapacity", new Object[]{n}));
        }
        if (n > 0x100000) {
            n = 0x100000;
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.illegalLoadFactor", new Object[]{Float.valueOf(f)}));
        }
        if (n != 16) {
            this._capacity = 1;
            while (this._capacity < n) {
                this._capacity <<= 1;
            }
            this._loadFactor = f;
            this._threshold = (int)((float)this._capacity * this._loadFactor);
        } else {
            this._capacity = 16;
            this._loadFactor = 0.75f;
            this._threshold = 12;
        }
    }

    public KeyIntMap(int n) {
        this(n, 0.75f);
    }

    public KeyIntMap() {
        this._capacity = 16;
        this._loadFactor = 0.75f;
        this._threshold = 12;
    }

    public final int size() {
        return this._size + this._readOnlyMapSize;
    }

    public abstract void clear();

    public abstract void setReadOnlyMap(KeyIntMap var1, boolean var2);

    public static final int hashHash(int n) {
        n += ~(n << 9);
        n ^= n >>> 14;
        n += n << 4;
        n ^= n >>> 10;
        return n;
    }

    public static final int indexFor(int n, int n2) {
        return n & n2 - 1;
    }

    static class BaseEntry {
        final int _hash;
        final int _value;

        public BaseEntry(int n, int n2) {
            this._hash = n;
            this._value = n2;
        }
    }
}

