/*
 * Decompiled with CFR 0.152.
 */
package com.HUD.Base;

import com.HUD.MyCanvas.MyCanvas;

public class Keyboard {
    public final int LEFT;
    public final int RIGHT;
    public final int UP;
    public final int DOWN;
    public final int FIRE;
    public final int SOFT_LEFT;
    public final int SOFT_RIGHT;
    final int C;
    final int BACKWARD;
    final int STOP;
    final int FORWARD;
    final int CALL;
    private boolean up;
    private boolean down;
    private boolean left;
    private boolean right;
    private boolean fire;
    private boolean key7;
    private boolean key9;
    private boolean key1;
    private boolean key3;
    private boolean buttonC;
    private boolean backward;
    private boolean stop;
    private boolean forward;
    private boolean call;
    private boolean deviceNokia = false;
    private int[] pressedNums = new int[10];
    private boolean[] pressed = new boolean[10];
    public static int[] keyCodes;
    public static boolean[] hasKeyCodes;

    public Keyboard(MyCanvas c) {
        this.C = -8;
        this.BACKWARD = -21;
        this.STOP = -23;
        this.FORWARD = -22;
        this.CALL = -1;
        if (Keyboard.isSelect(c, -26)) {
            this.LEFT = -61;
            this.RIGHT = -62;
            this.DOWN = -60;
            this.UP = -59;
            this.FIRE = -26;
            this.SOFT_LEFT = -1;
            this.SOFT_RIGHT = -4;
        } else if (Keyboard.isSelect(c, -20)) {
            this.LEFT = -2;
            this.RIGHT = -5;
            this.DOWN = -6;
            this.UP = -1;
            this.FIRE = -20;
            this.SOFT_LEFT = -21;
            this.SOFT_RIGHT = -22;
        } else {
            this.LEFT = -3;
            this.RIGHT = -4;
            this.DOWN = -2;
            this.UP = -1;
            this.FIRE = -5;
            this.SOFT_LEFT = -6;
            this.SOFT_RIGHT = -7;
            this.deviceNokia = true;
        }
        this.reset();
        if (keyCodes == null) {
            this.initKeycodes();
        }
        if (keyCodes != null && keyCodes.length != 48) {
            this.initKeycodes();
        }
    }

    private static boolean isSelect(MyCanvas \u0441, int i) {
        try {
            return \u0441.getKeyName(i).toUpperCase().indexOf("SELECT") != -1;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void reset() {
        this.call = false;
        this.forward = false;
        this.stop = false;
        this.backward = false;
        this.buttonC = false;
        this.key3 = false;
        this.key1 = false;
        this.key9 = false;
        this.key7 = false;
        this.fire = false;
        this.right = false;
        this.left = false;
        this.down = false;
        this.up = false;
        for (int i = 0; i < this.pressed.length; ++i) {
            this.pressed[i] = false;
        }
    }

    public void keyPressed(int key) {
        this.keyAction(key, true);
    }

    public void keyReleased(int key) {
        this.keyAction(key, false);
    }

    private void keyAction(int key, boolean action) {
        for (int i = 0; i < this.pressed.length; ++i) {
            if (this.pressed[i] != !action) continue;
            if (!action && this.pressedNums[i] == key) {
                this.pressed[i] = false;
            }
            if (!action) continue;
            this.pressedNums[i] = key;
            this.pressed[i] = true;
            break;
        }
        if (key == 50 || key == this.UP) {
            this.up = action;
        } else if (key == 56 || key == this.DOWN) {
            this.down = action;
        } else if (key == 52 || key == this.LEFT) {
            this.left = action;
        } else if (key == 54 || key == this.RIGHT) {
            this.right = action;
        } else if (key == 53 || key == this.FIRE) {
            this.fire = action;
        } else if (key == 49) {
            this.key1 = action;
        } else if (key == 51) {
            this.key3 = action;
        } else if (key == 55) {
            this.key7 = action;
        } else if (key == 57) {
            this.key9 = action;
        } else if (this.deviceNokia && key == -21) {
            this.backward = action;
        } else if (this.deviceNokia && key == -22) {
            this.forward = action;
        } else if (this.deviceNokia && key == -23) {
            this.stop = action;
        } else if (this.deviceNokia && key == -8) {
            this.buttonC = action;
        } else if (this.deviceNokia && key == -1) {
            this.call = action;
        }
    }

    public boolean up() {
        return this.up;
    }

    public boolean down() {
        return this.down;
    }

    public boolean left() {
        return this.left;
    }

    public boolean right() {
        return this.right;
    }

    public boolean fire() {
        return this.fire;
    }

    public boolean key1() {
        return this.key1;
    }

    public boolean key3() {
        return this.key3;
    }

    public boolean key7() {
        return this.key7;
    }

    public boolean key9() {
        return this.key9;
    }

    public boolean isUp(int key) {
        return key == 50 || key == this.UP;
    }

    public boolean isDown(int key) {
        return key == 56 || key == this.DOWN;
    }

    public boolean isleft(int key) {
        return key == 52 || key == this.LEFT;
    }

    public boolean isRight(int key) {
        return key == 54 || key == this.RIGHT;
    }

    public boolean isFire(int key) {
        return key == 53 || key == this.FIRE;
    }

    public boolean isPressed(int key) {
        for (int i = 0; i < this.pressed.length; ++i) {
            if (!this.pressed[i] || this.pressedNums[i] != key) continue;
            return true;
        }
        return false;
    }

    public void initKeycodes() {
        keyCodes = new int[]{this.UP, 50, this.DOWN, 56, 55, 0, 57, 0, this.LEFT, 52, this.RIGHT, 54, 51, 0, 49, 0, this.FIRE, 53, 48, 0, this.SOFT_LEFT, 0, 35, 0, 0, 0, 42, 0, 51, 0, 49, 0, 55, 0, 57, 0, this.LEFT, 52, this.RIGHT, 54, this.UP, 50, this.DOWN, 56, 0, 0, this.SOFT_LEFT, 0};
        hasKeyCodes = new boolean[]{true, true, true, true, true, false, true, false, true, true, true, true, true, false, true, false, true, true, true, false, true, false, true, false, false, false, true, false, true, false, true, false, true, false, true, false, true, true, true, true, true, true, true, true, false, false, true, false};
    }

    public boolean isWalkForward(boolean sight) {
        if (!sight && hasKeyCodes[0] && this.isPressed(keyCodes[0])) {
            return true;
        }
        if (!sight && hasKeyCodes[1] && this.isPressed(keyCodes[1])) {
            return true;
        }
        if (sight && hasKeyCodes[28] && this.isPressed(keyCodes[28])) {
            return true;
        }
        return sight && hasKeyCodes[29] && this.isPressed(keyCodes[29]);
    }

    public boolean isWalkBackward(boolean sight) {
        if (!sight && hasKeyCodes[2] && this.isPressed(keyCodes[2])) {
            return true;
        }
        if (!sight && hasKeyCodes[3] && this.isPressed(keyCodes[3])) {
            return true;
        }
        if (sight && hasKeyCodes[30] && this.isPressed(keyCodes[30])) {
            return true;
        }
        return sight && hasKeyCodes[31] && this.isPressed(keyCodes[31]);
    }

    public boolean isWalkLeft(boolean sight) {
        if (!sight && hasKeyCodes[4] && this.isPressed(keyCodes[4])) {
            return true;
        }
        if (!sight && hasKeyCodes[5] && this.isPressed(keyCodes[5])) {
            return true;
        }
        if (sight && hasKeyCodes[32] && this.isPressed(keyCodes[32])) {
            return true;
        }
        return sight && hasKeyCodes[33] && this.isPressed(keyCodes[33]);
    }

    public boolean isWalkRight(boolean sight) {
        if (!sight && hasKeyCodes[6] && this.isPressed(keyCodes[6])) {
            return true;
        }
        if (!sight && hasKeyCodes[7] && this.isPressed(keyCodes[7])) {
            return true;
        }
        if (sight && hasKeyCodes[34] && this.isPressed(keyCodes[34])) {
            return true;
        }
        return sight && hasKeyCodes[35] && this.isPressed(keyCodes[35]);
    }

    public boolean isLookLeft(boolean sight) {
        if (!sight && hasKeyCodes[8] && this.isPressed(keyCodes[8])) {
            return true;
        }
        if (!sight && hasKeyCodes[9] && this.isPressed(keyCodes[9])) {
            return true;
        }
        if (sight && hasKeyCodes[36] && this.isPressed(keyCodes[36])) {
            return true;
        }
        return sight && hasKeyCodes[37] && this.isPressed(keyCodes[37]);
    }

    public boolean isLookRight(boolean sight) {
        if (!sight && hasKeyCodes[10] && this.isPressed(keyCodes[10])) {
            return true;
        }
        if (!sight && hasKeyCodes[11] && this.isPressed(keyCodes[11])) {
            return true;
        }
        if (sight && hasKeyCodes[38] && this.isPressed(keyCodes[38])) {
            return true;
        }
        return sight && hasKeyCodes[39] && this.isPressed(keyCodes[39]);
    }

    public boolean isLookUp(boolean sight) {
        if (!sight && hasKeyCodes[12] && this.isPressed(keyCodes[12])) {
            return true;
        }
        if (!sight && hasKeyCodes[13] && this.isPressed(keyCodes[13])) {
            return true;
        }
        if (sight && hasKeyCodes[40] && this.isPressed(keyCodes[40])) {
            return true;
        }
        return sight && hasKeyCodes[41] && this.isPressed(keyCodes[41]);
    }

    public boolean isLookDown(boolean sight) {
        if (!sight && hasKeyCodes[14] && this.isPressed(keyCodes[14])) {
            return true;
        }
        if (!sight && hasKeyCodes[15] && this.isPressed(keyCodes[15])) {
            return true;
        }
        if (sight && hasKeyCodes[42] && this.isPressed(keyCodes[42])) {
            return true;
        }
        return sight && hasKeyCodes[43] && this.isPressed(keyCodes[43]);
    }

    public boolean isPlayerShooting() {
        if (hasKeyCodes[16] && this.isPressed(keyCodes[16])) {
            return true;
        }
        return hasKeyCodes[17] && this.isPressed(keyCodes[17]);
    }

    public static boolean isSightKey(int key) {
        if (hasKeyCodes[26] && keyCodes[26] == key) {
            return true;
        }
        return hasKeyCodes[27] && keyCodes[27] == key;
    }

    public static boolean isUseKey(int key) {
        if (hasKeyCodes[46] && keyCodes[46] == key) {
            return true;
        }
        return hasKeyCodes[47] && keyCodes[47] == key;
    }

    public static boolean isInventoryKey(int key) {
        if (hasKeyCodes[20] && keyCodes[20] == key) {
            return true;
        }
        return hasKeyCodes[21] && keyCodes[21] == key;
    }

    public static boolean isJumpKey(int key) {
        if (hasKeyCodes[18] && keyCodes[18] == key) {
            return true;
        }
        return hasKeyCodes[19] && keyCodes[19] == key;
    }

    public static boolean isNextWeaponKey(int key) {
        if (hasKeyCodes[22] && keyCodes[22] == key) {
            return true;
        }
        return hasKeyCodes[23] && keyCodes[23] == key;
    }

    public static boolean isPreviousWeaponKey(int key) {
        if (hasKeyCodes[24] && keyCodes[24] == key) {
            return true;
        }
        return hasKeyCodes[25] && keyCodes[25] == key;
    }
}

