/*
 * Decompiled with CFR 0.152.
 */
package com.Rendering.Meshes;

import com.Math.Matrix;
import com.Rendering.DirectX7;
import com.Rendering.Meshes.Mesh;
import com.Rendering.Meshes.Morphing;
import com.Rendering.MultyTexture;
import com.Rendering.RenderObject;
import com.Rendering.Texture;
import com.Rendering.Vertex;

public class MeshImage
extends RenderObject {
    private Matrix matrix = new Matrix();
    private int addMiddleZ = 0;
    private Vertex centre;
    private Mesh mesh;
    private Morphing animation;
    private MultyTexture tex;
    private int meshRadius;
    private int x1;
    private int y1;
    private int x2;
    private int y2;
    private int frame = 0;

    public MeshImage(Mesh mesh, Morphing animation) {
        this(mesh);
        this.setAnimation(animation);
    }

    public MeshImage(Mesh mesh) {
        this.mesh = mesh;
        long sx = 0L;
        long sy = 0L;
        long sz = 0L;
        Vertex[] vertexs = mesh.getVertices();
        for (int i = 0; i < vertexs.length; ++i) {
            Vertex v = vertexs[i];
            sx += (long)v.x;
            sy += (long)v.y;
            sz += (long)v.z;
        }
        this.centre = new Vertex((int)(sx /= (long)vertexs.length), (int)(sy /= (long)vertexs.length), (int)(sz /= (long)vertexs.length));
        this.meshRadius = MeshImage.max(mesh.maxX() - mesh.minX(), mesh.maxZ() - mesh.minZ());
    }

    public void setMesh(Mesh mesh) {
        this.mesh = mesh;
    }

    public Mesh getMesh() {
        return this.mesh;
    }

    public void setAnimation(Morphing animation) {
        this.animation = animation;
    }

    public void setTexture(MultyTexture animation) {
        this.tex = animation;
    }

    public Morphing getAnimation() {
        return this.animation;
    }

    public void setAddMiddleZ(int addMiddleZ) {
        this.addMiddleZ = addMiddleZ;
    }

    public void setMatrix(Matrix matrix) {
        this.matrix.set(matrix);
        this.centre.transform(matrix);
        this.sz = this.centre.rz * 4;
    }

    public void setFrame(int f) {
        this.frame = f;
    }

    public void render(DirectX7 g3d, Texture texture) {
        if (this.tex != null) {
            this.tex.updateAnimation();
        }
        if (this.animation != null) {
            this.animation.setFrameNI(this.frame);
        }
        if (this.animation != null) {
            this.mesh.setAnimation(this.animation);
        }
        g3d.transformAndProjectVertices(this.mesh, this.matrix);
        if (this.tex != null) {
            this.mesh.setTexture(this.tex);
        }
        this.mesh.render(g3d, this.x1, this.y1, this.x2, this.y2);
    }

    public void renderFast(DirectX7 g3d, Texture texture) {
        if (this.tex != null) {
            this.tex.updateAnimation();
        }
        if (this.animation != null) {
            this.animation.setFrameNI(this.frame);
        }
        if (this.animation != null) {
            this.mesh.setAnimation(this.animation);
        }
        g3d.transformAndProjectVertices(this.mesh, this.matrix);
        if (this.tex != null) {
            this.mesh.setTexture(this.tex);
        }
        this.mesh.render(g3d, this.x1, this.y1, this.x2, this.y2);
    }

    public boolean isVisible(int x1, int y1, int x2, int y2) {
        if (this.sz - this.meshRadius > 0) {
            return false;
        }
        if (-this.sz / 4 - this.meshRadius > DirectX7.drDist) {
            return false;
        }
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        return true;
    }

    private static final int max(int x, int y) {
        if (x > y) {
            return x;
        }
        return y;
    }
}

