/*
 * Decompiled with CFR 0.152.
 */
package code.Gameplay.Objects;

import code.AI.Player;
import code.Gameplay.GameScreen;
import code.Gameplay.Map.House;
import code.Gameplay.Map.RoomObject;
import code.Math.Vector3D;
import code.Rendering.DirectX7;
import code.utils.Asset;
import code.utils.Main;

public final class Teleport
extends RoomObject {
    public Vector3D pos = new Vector3D(0, 0, 0);
    public Vector3D npos = new Vector3D(0, 0, 0);
    public int pRot = 0;

    public Teleport(Vector3D pos2, Vector3D pos3) {
        this.activable = true;
        this.pos.set(pos2);
        this.npos.set(pos3);
    }

    public final void destroy() {
    }

    public final void render(DirectX7 g3d, int x1, int y1, int x2, int y2) {
    }

    public final int getPosX() {
        return this.pos.x;
    }

    public final void setPos(int x, int y, int z) {
        this.pos.set(x, y, z);
    }

    public final int getPosZ() {
        return this.pos.z;
    }

    public final int getPosY() {
        return this.pos.y;
    }

    public void activate(House house, Player player, GameScreen gs) {
        if (this.lastActivate > 0L && this.lastActivate + this.timeToReset > GameScreen.time) {
            return;
        }
        if (!this.isAllCollected(Player.usedPoints, player, house, gs)) {
            if (this.errMessage != null) {
                this.errMsg(gs);
            }
            return;
        }
        if (this.sound != null && Main.isSounds && Main.sounds != 0) {
            Asset.getSound(this.sound).start(Main.sounds);
        }
        if (!(this.singleUse && this.activated || this.message == null)) {
            this.prMsg(gs);
        }
        if (!this.singleUse || !this.activated) {
            this.give(this.additional, player, house, gs);
        }
        if (!this.contains(Player.usedPoints, this.name)) {
            this.give(this.name, player);
            player.getCharacter().getTransform().addPosition(-this.pos.x, -this.pos.y, -this.pos.z);
            player.getCharacter().getTransform().addPosition(this.npos);
            player.rotYn(this.pRot);
            this.activated = true;
            if (this.lastActivate >= 0L) {
                this.lastActivate = GameScreen.time;
            }
        }
        if (this.destroyOnUse) {
            house.removeObject(this);
        }
    }
}

