/*
 * Decompiled with CFR 0.152.
 */
package code.HUD.Base;

import code.HUD.Base.Font;
import code.utils.Main;
import javax.microedition.lcdui.Graphics;

public final class ItemList {
    private Font font;
    private String[] items;
    public boolean[] midSel;
    public boolean left = false;
    public boolean redact = false;
    private int index = 0;

    public ItemList(String[] items, Font font) {
        this.items = items;
        this.font = font;
    }

    public ItemList(String[] items, Font font, boolean[] ms) {
        this.items = items;
        this.font = font;
        this.midSel = ms;
    }

    public ItemList(String[] items) {
        this.items = items;
    }

    public final void setFont(Font font) {
        this.font = font;
    }

    public int getHeight() {
        return this.items.length * (this.font.height() + 3);
    }

    public final void draw(Graphics g, int x, int y, int w, int h) {
        int fontHeight = this.font.height();
        int stepY = fontHeight + 3;
        int max = h / stepY;
        boolean less = this.items.length <= max;
        int posy = y;
        int i = 0;
        if (less) {
            posy += h / 2 - this.items.length * stepY / 2;
        } else {
            i = this.index - max / 2;
            if (i < 0) {
                i = 0;
            }
            if (i >= this.items.length - max) {
                i = this.items.length - max;
            }
        }
        while (i < this.items.length) {
            if (posy >= y) {
                if (posy + fontHeight > y + h) break;
                String str = this.items[i];
                int x2 = w / 2 - this.font.widthOf(str) / 2 + x;
                boolean ms = false;
                if (this.midSel != null && this.midSel[i]) {
                    ms = true;
                }
                if (this.left && !ms) {
                    x2 = x;
                }
                this.font.drawString(g, str, x2, posy, 0, this.redact && i == this.index ? 2 : (i == this.index || ms ? 1 : 0));
                posy += stepY;
            }
            ++i;
        }
    }

    public final void drawBck(Graphics g, int x, int y, int w, int h) {
        int fontHeight = this.font.height();
        int stepY = fontHeight + 3;
        int max = h / stepY;
        boolean less = this.items.length <= max;
        int posy = y;
        int i = 0;
        if (less) {
            posy += h / 2 - this.items.length * stepY / 2;
        } else {
            i = this.index - max / 2;
            if (i < 0) {
                i = 0;
            }
            if (i >= this.items.length - max) {
                i = this.items.length - max;
            }
        }
        int posy2 = posy;
        while (i < this.items.length) {
            if (posy2 >= y) {
                if (posy2 + fontHeight > y + h) break;
                posy2 += stepY;
            }
            ++i;
        }
        Main.drawBckDialog(g, posy, posy2 - 3);
    }

    public final int getPosY(int h) {
        int stepY = this.font.height() + 3;
        int max = h / stepY;
        boolean less = this.items.length <= max;
        int posy = 0;
        int i = 0;
        if (less) {
            posy += h / 2 - this.items.length * stepY / 2;
        } else {
            i = this.index - max / 2;
            if (i < 0) {
                i = 0;
            }
            if (i >= this.items.length - max) {
                i = this.items.length - max;
            }
        }
        return posy - i * stepY;
    }

    public final void scrollDown() {
        ++this.index;
        this.index %= this.items.length;
    }

    public final void scrollUp() {
        --this.index;
        if (this.index < 0) {
            this.index = this.items.length - 1;
        }
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int i) {
        this.index = i;
    }

    public final String getCurrentItem() {
        return this.items[this.index];
    }

    public final String[] getItems() {
        return this.items;
    }
}

