/*
 * Decompiled with CFR 0.152.
 */
package com.Collision;

import com.Collision.Height;
import com.Math.MathUtils2;
import com.Math.Matrix;
import com.Math.Vector3D;
import com.Rendering.Graphics3D;
import com.Rendering.Meshes.Mesh;
import com.Rendering.Meshes.Polygon3V;
import com.Rendering.Meshes.Polygon4V;
import com.Rendering.RenderObject;
import com.Rendering.Vertex;

public class HeightComputer {
    private static final Vector3D nor = new Vector3D();
    private static final Height height = new Height();

    public static boolean isPointAABBCollision(int x, int z, int minx, int maxx, int minz, int maxz) {
        return x >= minx && z >= minz && x <= maxx && z <= maxz;
    }

    public static int computeHeight(Mesh mesh, int x, int y, int z) {
        height.reset();
        height.getPosition().set(x, y, z);
        HeightComputer.computeHeight(mesh, height);
        return height.getHeight();
    }

    public static void computeHeight(Mesh mesh, Matrix matrix, Height height) {
        HeightComputer.computeHeight(mesh, matrix, height, true);
    }

    public static void computeHeight(Mesh mesh, Matrix matrix, Height height, boolean updatePos) {
        Graphics3D.transform(mesh, matrix);
        RenderObject[] polygons = mesh.getPolygons();
        Vector3D pos = height.getPosition();
        int x = pos.x;
        int y = pos.y;
        int z = pos.z;
        for (int i = 0; i < polygons.length; ++i) {
            Vertex c;
            Vertex b;
            Vertex a;
            RenderObject p;
            RenderObject el = polygons[i];
            int polyY = Integer.MAX_VALUE;
            int cenX = Integer.MAX_VALUE;
            int cenZ = Integer.MAX_VALUE;
            int cenY = Integer.MAX_VALUE;
            if (el instanceof Polygon3V) {
                int minz;
                int maxz;
                int minx;
                p = (Polygon3V)el;
                a = p.a;
                b = p.b;
                c = p.c;
                int ax = a.sx;
                int ay = a.sy;
                int az = a.rz;
                int bx = b.sx;
                int by = b.sy;
                int bz = b.rz;
                int cx = c.sx;
                int cy = c.sy;
                int cz = c.rz;
                int maxx = ax;
                if (bx > maxx) {
                    maxx = bx;
                }
                if (cx > maxx) {
                    maxx = cx;
                }
                if (bx < (minx = ax)) {
                    minx = bx;
                }
                if (cx < minx) {
                    minx = cx;
                }
                if (bz > (maxz = az)) {
                    maxz = bz;
                }
                if (cz > maxz) {
                    maxz = cz;
                }
                if (bz < (minz = az)) {
                    minz = bz;
                }
                if (cz < minz) {
                    minz = cz;
                }
                if (minx > x || minz > z || maxx < x || maxz < z) continue;
                double xx = (long)(ay - by) * (long)(az - cz) - (long)(az - bz) * (long)(ay - cy);
                double yy = (long)(az - bz) * (long)(ax - cx) - (long)(ax - bx) * (long)(az - cz);
                double zz = (long)(ax - bx) * (long)(ay - cy) - (long)(ay - by) * (long)(ax - cx);
                double sqrt = Math.sqrt(xx * xx + yy * yy + zz * zz) / 4096.0;
                HeightComputer.nor.x = (int)(xx / sqrt);
                HeightComputer.nor.y = (int)(yy / sqrt);
                HeightComputer.nor.z = (int)(zz / sqrt);
                if (HeightComputer.nor.y >= 0) continue;
                if (MathUtils2.isPointOnPolygon(x, z, ax, az, bx, bz, cx, cz, p.ny)) {
                    polyY = y - ((x - ax) * p.nx + (y - ay) * p.ny + (z - az) * p.nz) / p.ny;
                    cenX = (ax + bx + cx) / 3;
                    cenZ = (az + bz + cz) / 3;
                    cenY = (ay + by + cy) / 3;
                }
            } else if (el instanceof Polygon4V) {
                int minz;
                int maxz;
                int minx;
                p = (Polygon4V)el;
                a = ((Polygon4V)p).a;
                b = ((Polygon4V)p).b;
                c = ((Polygon4V)p).c;
                Vertex d = ((Polygon4V)p).d;
                int ax = a.sx;
                int ay = a.sy;
                int az = a.rz;
                int bx = b.sx;
                int by = b.sy;
                int bz = b.rz;
                int cx = c.sx;
                int cy = c.sy;
                int cz = c.rz;
                int dx = d.sx;
                int dy = d.sy;
                int dz = d.rz;
                int maxx = ax;
                if (bx > maxx) {
                    maxx = bx;
                }
                if (cx > maxx) {
                    maxx = cx;
                }
                if (dx > maxx) {
                    maxx = dx;
                }
                if (bx < (minx = ax)) {
                    minx = bx;
                }
                if (cx < minx) {
                    minx = cx;
                }
                if (dx < minx) {
                    minx = dx;
                }
                if (bz > (maxz = az)) {
                    maxz = bz;
                }
                if (cz > maxz) {
                    maxz = cz;
                }
                if (dz > maxz) {
                    maxz = dz;
                }
                if (bz < (minz = az)) {
                    minz = bz;
                }
                if (cz < minz) {
                    minz = cz;
                }
                if (dz < minz) {
                    minz = dz;
                }
                if (minx > x || minz > z || maxx < x || maxz < z) continue;
                double xx = (long)(ay - by) * (long)(az - dz) - (long)(az - bz) * (long)(ay - dy);
                double yy = (long)(az - bz) * (long)(ax - dx) - (long)(ax - bx) * (long)(az - dz);
                double zz = (long)(ax - bx) * (long)(ay - dy) - (long)(ay - by) * (long)(ax - dx);
                double sqrt = Math.sqrt(xx * xx + yy * yy + zz * zz) / 4096.0;
                HeightComputer.nor.x = (int)(xx / sqrt);
                HeightComputer.nor.y = (int)(yy / sqrt);
                HeightComputer.nor.z = (int)(zz / sqrt);
                if (HeightComputer.nor.y >= 0) continue;
                if (MathUtils2.isPointOnPolygon(x, z, ax, az, bx, bz, cx, cz, dx, dz, ((Polygon4V)p).ny)) {
                    polyY = y - ((x - ax) * ((Polygon4V)p).nx + (y - ay) * ((Polygon4V)p).ny + (z - az) * ((Polygon4V)p).nz) / ((Polygon4V)p).ny;
                    cenX = ax + bx + cx + dx >> 2;
                    cenZ = az + bz + cz + dz >> 2;
                    cenY = ay + by + cy + dy >> 2;
                }
            }
            if (polyY >= y || polyY <= height.getHeight()) continue;
            height.set(polyY, el, cenX, cenZ, cenY, matrix, updatePos);
        }
    }

    public static void computeHeight(Mesh mesh, Height height) {
        RenderObject[] polygons = mesh.getPoligons();
        Vector3D pos = height.getPosition();
        int x = pos.x;
        int y = pos.y;
        int z = pos.z;
        for (int i = 0; i < polygons.length; ++i) {
            Vertex c;
            Vertex b;
            Vertex a;
            RenderObject p;
            RenderObject el = polygons[i];
            if (el.ny >= 0) continue;
            int polyY = Integer.MAX_VALUE;
            int cx = Integer.MAX_VALUE;
            int cz = Integer.MAX_VALUE;
            int cy = Integer.MAX_VALUE;
            if (el instanceof Polygon3V) {
                int minz;
                int maxz;
                int minx;
                p = (Polygon3V)el;
                a = p.a;
                b = p.b;
                c = p.c;
                int ax = a.x;
                int az = a.z;
                int bx = b.x;
                int bz = b.z;
                int maxx = ax;
                if (bx > maxx) {
                    maxx = bx;
                }
                if (c.x > maxx) {
                    maxx = c.x;
                }
                if (bx < (minx = ax)) {
                    minx = bx;
                }
                if (c.x < minx) {
                    minx = c.x;
                }
                if (bz > (maxz = az)) {
                    maxz = bz;
                }
                if (c.z > maxz) {
                    maxz = c.z;
                }
                if (bz < (minz = az)) {
                    minz = bz;
                }
                if (c.z < minz) {
                    minz = c.z;
                }
                if (minx > x || minz > z || maxx < x || maxz < z) continue;
                if (MathUtils2.isPointOnPolygon(x, z, a.x, a.z, b.x, b.z, c.x, c.z, p.ny)) {
                    polyY = y - ((x - ax) * p.nx + (y - a.y) * p.ny + (z - az) * p.nz) / p.ny;
                    cx = (a.x + b.x + c.x) / 3;
                    cz = (a.z + b.z + c.z) / 3;
                    cy = (a.y + b.y + c.y) / 3;
                }
            } else if (el instanceof Polygon4V) {
                int minz;
                int maxz;
                int minx;
                p = (Polygon4V)el;
                a = ((Polygon4V)p).a;
                b = ((Polygon4V)p).b;
                c = ((Polygon4V)p).c;
                Vertex d = ((Polygon4V)p).d;
                int ax = a.x;
                int az = a.z;
                int bx = b.x;
                int bz = b.z;
                int dx = d.x;
                int dz = d.z;
                int maxx = ax;
                if (bx > maxx) {
                    maxx = bx;
                }
                if (c.x > maxx) {
                    maxx = c.x;
                }
                if (dx > maxx) {
                    maxx = dx;
                }
                if (bx < (minx = ax)) {
                    minx = bx;
                }
                if (c.x < minx) {
                    minx = c.x;
                }
                if (dx < minx) {
                    minx = dx;
                }
                if (bz > (maxz = az)) {
                    maxz = bz;
                }
                if (c.z > maxz) {
                    maxz = c.z;
                }
                if (dz > maxz) {
                    maxz = dz;
                }
                if (bz < (minz = az)) {
                    minz = bz;
                }
                if (c.z < minz) {
                    minz = c.z;
                }
                if (dz < minz) {
                    minz = dz;
                }
                if (minx > x || minz > z || maxx < x || maxz < z) continue;
                if (MathUtils2.isPointOnPolygon(x, z, ax, az, bx, bz, c.x, c.z, dx, dz, ((Polygon4V)p).ny)) {
                    polyY = y - ((x - ax) * ((Polygon4V)p).nx + (y - a.y) * ((Polygon4V)p).ny + (z - az) * ((Polygon4V)p).nz) / ((Polygon4V)p).ny;
                    cx = ax + bx + c.x + dx >> 2;
                    cz = az + bz + c.z + dz >> 2;
                    cy = a.y + b.y + c.y + d.y >> 2;
                }
            }
            if (polyY >= y || polyY <= height.getHeight()) continue;
            height.set(polyY, el, cx, cz, cy, null, true);
        }
    }
}

