/*
 * Decompiled with CFR 0.152.
 */
package com.Gameplay;

import com.AI.Player;
import com.Gameplay.Arsenal;
import com.Gameplay.GameScreen;
import com.Gameplay.Weapon;
import com.HUD.Base.Font;
import com.HUD.GUIScreen;
import com.Rendering.Fps;
import com.Rendering.Meshes.Mesh;
import com.misc.ImageResize;
import com.misc.Main;
import com.misc.Stringer;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class Shop
extends GUIScreen {
    public static int weapon_count = 0;
    public static String[] files;
    public static int[] prices;
    public static String[] bckFiles;
    public static int[] bckPrices;
    public static int index;
    public static int[] items;
    public static int[] allitems;
    private static boolean proportionalShop;
    public static int[] defaultArsenal;
    private GameScreen gameScreen;
    private Player player;
    private Image iconItem;
    private Image iconPatron;
    private static boolean side;
    private static long sideAnimBegin;
    private static int sideAnimOld;
    private static long sideAnimTime;
    private static boolean paint;

    public static void initShop() {
        Stringer settings = Main.settings;
        String file = Mesh.getStringFromResource("/weapons.txt");
        if (settings.getString("DEFAULT_ARSENAL") != null) {
            defaultArsenal = Mesh.cutOnInts(settings.getString("DEFAULT_ARSENAL"), ',', ';');
        } else if (file != null) {
            defaultArsenal = new int[1];
            Shop.defaultArsenal[0] = 0;
        } else {
            defaultArsenal = new int[1];
            Shop.defaultArsenal[0] = -1;
        }
        if (file != null) {
            int i;
            int len;
            weapon_count = len = Mesh.cutOnStrings(file, '[').length + 1;
            allitems = new int[len];
            for (i = 0; i < len; ++i) {
                Shop.allitems[i] = i;
            }
            items = new int[len];
            for (i = 0; i < len; ++i) {
                Shop.items[i] = i;
            }
            files = new String[len];
            prices = new int[len];
            bckFiles = new String[len];
            bckPrices = new int[len];
            int sel = 0;
            while (file.indexOf(91) >= 0) {
                int pos = file.indexOf(91);
                int endpos = file.indexOf(93);
                String objectType = file.substring(pos + 1, endpos);
                String object = file.substring(endpos + 1);
                if ((endpos = object.indexOf(91)) >= 0) {
                    file = object.substring(endpos);
                    object = object.substring(0, endpos - 1);
                }
                Stringer obj = new Stringer(object);
                Shop.files[sel] = obj.getString("SHOP_IMAGE");
                Shop.prices[sel] = obj.getInt("PRICE");
                Shop.bckFiles[sel] = obj.getString("SHOP_IMAGE");
                Shop.bckPrices[sel] = obj.getInt("PRICE");
                ++sel;
                if (endpos >= 0) continue;
                break;
            }
        } else {
            int i;
            weapon_count = 2;
            allitems = new int[2];
            for (i = 0; i < 2; ++i) {
                Shop.allitems[i] = i;
            }
            items = new int[2];
            for (i = 0; i < 2; ++i) {
                Shop.items[i] = i;
            }
            files = new String[2];
            prices = new int[2];
            bckFiles = new String[2];
            bckPrices = new int[2];
        }
        Shop.files[Shop.files.length - 1] = Main.shop_medkit;
        Shop.prices[Shop.files.length - 1] = settings.getInt("PRICE_MEDICINE_CHEST");
        Shop.bckFiles[Shop.files.length - 1] = Main.shop_medkit;
        Shop.bckPrices[Shop.files.length - 1] = settings.getInt("PRICE_MEDICINE_CHEST");
        if (settings.getInt("SHOP_PROPORTIONAL", 1) == 0) {
            proportionalShop = false;
        }
    }

    public Shop(Main main, GameScreen gameScreen, Player player) {
        this.gameScreen = gameScreen;
        this.player = player;
        Stringer lang = Main.getGameText();
        this.set(Main.getFont(), lang.getString2("BUY"), lang.getString2("BACK"));
        this.iconPatron = ImageResize.createImageProportional(Main.shop_patron, (float)this.getWidth() / 240.0f, (float)this.getHeight() / 320.0f);
        this.reset();
        sideAnimBegin = 0L;
        this.inverseHScroll = true;
        this.inverseVScroll = true;
    }

    public final void destroy() {
        super.destroy();
        this.iconPatron = null;
        this.iconItem = null;
        this.player = null;
    }

    private void reset() {
        String path = files[index];
        if (Main.getGameText().getString2(path) != null) {
            path = Main.getGameText().getString2(path);
        }
        if (proportionalShop) {
            this.iconItem = ImageResize.createImageProportional(path, (float)this.getWidth() / 240.0f, (float)this.getHeight() / 320.0f);
            return;
        }
        this.iconItem = ImageResize.createImage(path, (float)this.getWidth() / 240.0f, (float)this.getHeight() / 320.0f);
    }

    private int price() {
        return index == files.length - 1 ? prices[index] : (this.isNotPurchased() ? prices[index] : (this.isPurchased() && this.isPatron() ? prices[index] / 3 : Short.MAX_VALUE));
    }

    private boolean isAvailableAidKit() {
        return index == files.length - 1 && this.player.getHp() == 100 ? false : Player.money >= this.price();
    }

    private boolean isAvailableAidKitPrice() {
        return index != files.length - 1 ? false : Player.money < this.price();
    }

    private boolean isNotPurchased() {
        Weapon[] weapons = Arsenal.getWeapons();
        return index >= 0 && index < files.length - 1 && weapons[index] == null;
    }

    private boolean isPatron() {
        Weapon[] weapons = Arsenal.getWeapons();
        return index >= 0 && index < files.length - 1 && weapons[index] != null && weapons[Shop.index].patronbuy;
    }

    private boolean isPurchased() {
        Weapon[] weapons = Arsenal.getWeapons();
        return index >= 0 && index < files.length - 1 && weapons[index] != null;
    }

    protected final void paint(Graphics g) {
        int coof;
        paint = true;
        int w = this.getWidth();
        int h = this.getHeight();
        int n = coof = Main.verticalShopScroll ? h : w;
        if (System.currentTimeMillis() - sideAnimBegin < sideAnimTime && sideAnimTime != 0L) {
            coof = (int)((System.currentTimeMillis() - sideAnimBegin) * (long)coof / sideAnimTime);
        }
        if (coof < w && !Main.verticalShopScroll) {
            if (!side) {
                g.setClip(sideAnimOld, 0, coof - sideAnimOld, h);
            }
            if (side) {
                g.setClip(w - coof, 0, coof - sideAnimOld, h);
            }
        } else if (coof < h && Main.verticalShopScroll) {
            if (!side) {
                g.setClip(0, sideAnimOld, w, coof - sideAnimOld);
            }
            if (side) {
                g.setClip(0, h - coof, w, coof - sideAnimOld);
            }
        } else {
            g.setClip(0, 0, w, h);
        }
        g.setColor(0);
        g.fillRect(0, 0, w, h);
        Stringer var6 = Main.getGameText();
        if (this.isAvailableAidKit()) {
            this.setLeftSoft(var6.getString2("BUY"));
        } else if (this.isPatron() || this.isNotPurchased() || this.isAvailableAidKitPrice()) {
            this.setLeftSoft(var6.getString2("NOTENOUGHMONEY"));
        } else {
            this.setLeftSoft("");
        }
        int arWidth = w / 34;
        int arHeight = h / 34;
        if (!Main.verticalShopScroll) {
            this.drawArrow(g, 4, h / 4, arWidth + 4, h / 4 - arHeight / 2, arWidth + 4, h / 4 + arHeight / 2);
            this.drawArrow(g, w - 4, h / 4, w - 4 - arWidth, h / 4 - arHeight / 2, w - 4 - arWidth, h / 4 + arHeight / 2);
        }
        Font font = this.getFont();
        Stringer var7 = Main.getGameText();
        font.drawString(g, var7.getString2("MONEY") + ":" + Player.money, w - 2, 2, 24);
        g.drawImage(this.iconItem, w / 2, h / 2, 3);
        if (this.isPurchased() && this.isPatron()) {
            g.drawImage(this.iconPatron, w / 2 - this.iconItem.getWidth() / 2, h / 2 + this.iconItem.getHeight() / 2, 36);
        }
        if (var7.getString2("CENA") != null && (this.isPatron() || this.isNotPurchased() || index == files.length - 1)) {
            font.drawString(g, var7.getString2("CENA") + ":" + this.price(), w / 2, h / 2 + this.iconItem.getHeight() / 2 + 2, 17);
        }
        this.drawSoftKeys(g);
        sideAnimOld = coof;
        if (coof < w && !Main.verticalShopScroll || coof < h && Main.verticalShopScroll) {
            try {
                Thread.sleep(5L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.repaint();
        } else {
            paint = false;
            this.dragIgnore = false;
        }
    }

    private void drawArrow(Graphics g, int x1, int y1, int x2, int y2, int x3, int y3) {
        int miny = Math.min(y1, Math.min(y2, y3));
        int maxy = Math.max(y1, Math.max(y2, y3));
        int sizey = (maxy - miny) / 3;
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        for (int i = 0; i < sizey; ++i) {
            int bright;
            if (this.isAvailableAidKit()) {
                bright = Math.min(255, i * 255 / sizey);
                g.setColor(bright, bright, bright);
            } else {
                bright = Math.min(255, i * 255 / sizey);
                g.setColor(bright, 0, 0);
            }
            g.setClip(clipX, Math.max(clipY, miny + (maxy - miny) * i / sizey), clipWidth, Math.min(clipHeight, maxy));
            g.fillTriangle(x1, y1, x2, y2, x3, y3);
        }
        g.setClip(clipX, clipY, clipWidth, clipHeight);
    }

    protected final void onRightSoftKey() {
        try {
            this.destroy();
            System.gc();
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Fps.reset();
        this.gameScreen.start();
        Main.setCurrent(this.gameScreen);
        this.gameScreen = null;
    }

    protected final void onLeftSoftKey() {
        if (!this.isAvailableAidKit()) {
            return;
        }
        if (this.isNotPurchased()) {
            Weapon[] weapons = Arsenal.getWeapons();
            this.player.pay(this.price());
            weapons[Shop.index] = Stringer.createWeapon(index);
            weapons[index].setAmmo(100);
            if (Arsenal.current != -1 && Arsenal.currentWeapon().getDamageValue() < Arsenal.weapons[index].getDamageValue()) {
                Arsenal.current = index;
            }
            if (!paint) {
                this.repaint();
            }
        } else if (this.isPurchased() && this.isPatron()) {
            Weapon[] weapons = Arsenal.getWeapons();
            this.player.pay(this.price());
            weapons[index].addAmmo(100);
            if (!paint) {
                this.repaint();
            }
        } else if (index == files.length - 1) {
            this.player.pay(this.price());
            this.player.setHp(100);
            if (!paint) {
                this.repaint();
            }
        }
    }

    protected final void onKey6() {
        if (Main.verticalShopScroll || paint) {
            return;
        }
        this.dragIgnore = true;
        ++index;
        index %= files.length;
        if (!this.isContains()) {
            this.onKey6();
            return;
        }
        this.reset();
        side = true;
        sideAnimBegin = System.currentTimeMillis();
        sideAnimOld = 0;
        if (!paint) {
            this.repaint();
        }
    }

    protected final void onKey4() {
        if (Main.verticalShopScroll || paint) {
            return;
        }
        this.dragIgnore = true;
        if (--index < 0) {
            index += files.length;
        }
        if (!this.isContains()) {
            this.onKey4();
            return;
        }
        this.reset();
        side = false;
        sideAnimBegin = System.currentTimeMillis();
        sideAnimOld = 0;
        if (!paint) {
            this.repaint();
        }
    }

    protected final void onKey8() {
        if (!Main.verticalShopScroll || paint) {
            return;
        }
        this.dragIgnore = true;
        ++index;
        index %= files.length;
        if (!this.isContains()) {
            this.onKey8();
            return;
        }
        this.reset();
        side = true;
        sideAnimBegin = System.currentTimeMillis();
        sideAnimOld = 0;
        if (!paint) {
            this.repaint();
        }
    }

    protected final void onKey2() {
        if (!Main.verticalShopScroll || paint) {
            return;
        }
        this.dragIgnore = true;
        if (--index < 0) {
            index += files.length;
        }
        if (!this.isContains()) {
            this.onKey2();
            return;
        }
        this.reset();
        side = false;
        sideAnimBegin = System.currentTimeMillis();
        sideAnimOld = 0;
        if (!paint) {
            this.repaint();
        }
    }

    private boolean isContains() {
        for (int i = 0; i < items.length; ++i) {
            if (items[i] != index) continue;
            return true;
        }
        return false;
    }

    static {
        index = 0;
        proportionalShop = true;
        defaultArsenal = null;
        side = false;
        sideAnimBegin = 0L;
        sideAnimOld = 0;
        sideAnimTime = 130L;
        paint = false;
    }
}

