/*
 * Decompiled with CFR 0.152.
 */
package com.Rendering;

import com.Math.Matrix;
import com.Rendering.Meshes.Mesh;
import com.Rendering.MultyTexture;
import com.Rendering.RenderObject;
import com.Rendering.RenderObjectBuffer;
import com.Rendering.TMPElement;
import com.Rendering.Texture;
import com.Rendering.Vertex;
import com.misc.Main;
import javax.microedition.lcdui.Graphics;

public final class Graphics3D {
    public static final int[] sort = new int[]{1, 4, 10, 23, 57, 145, 356, 911, 1968, 4711, 11969, 27901, 84801};
    public int width;
    public int height;
    public int[] display;
    public boolean flushAlpha = false;
    public static Matrix camera;
    public static Matrix invCamera;
    public static Matrix finalCamera;
    public int distX = 150;
    public int distY = 150;
    public static int fDist;
    public static int drDist;
    public static int waterDistance;
    public static byte fog;
    public static int fogc;
    public static short lightdirx;
    public static short lightdiry;
    public static short lightdirz;
    private static Main main;
    public int centreX;
    public int centreY;
    private final RenderObjectBuffer buffer;
    public int lx;
    public int ly;
    public int lz = 0;
    public int shootIntensity = 0;
    public int shootLength = 0;

    public Graphics3D(int width, int height, Main mainz) {
        this.width = width;
        this.height = height;
        camera = new Matrix();
        invCamera = new Matrix();
        finalCamera = new Matrix();
        this.buffer = new RenderObjectBuffer();
        main = mainz;
        this.resize(this.width, this.height);
        this.lz = 0;
        this.ly = 0;
        this.lx = 0;
    }

    public void resize(int width, int height) {
        this.width = width;
        this.height = height;
        this.display = new int[this.width * this.height];
        this.centreX = this.width / 2;
        this.centreY = this.height / 2;
        this.distX = this.centreX * 5000 >> 12;
        this.distY = this.centreY * 5000 >> 12;
        this.distX = this.distX * height / width;
    }

    public final void updateFov(int fov) {
        this.distX = this.centreX * fov >> 12;
        this.distY = this.centreY * fov >> 12;
        this.distX = this.distX * this.height / this.width;
    }

    public final void destroy() {
        fDist = 1;
        drDist = 300000;
        fog = 0;
        fogc = 0x5500FF;
        finalCamera = null;
        invCamera = null;
        camera = null;
        this.buffer.resetTex();
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getnWidth() {
        return this.width;
    }

    public final int getnHeight() {
        return this.height;
    }

    public final int[] getDisplay() {
        return this.display;
    }

    public final void setCamera(Matrix matrix) {
        invCamera.set(matrix);
        camera.set(matrix);
        invCamera.invert();
    }

    public final Matrix getInvCamera() {
        return invCamera;
    }

    public final Matrix getCamera() {
        return camera;
    }

    public final Matrix computeFinalMatrix(Matrix matrix) {
        finalCamera.mul(invCamera, matrix);
        return finalCamera;
    }

    public final void addRenderObject(RenderObject obj) {
        this.addRenderObject(obj, 0, 0, this.width, this.height);
    }

    public final void addRenderObject(RenderObject obj, int x1, int y1, int x2, int y2) {
        this.buffer.addRenderObject(obj, x1, y1, x2, y2);
    }

    public final void addRenderObject(RenderObject obj, Texture tex) {
        this.buffer.addRenderObject(obj, tex, 0, 0, this.width, this.height);
    }

    public final void addRenderObjectDT(RenderObject obj, Texture tex) {
        this.buffer.addRenderObjectDT(obj, tex, 0, 0, this.width, this.height);
    }

    public final void addMesh(Mesh mesh, int x1, int y1, int x2, int y2) {
        this.buffer.addRenderObjects(mesh.getPoligons(), mesh.getTexture(), x1, y1, x2, y2);
    }

    public final void addMesh(Mesh mesh, int x1, int y1, int x2, int y2, MultyTexture tex) {
        this.buffer.addRenderObjects(mesh.getPoligons(), tex, x1, y1, x2, y2);
    }

    public final void render() {
        this.buffer.sort();
        TMPElement[] buffer2 = this.buffer.getBuffer();
        for (int i = this.buffer.getSize() - 1; i >= 0; --i) {
            TMPElement element = buffer2[i];
            element.obj.render(this, element.tex);
        }
        this.buffer.reset();
    }

    public final void flush(Graphics g, int x, int y) {
        g.drawRGB(this.display, 0, this.width, x, y, this.width, this.height, this.flushAlpha);
    }

    public static void transform(Mesh ms, Matrix m) {
        Vertex[] vers = ms.getVertices();
        int m00 = m.m00 >> 2;
        int m01 = m.m01 >> 2;
        int m02 = m.m02 >> 2;
        int m03 = m.m03;
        int m10 = m.m10 >> 2;
        int m11 = m.m11 >> 2;
        int m12 = m.m12 >> 2;
        int m13 = m.m13;
        int m20 = m.m20 >> 2;
        int m21 = m.m21 >> 2;
        int m22 = m.m22 >> 2;
        int m23 = m.m23;
        int fp = 12;
        for (int i = vers.length - 1; i >= 0; --i) {
            Vertex ver = vers[i];
            int x = ver.x;
            int y = ver.y;
            int z = ver.z;
            ver.sx = (x * m00 >> 12) + (y * m01 >> 12) + (z * m02 >> 12) + m03;
            ver.sy = (x * m10 >> 12) + (y * m11 >> 12) + (z * m12 >> 12) + m13;
            ver.rz = (x * m20 >> 12) + (y * m21 >> 12) + (z * m22 >> 12) + m23;
        }
    }

    public static void transform(Vertex[] vers, Matrix m) {
        if (m != null) {
            int m00 = m.m00 >> 2;
            int m01 = m.m01 >> 2;
            int m02 = m.m02 >> 2;
            int m03 = m.m03;
            int m10 = m.m10 >> 2;
            int m11 = m.m11 >> 2;
            int m12 = m.m12 >> 2;
            int m13 = m.m13;
            int m20 = m.m20 >> 2;
            int m21 = m.m21 >> 2;
            int m22 = m.m22 >> 2;
            int m23 = m.m23;
            int fp = 12;
            for (int i = vers.length - 1; i >= 0; --i) {
                Vertex ver = vers[i];
                int x = ver.x;
                int y = ver.y;
                int z = ver.z;
                ver.sx = (x * m00 >> 12) + (y * m01 >> 12) + (z * m02 >> 12) + m03;
                ver.sy = (x * m10 >> 12) + (y * m11 >> 12) + (z * m12 >> 12) + m13;
                ver.rz = (x * m20 >> 12) + (y * m21 >> 12) + (z * m22 >> 12) + m23;
            }
        } else {
            for (int i = vers.length - 1; i >= 0; --i) {
                Vertex ver = vers[i];
                ver.sx = ver.x;
                ver.sy = ver.y;
                ver.rz = ver.z;
            }
        }
    }

    public void project(Vertex[] vertices, int rz) {
        Vertex ver = null;
        for (int i = vertices.length - 1; i >= 0; --i) {
            ver = vertices[i];
            int sx = ver.sx;
            int sy = -ver.sy;
            if (rz <= 0) {
                sx = sx * this.distX / (rz + this.distX);
                sy = sy * this.distY / (rz + this.distY);
            }
            ver.sx = (short)(sx + this.centreX);
            ver.sy = (short)(sy + this.centreY);
        }
    }

    public static void returnMesh(Mesh ms) {
        Vertex[] vers = ms.getVertices();
        for (int i = vers.length - 1; i >= 0; --i) {
            Vertex ver = vers[i];
            ver.x = ver.sx;
            ver.y = ver.sy;
            ver.z = ver.rz;
        }
    }

    public static void transformSave(Mesh ms, Matrix m) {
        Vertex[] vers = ms.getVertices();
        int m00 = m.m00 >> 2;
        int m01 = m.m01 >> 2;
        int m02 = m.m02 >> 2;
        int m03 = m.m03;
        int m10 = m.m10 >> 2;
        int m11 = m.m11 >> 2;
        int m12 = m.m12 >> 2;
        int m13 = m.m13;
        int m20 = m.m20 >> 2;
        int m21 = m.m21 >> 2;
        int m22 = m.m22 >> 2;
        int m23 = m.m23;
        int fp = 12;
        for (int i = vers.length - 1; i >= 0; --i) {
            Vertex ver = vers[i];
            int x = ver.x;
            int y = ver.y;
            int z = ver.z;
            ver.sx = x;
            ver.sy = y;
            ver.rz = z;
            ver.x = (x * m00 >> 12) + (y * m01 >> 12) + (z * m02 >> 12) + m03;
            ver.y = (x * m10 >> 12) + (y * m11 >> 12) + (z * m12 >> 12) + m13;
            ver.z = (x * m20 >> 12) + (y * m21 >> 12) + (z * m22 >> 12) + m23;
        }
    }

    public void transformAndProjectVertices(Mesh ms, Matrix matrix) {
        Vertex[] vertices = ms.getVertices();
        int m00 = matrix.m00 >> 2;
        int m01 = matrix.m01 >> 2;
        int m02 = matrix.m02 >> 2;
        int m03 = matrix.m03;
        int m10 = matrix.m10 >> 2;
        int m11 = matrix.m11 >> 2;
        int m12 = matrix.m12 >> 2;
        int m13 = matrix.m13;
        int m20 = matrix.m20 >> 2;
        int m21 = matrix.m21 >> 2;
        int m22 = matrix.m22 >> 2;
        int m23 = matrix.m23;
        int fp = 12;
        for (int i = vertices.length - 1; i >= 0; --i) {
            Vertex ver = vertices[i];
            int x = ver.x;
            int y = ver.y;
            int z = ver.z;
            int sx = m03;
            if (m00 != 0) {
                sx += x * m00 >> 12;
            }
            if (m01 != 0) {
                sx += y * m01 >> 12;
            }
            if (m02 != 0) {
                sx += z * m02 >> 12;
            }
            int sy = -m13;
            if (m10 != 0) {
                sy -= x * m10 >> 12;
            }
            if (m11 != 0) {
                sy -= y * m11 >> 12;
            }
            if (m12 != 0) {
                sy -= z * m12 >> 12;
            }
            int rz = m23;
            if (m20 != 0) {
                rz += x * m20 >> 12;
            }
            if (m21 != 0) {
                rz += y * m21 >> 12;
            }
            if (m22 != 0) {
                rz += z * m22 >> 12;
            }
            if (rz < 0) {
                sx = sx * this.distX / (-rz + this.distX);
                sy = sy * this.distY / (-rz + this.distY);
            }
            ver.sx = sx + this.centreX;
            ver.sy = sy + this.centreY;
            ver.rz = rz;
        }
    }

    public void transformAndProjectVertices(Vertex[] vertices, Matrix matrix) {
        int m00 = matrix.m00 >> 2;
        int m01 = matrix.m01 >> 2;
        int m02 = matrix.m02 >> 2;
        int m03 = matrix.m03;
        int m10 = matrix.m10 >> 2;
        int m11 = matrix.m11 >> 2;
        int m12 = matrix.m12 >> 2;
        int m13 = matrix.m13;
        int m20 = matrix.m20 >> 2;
        int m21 = matrix.m21 >> 2;
        int m22 = matrix.m22 >> 2;
        int m23 = matrix.m23;
        int fp = 12;
        for (int i = vertices.length - 1; i >= 0; --i) {
            Vertex ver = vertices[i];
            int x = ver.x;
            int y = ver.y;
            int z = ver.z;
            int sx = m03;
            if (m00 != 0) {
                sx += x * m00 >> 12;
            }
            if (m01 != 0) {
                sx += y * m01 >> 12;
            }
            if (m02 != 0) {
                sx += z * m02 >> 12;
            }
            int sy = -m13;
            if (m10 != 0) {
                sy -= x * m10 >> 12;
            }
            if (m11 != 0) {
                sy -= y * m11 >> 12;
            }
            if (m12 != 0) {
                sy -= z * m12 >> 12;
            }
            int rz = m23;
            if (m20 != 0) {
                rz += x * m20 >> 12;
            }
            if (m21 != 0) {
                rz += y * m21 >> 12;
            }
            if (m22 != 0) {
                rz += z * m22 >> 12;
            }
            if (rz < 0) {
                sx = sx * this.distX / (-rz + this.distX);
                sy = sy * this.distY / (-rz + this.distY);
            }
            ver.sx = sx + this.centreX;
            ver.sy = sy + this.centreY;
            ver.rz = rz;
        }
    }

    public static void setFogDist(int d) {
        fDist = d;
    }

    public static void setDrDist(int d) {
        drDist = d;
    }

    public final void clearDisplay(int col) {
        int length = this.display.length;
        int i = 0;
        while (length - i > 5) {
            this.display[i] = col;
            this.display[i + 1] = col;
            this.display[i + 2] = col;
            this.display[i + 3] = col;
            this.display[i + 4] = col;
            i += 5;
        }
        while (i < length) {
            this.display[i] = col;
            ++i;
        }
    }

    static {
        fDist = 1;
        drDist = 30000000;
        waterDistance = 10000;
        fog = 0;
        fogc = 0x5500FF;
        lightdirx = 0;
        lightdiry = 0;
        lightdirz = 0;
    }
}

