/*
 * Decompiled with CFR 0.152.
 */
package code.Gameplay.Objects;

import code.AI.Player;
import code.Gameplay.GameScreen;
import code.Gameplay.Map.Character;
import code.Gameplay.Map.House;
import code.Gameplay.Map.RoomObject;
import code.Gameplay.Map.Scene;
import code.Math.Vector3D;
import code.utils.Asset;
import code.utils.Main;
import code.utils.QFPS;

public abstract class GameObject
extends RoomObject {
    private int frame;
    private int frame100;
    private float friction = 4.0f;
    public final Character character = new Character(0, 0);
    private int hp;
    public long DeathTime = 0L;

    public final void setCharacterSize(int modelHeight) {
        this.character.set((int)((float)modelHeight / 2.5f), (int)((float)modelHeight * 0.75f));
    }

    public final void setCharacterSize(int w, int h) {
        this.character.set(w, h);
    }

    public final void setCharacterSize(int w, int wz, int h) {
        this.character.set(w, wz, h);
    }

    protected final void jump(int jump, float force) {
        this.character.jump(jump, force);
    }

    public void update(Scene scene, Player player) {
        if (this.character.isUpdatable()) {
            this.character.update();
            this.character.collisionTest(this.getPart(), scene.getHouse());
            if (this.character.isOnFloor() || this.character.fly) {
                Vector3D speed = this.character.getSpeed();
                speed.x = (int)((float)speed.x / this.friction);
                speed.y = (int)((float)speed.y / this.friction);
                speed.z = (int)((float)speed.z / this.friction);
            }
        }
        ++this.frame;
        this.frame100 += 100 * QFPS.frameTime / 50;
    }

    public boolean damage(GameObject obj, int dmg) {
        return this.damage(dmg);
    }

    public boolean damage(int dmg) {
        boolean oldDead = this.isDead();
        this.hp -= dmg;
        if (this.hp < 0) {
            this.hp = 0;
        }
        if (oldDead != this.isDead()) {
            this.frame = 0;
            this.frame100 = 0;
            this.DeathTime = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    public final Character getCharacter() {
        return this.character;
    }

    public final int getHp() {
        return this.hp;
    }

    public final boolean isDead() {
        return this.hp <= 0;
    }

    public boolean isTimeToRenew() {
        return this.isDead() && this.frame > 1250 / (QFPS.frameTime == 0 ? 1 : QFPS.frameTime);
    }

    public final void setHp(int hp) {
        this.hp = hp;
    }

    public final int getFrame() {
        return this.frame;
    }

    public final void setFriction(float f) {
        this.friction = f;
    }

    public final float getFriction() {
        return this.friction;
    }

    public final int getFrameInter() {
        return this.frame100;
    }

    public final int getFrameInterDiv() {
        return this.frame100 / 100;
    }

    public final int getPosX() {
        return this.character.getTransform().m03;
    }

    public final int getPosZ() {
        return this.character.getTransform().m23;
    }

    public final int getPosY() {
        return this.character.getTransform().m13;
    }

    public final void setPos(int x, int y, int z) {
        this.character.getTransform().m03 = x;
        this.character.getTransform().m13 = y;
        this.character.getTransform().m23 = z;
    }

    public void activate(House house, Player player, GameScreen gs) {
        if (this.lastActivate >= 0L && this.lastActivate + this.timeToReset > GameScreen.time) {
            return;
        }
        if (!this.isAllCollected(Player.usedPoints, player, house, gs)) {
            if (this.errMessage != null) {
                this.errMsg(gs);
            }
            return;
        }
        if (this.sound != null && Main.isSounds && Main.sounds != 0) {
            Asset.getSound(this.sound).start(Main.sounds);
        }
        if (!(this.singleUse && this.activated || this.message == null)) {
            this.prMsg(gs);
        }
        if (!this.singleUse || !this.activated) {
            this.give(this.additional, player, house, gs);
        }
        if (!this.contains(Player.usedPoints, this.name)) {
            this.give(this.name, player);
            this.activated = true;
            if (this.timeToReset > 0L) {
                this.lastActivate = GameScreen.time;
            }
        }
        if (this.destroyOnUse) {
            house.removeObject(this);
        }
    }
}

