/*
 * Decompiled with CFR 0.152.
 */
package com.Gameplay.Map;

import com.Collision.Height;
import com.Collision.Ray;
import com.Gameplay.Map.Portal;
import com.Gameplay.Map.Room;
import com.Gameplay.Map.RoomObject;
import com.Gameplay.Map.Skybox;
import com.Gameplay.Objects.MeshObject;
import com.Math.Matrix;
import com.Math.Vector3D;
import com.Rendering.Graphics3D;
import com.Rendering.Texture;
import com.misc.Main;
import java.util.Vector;

public final class House {
    private Room[] rooms;
    private Room[][] neighbours;
    private Vector nearRooms = new Vector();
    private Vector renderedPortals = new Vector();
    private Skybox skybox;
    public int deep = 1;
    private Vector tVec = new Vector();
    private Vector tVec2 = new Vector();
    public boolean noPortals = false;

    public House(Room[] rooms, Room[][] neighbours) {
        this.rooms = rooms;
        this.neighbours = neighbours;
        this.deep = 1;
        this.noPortals = false;
    }

    public final void destroy() {
        for (int var1 = 0; var1 < this.rooms.length; ++var1) {
            this.rooms[var1].destroy();
            this.rooms[var1] = null;
        }
        this.rooms = null;
        this.neighbours = null;
        this.nearRooms.removeAllElements();
        this.nearRooms = null;
        if (this.skybox != null) {
            this.skybox.destroy();
            this.skybox = null;
        }
        this.deep = 1;
        this.noPortals = false;
    }

    public final void setTexture(Texture texture) {
        for (int var2 = 0; var2 < this.rooms.length; ++var2) {
            this.rooms[var2].getMesh().setTexture(texture);
        }
    }

    public final void setSkybox(Skybox skybox) {
        this.skybox = skybox;
    }

    public final Skybox getSkybox() {
        return this.skybox;
    }

    public final Room[] getRooms() {
        return this.rooms;
    }

    public final Room[] getNeighbourRooms(int part) {
        return this.neighbours[part];
    }

    private Vector getNearRooms(int part) {
        this.nearRooms.removeAllElements();
        if (part == -1) {
            return this.nearRooms;
        }
        if (this.rooms[part] != null) {
            this.nearRooms.addElement(this.rooms[part]);
        }
        Room[] var3 = this.neighbours[part];
        for (int var2 = 0; var2 < var3.length; ++var2) {
            if (var3[var2] == null) continue;
            this.nearRooms.addElement(var3[var2]);
        }
        return this.nearRooms;
    }

    public final boolean sphereCast(int part, Vector3D pos, int rad) {
        Vector var7 = this.getNearRooms(part);
        boolean col = false;
        if (var7.size() >= 1) {
            for (int var5 = 0; var5 < var7.size(); ++var5) {
                Room var6 = (Room)var7.elementAt(var5);
                col |= var6.sphereCast(pos, rad);
            }
        }
        this.getNearObjects(this.tVec, part);
        if (this.tVec.size() >= 1) {
            for (int i = 0; i < this.tVec.size(); ++i) {
                Object obj = this.tVec.elementAt(i);
                if (!(obj instanceof MeshObject)) continue;
                MeshObject point = (MeshObject)obj;
                if (!point.precCol) continue;
                col |= point.sphereCollisionTest(pos, rad);
            }
        }
        return col;
    }

    public final boolean sphereCast(int[] parts, Vector3D pos, int rad) {
        this.renderedPortals.removeAllElements();
        boolean col = false;
        for (int ipi = 0; ipi < parts.length; ++ipi) {
            int part = parts[ipi];
            Vector var7 = this.getNearRooms(part);
            if (var7.size() >= 1) {
                for (int var5 = 0; var5 < var7.size(); ++var5) {
                    Room var6 = (Room)var7.elementAt(var5);
                    if (this.renderedPortals.contains(var6)) continue;
                    col |= var6.sphereCast(pos, rad);
                    this.renderedPortals.addElement(var6);
                }
            }
            this.getNearObjects(this.tVec, part);
            if (var7.size() < 1) continue;
            for (int i = 0; i < this.tVec.size(); ++i) {
                Object obj = this.tVec.elementAt(i);
                if (!(obj instanceof MeshObject)) continue;
                MeshObject point = (MeshObject)obj;
                if (!point.precCol) continue;
                col |= point.sphereCollisionTest(pos, rad);
            }
        }
        return col;
    }

    public final void rayCast(int part, Ray ray) {
        if (part == -1) {
            return;
        }
        Vector var5 = this.getNearRooms(part);
        for (int var3 = 0; var3 < var5.size(); ++var3) {
            ((Room)var5.elementAt(var3)).rayCast(ray);
        }
        this.getNearObjects(this.tVec, part);
        for (int i = 0; i < this.tVec.size(); ++i) {
            Object obj = this.tVec.elementAt(i);
            if (!(obj instanceof MeshObject)) continue;
            MeshObject point = (MeshObject)obj;
            if (!point.precCol) continue;
            point.rayCast(ray);
        }
    }

    public void computeHeight(int part, Height height) {
        if (part == -1) {
            return;
        }
        this.rooms[part].computeHeight(height);
        Room[] near = this.neighbours[part];
        for (int i = 0; i < near.length; ++i) {
            if (near[i] == null) continue;
            near[i].computeHeight(height);
        }
    }

    public void computeHeightFull(int part, Height height) {
        if (part == -1) {
            return;
        }
        this.computeHeight(part, height);
        this.getNearObjects(this.tVec, part);
        for (int i = 0; i < this.tVec.size(); ++i) {
            Object obj = this.tVec.elementAt(i);
            if (!(obj instanceof MeshObject)) continue;
            MeshObject point = (MeshObject)obj;
            if (!point.precCol) continue;
            point.computeHeight(height);
        }
    }

    public void getNearObjects(Vector buf, int part) {
        buf.removeAllElements();
        if (part == -1) {
            return;
        }
        this.rooms[part].getObjects(buf);
        Room[] near = this.neighbours[part];
        for (int i = 0; i < near.length; ++i) {
            near[i].getObjects(buf);
        }
    }

    public Vector getNearObjects(int part) {
        this.tVec.removeAllElements();
        if (part == -1) {
            return this.tVec;
        }
        this.rooms[part].getObjects(this.tVec);
        Room[] near = this.neighbours[part];
        for (int i = 0; i < near.length; ++i) {
            near[i].getObjects(this.tVec);
        }
        return this.tVec;
    }

    public final int a_int_sub2(int part, int x, int y, int z) {
        int var5 = Integer.MIN_VALUE;
        Vector var8 = this.getNearRooms(part);
        for (int var6 = 0; var6 < var8.size(); ++var6) {
            int var7 = ((Room)var8.elementAt(var6)).a_int_sub2(x, y, z);
            if (var7 >= y || var7 <= var5) continue;
            var5 = var7;
        }
        return var5;
    }

    public final int a_int_sub(int part, int x, int y, int z) {
        int var5 = Integer.MIN_VALUE;
        Vector var8 = this.getNearRooms(part);
        for (int var6 = 0; var6 < var8.size(); ++var6) {
            if (!((Room)var8.elementAt(var6)).a_int_sub(x, y, z)) continue;
            var5 = ((Room)var8.elementAt(var6)).getId();
        }
        return var5;
    }

    public final int render(Graphics3D g3d, int[] part, int cx, int cz) {
        Room rm;
        int i;
        if (this.skybox != null) {
            this.skybox.render(g3d);
            g3d.render();
            this.skybox.resetViewport();
        }
        if (part.length == 0) {
            return 0;
        }
        this.nearRooms.removeAllElements();
        this.renderedPortals.removeAllElements();
        for (int x = part.length - 1; x >= 0; --x) {
            if (part[x] == -1) {
                return 0;
            }
            this.render(g3d, this.rooms[part[x]], 0, 0, g3d.getWidth(), g3d.getHeight(), cx, cz);
        }
        this.renderedPortals.removeAllElements();
        Room[] var3 = this.neighbours[part[0]];
        if (var3.length > 0) {
            for (i = 0; i < var3.length; ++i) {
                rm = var3[i];
                rm.render(g3d, 0, 0, g3d.getWidth(), g3d.getHeight());
                this.renderedPortals.addElement(rm);
            }
        }
        if (this.nearRooms.size() > 0) {
            for (i = 0; i < this.nearRooms.size(); ++i) {
                if (i >= this.nearRooms.size() || this.nearRooms.size() <= 0 || this.renderedPortals.contains(rm = (Room)this.nearRooms.elementAt(i))) continue;
                rm.render(g3d);
                this.renderedPortals.addElement(rm);
            }
        }
        return this.nearRooms.size();
    }

    private void render(Graphics3D g3d, Room mainRoom, int x1, int y1, int x2, int y2, int cx, int cz) {
        if (mainRoom != null) {
            mainRoom.setViewport(x1, y1, x2, y2);
            mainRoom.render(g3d, cx, cz);
            if (!this.nearRooms.contains(mainRoom)) {
                this.nearRooms.addElement(mainRoom);
            }
            if (mainRoom.isOpenSky() && this.skybox != null) {
                this.skybox.addViewport(x1, y1, x2, y2);
            }
            Portal[] var15 = mainRoom.getPortals();
            for (int var7 = 0; var7 < var15.length; ++var7) {
                Portal var8 = var15[var7];
                if (this.nearRooms.contains(var8.getRoom()) || !var8.isVisible(g3d, x1, y1, x2, y2)) continue;
                int var9 = var8.getMinX();
                int var10 = var8.getMinY();
                int var11 = var8.getMaxX();
                int var12 = var8.getMaxY();
                if (var9 < x1) {
                    var9 = x1;
                }
                if (var10 < y1) {
                    var10 = y1;
                }
                if (var11 > x2) {
                    var11 = x2;
                }
                if (var12 > y2) {
                    var12 = y2;
                }
                int var13 = var11 - var9;
                int var14 = var12 - var10;
                if (var13 < 20 && var14 < 20 || var13 < 5 || var14 < 5) continue;
                this.renderedPortals.addElement(var8);
                this.render(g3d, var8.getRoom(), var9, var10, var11, var12, cx, cz);
            }
        }
    }

    public final Vector getObjects() {
        this.tVec2.removeAllElements();
        for (int i = 0; i < this.rooms.length; ++i) {
            this.rooms[i].getObjects(this.tVec2);
        }
        return this.tVec2;
    }

    public void addObject(RoomObject obj) {
        this.recomputePart(obj);
        if (obj.getPart() == -1) {
            if (Main.debug) {
                System.out.println("House: \u041e\u0431\u044a\u0435\u043a\u0442 \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432\u043d\u0435 \u043a\u0430\u0440\u0442\u044b \u0438 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d");
            }
            return;
        }
    }

    public void removeObject(RoomObject obj) {
        if (obj.getPart() == -1) {
            return;
        }
        this.rooms[obj.getPart()].removeObject(obj);
    }

    public void recomputePart(RoomObject obj) {
        if (!obj.isNeedRecomputePart()) {
            return;
        }
        int x = obj.getPosX();
        int z = obj.getPosZ();
        int y = obj.getPosY();
        int oldPart = obj.getPart();
        int newPart = this.calcPart(oldPart, x, z, y);
        if (newPart != -1) {
            if (newPart != oldPart || oldPart == -1) {
                if (oldPart != -1) {
                    this.rooms[oldPart].removeObject(obj);
                }
                this.rooms[newPart].addObject(obj);
                obj.setPart(newPart);
            }
        } else if (Main.debug) {
            System.out.println("House.recalculatePart: newPart == -1  x=" + x + " z=" + z + "  " + obj);
        }
    }

    public int calcPart(int oldPart, int x, int z, int y) {
        if (oldPart != -1) {
            if (this.rooms[oldPart].isPointOnMesh(x, z, y) == 1) {
                return oldPart;
            }
            Room[] neighbours2 = this.neighbours[oldPart];
            for (int i = 0; i < neighbours2.length; ++i) {
                if (neighbours2[i].isPointOnMesh(x, z, y) != 1) continue;
                return neighbours2[i].getId();
            }
        }
        for (int i = 0; i < this.rooms.length; ++i) {
            if (this.rooms[i].isPointOnMesh(x, z, y) != 1) continue;
            return i;
        }
        return -1;
    }

    public static int[] getParts(House house, int part, Matrix cam) {
        Vector<String> parts = new Vector<String>();
        Room[] rooms = house.getRooms();
        int x = cam.m03;
        int y = cam.m13;
        int z = cam.m23;
        for (int i = 0; i < rooms.length; ++i) {
            Room mesh = rooms[i];
            if (x <= mesh.getMinX() || x >= mesh.getMaxX() || z <= mesh.getMinZ() || z >= mesh.getMaxZ() || (!rooms[i].isOpenSky() || y < mesh.getMinY()) && (rooms[i].isOpenSky() || y < mesh.getMinY() || y > mesh.getMaxY())) continue;
            parts.addElement(String.valueOf(i));
        }
        if (parts.indexOf(String.valueOf(part)) == -1) {
            parts.addElement(String.valueOf(part));
        }
        int[] out = new int[parts.size()];
        for (int i = 0; i < parts.size(); ++i) {
            out[i] = Integer.parseInt((String)parts.elementAt(i));
        }
        parts.removeAllElements();
        return out;
    }

    public final int computePart(int oldPart, int x, int y, int z) {
        if (oldPart != -1) {
            Room[] var5;
            if (this.rooms[oldPart].isPointOnMesh(x, z, y) != -1) {
                return oldPart;
            }
            if (oldPart != -1 && (var5 = this.neighbours[oldPart]) != null && var5.length > 0) {
                for (int var4 = 0; var4 < var5.length; ++var4) {
                    if (var5[var4] == null || var5[var4].isPointOnMesh(x, z, y) == -1) continue;
                    return var5[var4].getId();
                }
            }
        }
        for (oldPart = this.rooms.length - 1; oldPart >= 0; --oldPart) {
            if (this.rooms[oldPart] == null || this.rooms[oldPart].isPointOnMesh(x, z, y) == -1) continue;
            return oldPart;
        }
        return -1;
    }

    public boolean isNear(int id1, int id2) {
        if (id1 == id2) {
            return true;
        }
        if (id1 == -1 || id2 == -1) {
            return false;
        }
        if (id1 >= this.neighbours.length) {
            return false;
        }
        Room[] var3 = this.neighbours[id1];
        if (var3 != null) {
            for (int i = 0; i < var3.length; ++i) {
                Room room = var3[i];
                if (room == null || room.getId() != id2) continue;
                return true;
            }
        }
        return false;
    }
}

