/*
 * Decompiled with CFR 0.152.
 */
package com.HUD;

import com.HUD.GUIScreen;
import com.HUD.Menu;
import com.Rendering.Graphics3D;
import com.Rendering.Texture;
import com.Rendering.Texturing;
import com.Rendering.Vertex;
import com.misc.Main;
import javax.microedition.lcdui.Graphics;

final class Benchmark
extends GUIScreen {
    private int y0;
    private Main main;
    private Menu menu;
    private Graphics3D g3d;
    private Texture tex;
    private Vertex a;
    private Vertex b;
    private Vertex c;
    private long AffTime = 0L;
    private long PersTime = 0L;
    private long AffTime2 = 0L;
    private long PersTime2 = 0L;
    private byte rendermode = 0;

    public Benchmark(Main main, Menu menu) {
        this.main = main;
        this.menu = menu;
        this.setFont(Main.getFont());
        this.setSoftKeysNames("Change Render Mode", "Back");
        this.g3d = new Graphics3D(256, 256, main);
        this.tex = Texture.createTexture("/images/icon.png");
        this.a = new Vertex(0, 0, 0);
        this.a.sy = 0;
        this.a.sx = 0;
        this.a.rz = 0;
        this.b = new Vertex(0, 0, 0);
        this.b.sy = 0;
        this.b.sx = 255;
        this.b.rz = -100;
        this.c = new Vertex(0, 0, 0);
        this.c.sy = 255;
        this.c.sx = 0;
        this.c.rz = -25;
        this.test(true);
    }

    protected final void paint(Graphics g) {
        this.menu.drawBackground(g);
        g.setColor(0xFFFFFF);
        g.translate(this.getWidth() / 2, this.getHeight() / 2);
        g.drawString("Render Mode: " + this.rendermode, 0, -50, 65);
        g.drawString("Affine Time: " + Long.toString(this.AffTime) + " ms", 0, -20, 65);
        g.drawString("Perspective Time: " + Long.toString(this.PersTime) + " ms", 0, 20, 65);
        g.translate(-this.getWidth() / 2, -this.getHeight() / 2);
        this.drawSoftKeys(g);
    }

    protected final void onLeftSoftKey() {
        this.rendermode = (byte)(this.rendermode + 1);
        if (this.rendermode > 8) {
            this.rendermode = this.rendermode;
        }
        this.onKey5();
    }

    protected final void onRightSoftKey() {
        this.g3d.destroy();
        this.tex.destroy();
        this.a = null;
        this.b = null;
        this.c = null;
        this.rendermode = this.rendermode;
        System.gc();
        Main.setCurrent(this.menu);
    }

    protected final void onKey2() {
        this.repaint();
    }

    protected final void onKey5() {
        this.a.sy = 0;
        this.a.sx = 0;
        this.a.rz = 0;
        this.b.sy = 0;
        this.b.sx = 256;
        this.b.rz = -100;
        this.c.sy = 256;
        this.c.sx = 0;
        this.c.rz = -25;
        this.test(true);
        this.repaint();
    }

    protected final void onKey8() {
        this.repaint();
    }

    protected final void pointerPressed(int x, int y) {
        super.pointerPressed(x, y);
        this.y0 = y;
    }

    protected final void pointerDragged(int x, int y) {
        x = y - this.y0;
        this.y0 = y;
        this.serviceRepaints();
        this.repaint();
    }

    private void test(boolean tp) {
        int i;
        long bTime = System.currentTimeMillis();
        int count = 200;
        if (!tp) {
            count = 1000;
        }
        for (i = 0; i < count; ++i) {
            Texturing.paintPers(this.g3d, this.tex, this.a, 0, 0, this.b, 255, 0, this.c, 0, 255, 0, this.rendermode, 0, 24);
        }
        if (tp) {
            this.PersTime = System.currentTimeMillis() - bTime;
        } else {
            this.PersTime2 = System.currentTimeMillis() - bTime;
        }
        bTime = System.currentTimeMillis();
        for (i = 0; i < count; ++i) {
            Texturing.paintAffine(this.g3d, this.tex, this.a, 0, 0, this.b, 255, 0, this.c, 0, 255, 0, this.rendermode, 0);
        }
        if (tp) {
            this.AffTime = System.currentTimeMillis() - bTime;
        } else {
            this.AffTime2 = System.currentTimeMillis() - bTime;
        }
    }
}

