/*
 * Decompiled with CFR 0.152.
 */
package com.HUD;

import com.HUD.Base.Font;
import com.HUD.Base.Keyboard;
import com.HUD.MyCanvas.MyCanvas;
import javax.microedition.lcdui.Graphics;

public abstract class GUIScreen
extends MyCanvas {
    private String leftSoft;
    private String rightSoft;
    public boolean pressUp = false;
    public boolean pressDown = false;
    private Font font;
    private final Keyboard keys = new Keyboard(this);
    private int x = 0;
    private int y = 0;

    public void destroy() {
        this.rightSoft = null;
        this.leftSoft = null;
        this.font = null;
    }

    protected final void set(Font font, String leftSoft, String rightSoft) {
        this.font = font;
        this.setSoftKeysNames(leftSoft, rightSoft);
    }

    protected final void setFont(Font font) {
        this.font = font;
    }

    protected final Font getFont() {
        return this.font;
    }

    protected final void setSoftKeysNames(String leftSoft, String rightSoft) {
        this.leftSoft = leftSoft;
        this.rightSoft = rightSoft;
    }

    protected final void setLeftSoft(String name) {
        this.leftSoft = name;
    }

    protected final void drawSoftKeys(Graphics g) {
        int var2 = this.getWidth();
        int var3 = this.getHeight();
        if (this.font == null) {
            System.out.println("GUIScreen: ERROR: font == null");
        } else {
            this.font.setY(0);
            if (this.leftSoft != null) {
                this.font.drawString(g, this.leftSoft, 2, var3, 36);
            }
            if (this.rightSoft != null) {
                this.font.drawString(g, this.rightSoft, var2 - 2, var3, 40);
            }
        }
    }

    protected final void mousePressed(int x, int y) {
        this.onLeftSoftKey();
    }

    protected final void keyPressed(int key) {
        if (key == this.keys.SOFT_LEFT) {
            this.onLeftSoftKey();
        }
        if (key == this.keys.SOFT_RIGHT) {
            this.onRightSoftKey();
        }
        if (key == 55) {
            this.onKey7();
        }
        if (key == 57) {
            this.onKey9();
        }
        if (key == 53 || key == this.keys.FIRE) {
            this.onKey5();
        }
        if (key == 52 || key == this.keys.LEFT) {
            this.onKey4();
        }
        if (key == 54 || key == this.keys.RIGHT) {
            this.onKey6();
        }
        if (key == 50 || key == this.keys.UP) {
            this.onKey2();
            this.pressUp = true;
        }
        if (key == 56 || key == this.keys.DOWN) {
            this.onKey8();
            this.pressDown = true;
        }
    }

    protected final void keyReleased(int key) {
        if (key == 50 || key == this.keys.UP) {
            this.pressUp = false;
        }
        if (key == 56 || key == this.keys.DOWN) {
            this.pressDown = false;
        }
    }

    protected void onLeftSoftKey() {
    }

    protected void onRightSoftKey() {
    }

    protected void onKey5() {
    }

    protected void onKey4() {
    }

    protected void onKey6() {
    }

    protected void onKey7() {
    }

    protected void onKey9() {
    }

    protected void onKey2() {
    }

    protected void onKey8() {
    }

    protected void pointerPressed(int x, int y) {
        super.pointerPressed(x, y);
        this.x = x;
        this.y = y;
        if (GUIScreen.isLeftSoft(x, y, this.getWidth(), this.getHeight())) {
            this.keyPressed(this.keys.SOFT_LEFT);
        }
        if (GUIScreen.isRightSoft(x, y, this.getWidth(), this.getHeight())) {
            this.keyPressed(this.keys.SOFT_RIGHT);
        }
    }

    protected void pointerDragged(int x, int y) {
        int var3 = this.getWidth();
        int var4 = this.getHeight();
        if (Math.abs(this.x - x) > var3 / 7) {
            if (this.x < x) {
                this.onKey6();
            }
            if (this.x > x) {
                this.onKey4();
            }
            this.x = x;
        }
        if (Math.abs(this.y - y) > var4 / 7) {
            if (this.y > y) {
                this.onKey2();
            }
            if (this.y < y) {
                this.onKey8();
            }
            this.y = y;
        }
    }

    protected void pointerReleased(int x, int y) {
        super.pointerReleased(x, y);
    }

    public static boolean isLeftSoft(int x, int y, int w, int h) {
        int var4 = h / 10;
        return GUIScreen.inArea(x, y, 0, h - var4, w / 2 - w / 6, h);
    }

    public static boolean isRightSoft(int x, int y, int w, int h) {
        int var4 = h / 10;
        return GUIScreen.inArea(x, y, w / 2 + w / 6, h - var4, w, h);
    }

    private static boolean inArea(int x, int y, int x1, int y1, int x2, int y2) {
        return x >= x1 && x <= x2 && y >= y1 && y <= y2;
    }
}

