/*
 * Decompiled with CFR 0.152.
 */
package com.Rendering;

import com.Gameplay.Map.House;
import com.Math.MathUtils;
import com.Math.Matrix;

public class Camera {
    private Matrix tmpPos = new Matrix();
    private Matrix tmp = new Matrix();
    private Matrix camera = new Matrix();
    public int angle = -8;
    public int y = 1400;
    public int x = 500;
    public int z = 1000;
    private int oldPart = -1;
    private int part = -1;

    public void set(Matrix pos) {
        this.interpolation(this.tmpPos, pos);
        this.camera.set(this.tmpPos);
        this.camera.translate(this.x, this.y, this.z);
        this.tmp.setRotX(this.angle);
        this.camera.mul(this.tmp);
    }

    private void interpolation(Matrix m1, Matrix m2) {
        int sVec = 8;
        m1.m00 += (m2.m00 - m1.m00) / 8;
        m1.m01 += (m2.m01 - m1.m01) / 8;
        m1.m02 += (m2.m02 - m1.m02) / 8;
        m1.m10 += (m2.m10 - m1.m10) / 8;
        m1.m11 += (m2.m11 - m1.m11) / 8;
        m1.m12 += (m2.m12 - m1.m12) / 8;
        m1.m20 += (m2.m20 - m1.m20) / 8;
        m1.m21 += (m2.m21 - m1.m21) / 8;
        m1.m22 += (m2.m22 - m1.m22) / 8;
        m1.m03 = m2.m03;
        m1.m13 = m2.m13;
        m1.m23 = m2.m23;
        float l = this.invLength(m1.m00, m1.m01, m1.m02) * (float)Matrix.FP;
        m1.m00 = (int)((float)m1.m00 * l);
        m1.m01 = (int)((float)m1.m01 * l);
        m1.m02 = (int)((float)m1.m02 * l);
        l = this.invLength(m1.m10, m1.m11, m1.m12) * (float)Matrix.FP;
        m1.m10 = (int)((float)m1.m10 * l);
        m1.m11 = (int)((float)m1.m11 * l);
        m1.m12 = (int)((float)m1.m12 * l);
        l = this.invLength(m1.m20, m1.m21, m1.m22) * (float)Matrix.FP;
        m1.m20 = (int)((float)m1.m20 * l);
        m1.m21 = (int)((float)m1.m21 * l);
        m1.m22 = (int)((float)m1.m22 * l);
    }

    private float invLength(int x, int y, int z) {
        return MathUtils.invSqrt(x * x + y * y + z * z);
    }

    public void addAngle(int i) {
        this.angle += i;
    }

    public void addY(int i) {
        this.y += i;
    }

    public void addZ(int i) {
        this.z += i;
    }

    public void addX(int i) {
        this.x += i;
    }

    public Matrix getCamera() {
        return this.camera;
    }

    public void calcPart(House home) {
        this.oldPart = this.part = home.computePart(this.oldPart, this.camera.m03, this.camera.m13, this.camera.m23);
    }

    public int getPart() {
        return this.part;
    }
}

