/*
 * Decompiled with CFR 0.152.
 */
package com.Audio;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class Sound {
    private ByteArrayInputStream bis;
    private Player player;

    public Sound(String name) {
        try {
            System.out.println("Lowering Case " + name);
            String t = name.toLowerCase();
            System.out.println("Reading Format " + name);
            String type = Sound.formatCheck(t);
            System.out.println("Loading sound " + name);
            InputStream is = this.getClass().getResourceAsStream(name);
            System.out.println("Sound " + name + " loaded");
            byte[] snd = new byte[is.available()];
            is.read(snd);
            this.bis = new ByteArrayInputStream(snd);
            this.player = Manager.createPlayer((InputStream)this.bis, (String)type);
            this.player.realize();
            this.player.prefetch();
            this.player.setLoopCount(1);
            this.player.start();
            this.player.stop();
        }
        catch (Exception var2) {
            System.err.println("ERROR in Sound initialization " + name + ": " + var2);
        }
    }

    public void setLoop(int count) {
        try {
            this.player.setLoopCount(count);
        }
        catch (Exception var2) {
            System.err.println("ERROR in Sound loop set : " + var2);
        }
    }

    public void start(int volume) {
        try {
            this.player.setMediaTime(0L);
            this.setVolume(volume);
            this.player.start();
        }
        catch (Exception var2) {
            System.err.println("ERROR in Sound start : " + var2);
        }
    }

    public void stop() {
        try {
            this.player.stop();
            this.player.deallocate();
        }
        catch (Exception var2) {
            System.err.println("ERROR in Sound stop : " + var2);
        }
    }

    public void stopND() {
        try {
            this.player.stop();
        }
        catch (Exception var2) {
            System.err.println("ERROR in Sound stop : " + var2);
        }
    }

    public void setVolume(int i) {
        VolumeControl control;
        if (i < 1) {
            i = 1;
        }
        if (i > 100) {
            i = 100;
        }
        if ((control = (VolumeControl)this.player.getControl("VolumeControl")) != null) {
            control.setLevel(i);
        }
    }

    public void destroy() {
        try {
            if (this.player == null) {
                return;
            }
            this.player.stop();
            this.player.deallocate();
            try {
                this.bis.close();
                this.player.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.bis = null;
            this.player = null;
        }
        catch (Exception var2) {
            System.err.println("ERROR in Sound destroy : " + var2);
        }
    }

    public static final String formatCheck(String var2) {
        if (var2.endsWith(".wav") || var2.endsWith(".wave")) {
            return "audio/X-wav";
        }
        if (var2.endsWith(".midi") || var2.endsWith(".mid")) {
            return "audio/midi";
        }
        if (var2.endsWith(".mp3")) {
            return "audio/mpeg";
        }
        if (var2.endsWith(".amr")) {
            return "audio/amr";
        }
        if (var2.endsWith(".jts")) {
            return "audio/x-tone-seq";
        }
        if (var2.endsWith(".ac3")) {
            return "audio/ac3";
        }
        if (var2.endsWith(".ogg")) {
            return "audio/ogg";
        }
        if (var2.endsWith(".vorbis")) {
            return "audio/vorbis";
        }
        if (var2.endsWith(".xmf") || var2.endsWith(".mxmf")) {
            return "audio/mobile-xmf";
        }
        if (var2.endsWith(".mmf")) {
            return "application/vnd.yamaha.smaf-audio";
        }
        return "";
    }
}

