/*
 * Decompiled with CFR 0.152.
 */
package com.HUD.Base;

import com.HUD.Base.Font;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class TextView {
    private static final int INDENT = 3;
    private Vector lines = new Vector();
    private Font font;
    private int w;
    private int h;
    private boolean center = false;
    private int yOffset = 0;

    public TextView(String str, int w, int h, Font font) {
        this.font = font;
        this.w = w;
        this.h = h;
        this.createLines(str, this.lines);
    }

    private void createLines(String txt, Vector lines) {
        int wordWidth = 0;
        int wordStart = 0;
        int lastSpace = -1;
        int i = 0;
        while (i < txt.length()) {
            char ch = txt.charAt(i);
            if (ch == ' ') {
                lastSpace = i;
            }
            int wordEnd = -1;
            if (ch == '*') {
                wordEnd = i++;
            } else if (wordWidth + this.font.charWidth(ch) > this.w) {
                if (lastSpace != -1) {
                    i = lastSpace + 1;
                    wordEnd = lastSpace;
                } else {
                    wordEnd = i;
                }
            }
            if (wordEnd != -1) {
                String line = txt.substring(wordStart, wordEnd);
                lines.addElement(line);
                wordWidth = 0;
                wordStart = i;
                continue;
            }
            wordWidth += this.font.charWidth(ch);
            ++i;
        }
        if (wordStart < txt.length()) {
            lines.addElement(txt.substring(wordStart, txt.length()));
        }
    }

    public void addString(String str) {
        this.createLines(str, this.lines);
    }

    public void setString(String str) {
        this.lines.removeAllElements();
        this.createLines(str, this.lines);
    }

    public void paint(Graphics g, int x, int y) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        g.setClip(x, y, this.w, this.h);
        int stepY = this.getLineHeight();
        int posY = this.yOffset;
        for (int i = 0; i < this.lines.size(); ++i) {
            if (posY + stepY >= 0) {
                int posX;
                if (posY > this.h) break;
                String str = (String)this.lines.elementAt(i);
                posX = this.center ? (posX = this.w - this.font.widthOf(str) >> 1) : 0;
                this.font.drawString(g, str, posX + x, posY + y, 0);
            }
            posY += stepY;
        }
        g.setClip(clipX, clipY, clipWidth, clipHeight);
    }

    public void move(int dy) {
        this.yOffset += dy;
        int textHeight = this.getTextHeight();
        if (textHeight > this.h) {
            if (this.yOffset > 0) {
                this.yOffset = 0;
            }
            if (this.yOffset + textHeight < this.h) {
                this.yOffset = this.h - textHeight;
            }
        } else {
            if (this.yOffset < 0) {
                this.yOffset = 0;
            }
            if (this.yOffset + textHeight > this.h) {
                this.yOffset = this.h - textHeight;
            }
        }
        if (textHeight + this.yOffset < this.h && this.yOffset > 0) {
            this.yOffset = 0;
        }
    }

    public Font getFont() {
        return this.font;
    }

    public int getCountString() {
        return this.lines.size();
    }

    public int getLineHeight() {
        return this.font.height() + 3;
    }

    public int getTextHeight() {
        return this.getLineHeight() * this.lines.size() - 3;
    }

    public int getY() {
        return this.yOffset;
    }

    public void setY(int y) {
        this.yOffset = y;
    }

    public boolean getCenter() {
        return this.center;
    }

    public void setCenter(boolean cen) {
        this.center = cen;
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }
}

