/*
 * Decompiled with CFR 0.152.
 */
package com.Rendering;

import com.Math.Matrix;
import com.Rendering.Graphics3D;
import com.misc.Main;

public final class Vertex {
    public int x;
    public int y;
    public int z;
    public int sx;
    public int sy;
    public int rz;
    private static Main main;

    public Vertex() {
    }

    public Vertex(int x, int y, int z) {
        this.set(x, y, z);
    }

    public final void set(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public final void mul(int x, int y, int z) {
        this.x *= x;
        this.y *= y;
        this.z *= z;
    }

    public final void sub(int x, int y, int z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
    }

    public final void add(int x, int y, int z) {
        this.x += x;
        this.y += y;
        this.z += z;
    }

    public final void div(int x, int y, int z) {
        if (x != 0) {
            this.x /= x;
        }
        if (y != 0) {
            this.y /= y;
        }
        if (z != 0) {
            this.z /= z;
        }
    }

    public final void transform(Matrix matrix) {
        int fpss = Matrix.fp - 2;
        int var2 = matrix.m00 >> 2;
        int var3 = matrix.m01 >> 2;
        int var4 = matrix.m02 >> 2;
        int var5 = matrix.m03;
        int var6 = matrix.m10 >> 2;
        int var7 = matrix.m11 >> 2;
        int var8 = matrix.m12 >> 2;
        int var9 = matrix.m13;
        int var10 = matrix.m20 >> 2;
        int var11 = matrix.m21 >> 2;
        int var12 = matrix.m22 >> 2;
        int var13 = matrix.m23;
        this.sx = (this.x * var2 >> fpss) + (this.y * var3 >> fpss) + (this.z * var4 >> fpss) + var5;
        this.sy = (this.x * var6 >> fpss) + (this.y * var7 >> fpss) + (this.z * var8 >> fpss) + var9;
        this.rz = (this.x * var10 >> fpss) + (this.y * var11 >> fpss) + (this.z * var12 >> fpss) + var13;
    }

    public final void transformFE(Matrix matrix) {
        int fpss = Matrix.fp - 2;
        int var2 = matrix.m00 >> 2;
        int var3 = matrix.m01 >> 2;
        int var4 = matrix.m02 >> 2;
        int var5 = matrix.m03;
        int var6 = matrix.m10 >> 2;
        int var7 = matrix.m11 >> 2;
        int var8 = matrix.m12 >> 2;
        int var9 = matrix.m13;
        int var10 = matrix.m20 >> 2;
        int var11 = matrix.m21 >> 2;
        int var12 = matrix.m22 >> 2;
        int var13 = matrix.m23;
        this.sx = this.x;
        this.sy = this.y;
        this.rz = this.z;
        this.x = (this.x * var2 >> fpss) + (this.y * var3 >> fpss) + (this.z * var4 >> fpss) + var5;
        this.y = (this.x * var6 >> fpss) + (this.y * var7 >> fpss) + (this.z * var8 >> fpss) + var9;
        this.z = (this.x * var10 >> fpss) + (this.y * var11 >> fpss) + (this.z * var12 >> fpss) + var13;
    }

    public final void project(Graphics3D g3d) {
        if (this.rz <= 0) {
            this.sx = this.sx * g3d.distX / (-this.rz + g3d.distX) + g3d.centreX;
            this.sy = -this.sy * g3d.distY / (-this.rz + g3d.distY) + g3d.centreY;
        } else {
            this.sx += g3d.centreX;
            this.sy = -this.sy + g3d.centreY;
        }
    }
}

