/*
 * Decompiled with CFR 0.152.
 */
package com.AI;

import com.AI.BigZombie;
import com.AI.NPC;
import com.AI.Zombie;
import com.Gameplay.Arsenal;
import com.Gameplay.GameScreen;
import com.Gameplay.Map.Character;
import com.Gameplay.Map.House;
import com.Gameplay.Map.Scene;
import com.Gameplay.Objects.GameObject;
import com.Gameplay.Weapon;
import com.HUD.Base.HUDInfo;
import com.Math.Matrix;
import com.Math.Vector3D;
import com.Rendering.Fps;
import com.Rendering.Graphics3D;
import com.Rendering.Meshes.Mesh;
import com.Rendering.Meshes.MeshClone;
import com.Rendering.Meshes.Morphing;
import com.Rendering.MultyTexture;
import com.misc.Asset;
import com.misc.Main;
import com.misc.Stringer;
import java.util.Vector;

public final class Player
extends GameObject {
    private static Fps fps;
    public boolean zoom = false;
    public int fov = Main.minZoom;
    public int minFov = Main.minZoom;
    public int maxFov = Main.maxZoom;
    public long lastZoomAction = 0L;
    public static int money;
    public static String[] sndWalk;
    public static String sndJump;
    public static int stepIndex;
    public int frags = 0;
    public static Arsenal arsenal;
    private boolean damage = false;
    private int falldist = 0;
    private Morphing anim = null;
    private MultyTexture mt = null;
    public static Vector usedPoints;
    private int fr = 0;
    private long step = 0L;
    public boolean fly = false;
    private long lastJump = 0L;
    private long lastYCheck = 0L;
    private int lastY = 0;

    public Player(int width_g3d, int height_g3d, Vector3D pos, Object hudInfo) {
        this.set(width_g3d, height_g3d, pos, hudInfo);
    }

    public final void set(int width_g3d, int height_g3d, Vector3D pos, Object hudInfo) {
        this.name = "PLAYER";
        this.getCharacter().reset();
        this.getCharacter().getTransform().setPosition(0, 0, 0);
        if (pos != null) {
            this.getCharacter().getTransform().setPosition(pos.x, pos.y, pos.z);
        }
        this.setHp(100);
        this.frags = 0;
        this.setCharacterSize(400, 1503);
        this.falldist = 0;
        money = 0;
        arsenal = new Arsenal(width_g3d, height_g3d);
        if (hudInfo != null) {
            money = ((HUDInfo)hudInfo).money;
            int[] var8 = ((HUDInfo)hudInfo).ammo;
            Weapon[] var5 = Arsenal.getWeapons();
            for (int var6 = 0; var6 < var5.length; ++var6) {
                if (var5[var6] != null) {
                    var5[var6].reset();
                }
                if (var8[var6] == -1) {
                    var5[var6] = null;
                    continue;
                }
                var5[var6] = Stringer.createWeapon(var6);
                var5[var6].setAmmo(var8[var6]);
            }
            if (Arsenal.current != -1) {
                Arsenal.currentWeapon().createSprite(width_g3d, height_g3d);
            }
        }
    }

    public Morphing getAnim() {
        return this.anim;
    }

    public void setModel(String modelPath, String textures, float scale) {
        Mesh[] meshes = Asset.getMeshes(modelPath, scale, scale, scale);
        Mesh mesh = meshes[0];
        MeshClone animData = new MeshClone(mesh);
        this.anim = new Morphing(Morphing.create(meshes), animData.copy());
        animData = null;
        this.mt = Asset.getMultyTexture(textures);
        this.anim.getMesh().setTexture(this.mt);
    }

    public final void destroy() {
        if (this.anim != null) {
            this.anim.getMesh().destroy();
            this.anim.destroy();
        }
        this.anim = null;
        money = 0;
    }

    public final void render(Graphics3D g3d, int x1, int y1, int x2, int y2) {
        if (Main.stepSound != null && Main.isFootsteps && Main.footsteps != 0 && (this.getCharacter().speed.x != 0 || this.getCharacter().speed.z != 0) && this.getCharacter().onFloor && System.currentTimeMillis() - this.step > 450L) {
            String[] soundz = Main.stepSound;
            if (sndWalk != null) {
                soundz = sndWalk;
            }
            if (stepIndex >= soundz.length) {
                stepIndex = 0;
            }
            if (soundz != null) {
                try {
                    Asset.getSound(soundz[stepIndex]).stopND();
                    Asset.getSound(soundz[stepIndex]).start(Main.footsteps);
                    ++stepIndex;
                }
                catch (Exception var2) {
                    System.err.println("ERROR in Step sound: " + var2);
                }
            }
            this.step = System.currentTimeMillis();
        }
        if (this.anim == null && Arsenal.currentWeapon() != null) {
            Arsenal.currentWeapon().renderSplinter(g3d);
        }
        if (this.anim != null) {
            Matrix var6s = new Matrix();
            var6s.set(this.getCharacter().getTransform());
            if (this.getCharacter().speed.x != 0 || this.getCharacter().speed.z != 0) {
                this.anim.setFrame(this.fr * 170 / 100);
                this.fr += 20000 / Fps.getFps();
                if (this.fr * 170 / 100 > 2048) {
                    this.fr = 0;
                }
            }
            Matrix var6zs = g3d.computeFinalMatrix(var6s);
            g3d.transformAndProjectVertices(this.anim.getMesh(), var6zs);
            g3d.addMesh(this.anim.getMesh(), x1, y1, x2, y2, this.mt);
        }
    }

    public final void update(Scene scene, Player player) {
        super.update(scene, player);
        sndWalk = scene.getHouse().getRooms()[this.getPart()].stepSound;
        sndJump = scene.getHouse().getRooms()[this.getPart()].jumpSound;
        Character ch = this.getCharacter();
        if (!ch.onFloor && System.currentTimeMillis() - this.lastYCheck < 1000L) {
            this.falldist += this.lastY - this.getPosY();
        }
        if (this.falldist > 7000 && ch.onFloor) {
            this.damage = true;
            this.damage((this.falldist - 7000) / 40);
        }
        if (this.falldist > 11000 && !ch.onFloor) {
            this.damage = true;
            this.damage(100);
        }
        this.lastYCheck = System.currentTimeMillis();
        this.lastY = this.getPosY();
        if (ch.onFloor) {
            this.falldist = 0;
        }
        if (Arsenal.current != -1 && Arsenal.currentWeapon() != null) {
            GameObject var2 = Arsenal.currentWeapon().update(scene.getHouse(), this);
            if (var2 instanceof Zombie) {
                money += Main.zombieprice;
                ++this.frags;
            }
            if (var2 instanceof BigZombie) {
                money += Main.bigzombieprice;
                ++this.frags;
            }
            if (var2 != null && var2 instanceof NPC) {
                NPC npc = (NPC)var2;
                this.frags += npc.fragsOnDeath;
                money += npc.moneyOnDeath;
            }
        }
    }

    public final boolean damage(GameObject obj, int dmg) {
        if (Main.debug && dmg > 0) {
            return true;
        }
        if (dmg > 0) {
            this.damage = true;
        }
        if (dmg < 0 && this.getHp() - dmg > 100) {
            return super.damage(obj, -(100 - this.getHp()));
        }
        return super.damage(obj, dmg);
    }

    public final boolean isDamaged() {
        boolean var1 = this.damage;
        this.damage = false;
        return var1;
    }

    public final int getMoney() {
        return money;
    }

    public final int getFrags() {
        return this.frags;
    }

    public final void pay(int price) {
        money -= price;
    }

    public final Arsenal getArsenal() {
        return arsenal;
    }

    public final boolean isTimeToRenew() {
        return this.isDead() && this.getFrameInterDiv() > 45;
    }

    public final void fire() {
        if (Arsenal.current != -1) {
            Arsenal.currentWeapon().fire();
        }
    }

    public final void jump() {
        if (Main.debug && System.currentTimeMillis() - this.lastJump < 400L) {
            this.fly = !this.fly;
            this.lastJump = System.currentTimeMillis();
        }
        this.jump(150, 1.2f);
        if (this.character.onFloor && Main.isFootsteps && Main.footsteps != 0) {
            try {
                String snd = Main.jumpSound;
                if (sndJump != null) {
                    snd = sndJump;
                }
                Asset.getSound(snd).stopND();
                Asset.getSound(snd).start(Main.footsteps);
            }
            catch (Exception var2) {
                System.err.println("ERROR in Step sound: " + var2);
            }
        }
    }

    public final void rotLeft() {
        this.rotY((!this.zoom ? 7 : 5) * Main.mouseSpeed / 50);
    }

    public final void rotZ(int i) {
        this.rotY((int)((float)i * 1.5f));
    }

    public final void rotRight() {
        this.rotY(-(!this.zoom ? 7 : 5) * Main.mouseSpeed / 50);
    }

    public final void rotX(int angle) {
        if (this.anim == null) {
            int ang = angle * 2;
            if (this.getCharacter().getTransform().m12 < -15700 && ang > 0) {
                ang = 0;
            }
            if (this.getCharacter().getTransform().m12 > 15700 && ang < 0) {
                ang = 0;
            }
            this.getCharacter().rotX(ang);
        }
    }

    public final void rotXn(int angle) {
        if (this.anim == null) {
            int ang = angle * 2;
            if (this.getCharacter().getTransform().m12 < -15700 && ang > 0) {
                ang = 0;
            }
            if (this.getCharacter().getTransform().m12 > 15700 && ang < 0) {
                ang = 0;
            }
            this.getCharacter().rotXn(ang / 2);
        }
    }

    public final void rotXnHQ(int angle) {
        if (this.anim == null) {
            int ang = angle * 2;
            if (this.getCharacter().getTransform().m12 < -15700 && ang > 0) {
                ang = 0;
            }
            if (this.getCharacter().getTransform().m12 > 15700 && ang < 0) {
                ang = 0;
            }
            this.getCharacter().rotXn(ang / 2);
        }
    }

    public final void moveForward() {
        this.moveZ(-150);
        if (Arsenal.currentWeapon() != null) {
            Arsenal.currentWeapon().enableShake();
        }
    }

    public final void moveBackward() {
        this.moveZ(150);
        if (Arsenal.currentWeapon() != null) {
            Arsenal.currentWeapon().enableShake();
        }
    }

    public final void moveLeft() {
        this.getCharacter().moveX(-150);
        if (Arsenal.currentWeapon() != null) {
            Arsenal.currentWeapon().enableShake();
        }
    }

    public final void moveRight() {
        this.getCharacter().moveX(150);
        if (Arsenal.currentWeapon() != null) {
            Arsenal.currentWeapon().enableShake();
        }
    }

    public final Object getHUDInfo() {
        Weapon[] var1 = Arsenal.getWeapons();
        int[] var2 = new int[var1.length];
        for (int var3 = 0; var3 < var1.length; ++var3) {
            var2[var3] = var1[var3] != null ? var1[var3].getAmmo() + var1[var3].getRounds() : -1;
        }
        return new HUDInfo(money, var2);
    }

    public void activate(House house, Player player, GameScreen gs) {
    }

    static {
        money = 0;
        sndWalk = null;
        sndJump = null;
        stepIndex = 0;
        usedPoints = new Vector();
    }
}

