/*
 * Decompiled with CFR 0.152.
 */
package com.Gameplay.Objects;

import com.AI.Player;
import com.Collision.Height;
import com.Collision.HeightComputer;
import com.Collision.Ray;
import com.Collision.RayCast;
import com.Collision.SphereCast;
import com.Gameplay.GameScreen;
import com.Gameplay.Map.House;
import com.Gameplay.Map.Scene;
import com.Gameplay.Objects.GameObject;
import com.Math.Matrix;
import com.Math.Vector3D;
import com.Rendering.Graphics3D;
import com.Rendering.Meshes.BoundingBox;
import com.Rendering.Meshes.Mesh;
import com.Rendering.Meshes.MeshClone;
import com.Rendering.Meshes.Morphing;
import com.Rendering.Meshes.Polygon3V;
import com.Rendering.Meshes.Polygon4V;
import com.Rendering.MultyTexture;
import com.Rendering.RenderObject;
import com.Rendering.Vertex;

public final class MeshObject
extends GameObject {
    public static final int OPEN = 1;
    public static final int CLOSE = 2;
    public static final int LOOP = 0;
    public static final int STAY_BEGIN = 0;
    public static final int DRIVE = 1;
    public static final int STAY_END = 2;
    public static final int DRIVE_BACK = 3;
    public int state = 0;
    public int LIFT_STATE = 0;
    public long clickTime = System.currentTimeMillis();
    public long liftClickTime = System.currentTimeMillis();
    public Vector3D[] poses;
    public long clickAnim = 0L;
    public int[] timeToMove;
    public static short[][] animData;
    public static MeshClone meshData;
    public Morphing animation;
    public MultyTexture tex;
    public float animSpeed = 0.0f;
    public int addsz = 1500;
    public int animType = 0;
    public int minx;
    public int maxx;
    public int minz;
    public int maxz;
    public boolean precCol = false;
    public BoundingBox boundingBox;

    public MeshObject(Mesh[] meshes, MultyTexture tex2, int xx, int yy, int zz) {
        Mesh mesh = meshes[0];
        animData = Morphing.create(meshes);
        meshData = new MeshClone(mesh);
        this.poses = new Vector3D[1];
        this.poses[0] = new Vector3D(xx, yy, zz);
        this.animation = new Morphing(animData, meshData.copy());
        meshData.destroy();
        meshData = null;
        this.getCharacter().getTransform().setIdentity();
        this.animation.getMesh().setTexture(tex2);
        this.boundingBox = new BoundingBox(this.animation);
        this.tex = tex2;
        this.set(xx, yy, zz);
        this.setHp(999999);
    }

    public void computeAABB() {
        int i;
        this.minz = Integer.MAX_VALUE;
        this.minx = Integer.MAX_VALUE;
        this.maxz = Integer.MIN_VALUE;
        this.maxx = Integer.MIN_VALUE;
        Matrix mat = this.getCharacter().getTransform();
        Vertex[] vers = this.boundingBox.getVertices();
        for (int i2 = 0; i2 < vers.length; ++i2) {
            vers[i2].transform(mat);
            this.addToAABB(vers[i2].sx, vers[i2].sy, vers[i2].rz);
        }
        RenderObject[] ro = this.animation.getMesh().getPolygons();
        Vertex[] vert = this.animation.getMesh().getVertices();
        for (i = 0; i < vert.length; ++i) {
            vert[i].transformFE(mat);
        }
        for (i = 0; i < ro.length; ++i) {
            RenderObject obj;
            if (ro[i] instanceof Polygon4V) {
                obj = (Polygon4V)ro[i];
                ro[i].calculateNormals(obj.a, obj.b, obj.d);
                continue;
            }
            if (!(ro[i] instanceof Polygon3V)) continue;
            obj = (Polygon3V)ro[i];
            ro[i].calculateNormals(((Polygon3V)obj).a, ((Polygon3V)obj).b, ((Polygon3V)obj).c);
        }
        for (i = 0; i < vert.length; ++i) {
            vert[i].x = vert[i].sx;
            vert[i].y = vert[i].sy;
            vert[i].z = vert[i].rz;
        }
    }

    private void addToAABB(int x, int y, int z) {
        if (x < this.minx) {
            this.minx = x;
        }
        if (z < this.minz) {
            this.minz = z;
        }
        if (x > this.maxx) {
            this.maxx = x;
        }
        if (z > this.maxz) {
            this.maxz = z;
        }
    }

    public boolean sphereCollisionTest(Vector3D pos, int rad) {
        if (!SphereCast.isSphereAABBCollision(pos, rad, this.minx - this.poses[0].x + this.getCharacter().getTransform().m03, this.maxx - this.poses[0].x + this.getCharacter().getTransform().m03, this.minz - this.poses[0].z + this.getCharacter().getTransform().m23, this.maxz - this.poses[0].z + this.getCharacter().getTransform().m23)) {
            return false;
        }
        return SphereCast.sphereCast(this.animation.getMesh(), this.getCharacter().getTransform(), pos, rad);
    }

    public void set(int xx, int yy, int zz) {
        this.getCharacter().reset();
        this.getCharacter().getTransform().setPosition(xx, yy, zz);
        int xsize = this.animation.getMesh().maxX() - this.animation.getMesh().minX();
        int zsize = this.animation.getMesh().maxX() - this.animation.getMesh().minX();
        int ysize = this.animation.getMesh().maxY() - this.animation.getMesh().minY();
        this.setCharacterSize(xsize / 2, zsize / 2, ysize);
    }

    public void destroy() {
    }

    public final int a_int_sub2(int x, int y, int z) {
        return x >= this.minx && z >= this.minz && x <= this.maxx && z <= this.maxz ? Scene.isPointOnMesh(this.animation.getMesh(), x, y, z) : Integer.MIN_VALUE;
    }

    public final void rayCast(Ray ray) {
        Vector3D var2 = ray.getStart();
        Vector3D var3 = ray.getDir();
        int var4 = Math.min(var2.x, var2.x + var3.x);
        int var5 = Math.min(var2.z, var2.z + var3.z);
        int var6 = Math.max(var2.x, var2.x + var3.x);
        int var7 = Math.max(var2.z, var2.z + var3.z);
        if (var4 <= this.maxx && var5 <= this.maxz && var6 >= this.minx && var7 >= this.minz) {
            RayCast.rayCast(this.animation.getMesh(), ray, this.getCharacter().getTransform());
        }
    }

    protected static void increaseMeshSz(Mesh mesh, int val1) {
        RenderObject[] var2 = mesh.getPoligons();
        for (int val = 0; val < var2.length; ++val) {
            var2[val].sz += val1;
        }
    }

    public void computeHeight(Height height) {
        Vector3D pos = height.getPosition();
        if (!HeightComputer.isPointAABBCollision(pos.x, pos.z, this.minx - this.poses[0].x + this.getCharacter().getTransform().m03, this.maxx - this.poses[0].x + this.getCharacter().getTransform().m03, this.minz - this.poses[0].z + this.getCharacter().getTransform().m23, this.maxz - this.poses[0].z + this.getCharacter().getTransform().m23)) {
            return;
        }
        HeightComputer.computeHeight(this.animation.getMesh(), this.getCharacter().getTransform(), height);
    }

    public void update(Scene scene, Player player) {
        if (this.LIFT_STATE == 0) {
            this.getCharacter().getTransform().setPosition(this.poses[0]);
        } else if (this.LIFT_STATE == 2) {
            this.getCharacter().getTransform().setPosition(this.poses[this.poses.length - 1]);
        } else if (this.LIFT_STATE == 1 || this.LIFT_STATE == 3) {
            int summ = 0;
            for (int i = 0; i < this.timeToMove.length; ++i) {
                summ += this.timeToMove[i];
            }
            long curTime = System.currentTimeMillis();
            long coof = curTime - this.liftClickTime;
            if (this.LIFT_STATE == 1 && coof >= (long)summ) {
                this.LIFT_STATE = 2;
            } else if (this.LIFT_STATE == 3 && coof >= (long)summ) {
                this.LIFT_STATE = 0;
            } else {
                int b;
                if (this.LIFT_STATE == 3) {
                    coof = (long)summ - coof;
                }
                int a = 0;
                int sub = 0;
                for (int i = 0; i < this.timeToMove.length; ++i) {
                    if (coof < (long)(sub += this.timeToMove[i])) continue;
                    ++a;
                }
                if (a > this.poses.length - 1) {
                    a = 0;
                }
                if ((b = a + 1) > this.poses.length - 1) {
                    b = 0;
                }
                if (a < 0) {
                    a = 0;
                }
                if (b < 0) {
                    b = 0;
                }
                sub = 0;
                for (int i = 0; i < a; ++i) {
                    sub += this.timeToMove[i];
                }
                int c = (int)((coof - (long)sub) * 1000L / (long)this.timeToMove[a]);
                int d = 1000 - c;
                this.getCharacter().getTransform().setPosition((this.poses[a].x * d + this.poses[b].x * c) / 1000, (this.poses[a].y * d + this.poses[b].y * c) / 1000, (this.poses[a].z * d + this.poses[b].z * c) / 1000);
            }
        }
        if (this.state == 0) {
            if (this.animType == 0) {
                this.animation.setFrame((int)((float)this.getFrameInter() * this.animSpeed / 100.0f));
            }
            if (this.animType == 1) {
                this.animation.setFrame2((int)((float)this.getFrameInter() * this.animSpeed / 100.0f));
            }
        } else if (this.state == 1) {
            long frame = (long)((float)this.clickAnim + (float)(System.currentTimeMillis() - this.clickTime) * this.animSpeed * 20.0f / 1000.0f);
            if (frame >= (long)(this.animation.getMaxFrame() - 1024)) {
                frame = this.animation.getMaxFrame() - 1024;
            }
            this.animation.setFrame((int)frame);
        } else if (this.state == 2) {
            long frame = (long)((float)this.clickAnim - (float)(System.currentTimeMillis() - this.clickTime) * this.animSpeed * 20.0f / 1000.0f);
            if (frame < 0L) {
                frame = 0L;
            }
            this.animation.setFrame((int)frame);
        }
        super.update(scene, player);
    }

    public final void render(Graphics3D g3d, int x1, int y1, int x2, int y2) {
        if (!this.visible) {
            return;
        }
        if (this.lastActivate > 0L && this.lastActivate + this.timeToReset > System.currentTimeMillis() && this.hideWhenUnusable) {
            return;
        }
        Matrix var6 = this.getCharacter().getTransform();
        if (!this.boundingBox.isVisible(g3d, var6 = g3d.computeFinalMatrix(var6), x1, y1, x2, y2)) {
            return;
        }
        g3d.transformAndProjectVertices(this.animation.getMesh(), var6);
        g3d.addMesh(this.animation.getMesh(), x1, y1, x2, y2, this.tex);
        MeshObject.increaseMeshSz(this.animation.getMesh(), this.addsz);
    }

    public void activate(House house, Player player, GameScreen gs) {
        if (this.lastActivate > 0L && this.lastActivate + this.timeToReset > System.currentTimeMillis()) {
            return;
        }
        if (!this.singleUse && !this.contains(Player.usedPoints, this.name) && this.isAllCollected(Player.usedPoints, player, house, gs)) {
            if (this.state == 2) {
                this.state = 1;
            } else if (this.state == 1) {
                this.state = 2;
            }
            this.clickAnim = this.animation.getFrame();
            this.clickTime = System.currentTimeMillis();
            if (this.poses.length > 1) {
                if (this.LIFT_STATE == 0 || this.LIFT_STATE == 2) {
                    this.liftClickTime = System.currentTimeMillis();
                }
                if (this.LIFT_STATE == 0) {
                    this.LIFT_STATE = 1;
                }
            }
        }
        super.activate(house, player, gs);
    }
}

