/*
 * Decompiled with CFR 0.152.
 */
package com.HUD;

import com.Gameplay.Arsenal;
import com.HUD.Base.ItemList;
import com.HUD.GUIScreen;
import com.HUD.LanguageScreen;
import com.HUD.Menu;
import com.Rendering.Meshes.Mesh;
import com.misc.Main;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class SplashScreen
extends GUIScreen {
    private Main main;
    private int action;
    private Image splash;
    private Image background;
    private ItemList list;
    private String[] langlist = Mesh.cutOnStrings(Mesh.getStringFromResource("/languages/languages.txt"), ',');

    public SplashScreen(Main var1) {
        this.main = var1;
        this.setFont(Main.getFont());
        this.onAction(1);
        if (Main.bcks != null) {
            Main.bcks = Arsenal.resize(Main.bcks, this.getWidth(), Main.bcks.getHeight());
        }
        if (Main.bcks2 != null) {
            Main.bcks2 = Arsenal.resize(Main.bcks2, this.getWidth(), Main.bcks2.getHeight());
        }
    }

    public final void destroy() {
        super.destroy();
        this.background = null;
        this.splash = null;
    }

    private void onAction(int action) {
        this.action = action;
        if (action == 1) {
            try {
                this.splash = Arsenal.resize(Image.createImage((String)Main.splash), (float)this.getHeight() / 320.0f, (float)this.getHeight() / 320.0f);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (Main.lang == -1) {
                new LanguageScreen(this).start();
            }
        } else if (action == 2) {
            this.splash = null;
            try {
                this.background = Arsenal.resize(Image.createImage((String)Main.background_logo), this.getWidth(), this.getHeight());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String[] var4 = new String[this.langlist.length];
            if (var4 != null) {
                for (int i = 0; i < var4.length; ++i) {
                    var4[i] = this.langlist[i];
                    if (var4[i] == null) continue;
                    if (Main.settings.getString(var4[i]) != null) {
                        var4[i] = Main.settings.getString2(var4[i]);
                    }
                    if (Main.getGameText().getString(var4[i]) == null) continue;
                    var4[i] = Main.settings.getString2(var4[i]);
                }
            }
            this.list = new ItemList(var4, Main.getFont());
            this.setSoftKeysNames(Main.getGameText$6783a6a7().getString2("SELECT"), null);
        } else if (action == 3) {
            this.splash = null;
            String[] var4 = new String[]{Main.getGameText$6783a6a7().getString2("AUDIO") + ":" + Main.getGameText$6783a6a7().getString2("ON"), Main.getGameText$6783a6a7().getString2("AUDIO") + ":" + Main.getGameText$6783a6a7().getString2("OFF")};
            this.list = new ItemList(var4, Main.getFont());
            this.setSoftKeysNames(Main.getGameText$6783a6a7().getString2("SELECT"), null);
        }
        this.repaint();
    }

    protected final void paint(Graphics g) {
        if (this.action == 1 || this.action == -1) {
            g.setColor(0xFFFFFF);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.splash != null) {
                g.drawImage(this.splash, this.getWidth() / 2, this.getHeight() / 2, 3);
            }
        } else if (this.action == 2) {
            if (this.background != null) {
                g.drawImage(this.background, 0, 0, 0);
            }
            if (this.list != null) {
                this.list.draw(g, 0, 0, this.getWidth(), this.getHeight());
            }
        } else if (this.action == 3) {
            if (this.background != null) {
                g.drawImage(this.background, 0, 0, 0);
            }
            if (this.list != null) {
                this.list.draw(g, 0, 0, this.getWidth(), this.getHeight());
            }
        }
        if (this.action != 1 && this.action != -1) {
            this.drawSoftKeys(g);
        }
        if ((this.action == 1 || this.action == -1) && Main.lang != -1) {
            this.reloadScreen();
        }
    }

    protected final void onKey2() {
        if (this.action == 2 || this.action == 3) {
            this.list.scrollUp();
            this.repaint();
        }
    }

    protected final void onKey8() {
        if (this.action == 2 || this.action == 3) {
            this.list.scrollDown();
            this.repaint();
        }
    }

    protected final void onKey5() {
        if (this.action == 2) {
            String var1 = "/languages/" + this.langlist[this.list.getIndex()].toLowerCase() + ".txt";
            this.main.setLanguage(var1);
            Main.lang = this.list.getIndex();
            this.main.saveSettingToStore();
            this.setFont(Main.getFont());
            this.onAction(3);
        } else if (this.action == 3) {
            boolean au;
            Main.isSounds = au = this.list.getIndex() == 0;
            Main.isMusic = au;
            Main.isFootsteps = au;
            Main.setCurrent(new Menu(this.main));
            this.destroy();
        }
    }

    protected final void onLeftSoftKey() {
        this.onKey5();
    }

    static void langSelection(SplashScreen s, int action) {
        s.onAction(2);
    }

    void reloadScreen() {
        if (this.action == 1) {
            this.action = -1;
            this.repaint();
            return;
        }
        try {
            Thread.sleep(3000L);
            this.background = Arsenal.resize(Image.createImage((String)Main.background_logo), this.getWidth(), this.getHeight());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.onAction(3);
    }

    public void sizeChanged(int w, int h) {
        try {
            this.background = null;
            this.background = Arsenal.resize(Image.createImage((String)Main.background_logo), w, h);
        }
        catch (Exception var4) {
            var4.printStackTrace();
        }
    }
}

