/*
 * Decompiled with CFR 0.152.
 */
package com.Rendering;

import com.Rendering.Graphics3D;
import com.Rendering.Texture;
import com.Rendering.Vertex;

public abstract class RenderObject {
    public int sz;
    public short nx;
    public short ny;
    public short nz;
    public static final int normal_fp = 12;

    public RenderObject() {
        this.nz = 0;
        this.ny = 0;
        this.nx = 0;
    }

    public RenderObject(Vertex ver1, Vertex ver2, Vertex ver3) {
        long x = (long)(ver1.y - ver2.y) * (long)(ver1.z - ver3.z) - (long)(ver1.z - ver2.z) * (long)(ver1.y - ver3.y);
        long y = (long)(ver1.z - ver2.z) * (long)(ver1.x - ver3.x) - (long)(ver1.x - ver2.x) * (long)(ver1.z - ver3.z);
        long z = (long)(ver1.x - ver2.x) * (long)(ver1.y - ver3.y) - (long)(ver1.y - ver2.y) * (long)(ver1.x - ver3.x);
        double sqrt = Math.sqrt(x * x + y * y + z * z) / 4096.0;
        this.nx = (short)((double)x / sqrt);
        this.ny = (short)((double)y / sqrt);
        this.nz = (short)((double)z / sqrt);
    }

    public void calculateNormals(Vertex ver1, Vertex ver2, Vertex ver3) {
        long x = (long)(ver1.y - ver2.y) * (long)(ver1.z - ver3.z) - (long)(ver1.z - ver2.z) * (long)(ver1.y - ver3.y);
        long y = (long)(ver1.z - ver2.z) * (long)(ver1.x - ver3.x) - (long)(ver1.x - ver2.x) * (long)(ver1.z - ver3.z);
        long z = (long)(ver1.x - ver2.x) * (long)(ver1.y - ver3.y) - (long)(ver1.y - ver2.y) * (long)(ver1.x - ver3.x);
        double sqrt = Math.sqrt(x * x + y * y + z * z) / 4096.0;
        this.nx = (short)((double)x / sqrt);
        this.ny = (short)((double)y / sqrt);
        this.nz = (short)((double)z / sqrt);
    }

    public abstract void render(Graphics3D var1, Texture var2);

    public abstract void renderFast(Graphics3D var1, Texture var2);

    public abstract boolean isVisible(int var1, int var2, int var3, int var4);
}

