/*
 * Decompiled with CFR 0.152.
 */
package com.AI.misc;

import com.Gameplay.Objects.GameObject;
import com.Math.Matrix;
import com.Math.Vector3D;
import com.Rendering.Fps;
import com.Rendering.Graphics3D;
import com.Rendering.Meshes.Sprite;
import com.Rendering.Texture;
import com.misc.Main;

public class Blood {
    private static Fps fps;
    public static Texture blood;
    private GameObject obj;
    private int frame = 255;
    private Sprite sprite = new Sprite(5);
    private static byte mir;

    public Blood(GameObject obj) {
        this.obj = obj;
        this.sprite.setTextures(new Texture[]{blood});
        this.sprite.setScale(5);
        this.sprite.mode = (byte)3;
        this.sprite.mirX = false;
        this.sprite.mirY = false;
        if (!Blood.blood.alphaMixing) {
            this.sprite.mode = 0;
        }
        if (mir >= 2) {
            this.sprite.mirX = true;
        }
        if (mir == 1 || mir == 2) {
            this.sprite.mirY = true;
        }
        if ((mir = (byte)(mir + 1)) > 3) {
            mir = 0;
        }
    }

    public final void reset() {
        this.sprite.setScale(5);
        this.frame = 255;
    }

    public final void destroy() {
        this.obj = null;
        this.sprite.destroy();
        this.sprite = null;
    }

    public final void bleed() {
        this.frame = 0;
        this.sprite.mirX = !this.sprite.mirX;
        this.sprite.mirY = !this.sprite.mirX;
    }

    public final void render(Graphics3D g3d, int sz, Vector3D pos) {
        Matrix var3 = this.obj.getCharacter().getTransform();
        this.sprite.getPosition().set(pos.x, pos.y, pos.z);
        this.frame += 2000 / Fps.getFps();
        this.sprite.setScale((int)((float)(this.frame / 2) * Main.bloodscale));
        this.sprite.setOffset(0, -this.sprite.getHeight() / 2 - this.frame * 4);
        this.sprite.project(g3d.getInvCamera(), g3d);
        g3d.addRenderObject(this.sprite);
        this.sprite.sz += sz;
    }

    public final boolean isBleeding() {
        return this.frame < 70;
    }

    static {
        blood = null;
        mir = 0;
    }
}

