/*
 * Decompiled with CFR 0.152.
 */
package com.Gameplay.Objects;

import com.AI.Player;
import com.Gameplay.GameScreen;
import com.Gameplay.Map.House;
import com.Gameplay.Map.RoomObject;
import com.Math.Vector3D;
import com.Rendering.Graphics3D;
import com.misc.Asset;
import com.misc.Main;
import javax.microedition.lcdui.Image;

public final class Image2D
extends RoomObject {
    public Vector3D pos = new Vector3D(0, 0, 0);
    public Image img;
    public long timer = 0L;

    public Image2D(Vector3D pos2, Image img2, long timer2) {
        this.activable = true;
        this.singleUse = true;
        this.destroyOnUse = true;
        this.img = img2;
        this.timer = timer2;
        this.pos.set(pos2);
    }

    public final void destroy() {
    }

    public final void render(Graphics3D g3d, int x1, int y1, int x2, int y2) {
    }

    public final int getPosX() {
        return this.pos.x;
    }

    public final int getPosZ() {
        return this.pos.z;
    }

    public final int getPosY() {
        return this.pos.y;
    }

    public final void setPos(int x, int y, int z) {
        this.pos.set(x, y, z);
    }

    public void activate(House house, Player player, GameScreen gs) {
        if (this.lastActivate > 0L && this.lastActivate + this.timeToReset > System.currentTimeMillis()) {
            return;
        }
        if (!this.isAllCollected(Player.usedPoints, player, house, gs)) {
            if (this.errMessage != null) {
                this.errMsg(gs);
            }
            return;
        }
        if (this.sound != null && Main.isSounds && Main.sounds != 0) {
            Asset.getSound(this.sound).start(Main.sounds);
        }
        if (this.singleUse && this.contains(Player.usedPoints, this.name)) {
            if (this.destroyOnUse) {
                house.removeObject(this);
            }
            return;
        }
        if (!this.singleUse || !this.activated) {
            this.give(this.additional, player, house, gs);
        }
        if (!this.contains(Player.usedPoints, this.name)) {
            this.give(this.name, player);
            gs.overlay = this.img;
            gs.overlayTimeOut = this.timer;
            gs.overlayStart = System.currentTimeMillis();
            this.activated = true;
            if (this.lastActivate >= 0L) {
                this.lastActivate = System.currentTimeMillis();
            }
        }
        if (this.message != null) {
            this.prMsg(gs);
        }
        if (this.destroyOnUse) {
            house.removeObject(this);
        }
    }
}

