/*
 * Decompiled with CFR 0.152.
 */
package com.Gameplay.Objects;

import com.AI.Player;
import com.Gameplay.GameScreen;
import com.Gameplay.Map.House;
import com.Gameplay.Map.RoomObject;
import com.Rendering.Fps;
import com.Rendering.Graphics3D;
import com.Rendering.Meshes.Sprite;
import com.misc.Asset;
import com.misc.Main;

public final class SpriteObject
extends RoomObject {
    public Sprite spr = new Sprite(0);
    public int addsz = 2000;
    public boolean[] flicker = null;
    public int[] colorFlicker = null;
    private int intframe = 0;
    private static Fps fps;

    public final void destroy() {
        this.spr.destroy();
    }

    public final void render(Graphics3D g3d, int x1, int y1, int x2, int y2) {
        if (!this.visible) {
            return;
        }
        if (this.lastActivate > 0L && this.lastActivate + this.timeToReset > System.currentTimeMillis() && this.hideWhenUnusable) {
            return;
        }
        boolean draw = true;
        this.spr.updateFrame();
        this.spr.project(g3d.getInvCamera(), g3d);
        if (!this.spr.isVisible(x1, y1, x2, y2)) {
            return;
        }
        if (this.flicker != null) {
            draw = this.flicker[this.intframe / 125 % this.flicker.length];
        }
        if (this.colorFlicker != null) {
            this.spr.color = this.colorFlicker[this.intframe / 125 % this.colorFlicker.length];
        }
        this.intframe += 20000 / Fps.getFps();
        if (!draw) {
            return;
        }
        g3d.addRenderObject(this.spr, x1, y1, x2, y2);
        this.spr.sz += this.addsz;
    }

    public final int getPosX() {
        return this.spr.getPosition().x;
    }

    public final void setPos(int x, int y, int z) {
        this.spr.getPosition().set(x, y, z);
    }

    public final int getPosZ() {
        return this.spr.getPosition().z;
    }

    public final int getPosY() {
        return this.spr.getPosition().y;
    }

    public void activate(House house, Player player, GameScreen gs) {
        if (this.lastActivate > 0L && this.lastActivate + this.timeToReset > System.currentTimeMillis()) {
            return;
        }
        if (!this.isAllCollected(Player.usedPoints, player, house, gs)) {
            if (this.errMessage != null) {
                this.errMsg(gs);
            }
            return;
        }
        if (this.sound != null && Main.isSounds && Main.sounds != 0) {
            Asset.getSound(this.sound).start(Main.sounds);
        }
        if (this.singleUse && this.contains(Player.usedPoints, this.name)) {
            if (this.destroyOnUse) {
                house.removeObject(this);
            }
            return;
        }
        if (!this.singleUse || !this.activated) {
            this.give(this.additional, player, house, gs);
        }
        if (!this.contains(Player.usedPoints, this.name)) {
            this.give(this.name, player);
            this.activated = true;
            if (this.lastActivate >= 0L) {
                this.lastActivate = System.currentTimeMillis();
            }
        }
        if (this.message != null) {
            this.prMsg(gs);
        }
        if (this.destroyOnUse) {
            house.removeObject(this);
        }
    }
}

