/*
 * Decompiled with CFR 0.152.
 */
package com.Gameplay;

import com.AI.misc.Splinter;
import com.AI.misc.Trace;
import com.Collision.Ray;
import com.Gameplay.Arsenal;
import com.Gameplay.Magazine;
import com.Gameplay.Map.Character;
import com.Gameplay.Map.House;
import com.Gameplay.Objects.GameObject;
import com.Math.MathUtils;
import com.Math.Matrix;
import com.Math.Vector3D;
import com.Rendering.Fps;
import com.Rendering.Graphics3D;
import com.Rendering.Meshes.Polygon3V;
import com.Rendering.Meshes.Polygon4V;
import com.Rendering.RenderObject;
import com.misc.Asset;
import com.misc.Main;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class Weapon {
    private static Fps fps;
    private static Main main;
    private static final Splinter splinter;
    private static final Ray ray;
    private final short damageValue;
    private final short delay;
    private final short shotTime;
    private float frame = -1.0f;
    private String fileWeapon;
    private String fileFire;
    private float kW;
    private float kH;
    public boolean patronbuy = true;
    public Image imgWeapon;
    private Image imgFire;
    private long distance = 999999999L;
    public boolean meleeAnim = false;
    private short dx_fire = 1;
    private short dy_fire = 1;
    public short dx_max = 0;
    public short dy_max = 0;
    private short dx = 0;
    private short dy = 0;
    private short widthShift = (short)2;
    private short heightShift = (short)5;
    private boolean twoHands = false;
    private boolean shake = false;
    public boolean newanim = false;
    public Image sight;
    public Image sightWeapon;
    public String fileSight;
    public String fileSightWeapon;
    public Magazine magazine;
    public int minZoom;
    public int maxZoom;
    public boolean hasZoom;
    public String shoot = null;
    public String reload = null;
    public boolean canShoot = true;
    public boolean ignoreSightOnDraw = false;
    public float attackIntensity = 1.0f;
    public int weaponId = 1;
    public boolean customPos = false;
    public float customPosX = 1.0f;
    public boolean centreAlign = false;

    public Weapon(String fileWeapon2, String fileFire2, float kW2, float kH2, int damageValue2, int delay2, int shotTime2, boolean twoHands2, int capacity, int reloadTime, long distance2, boolean pb, int weaponId2) {
        this.distance = distance2;
        this.patronbuy = pb;
        this.fileWeapon = fileWeapon2;
        this.fileFire = fileFire2;
        this.kW = kW2;
        this.kH = kH2;
        this.damageValue = (short)damageValue2;
        this.delay = (short)delay2;
        this.shotTime = (short)shotTime2;
        this.twoHands = twoHands2;
        this.magazine = new Magazine(capacity, reloadTime);
        this.newanim = false;
        this.weaponId = weaponId2;
        this.minZoom = Main.minZoom;
        this.maxZoom = Main.maxZoom;
        this.hasZoom = Main.hasZoom;
    }

    public final void reset() {
        this.sightWeapon = null;
        this.sight = null;
        this.imgFire = null;
        this.imgWeapon = null;
    }

    public final void createSprite(int width_g3d, int height_g3d) {
        Image var7;
        Image[] var6 = this.createImages(this.fileWeapon, this.fileFire, width_g3d, height_g3d);
        Image var10001 = var6[0];
        Image var10002 = var6[1];
        float var5 = this.kH;
        float var4 = this.kW;
        Image var3 = var10002;
        this.imgWeapon = var7 = var10001;
        this.imgFire = var3;
        this.dx_fire = (short)((float)this.imgWeapon.getWidth() * var4);
        this.dy_fire = (short)((float)this.imgWeapon.getHeight() * var5);
        this.dx_max = (short)(this.imgWeapon.getWidth() / 5);
        this.dy_max = (short)(this.imgWeapon.getHeight() / 5);
        if (this.attackIntensity > 1.0f) {
            this.dx_max = (short)(this.imgWeapon.getWidth() / 2);
            this.dy_max = (short)(this.imgWeapon.getHeight() / 2);
        }
    }

    private Image[] createImages(String file1, String file2, int width, int height) {
        float var6 = (float)height / 256.0f;
        try {
            return new Image[]{Weapon.createImage(file1, var6, var6), Weapon.createImage(file2, var6, var6)};
        }
        catch (IOException var5) {
            return null;
        }
    }

    private void createSights(int width, int height) {
        float var6 = (float)height / 256.0f;
        try {
            if (this.sight == null && this.fileSight != null) {
                this.sight = Weapon.createImageInt(this.fileSight, width, height);
            }
            if (this.sightWeapon == null && this.fileSightWeapon != null) {
                this.sightWeapon = Weapon.createImage(this.fileSightWeapon, var6, var6);
            }
        }
        catch (IOException var5) {
            return;
        }
    }

    private static Image createImageInt(String file, int w2, int h2) throws IOException {
        if (file == null) {
            return null;
        }
        Image var3 = Image.createImage((String)file);
        return Arsenal.resize(var3, w2, h2);
    }

    private static Image createImage(String file, float scaleW, float scaleH) throws IOException {
        if (file == null) {
            return null;
        }
        Image var3 = Image.createImage((String)file);
        int var4 = (int)((float)var3.getWidth() * scaleW);
        int var5 = (int)((float)var3.getHeight() * scaleH);
        return var3.getWidth() == var4 && var3.getHeight() == var5 ? var3 : Arsenal.resize(var3, var4, var5);
    }

    private boolean isFire() {
        return this.frame >= 0.0f;
    }

    public short getDamageValue() {
        return this.damageValue;
    }

    public final void draw(Graphics g, int x, int y, int width, int height) {
        if (this.imgWeapon == null) {
            this.createSprite(width, height);
        }
        if (this.sight == null && this.fileSight != null || this.sightWeapon == null && this.fileSightWeapon != null) {
            this.createSights(width, height);
        }
        short dxb = this.dx;
        short dxmb = this.dx_max;
        if (this.meleeAnim) {
            this.dx = (short)(this.dx_max - this.dx);
            this.dy = (short)(this.dy_max - this.dy);
        }
        if (this.customPos) {
            x = (int)((float)(width - height * 240 / 256) * this.customPosX / 2.0f);
            width = (int)((float)(height * 240) * this.customPosX / 256.0f);
            this.dx = (short)((float)this.dx * this.customPosX);
            this.dx_max = (short)((float)this.dx_max * this.customPosX);
        } else {
            x = 0;
        }
        if (this.centreAlign) {
            x += this.imgWeapon.getWidth() / 2;
        }
        if (!this.newanim) {
            if (this.isFire() && this.imgFire != null) {
                g.drawImage(this.imgFire, width - this.dx_fire + this.dx + x, height - this.dy_fire + this.dy + y, 3);
            }
            g.drawImage(this.imgWeapon, width + this.dx + x, height + this.dy + y, 40);
            if (this.twoHands) {
                if (this.isFire() && this.imgFire != null) {
                    g.drawRegion(this.imgFire, 0, 0, this.imgFire.getWidth(), this.imgFire.getHeight(), 2, this.dx_fire - this.dx + x, height - this.dy_fire + this.dy + y, 3);
                }
                g.drawRegion(this.imgWeapon, 0, 0, this.imgWeapon.getWidth(), this.imgWeapon.getHeight(), 2, x - this.dx, height + this.dy + y, 36);
            }
        } else {
            if (this.isFire()) {
                if (this.imgFire != null) {
                    g.drawImage(this.imgFire, width + this.dx + x, height + this.dy + y, 40);
                }
            } else {
                g.drawImage(this.imgWeapon, width + this.dx + x, height + this.dy + y, 40);
            }
            if (this.twoHands) {
                if (this.isFire()) {
                    if (this.imgFire != null) {
                        g.drawRegion(this.imgFire, 0, 0, this.imgWeapon.getWidth(), this.imgWeapon.getHeight(), 2, x - this.dx, height + this.dy + y, 36);
                    }
                } else {
                    g.drawRegion(this.imgWeapon, 0, 0, this.imgWeapon.getWidth(), this.imgWeapon.getHeight(), 2, x - this.dx, height + this.dy + y, 36);
                }
            }
        }
        if (this.meleeAnim) {
            this.dy = (short)(this.dy_max - this.dy);
        }
        this.dx_max = dxmb;
        this.dx = dxb;
    }

    public final void drawSight(Graphics g, int x, int y, int width, int height) {
        if (this.ignoreSightOnDraw) {
            this.draw(g, x, y, width, height);
        }
        if (this.sight == null && this.fileSight != null || this.sightWeapon == null && this.fileSightWeapon != null) {
            this.createSights(width, height);
        }
        if (this.sight == null && this.sightWeapon == null) {
            return;
        }
        if (this.meleeAnim) {
            this.dx = (short)(this.dx_max - this.dx);
            this.dy = (short)(this.dy_max - this.dy);
        }
        if (this.sightWeapon != null) {
            if (!this.twoHands) {
                g.drawImage(this.sightWeapon, width / 2, height + y + this.dy, 33);
            } else {
                g.drawImage(this.sightWeapon, width / 2, height + y + this.dy, 36);
                g.drawRegion(this.sightWeapon, 0, 0, this.sightWeapon.getWidth(), this.sightWeapon.getHeight(), 2, width / 2, height + y + this.dy, 40);
            }
        }
        if (this.sight != null) {
            g.drawImage(this.sight, 0, y, 20);
        }
        if (this.meleeAnim) {
            this.dx = (short)(this.dx_max - this.dx);
            this.dy = (short)(this.dy_max - this.dy);
        }
    }

    public void renderSplinter(Graphics3D g3d) {
        splinter.project(g3d);
        if (splinter.isShatters() && (long)(-Weapon.splinter.sprite.sz / 4) < this.distance) {
            splinter.render(g3d, 1500);
        }
    }

    public final void enableShake() {
        this.shake = true;
    }

    public final int getRounds() {
        return this.magazine.getRounds();
    }

    public int getAmmo() {
        return this.magazine.getAmmo();
    }

    public void setAmmo(int number) {
        this.magazine.setAmmo(number);
        this.magazine.recount();
    }

    public final boolean isReloading() {
        return this.magazine.isReloading();
    }

    public final int reloadingPercentage() {
        return this.magazine.percentage();
    }

    public final GameObject update(House house, GameObject player) {
        boolean var3;
        if (this.canShoot) {
            this.magazine.update();
        }
        int anima = 350;
        if (this.attackIntensity > 1.0f) {
            anima = 600;
        }
        boolean bl = var3 = this.frame == 0.0f;
        if (this.isFire() && this.canShoot) {
            this.frame = (float)((double)this.frame + 200.0 / (double)Fps.getFps());
            if (this.frame > (float)this.shotTime) {
                this.frame = -this.delay;
            }
        }
        if (this.frame < -1.0f) {
            this.frame = (float)((double)this.frame + 600.0 / (double)Fps.getFps());
            if (this.frame > -1.0f) {
                this.frame = -1.0f;
            }
        }
        if (this.isFire() && this.canShoot) {
            this.dx = (short)((float)this.dx + (float)((Math.abs(this.widthShift) << 1) * anima / Fps.getFps()) * this.attackIntensity);
            this.dy = (short)((float)this.dy + (float)((Math.abs(this.heightShift) << 1) * anima / Fps.getFps()) * this.attackIntensity);
        }
        if (this.shake && this.frame >= -1.0f) {
            if (anima != 600) {
                this.dx = (short)(this.dx + (byte)(this.widthShift * anima / Fps.getFps()));
                this.dy = (short)(this.dy + (byte)(this.heightShift * anima / Fps.getFps()));
            }
            this.shake = false;
        } else {
            this.dx = (short)(this.dx + -this.dx * anima / Fps.getFps() / 6);
            this.dy = (short)(this.dy + -this.dy * anima / Fps.getFps() / 6);
        }
        if (this.dy <= 0) {
            this.dy = 0;
            this.heightShift = -this.heightShift;
        }
        if (this.dy > this.dy_max) {
            this.dy = this.dy_max;
            this.heightShift = -this.heightShift;
        }
        if (this.dx <= 0) {
            this.dx = 0;
            this.widthShift = -this.widthShift;
        }
        if (this.dx >= this.dx_max) {
            this.dx = this.dx_max;
            this.widthShift = -this.widthShift;
        }
        if (var3 && this.canShoot) {
            Matrix var30 = player.getCharacter().getTransform();
            ray.reset();
            Vector3D var4 = ray.getStart();
            Vector3D var5 = ray.getDir();
            var4.set(var30.m03, var30.m13 + player.getCharacter().getHeight(), var30.m23);
            var5.set(-var30.m02 << 1, -var30.m12 << 1, -var30.m22 << 1);
            ray.reset();
            house.rayCast(player.getPart(), ray);
            if (ray.isCollision()) {
                var5.setLength(ray.getDistance());
            }
            Vector3D var6 = var5;
            var5 = var4;
            GameObject var31 = player;
            Character pchar = player.getCharacter();
            GameObject var32 = null;
            long var17 = Integer.MAX_VALUE;
            Vector var27 = house.getObjects();
            Vector3D var7 = new Vector3D();
            for (int var8 = 0; var8 < var27.size(); ++var8) {
                long var10000;
                GameObject var9;
                if (!(var27.elementAt(var8) instanceof GameObject) || (var9 = (GameObject)var27.elementAt(var8)) == var31 || var9.isDead()) continue;
                Character var10 = var9.getCharacter();
                Matrix var11 = var10.getTransform();
                var7.set(var11.m03, var11.m13 + var10.getHeight(), var11.m23);
                int var34 = var10.getRadius();
                if (MathUtils.distanceToRay(var7, var5, var6) < var34 * var34) {
                    Vector3D var35 = var7;
                    int var12 = var35.x - var5.x;
                    int var13 = var35.y - var5.y;
                    int var36 = var35.z - var5.z;
                    var10000 = (long)var12 * (long)var12 + (long)var13 * (long)var13 + (long)var36 * (long)var36;
                } else {
                    var10000 = Integer.MAX_VALUE;
                }
                long var25 = var10000;
                if (var10000 >= var17) continue;
                var32 = var9;
                var17 = var25;
            }
            var3 = var32 != null;
            boolean var33 = false;
            if (var3 && var32.getCharacter().distance(pchar) < this.distance * this.distance) {
                var33 = var32.damage(player, this.damageValue);
            }
            if (ray.isCollision()) {
                Vector3D var29 = ray.getCollisionPoint();
                if (!var3) {
                    splinter.set(var29.x, var29.y, var29.z);
                }
                if (var3 && Main.blood) {
                    Trace trace = this.createTrace(var29, ray.getTriangle());
                    trace.setPart(ray.getNumRoom());
                    house.addObject(trace);
                }
            }
            if (var33) {
                return var32;
            }
            return null;
        }
        return null;
    }

    public final void fire() {
        if (!this.canShoot) {
            return;
        }
        if (!this.patronbuy) {
            this.magazine.addAmmo(1);
            this.magazine.takeRounds(-1);
            if (this.twoHands) {
                this.magazine.addAmmo(1);
                this.magazine.takeRounds(-1);
            }
        }
        if (this.frame == -1.0f) {
            if (this.magazine.getRounds() > 0) {
                this.frame = 0.0f;
                if (this.shoot != null && Main.isSounds && Main.sounds != 0) {
                    Asset.getSound(this.shoot).stopND();
                    Asset.getSound(this.shoot).start(Main.sounds);
                }
                if (!this.twoHands) {
                    this.magazine.takeRounds(1);
                    return;
                }
                this.magazine.takeRounds(2);
                return;
            }
            if (!this.magazine.isReloading()) {
                this.magazine.reload();
                if (this.reload != null && Main.isSounds && Main.sounds != 0) {
                    Asset.getSound(this.reload).stopND();
                    Asset.getSound(this.reload).start(Main.sounds);
                }
            }
        }
    }

    public final boolean isTwoHands() {
        return this.twoHands;
    }

    public final void addAmmo(int number) {
        this.magazine.addAmmo(100);
    }

    public Trace createTrace(Vector3D vector3f, RenderObject meshr) {
        int minx = 0;
        int miny = 0;
        int minz = 0;
        int maxx = 0;
        int maxy = 0;
        int maxz = 0;
        int posx = 0;
        int posy = 0;
        int posz = 0;
        Vector3D v1 = new Vector3D(0, 0, 0);
        Vector3D v2 = new Vector3D(0, 0, 0);
        Vector3D v3 = new Vector3D(0, 0, 0);
        Vector3D v4 = new Vector3D(0, 0, 0);
        if (meshr instanceof Polygon4V) {
            Polygon4V p4v = (Polygon4V)meshr;
            posx = (p4v.a.x + p4v.b.x + p4v.c.x + p4v.d.x) / 4;
            posy = (p4v.a.y + p4v.b.y + p4v.c.y + p4v.d.y) / 4;
            posz = (p4v.a.z + p4v.b.z + p4v.c.z + p4v.d.z) / 4;
            minx = Math.min(Math.min(Math.min(p4v.a.x, p4v.b.x), p4v.c.x), p4v.d.x) - posx;
            miny = Math.min(Math.min(Math.min(p4v.a.y, p4v.b.y), p4v.c.y), p4v.d.y) - posy;
            minz = Math.min(Math.min(Math.min(p4v.a.z, p4v.b.z), p4v.c.z), p4v.d.z) - posz;
            maxx = Math.max(Math.max(Math.max(p4v.a.x, p4v.b.x), p4v.c.x), p4v.d.x) - posx;
            maxy = Math.max(Math.max(Math.max(p4v.a.y, p4v.b.y), p4v.c.y), p4v.d.y) - posy;
            maxz = Math.max(Math.max(Math.max(p4v.a.z, p4v.b.z), p4v.c.z), p4v.d.z) - posz;
            v1.set(p4v.a.x - posx, p4v.a.y - posy, p4v.a.z - posz);
            v2.set(p4v.b.x - posx, p4v.b.y - posy, p4v.b.z - posz);
            v3.set(p4v.c.x - posx, p4v.c.y - posy, p4v.c.z - posz);
            v4.set(p4v.d.x - posx, p4v.d.y - posy, p4v.d.z - posz);
        }
        if (meshr instanceof Polygon3V) {
            Polygon3V p3v = (Polygon3V)meshr;
            posx = (p3v.a.x + p3v.b.x + p3v.c.x) / 3;
            posy = (p3v.a.y + p3v.b.y + p3v.c.y) / 3;
            posz = (p3v.a.z + p3v.b.z + p3v.c.z) / 3;
            minx = Math.min(Math.min(p3v.a.x, p3v.b.x), p3v.c.x) - posx;
            miny = Math.min(Math.min(p3v.a.y, p3v.b.y), p3v.c.y) - posy;
            minz = Math.min(Math.min(p3v.a.z, p3v.b.z), p3v.c.z) - posz;
            maxx = Math.max(Math.max(p3v.a.x, p3v.b.x), p3v.c.x) - posx;
            maxy = Math.max(Math.max(p3v.a.y, p3v.b.y), p3v.c.y) - posy;
            maxz = Math.max(Math.max(p3v.a.z, p3v.b.z), p3v.c.z) - posz;
            v1.set(p3v.a.x - posx, p3v.a.y - posy, p3v.a.z - posz);
            v2.set(p3v.b.x - posx, p3v.b.y - posy, p3v.b.z - posz);
            v3.set(p3v.c.x - posx, p3v.c.y - posy, p3v.c.z - posz);
            v4.set(p3v.c.x - posx, p3v.c.y - posy, p3v.c.z - posz);
        }
        return new Trace(vector3f.x, vector3f.y, vector3f.z, v1, v2, v3, v4, new Vector3D(Math.abs(minx) + Math.abs(maxx), Math.abs(miny) + Math.abs(maxy), Math.abs(minz) + Math.abs(maxz)));
    }

    static {
        splinter = new Splinter();
        ray = new Ray();
    }
}

